package com.mcsnowflake.worktimer.ui.views.dashboard

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.derivedStateOf
import androidx.compose.runtime.getValue
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.mcsnowflake.worktimer.TextHandler
import com.mcsnowflake.worktimer.state.SessionData
import com.mcsnowflake.worktimer.state.TimerState
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow

@Preview
@Composable
fun Header(
    modifier: Modifier = Modifier,
    state: StateFlow<TimerState> = MutableStateFlow(TimerState.Stopped).asStateFlow(),
) = Box(
    modifier
        .fillMaxWidth()
        .height(100.dp),
    Alignment.Center
) {
    val timerState by state.collectAsState()
    val primaryColor = MaterialTheme.colorScheme.primary
    val tertiaryColor = MaterialTheme.colorScheme.tertiary
    val titleResId by remember { derivedStateOf { TextHandler.getTitle(timerState) } }

    val color = remember {
        derivedStateOf {
            when (val state = timerState) {
                is TimerState.Session -> when (state.session.type) {
                    SessionData.Type.WORK_SESSION -> primaryColor
                    SessionData.Type.SHORT_BREAK, SessionData.Type.LONG_BREAK -> tertiaryColor
                }

                is TimerState.Stopped -> primaryColor
            }
        }
    }
    Text(
        text = stringResource(titleResId),
        fontSize = 30.sp,
        color = color.value
    )
}
