package com.mcsnowflake.worktimer.ui.views.about.content

import androidx.compose.foundation.border
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.rounded.Timer
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.contentColorFor
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalUriHandler
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.LinkAnnotation
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.TextLinkStyles
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.text.withLink
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.ui.views.about.Header
import com.mcsnowflake.worktimer.ui.views.about.Scrollable

@Composable
fun ColumnScope.Pomodoro(
    headerWeight: Float,
    textWeight: Float
) {
    Header(
        stringResource(id = R.string.pomodoro_technique_title),
        Icons.Rounded.Timer,
        Modifier.weight(headerWeight)
            .border(1.dp, Color.Red)
    )

    Scrollable(textWeight) {
        Text(stringResource(id = R.string.pomodoro_explanation_1))
        Text(stringResource(id = R.string.pomodoro_explanation_2))
        Text(stringResource(id = R.string.pomodoro_explanation_3))
        Text(stringResource(id = R.string.pomodoro_explanation_4))
        Text(stringResource(id = R.string.pomodoro_explanation_5))
        val uriHandler = LocalUriHandler.current
        val linkStyle = SpanStyle(
            fontSize = 12.sp,
            color = MaterialTheme.colorScheme.tertiary,
            textDecoration = TextDecoration.Underline
        )
        val textStyle = SpanStyle(
            fontSize = 12.sp,
            color = if (isSystemInDarkTheme()) Color.White
            else contentColorFor(MaterialTheme.colorScheme.background)
        )
        val link =
            LinkAnnotation.Url(
                "https://en.wikipedia.org/wiki/Pomodoro_Technique",
                TextLinkStyles(linkStyle),
            ) {
                val url = (it as LinkAnnotation.Url).url
                uriHandler.openUri(url)
            }
        val annotatedString1 = buildAnnotatedString {
            withStyle(textStyle) { append(stringResource(id = R.string.pomodoro_excerpt_from)) }
            withLink(link) { append(stringResource(id = R.string.pomodoro_wikipedia_article)) }
        }

        Text(
            text = annotatedString1,
            modifier = Modifier.fillMaxWidth(),
            style = TextStyle(fontSize = 12.sp, textAlign = TextAlign.Center),
        )
    }
}
