package com.mcsnowflake.worktimer.ui.views.about.content

import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.rounded.AutoAwesome
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.ui.views.about.Header
import com.mcsnowflake.worktimer.ui.views.about.Scrollable

@Composable
fun ColumnScope.Features(
    headerWeight: Float,
    textWeight: Float
) {

    Header(
        stringResource(id = R.string.features_header),
        Icons.Rounded.AutoAwesome,
        Modifier.weight(headerWeight)
    )

    Scrollable(textWeight) {
        Text(stringResource(id = R.string.features_explanation))
        HorizontalDivider(Modifier.fillMaxWidth(0.6f))
        Text(stringResource(id = R.string.auto_switching_explanation))
        Text(stringResource(id = R.string.session_prolonging_explanation))
        Text(stringResource(id = R.string.do_not_disturb_explanation))
        Text(stringResource(id = R.string.hydration_reminder_explanation))
        Text(stringResource(id = R.string.keep_screen_on_explanation))

    }
}
