package com.mcsnowflake.worktimer.ui.components.buttons

import androidx.compose.foundation.layout.width
import androidx.compose.material3.Button
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.State
import androidx.compose.runtime.derivedStateOf
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.notifications.NotificationAction
import com.mcsnowflake.worktimer.ui.theme.Theme

@Composable
fun StartStopButton(
    modifier: Modifier = Modifier,
    isTimerRunning: Boolean,
    onClick: () -> Unit,
    enabled: State<Boolean>
) {
    val label by remember(isTimerRunning) {
        derivedStateOf {
            if (isTimerRunning) NotificationAction.STOP.getActionTitle()
            else NotificationAction.START.getActionTitle()
        }
    }

    val startColors = ButtonDefaults.buttonColors(
        contentColor = MaterialTheme.colorScheme.onPrimary,
        containerColor = MaterialTheme.colorScheme.primary
    )

    val stopColors = ButtonDefaults.buttonColors(
        contentColor = MaterialTheme.colorScheme.inverseSurface,
        containerColor = MaterialTheme.colorScheme.inversePrimary
    )

    val colors by remember(isTimerRunning) {
        derivedStateOf {
            if (isTimerRunning) stopColors
            else startColors
        }
    }

    Button(
        onClick = onClick,
        modifier = modifier.width(200.dp),
        colors = colors,
        enabled = enabled.value
    ) {
        Text(
            text = stringResource(id = label),
        )
    }
}

@Preview
@Composable
fun StartStopButtonRunningPreview() = Theme {
    StartStopButton(
        isTimerRunning = true,
        onClick = {},
        enabled = remember { mutableStateOf(true) }
    )
}

@Preview
@Composable
fun StartStopButtonStoppedPreview() = Theme {
    StartStopButton(
        isTimerRunning = false,
        onClick = {},
        enabled = remember { mutableStateOf(true) }
    )
}

@Preview(
    showBackground = true,
)
@Composable
fun StartStopButtonDisabledPreview() = Theme {
    StartStopButton(
        isTimerRunning = false,
        onClick = {},
        enabled = remember { mutableStateOf(false) }
    )
}


