package com.mcsnowflake.worktimer.notifications

import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.state.TimerEvent

enum class NotificationAction(val event: TimerEvent) {
    PAUSE(TimerEvent.NEXT),
    WORK(TimerEvent.NEXT),
    RESUME(TimerEvent.NEXT),
    STOP(TimerEvent.STOP),
    MORE(TimerEvent.MORE),
    START(TimerEvent.START);

    @StringRes
    fun getActionTitle(): Int = when (this) {
        PAUSE -> R.string.pause_button_label
        WORK -> R.string.work_button_label
        RESUME -> R.string.next_button_label
        STOP -> R.string.stop_button_label
        MORE -> R.string.more_button_label
        START -> R.string.start_button_label
    }

    @DrawableRes
    fun getActionIcon(): Int = when (this) {
        PAUSE -> R.drawable.baseline_check_circle_outline_24
        WORK -> R.drawable.baseline_check_circle_outline_24
        RESUME -> R.drawable.baseline_highlight_off_24
        STOP -> R.drawable.baseline_history_24
        MORE -> R.drawable.baseline_history_24
        START -> R.drawable.baseline_check_circle_outline_24
    }
}
