@file:OptIn(ExperimentalTime::class)

package com.mcsnowflake.worktimer

import com.mcsnowflake.worktimer.state.SessionData
import com.mcsnowflake.worktimer.state.SessionData.Type.LONG_BREAK
import com.mcsnowflake.worktimer.state.SessionData.Type.SHORT_BREAK
import com.mcsnowflake.worktimer.state.SessionData.Type.WORK_SESSION
import com.mcsnowflake.worktimer.state.TimerState
import com.mcsnowflake.worktimer.state.TimerState.Session
import com.mcsnowflake.worktimer.state.TimerState.Session.Finished
import kotlin.time.ExperimentalTime

object TextHandler {

    fun getTitle(state: TimerState): Int = when (state) {
        is Session.Running -> when (state.session.type) {
            WORK_SESSION -> R.string.work_session_ongoing
            SHORT_BREAK, LONG_BREAK -> R.string.relax_time
        }

        is Finished -> when (state.session.type) {
            WORK_SESSION -> R.string.work_session_over
            SHORT_BREAK, LONG_BREAK -> R.string.break_is_over
        }

        is TimerState.Stopped -> R.string.welcome_text
    }

    fun getInfoText(session: SessionData.Type): Int = when (session) {
        WORK_SESSION -> R.string.time_for_a_break
        SHORT_BREAK, LONG_BREAK -> R.string.get_ready_to_rock
    }
}
