package com.mcsnowflake.worktimer.ui.views.settings

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.rounded.Redo
import androidx.compose.material.icons.rounded.ColorLens
import androidx.compose.material.icons.rounded.DoNotDisturb
import androidx.compose.material.icons.rounded.MoreTime
import androidx.compose.material.icons.rounded.Notifications
import androidx.compose.material.icons.rounded.QueryStats
import androidx.compose.material.icons.rounded.WaterDrop
import androidx.compose.material.icons.rounded.WbSunny
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.configuration.Preference

data class SettingsCardData(
    val icon: ImageVector, val label: Int, val onText: Int, val offText: Int
) {
    companion object {

        val SettingsCardHeight = 80.dp
        val expandedSettingsCardHeight = 144.dp

        operator fun get(preference: Preference): SettingsCardData = when (preference) {
            Preference.AUTO_SWITCH_MODE -> SettingsCardData(
                icon = Icons.AutoMirrored.Rounded.Redo,
                label = R.string.settings_auto_switch_label,
                onText = R.string.settings_auto_switch_on,
                offText = R.string.settings_auto_switch_off
            )

            Preference.OVERTIME_MODE -> SettingsCardData(
                icon = Icons.Rounded.MoreTime,
                label = R.string.settings_overtime_label,
                onText = R.string.settings_overtime_on,
                offText = R.string.settings_overtime_off,
            )

            Preference.DND_MODE -> SettingsCardData(
                icon = Icons.Rounded.DoNotDisturb,
                label = R.string.settings_dnd_label,
                onText = R.string.settings_dnd_on,
                offText = R.string.settings_dnd_off,
            )

            Preference.NOTIFICATIONS_ON -> SettingsCardData(
                icon = Icons.Rounded.Notifications,
                label = R.string.settings_notifications_label,
                onText = R.string.settings_notifications_on,
                offText = R.string.settings_notifications_off,
            )

            Preference.HYDRATION_MODE -> SettingsCardData(
                icon = Icons.Rounded.WaterDrop,
                label = R.string.settings_hydration_label,
                onText = R.string.settings_hydration_on,
                offText = R.string.settings_hydration_off,
            )

            Preference.STATISTICS_ON -> SettingsCardData(
                icon = Icons.Rounded.QueryStats,
                label = R.string.settings_statistics_label,
                onText = R.string.settings_statistics_on,
                offText = R.string.settings_statistics_off,
            )

            Preference.KEEP_SCREEN_ON -> SettingsCardData(
                icon = Icons.Rounded.WbSunny,
                label = R.string.settings_keep_screen_on_label,
                onText = R.string.settings_keep_screen_on_on,
                offText = R.string.settings_keep_screen_on_off,
            )

            Preference.DYNAMIC_COLOR_ON -> SettingsCardData(
                icon = Icons.Rounded.ColorLens,
                label = R.string.settings_dynamic_color_label,
                onText = R.string.settings_dynamic_color_on,
                offText = R.string.settings_dynamic_color_off,
            )

        }
    }
}
