package com.mcsnowflake.worktimer.ui.views.about

import androidx.annotation.StringRes
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.rounded.AutoAwesome
import androidx.compose.material.icons.rounded.Settings
import androidx.compose.material.icons.rounded.Timer
import androidx.compose.ui.graphics.vector.ImageVector
import com.mcsnowflake.worktimer.R

enum class Page(
    val icon: ImageVector?,
    @StringRes val nextPageLabel: Int
) {
    GREETER(null, R.string.about_next_page_learn_more),
    POMODORO(Icons.Rounded.Timer, R.string.about_next_page_how_to_use),
    MANUAL(Icons.Rounded.Settings, R.string.about_next_page_additional_features),
    FEATURES(Icons.Rounded.AutoAwesome, 0);

    fun next(): Page {
        val nextPageOrdinal = ordinal + 1
        return if (nextPageOrdinal == entries.size) {
            entries[0]
        } else {
            entries[nextPageOrdinal]
        }
    }

    val isNotLastPage: Boolean get() = this.ordinal < entries.size - 1
}
