package com.mcsnowflake.worktimer.ui.dialogs

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.ui.platform.LocalUriHandler
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R

@Preview(locale = "de")
@Preview(locale = "es")
@Preview(locale = "fr")
@Preview
@Composable
fun BugReportDialog(
    showDialog: MutableState<Boolean> = mutableStateOf(true)
) {
    if (showDialog.value) {
        val uriHandler = LocalUriHandler.current
        AlertDialog(
            title = {
                Text(stringResource(id = R.string.bug_report_title))
            },
            text = {
                Column(
                    verticalArrangement = Arrangement.spacedBy(8.dp)
                ) {
                    Text(
                        buildAnnotatedString {
                            append(stringResource(id = R.string.bug_report_description_part1))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.bug_report_description_gitlab))
                            }
                            append(stringResource(id = R.string.bug_report_description_part2))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.bug_report_description_registered))
                            }
                            append(stringResource(id = R.string.bug_report_description_part3))
                        }
                    )
                    Text(stringResource(id = R.string.bug_report_check_existing))
                }

            },
            onDismissRequest = { showDialog.value = false },
            dismissButton = {
                Button(
                    onClick = { showDialog.value = false },
                ) {
                    Text(stringResource(id = R.string.bug_report_decline))
                }
            },
            confirmButton = {
                Button(
                    onClick = {
                        showDialog.value = false
                        uriHandler.openUri("https://gitlab.com/McSnowflake/worktimer/-/issues")
                    },
                ) {
                    Text(stringResource(id = android.R.string.ok))
                }
            },
        )
    }
}
