package com.mcsnowflake.worktimer.ui.components.timer

import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.OutlinedTextFieldDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.State
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.input.KeyboardType
import androidx.compose.ui.text.input.VisualTransformation
import androidx.compose.ui.text.style.TextAlign

@Composable
fun NumberInput(
    value: State<String>,
    onValueChange: (value: String) -> Unit,
    modifier: Modifier = Modifier.Companion,
    label: @Composable () -> Unit,
    visualTransformation: VisualTransformation,
    accentColor: Color
) = OutlinedTextField(
    value = value.value,
    onValueChange = onValueChange,
    modifier = modifier,
    keyboardOptions = KeyboardOptions.Default.copy(keyboardType = KeyboardType.Number),
    label = label,
    visualTransformation = visualTransformation,
    colors = OutlinedTextFieldDefaults.colors(
        focusedBorderColor = accentColor,
        unfocusedBorderColor = accentColor.copy(alpha = 0.8f),
        cursorColor = accentColor,
        focusedLabelColor = accentColor.copy(alpha = 0.8f),
    ),
    textStyle = LocalTextStyle.current.copy(textAlign = TextAlign.Center)
)
