package com.mcsnowflake.worktimer.ui.components.banners

import android.app.NotificationManager
import android.media.AudioManager
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.rounded.VolumeOff
import androidx.compose.material3.Icon
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import com.mcsnowflake.worktimer.R
import com.mcsnowflake.worktimer.state.TimerState
import com.mcsnowflake.worktimer.ui.dialogs.DndPermissionDialogViewState
import org.koin.compose.koinInject

@Preview
@Composable
fun MuteBanner(
    audioManager: AudioManager = koinInject(),
    notificationManager: NotificationManager = koinInject(),
    bannersViewModel: BannersViewModel = koinInject(),
    dndPermissionDialogViewState: DndPermissionDialogViewState = koinInject()
) {

    //TODO check if mute warning makes sense and workes correctly
    val reevaluate by bannersViewModel.getReevaluateBanners()
    val state by bannersViewModel.timerState.collectAsState()
    var showMuteBanner by remember { mutableStateOf(false) }

    LaunchedEffect(audioManager.ringerMode, reevaluate) {
         showMuteBanner = audioManager.ringerMode != AudioManager.RINGER_MODE_NORMAL && notificationManager.areNotificationsEnabled()
    }


    AnimatedBanner(
        isVisible = showMuteBanner && state is TimerState.Stopped,
        icon = { Icon(Icons.AutoMirrored.Rounded.VolumeOff, stringResource(id = R.string.mute_banner_icon_description)) },
        text = stringResource(id = R.string.mute_banner_text),
        actions = mapOf(stringResource(id = R.string.mute_banner_action_unmute) to {
            if (!notificationManager.isNotificationPolicyAccessGranted) {
                dndPermissionDialogViewState.show()
            } else {
                audioManager.ringerMode = AudioManager.RINGER_MODE_NORMAL
                bannersViewModel.setReevaluateBanners()
            }
        })
    )
}
