@file:OptIn(ExperimentalTime::class)

package com.mcsnowflake.worktimer.state

import kotlin.time.Duration
import kotlin.time.ExperimentalTime
import kotlin.time.Instant
import kotlinx.serialization.Serializable

@Serializable
data class SessionData(
    val type: Type,
    @Serializable(with = InstantSerializer::class)
    val start: Instant,
    @Serializable(with = InstantSerializer::class)
    val end: Instant,
    val repetition: Int
) {

    val duration = end - start

    @Serializable
    enum class Type {
        WORK_SESSION,
        SHORT_BREAK,
        LONG_BREAK;
    }

    fun prolongedBy(duration: Duration) = copy(end = end + duration)

    companion object {
        fun newSession(start: Instant, end: Instant) = SessionData(Type.WORK_SESSION, start, end, 0)
    }
}
