package com.mcsnowflake.worktimer.configuration

import androidx.datastore.preferences.core.Preferences
import androidx.datastore.preferences.core.intPreferencesKey

enum class TimerInput(
    override val key: Preferences.Key<Int>,
    override val default: Int
) : Configuration<Int> {
    WORK_SESSION_DURATION(intPreferencesKey("work_session_duration"), 25),
    SHORT_BREAK_REPETITIONS(intPreferencesKey("short_break_repetitions"), 3),
    SHORT_BREAK_DURATION(intPreferencesKey("short_break_duration"), 5),
    LONG_BREAK_DURATION(intPreferencesKey("long_break_duration"), 10),
    OVERTIME_DURATION(intPreferencesKey("overtime_duration"), 5),
    HYDRATION_REMINDER_INTERVAL(intPreferencesKey("hydration_reminder_interval"), 5)
}
