package com.mcsnowflake.worktimer.ui.views.settings

import android.app.NotificationManager
import android.os.Build
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.imePadding
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.FocusRequester
import androidx.compose.ui.focus.focusRequester
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.configuration.Preference
import com.mcsnowflake.worktimer.configuration.TimerInput
import com.mcsnowflake.worktimer.ui.components.appbar.SimpleAppBar
import com.mcsnowflake.worktimer.ui.dialogs.DndPermissionDialogViewState
import org.koin.androidx.compose.koinViewModel
import org.koin.compose.koinInject

const val PREFERENCES_SCREEN = "Preferences"

@Preview
@Composable
fun Settings(
    navigateBack: () -> Unit = {},
    viewModel: SettingsViewModel = koinViewModel(),
    notificationManager: NotificationManager = koinInject(),
    dndPermissionDialogViewState: DndPermissionDialogViewState = koinInject()
) = Scaffold(
    modifier = Modifier.imePadding(),
    topBar = { SimpleAppBar("Settings", navigateBack) },
    containerColor = MaterialTheme.colorScheme.background,
) { innerPadding ->
    val scrollState = rememberScrollState()
    val focusRequester = remember { FocusRequester() }

    Column(
        modifier = Modifier
            .imePadding()
            .padding(innerPadding)
            .verticalScroll(scrollState),
        horizontalAlignment = Alignment.CenterHorizontally,
        verticalArrangement = Arrangement.spacedBy(2.dp)
    ) {

        SimpleSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.AUTO_SWITCH_MODE)
        ExtendedSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.OVERTIME_MODE, TimerInput.OVERTIME_DURATION)
        SimpleSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.DND_MODE) {
            when {
                it && !notificationManager.isNotificationPolicyAccessGranted -> dndPermissionDialogViewState.show()
                else -> viewModel[Preference.DND_MODE] = it
            }
        }
        NotificationsSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.NOTIFICATIONS_ON, notificationManager::areNotificationsEnabled)
        NotificationsSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.HYDRATION_MODE, notificationManager::areNotificationsEnabled)
        SimpleSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.KEEP_SCREEN_ON)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S)
            SimpleSettingsCard(Modifier.focusRequester(focusRequester), viewModel, Preference.DYNAMIC_COLOR_ON)

        HorizontalDivider()
        LaunchedEffect(Unit) {
            focusRequester.requestFocus()
            scrollState.animateScrollTo(scrollState.maxValue)
        }
    }
}
