package com.mcsnowflake.worktimer.ui.dialogs

import android.util.Log
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.runtime.getValue
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.mcsnowflake.worktimer.R
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.asStateFlow
import org.koin.compose.koinInject

@Preview(locale = "de")
@Preview(locale = "es")
@Preview(locale = "fr")
@Preview
@Composable
private fun LateAlarmsDialogInternal(
    isVisible: Boolean = true,
    onDismiss: () -> Unit = {}
) {
    if (isVisible) {
        AlertDialog(
            onDismissRequest = onDismiss,
            confirmButton = {
                Button(onDismiss) { Text(stringResource(id = R.string.next_button_label)) }
            },
            title = { Text(stringResource(id = R.string.late_alarms_dialog_title)) },
            text = {
                Column(verticalArrangement = Arrangement.spacedBy(8.dp)) {
                    Text(stringResource(id = R.string.late_alarms_dialog_description1))
                    Text(stringResource(id = R.string.late_alarms_dialog_description2))
                    Text(
                        buildAnnotatedString {
                            append(stringResource(id = R.string.late_alarms_dialog_step1_start))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.late_alarms_dialog_step1_bold))
                            }
                        }
                    )
                    Text(
                        buildAnnotatedString {
                            append(stringResource(id = R.string.late_alarms_dialog_step2_start))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.late_alarms_dialog_step2_bold1))
                            }
                            append(stringResource(id = R.string.late_alarms_dialog_step2_conjunction))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.late_alarms_dialog_step2_bold2))
                            }
                        }
                    )
                    Text(
                        buildAnnotatedString {
                            append(stringResource(id = R.string.late_alarms_dialog_step3_start))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.late_alarms_dialog_step3_bold1))
                            }
                            append(stringResource(id = R.string.late_alarms_dialog_step3_conjunction1))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.late_alarms_dialog_step3_bold2))
                            }
                            append(stringResource(id = R.string.late_alarms_dialog_step3_conjunction2))
                            withStyle(style = SpanStyle(fontWeight = FontWeight.Bold)) {
                                append(stringResource(id = R.string.late_alarms_dialog_step3_bold3))
                            }
                        }
                    )
                    Text(stringResource(id = R.string.late_alarms_dialog_step4))
                }
            }

        )
    }
}

@Composable
fun LateAlarmsDialog(viewState: LateAlarmsDialogViewState = koinInject()) {
    val isVisible by viewState.isVisible.collectAsState(false)

    LateAlarmsDialogInternal(isVisible, onDismiss = viewState::dismiss)
}

class LateAlarmsDialogViewState {
    private val _isVisible = MutableStateFlow(false)
    val isVisible: StateFlow<Boolean> = _isVisible.asStateFlow()

    fun show() {
        Log.d("DndPermissionDialogViewModel", "should show")
        _isVisible.value = true
    }

    fun dismiss() {
        Log.d("DndPermissionDialogViewModel", "should not show")
        _isVisible.value = false
    }
}

