package com.mcsnowflake.worktimer.ui.components.banners

import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mcsnowflake.worktimer.configuration.ConfigurationStore
import com.mcsnowflake.worktimer.configuration.LateAlarmStatus
import com.mcsnowflake.worktimer.configuration.Preference
import com.mcsnowflake.worktimer.configuration.StateStore
import com.mcsnowflake.worktimer.configuration.StateStore.Companion.LATE_ALARMS
import com.mcsnowflake.worktimer.state.TimerState
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch

class BannersViewModel(
    val configuration: ConfigurationStore,
    val stateStore: StateStore,
    val timerState: StateFlow<TimerState>
) : ViewModel() {

    private val reevaluateBanners = MutableStateFlow(0)

    @Composable
    fun getReevaluateBanners() = reevaluateBanners.collectAsState(viewModelScope)

    fun setReevaluateBanners() = viewModelScope.launch { reevaluateBanners.emit(reevaluateBanners.value + 1) }

    fun setLateAlarmsDismissed() = viewModelScope.launch {
        stateStore[LATE_ALARMS] = LateAlarmStatus.LATE_ALARMS_DISMISSED.name
    }

    fun getLateAlarmsStatus() = stateStore.getAsFlow(LATE_ALARMS)
    operator fun set(preference: Preference, value: Boolean) = viewModelScope.launch { configuration[preference] = value }
    operator fun get(preference: Preference) = configuration.getAsStateFlow(preference, viewModelScope)
}
