package com.mcsnowflake.worktimer.ui.components.banners

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.expandVertically
import androidx.compose.animation.shrinkVertically
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.rounded.WaterDrop
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp

@Preview
@Composable
fun AnimatedBanner(
    isVisible: Boolean = false,
    color: Color = MaterialTheme.colorScheme.surfaceContainer,
    icon: @Composable () -> Unit = { Icon(Icons.Rounded.WaterDrop, "test") },
    text: String = "Prervie",
    actions: Map<String, () -> Unit> = mapOf("ACTION" to {})
) = AnimatedVisibility(
    visible = isVisible,
    enter = expandVertically(),
    exit = shrinkVertically()
) {
    Surface(color = color) {
        Row(
            modifier = Modifier
                .fillMaxWidth()
                .padding(
                    top = 10.dp,
                    bottom = 8.dp,
                    start = 16.dp,
                    end = 8.dp
                ),
            horizontalArrangement = Arrangement.spacedBy(16.dp),
            verticalAlignment = Alignment.CenterVertically
        ) {
            icon()
            Text(text, Modifier.weight(1f))
            Actions(actions)
        }
    }
}

@Composable
private fun Action(label: String, action: () -> Unit) =
    TextButton(onClick = action) {
        Text(
            text = label,
            fontWeight = FontWeight.Bold,
            color = MaterialTheme.colorScheme.secondary
        )
    }

@Composable
private fun Actions(actions: Map<String, () -> Unit>) =
    Column(
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.End
    ) {
        actions.forEach { (label, action) ->
            Action(label, action)
        }
    }
