package com.mcsnowflake.worktimer.configuration

import androidx.datastore.core.DataStore
import androidx.datastore.preferences.core.Preferences
import androidx.datastore.preferences.core.booleanPreferencesKey
import androidx.datastore.preferences.core.byteArrayPreferencesKey
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import kotlinx.coroutines.flow.distinctUntilChanged
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.flow.map

class StateStore(
    private val dataStore: DataStore<Preferences>,
) {

    suspend operator fun <P> get(key: Preferences.Key<P>): P? = getAsFlow(key).first()
    suspend operator fun <P> set(key: Preferences.Key<P>, value: P) = dataStore.edit { it[key] = value }
    fun <P> getAsFlow(key: Preferences.Key<P>) = dataStore.data.map { it[key] }.distinctUntilChanged()

    companion object {
        val VERSION = stringPreferencesKey("VERSION")
        val FIRST_START = booleanPreferencesKey("FIRST_START")
        val LATE_ALARMS = stringPreferencesKey("late_alarms")
        val TIMER_STATE = byteArrayPreferencesKey("timer_state")
    }
}
