// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Прості, локальні, нотатки в стилі Material Design';

  @override
  String app_about(String appName) {
    return '$appName — це текстовий додаток для створення нотаток, орієнтований на простоту. Він використовує Material Design. Нотатки зберігаються локально та не мають дозволів на доступ до Інтернету, тому доступ до них маєте лише ви.';
  }

  @override
  String get error_snack_bar => 'Помилка:';

  @override
  String get error_widget_title => 'Виникла помилка.';

  @override
  String get error_widget_description =>
      'Будь ласка, повідомте про цю проблему на GitHub або поштою. Додайте нижче скриншот цієї сторінки та лог-файли, які можна скопіювати або експортувати. Як запобіжний захід, також слід експортувати свої нотатки.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Налаштування позначення програми як безпечної вимкнено до наступного перезавантаження, щоб увімкнути знімки екрана.';

  @override
  String get error_widget_button_export_notes => 'Експорт нотаток';

  @override
  String get error_widget_button_copy_logs => 'Копіювання лог-файлів';

  @override
  String get error_widget_button_export_logs => 'Експорт лог-файлів';

  @override
  String get error_widget_button_create_github_issue => 'Створити запис у GitHub';

  @override
  String get error_widget_button_send_mail => 'Надіслати пошту';

  @override
  String get navigation_notes => 'Нотатки';

  @override
  String get navigation_manage_labels_destination => 'Керування тегами';

  @override
  String get navigation_manage_labels_page => 'Теги';

  @override
  String get navigation_archives => 'Архів';

  @override
  String get navigation_bin => 'Кошик';

  @override
  String get navigation_settings => 'Налаштування';

  @override
  String get navigation_settings_appearance => 'Вигляд';

  @override
  String get navigation_settings_notes_types => 'Типи нотаток';

  @override
  String get navigation_settings_notes_tiles => 'Плити нотаток';

  @override
  String get navigation_settings_behavior => 'Поведінка';

  @override
  String get navigation_settings_editor => 'Редактор';

  @override
  String get navigation_settings_labels => 'Теги';

  @override
  String get navigation_settings_backup => 'Резервні копії';

  @override
  String get navigation_settings_security => 'Безпека';

  @override
  String get navigation_settings_accessibility => 'Доступність';

  @override
  String get navigation_settings_help => 'Допомога';

  @override
  String get navigation_settings_about => 'Про додаток';

  @override
  String get button_sort_title => 'Заголовок';

  @override
  String get button_sort_ascending => 'Наростальний';

  @override
  String get settings_page_appearance => 'Вигляд';

  @override
  String get settings_page_appearance_description => 'Мова, теми, шрифти';

  @override
  String get settings_language => 'Мова';

  @override
  String get settings_language_contribute => 'Підтримати';

  @override
  String get settings_appearance_section_theming => 'Оформити';

  @override
  String get settings_theme => 'Тема';

  @override
  String get settings_theme_system => 'Системна';

  @override
  String get settings_theme_light => 'Світла';

  @override
  String get settings_theme_dark => 'Темна';

  @override
  String get settings_dynamic_theming => 'Динамічне оформлення';

  @override
  String get settings_dynamic_theming_description => 'Генерувати кольори з системи';

  @override
  String get settings_black_theming => 'Amoled оформлення';

  @override
  String get settings_black_theming_description => 'Використовувати чорний фон у темному режимі';

  @override
  String get settings_appearance_section_fonts => 'Шрифти';

  @override
  String get settings_app_font => 'Шрифт додатка';

  @override
  String get settings_app_font_description =>
      'Шрифт використовується для всіх текстів у додатку, окрім редактора нотаток';

  @override
  String get settings_editor_font => 'Шрифт редактора';

  @override
  String get settings_editor_font_description => 'Шрифт використовується лише для тексту в редакторі нотаток';

  @override
  String get settings_page_notes_tiles => 'Плити нотаток';

  @override
  String get settings_page_notes_tiles_description => 'Вигляд, вміст';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Вигляд';

  @override
  String get settings_page_notes_tiles_content_section => 'Вміст';

  @override
  String get settings_show_tiles_background => 'Фон';

  @override
  String get settings_show_tiles_background_description => 'Показати фон плиток нотаток';

  @override
  String get settings_show_separators => 'Роздільники';

  @override
  String get settings_show_separators_description => 'Показати роздільник між плитками нотаток';

  @override
  String get settings_show_note_type_icon => 'Показати значок типу';

  @override
  String get settings_show_note_type_icon_description => 'Показати значок типу нотатки';

  @override
  String get settings_show_titles_only => 'Лише заголовки';

  @override
  String get settings_show_titles_only_description => 'Показувати лише заголовки нотаток';

  @override
  String get settings_show_titles_only_disable_in_search_view => 'Вимкнути заголовки лише в режимі пошуку';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Вимкнути опцію показу лише назв у режимі пошуку';

  @override
  String get settings_content_preview_max_lines => 'Максимальна кількість рядків попереднього перегляду';

  @override
  String get settings_content_preview_max_lines_description =>
      'Максимальна кількість рядків попереднього перегляду вмісту для показу';

  @override
  String get settings_behavior => 'Поведінка';

  @override
  String get settings_behavior_description => 'Підтвердження, дії зі гортанням';

  @override
  String get settings_behavior_application => 'Застосунок';

  @override
  String get settings_confirmations => 'Діалогове вікно підтвердження';

  @override
  String get settings_confirmations_description =>
      'Коли показувати діалогове вікно підтвердження під час виконання дії з нотаткою';

  @override
  String get settings_confirmations_title_none => 'Ніколи';

  @override
  String get settings_confirmations_title_irreversible => 'Тільки незворотні дії';

  @override
  String get settings_confirmations_title_all => 'Завжди';

  @override
  String get settings_auto_remove_from_bin_title => 'Автоматичне видалення з кошика';

  @override
  String get settings_auto_remove_from_bin_description => 'Автоматично видаляти нотатки з кошика';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'Після тижня',
      '14': 'Після 2 тижнів',
      '30': 'Після місяця',
      '90': 'Після 3 місяців',
      '180': 'Після 6 місяців',
      '365': 'Після року',
      'other': 'Ніколи',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Дії з гортанням';

  @override
  String get settings_behavior_swipe_actions_archives => 'Дії з гортанням (архів)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Дії з гортанням (кошик)';

  @override
  String get settings_swipe_action_right => 'Дія гортання праворуч';

  @override
  String get settings_swipe_action_right_description =>
      'Дія, яка спрацьовує, коли на плитці нотатки виконується гортання праворуч';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Дія, яка спрацьовує, коли на плитці нотатки в кошику виконується гортання праворуч';

  @override
  String get settings_swipe_action_left => 'Дія гортання ліворуч';

  @override
  String get settings_swipe_action_left_description =>
      'Дія, яка спрацьовує, коли на плитці нотатки виконується гортання ліворуч';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Дія, яка спрацьовує, коли на плитці нотатки в кошику виконується гортання ліворуч';

  @override
  String get settings_page_notes_types => 'Типи нотаток';

  @override
  String get settings_page_notes_types_description => 'Типи до використання, форматований текст';

  @override
  String get settings_section_types_to_use => 'Типи до використання';

  @override
  String get settings_available_notes_types => 'Доступні типи до використання';

  @override
  String get settings_available_notes_types_description =>
      'Список типів нотаток, які можна створити за допомогою кнопки «Додати» на сторінці нотаток. Під час видалення типу наявні нотатки цього типу не видаляються та їх можна використовувати як завжди';

  @override
  String get settings_available_default_share_type => 'Тип поширення за замовчуванням';

  @override
  String get settings_available_default_share_type_description =>
      'Тип нотатки за замовчуванням, який використовується під час створення нотатки з дії поширення. Це може бути тип, недоступний за допомогою кнопки «Додати»';

  @override
  String get settings_editor => 'Редактор';

  @override
  String get settings_editor_description => 'Поведінка';

  @override
  String get settings_editor_behavior => 'Поведінка';

  @override
  String get settings_show_editor_mode_button => 'Кнопка режиму редактора';

  @override
  String get settings_show_editor_mode_button_description =>
      'Увімкніть кнопку для перемикання редактора між режимом редагування та режимом читання';

  @override
  String get settings_open_editor_reading_mode => 'Відкрити в режимі читання';

  @override
  String get settings_open_editor_reading_mode_description => 'Відкривати редактор у режимі читання за замовчуванням';

  @override
  String get settings_focus_title_on_new_note => 'Зосередитись на заголовку';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Зосередитись на заголовку, а не на змісті під час створення нової нотатки';

  @override
  String get settings_editor_appearance => 'Вигляд';

  @override
  String get settings_toolbar_style_title => 'Стиль панелі інструментів';

  @override
  String get settings_toolbar_style_description => 'Стиль панелі інструментів редактора форматованого тексту';

  @override
  String get settings_use_paragraph_spacing => 'Інтервал між абзацами';

  @override
  String get settings_use_paragraph_spacing_description => 'Використовувати інтервали між абзацами';

  @override
  String get settings_labels => 'Теги';

  @override
  String get settings_labels_description => 'Увімкнути, вигляд';

  @override
  String get settings_enable_labels => 'Увімкнути';

  @override
  String get settings_enable_labels_description =>
      'Дозволити категоризацію нотаток за допомогою тегів (вимкнення цієї функції не видаляє теги та не видаляє їх з нотаток, а лише приховує їх)';

  @override
  String get settings_labels_appearance => 'Вигляд';

  @override
  String get settings_show_labels_note_tile => 'Показувати теги на плитці нотаток';

  @override
  String get settings_show_labels_note_tile_description => 'Показати список тегів плиток нотаток';

  @override
  String get settings_show_labels_editor => 'Показати теги в редакторі';

  @override
  String get settings_show_labels_editor_description => 'Показати список тегів унизу редактора';

  @override
  String get settings_labels_section_behavior => 'Поведінка';

  @override
  String get settings_labels_swipe_action_right => 'Дія гортання праворуч';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Дія, яка спрацьовує, коли на плитці з міткою виконується гортання праворуч';

  @override
  String get settings_labels_swipe_action_left => 'Дія гортання ліворуч';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Дія, яка спрацьовує, коли на плитці з міткою виконується гортання ліворуч';

  @override
  String get settings_backup => 'Резервна копія';

  @override
  String get settings_backup_description => 'Ручний та автоматичний експорт, шифрування, імпорт';

  @override
  String get settings_backup_import => 'Імпорт';

  @override
  String get settings_import => 'Імпорт';

  @override
  String get settings_import_description => 'Імпорт нотаток, тегів та налаштувань з JSON-файлу';

  @override
  String get settings_backup_manual_export => 'Ручний експорт';

  @override
  String get settings_export_json => 'Експортувати як JSON-файл';

  @override
  String get settings_export_json_description =>
      'Миттєво експортувати всі нотатки, теги та налаштування у файл JSON, який можна імпортувати назад';

  @override
  String get settings_export_markdown => 'Експортувати як Markdown';

  @override
  String get settings_export_markdown_description => 'Миттєво експортувати всі нотатки до файлу Markdown';

  @override
  String get settings_backup_auto_export => 'Автоматичний експорт';

  @override
  String get settings_auto_export => 'Автоматичний експорт';

  @override
  String get settings_auto_export_description =>
      'Автоматично експортувати всі нотатки, теги та налаштування у файл JSON, який можна імпортувати назад';

  @override
  String get settings_auto_export_frequency => 'Частота';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'день',
      '7': 'тиждень',
      '14': '2 тижні',
      '30': 'місяць',
      'other': '',
    });
    return 'Кожен $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Частота автоматичного експорту';

  @override
  String get settings_auto_export_encryption => 'Шифрування';

  @override
  String get settings_auto_export_encryption_description => 'Зашифрувати назву та вміст нотаток паролем';

  @override
  String get settings_auto_export_directory => 'Тека';

  @override
  String get settings_auto_export_directory_description => 'Тека для зберігання автоматичних експортів';

  @override
  String get settings_security => 'Безпека';

  @override
  String get settings_security_description => 'Позначення безпеки, блокування додатка, блокування нотатки';

  @override
  String get settings_security_application => 'Додаток';

  @override
  String get settings_security_application_lock => 'Блокування додатка';

  @override
  String get settings_security_note_lock => 'Блокування нотатки';

  @override
  String get settings_flag_secure => 'Позначити додаток як безпечний';

  @override
  String get settings_flag_secure_description =>
      'Приховати додаток від нещодавніх програм і запобігти створенню скриншотів';

  @override
  String get settings_application_lock_title => 'Блокування';

  @override
  String get settings_application_lock_description =>
      'Заблокувати додаток та вимагати автентифікацію за допомогою пристрою, щоб розблокувати її';

  @override
  String get settings_application_lock_delay_title => 'Затримка блокування';

  @override
  String get settings_application_lock_delay_description =>
      'Затримка, після якої додаток блокується при переміщенні у фоновий режим';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Негайно',
      '3': 'Після 3 секунд',
      '5': 'Після 5 секунд',
      '10': 'Після 10 секунд',
      '30': 'Після 30 секунд',
      '60': 'Після хвилини',
      '120': 'Після 2 хвилин',
      '300': 'Після 5 хвилин',
      'other': 'Ніколи',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Блокування нотатки';

  @override
  String get settings_note_lock_description =>
      'Блокування нотатки та вимога автентифікації за допомогою пристрою для її перегляду та редагування';

  @override
  String get settings_label_lock_title => 'Блокування тега';

  @override
  String get settings_label_lock_description =>
      'Блокування тега і вимога автентифікації за допомогою пристрої для перегляду та редагування будь-якої нотатки, яка його містить';

  @override
  String get settings_note_lock_delay_title => 'Затримка блокування';

  @override
  String get settings_note_lock_delay_description =>
      'Затримка, після якої нотатка блокується, коли додаток переміщується у фоновий режим';

  @override
  String get settings_accessibility => 'Доступність';

  @override
  String get settings_accessibility_text_size => 'Розмір тексту';

  @override
  String get settings_accessibility_text_color => 'Колір тексту';

  @override
  String get settings_accessibility_description => 'Колір тексту, масштабування тексту';

  @override
  String get settings_text_scaling => 'Масштабування тексту';

  @override
  String get settings_bigger_titles => 'Збільшені заголовки';

  @override
  String get settings_bigger_titles_description => 'Показувати більші заголовки на плитках нотаток та в редакторі';

  @override
  String get settings_white_text_dark_mode => 'Білий текст у темному режимі';

  @override
  String get settings_white_text_dark_mode_description => 'Використовувати білий колір для тексту в темному режимі';

  @override
  String get settings_disable_subdued_note_content_preview => 'Не приглушений попередній перегляд';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Вимкнути приглушений колір тексту попереднього перегляду вмісту нотаток';

  @override
  String get settings_help_section_contact => 'Контакти';

  @override
  String get settings_github_issues => 'Повідомити про помилку або пропонувати функцію';

  @override
  String get settings_github_issues_description =>
      'Повідомити про помилку або пропонувати функцію, створивши запит на GitHub';

  @override
  String get settings_github_discussions => 'Поставити питання';

  @override
  String get settings_github_discussions_description => 'Ставити питання на GitHub дискусії';

  @override
  String get settings_contact_developer => 'Зв\'язатись з розробником';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Зв\'язатись з розробником через пошту $email';
  }

  @override
  String get settings_help => 'Допомога';

  @override
  String get settings_help_description => 'Контакти, лог-файли';

  @override
  String get settings_help_section_logs => 'Лог-файли';

  @override
  String get settings_copy_logs => 'Копіювати лог-файли';

  @override
  String get settings_copy_logs_description => 'Копіювати лог-файли додатка в буфер обміну';

  @override
  String get settings_export_logs => 'Експортувати лог-файли';

  @override
  String get settings_export_logs_description => 'Експортувати лог-файли додатка в текстовий файл';

  @override
  String get settings_about => 'Про додаток';

  @override
  String get settings_about_description => 'Інформація, посилання, пожертвування';

  @override
  String get settings_about_application => 'Додаток';

  @override
  String get settings_build_mode => 'Режим збірки';

  @override
  String get settings_build_mode_release => 'Реліз';

  @override
  String get settings_build_mode_debug => 'Налагодження';

  @override
  String get settings_about_links => 'Посилання';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Переглянути вихідний код';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Додати або покращити локалізації в проєкті Crowdin';

  @override
  String get settings_licence => 'Ліцензія';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Пожертвування';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Заголовок';

  @override
  String get hint_content => 'Нотатка';

  @override
  String get hint_link => 'Посилання';

  @override
  String get hint_label_name => 'Назва';

  @override
  String get dialog_export_encryption_password => 'Пароль';

  @override
  String get dialog_select_labels => 'Обрати теги';

  @override
  String get dialog_select_labels_to_add => 'Обрати теги, щоб додати';

  @override
  String get tooltip_undo => 'Скасувати останню дію';

  @override
  String get tooltip_redo => 'Повторити останню дію';

  @override
  String get tooltip_fab_add_note => 'Додати нотатку';

  @override
  String get tooltip_fab_add_plain_text_note => 'Додати нотатку у вигляді звичайного тексту';

  @override
  String get tooltip_fab_add_markdown_note => 'Додати нотатку у вигляді markdown';

  @override
  String get tooltip_fab_add_rich_text_note => 'Додати нотатку у вигляді форматованого тексту';

  @override
  String get tooltip_fab_add_checklist_note => 'Додати нотатку у вигляді контрольованого тексту';

  @override
  String get tooltip_fab_add_label => 'Додати тег';

  @override
  String get tooltip_fab_empty_bin => 'Очистити кошик';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Перейти у режим редактора';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Перейти у режим читання';

  @override
  String get tooltip_layout_list => 'Огляд списку';

  @override
  String get tooltip_layout_grid => 'Огляд сітки';

  @override
  String get tooltip_sort => 'Сортувати нотатки';

  @override
  String get tooltip_search => 'Пошук нотаток';

  @override
  String get tooltip_unselect_all => 'Зняти вибір усіх';

  @override
  String get tooltip_reset => 'Скинути';

  @override
  String get dialog_add_link => 'Додати посилання';

  @override
  String get dialog_archive => 'Архів';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотатку');
    return 'Ви справді хочете архівувати $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Розархівувати';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотатку');
    return 'Ви справді хочете розархівувати $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Видалити';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотатку');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'їх', one: 'її');
    return 'Ви справді хочете видалити $count $_temp0? Ви зможете відновити $_temp1 з кошика.';
  }

  @override
  String get dialog_permanently_delete => 'Остаточне видалення';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотатку');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'їх', one: 'її');
    return 'Ви справді хочете остаточно видалити $count $_temp0? Ви не матимете змоги відновити $_temp1.';
  }

  @override
  String get dialog_restore => 'Відновити';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотатку');
    return 'Ви справді хочете відновити $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Очистити кошик';

  @override
  String get dialog_empty_bin_body =>
      'Ви справді хочете остаточно очистити кошик? Ви не зможете відновити нотатки, які в ньому містяться.';

  @override
  String get dialog_delete_label => 'Видалити';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'теги', one: 'тег');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'Їх', one: 'Його');
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: 'їх', one: 'його');
    return 'Ви справді хочете видалити $count $_temp0? $_temp1 буде видаленого з нотаток, де ви додали $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'Шифрування експорту JSON';

  @override
  String get dialog_export_encryption_description =>
      'Назва та вміст нотаток будуть зашифровані за допомогою вашого пароля. Він має бути згенерований випадковим чином, складатися рівно з 32 символів, бути надійним (принаймні 1 мала літера, 1 велика літера, 1 цифра та 1 спеціальний символ) та надійно зберігатися.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Цей пароль буде використано для всіх майбутніх автоматичних експортів.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Цей пароль буде використано лише для цього експорту.';

  @override
  String get dialog_export_encryption_password_invalid => 'Недійсний';

  @override
  String get dialog_import_encryption_password_description =>
      'Цей експорт зашифровано. Щоб імпортувати його, потрібно вказати пароль, який використовувався для шифрування.';

  @override
  String get dialog_import_encryption_password_error =>
      'Розшифрування експорту не вдалося. Переконайтеся, що ви вказали той самий пароль, який використовували для шифрування експорту.';

  @override
  String get dialog_label_add => 'Додати тег';

  @override
  String get dialog_label_edit => 'Редагувати тег';

  @override
  String get dialog_label_name_cannot_be_empty => 'Назва не може бути порожньою.';

  @override
  String get dialog_label_name_already_used => 'Ця назва вже використовується.';

  @override
  String get button_sort_creation_date => 'Дата створення';

  @override
  String get button_sort_edition_date => 'Дата редагування';

  @override
  String get placeholder_notes => 'Без нотаток';

  @override
  String get placeholder_labels => 'Без тегів';

  @override
  String get placeholder_archives => 'Відсутні архівовані нотатки';

  @override
  String get placeholder_bin => 'Відсутні видалені нотатки';

  @override
  String get action_disabled => 'Вимкнено';

  @override
  String get action_toggle_pin => 'Перемикання закріплень';

  @override
  String get action_pin_unpin => 'Закріпити / Відкріпити';

  @override
  String get action_pin => 'Закріпити';

  @override
  String get action_unpin => 'Відкріпити';

  @override
  String get action_toggle_lock => 'Перемикач блокування';

  @override
  String get action_lock_unlock => 'Блокувати / Розблокувати';

  @override
  String get action_lock => 'Блокувати';

  @override
  String get action_unlock => 'Розблокувати';

  @override
  String get action_share => 'Поширити';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотатку');
    return '$count $_temp0 опубліковано з Material Notes';
  }

  @override
  String get action_archive => 'Архівувати';

  @override
  String get action_unarchive => 'Розархівувати';

  @override
  String get action_delete => 'Видалити';

  @override
  String get action_restore => 'Відновити';

  @override
  String get action_delete_permanently => 'Остаточно видалити';

  @override
  String get action_about => 'Про додаток';

  @override
  String get about_last_edited => 'Останнє редагування';

  @override
  String get about_type => 'Тип';

  @override
  String get about_created => 'Створено';

  @override
  String get about_labels => 'Теги';

  @override
  String get about_words => 'Слова';

  @override
  String get about_characters => 'Властивість';

  @override
  String get about_time_at => 'в';

  @override
  String get menu_action_select_labels => 'Теги';

  @override
  String get menu_action_add_labels => 'Додати теги';

  @override
  String get action_labels_toggle_visibile => 'Перемикач видимості';

  @override
  String get action_labels_show_hide => 'Показати / Приховати';

  @override
  String get action_labels_show => 'Показати';

  @override
  String get action_labels_hide => 'Приховати';

  @override
  String get action_labels_toggle_pins => 'Перемикач закріплень';

  @override
  String get action_labels_pin_unpin => 'Закріпити / Відкріпити';

  @override
  String get action_labels_pin => 'Закріпити';

  @override
  String get action_labels_unpin => 'Відкріпити';

  @override
  String get action_labels_toggle_lock => 'Перемикач блокування';

  @override
  String get action_labels_lock_unlock => 'Блокувати / Розблокувати';

  @override
  String get action_labels_lock => 'Блокувати';

  @override
  String get action_labels_unlock => 'Розблокувати';

  @override
  String get action_labels_edit => 'Редагувати';

  @override
  String get action_labels_delete => 'Видалити';

  @override
  String get filter_labels_all => 'Всі';

  @override
  String get filter_labels_visible => 'Видимі';

  @override
  String get filter_labels_hidden => 'Приховані';

  @override
  String get filter_labels_pinned => 'Закріплені';

  @override
  String get filter_labels_locked => 'Заблоковані';

  @override
  String get snack_bar_authentication_failed => 'Невдала автентифікація, будь ласка, спробуйте ще раз.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотаток');
    return '$_temp0 заархівовано';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотаток');
    return '$_temp0 розархівовано';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотаток');
    return '$_temp0 видалено';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатки', one: 'нотаток');
    return '$_temp0 відновлено';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'нотатків', one: 'нотатка');
    return 'Вміст $_temp0 скопійовано до буфера обміну.';
  }

  @override
  String get snack_bar_import_success => 'Резервну копію успішно імпортовано.';

  @override
  String get snack_bar_export_success => 'Резервні копії успішно експортовано.';

  @override
  String get snack_bar_logs_copied => 'Лог-файли скопійовано до буфера обміну.';

  @override
  String get snack_bar_logs_exported => 'Лог-файли успішно експортовано.';

  @override
  String get snack_bar_no_labels => 'Теги відсутні.';

  @override
  String get quick_action_add_plain_text_note_title => 'Додати нотатку у вигляді звичайного тексту';

  @override
  String get quick_action_add_markdown_note_title => 'Додати нотатку у вигляді markdown';

  @override
  String get quick_action_add_rich_text_note_title => 'Додати нотатку у вигляді форматованого тексту';

  @override
  String get quick_action_add_checklist_note_title => 'Додати нотатку у вигляді контрольованого листа';

  @override
  String get welcome_note_title => 'Вітаю у Material Notes!';

  @override
  String get welcome_note_content => 'Прості, локальні, нотатки в стилі Material Design';

  @override
  String get font_system_default => 'Системні за замовчуванням';

  @override
  String get note_type_plain_text => 'Звичайний текст';

  @override
  String get note_type_markdown => 'Текст з розміткою';

  @override
  String get note_type_rich_text => 'Форматований текст';

  @override
  String get note_type_checklist => 'Контрольований список';

  @override
  String get lock_page_reason_app => 'Розблокувати Material Notes';

  @override
  String get lock_page_reason_note => 'Розблокувати цю нотатку';

  @override
  String get lock_page_reason_action => 'Авторизувати цю дію';

  @override
  String get lock_page_description_app => 'Додаток заблоковано.';

  @override
  String get lock_page_description_note => 'Ця нотатка заблокована.';

  @override
  String get lock_page_unlock => 'Розблокувати';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Колір переднього плану';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Колір фону';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Колір переднього плану';

  @override
  String get toolbar_style_one_row_simple_title => 'Один ряд (прості параметри)';

  @override
  String get toolbar_style_one_row_simple_description => 'Тільки прості параметри форматування в одному рядку';

  @override
  String get toolbar_style_one_row_all_title => 'Один рядок (усі параметри)';

  @override
  String get toolbar_style_one_row_all_description => 'Усі параметри форматування в одному рядку';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Два рядки (складені)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'Усі параметри форматування для двох складених рядків';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Два рядки (з перемиканням)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'Усі параметри форматування у двох рядках, що перемикаються';

  @override
  String get settings_confirm_before_exiting_title => 'Підтвердити вихід';

  @override
  String get settings_confirm_before_exiting_description => 'Запитувати підтвердження перед виходом із додатка';

  @override
  String get snack_bar_confirm_exiting => 'Натисніть кнопку «Назад» ще раз, щоб вийти з додатка.';
}
