// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Notes simples, locales, en material design';

  @override
  String app_about(String appName) {
    return '$appName est une application de prise de notes textuelles, qui vise la simplicité. Elle adopte le style Material Design. Elle stocke les notes localement et n\'a aucune permission internet, vous êtes donc le seul à pouvoir accéder aux notes.';
  }

  @override
  String get error_snack_bar => 'Erreur :';

  @override
  String get error_widget_title => 'Une erreur s\'est produite.';

  @override
  String get error_widget_description =>
      'Veuillez signaler cette erreur sur GitHub ou par mail. Joignez une capture d\'écran de cette page et les logs que vous pouvez copier ou exporter ci-dessous. Par précaution, vous devriez également exporter vos notes.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Le paramètre pour marquer l\'application comme sécurisée est désactivé jusquau prochain redémarrage pour permettre les captures décran.';

  @override
  String get error_widget_button_export_notes => 'Exporter les notes';

  @override
  String get error_widget_button_copy_logs => 'Copier les logs';

  @override
  String get error_widget_button_export_logs => 'Exporter les logs';

  @override
  String get error_widget_button_create_github_issue => 'Créer une issue GitHub';

  @override
  String get error_widget_button_send_mail => 'Envoyer un mail';

  @override
  String get navigation_notes => 'Notes';

  @override
  String get navigation_manage_labels_destination => 'Gérer les libellés';

  @override
  String get navigation_manage_labels_page => 'Libellés';

  @override
  String get navigation_archives => 'Archives';

  @override
  String get navigation_bin => 'Corbeille';

  @override
  String get navigation_settings => 'Paramètres';

  @override
  String get navigation_settings_appearance => 'Apparence';

  @override
  String get navigation_settings_notes_types => 'Types de notes';

  @override
  String get navigation_settings_notes_tiles => 'Tuiles de notes';

  @override
  String get navigation_settings_behavior => 'Comportement';

  @override
  String get navigation_settings_editor => 'Éditeur';

  @override
  String get navigation_settings_labels => 'Libellés';

  @override
  String get navigation_settings_backup => 'Sauvegarde';

  @override
  String get navigation_settings_security => 'Sécurité';

  @override
  String get navigation_settings_accessibility => 'Accessibilité';

  @override
  String get navigation_settings_help => 'Aide';

  @override
  String get navigation_settings_about => 'À propos';

  @override
  String get button_sort_title => 'Titre';

  @override
  String get button_sort_ascending => 'Croissant';

  @override
  String get settings_page_appearance => 'Apparence';

  @override
  String get settings_page_appearance_description => 'Langue, thème, polices';

  @override
  String get settings_language => 'Langue';

  @override
  String get settings_language_contribute => 'Contribuer';

  @override
  String get settings_appearance_section_theming => 'Thème';

  @override
  String get settings_theme => 'Thème';

  @override
  String get settings_theme_system => 'Système';

  @override
  String get settings_theme_light => 'Clair';

  @override
  String get settings_theme_dark => 'Sombre';

  @override
  String get settings_dynamic_theming => 'Thème dynamique';

  @override
  String get settings_dynamic_theming_description => 'Générer des couleurs depuis le système';

  @override
  String get settings_black_theming => 'Thème noir';

  @override
  String get settings_black_theming_description => 'Utilise un fond noir pour le thème sombre';

  @override
  String get settings_appearance_section_fonts => 'Polices';

  @override
  String get settings_app_font => 'Police de l\'application';

  @override
  String get settings_app_font_description =>
      'Police utilisée pour tous les textes dans l\'application, hormis dans l\'éditeur de note';

  @override
  String get settings_editor_font => 'Police de l\'éditeur';

  @override
  String get settings_editor_font_description => 'Police utilisée pour le texte dans l\'éditeur de notes';

  @override
  String get settings_page_notes_tiles => 'Tuiles de notes';

  @override
  String get settings_page_notes_tiles_description => 'Apparence, contenu';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Apparence';

  @override
  String get settings_page_notes_tiles_content_section => 'Contenu';

  @override
  String get settings_show_tiles_background => 'Fond';

  @override
  String get settings_show_tiles_background_description => 'Afficher l\'arrière-plan des tuiles de notes';

  @override
  String get settings_show_separators => 'Séparateurs';

  @override
  String get settings_show_separators_description => 'Afficher un séparateur entre les tuiles de notes';

  @override
  String get settings_show_note_type_icon => 'Afficher l\'icône du type';

  @override
  String get settings_show_note_type_icon_description => 'Afficher l\'icône du type de la note';

  @override
  String get settings_show_titles_only => 'Titres uniquement';

  @override
  String get settings_show_titles_only_description => 'Afficher uniquement les titres des notes';

  @override
  String get settings_show_titles_only_disable_in_search_view => 'Désactiver titres uniquement dans la recherche';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Désactiver l’option pour afficher uniquement les titres dans la vue de recherche';

  @override
  String get settings_content_preview_max_lines => 'Maximum de lignes d\'aperçu';

  @override
  String get settings_content_preview_max_lines_description =>
      'Nombre maximum de lignes d\'aperçu du contenu à afficher';

  @override
  String get settings_behavior => 'Comportement';

  @override
  String get settings_behavior_description => 'Confirmations, actions de balayage';

  @override
  String get settings_behavior_application => 'Application';

  @override
  String get settings_confirmations => 'Dialogues de confirmation';

  @override
  String get settings_confirmations_description =>
      'Quand afficher un dialogue de confirmation lors de l\'exécution d\'une action sur une note';

  @override
  String get settings_confirmations_title_none => 'Jamais';

  @override
  String get settings_confirmations_title_irreversible => 'Actions irréversibles uniquement';

  @override
  String get settings_confirmations_title_all => 'Toujours';

  @override
  String get settings_auto_remove_from_bin_title => 'Retrait automatique de la corbeille';

  @override
  String get settings_auto_remove_from_bin_description => 'Retirer automatiquement les notes de la corbeille';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'Après 1 semaine',
      '14': 'Après 2 semaines',
      '30': 'Après 1 mois',
      '90': 'Après 3 mois',
      '180': 'Après 6 mois',
      '365': 'Après 1 an',
      'other': 'Jamais',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Actions de balayage';

  @override
  String get settings_behavior_swipe_actions_archives => 'Actions de balayage (archives)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Action de balayage (corbeille)';

  @override
  String get settings_swipe_action_right => 'Action de balayage à droite';

  @override
  String get settings_swipe_action_right_description =>
      'Action à déclencher lorsqu\'un balayage vers la droite est effectué sur une tuile de note';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Action à déclencher lorsqu\'un balayage vers la droite est effectué sur une tuile de note dans la corbeille';

  @override
  String get settings_swipe_action_left => 'Action de balayage à gauche';

  @override
  String get settings_swipe_action_left_description =>
      'Action à déclencher lorsqu\'un balayage vers la gauche est effectué sur une tuile de note';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Action à déclencher lorsqu\'un balayage vers la gauche est effectué sur une tuile de note dans la corbeille';

  @override
  String get settings_page_notes_types => 'Types de notes';

  @override
  String get settings_page_notes_types_description => 'Types à utiliser, texte riche';

  @override
  String get settings_section_types_to_use => 'Types à utiliser';

  @override
  String get settings_available_notes_types => 'Types de notes disponibles';

  @override
  String get settings_available_notes_types_description =>
      'La liste des types de notes qui peuvent être créés avec le bouton \"Ajouter\" à partir de la page des notes. Lors du retrait d\'un type, les notes déjà existantes avec ce type ne sont pas supprimées et peuvent toujours être utilisées normalement';

  @override
  String get settings_available_default_share_type => 'Type de partage par défaut';

  @override
  String get settings_available_default_share_type_description =>
      'Le type de note à utiliser par défaut lors de la création d\'une note à partir d\'une action de partage. Il peut s\'agir d\'un type qui n\'est pas disponible depuis le bouton \"Ajouter\"';

  @override
  String get settings_editor => 'Éditeur';

  @override
  String get settings_editor_description => 'Comportement';

  @override
  String get settings_editor_behavior => 'Comportement';

  @override
  String get settings_show_editor_mode_button => 'Bouton du mode édition';

  @override
  String get settings_show_editor_mode_button_description =>
      'Activer le bouton pour basculer entre le mode d\'édition et le mode de lecture';

  @override
  String get settings_open_editor_reading_mode => 'Ouvrir en mode lecture';

  @override
  String get settings_open_editor_reading_mode_description => 'Ouvrir l\'éditeur en mode lecture par défaut';

  @override
  String get settings_focus_title_on_new_note => 'Focaliser le titre';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Focaliser le titre au lieu du contenu lors de la création d\'une nouvelle note';

  @override
  String get settings_editor_appearance => 'Apparence';

  @override
  String get settings_toolbar_style_title => 'Style de la barre d\'outils';

  @override
  String get settings_toolbar_style_description => 'Le style de la barre d\'outils de l\'éditeur de texte riche';

  @override
  String get settings_use_paragraph_spacing => 'Espacement entre les paragraphes';

  @override
  String get settings_use_paragraph_spacing_description => 'Utiliser l\'espacement entre les paragraphes';

  @override
  String get settings_labels => 'Libellés';

  @override
  String get settings_labels_description => 'Activer, apparence';

  @override
  String get settings_enable_labels => 'Activer';

  @override
  String get settings_enable_labels_description =>
      'Permettre de catégoriser les notes avec des étiquettes (le désactiver ne supprime pas les étiquettes et ne les retire pas des notes, ça les masque seulement)';

  @override
  String get settings_labels_appearance => 'Apparence';

  @override
  String get settings_show_labels_note_tile => 'Montrer libellés sur tuile de note';

  @override
  String get settings_show_labels_note_tile_description => 'Montrer la liste des libellés sur les tuiles de notes';

  @override
  String get settings_show_labels_editor => 'Montrer libellés dans l\'éditeur';

  @override
  String get settings_show_labels_editor_description => 'Montrer la liste des libellés en bas de l\'éditeur';

  @override
  String get settings_labels_section_behavior => 'Comportement';

  @override
  String get settings_labels_swipe_action_right => 'Action de balayage vers la droite';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action à déclencher lorsqu\'un glissement vers la droite est effectué sur une tuile d\'étiquette';

  @override
  String get settings_labels_swipe_action_left => 'Action de glissement vers la gauche';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action à déclencher lorsqu\'un glissement vers la gauche est effectué sur une tuile d\'étiquette';

  @override
  String get settings_backup => 'Sauvegarde';

  @override
  String get settings_backup_description => 'Export manuel et automatique, chiffrement, import';

  @override
  String get settings_backup_import => 'Importer';

  @override
  String get settings_import => 'Importer';

  @override
  String get settings_import_description =>
      'Importer des notes, des étiquettes et des paramètres depuis un fichier JSON';

  @override
  String get settings_backup_manual_export => 'Export manuel';

  @override
  String get settings_export_json => 'Exporter en JSON';

  @override
  String get settings_export_json_description =>
      'Exporter immédiatement toutes les notes, étiquettes et paramètres vers un fichier JSON qui peut être réimporté';

  @override
  String get settings_export_markdown => 'Exporter en Markdown';

  @override
  String get settings_export_markdown_description => 'Exporter immédiatement toutes les notes vers un fichier Markdown';

  @override
  String get settings_backup_auto_export => 'Export automatique';

  @override
  String get settings_auto_export => 'Export automatique';

  @override
  String get settings_auto_export_description =>
      'Exporter immédiatement toutes les notes, étiquettes et paramètres vers un fichier JSON qui peut être réimporté';

  @override
  String get settings_auto_export_frequency => 'Fréquence';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'jour',
      '7': 'semaine',
      '14': '2 semaines',
      '30': 'mois',
      'other': '',
    });
    return 'Chaque $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Fréquence de l\'export automatique';

  @override
  String get settings_auto_export_encryption => 'Chiffrement';

  @override
  String get settings_auto_export_encryption_description =>
      'Chiffrer le titre et le contenu des notes avec un mot de passe';

  @override
  String get settings_auto_export_directory => 'Dossier';

  @override
  String get settings_auto_export_directory_description => 'Dossier où stocker les exports automatiques';

  @override
  String get settings_security => 'Sécurité';

  @override
  String get settings_security_description => 'Sécurité, verrou de l\'application, verrou de note';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Verrouillage de l\'application';

  @override
  String get settings_security_note_lock => 'Verrouillage de note';

  @override
  String get settings_flag_secure => 'Marquer l\'application comme sécurisée';

  @override
  String get settings_flag_secure_description =>
      'Masquer l\'application des applications récentes et empêcher la réalisation de captures d\'écran';

  @override
  String get settings_application_lock_title => 'Verrouillage';

  @override
  String get settings_application_lock_description =>
      'Verrouiller l\'application et demander à s\'authentifier avec l\'appareil pour la déverrouiller';

  @override
  String get settings_application_lock_delay_title => 'Délai de verrouillage';

  @override
  String get settings_application_lock_delay_description =>
      'Délai après lequel l\'application se verrouille lorsqu\'elle est mise en arrière-plan';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immédiatement',
      '3': 'Après 3 secondes',
      '5': 'Après 5 secondes',
      '10': 'Après 10 secondes',
      '30': 'Après 30 secondes',
      '60': 'Après 1 minute',
      '120': 'Après 2 minutes',
      '300': 'Après 5 minutes',
      'other': 'Jamais',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Verrouiller la note';

  @override
  String get settings_note_lock_description =>
      'Verrouiller la note et demander à s\'authentifier avec l\'appareil pour la voir et la modifier';

  @override
  String get settings_label_lock_title => 'Verrouillage d\'étiquette';

  @override
  String get settings_label_lock_description =>
      'Verrouiller l\'étiquette et demander à s\'authentifier avec l\'appareil pour voir et éditer toute note qui la contient';

  @override
  String get settings_note_lock_delay_title => 'Délai de verrouillage';

  @override
  String get settings_note_lock_delay_description =>
      'Délai après lequel la note se verrouille quand l\'application est déplacée en arrière-plan';

  @override
  String get settings_accessibility => 'Accessibilité';

  @override
  String get settings_accessibility_text_size => 'Taille du texte';

  @override
  String get settings_accessibility_text_color => 'Couleur du texte';

  @override
  String get settings_accessibility_description => 'Couleur du texte, taille du texte';

  @override
  String get settings_text_scaling => 'Mise à l\'échelle du texte';

  @override
  String get settings_bigger_titles => 'Plus gros titres';

  @override
  String get settings_bigger_titles_description =>
      'Afficher des titres plus grands sur les tuiles de notes et dans l\'éditeur';

  @override
  String get settings_white_text_dark_mode => 'Texte blanc en thème sombre';

  @override
  String get settings_white_text_dark_mode_description => 'Utiliser une couleur blanche pour le texte en thème sombre';

  @override
  String get settings_disable_subdued_note_content_preview => 'Aperçu non atténué';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Désactiver la couleur de texte atténuée de l\'aperçu du contenu des notes';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues => 'Signaler un bug ou proposer une fonctionnalité';

  @override
  String get settings_github_issues_description =>
      'Signaler un bug ou proposer une fonctionnalité en créant une issue GitHub';

  @override
  String get settings_github_discussions => 'Poser une question';

  @override
  String get settings_github_discussions_description => 'Poser une question dans les discussions GitHub';

  @override
  String get settings_contact_developer => 'Contacter le développeur';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Contacter le développeur par mail à $email';
  }

  @override
  String get settings_help => 'Aide';

  @override
  String get settings_help_description => 'Contact, journaux';

  @override
  String get settings_help_section_logs => 'Journaux';

  @override
  String get settings_copy_logs => 'Copier les logs';

  @override
  String get settings_copy_logs_description => 'Copier les logs de l\'application dans le presse-papiers';

  @override
  String get settings_export_logs => 'Exporter les logs';

  @override
  String get settings_export_logs_description => 'Exporter les logs de l\'application vers un fichier texte';

  @override
  String get settings_about => 'À propos';

  @override
  String get settings_about_description => 'Informations, liens, dons';

  @override
  String get settings_about_application => 'Application';

  @override
  String get settings_build_mode => 'Build mode';

  @override
  String get settings_build_mode_release => 'Production';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => 'Liens';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Jeter un coup d\'œil au code source';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Ajouter ou améliorer les traductions sur le projet Crowdin';

  @override
  String get settings_licence => 'License';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Faire un don';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Titre';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Lien';

  @override
  String get hint_label_name => 'Nom';

  @override
  String get dialog_export_encryption_password => 'Mot de passe';

  @override
  String get dialog_select_labels => 'Sélectionner les étiquettes';

  @override
  String get dialog_select_labels_to_add => 'Sélectionner les étiquettes à ajouter';

  @override
  String get tooltip_undo => 'Annuler la dernière action';

  @override
  String get tooltip_redo => 'Rétablir la dernière action';

  @override
  String get tooltip_fab_add_note => 'Ajouter une note';

  @override
  String get tooltip_fab_add_plain_text_note => 'Ajouter une note de texte brut';

  @override
  String get tooltip_fab_add_markdown_note => 'Ajouter une note en markdown';

  @override
  String get tooltip_fab_add_rich_text_note => 'Ajouter une note de texte riche';

  @override
  String get tooltip_fab_add_checklist_note => 'Ajouter une note de liste de contrôle';

  @override
  String get tooltip_fab_add_label => 'Ajouter un libellé';

  @override
  String get tooltip_fab_empty_bin => 'Vider la corbeille';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Basculer en mode édition';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Basculer en mode lecture';

  @override
  String get tooltip_layout_list => 'Vue en liste';

  @override
  String get tooltip_layout_grid => 'Vue en grille';

  @override
  String get tooltip_sort => 'Trier les notes';

  @override
  String get tooltip_search => 'Rechercher parmi les notes';

  @override
  String get tooltip_unselect_all => 'Tout déselectionner';

  @override
  String get tooltip_reset => 'Réinitialiser';

  @override
  String get dialog_add_link => 'Ajouter un lien';

  @override
  String get dialog_archive => 'Archiver';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Voulez-vous vraiment archiver $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Désarchiver';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Voulez-vous vraiment désarchiver $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Supprimer';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'les', one: 'la');
    return 'Voulez-vous vraiment supprimer $count $_temp0 ? Vous pouvez $_temp1 restaurer depuis la corbeille.';
  }

  @override
  String get dialog_permanently_delete => 'Supprimer définitivement';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'les', one: 'la');
    return 'Voulez-vous vraiment supprimer définitivement $count $_temp0 ? Vous ne pourrez pas $_temp1 restaurer.';
  }

  @override
  String get dialog_restore => 'Restaurer';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Voulez-vous vraiment restaurer $count $_temp0 ?';
  }

  @override
  String get dialog_empty_bin => 'Vider la corbeille';

  @override
  String get dialog_empty_bin_body =>
      'Voulez-vous vraiment vider définitivement la corbeille ? Vous ne pourrez pas restaurer les notes qu\'elle contient.';

  @override
  String get dialog_delete_label => 'Supprimer';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'étiquettes', one: 'étiquette');
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Elles seront retirées',
      one: 'Elle sera retirée',
    );
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'les avez ajoutées',
      one: 'l\'avez ajoutée',
    );
    return 'Voulez-vous vraiment supprimer $count $_temp0 ? $_temp1 des notes auxquelles vous $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'Chiffrer l\'export JSON';

  @override
  String get dialog_export_encryption_description =>
      'Le titre et le contenu des notes seront chiffrés à laide de votre mot de passe. Il devrait être généré de façon aléatoire, dexactement 32 caractères de long, fort (au moins 1 minuscule, 1 majuscule, 1 chiffre et 1 caractère spécial) et stocké de manière sécurisée.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Ce mot de passe sera utilisé pour tous les futurs exports automatiques.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Ce mot de passe ne sera utilisé que pour cet export.';

  @override
  String get dialog_export_encryption_password_invalid => 'Invalide';

  @override
  String get dialog_import_encryption_password_description =>
      'Cet export est chiffré. Pour l\'importer, vous devez fournir le mot de passe utilisé pour le chiffrer.';

  @override
  String get dialog_import_encryption_password_error =>
      'le déchiffrement de l\'export a échoué. Veuillez vérifier que vous avez fourni le même mot de passe que celui que vous avez utilisé pour chiffrer l\'export.';

  @override
  String get dialog_label_add => 'Ajouter une étiquette';

  @override
  String get dialog_label_edit => 'Modifier l\'étiquette';

  @override
  String get dialog_label_name_cannot_be_empty => 'Le nom ne peut pas être vide.';

  @override
  String get dialog_label_name_already_used => 'Ce nom est déjà utilisé.';

  @override
  String get button_sort_creation_date => 'Date de création';

  @override
  String get button_sort_edition_date => 'Date d\'édition';

  @override
  String get placeholder_notes => 'Pas de notes';

  @override
  String get placeholder_labels => 'Aucune étiquette';

  @override
  String get placeholder_archives => 'Aucune note archivée';

  @override
  String get placeholder_bin => 'Aucune note supprimée';

  @override
  String get action_disabled => 'Désactivé';

  @override
  String get action_toggle_pin => 'Basculer les épingles';

  @override
  String get action_pin_unpin => 'Épingler / Désépingler';

  @override
  String get action_pin => 'Épingler';

  @override
  String get action_unpin => 'Désépingler';

  @override
  String get action_toggle_lock => 'Basculer le verrouillage';

  @override
  String get action_lock_unlock => 'Verrouiller / Déverrouiller';

  @override
  String get action_lock => 'Verrouiller';

  @override
  String get action_unlock => 'Déverrouiller';

  @override
  String get action_share => 'Partager';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes partagées', one: 'note partagée');
    return '$count $_temp0 à partir de Material Notes';
  }

  @override
  String get action_archive => 'Archiver';

  @override
  String get action_unarchive => 'Désarchiver';

  @override
  String get action_delete => 'Supprimer';

  @override
  String get action_restore => 'Restaurer';

  @override
  String get action_delete_permanently => 'Supprimer définitivement';

  @override
  String get action_about => 'À propos';

  @override
  String get about_last_edited => 'Dernière modification';

  @override
  String get about_type => 'Type';

  @override
  String get about_created => 'Création';

  @override
  String get about_labels => 'Libellés';

  @override
  String get about_words => 'Mots';

  @override
  String get about_characters => 'Caractères';

  @override
  String get about_time_at => 'à';

  @override
  String get menu_action_select_labels => 'Libellés';

  @override
  String get menu_action_add_labels => 'Ajouter des libellés';

  @override
  String get action_labels_toggle_visibile => 'Basculer la visibilité';

  @override
  String get action_labels_show_hide => 'Afficher / Masquer';

  @override
  String get action_labels_show => 'Afficher';

  @override
  String get action_labels_hide => 'Masquer';

  @override
  String get action_labels_toggle_pins => 'Basculer les épingles';

  @override
  String get action_labels_pin_unpin => 'Épingler / Désépingler';

  @override
  String get action_labels_pin => 'Épingler';

  @override
  String get action_labels_unpin => 'Désépingler';

  @override
  String get action_labels_toggle_lock => 'Basculer le verrouillage';

  @override
  String get action_labels_lock_unlock => 'Verrouiller / Déverrouiller';

  @override
  String get action_labels_lock => 'Verrouiller';

  @override
  String get action_labels_unlock => 'Déverrouiller';

  @override
  String get action_labels_edit => 'Modifier';

  @override
  String get action_labels_delete => 'Supprimer';

  @override
  String get filter_labels_all => 'Tous';

  @override
  String get filter_labels_visible => 'Visibles';

  @override
  String get filter_labels_hidden => 'Masqués';

  @override
  String get filter_labels_pinned => 'Épinglés';

  @override
  String get filter_labels_locked => 'Verrouillé';

  @override
  String get snack_bar_authentication_failed => 'L\'authentification a échoué, veuillez réessayer.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Les notes ont été archivées',
      one: 'La note a été archivée',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Les notes ont été désarchivées',
      one: 'La note a été désarchivée',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Les notes ont été supprimées',
      one: 'La note a été supprimée',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Les notes ont été restaurées',
      one: 'La note a été restaurée',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'des notes', one: 'de la note');
    return 'Contenu $_temp0 copié dans le presse-papiers.';
  }

  @override
  String get snack_bar_import_success => 'La sauvegarde a été importée avec succès.';

  @override
  String get snack_bar_export_success => 'La sauvegarde a été exportée avec succès.';

  @override
  String get snack_bar_logs_copied => 'Les logs ont été copiés dans votre presse-papiers.';

  @override
  String get snack_bar_logs_exported => 'Les logs ont été exportés avec succès.';

  @override
  String get snack_bar_no_labels => 'Il n\'y a aucune étiquette.';

  @override
  String get quick_action_add_plain_text_note_title => 'Ajouter une note de texte brut';

  @override
  String get quick_action_add_markdown_note_title => 'Ajouter une note en markdown';

  @override
  String get quick_action_add_rich_text_note_title => 'Ajouter une note de texte riche';

  @override
  String get quick_action_add_checklist_note_title => 'Ajouter une note de liste de contrôle';

  @override
  String get welcome_note_title => 'Bienvenue dans Material Notes !';

  @override
  String get welcome_note_content => 'Notes simples, locales, en material design';

  @override
  String get font_system_default => 'Valeur par défaut du système';

  @override
  String get note_type_plain_text => 'Texte brut';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Texte riche';

  @override
  String get note_type_checklist => 'Liste de contrôle';

  @override
  String get lock_page_reason_app => 'Déverrouiller Material Notes';

  @override
  String get lock_page_reason_note => 'Déverrouiller cette note';

  @override
  String get lock_page_reason_action => 'Autoriser cette action';

  @override
  String get lock_page_description_app => 'L\'application est verrouillée.';

  @override
  String get lock_page_description_note => 'Cette note est verrouillée.';

  @override
  String get lock_page_unlock => 'Déverrouiller';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Couleur de premier plan';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Couleur d\'arrière-plan';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Couleur de premier plan';

  @override
  String get toolbar_style_one_row_simple_title => 'Une ligne (options simples)';

  @override
  String get toolbar_style_one_row_simple_description => 'Seulement les options de formatage simples sur une ligne';

  @override
  String get toolbar_style_one_row_all_title => 'Une ligne (toutes les options)';

  @override
  String get toolbar_style_one_row_all_description => 'Toutes les options de formatage sur une ligne';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Deux lignes (empilées)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'Toutes les options de formatage sur deux lignes empilées';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Deux lignes (basculables)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'Toutes les options de formatage sur deux lignes basulables';

  @override
  String get settings_confirm_before_exiting_title => 'Confirmer avant de quitter';

  @override
  String get settings_confirm_before_exiting_description => 'Demander une confirmation avant de quitter l\'application';

  @override
  String get snack_bar_confirm_exiting => 'Appuyez à nouveau sur retour pour quitter l\'application.';
}
