// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Notas simples, locales, en Material Design';

  @override
  String app_about(String appName) {
    return '$appName es una aplicación de toma de notas basadas en texto, orientada a la simplicidad, diseñada adoptando Material Design. $appName almacena las notas localmente y no requiere ningún permiso de internet, siendo tú el único que puede acceder a las notas.';
  }

  @override
  String get error_snack_bar => 'Error:';

  @override
  String get error_widget_title => 'Ha ocurrido un error.';

  @override
  String get error_widget_description =>
      'Informa de este problema en GitHub o por correo. Adjunta una captura de pantalla de esta página y los registros que puedes copiar o exportar a continuación. Como precaución, también debes exportar tus notas.';

  @override
  String get error_widget_disabled_secure_flag =>
      'La configuración para marcar la aplicación como segura está desactivada hasta el próximo reinicio para habilitar las capturas de pantalla.';

  @override
  String get error_widget_button_export_notes => 'Exportar notas';

  @override
  String get error_widget_button_copy_logs => 'Copiar registros';

  @override
  String get error_widget_button_export_logs => 'Exportar registros';

  @override
  String get error_widget_button_create_github_issue => 'Crear un problema en GitHub';

  @override
  String get error_widget_button_send_mail => 'Enviar correo electrónico';

  @override
  String get navigation_notes => 'Notas';

  @override
  String get navigation_manage_labels_destination => 'Administrar etiquetas';

  @override
  String get navigation_manage_labels_page => 'Etiquetas';

  @override
  String get navigation_archives => 'Archivos';

  @override
  String get navigation_bin => 'Papelera';

  @override
  String get navigation_settings => 'Ajustes';

  @override
  String get navigation_settings_appearance => 'Apariencia';

  @override
  String get navigation_settings_notes_types => 'Tipos de notas';

  @override
  String get navigation_settings_notes_tiles => 'Tarjetas de las notas';

  @override
  String get navigation_settings_behavior => 'Comportamiento';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Etiquetas';

  @override
  String get navigation_settings_backup => 'Copia de seguridad';

  @override
  String get navigation_settings_security => 'Seguridad';

  @override
  String get navigation_settings_accessibility => 'Accesibilidad';

  @override
  String get navigation_settings_help => 'Ayuda';

  @override
  String get navigation_settings_about => 'Acerca de';

  @override
  String get button_sort_title => 'Título';

  @override
  String get button_sort_ascending => 'Ascendente';

  @override
  String get settings_page_appearance => 'Apariencia';

  @override
  String get settings_page_appearance_description => 'Idioma, temas, fuentes';

  @override
  String get settings_language => 'Idioma';

  @override
  String get settings_language_contribute => 'Contribuir';

  @override
  String get settings_appearance_section_theming => 'Tematización';

  @override
  String get settings_theme => 'Tema';

  @override
  String get settings_theme_system => 'Sistema';

  @override
  String get settings_theme_light => 'Claro';

  @override
  String get settings_theme_dark => 'Oscuro';

  @override
  String get settings_dynamic_theming => 'Tema dinámico';

  @override
  String get settings_dynamic_theming_description => 'Generar colores desde el sistema';

  @override
  String get settings_black_theming => 'Negro puro';

  @override
  String get settings_black_theming_description => 'Fondo negro puro para el tema oscuro';

  @override
  String get settings_appearance_section_fonts => 'Fuentes';

  @override
  String get settings_app_font => 'Fuente de la aplicación';

  @override
  String get settings_app_font_description =>
      'Fuente utilizada para todos los textos de la aplicación, excepto en el editor de notas';

  @override
  String get settings_editor_font => 'Fuente del editor';

  @override
  String get settings_editor_font_description => 'Fuente utilizada sólo para el texto en el editor de notas';

  @override
  String get settings_page_notes_tiles => 'Tarjetas de las notas';

  @override
  String get settings_page_notes_tiles_description => 'Apariencia, contenido';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Apariencia';

  @override
  String get settings_page_notes_tiles_content_section => 'Contenido';

  @override
  String get settings_show_tiles_background => 'Fondo';

  @override
  String get settings_show_tiles_background_description => 'Muestra el fondo de tarjetas en las notas';

  @override
  String get settings_show_separators => 'Separadores';

  @override
  String get settings_show_separators_description => 'Mostrar un separador entre las notas';

  @override
  String get settings_show_note_type_icon => 'Mostrar icono de tipo';

  @override
  String get settings_show_note_type_icon_description => 'Mostrar el icono del tipo de nota';

  @override
  String get settings_show_titles_only => 'Sólo títulos';

  @override
  String get settings_show_titles_only_description => 'Sólo mostrar los títulos de las notas';

  @override
  String get settings_show_titles_only_disable_in_search_view => 'Deshabilitar mostrar solo los títulos en la búsqueda';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Deshabilitar la opción de sólo mostrar los títulos cuando se muestra la vista de búsqueda';

  @override
  String get settings_content_preview_max_lines => 'Máximas líneas en la vista previa';

  @override
  String get settings_content_preview_max_lines_description =>
      'Número máximo de líneas a mostrar en la vista previa del contenido';

  @override
  String get settings_behavior => 'Comportamiento';

  @override
  String get settings_behavior_description => 'Confirmaciones, deslizar acciones';

  @override
  String get settings_behavior_application => 'Aplicación';

  @override
  String get settings_confirmations => 'Diálogo de confirmación';

  @override
  String get settings_confirmations_description =>
      'Cuándo mostrar un cuadro de diálogo de confirmación al realizar una acción en una nota';

  @override
  String get settings_confirmations_title_none => 'Nunca';

  @override
  String get settings_confirmations_title_irreversible => 'En acciones irreversibles';

  @override
  String get settings_confirmations_title_all => 'Siempre';

  @override
  String get settings_auto_remove_from_bin_title => 'Autoeliminar de la papelera';

  @override
  String get settings_auto_remove_from_bin_description => 'Quitar automáticamente las notas de la papelera';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'Después de 1 semana',
      '14': 'Después de 2 semanas',
      '30': 'Después de 1 mes',
      '90': 'Después de 3 meses',
      '180': 'Después de 6 meses',
      '365': 'Después de 1 año',
      'other': 'Nunca',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Acciones de deslizamiento';

  @override
  String get settings_behavior_swipe_actions_archives => 'Deslizar acciones (archivos)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Acciones de deslizamiento (papelera)';

  @override
  String get settings_swipe_action_right => 'Deslizar a la derecha';

  @override
  String get settings_swipe_action_right_description =>
      'Acción a realizar al deslizar a la derecha la tarjeta se una nota';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Acción a realizar cuando se desliza a la derecha la tarjeta de una nota en la papelera';

  @override
  String get settings_swipe_action_left => 'Desliza a la izquierda';

  @override
  String get settings_swipe_action_left_description =>
      'Acción a realizar al deslizar a la izquierda la tarjeta de una nota';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Acción a realizar al deslizar a la izquierda la tarjeta de una nota';

  @override
  String get settings_page_notes_types => 'Tipos de notas';

  @override
  String get settings_page_notes_types_description => 'Tipos a utilizar, texto enriquecido';

  @override
  String get settings_section_types_to_use => 'Tipos a utilizar';

  @override
  String get settings_available_notes_types => 'Tipos de notas disponibles';

  @override
  String get settings_available_notes_types_description =>
      'La lista de tipos de notas que se pueden crear con el botón \"Añadir\" de la página de notas. Al eliminar un tipo, las notas ya existentes con ese tipo no se borran y se pueden seguir utilizando con normalidad';

  @override
  String get settings_available_default_share_type => 'Tipo de acción predeterminado';

  @override
  String get settings_available_default_share_type_description =>
      'El tipo de nota por defecto a usar al crear una nota desde una acción compartida. Puede ser un tipo que no esté disponible desde el botón \"Añadir\"';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Conducta';

  @override
  String get settings_editor_behavior => 'Comportamiento';

  @override
  String get settings_show_editor_mode_button => 'Botón del modo editor';

  @override
  String get settings_show_editor_mode_button_description =>
      'Activar el botón para cambiar el editor entre el modo de edición y el modo de lectura';

  @override
  String get settings_open_editor_reading_mode => 'Abrir en modo de lectura';

  @override
  String get settings_open_editor_reading_mode_description => 'Abrir el editor en modo de lectura por defecto';

  @override
  String get settings_focus_title_on_new_note => 'Enfocar el título';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Enfocar el título en lugar del contenido cuando se crea una nueva nota';

  @override
  String get settings_editor_appearance => 'Apariencia';

  @override
  String get settings_toolbar_style_title => 'Estilo de barra de herramientas';

  @override
  String get settings_toolbar_style_description =>
      'El estilo de la barra de herramientas del editor de texto enriquecido';

  @override
  String get settings_use_paragraph_spacing => 'Espacio entre párrafos';

  @override
  String get settings_use_paragraph_spacing_description => 'Usar espaciado entre párrafos';

  @override
  String get settings_labels => 'Etiquetas';

  @override
  String get settings_labels_description => 'Habilitar, apariencia';

  @override
  String get settings_enable_labels => 'Habilitar';

  @override
  String get settings_enable_labels_description =>
      'Permitir categorizar las notas con etiquetas (deshabilitarlo no elimina etiquetas ni las elimina de las notas, solo las oculta)';

  @override
  String get settings_labels_appearance => 'Apariencia';

  @override
  String get settings_show_labels_note_tile => 'Mostrar etiquetas en el título de las notas';

  @override
  String get settings_show_labels_note_tile_description => 'Mostrar la lista de etiquetas en los títulos de las notas';

  @override
  String get settings_show_labels_editor => 'Mostrar las etiquetas en el editor';

  @override
  String get settings_show_labels_editor_description => 'Muestra la lista de etiquetas en la parte inferior del editor';

  @override
  String get settings_labels_section_behavior => 'Comportamiento';

  @override
  String get settings_labels_swipe_action_right => 'Deslizar a la derecha';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Acción que se activa al deslizar hacia la derecha sobre un mosaico de etiqueta';

  @override
  String get settings_labels_swipe_action_left => 'Deslizar a la izquierda';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Acción que se activa cuando se desliza el dedo hacia la izquierda sobre un mosaico de etiqueta';

  @override
  String get settings_backup => 'Respaldo';

  @override
  String get settings_backup_description => 'Exportación manual y automática, cifrado, importación';

  @override
  String get settings_backup_import => 'Importar';

  @override
  String get settings_import => 'Importar';

  @override
  String get settings_import_description => 'Importar notas, etiquetas y configuraciones desde un archivo JSON';

  @override
  String get settings_backup_manual_export => 'Exportar manualmente';

  @override
  String get settings_export_json => 'Exportar a JSON';

  @override
  String get settings_export_json_description =>
      'Exporta inmediatamente todas las notas, etiquetas y ajustes a un archivo JSON que puede ser importado de vuelta';

  @override
  String get settings_export_markdown => 'Exportar a Markdown';

  @override
  String get settings_export_markdown_description => 'Exportar inmediatamente todas las notas a un archivo Markdown';

  @override
  String get settings_backup_auto_export => 'Exportación automática';

  @override
  String get settings_auto_export => 'Exportación automática';

  @override
  String get settings_auto_export_description =>
      'Exportar automáticamente todas las notas, etiquetas y ajustes a un archivo JSON que se puede importar de vuelta';

  @override
  String get settings_auto_export_frequency => 'Frecuencia';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'día',
      '7': 'semana',
      '14': '2 semanas',
      '30': 'mes',
      'other': '',
    });
    return 'Cada $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Frecuencia de la exportación automática';

  @override
  String get settings_auto_export_encryption => 'Encriptación';

  @override
  String get settings_auto_export_encryption_description =>
      'Encriptar el título y el contenido de las notas con una contraseña';

  @override
  String get settings_auto_export_directory => 'Directorio';

  @override
  String get settings_auto_export_directory_description => 'Directorio donde almacenar las exportaciones automáticas';

  @override
  String get settings_security => 'Seguridad';

  @override
  String get settings_security_description => 'Bandera segura, bloqueo de la aplicación, bloqueo de notas';

  @override
  String get settings_security_application => 'Aplicación';

  @override
  String get settings_security_application_lock => 'Bloqueo de la aplicación';

  @override
  String get settings_security_note_lock => 'Bloqueo de nota';

  @override
  String get settings_flag_secure => 'Marcar la aplicación cómo segura';

  @override
  String get settings_flag_secure_description =>
      'Oculta la aplicación de las aplicaciones recientes y previene que se realicen capturas de pantalla';

  @override
  String get settings_application_lock_title => 'Bloquear';

  @override
  String get settings_application_lock_description =>
      'Bloquea la aplicación y requiere autentificarse con el dispositivo para desbloquearla';

  @override
  String get settings_application_lock_delay_title => 'Retardo de bloqueo';

  @override
  String get settings_application_lock_delay_description =>
      'Retraso tras el cual la aplicación se bloquea automáticamente cuando se mueve al segundo plano';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Inmediatamente',
      '3': 'Después de 3 segundos',
      '5': 'Después de 5 segundos',
      '10': 'Después de 10 segundos',
      '30': 'Después de 30 segundos',
      '60': 'Después de 1 minuto',
      '120': 'Después de 2 minutos',
      '300': 'Después de 5 minutos',
      'other': 'Nunca',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Bloqueo de nota';

  @override
  String get settings_note_lock_description =>
      'Bloquea la nota y requiere autenticarse con el dispositivo para verla y editarla';

  @override
  String get settings_label_lock_title => 'Bloqueo de etiqueta';

  @override
  String get settings_label_lock_description =>
      'Bloquea la etiqueta y requiere autenticarse con el dispositivo para ver y editar cualquier nota que la contenga';

  @override
  String get settings_note_lock_delay_title => 'Retardo de bloqueo';

  @override
  String get settings_note_lock_delay_description =>
      'Retraso tras el cual la nota se bloquea automáticamente cuando la aplicación pasa a segundo plano';

  @override
  String get settings_accessibility => 'Accesibilidad';

  @override
  String get settings_accessibility_text_size => 'Tamaño del texto';

  @override
  String get settings_accessibility_text_color => 'Color del texto';

  @override
  String get settings_accessibility_description => 'Color de texto, escala del texto';

  @override
  String get settings_text_scaling => 'Escala del texto';

  @override
  String get settings_bigger_titles => 'Títulos grandes';

  @override
  String get settings_bigger_titles_description =>
      'Mostrar títulos más grandes en los azulejos de notas y en el editor';

  @override
  String get settings_white_text_dark_mode => 'Texto blanco en el modo oscuro';

  @override
  String get settings_white_text_dark_mode_description => 'Usar un color blanco para el texto en modo oscuro';

  @override
  String get settings_disable_subdued_note_content_preview => 'No subrayado en vista previa';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Desactiva el color de texto subrayado de la vista previa del contenido de las notas';

  @override
  String get settings_help_section_contact => 'Contacto';

  @override
  String get settings_github_issues => 'Reporta errores o solicita nuevas características';

  @override
  String get settings_github_issues_description =>
      'Reportar un error o solicitar una característica creando un problema de GitHub';

  @override
  String get settings_github_discussions => 'Hacer una pregunta';

  @override
  String get settings_github_discussions_description => 'Hacer una pregunta en las discusiones de GitHub';

  @override
  String get settings_contact_developer => 'Contactar con el desarrollador';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Póngase en contacto con el desarrollador por correo electrónico en $email';
  }

  @override
  String get settings_help => 'Ayuda';

  @override
  String get settings_help_description => 'Contacto, registros';

  @override
  String get settings_help_section_logs => 'Registros';

  @override
  String get settings_copy_logs => 'Copiar registros';

  @override
  String get settings_copy_logs_description => 'Copia los registros de la aplicación al portapapeles';

  @override
  String get settings_export_logs => 'Exportar los registros';

  @override
  String get settings_export_logs_description => 'Exporta los registros de la aplicación a un archivo de texto';

  @override
  String get settings_about => 'Acerca de';

  @override
  String get settings_about_description => 'Información, enlaces, donar';

  @override
  String get settings_about_application => 'Aplicación';

  @override
  String get settings_build_mode => 'Modo de compilación';

  @override
  String get settings_build_mode_release => 'Versión';

  @override
  String get settings_build_mode_debug => 'Depuración';

  @override
  String get settings_about_links => 'Enlaces';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Da un vistazo al código fuente';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Añade o mejora las localizaciones en el proyecto Crowdin';

  @override
  String get settings_licence => 'Licencia';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donar';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Título';

  @override
  String get hint_content => 'Nota';

  @override
  String get hint_link => 'Enlace';

  @override
  String get hint_label_name => 'Nombre';

  @override
  String get dialog_export_encryption_password => 'Contraseña';

  @override
  String get dialog_select_labels => 'Seleccionar etiquetas';

  @override
  String get dialog_select_labels_to_add => 'Seleccionar etiquetas a añadir';

  @override
  String get tooltip_undo => 'Deshacer la última acción';

  @override
  String get tooltip_redo => 'Rehacer la última acción';

  @override
  String get tooltip_fab_add_note => 'Agregar una nota';

  @override
  String get tooltip_fab_add_plain_text_note => 'Añadir una nota de texto plano';

  @override
  String get tooltip_fab_add_markdown_note => 'Añadir una nota de Markdown';

  @override
  String get tooltip_fab_add_rich_text_note => 'Añadir una nota de texto enriquecido';

  @override
  String get tooltip_fab_add_checklist_note => 'Añadir una nota de lista de verificación';

  @override
  String get tooltip_fab_add_label => 'Añadir etiqueta';

  @override
  String get tooltip_fab_empty_bin => 'Vaciar la papelera';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Cambiar al modo de edición';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Cambiar al modo de lectura';

  @override
  String get tooltip_layout_list => 'Vista en lista';

  @override
  String get tooltip_layout_grid => 'Vista en cuadrícula';

  @override
  String get tooltip_sort => 'Ordenar las notas';

  @override
  String get tooltip_search => 'Buscar entre las notas';

  @override
  String get tooltip_unselect_all => 'Deseleccionar todo';

  @override
  String get tooltip_reset => 'Restablecer';

  @override
  String get dialog_add_link => 'Agregar un vínculo';

  @override
  String get dialog_archive => 'Archivar';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    return '¿Realmente quieres restaurar $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Des archivar';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    return '¿Realmente quieres restaurar $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Eliminar';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'las', one: 'la');
    return '¿Realmente quieres eliminar $count $_temp0? ¡Puedes restaurar$_temp1 de la papelera.';
  }

  @override
  String get dialog_permanently_delete => 'Eliminar permanentemente';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'las', one: 'la');
    return '¿Realmente quieres eliminar permanentemente $count $_temp0? No podrás restaurar$_temp1.';
  }

  @override
  String get dialog_restore => 'Restaurar';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    return '¿Realmente quieres restaurar $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Vaciar la papelera';

  @override
  String get dialog_empty_bin_body =>
      '¿Realmente quieres restaurar la papelera? No podrás restaurar las notas en ella.';

  @override
  String get dialog_delete_label => 'Eliminar';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'etiquetas', one: 'etiqueta');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'Estas', one: 'Esta');
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: '');
    return '¿Estás seguro de que quieres eliminar $count $_temp0? $_temp1 serán removidas de las notas donde las agregaste$_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'Encriptar la exportación JSON';

  @override
  String get dialog_export_encryption_description =>
      'El título y el contenido de las notas serán cifrados usando su contraseña. Debe ser generado aleatoriamente, exactamente 32 caracteres de largo, fuerte (al menos 1 minúscula, 1 mayúscula, 1 número y 1 carácter especial) y almacenado de forma segura.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Esta contraseña se utilizará para todas las exportaciones automáticas futuras.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Esta contraseña sólo se usará para esta exportación.';

  @override
  String get dialog_export_encryption_password_invalid => 'Inválido';

  @override
  String get dialog_import_encryption_password_description =>
      'Esta exportación está encriptada. Para importarla, necesita proporcionar la contraseña utilizada para encriptarla.';

  @override
  String get dialog_import_encryption_password_error =>
      'el desencriptado de la exportación falló. Por favor, compruebe que proporcionó la misma contraseña que la que utilizó para encriptar la exportación.';

  @override
  String get dialog_label_add => 'Añadir etiqueta';

  @override
  String get dialog_label_edit => 'Editar etiqueta';

  @override
  String get dialog_label_name_cannot_be_empty => 'El nombre no puede estar vacío.';

  @override
  String get dialog_label_name_already_used => 'Este nombre ya está en uso.';

  @override
  String get button_sort_creation_date => 'Fecha de creación';

  @override
  String get button_sort_edition_date => 'Fecha de modificación';

  @override
  String get placeholder_notes => 'No hay notas';

  @override
  String get placeholder_labels => 'Sin etiquetas';

  @override
  String get placeholder_archives => 'No hay notas archivadas';

  @override
  String get placeholder_bin => 'No hay notas eliminadas';

  @override
  String get action_disabled => 'Desactivado';

  @override
  String get action_toggle_pin => 'Alternar fijado';

  @override
  String get action_pin_unpin => 'Fijar / Desfijar';

  @override
  String get action_pin => 'Fijar';

  @override
  String get action_unpin => 'Desfijar';

  @override
  String get action_toggle_lock => 'Alternar bloqueo';

  @override
  String get action_lock_unlock => 'Bloquear / Desbloquear';

  @override
  String get action_lock => 'Bloquear';

  @override
  String get action_unlock => 'Desbloquear';

  @override
  String get action_share => 'Compartir';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    return '$count $_temp0 compartidas de Notas Material';
  }

  @override
  String get action_archive => 'Archivar';

  @override
  String get action_unarchive => 'Des archivar';

  @override
  String get action_delete => 'Eliminar';

  @override
  String get action_restore => 'Restaurar';

  @override
  String get action_delete_permanently => 'Eliminar permanentemente';

  @override
  String get action_about => 'Acerca de';

  @override
  String get about_last_edited => 'Última edición';

  @override
  String get about_type => 'Tipo';

  @override
  String get about_created => 'Creación';

  @override
  String get about_labels => 'Etiquetas';

  @override
  String get about_words => 'Palabras';

  @override
  String get about_characters => 'Caracteres';

  @override
  String get about_time_at => 'a las';

  @override
  String get menu_action_select_labels => 'Etiquetas';

  @override
  String get menu_action_add_labels => 'Añadir etiquetas';

  @override
  String get action_labels_toggle_visibile => 'Alternar visibilidad';

  @override
  String get action_labels_show_hide => 'Mostrar / Ocultar';

  @override
  String get action_labels_show => 'Mostrar';

  @override
  String get action_labels_hide => 'Ocultar';

  @override
  String get action_labels_toggle_pins => 'Alternar fijado';

  @override
  String get action_labels_pin_unpin => 'Fijar / Desfijar';

  @override
  String get action_labels_pin => 'Fijar';

  @override
  String get action_labels_unpin => 'Desfijar';

  @override
  String get action_labels_toggle_lock => 'Alternar bloqueo';

  @override
  String get action_labels_lock_unlock => 'Bloquear / Desbloquear';

  @override
  String get action_labels_lock => 'Bloquear';

  @override
  String get action_labels_unlock => 'Desbloquear';

  @override
  String get action_labels_edit => 'Editar';

  @override
  String get action_labels_delete => 'Eliminar';

  @override
  String get filter_labels_all => 'Todas';

  @override
  String get filter_labels_visible => 'Visible';

  @override
  String get filter_labels_hidden => 'Ocultas';

  @override
  String get filter_labels_pinned => 'Fijadas';

  @override
  String get filter_labels_locked => 'Bloqueado';

  @override
  String get snack_bar_authentication_failed => 'La autenticación ha fallado por favor inténtelo de nuevo.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'han sido', one: 'han sido');
    return 'La/las notas $_temp0 archivadas';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'han sido', one: 'han sido');
    return 'La/las notas $_temp0 des archivadas';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'han sido', one: 'han sido');
    return 'La/las notas $_temp0 eliminadas';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'han sido', one: 'han sido');
    return 'La/las notas $_temp0 restauradas';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notas', one: 'nota');
    return 'Contenido de $_temp0 copiado al portapapeles.';
  }

  @override
  String get snack_bar_import_success => 'La copia de seguridad se ha importado correctamente.';

  @override
  String get snack_bar_export_success => 'La copia de seguridad se ha exportado correctamente.';

  @override
  String get snack_bar_logs_copied => 'Los registros han sido copiados al portapapeles.';

  @override
  String get snack_bar_logs_exported => 'Los registros se exportaron correctamente.';

  @override
  String get snack_bar_no_labels => 'No hay etiquetas.';

  @override
  String get quick_action_add_plain_text_note_title => 'Añadir una nota de texto plano';

  @override
  String get quick_action_add_markdown_note_title => 'Añadir una nota de Markdown';

  @override
  String get quick_action_add_rich_text_note_title => 'Añadir una nota de texto enriquecido';

  @override
  String get quick_action_add_checklist_note_title => 'Añadir una nota de lista de verificación';

  @override
  String get welcome_note_title => 'Bienvenido a Material Notes !';

  @override
  String get welcome_note_content => 'Notas simples, locales, en Material Design';

  @override
  String get font_system_default => 'Predeterminado del sistema';

  @override
  String get note_type_plain_text => 'Texto sin formato';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Texto enriquecido';

  @override
  String get note_type_checklist => 'Lista de verificación';

  @override
  String get lock_page_reason_app => 'Desbloquear Notas Material';

  @override
  String get lock_page_reason_note => 'Desbloquear esta nota';

  @override
  String get lock_page_reason_action => 'Autorizar esta acción';

  @override
  String get lock_page_description_app => 'La aplicación está bloqueada.';

  @override
  String get lock_page_description_note => 'Esta nota está bloqueada.';

  @override
  String get lock_page_unlock => 'Desbloquear';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Color de primer plano';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Color de fondo';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Color de primer plano';

  @override
  String get toolbar_style_one_row_simple_title => 'Una fila (opciones simples)';

  @override
  String get toolbar_style_one_row_simple_description => 'Sólo opciones de formato simples en una fila';

  @override
  String get toolbar_style_one_row_all_title => 'Una fila (todas las opciones)';

  @override
  String get toolbar_style_one_row_all_description => 'Todas las opciones de formato en una fila';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Dos filas (apilado)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'Todas las opciones de formato en dos filas apiladas';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Dos filas (activable)';

  @override
  String get toolbar_style_two_rows_toggleable_description => 'Todas las opciones de formato en dos filas conmutables';

  @override
  String get settings_confirm_before_exiting_title => 'Confirmar antes de salir';

  @override
  String get settings_confirm_before_exiting_description => 'Solicitar confirmación antes de salir de la aplicación';

  @override
  String get snack_bar_confirm_exiting => 'Presione atrás otra vez para salir de la aplicación.';
}
