// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => '简单、本地、Material 设计笔记';

  @override
  String app_about(String appName) {
    return '$appName 是基于文本的笔记应用程序，旨在简单，采用 Material 设计。它在本地存储笔记，并且没有任何互联网权限，因此只有您可以访问笔记。';
  }

  @override
  String get error_snack_bar => '错误：';

  @override
  String get error_widget_title => '发生了一个错误。';

  @override
  String get error_widget_description => '请在 GitHub 上或通过邮件报告此问题。附上此页面的屏幕截图以及您在下方复制或导出的日志。作为预防措施，您还应该导出您的笔记。';

  @override
  String get error_widget_disabled_secure_flag => '禁用将应用标记为安全的设置，直到下次重启才能启用截屏。';

  @override
  String get error_widget_button_export_notes => '导出笔记';

  @override
  String get error_widget_button_copy_logs => '复制日志';

  @override
  String get error_widget_button_export_logs => '导出日志';

  @override
  String get error_widget_button_create_github_issue => '创建 GitHub 问题';

  @override
  String get error_widget_button_send_mail => '发送邮件';

  @override
  String get navigation_notes => '笔记';

  @override
  String get navigation_manage_labels_destination => '管理标签';

  @override
  String get navigation_manage_labels_page => '标签';

  @override
  String get navigation_archives => '归档';

  @override
  String get navigation_bin => '回收站';

  @override
  String get navigation_settings => '设置';

  @override
  String get navigation_settings_appearance => '外观';

  @override
  String get navigation_settings_notes_types => '笔记类型';

  @override
  String get navigation_settings_notes_tiles => '笔记磁贴';

  @override
  String get navigation_settings_behavior => '行为';

  @override
  String get navigation_settings_editor => '编辑器';

  @override
  String get navigation_settings_labels => '标签';

  @override
  String get navigation_settings_backup => '备份';

  @override
  String get navigation_settings_security => '安全';

  @override
  String get navigation_settings_accessibility => '无障碍';

  @override
  String get navigation_settings_help => '帮助';

  @override
  String get navigation_settings_about => '关于';

  @override
  String get button_sort_title => '标题';

  @override
  String get button_sort_ascending => '升序';

  @override
  String get settings_page_appearance => '外观';

  @override
  String get settings_page_appearance_description => '语言、主题、字体';

  @override
  String get settings_language => '语言';

  @override
  String get settings_language_contribute => '贡献';

  @override
  String get settings_appearance_section_theming => '主题';

  @override
  String get settings_theme => '主题';

  @override
  String get settings_theme_system => '系统';

  @override
  String get settings_theme_light => '浅色';

  @override
  String get settings_theme_dark => '深色';

  @override
  String get settings_dynamic_theming => '动态主题';

  @override
  String get settings_dynamic_theming_description => '从系统生成配色';

  @override
  String get settings_black_theming => '黑色主题';

  @override
  String get settings_black_theming_description => '在深色模式下使用黑色背景';

  @override
  String get settings_appearance_section_fonts => '字体';

  @override
  String get settings_app_font => '应用字体';

  @override
  String get settings_app_font_description => '应用程序中除笔记编辑器外的所有文本使用的字体';

  @override
  String get settings_editor_font => '编辑器字体';

  @override
  String get settings_editor_font_description => '仅用于笔记编辑器中文本的字体';

  @override
  String get settings_page_notes_tiles => '笔记磁贴';

  @override
  String get settings_page_notes_tiles_description => '外观、内容';

  @override
  String get settings_page_notes_tiles_appearance_section => '外观';

  @override
  String get settings_page_notes_tiles_content_section => '内容';

  @override
  String get settings_show_tiles_background => '背景';

  @override
  String get settings_show_tiles_background_description => '显示笔记磁贴的背景';

  @override
  String get settings_show_separators => '分隔符';

  @override
  String get settings_show_separators_description => '在笔记磁贴之间显示分隔符';

  @override
  String get settings_show_note_type_icon => '显示类型图标';

  @override
  String get settings_show_note_type_icon_description => '显示笔记类型的图标';

  @override
  String get settings_show_titles_only => '仅标题';

  @override
  String get settings_show_titles_only_description => '仅显示笔记的标题';

  @override
  String get settings_show_titles_only_disable_in_search_view => '仅在搜索视图中禁用标题';

  @override
  String get settings_show_titles_only_disable_in_search_view_description => '禁用在搜索视图中仅显示标题的选项';

  @override
  String get settings_content_preview_max_lines => '最大预览行数';

  @override
  String get settings_content_preview_max_lines_description => '要显示的内容预览的最大行数';

  @override
  String get settings_behavior => '行为';

  @override
  String get settings_behavior_description => '确认、滑动操作';

  @override
  String get settings_behavior_application => '应用程序';

  @override
  String get settings_confirmations => '确认对话框';

  @override
  String get settings_confirmations_description => '对笔记执行操作时何时显示确认对话框';

  @override
  String get settings_confirmations_title_none => '从不';

  @override
  String get settings_confirmations_title_irreversible => '仅限不可撤销的操作';

  @override
  String get settings_confirmations_title_all => '始终';

  @override
  String get settings_auto_remove_from_bin_title => '自动从回收站中移除';

  @override
  String get settings_auto_remove_from_bin_description => '自动从回收站中移除笔记';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': '1 周后',
      '14': '2 周后',
      '30': '1 个月后',
      '90': '3 个月后',
      '180': '6 个月后',
      '365': '1 年后',
      'other': '从不',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => '滑动操作';

  @override
  String get settings_behavior_swipe_actions_archives => '滑动操作（归档）';

  @override
  String get settings_behavior_swipe_actions_bin => '滑动操作（回收站）';

  @override
  String get settings_swipe_action_right => '向右滑动操作';

  @override
  String get settings_swipe_action_right_description => '在笔记磁贴上向右滑动时触发的操作';

  @override
  String get settings_bin_swipe_action_right_description => '在回收站中的笔记磁贴上向右滑动时触发的操作';

  @override
  String get settings_swipe_action_left => '向左滑动操作';

  @override
  String get settings_swipe_action_left_description => '在笔记磁贴上向左滑动时触发的操作';

  @override
  String get settings_bin_swipe_action_left_description => '在回收站中的笔记磁贴上向左滑动时触发的操作';

  @override
  String get settings_page_notes_types => '笔记类型';

  @override
  String get settings_page_notes_types_description => '要使用的类型，富文本';

  @override
  String get settings_section_types_to_use => '要使用的类型';

  @override
  String get settings_available_notes_types => '可用笔记类型';

  @override
  String get settings_available_notes_types_description => '可以使用笔记页面中的“添加”按钮创建的笔记类型列表。移除类型时，该类型的现有笔记不会被删除，仍然可以正常使用';

  @override
  String get settings_available_default_share_type => '默认分享类型';

  @override
  String get settings_available_default_share_type_description => '从分享操作创建笔记时使用的默认笔记类型。它可以是“添加”按钮中不可用的类型';

  @override
  String get settings_editor => '编辑器';

  @override
  String get settings_editor_description => '行为';

  @override
  String get settings_editor_behavior => '行为';

  @override
  String get settings_show_editor_mode_button => '编辑器模式按钮';

  @override
  String get settings_show_editor_mode_button_description => '启用在编辑模式和阅读模式之间切换编辑器的按钮';

  @override
  String get settings_open_editor_reading_mode => '以阅读模式打开';

  @override
  String get settings_open_editor_reading_mode_description => '默认以阅读模式打开编辑器';

  @override
  String get settings_focus_title_on_new_note => '聚焦标题';

  @override
  String get settings_focus_title_on_new_note_description => '在创建新笔记时聚焦标题而不是内容';

  @override
  String get settings_editor_appearance => '外观';

  @override
  String get settings_toolbar_style_title => '工具栏样式';

  @override
  String get settings_toolbar_style_description => '富文本编辑器工具栏的样式';

  @override
  String get settings_use_paragraph_spacing => '段落间距';

  @override
  String get settings_use_paragraph_spacing_description => '在段落之间使用间距';

  @override
  String get settings_labels => '标签';

  @override
  String get settings_labels_description => '启用、外观';

  @override
  String get settings_enable_labels => '启用';

  @override
  String get settings_enable_labels_description => '允许使用标签对笔记进行分类（禁用后不会删除标签，也不会将其从笔记中移除，而只会隐藏标签）';

  @override
  String get settings_labels_appearance => '外观';

  @override
  String get settings_show_labels_note_tile => '在笔记磁贴上显示标签';

  @override
  String get settings_show_labels_note_tile_description => '显示笔记磁贴的标签列表';

  @override
  String get settings_show_labels_editor => '在编辑器中显示标签';

  @override
  String get settings_show_labels_editor_description => '在编辑器底部显示标签列表';

  @override
  String get settings_labels_section_behavior => '行为';

  @override
  String get settings_labels_swipe_action_right => '向右滑动操作';

  @override
  String get settings_labels_swipe_action_right_description => '在标签磁贴上向右滑动时触发的操作';

  @override
  String get settings_labels_swipe_action_left => '向左滑动操作';

  @override
  String get settings_labels_swipe_action_left_description => '在标签磁贴上向左滑动时触发的操作';

  @override
  String get settings_backup => '备份';

  @override
  String get settings_backup_description => '手动和自动导出、加密、导入';

  @override
  String get settings_backup_import => '导入';

  @override
  String get settings_import => '导入';

  @override
  String get settings_import_description => '从 JSON 文件导入笔记、标签和设置';

  @override
  String get settings_backup_manual_export => '手动导出';

  @override
  String get settings_export_json => '以 JSON 形式导出';

  @override
  String get settings_export_json_description => '立即将所有笔记、标签和设置导出到 JSON 文件中，以便可以重新导入';

  @override
  String get settings_export_markdown => '以 Markdown 形式导出';

  @override
  String get settings_export_markdown_description => '立即将所有笔记导出到 Markdown 文件中';

  @override
  String get settings_backup_auto_export => '自动导出';

  @override
  String get settings_auto_export => '自动导出';

  @override
  String get settings_auto_export_description => '自动将所有笔记、标签和设置导出到 JSON 文件中，以便可以重新导入';

  @override
  String get settings_auto_export_frequency => '频率';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {'1': '天', '7': '周', '14': ' 2 周', '30': '月', 'other': ''});
    return '每$_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => '自动导出的频率';

  @override
  String get settings_auto_export_encryption => '加密';

  @override
  String get settings_auto_export_encryption_description => '用密码加密笔记的标题和内容';

  @override
  String get settings_auto_export_directory => '目录';

  @override
  String get settings_auto_export_directory_description => '存储自动导出的目录';

  @override
  String get settings_security => '安全';

  @override
  String get settings_security_description => '安全标志、应用程序锁、笔记锁';

  @override
  String get settings_security_application => '应用程序';

  @override
  String get settings_security_application_lock => '应用程序锁';

  @override
  String get settings_security_note_lock => '笔记锁';

  @override
  String get settings_flag_secure => '将应用标记为安全';

  @override
  String get settings_flag_secure_description => '从最近的应用中隐藏本应用并防止截屏';

  @override
  String get settings_application_lock_title => '锁定';

  @override
  String get settings_application_lock_description => '锁定应用程序并要求使用设备验证身份才能解锁';

  @override
  String get settings_application_lock_delay_title => '锁定延迟';

  @override
  String get settings_application_lock_delay_description => '应用程序在移动到后台时自动锁定的延迟时间';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': '立即',
      '3': '3 秒后',
      '5': '5 秒后',
      '10': '10 秒后',
      '30': '30 秒后',
      '60': '1 分钟后',
      '120': '2 分钟后',
      '300': '5 分钟后',
      'other': '从不',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => '笔记锁';

  @override
  String get settings_note_lock_description => '锁定笔记并要求使用设备验证身份才能查看和编辑';

  @override
  String get settings_label_lock_title => '标签锁';

  @override
  String get settings_label_lock_description => '锁定标签并要求使用设备验证身份才能查看和编辑包含标签的任何笔记';

  @override
  String get settings_note_lock_delay_title => '锁定延迟';

  @override
  String get settings_note_lock_delay_description => '当应用程序移动到后台时，笔记自动锁定的延迟时间';

  @override
  String get settings_accessibility => '无障碍';

  @override
  String get settings_accessibility_text_size => '文本大小';

  @override
  String get settings_accessibility_text_color => '文本颜色';

  @override
  String get settings_accessibility_description => '文本颜色、文本缩放';

  @override
  String get settings_text_scaling => '文本缩放';

  @override
  String get settings_bigger_titles => '更大的标题';

  @override
  String get settings_bigger_titles_description => '在笔记磁贴和编辑器中显示更大的标题';

  @override
  String get settings_white_text_dark_mode => '深色模式中的白色文本';

  @override
  String get settings_white_text_dark_mode_description => '在深色模式中为文本使用白色';

  @override
  String get settings_disable_subdued_note_content_preview => '非柔和预览';

  @override
  String get settings_disable_subdued_note_content_preview_description => '禁用笔记内容预览的柔和文本颜色';

  @override
  String get settings_help_section_contact => '联系';

  @override
  String get settings_github_issues => '报告错误或请求功能';

  @override
  String get settings_github_issues_description => '通过创建 GitHub 问题来报告错误或请求功能';

  @override
  String get settings_github_discussions => '提问';

  @override
  String get settings_github_discussions_description => '在 GitHub 讨论中提问';

  @override
  String get settings_contact_developer => '联系开发人员';

  @override
  String settings_get_in_touch_description(Object email) {
    return '通过邮件 $email 联系开发人员';
  }

  @override
  String get settings_help => '帮助';

  @override
  String get settings_help_description => '联系、日志';

  @override
  String get settings_help_section_logs => '日志';

  @override
  String get settings_copy_logs => '复制日志';

  @override
  String get settings_copy_logs_description => '将应用程序的日志复制到剪贴板';

  @override
  String get settings_export_logs => '导出日志';

  @override
  String get settings_export_logs_description => '将应用程序的日志导出到文本文件';

  @override
  String get settings_about => '关于';

  @override
  String get settings_about_description => '信息、链接、捐赠';

  @override
  String get settings_about_application => '应用程序';

  @override
  String get settings_build_mode => '构建模式';

  @override
  String get settings_build_mode_release => 'Release';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => '链接';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => '查看源代码';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => '在 Crowdin 项目添加或改进本地化';

  @override
  String get settings_licence => '许可';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => '捐赠';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => '标题';

  @override
  String get hint_content => '笔记';

  @override
  String get hint_link => '链接';

  @override
  String get hint_label_name => '名称';

  @override
  String get dialog_export_encryption_password => '密码';

  @override
  String get dialog_select_labels => '选择标签';

  @override
  String get dialog_select_labels_to_add => '选择要添加的标签';

  @override
  String get tooltip_undo => '撤销最后操作';

  @override
  String get tooltip_redo => '恢复最后操作';

  @override
  String get tooltip_fab_add_note => '添加笔记';

  @override
  String get tooltip_fab_add_plain_text_note => '添加纯文本笔记';

  @override
  String get tooltip_fab_add_markdown_note => '添加 Markdown 笔记';

  @override
  String get tooltip_fab_add_rich_text_note => '添加富文本笔记';

  @override
  String get tooltip_fab_add_checklist_note => '添加核对清单笔记';

  @override
  String get tooltip_fab_add_label => '添加标签';

  @override
  String get tooltip_fab_empty_bin => '清空回收站';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => '切换到编辑模式';

  @override
  String get tooltip_fab_toggle_editor_mode_read => '切换到阅读模式';

  @override
  String get tooltip_layout_list => '列表视图';

  @override
  String get tooltip_layout_grid => '网格视图';

  @override
  String get tooltip_sort => '排序笔记';

  @override
  String get tooltip_search => '搜索笔记';

  @override
  String get tooltip_unselect_all => '取消全选';

  @override
  String get tooltip_reset => '重置';

  @override
  String get dialog_add_link => '添加链接';

  @override
  String get dialog_archive => '归档';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个笔记');
    return '是否确定要归档 $count $_temp0？';
  }

  @override
  String get dialog_unarchive => '取消归档';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个笔记');
    return '是否确定要取消归档 $count $_temp0？';
  }

  @override
  String get dialog_delete => '删除';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个笔记');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '是否确定要删除 $count $_temp0？您可以从回收站中还原$_temp1。';
  }

  @override
  String get dialog_permanently_delete => '永久删除';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个笔记');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '是否确定要永久删除 $count $_temp0？您将无法还原$_temp1。';
  }

  @override
  String get dialog_restore => '还原';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个笔记');
    return '是否确定要还原 $count $_temp0？';
  }

  @override
  String get dialog_empty_bin => '清空回收站';

  @override
  String get dialog_empty_bin_body => '是否确定要永久清空回收站？您将无法还原其中包含的笔记。';

  @override
  String get dialog_delete_label => '删除';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个标签');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: '标签');
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: '标签');
    return '是否确定要删除 $count $_temp0？将从您添加$_temp1的笔记中移除$_temp2。';
  }

  @override
  String get dialog_export_encryption_switch => '加密 JSON 导出';

  @override
  String get dialog_export_encryption_description =>
      '笔记的标题和内容将使用您的密码进行加密。密码应随机生成，长度恰好为 32 个字符，具有较强的强度（至少 1 个小写字母、1 个大写字母、1 个数字和 1 个特殊字符），并安全存储。';

  @override
  String get dialog_export_encryption_secondary_description_auto => '此密码将用于将来的所有自动导出。';

  @override
  String get dialog_export_encryption_secondary_description_manual => '此密码仅用于此导出。';

  @override
  String get dialog_export_encryption_password_invalid => '无效';

  @override
  String get dialog_import_encryption_password_description => '此导出已加密。要导入它，您需要提供用于加密它的密码。';

  @override
  String get dialog_import_encryption_password_error => '解密导出失败。请检查您提供的密码是否与加密导出时使用的密码相同。';

  @override
  String get dialog_label_add => '添加标签';

  @override
  String get dialog_label_edit => '编辑标签';

  @override
  String get dialog_label_name_cannot_be_empty => '名称不能为空。';

  @override
  String get dialog_label_name_already_used => '此名称已经使用。';

  @override
  String get button_sort_creation_date => '创建日期';

  @override
  String get button_sort_edition_date => '版本日期';

  @override
  String get placeholder_notes => '无笔记';

  @override
  String get placeholder_labels => '无标签';

  @override
  String get placeholder_archives => '没有归档的笔记';

  @override
  String get placeholder_bin => '没有删除的笔记';

  @override
  String get action_disabled => '已禁用';

  @override
  String get action_toggle_pin => '切换固定';

  @override
  String get action_pin_unpin => '固定/取消固定';

  @override
  String get action_pin => '固定';

  @override
  String get action_unpin => '取消固定';

  @override
  String get action_toggle_lock => '切换锁定';

  @override
  String get action_lock_unlock => '锁定/解锁';

  @override
  String get action_lock => '锁定';

  @override
  String get action_unlock => '解锁';

  @override
  String get action_share => '分享';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '个笔记');
    return '从 Material Notes 分享了 $count $_temp0';
  }

  @override
  String get action_archive => '归档';

  @override
  String get action_unarchive => '取消归档';

  @override
  String get action_delete => '删除';

  @override
  String get action_restore => '还原';

  @override
  String get action_delete_permanently => '永久删除';

  @override
  String get action_about => '关于';

  @override
  String get about_last_edited => '最后编辑';

  @override
  String get about_type => '类型';

  @override
  String get about_created => '创建日期';

  @override
  String get about_labels => '标签';

  @override
  String get about_words => '词数';

  @override
  String get about_characters => '字符';

  @override
  String get about_time_at => '于';

  @override
  String get menu_action_select_labels => '标签';

  @override
  String get menu_action_add_labels => '添加标签';

  @override
  String get action_labels_toggle_visibile => '切换可见性';

  @override
  String get action_labels_show_hide => '显示/隐藏';

  @override
  String get action_labels_show => '显示';

  @override
  String get action_labels_hide => '隐藏';

  @override
  String get action_labels_toggle_pins => '切换固定';

  @override
  String get action_labels_pin_unpin => '固定/取消固定';

  @override
  String get action_labels_pin => '固定';

  @override
  String get action_labels_unpin => '取消固定';

  @override
  String get action_labels_toggle_lock => '切换锁定';

  @override
  String get action_labels_lock_unlock => '锁定/解锁';

  @override
  String get action_labels_lock => '锁定';

  @override
  String get action_labels_unlock => '解锁';

  @override
  String get action_labels_edit => '编辑';

  @override
  String get action_labels_delete => '删除';

  @override
  String get filter_labels_all => '全部';

  @override
  String get filter_labels_visible => '可见的';

  @override
  String get filter_labels_hidden => '隐藏的';

  @override
  String get filter_labels_pinned => '固定的';

  @override
  String get filter_labels_locked => '已锁定';

  @override
  String get snack_bar_authentication_failed => '身份验证失败，请重试。';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '$_temp0已归档';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '$_temp0已取消归档';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '$_temp0已删除';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '$_temp0已还原';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '笔记');
    return '$_temp0内容已复制到剪贴板。';
  }

  @override
  String get snack_bar_import_success => '已成功导入备份。';

  @override
  String get snack_bar_export_success => '已成功导出备份。';

  @override
  String get snack_bar_logs_copied => '日志已复制到剪贴板。';

  @override
  String get snack_bar_logs_exported => '日志已成功导出。';

  @override
  String get snack_bar_no_labels => '没有标签。';

  @override
  String get quick_action_add_plain_text_note_title => '添加纯文本笔记';

  @override
  String get quick_action_add_markdown_note_title => '添加 Markdown 笔记';

  @override
  String get quick_action_add_rich_text_note_title => '添加富文本笔记';

  @override
  String get quick_action_add_checklist_note_title => '添加核对清单笔记';

  @override
  String get welcome_note_title => '欢迎使用 Material Notes！';

  @override
  String get welcome_note_content => '简单、本地、Material 设计笔记';

  @override
  String get font_system_default => '系统默认';

  @override
  String get note_type_plain_text => '纯文本';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => '富文本';

  @override
  String get note_type_checklist => '核对清单';

  @override
  String get lock_page_reason_app => '解锁 Material Notes';

  @override
  String get lock_page_reason_note => '解锁此笔记';

  @override
  String get lock_page_reason_action => '授权此操作';

  @override
  String get lock_page_description_app => '已锁定应用程序。';

  @override
  String get lock_page_description_note => '已锁定此笔记。';

  @override
  String get lock_page_unlock => '解锁';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => '前景颜色';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => '背景颜色';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => '前景颜色';

  @override
  String get toolbar_style_one_row_simple_title => '单行（简单选项）';

  @override
  String get toolbar_style_one_row_simple_description => '单行仅显示简单格式选项';

  @override
  String get toolbar_style_one_row_all_title => '单行（所有选项）';

  @override
  String get toolbar_style_one_row_all_description => '单行显示所有格式选项';

  @override
  String get toolbar_style_two_rows_stacked_title => '双行（堆叠）';

  @override
  String get toolbar_style_two_rows_stacked_description => '双行堆叠显示所有格式选项';

  @override
  String get toolbar_style_two_rows_toggleable_title => '双行（可切换）';

  @override
  String get toolbar_style_two_rows_toggleable_description => '双行可切换显示所有格式选项';

  @override
  String get settings_confirm_before_exiting_title => '退出前确认';

  @override
  String get settings_confirm_before_exiting_description => '退出应用程序前要求确认';

  @override
  String get snack_bar_confirm_exiting => '再次按返回退出应用程序。';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class AppLocalizationsZhHant extends AppLocalizationsZh {
  AppLocalizationsZhHant() : super('zh_Hant');

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => '簡單易用、本機操作、Material 設計之筆記';

  @override
  String app_about(String appName) {
    return '$appName 乃一款以文字為本的筆記應用程式，秉承簡約之風，擁抱 Material 設計。筆記於本機儲存，並不索取任何網際網路權限，只有您可以存取筆記。';
  }

  @override
  String get error_snack_bar => '錯誤：';

  @override
  String get error_widget_title => '發生錯誤。';

  @override
  String get error_widget_description => '請到 GitHub 或寄送郵件報告此問題，並附上此頁面之截圖，以及下方可供複製或匯出的記錄檔。以防萬一，您亦該匯出您的筆記。';

  @override
  String get error_widget_disabled_secure_flag => '標記應用程式為安全的設定已停用，直至下一次重新啟動，以便截圖。';

  @override
  String get error_widget_button_export_notes => '匯出筆記';

  @override
  String get error_widget_button_copy_logs => '複製記錄檔';

  @override
  String get error_widget_button_export_logs => '匯出記錄檔';

  @override
  String get error_widget_button_create_github_issue => '建立 GitHub 議題';

  @override
  String get error_widget_button_send_mail => '傳送郵件';

  @override
  String get navigation_notes => '筆記';

  @override
  String get navigation_manage_labels_destination => '管理標籤';

  @override
  String get navigation_manage_labels_page => '標籤';

  @override
  String get navigation_archives => '封存';

  @override
  String get navigation_bin => '垃圾桶';

  @override
  String get navigation_settings => '設定';

  @override
  String get navigation_settings_appearance => '外觀';

  @override
  String get navigation_settings_notes_types => '筆記類型';

  @override
  String get navigation_settings_notes_tiles => '筆記方塊';

  @override
  String get navigation_settings_behavior => '行為';

  @override
  String get navigation_settings_editor => '編輯器';

  @override
  String get navigation_settings_labels => '標籤';

  @override
  String get navigation_settings_backup => '備份';

  @override
  String get navigation_settings_security => '安全性';

  @override
  String get navigation_settings_accessibility => '輔助';

  @override
  String get navigation_settings_help => '說明';

  @override
  String get navigation_settings_about => '關於';

  @override
  String get button_sort_title => '標題';

  @override
  String get button_sort_ascending => '順序';

  @override
  String get settings_page_appearance => '外觀';

  @override
  String get settings_page_appearance_description => '語言、佈景配置、字型';

  @override
  String get settings_language => '語言';

  @override
  String get settings_language_contribute => '貢獻';

  @override
  String get settings_appearance_section_theming => '佈景配置';

  @override
  String get settings_theme => '佈景主題';

  @override
  String get settings_theme_system => '系統';

  @override
  String get settings_theme_light => '淺色';

  @override
  String get settings_theme_dark => '深色';

  @override
  String get settings_dynamic_theming => '動態佈景配置';

  @override
  String get settings_dynamic_theming_description => '從系統產生色彩';

  @override
  String get settings_black_theming => '黑色佈景配置';

  @override
  String get settings_black_theming_description => '深色模式使用黑色背景';

  @override
  String get settings_appearance_section_fonts => '字型';

  @override
  String get settings_app_font => '應用程式字型';

  @override
  String get settings_app_font_description => '應用程式中所有文字使用的字型 (筆記編輯器除外)';

  @override
  String get settings_editor_font => '編輯器字型';

  @override
  String get settings_editor_font_description => '僅限筆記編輯器中的文字使用的字型';

  @override
  String get settings_page_notes_tiles => '筆記方塊';

  @override
  String get settings_page_notes_tiles_description => '外觀、內容';

  @override
  String get settings_page_notes_tiles_appearance_section => '外觀';

  @override
  String get settings_page_notes_tiles_content_section => '內容';

  @override
  String get settings_show_tiles_background => '背景';

  @override
  String get settings_show_tiles_background_description => '顯示筆記方塊的背景';

  @override
  String get settings_show_separators => '分隔線';

  @override
  String get settings_show_separators_description => '顯示筆記方塊之間的分隔線';

  @override
  String get settings_show_note_type_icon => '顯示類型圖示';

  @override
  String get settings_show_note_type_icon_description => '顯示筆記類型圖示';

  @override
  String get settings_show_titles_only => '僅顯示標題';

  @override
  String get settings_show_titles_only_description => '僅顯示筆記的標題';

  @override
  String get settings_show_titles_only_disable_in_search_view => '搜尋檢視中停用僅顯示標題';

  @override
  String get settings_show_titles_only_disable_in_search_view_description => '在搜尋檢視中停用僅顯示標題的選項';

  @override
  String get settings_content_preview_max_lines => '預覽行數上限';

  @override
  String get settings_content_preview_max_lines_description => '內容預覽最多顯示幾多行';

  @override
  String get settings_behavior => '行為';

  @override
  String get settings_behavior_description => '確認、滑動動作';

  @override
  String get settings_behavior_application => '應用程式';

  @override
  String get settings_confirmations => '確認對話方塊';

  @override
  String get settings_confirmations_description => '執行筆記動作時該顯示確認對話方塊的時機';

  @override
  String get settings_confirmations_title_none => '永不';

  @override
  String get settings_confirmations_title_irreversible => '僅限不可逆轉的動作';

  @override
  String get settings_confirmations_title_all => '一律';

  @override
  String get settings_auto_remove_from_bin_title => '垃圾桶自動移除';

  @override
  String get settings_auto_remove_from_bin_description => '自動移除垃圾桶中的筆記';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': '1 週後',
      '14': '2 週後',
      '30': '1 個月後',
      '90': '3 個月後',
      '180': '6 個月後',
      '365': '1 年後',
      'other': '永不',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => '滑動動作';

  @override
  String get settings_behavior_swipe_actions_archives => '滑動動作 (封存)';

  @override
  String get settings_behavior_swipe_actions_bin => '滑動動作 (垃圾桶)';

  @override
  String get settings_swipe_action_right => '向右滑動動作';

  @override
  String get settings_swipe_action_right_description => '向右滑動筆記方塊時要觸發的動作';

  @override
  String get settings_bin_swipe_action_right_description => '在垃圾桶中向右滑動筆記方塊時要觸發的動作';

  @override
  String get settings_swipe_action_left => '向左滑動動作';

  @override
  String get settings_swipe_action_left_description => '向左滑動筆記方塊時要觸發的動作';

  @override
  String get settings_bin_swipe_action_left_description => '在垃圾桶中向左滑動筆記方塊時要觸發的動作';

  @override
  String get settings_page_notes_types => '筆記類型';

  @override
  String get settings_page_notes_types_description => '使用的類型、格式化文字';

  @override
  String get settings_section_types_to_use => '使用的類型';

  @override
  String get settings_available_notes_types => '可用的筆記類型';

  @override
  String get settings_available_notes_types_description => '在筆記頁面中使用「新增」按鈕可建立的筆記類型清單。即使移除類型，現有的筆記並不會刪除，且可如常使用';

  @override
  String get settings_available_default_share_type => '預設分享類型';

  @override
  String get settings_available_default_share_type_description => '藉由分享動作建立筆記時預設使用的筆記類型。可以是「新增」按鈕不使用的類型';

  @override
  String get settings_editor => '編輯器';

  @override
  String get settings_editor_description => '行為';

  @override
  String get settings_editor_behavior => '行為';

  @override
  String get settings_show_editor_mode_button => '編輯器模式按鈕';

  @override
  String get settings_show_editor_mode_button_description => '啟用切換編輯器編輯與閱讀模式的按鈕';

  @override
  String get settings_open_editor_reading_mode => '以閱讀模式開啟';

  @override
  String get settings_open_editor_reading_mode_description => '預設以閱讀模式開啟編輯器';

  @override
  String get settings_focus_title_on_new_note => '標題聚焦';

  @override
  String get settings_focus_title_on_new_note_description => '建立新的筆記時聚焦標題而非內容';

  @override
  String get settings_editor_appearance => '外觀';

  @override
  String get settings_toolbar_style_title => '工具列樣式';

  @override
  String get settings_toolbar_style_description => '格式化文字編輯器中的工具列樣式';

  @override
  String get settings_use_paragraph_spacing => '分段留白';

  @override
  String get settings_use_paragraph_spacing_description => '段落之間留白';

  @override
  String get settings_labels => '標籤';

  @override
  String get settings_labels_description => '啟用、外觀';

  @override
  String get settings_enable_labels => '啟用';

  @override
  String get settings_enable_labels_description => '允許以標籤分類筆記 (停用僅隱藏標籤，不會刪除或從筆記移除標籤)';

  @override
  String get settings_labels_appearance => '外觀';

  @override
  String get settings_show_labels_note_tile => '筆記方塊上顯示標籤';

  @override
  String get settings_show_labels_note_tile_description => '顯示筆記方塊的標籤清單';

  @override
  String get settings_show_labels_editor => '編輯器中顯示標籤';

  @override
  String get settings_show_labels_editor_description => '編輯器底部顯示標籤清單';

  @override
  String get settings_labels_section_behavior => '行為';

  @override
  String get settings_labels_swipe_action_right => '向右滑動動作';

  @override
  String get settings_labels_swipe_action_right_description => '向右滑動標籤方塊時要觸發的動作';

  @override
  String get settings_labels_swipe_action_left => '向左滑動動作';

  @override
  String get settings_labels_swipe_action_left_description => '向左滑動標籤方塊時要觸發的動作';

  @override
  String get settings_backup => '備份';

  @override
  String get settings_backup_description => '手動與自動匯出、加密、匯入';

  @override
  String get settings_backup_import => '匯入';

  @override
  String get settings_import => '匯入';

  @override
  String get settings_import_description => '從 JSON 檔案匯入筆記、標籤和設定';

  @override
  String get settings_backup_manual_export => '手動匯出';

  @override
  String get settings_export_json => '匯出成 JSON';

  @override
  String get settings_export_json_description => '立即將所有筆記、標籤和設定匯出成 JSON 檔案，以便日後可重新匯入';

  @override
  String get settings_export_markdown => '匯出成 Markdown';

  @override
  String get settings_export_markdown_description => '立即將所有筆記匯出成 Markdown 檔案';

  @override
  String get settings_backup_auto_export => '自動匯出';

  @override
  String get settings_auto_export => '自動匯出';

  @override
  String get settings_auto_export_description => '自動將所有筆記、標籤和設定匯出成 JSON 檔案，以便日後可重新匯入';

  @override
  String get settings_auto_export_frequency => '頻率';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {'1': '天', '7': '週', '14': '兩星期', '30': '月', 'other': ''});
    return '每$_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => '自動匯出的頻率';

  @override
  String get settings_auto_export_encryption => '加密';

  @override
  String get settings_auto_export_encryption_description => '以密碼加密筆記的標題和內容';

  @override
  String get settings_auto_export_directory => '目錄';

  @override
  String get settings_auto_export_directory_description => '要儲存自動匯出的目錄';

  @override
  String get settings_security => '安全性';

  @override
  String get settings_security_description => '安全旗標、應用程式鎖定、筆記鎖定';

  @override
  String get settings_security_application => '應用程式';

  @override
  String get settings_security_application_lock => '應用程式鎖定';

  @override
  String get settings_security_note_lock => '筆記鎖定';

  @override
  String get settings_flag_secure => '標記應用程式為安全';

  @override
  String get settings_flag_secure_description => '從最近使用應用程式中隱藏並阻止截圖';

  @override
  String get settings_application_lock_title => '鎖定';

  @override
  String get settings_application_lock_description => '鎖定應用程式並要求以裝置的認證方式解除鎖定';

  @override
  String get settings_application_lock_delay_title => '鎖定延遲';

  @override
  String get settings_application_lock_delay_description => '當應用程式移至背景時，相隔多久才鎖定應用程式';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': '立即',
      '3': '3 秒後',
      '5': '5 秒後',
      '10': '10 秒後',
      '30': '30 秒後',
      '60': '1 分鐘後',
      '120': '2 分鐘後',
      '300': '5 分鐘後',
      'other': '永不',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => '筆記鎖定';

  @override
  String get settings_note_lock_description => '鎖定筆記並要求以裝置的認證方式解除鎖定，方可檢視與編輯';

  @override
  String get settings_label_lock_title => '標籤鎖定';

  @override
  String get settings_label_lock_description => '鎖定標籤並要求以裝置的認證方式解除鎖定，方可檢視與編輯任何已加上此標籤的筆記';

  @override
  String get settings_note_lock_delay_title => '鎖定延遲';

  @override
  String get settings_note_lock_delay_description => '當應用程式移至背景時，相隔多久才鎖定筆記';

  @override
  String get settings_accessibility => '輔助';

  @override
  String get settings_accessibility_text_size => '文字大小';

  @override
  String get settings_accessibility_text_color => '文字色彩';

  @override
  String get settings_accessibility_description => '文字色彩、文字縮放';

  @override
  String get settings_text_scaling => '文字縮放';

  @override
  String get settings_bigger_titles => '標題放大';

  @override
  String get settings_bigger_titles_description => '放大筆記方塊與編輯器中的標題';

  @override
  String get settings_white_text_dark_mode => '深色模式白字顯示';

  @override
  String get settings_white_text_dark_mode_description => '深色模式時文字使用白色';

  @override
  String get settings_disable_subdued_note_content_preview => '預覽不調暗';

  @override
  String get settings_disable_subdued_note_content_preview_description => '筆記內容預覽停用調暗的文字色彩';

  @override
  String get settings_help_section_contact => '聯絡';

  @override
  String get settings_github_issues => '報告問題或功能請求';

  @override
  String get settings_github_issues_description => '建立 GitHub 議題以便報告問題或請求新功能';

  @override
  String get settings_github_discussions => '發問';

  @override
  String get settings_github_discussions_description => '到 GitHub 討論區發問';

  @override
  String get settings_contact_developer => '聯絡開發者';

  @override
  String settings_get_in_touch_description(Object email) {
    return '寄送郵件聯絡開發者：$email';
  }

  @override
  String get settings_help => '說明';

  @override
  String get settings_help_description => '聯絡、記錄檔';

  @override
  String get settings_help_section_logs => '記錄檔';

  @override
  String get settings_copy_logs => '複製記錄檔';

  @override
  String get settings_copy_logs_description => '將應用程式的記錄檔複製至剪貼簿';

  @override
  String get settings_export_logs => '匯出記錄檔';

  @override
  String get settings_export_logs_description => '將應用程式的記錄檔匯出至文字檔';

  @override
  String get settings_about => '關於';

  @override
  String get settings_about_description => '資訊、連結、捐款';

  @override
  String get settings_about_application => '應用程式';

  @override
  String get settings_build_mode => '組建模式';

  @override
  String get settings_build_mode_release => '發行版';

  @override
  String get settings_build_mode_debug => '除錯版';

  @override
  String get settings_about_links => '連結';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => '查看原始碼';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => '到 Crowdin 專案新增或改進翻譯';

  @override
  String get settings_licence => '授權協議';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => '捐款';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => '標題';

  @override
  String get hint_content => '筆記';

  @override
  String get hint_link => '連結';

  @override
  String get hint_label_name => '名稱';

  @override
  String get dialog_export_encryption_password => '密碼';

  @override
  String get dialog_select_labels => '選取標籤';

  @override
  String get dialog_select_labels_to_add => '選取要新增的標籤';

  @override
  String get tooltip_undo => '復原最後一個動作';

  @override
  String get tooltip_redo => '重做最後一個動作';

  @override
  String get tooltip_fab_add_note => '新增筆記';

  @override
  String get tooltip_fab_add_plain_text_note => '新增純文字筆記';

  @override
  String get tooltip_fab_add_markdown_note => '新增 Markdown 筆記';

  @override
  String get tooltip_fab_add_rich_text_note => '新增格式化文字筆記';

  @override
  String get tooltip_fab_add_checklist_note => '新增勾選清單筆記';

  @override
  String get tooltip_fab_add_label => '新增標籤';

  @override
  String get tooltip_fab_empty_bin => '清空垃圾桶';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => '切換至編輯模式';

  @override
  String get tooltip_fab_toggle_editor_mode_read => '切換至閱讀模式';

  @override
  String get tooltip_layout_list => '清單檢視';

  @override
  String get tooltip_layout_grid => '網格檢視';

  @override
  String get tooltip_sort => '排序筆記';

  @override
  String get tooltip_search => '搜尋筆記';

  @override
  String get tooltip_unselect_all => '全部取消選取';

  @override
  String get tooltip_reset => '重設';

  @override
  String get dialog_add_link => '新增連結';

  @override
  String get dialog_archive => '封存';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個筆記');
    return '您確定要封存 $count $_temp0嗎？';
  }

  @override
  String get dialog_unarchive => '取消封存';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個筆記');
    return '您確定要取消封存 $count $_temp0嗎？';
  }

  @override
  String get dialog_delete => '刪除';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個筆記');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: '其');
    return '您確定要刪除 $count $_temp0嗎？之後可從垃圾桶中將$_temp1還原。';
  }

  @override
  String get dialog_permanently_delete => '永久刪除';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個筆記');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: '');
    return '您確定要永久刪除 $count $_temp0嗎？您之後將無法$_temp1還原。';
  }

  @override
  String get dialog_restore => '還原';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個筆記');
    return '您確定要還原 $count $_temp0嗎？';
  }

  @override
  String get dialog_empty_bin => '清空垃圾桶';

  @override
  String get dialog_empty_bin_body => '您確定要永久清空垃圾桶嗎？您將無法還原當中所載的筆記。';

  @override
  String get dialog_delete_label => '刪除';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個標籤');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: '標籤');
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: '');
    return '您確定要刪除 $count $_temp0嗎？$_temp1將一併從筆記移除$_temp2。';
  }

  @override
  String get dialog_export_encryption_switch => '將 JSON 匯出加密';

  @override
  String get dialog_export_encryption_description =>
      '筆記的標題和內容將使用您的密碼加密。密碼應該隨機產生、長度恰好 32 個字元、高強度 (包含至少 1 個小寫、1 個大寫、1 個數字和 1 個特殊字元) 並安全地妥為保管。';

  @override
  String get dialog_export_encryption_secondary_description_auto => '此後所有自動匯出皆將使用此密碼。';

  @override
  String get dialog_export_encryption_secondary_description_manual => '此密碼僅限此次匯出使用。';

  @override
  String get dialog_export_encryption_password_invalid => '無效';

  @override
  String get dialog_import_encryption_password_description => '此匯出已經加密。若要匯入，您需要提供用以加密的密碼。';

  @override
  String get dialog_import_encryption_password_error => '解密匯出失敗。請檢查用以加密匯出的密碼與您所提供的是否相同。';

  @override
  String get dialog_label_add => '新增標籤';

  @override
  String get dialog_label_edit => '編輯標籤';

  @override
  String get dialog_label_name_cannot_be_empty => '名稱不得留空。';

  @override
  String get dialog_label_name_already_used => '此名稱已在使用。';

  @override
  String get button_sort_creation_date => '建立日期';

  @override
  String get button_sort_edition_date => '編輯日期';

  @override
  String get placeholder_notes => '無筆記';

  @override
  String get placeholder_labels => '無標籤';

  @override
  String get placeholder_archives => '無已封存的筆記';

  @override
  String get placeholder_bin => '無已刪除的筆記';

  @override
  String get action_disabled => '已停用';

  @override
  String get action_toggle_pin => '切換釘選';

  @override
  String get action_pin_unpin => '釘選 / 取消釘選';

  @override
  String get action_pin => '釘選';

  @override
  String get action_unpin => '取消釘選';

  @override
  String get action_toggle_lock => '切換鎖定';

  @override
  String get action_lock_unlock => '鎖定 / 解除鎖定';

  @override
  String get action_lock => '鎖定';

  @override
  String get action_unlock => '解除鎖定';

  @override
  String get action_share => '分享';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '個筆記');
    return '$count $_temp0分享自 Material Notes';
  }

  @override
  String get action_archive => '封存';

  @override
  String get action_unarchive => '取消封存';

  @override
  String get action_delete => '刪除';

  @override
  String get action_restore => '還原';

  @override
  String get action_delete_permanently => '永久刪除';

  @override
  String get action_about => '關於';

  @override
  String get about_last_edited => '最後編輯日期';

  @override
  String get about_type => '類型';

  @override
  String get about_created => '建立日期';

  @override
  String get about_labels => '標籤數目';

  @override
  String get about_words => '字詞數目';

  @override
  String get about_characters => '字元數目';

  @override
  String get about_time_at => '於';

  @override
  String get menu_action_select_labels => '標籤';

  @override
  String get menu_action_add_labels => '新增標籤';

  @override
  String get action_labels_toggle_visibile => '切換可見';

  @override
  String get action_labels_show_hide => '顯示 / 隱藏';

  @override
  String get action_labels_show => '顯示';

  @override
  String get action_labels_hide => '隱藏';

  @override
  String get action_labels_toggle_pins => '切換釘選';

  @override
  String get action_labels_pin_unpin => '釘選 / 取消釘選';

  @override
  String get action_labels_pin => '釘選';

  @override
  String get action_labels_unpin => '取消釘選';

  @override
  String get action_labels_toggle_lock => '切換鎖定';

  @override
  String get action_labels_lock_unlock => '鎖定 / 解除鎖定';

  @override
  String get action_labels_lock => '鎖定';

  @override
  String get action_labels_unlock => '解除鎖定';

  @override
  String get action_labels_edit => '編輯';

  @override
  String get action_labels_delete => '刪除';

  @override
  String get filter_labels_all => '全部';

  @override
  String get filter_labels_visible => '可見';

  @override
  String get filter_labels_hidden => '已隱藏';

  @override
  String get filter_labels_pinned => '已釘選';

  @override
  String get filter_labels_locked => '已鎖定';

  @override
  String get snack_bar_authentication_failed => '認證失敗，請再試一次。';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '筆記');
    return '$_temp0已封存';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '筆記');
    return '$_temp0已取消封存';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '筆記');
    return '$_temp0已刪除';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '筆記');
    return '$_temp0已還原';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: '筆記');
    return '$_temp0內容已複製至剪貼簿。';
  }

  @override
  String get snack_bar_import_success => '備份已成功匯入。';

  @override
  String get snack_bar_export_success => '備份已成功匯出。';

  @override
  String get snack_bar_logs_copied => '記錄檔已複製至您的剪貼簿。';

  @override
  String get snack_bar_logs_exported => '記錄檔已成功匯出。';

  @override
  String get snack_bar_no_labels => '未有任何標籤。';

  @override
  String get quick_action_add_plain_text_note_title => '新增純文字筆記';

  @override
  String get quick_action_add_markdown_note_title => '新增 Markdown 筆記';

  @override
  String get quick_action_add_rich_text_note_title => '新增格式化文字筆記';

  @override
  String get quick_action_add_checklist_note_title => '新增勾選清單筆記';

  @override
  String get welcome_note_title => '歡迎使用 Material Notes！';

  @override
  String get welcome_note_content => '簡單易用、本機操作、Material 設計之筆記';

  @override
  String get font_system_default => '系統預設值';

  @override
  String get note_type_plain_text => '純文字';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => '格式化文字';

  @override
  String get note_type_checklist => '勾選清單';

  @override
  String get lock_page_reason_app => '解除鎖定 Material Notes';

  @override
  String get lock_page_reason_note => '解除鎖定此筆記';

  @override
  String get lock_page_reason_action => '授權此動作';

  @override
  String get lock_page_description_app => '應用程式已鎖定。';

  @override
  String get lock_page_description_note => '此筆記已鎖定。';

  @override
  String get lock_page_unlock => '解除鎖定';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => '前景色彩';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => '背景色彩';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => '前景色彩';

  @override
  String get toolbar_style_one_row_simple_title => '單行 (精簡選項)';

  @override
  String get toolbar_style_one_row_simple_description => '單行僅顯示簡易格式化選項';

  @override
  String get toolbar_style_one_row_all_title => '單行 (所有選項)';

  @override
  String get toolbar_style_one_row_all_description => '單行顯示所有格式化選項';

  @override
  String get toolbar_style_two_rows_stacked_title => '雙行 (並列)';

  @override
  String get toolbar_style_two_rows_stacked_description => '上下兩行顯示所有格式化選項';

  @override
  String get toolbar_style_two_rows_toggleable_title => '雙行 (切換)';

  @override
  String get toolbar_style_two_rows_toggleable_description => '雙行切換顯示所有格式化選項';

  @override
  String get settings_confirm_before_exiting_title => '結束前先確認';

  @override
  String get settings_confirm_before_exiting_description => '結束應用程式前先詢問確認';

  @override
  String get snack_bar_confirm_exiting => '再按一下返回結束應用程式。';
}
