// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get app_name => 'Materyal Notlar';

  @override
  String get app_tagline => 'Basit, çevrimdışı, materyal tasarımlı notlar';

  @override
  String app_about(String appName) {
    return '$appName basitliği hedefleyen metin tabanlı bir not alma uygulamasıdır. Materyal Tasarımı benimser. Notları yerel olarak saklar ve internet izni yoktur, böylece notlara erişebilen tek kişi sizsiniz.';
  }

  @override
  String get error_snack_bar => 'Hata:';

  @override
  String get error_widget_title => 'Bir hata oluştu.';

  @override
  String get error_widget_description =>
      'Lütfen bu sorunu GitHub\'da veya posta yoluyla bildirin. Bu sayfanın bir ekran görüntüsünü ve kopyalayabileceğiniz veya dışa aktarabileceğiniz günlükleri aşağıya ekleyin. Önlem olarak, notlarınızı da dışa aktarmalısınız.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Uygulamayı güvenli olarak işaretleme ayarı, ekran görüntülerini etkinleştirmek için bir sonraki yeniden başlatmaya kadar devre dışı bırakılır.';

  @override
  String get error_widget_button_export_notes => 'Notları dışarı aktar';

  @override
  String get error_widget_button_copy_logs => 'Günlükleri kopyala';

  @override
  String get error_widget_button_export_logs => 'Günlüğü indir';

  @override
  String get error_widget_button_create_github_issue => 'GitHub sorunu ekle';

  @override
  String get error_widget_button_send_mail => 'Posta gönder';

  @override
  String get navigation_notes => 'Notlar';

  @override
  String get navigation_manage_labels_destination => 'Etiketleri yönetin';

  @override
  String get navigation_manage_labels_page => 'Etiketler';

  @override
  String get navigation_archives => 'Arşivler';

  @override
  String get navigation_bin => 'Çöp Kutusu';

  @override
  String get navigation_settings => 'Ayarlar';

  @override
  String get navigation_settings_appearance => 'Görünüm';

  @override
  String get navigation_settings_notes_types => 'Not türleri';

  @override
  String get navigation_settings_notes_tiles => 'Not başlıkları';

  @override
  String get navigation_settings_behavior => 'Davranış';

  @override
  String get navigation_settings_editor => 'Düzenleyici';

  @override
  String get navigation_settings_labels => 'Etiketler';

  @override
  String get navigation_settings_backup => 'Yedekle';

  @override
  String get navigation_settings_security => 'Güvenlik';

  @override
  String get navigation_settings_accessibility => 'Erişilebilirlik';

  @override
  String get navigation_settings_help => 'Yardım alın';

  @override
  String get navigation_settings_about => 'Hakkında';

  @override
  String get button_sort_title => 'Başlık';

  @override
  String get button_sort_ascending => 'Artan';

  @override
  String get settings_page_appearance => 'Görünüm';

  @override
  String get settings_page_appearance_description => 'Diller, temalaştırma ve yazı tipleri';

  @override
  String get settings_language => 'Dil';

  @override
  String get settings_language_contribute => 'Bağış yap';

  @override
  String get settings_appearance_section_theming => 'Temalaştırma';

  @override
  String get settings_theme => 'Tema';

  @override
  String get settings_theme_system => 'Sistem';

  @override
  String get settings_theme_light => 'Açık';

  @override
  String get settings_theme_dark => 'Koyu';

  @override
  String get settings_dynamic_theming => 'Dinamik tema';

  @override
  String get settings_dynamic_theming_description => 'Sisteminizdeki rengi baz alın';

  @override
  String get settings_black_theming => 'Siyah tema';

  @override
  String get settings_black_theming_description => 'Koyu modda siyah arkaplan kullanın';

  @override
  String get settings_appearance_section_fonts => 'Yazı tipleri';

  @override
  String get settings_app_font => 'Uygulama yazı tipi';

  @override
  String get settings_app_font_description =>
      'Not düzenleyici dışında uygulamadaki diğer tüm metinlerde kullanılan yazı tipi';

  @override
  String get settings_editor_font => 'Düzenleyici yazı tipi';

  @override
  String get settings_editor_font_description => 'Yalnızca not düzenleyicisindeki metinde kullanılan yazı tipi';

  @override
  String get settings_page_notes_tiles => 'Not başlıkları';

  @override
  String get settings_page_notes_tiles_description => 'Görünüm, içerik';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Appearance';

  @override
  String get settings_page_notes_tiles_content_section => 'Content';

  @override
  String get settings_show_tiles_background => 'Arkaplan';

  @override
  String get settings_show_tiles_background_description => 'Not karolarının arka planını gösterin';

  @override
  String get settings_show_separators => 'Ayırıcı';

  @override
  String get settings_show_separators_description => 'Not kutucukları arasında bir ayırıcı göster';

  @override
  String get settings_show_note_type_icon => 'Show type icon';

  @override
  String get settings_show_note_type_icon_description => 'Show the icon of the type of the note';

  @override
  String get settings_show_titles_only => 'Sadece başlıklar';

  @override
  String get settings_show_titles_only_description => 'Yalnızca notların başlıklarını gösterin';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'Başlıkları yalnızca arama görünümünde devre dışı bırak';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Arama görünümündeyken yalnızca başlıkları gösterme seçeneğini devre dışı bırakın';

  @override
  String get settings_content_preview_max_lines => 'Maximum preview lines';

  @override
  String get settings_content_preview_max_lines_description => 'Maximum number of lines of the content preview to show';

  @override
  String get settings_behavior => 'Davranış';

  @override
  String get settings_behavior_description => 'Confirmations, swipe actions';

  @override
  String get settings_behavior_application => 'Uygulama';

  @override
  String get settings_confirmations => 'Onay iletişim kutuları';

  @override
  String get settings_confirmations_description =>
      'Not üzerinde bir eylem gerçekleştirirken bir onay iletişim kutusu ne zaman gösterilir';

  @override
  String get settings_confirmations_title_none => 'Asla';

  @override
  String get settings_confirmations_title_irreversible => 'Sadece geri alınamaz eylemler';

  @override
  String get settings_confirmations_title_all => 'Her zaman';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description => 'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Kaydırma işlemleri';

  @override
  String get settings_behavior_swipe_actions_archives => 'Swipe actions (archives)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Swipe actions (bin)';

  @override
  String get settings_swipe_action_right => 'Sağa kaydırma eylemi';

  @override
  String get settings_swipe_action_right_description =>
      'Bir not kutucuğu üzerinde sağa kaydırma yapıldığında tetiklenecek eylem';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a note tile in the bin';

  @override
  String get settings_swipe_action_left => 'Sola kaydırma eylemi';

  @override
  String get settings_swipe_action_left_description =>
      'Bir not kutucuğu üzerinde sola kaydırma yapıldığında tetiklenecek eylem';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a note tile in the bin';

  @override
  String get settings_page_notes_types => 'Notes types';

  @override
  String get settings_page_notes_types_description => 'Types to use, rich text';

  @override
  String get settings_section_types_to_use => 'Types to use';

  @override
  String get settings_available_notes_types => 'Available notes types';

  @override
  String get settings_available_notes_types_description =>
      'The list of notes types that can be created with the \"Add\" button from the notes page. When removing a type, already existing notes with that type are not deleted and can still be used normally';

  @override
  String get settings_available_default_share_type => 'Default share type';

  @override
  String get settings_available_default_share_type_description =>
      'The default note type to use when creating a note from a share action. It can be a type that is not available from the \"Add\" button';

  @override
  String get settings_editor => 'Düzenleyen';

  @override
  String get settings_editor_description => 'Behavior';

  @override
  String get settings_editor_behavior => 'Davranış';

  @override
  String get settings_show_editor_mode_button => 'Düzenleyici modu düğmesi';

  @override
  String get settings_show_editor_mode_button_description =>
      'Düzenleyiciyi düzenleme modu ile okuma modu arasında değiştirmek için düğmeyi etkinleştirin';

  @override
  String get settings_open_editor_reading_mode => 'Okuma modunda açın';

  @override
  String get settings_open_editor_reading_mode_description => 'Düzenleyiciyi varsayılan olarak okuma modunda açın';

  @override
  String get settings_focus_title_on_new_note => 'Başlığa odaklanın';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Yeni bir not oluştururken içerik yerine başlığa odaklanın';

  @override
  String get settings_editor_appearance => 'Görünüm';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description => 'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'Paragraf aralığı';

  @override
  String get settings_use_paragraph_spacing_description => 'Paragraflar arasında boşluk kullanın';

  @override
  String get settings_labels => 'Etiketler';

  @override
  String get settings_labels_description => 'Görünümü etkinleştir';

  @override
  String get settings_enable_labels => 'Etkinleştir';

  @override
  String get settings_enable_labels_description =>
      'Notları etiketlerle kategorize etmeye izin ver (devre dışı bırakmak etiketleri silmez veya notlardan kaldırmaz, sadece gizler)';

  @override
  String get settings_labels_appearance => 'Görünüm';

  @override
  String get settings_show_labels_note_tile => 'Not kutucuğunda etiketleri göster';

  @override
  String get settings_show_labels_note_tile_description => 'Not kutucuklarının etiket listesini göster';

  @override
  String get settings_show_labels_editor => 'Düzenleyicide etiketleri göster';

  @override
  String get settings_show_labels_editor_description => 'Düzenleyicinin alt kısmında etiket listesini göster';

  @override
  String get settings_labels_section_behavior => 'Behavior';

  @override
  String get settings_labels_swipe_action_right => 'Right swipe action';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a label tile';

  @override
  String get settings_labels_swipe_action_left => 'Left swipe action';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a label tile';

  @override
  String get settings_backup => 'Yedekleme';

  @override
  String get settings_backup_description => 'Manuel ve otomatik dışa aktarma, şifreleme, içe aktarma';

  @override
  String get settings_backup_import => 'İçe aktar';

  @override
  String get settings_import => 'İçe aktar';

  @override
  String get settings_import_description => 'Notları, etiketleri ve ayarları bir JSON dosyasından içe aktarın';

  @override
  String get settings_backup_manual_export => 'Manuel dışa aktarma';

  @override
  String get settings_export_json => 'JSON olarak dışa aktar';

  @override
  String get settings_export_json_description =>
      'Immediately export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_export_markdown => 'Markdown olarak dışa aktar';

  @override
  String get settings_export_markdown_description => 'Immediately export all the notes to a Markdown file';

  @override
  String get settings_backup_auto_export => 'Otomatik dışa aktarma';

  @override
  String get settings_auto_export => 'Otomatik dışa aktarma';

  @override
  String get settings_auto_export_description =>
      'Automatically export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_auto_export_frequency => 'Sıklık';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Otomatik dışa aktarma sıklığı';

  @override
  String get settings_auto_export_encryption => 'Parolamak';

  @override
  String get settings_auto_export_encryption_description => 'Notların başlığını ve içeriğini bir parola ile şifreleyin';

  @override
  String get settings_auto_export_directory => 'Rehber';

  @override
  String get settings_auto_export_directory_description => 'Otomatik dışa aktarımların depolanacağı dizin';

  @override
  String get settings_security => 'Security';

  @override
  String get settings_security_description => 'Secure flag, application lock, note lock';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Application lock';

  @override
  String get settings_security_note_lock => 'Note lock';

  @override
  String get settings_flag_secure => 'Uygulamayı güvenli olarak işaretleyin';

  @override
  String get settings_flag_secure_description =>
      'Uygulamayı son uygulamalardan gizleyin ve ekran görüntüsü alınmasını engelleyin';

  @override
  String get settings_application_lock_title => 'Lock';

  @override
  String get settings_application_lock_description =>
      'Lock the application and require to authenticate with the device to unlock it';

  @override
  String get settings_application_lock_delay_title => 'Lock delay';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Note lock';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Erişilebilirlik';

  @override
  String get settings_accessibility_text_size => 'Text size';

  @override
  String get settings_accessibility_text_color => 'Text color';

  @override
  String get settings_accessibility_description => 'Metin rengi, metin ölçeklendirme';

  @override
  String get settings_text_scaling => 'Metin Ölçekleme';

  @override
  String get settings_bigger_titles => 'Bigger titles';

  @override
  String get settings_bigger_titles_description => 'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'Karanlık modda beyaz metin';

  @override
  String get settings_white_text_dark_mode_description => 'Karanlık modda metin için beyaz renk kullanın';

  @override
  String get settings_disable_subdued_note_content_preview => 'Bastırılmamış önizleme';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Not içeriği önizlemesinin bastırılmış metin rengini devre dışı bırakma';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues => 'Bir hata bildirin veya bir özellik talep edin';

  @override
  String get settings_github_issues_description =>
      'Bir GitHub sorunu oluşturarak bir hata bildirin veya bir özellik talep edin';

  @override
  String get settings_github_discussions => 'Soru sor';

  @override
  String get settings_github_discussions_description => 'GitHub tartışmalarında soru sorun';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Geliştiriciye $email adresinden posta yoluyla ulaşın';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Günlükleri kopyalayın';

  @override
  String get settings_copy_logs_description => 'Uygulamanın günlüklerini panoya kopyalayın';

  @override
  String get settings_export_logs => 'Günlüğü indir';

  @override
  String get settings_export_logs_description => 'Uygulamanın günlüklerini bir metin dosyasına aktarın';

  @override
  String get settings_about => 'Hakkında';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'Uygulama';

  @override
  String get settings_build_mode => 'Yapı Modu';

  @override
  String get settings_build_mode_release => 'Kararlı';

  @override
  String get settings_build_mode_debug => 'Hata ayıklama';

  @override
  String get settings_about_links => 'Bağlantılar';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Kaynak koduna göz at';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Crowdin projesine yerelleştirmeler ekleyin veya geliştirin';

  @override
  String get settings_licence => 'Lisans';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Başlık';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Bağlantı';

  @override
  String get hint_label_name => 'İsim';

  @override
  String get dialog_export_encryption_password => 'Parola';

  @override
  String get dialog_select_labels => 'Select tags';

  @override
  String get dialog_select_labels_to_add => 'Select tags to add';

  @override
  String get tooltip_undo => 'Son işlemi geri al';

  @override
  String get tooltip_redo => 'Son işlemi yeniden yap';

  @override
  String get tooltip_fab_add_note => 'Bir not ekle';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Etiket ekle';

  @override
  String get tooltip_fab_empty_bin => 'Çöp kutusunu boşalt';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Düzenleme moduna geçme';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Düzenleme moduna geçme';

  @override
  String get tooltip_layout_list => 'Liste görünümü';

  @override
  String get tooltip_layout_grid => 'Izgara görünümü';

  @override
  String get tooltip_sort => 'Notları sırala';

  @override
  String get tooltip_search => 'Notların içinde ara';

  @override
  String get tooltip_unselect_all => 'Tümünün seçimini kaldır';

  @override
  String get tooltip_reset => 'Sıfırla';

  @override
  String get dialog_add_link => 'Bağlantı ekle';

  @override
  String get dialog_archive => 'Archive';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Sil';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'them', one: 'it');
    return 'Do you really want to delete $count $_temp0? You can restore $_temp1 from the bin.';
  }

  @override
  String get dialog_permanently_delete => 'Kalıcı sil';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'them', one: 'it');
    return 'Do you really want to permanently delete $count $_temp0? You will not be able to restore $_temp1.';
  }

  @override
  String get dialog_restore => 'Kurtar';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Do you really want to restore $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Çöp kutusunu boşalt';

  @override
  String get dialog_empty_bin_body =>
      'Çöp kutusunu gerçekten kalıcı olarak boşaltmak istiyor musunuz? İçerdiği notları kurtaramazsınız';

  @override
  String get dialog_delete_label => 'Sil';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'tags', one: 'tag');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'They', one: 'It');
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: 'them', one: 'it');
    return 'Do you really want to delete $count $_temp0? $_temp1 will be removed from the notes where you added $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'JSON dışa aktarımını şifreleyin';

  @override
  String get dialog_export_encryption_description =>
      'Notların başlığı ve içeriği şifreniz kullanılarak şifrelenecektir. Şifre rastgele oluşturulmalı, tam olarak 32 karakter uzunluğunda, güçlü (en az 1 küçük harf, 1 büyük harf, 1 sayı ve 1 özel karakter) olmalı ve güvenli bir şekilde saklanmalıdır.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Bu şifre gelecekteki tüm otomatik dışa aktarmalar için kullanılacaktır.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Bu şifre sadece bu dışa aktarım için kullanılacaktır.';

  @override
  String get dialog_export_encryption_password_invalid => 'Geçersiz';

  @override
  String get dialog_import_encryption_password_description =>
      'Bu dışa aktarım şifrelenmiştir. İçeri aktarmak için, şifrelemek için kullanılan şifreyi sağlamanız gerekir.';

  @override
  String get dialog_import_encryption_password_error =>
      'dışa aktarmanın şifresinin çözülmesi başarısız oldu. Lütfen dışa aktarımı şifrelemek için kullandığınız parolayla aynı parolayı girip girmediğinizi kontrol edin.';

  @override
  String get dialog_label_add => 'Etiket ekle';

  @override
  String get dialog_label_edit => 'Etiketi düzenle';

  @override
  String get dialog_label_name_cannot_be_empty => 'İsim boş olamaz.';

  @override
  String get dialog_label_name_already_used => 'Bu isim zaten kullanılıyor.';

  @override
  String get button_sort_creation_date => 'Oluşturma tarihi';

  @override
  String get button_sort_edition_date => 'Düzenleme tarihi';

  @override
  String get placeholder_notes => 'Not yok';

  @override
  String get placeholder_labels => 'No tags';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'Silinen not yok';

  @override
  String get action_disabled => 'Kapalı';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Sabitle';

  @override
  String get action_unpin => 'Sabitleme';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Paylaş';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return '$count $_temp0 shared from Material Notes';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Sil';

  @override
  String get action_restore => 'Kurtar';

  @override
  String get action_delete_permanently => 'Kalıcı sil';

  @override
  String get action_about => 'Hakkında';

  @override
  String get about_last_edited => 'Son düzenleme';

  @override
  String get about_type => 'Type';

  @override
  String get about_created => 'Oluşturma tarihi';

  @override
  String get about_labels => 'Etiketler';

  @override
  String get about_words => 'Kelime';

  @override
  String get about_characters => 'Karakter';

  @override
  String get about_time_at => 'saat';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Sabitleri aç / kapat';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Düzenle';

  @override
  String get action_labels_delete => 'Sil';

  @override
  String get filter_labels_all => 'Tümü';

  @override
  String get filter_labels_visible => 'Görünür';

  @override
  String get filter_labels_hidden => 'Gizlenmiş';

  @override
  String get filter_labels_pinned => 'Sabitlendi';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed => 'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 archived';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 unarchived';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success => 'Yedekleme başarıyla içe aktarıldı.';

  @override
  String get snack_bar_export_success => 'Yedekleme başarıyla dışa aktarıldı.';

  @override
  String get snack_bar_logs_copied => 'Günlükler panonuza kopyalandı.';

  @override
  String get snack_bar_logs_exported => 'Günlükler başarıyla dışa aktarıldı.';

  @override
  String get snack_bar_no_labels => 'Etiket yok.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Materyal Notlara hoşgeldin!';

  @override
  String get welcome_note_content => 'Basit, çevrimdışı, materyal tasarımlı notlar';

  @override
  String get font_system_default => 'System default';

  @override
  String get note_type_plain_text => 'Plain text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Rich text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description => 'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description => 'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description => 'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting => 'Press back again to exit the application.';
}
