// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Semplici note salvate in locale, in stile Material Design';

  @override
  String app_about(String appName) {
    return '$appName è una applicazione per scrivere note che punta alla semplicità d\'uso. Utilizza in tutto e per tutto il Material Design. Salva localmente le tue note e non ha alcun accesso ad internet, per cui solo tu puoi accedere alle tue note.';
  }

  @override
  String get error_snack_bar => 'Errore:';

  @override
  String get error_widget_title => 'È stato riscontrato un errore.';

  @override
  String get error_widget_description =>
      'Per favore invia un report di questo problema su GitHub oppure via mail. Allega uno screenshot di questa pagina insieme ai log che puoi copiare o esportare qui sotto. Per precauzione dovresti anche esportare le tue note/appunti.';

  @override
  String get error_widget_disabled_secure_flag =>
      'L\'opzione per contrassegnare l\'app come sicura è disabilitata fino al prossimo riavvio per abilitare gli screenshot.';

  @override
  String get error_widget_button_export_notes => 'Esporta note';

  @override
  String get error_widget_button_copy_logs => 'Copia i logs';

  @override
  String get error_widget_button_export_logs => 'Esporta i log';

  @override
  String get error_widget_button_create_github_issue => 'Crea un report su GitHub';

  @override
  String get error_widget_button_send_mail => 'Invia un\'email';

  @override
  String get navigation_notes => 'Note';

  @override
  String get navigation_manage_labels_destination => 'Gestisci le etichette';

  @override
  String get navigation_manage_labels_page => 'Etichette';

  @override
  String get navigation_archives => 'Archivio';

  @override
  String get navigation_bin => 'Cestino';

  @override
  String get navigation_settings => 'Impostazioni';

  @override
  String get navigation_settings_appearance => 'Aspetto';

  @override
  String get navigation_settings_notes_types => 'Tipi di note';

  @override
  String get navigation_settings_notes_tiles => 'Riquadri delle note';

  @override
  String get navigation_settings_behavior => 'Comportamento';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Etichette';

  @override
  String get navigation_settings_backup => 'Backup';

  @override
  String get navigation_settings_security => 'Sicurezza';

  @override
  String get navigation_settings_accessibility => 'Accessibilità';

  @override
  String get navigation_settings_help => 'Aiuto';

  @override
  String get navigation_settings_about => 'Info su';

  @override
  String get button_sort_title => 'Titolo';

  @override
  String get button_sort_ascending => 'Ascendente';

  @override
  String get settings_page_appearance => 'Aspetto';

  @override
  String get settings_page_appearance_description => 'Lingua, tema, caratteri';

  @override
  String get settings_language => 'Lingua';

  @override
  String get settings_language_contribute => 'Contribuisci';

  @override
  String get settings_appearance_section_theming => 'Personalizzazione';

  @override
  String get settings_theme => 'Tema';

  @override
  String get settings_theme_system => 'Sistema';

  @override
  String get settings_theme_light => 'Chiaro';

  @override
  String get settings_theme_dark => 'Scuro';

  @override
  String get settings_dynamic_theming => 'Tema dinamico';

  @override
  String get settings_dynamic_theming_description => 'Genera colori dal sistema';

  @override
  String get settings_black_theming => 'Tema Nero';

  @override
  String get settings_black_theming_description => 'Usa uno sfondo nero in modalità scura';

  @override
  String get settings_appearance_section_fonts => 'Caratteri';

  @override
  String get settings_app_font => 'Carattere dell\'app';

  @override
  String get settings_app_font_description =>
      'Carattere utilizzato per tutti i testi dell\'applicazione, tranne che nell\'editor delle note';

  @override
  String get settings_editor_font => 'Carattere dell\'editor';

  @override
  String get settings_editor_font_description => 'Carattere utilizzato solo per il testo nell\'editor delle note';

  @override
  String get settings_page_notes_tiles => 'Riquadri delle note';

  @override
  String get settings_page_notes_tiles_description => 'Aspetto, contenuto';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Aspetto';

  @override
  String get settings_page_notes_tiles_content_section => 'Contenuto';

  @override
  String get settings_show_tiles_background => 'Sfondo';

  @override
  String get settings_show_tiles_background_description => 'Mostra lo sfondo dei riquadri delle note';

  @override
  String get settings_show_separators => 'Separatori';

  @override
  String get settings_show_separators_description => 'Mostra una linea di separazione tra i riquadri delle note';

  @override
  String get settings_show_note_type_icon => 'Mostra icona del tipo';

  @override
  String get settings_show_note_type_icon_description => 'Mostra l\'icona del tipo della nota';

  @override
  String get settings_show_titles_only => 'Solo titoli';

  @override
  String get settings_show_titles_only_description => 'Mostra solo i titoli delle note';

  @override
  String get settings_show_titles_only_disable_in_search_view => 'Disabilita i titoli solo nella vista di ricerca';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Disabilita l\'opzione \"mostra solo i titoli\" nella vista di ricerca';

  @override
  String get settings_content_preview_max_lines => 'Righe di anteprima massime';

  @override
  String get settings_content_preview_max_lines_description =>
      'Numero massimo di righe dell\'anteprima del contenuto da mostrare';

  @override
  String get settings_behavior => 'Comportamento';

  @override
  String get settings_behavior_description => 'Conferme, azioni di scorrimento';

  @override
  String get settings_behavior_application => 'Applicazione';

  @override
  String get settings_confirmations => 'Dialoghi di conferma';

  @override
  String get settings_confirmations_description => 'Quali azioni su una nota mostrano un dialogo di conferma';

  @override
  String get settings_confirmations_title_none => 'Mai';

  @override
  String get settings_confirmations_title_irreversible => 'Solo azioni irreversibili';

  @override
  String get settings_confirmations_title_all => 'Sempre';

  @override
  String get settings_auto_remove_from_bin_title => 'Rimozione automatica';

  @override
  String get settings_auto_remove_from_bin_description => 'Rimuove automaticamente le note dal cestino';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'Dopo 1 settimana',
      '14': 'Dopo 2 settimane',
      '30': 'Dopo 1 mese',
      '90': 'Dopo 3 mesi',
      '180': 'Dopo 6 mesi',
      '365': 'Dopo 1 anno',
      'other': 'Mai',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Azioni di scorrimento';

  @override
  String get settings_behavior_swipe_actions_archives => 'Azioni di scorrimento (Archivio)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Azioni di scorrimento (nel cestino)';

  @override
  String get settings_swipe_action_right => 'Azione di scorrimento verso destra';

  @override
  String get settings_swipe_action_right_description =>
      'Azione che viene eseguita dopo uno scorrimento verso destra su una nota';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Azione che viene eseguita dopo uno scorrimento verso destra, su una nota che si trova nel cestino';

  @override
  String get settings_swipe_action_left => 'Azione di scorrimento verso sinistra';

  @override
  String get settings_swipe_action_left_description =>
      'Azione che viene eseguita dopo uno scorrimento verso sinistra su una nota';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Azione che viene eseguita dopo uno scorrimento verso sinistra, su una nota che si trova nel cestino';

  @override
  String get settings_page_notes_types => 'Tipi di note';

  @override
  String get settings_page_notes_types_description => 'Tipi da utilizzare, testo avanzato';

  @override
  String get settings_section_types_to_use => 'Tipi da utilizzare';

  @override
  String get settings_available_notes_types => 'Tipi di note disponibili';

  @override
  String get settings_available_notes_types_description =>
      'La lista di tipi di note che posso essere creati con il pulsante \"+\" dalla pagina delle note. Quando rimuovi un tipo, le note esistenti di quel tipo non saranno rimosse e rimarranno utilizzabili';

  @override
  String get settings_available_default_share_type => 'Tipo da condivisione';

  @override
  String get settings_available_default_share_type_description =>
      'Il tipo predefinito di nota da utilizzare quando si crea una nota da una condivisione. Può essere un tipo non disponibile dal tasto \"+\"';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Comportamenti';

  @override
  String get settings_editor_behavior => 'Comportamenti';

  @override
  String get settings_show_editor_mode_button => 'Pulsante di cambio modalità nell\'editor';

  @override
  String get settings_show_editor_mode_button_description =>
      'Abilita il pulsante per cambiare dalla modalità editing alla modalità lettura, e viceversa';

  @override
  String get settings_open_editor_reading_mode => 'Apri in modalità lettura';

  @override
  String get settings_open_editor_reading_mode_description => 'Apri l\'editor in modalità lettura di default';

  @override
  String get settings_focus_title_on_new_note => 'Metti a fuoco il titolo';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Quando si crea una nuova nota, il cursore di scrittura è posizionato sul titolo invece che sul contenuto';

  @override
  String get settings_editor_appearance => 'Aspetto';

  @override
  String get settings_toolbar_style_title => 'Stile barra degli strumenti';

  @override
  String get settings_toolbar_style_description => 'Stile della barra degli strumenti dell\'editor di testo avanzato';

  @override
  String get settings_use_paragraph_spacing => 'Spaziatura dei paragrafi';

  @override
  String get settings_use_paragraph_spacing_description => 'Inserisci della spaziatura tra paragrafi';

  @override
  String get settings_labels => 'Etichette';

  @override
  String get settings_labels_description => 'Abilita, aspetto';

  @override
  String get settings_enable_labels => 'Abilita';

  @override
  String get settings_enable_labels_description =>
      'Permetti di categorizzare le note con delle etichette (disabilitare questa impostazione non elimina le etichette né le rimuove dalle note, le nasconde soltanto)';

  @override
  String get settings_labels_appearance => 'Aspetto';

  @override
  String get settings_show_labels_note_tile => 'Mostra le etichette sul riquadro della nota';

  @override
  String get settings_show_labels_note_tile_description => 'Mostra l\'elenco delle etichette sui riquadri delle note';

  @override
  String get settings_show_labels_editor => 'Mostra le etichette nell\'editor';

  @override
  String get settings_show_labels_editor_description =>
      'Mostra l\'elenco delle etichette nella parte inferiore dell\'editor';

  @override
  String get settings_labels_section_behavior => 'Comportamento';

  @override
  String get settings_labels_swipe_action_right => 'Azione di scorrimento a destra';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Azione che viene eseguita dopo uno scorrimento verso destra su una nota';

  @override
  String get settings_labels_swipe_action_left => 'Azione di scorrimento a sinistra';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Azione che viene eseguita dopo uno scorrimento verso sinistra su una nota';

  @override
  String get settings_backup => 'Backup';

  @override
  String get settings_backup_description => 'Esportazione manuale e automatica, crittografia, importazione';

  @override
  String get settings_backup_import => 'Importazione';

  @override
  String get settings_import => 'Importa';

  @override
  String get settings_import_description => 'Importa note, etichette e impostazioni da un file JSON';

  @override
  String get settings_backup_manual_export => 'Esportazione manuale';

  @override
  String get settings_export_json => 'Esporta in formato JSON';

  @override
  String get settings_export_json_description =>
      'Esposta immediatamente tutte le note, le etichette e le impostazioni in un file JSON che può essere importato nuovamente';

  @override
  String get settings_export_markdown => 'Esporta come Markdown';

  @override
  String get settings_export_markdown_description => 'Esporta immediatamente tutte le note in un file Markdown';

  @override
  String get settings_backup_auto_export => 'Esportazione automatica';

  @override
  String get settings_auto_export => 'Esportazione automatica';

  @override
  String get settings_auto_export_description =>
      'Esposta automaticamente tutte le note, le etichette e le impostazioni in un file JSON che può essere importato nuovamente';

  @override
  String get settings_auto_export_frequency => 'Frequenza';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'giorno',
      '7': 'settimana',
      '14': '2 settimane',
      '30': 'mese',
      'other': '',
    });
    return 'Ogni $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Frequenza delle esportazioni automatiche';

  @override
  String get settings_auto_export_encryption => 'Cifratura';

  @override
  String get settings_auto_export_encryption_description =>
      'Crittografa il titolo e il contenuto delle note con una password';

  @override
  String get settings_auto_export_directory => 'Directory';

  @override
  String get settings_auto_export_directory_description => 'Directory dove salvare le esportazioni automatiche';

  @override
  String get settings_security => 'Sicurezza';

  @override
  String get settings_security_description => 'Contrassegno sicurezza, blocco applicazione, blocco note';

  @override
  String get settings_security_application => 'Applicazione';

  @override
  String get settings_security_application_lock => 'Blocca applicazione';

  @override
  String get settings_security_note_lock => 'Blocca note';

  @override
  String get settings_flag_secure => 'Contrassegna l\'applicazione come sicura';

  @override
  String get settings_flag_secure_description =>
      'Nasconde l\'applicazione dalle app recenti e impedisce che vengano eseguiti screenshot';

  @override
  String get settings_application_lock_title => 'Blocca';

  @override
  String get settings_application_lock_description =>
      'Blocca lapplicazione e richiedi lautenticazione sul dispositivo per lo sblocco';

  @override
  String get settings_application_lock_delay_title => 'Ritardo di blocco';

  @override
  String get settings_application_lock_delay_description =>
      'Tempo dopo il quale l\'applicazione si blocca una volta messa in secondo piano';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediatamente',
      '3': 'Dopo 3 secondi',
      '5': 'Dopo 5 secondi',
      '10': 'Dopo 10 secondi',
      '30': 'Dopo 30 secondi',
      '60': 'Dopo 1 minuto',
      '120': 'Dopo 2 minuti',
      '300': 'Dopo 5 minuti',
      'other': 'Mai',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Blocca le note';

  @override
  String get settings_note_lock_description =>
      'Blocca le note e richiedi l\'autenticazione sul dispositivo per visualizzarle e modificarle';

  @override
  String get settings_label_lock_title => 'Blocca le etichette';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Accessibilità';

  @override
  String get settings_accessibility_text_size => 'Dimensione del testo';

  @override
  String get settings_accessibility_text_color => 'Colore del testo';

  @override
  String get settings_accessibility_description => 'Colore del testo, ridimensionamento testo';

  @override
  String get settings_text_scaling => 'Ridimensionamento del testo';

  @override
  String get settings_bigger_titles => 'Titoli più grandi';

  @override
  String get settings_bigger_titles_description => 'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'Testo bianco in modalità scura';

  @override
  String get settings_white_text_dark_mode_description => 'Usa un colore bianco per il testo in modalità scura';

  @override
  String get settings_disable_subdued_note_content_preview => 'Anteprima non sbiadita';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Disabilita il colore del testo \"sbiadito\" nell\'anteprima del contenuto delle note';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues => 'Segnala un bug o suggerisci nuove funzioni';

  @override
  String get settings_github_issues_description =>
      'Segnala un bug o richiedi nuove funzioni creando un Issue su GitHub';

  @override
  String get settings_github_discussions => 'Fai una domanda';

  @override
  String get settings_github_discussions_description => 'Fai una domanda sulle discussioni su GitHub';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Contatta lo sviluppatore inviando una mail a $email';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Copia i log';

  @override
  String get settings_copy_logs_description => 'Copia i log dell\'applicazione negli appunti';

  @override
  String get settings_export_logs => 'Esporta i log';

  @override
  String get settings_export_logs_description => 'Esporta i log dell\'applicazione in un file di testo';

  @override
  String get settings_about => 'Informazioni';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'Applicazione';

  @override
  String get settings_build_mode => 'Build mode';

  @override
  String get settings_build_mode_release => 'Rilascio';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => 'Link';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Dai un\'occhiata al codice sorgente';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Aggiungi o migliora le localizzazioni tramite Crowdin';

  @override
  String get settings_licence => 'Licenza';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Titolo';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Link';

  @override
  String get hint_label_name => 'Nome';

  @override
  String get dialog_export_encryption_password => 'Password';

  @override
  String get dialog_select_labels => 'Seleziona etichette';

  @override
  String get dialog_select_labels_to_add => 'Seleziona etichette da aggiungere';

  @override
  String get tooltip_undo => 'Annulla l\'ultima azione';

  @override
  String get tooltip_redo => 'Ripeti l\'ultima azione';

  @override
  String get tooltip_fab_add_note => 'Aggiungi una nota';

  @override
  String get tooltip_fab_add_plain_text_note => 'Aggiungi una nota in testo semplice';

  @override
  String get tooltip_fab_add_markdown_note => 'Aggiungi una nota in Markdown';

  @override
  String get tooltip_fab_add_rich_text_note => 'Aggiungi una nota in testo avanzato';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Aggiungi un\'etichetta';

  @override
  String get tooltip_fab_empty_bin => 'Svuota il cestino';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Passa alla modalità di editing';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Passa alla modalità di lettura';

  @override
  String get tooltip_layout_list => 'Vista a elenco';

  @override
  String get tooltip_layout_grid => 'Vista a griglia';

  @override
  String get tooltip_sort => 'Ordina le note';

  @override
  String get tooltip_search => 'Cerca tra le note';

  @override
  String get tooltip_unselect_all => 'Deseleziona tutto';

  @override
  String get tooltip_reset => 'Reset';

  @override
  String get dialog_add_link => 'Aggiungi un link';

  @override
  String get dialog_archive => 'Archivio';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'note', one: 'nota');
    return 'Vuoi davvero archiviare $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Ripristina';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'note', one: 'nota');
    return 'Vuoi davvero ripristinare $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Elimina';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'note', one: 'nota');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'le', one: 'la');
    return 'Vuoi davvero eliminare $count $_temp0? Puoi ripristinar$_temp1 dal cestino.';
  }

  @override
  String get dialog_permanently_delete => 'Elimina definitivamente';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'note', one: 'nota');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'le', one: 'la');
    return 'Vuoi davvero eliminare definitivamente $count $_temp0? Non potrai ripristinar$_temp1 dal cestino.';
  }

  @override
  String get dialog_restore => 'Ripristina';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'note', one: 'nota');
    return 'Vuoi davvero ripristinare $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Svuota il cestino';

  @override
  String get dialog_empty_bin_body =>
      'Vuoi davvero svuotare definitivamente il cestino? Non sarai in grado di ripristinare le note al suo interno.';

  @override
  String get dialog_delete_label => 'Elimina';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'etichette', one: 'etichetta');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'Saranno rimosse', one: 'Sarà rimossa');
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'le hai assegnate',
      one: 'l\'hai assegnata',
    );
    return 'Vuoi davvero eliminare $count $_temp0? $_temp1 dalle note a cui $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'Crittografa il file JSON esportato';

  @override
  String get dialog_export_encryption_description =>
      'Il titolo e il contenuto delle note saranno crittografati usando la tua password. Quest\'ultima dovrebbe essere generata in maniera casuale, essere lunga esattamente 32 caratteri, essere forte (deve contenere almeno 1 carattere minuscolo, 1 maiuscolo, 1 numero e 1 carattere speciale) e memorizzata in modo sicuro.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Questa password sarà utilizzata per tutte le esportazioni automatiche future.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Questa password sarà utilizzata solo per questa esportazione.';

  @override
  String get dialog_export_encryption_password_invalid => 'Non valida';

  @override
  String get dialog_import_encryption_password_description =>
      'Questa esportazione è crittografata. Per importarla, è necessario fornire la password utilizzata per crittografarla.';

  @override
  String get dialog_import_encryption_password_error =>
      'la decifratura dell\'esportazione non è riuscita. Controlla di aver fornito la stessa password utilizzata per crittografare l\'esportazione.';

  @override
  String get dialog_label_add => 'Aggiungi etichetta';

  @override
  String get dialog_label_edit => 'Modifica etichetta';

  @override
  String get dialog_label_name_cannot_be_empty => 'Il campo nome non può essere vuoto.';

  @override
  String get dialog_label_name_already_used => 'Questo nome è già in uso.';

  @override
  String get button_sort_creation_date => 'Data di creazione';

  @override
  String get button_sort_edition_date => 'Data di modifica';

  @override
  String get placeholder_notes => 'Nessuna nota';

  @override
  String get placeholder_labels => 'Nessuna etichetta';

  @override
  String get placeholder_archives => 'Nessuna nota archiviata';

  @override
  String get placeholder_bin => 'Nessuna nota eliminata';

  @override
  String get action_disabled => 'Disattivata';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Fissa';

  @override
  String get action_unpin => 'Rimuovi dai fissati';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Condividi';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'note condivise', one: 'nota condivisa');
    return '$count $_temp0 da Material Notes';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Elimina';

  @override
  String get action_restore => 'Ripristina';

  @override
  String get action_delete_permanently => 'Elimina definitivamente';

  @override
  String get action_about => 'Info su';

  @override
  String get about_last_edited => 'Ultima modifica';

  @override
  String get about_type => 'Tipo';

  @override
  String get about_created => 'Creata il';

  @override
  String get about_labels => 'Etichette';

  @override
  String get about_words => 'Parole';

  @override
  String get about_characters => 'Caratteri';

  @override
  String get about_time_at => 'alle';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Attiva/Disattiva i pin';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Modifica';

  @override
  String get action_labels_delete => 'Elimina';

  @override
  String get filter_labels_all => 'Tutte';

  @override
  String get filter_labels_visible => 'Visibili';

  @override
  String get filter_labels_hidden => 'Nascoste';

  @override
  String get filter_labels_pinned => 'Fissate';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed => 'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Le note sono state archiviate',
      one: 'La nota è stata archiviata',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Le note sono state ripristinate',
      one: 'La nota è stata ripristinata',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Le note sono state cancellate',
      one: 'La nota è stata cancellate',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Le note sono state ripristinate',
      one: 'La nota è stata ripristinata',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success => 'Il backup è stato importato con successo.';

  @override
  String get snack_bar_export_success => 'Il backup è stato esportato con successo.';

  @override
  String get snack_bar_logs_copied => 'I log sono stati copiati negli appunti.';

  @override
  String get snack_bar_logs_exported => 'I log sono stati esportati con successo.';

  @override
  String get snack_bar_no_labels => 'Non ci sono etichette.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Benvenuto su Material Notes!';

  @override
  String get welcome_note_content => 'Semplici note salvate in locale, in stile Material Design';

  @override
  String get font_system_default => 'Predefinito del sistema';

  @override
  String get note_type_plain_text => 'Testo semplice';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Rich text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description => 'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description => 'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description => 'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting => 'Press back again to exit the application.';
}
