import 'dart:typed_data';

import 'package:asn1lib/asn1lib.dart';
import 'package:test/test.dart';

void main() {
  test('encode', () {
    var bytes = Uint8List.fromList([
      // @format:off
      0x14, 0x37, 0x77, 0x77, 0x77, 0x2E, 0x65, 0x6E, 0x74, 0x72, 0x75, 0x73,
      0x74, 0x2E, 0x6E, 0x65, 0x74, 0x2F, 0x43, 0x50, 0x53, 0x5F, 0x32, 0x30,
      0x34, 0x38, 0x20, 0x69, 0x6E, 0x63, 0x6F, 0x72, 0x70, 0x2E, 0x20, 0x62,
      0x79, 0x20, 0x72, 0x65, 0x66, 0x2E, 0x20, 0x28, 0x6C, 0x69, 0x6D, 0x69,
      0x74, 0x73, 0x20, 0x6C, 0x69, 0x61, 0x62, 0x2E, 0x29
      // @format:on
    ]);

    var time = ASN1TeletextString.fromBytes(bytes);
    expect(time.stringValue,
        'www.entrust.net/CPS_2048 incorp. by ref. (limits liab.)');
    var encoded = time.encodedBytes;
    expect(encoded.length, bytes.length);
    expect(encoded, bytes);
  });
}
