// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline =>
      'Простые, локальные заметки в стиле material design';

  @override
  String app_about(String appName) {
    return '$appName – это приложение для создания простых текстовых заметок. Приложение выполнено в стиле Material Design. Оно хранит заметки локально на устройстве и работает без подключения к Интернету, поэтому только вы имеете доступ к заметкам.';
  }

  @override
  String get error_snack_bar => 'Ошибка:';

  @override
  String get error_widget_title => 'Произошла ошибка.';

  @override
  String get error_widget_description =>
      'Пожалуйста, сообщите об этой проблеме на GitHub или по почте. Прикрепите скриншот этой страницы и логи, которые вы можете скопировать или экспортировать ниже. В качестве меры предосторожности, вы должны экспортировать ваши заметки.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Параметр для отметки приложения как безопасного отключен до следующего перезапуска, чтобы включить снимки экрана.';

  @override
  String get error_widget_button_export_notes => 'Экспортировать заметки';

  @override
  String get error_widget_button_copy_logs => 'Копировать журналы';

  @override
  String get error_widget_button_export_logs => 'Экспорт журналов';

  @override
  String get error_widget_button_create_github_issue =>
      'Создать issue на GitHub';

  @override
  String get error_widget_button_send_mail => 'Отправить письмо';

  @override
  String get navigation_notes => 'Заметки';

  @override
  String get navigation_manage_labels_destination => 'Управление тегами';

  @override
  String get navigation_manage_labels_page => 'Теги';

  @override
  String get navigation_archives => 'Archives';

  @override
  String get navigation_bin => 'Корзина';

  @override
  String get navigation_settings => 'Настройки';

  @override
  String get navigation_settings_appearance => 'Персонализация';

  @override
  String get navigation_settings_notes_types => 'Notes types';

  @override
  String get navigation_settings_notes_tiles => 'Плитки заметок';

  @override
  String get navigation_settings_behavior => 'Поведение';

  @override
  String get navigation_settings_editor => 'Редактор';

  @override
  String get navigation_settings_labels => 'Теги';

  @override
  String get navigation_settings_backup => 'Резервное копирование';

  @override
  String get navigation_settings_security => 'Security';

  @override
  String get navigation_settings_accessibility => 'Специальные возможности';

  @override
  String get navigation_settings_help => 'Help';

  @override
  String get navigation_settings_about => 'О приложении';

  @override
  String get button_sort_title => 'По заголовку';

  @override
  String get button_sort_ascending => 'По возрастанию';

  @override
  String get settings_page_appearance => 'Персонализация';

  @override
  String get settings_page_appearance_description => 'Язык, оформление, шрифты';

  @override
  String get settings_language => 'Язык';

  @override
  String get settings_language_contribute => 'Поддержать';

  @override
  String get settings_appearance_section_theming => 'Тема оформления';

  @override
  String get settings_theme => 'Тема оформления';

  @override
  String get settings_theme_system => 'По умолчанию';

  @override
  String get settings_theme_light => 'Светлая';

  @override
  String get settings_theme_dark => 'Тёмная';

  @override
  String get settings_dynamic_theming => 'Динамические цвета';

  @override
  String get settings_dynamic_theming_description =>
      'Использовать цвет, установленный в системе';

  @override
  String get settings_black_theming => 'Натуральный чёрный';

  @override
  String get settings_black_theming_description =>
      'Использовать чёрный фон при тёмной теме оформления';

  @override
  String get settings_appearance_section_fonts => 'Шрифты';

  @override
  String get settings_app_font => 'Шрифт приложения';

  @override
  String get settings_app_font_description =>
      'Шрифт, который будет использоваться в приложении';

  @override
  String get settings_editor_font => 'Шрифт редактора';

  @override
  String get settings_editor_font_description =>
      'Шрифт, который будет использоваться в редакторе';

  @override
  String get settings_page_notes_tiles => 'Плитки заметок';

  @override
  String get settings_page_notes_tiles_description => 'Внешний вид, содержимое';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Внешний вид';

  @override
  String get settings_page_notes_tiles_content_section => 'Содержимое';

  @override
  String get settings_show_tiles_background => 'Фон';

  @override
  String get settings_show_tiles_background_description =>
      'Показывать фон заметок';

  @override
  String get settings_show_separators => 'Разделители';

  @override
  String get settings_show_separators_description =>
      'Показать разделитель между заметками';

  @override
  String get settings_show_note_type_icon => 'Show type icon';

  @override
  String get settings_show_note_type_icon_description =>
      'Show the icon of the type of the note';

  @override
  String get settings_show_titles_only => 'Только заголовки';

  @override
  String get settings_show_titles_only_description =>
      'Показывать только заголовки заметок';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'Отключить заголовки только в режиме поиска';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Отключите опцию, чтобы показывать только заголовки во время поиска';

  @override
  String get settings_content_preview_max_lines =>
      'Максимум строк предварительного просмотра';

  @override
  String get settings_content_preview_max_lines_description =>
      'Максимальное количество строк для отображения предварительного просмотра содержимого';

  @override
  String get settings_behavior => 'Поведение';

  @override
  String get settings_behavior_description => 'Confirmations, swipe actions';

  @override
  String get settings_behavior_application => 'Приложение';

  @override
  String get settings_confirmations => 'Диалог подтверждения';

  @override
  String get settings_confirmations_description =>
      'Когда показывать диалоговое окно подтверждения при выполнении действия над записью';

  @override
  String get settings_confirmations_title_none => 'Никогда';

  @override
  String get settings_confirmations_title_irreversible =>
      'Только необратимые действия';

  @override
  String get settings_confirmations_title_all => 'Всегда';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description =>
      'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Действия при свайпе';

  @override
  String get settings_behavior_swipe_actions_archives =>
      'Swipe actions (archives)';

  @override
  String get settings_behavior_swipe_actions_bin =>
      'Действия при свайпе (в корзине)';

  @override
  String get settings_swipe_action_right => 'Действие при свайпе вправо';

  @override
  String get settings_swipe_action_right_description =>
      'Действие, которое будет выполняться при свайпе вправо по заметке';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Действие, которое будет выполняться при свайпе вправо по заметке в корзине';

  @override
  String get settings_swipe_action_left => 'Действие при свайпе влево';

  @override
  String get settings_swipe_action_left_description =>
      'Действие, которое будет выполняться при свайпе влево по заметке';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Действие, которое будет выполняться при свайпе влево по заметке в корзине';

  @override
  String get settings_page_notes_types => 'Notes types';

  @override
  String get settings_page_notes_types_description => 'Types to use, rich text';

  @override
  String get settings_section_types_to_use => 'Types to use';

  @override
  String get settings_available_notes_types => 'Available notes types';

  @override
  String get settings_available_notes_types_description =>
      'The list of notes types that can be created with the \"Add\" button from the notes page. When removing a type, already existing notes with that type are not deleted and can still be used normally';

  @override
  String get settings_available_default_share_type => 'Default share type';

  @override
  String get settings_available_default_share_type_description =>
      'The default note type to use when creating a note from a share action. It can be a type that is not available from the \"Add\" button';

  @override
  String get settings_editor => 'Редактор';

  @override
  String get settings_editor_description => 'Behavior';

  @override
  String get settings_editor_behavior => 'Поведение';

  @override
  String get settings_show_editor_mode_button => 'Кнопка режима редактирования';

  @override
  String get settings_show_editor_mode_button_description =>
      'Включите кнопку, чтобы переключить редактор между режимом редактирования и режимом чтения';

  @override
  String get settings_open_editor_reading_mode => 'Открыть в режиме чтения';

  @override
  String get settings_open_editor_reading_mode_description =>
      'По умолчанию открывать редактор в режиме чтения';

  @override
  String get settings_focus_title_on_new_note => 'Фокусироваться на заголовке';

  @override
  String get settings_focus_title_on_new_note_description =>
      'При создании новой заметки сфокусироваться на заголовок';

  @override
  String get settings_editor_appearance => 'Персонализация';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description =>
      'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'Расстояние между абзацами';

  @override
  String get settings_use_paragraph_spacing_description =>
      'Применять интервал между абзацами';

  @override
  String get settings_labels => 'Теги';

  @override
  String get settings_labels_description => 'Включить теги, персонализация';

  @override
  String get settings_enable_labels => 'Включить теги';

  @override
  String get settings_enable_labels_description =>
      'Позволяет организовывать заметки с помощью тегов (отключение не удаляет теги, а только скрывает их)';

  @override
  String get settings_labels_appearance => 'Персонализация';

  @override
  String get settings_show_labels_note_tile => 'Теги в карточке с заметкой';

  @override
  String get settings_show_labels_note_tile_description =>
      'Показывать теги в карточке с заметкой';

  @override
  String get settings_show_labels_editor => 'Показывать теги в редакторе';

  @override
  String get settings_show_labels_editor_description =>
      'Показывать список тегов под редактором';

  @override
  String get settings_labels_section_behavior => 'Behavior';

  @override
  String get settings_labels_swipe_action_right => 'Right swipe action';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a label tile';

  @override
  String get settings_labels_swipe_action_left => 'Left swipe action';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a label tile';

  @override
  String get settings_backup => 'Резервное копирование';

  @override
  String get settings_backup_description =>
      'Ручной и автоматический экспорт, шифрование, импорт';

  @override
  String get settings_backup_import => 'Импорт';

  @override
  String get settings_import => 'Импорт заметок';

  @override
  String get settings_import_description =>
      'Импорт заметок, тегов и настроек из JSON файла';

  @override
  String get settings_backup_manual_export => 'Ручной экспорт';

  @override
  String get settings_export_json => 'Экспортировать в формате JSON';

  @override
  String get settings_export_json_description =>
      'Immediately export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_export_markdown => 'Экспортировать в формате Markdown';

  @override
  String get settings_export_markdown_description =>
      'Immediately export all the notes to a Markdown file';

  @override
  String get settings_backup_auto_export => 'Автоматический экспорт';

  @override
  String get settings_auto_export => 'Автоматический экспорт';

  @override
  String get settings_auto_export_description =>
      'Automatically export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_auto_export_frequency => 'Периодичность';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description =>
      'Частота автоматического экспорта';

  @override
  String get settings_auto_export_encryption => 'Шифрование';

  @override
  String get settings_auto_export_encryption_description =>
      'Зашифровать заголовок и содержимое заметок паролем';

  @override
  String get settings_auto_export_directory => 'Директория';

  @override
  String get settings_auto_export_directory_description =>
      'Каталог для сохранения автоматических экспортов';

  @override
  String get settings_security => 'Security';

  @override
  String get settings_security_description =>
      'Secure flag, application lock, note lock';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Application lock';

  @override
  String get settings_security_note_lock => 'Note lock';

  @override
  String get settings_flag_secure => 'Помечать приложение как защищённое';

  @override
  String get settings_flag_secure_description =>
      'Скрывать приложение из недавних приложений и предотвращать создание скриншотов';

  @override
  String get settings_application_lock_title => 'Lock';

  @override
  String get settings_application_lock_description =>
      'Lock the application and require to authenticate with the device to unlock it';

  @override
  String get settings_application_lock_delay_title => 'Lock delay';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Note lock';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Специальные возможности';

  @override
  String get settings_accessibility_text_size => 'Размер шрифта';

  @override
  String get settings_accessibility_text_color => 'Цвет текста';

  @override
  String get settings_accessibility_description => 'Цвет текста, размер текста';

  @override
  String get settings_text_scaling => 'Размер текста';

  @override
  String get settings_bigger_titles => 'Увеличенный заголовок';

  @override
  String get settings_bigger_titles_description =>
      'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'Белый текст в тёмном режиме';

  @override
  String get settings_white_text_dark_mode_description =>
      'Использовать белый цвет для текста в тёмном режиме';

  @override
  String get settings_disable_subdued_note_content_preview =>
      'Неприглушенный предварительный просмотр';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Не приглушать цвет текста контента заметки при предварительном просмотре';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues =>
      'Сообщить об ошибке или запросить функцию';

  @override
  String get settings_github_issues_description =>
      'Сообщить об ошибке или запросить функцию, создав запрос на GitHub';

  @override
  String get settings_github_discussions => 'Задать вопрос';

  @override
  String get settings_github_discussions_description =>
      'Задайте вопрос на обсуждениях в GitHub';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Свяжитесь с разработчиком по почте $email';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Скопировать журналы';

  @override
  String get settings_copy_logs_description =>
      'Скопировать журналы приложения в буфер обмена';

  @override
  String get settings_export_logs => 'Экспорт журналов';

  @override
  String get settings_export_logs_description =>
      'Экспорт журналов приложения в текстовый файл';

  @override
  String get settings_about => 'О приложении';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'Приложение';

  @override
  String get settings_build_mode => 'Режим сборки';

  @override
  String get settings_build_mode_release => 'Release';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => 'Ссылки';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description =>
      'Ознакомьтесь с исходным кодом приложения';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description =>
      'Добавляйте или улучшайте перевод в проекте Crowdin';

  @override
  String get settings_licence => 'Лицензия';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Заголовок';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Ссылка';

  @override
  String get hint_label_name => 'Название';

  @override
  String get dialog_export_encryption_password => 'Пароль';

  @override
  String get dialog_select_labels => 'Выберите теги';

  @override
  String get dialog_select_labels_to_add => 'Выберите теги для добавления';

  @override
  String get tooltip_undo => 'Отменить последнее действие';

  @override
  String get tooltip_redo => 'Повторить последнее действие';

  @override
  String get tooltip_fab_add_note => 'Добавить заметку';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Добавить новый тег';

  @override
  String get tooltip_fab_empty_bin => 'Очистить корзину';

  @override
  String get tooltip_fab_toggle_editor_mode_edit =>
      'Переключиться в режим редактирования';

  @override
  String get tooltip_fab_toggle_editor_mode_read =>
      'Переключиться в режим чтения';

  @override
  String get tooltip_layout_list => 'Список';

  @override
  String get tooltip_layout_grid => 'Сетка';

  @override
  String get tooltip_sort => 'Сортировать заметки';

  @override
  String get tooltip_search => 'Поиск заметок';

  @override
  String get tooltip_unselect_all => 'Отменить выбор';

  @override
  String get tooltip_reset => 'Сброс';

  @override
  String get dialog_add_link => 'Добавить ссылку';

  @override
  String get dialog_archive => 'Archive';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Удалить';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'заметок',
      few: 'заметки',
      one: 'заметку',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'их',
      one: 'ее',
    );
    return 'Вы действительно хотите удалить $count $_temp0? Вы сможете восстановить $_temp1 из корзины.';
  }

  @override
  String get dialog_permanently_delete => 'Удалить';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'заметок',
      few: 'заметки',
      one: 'заметку',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'их',
      one: 'ее',
    );
    return 'Вы действительно хотите удалить навсегда $count $_temp0? Вы не сможете восстановить $_temp1.';
  }

  @override
  String get dialog_restore => 'Восстановить';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'заметок',
      few: 'заметки',
      one: 'заметку',
    );
    return 'Вы действительно хотите восстановить $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Очистить корзину';

  @override
  String get dialog_empty_bin_body =>
      'Вы действительно хотите отчистить корзину? Все заметки будут безвозвратно удалены.';

  @override
  String get dialog_delete_label => 'Удалить';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'тегов',
      few: 'тега',
      one: 'тег',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Они будут удалены',
      one: 'Он будет удален',
    );
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'их',
      one: 'его',
    );
    return 'Вы действительно хотите удалить $count $_temp0? $_temp1 из заметок, в которые вы добавили $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch =>
      'Зашифровать экспорт в формате JSON';

  @override
  String get dialog_export_encryption_description =>
      'Заметки будут зашифрованы паролем. Пароль должен быть сгенерирован случайным образом, длиной в 32 символа (должен содержать минимум 1 строчную букву, 1 заглавную букву, 1 цифру и 1 специальный символ) и храниться в надежном месте.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Этот пароль будет использован для всех автоматических экспортов заметок.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Этот пароль будет использоваться только для экспорта текущих заметок.';

  @override
  String get dialog_export_encryption_password_invalid => 'Неверно';

  @override
  String get dialog_import_encryption_password_description =>
      'Данные зашифрованы. Чтобы импортировать данные, нужно ввести пароль.';

  @override
  String get dialog_import_encryption_password_error =>
      'не удалось расшифровать данные. Убедитесь, что вы ввели правильный пароль.';

  @override
  String get dialog_label_add => 'Добавить новый тег';

  @override
  String get dialog_label_edit => 'Редактировать тег';

  @override
  String get dialog_label_name_cannot_be_empty =>
      'Название тега не может быть пустым.';

  @override
  String get dialog_label_name_already_used =>
      'Это название тега уже используется.';

  @override
  String get button_sort_creation_date => 'По дате создания';

  @override
  String get button_sort_edition_date => 'По дате редактирования';

  @override
  String get placeholder_notes => 'Нет заметок';

  @override
  String get placeholder_labels => 'Тегов нет';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'Нет удаленных заметок';

  @override
  String get action_disabled => 'Отключено';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Закрепить';

  @override
  String get action_unpin => 'Открепить';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Поделиться';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'заметок',
      few: 'заметки',
      one: 'заметка',
    );
    return '$count $_temp0 shared из Material Notes';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Удалить';

  @override
  String get action_restore => 'Восстановить';

  @override
  String get action_delete_permanently => 'Удалить навсегда';

  @override
  String get action_about => 'О заметке';

  @override
  String get about_last_edited => 'Изменено';

  @override
  String get about_type => 'Тип';

  @override
  String get about_created => 'Создано';

  @override
  String get about_labels => 'Количество тегов';

  @override
  String get about_words => 'Количество слов';

  @override
  String get about_characters => 'Количество символов';

  @override
  String get about_time_at => 'в';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Закрепить/Открепить';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Редактировать';

  @override
  String get action_labels_delete => 'Удалить';

  @override
  String get filter_labels_all => 'Все';

  @override
  String get filter_labels_visible => 'Видимые';

  @override
  String get filter_labels_hidden => 'Скрытые';

  @override
  String get filter_labels_pinned => 'Закреплённые';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed =>
      'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 archived';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 unarchived';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success =>
      'Резервная копия была успешно импортирована.';

  @override
  String get snack_bar_export_success =>
      'Резервная копия была успешно экспортирована.';

  @override
  String get snack_bar_logs_copied => 'Логи скопированы в буфер обмена.';

  @override
  String get snack_bar_logs_exported => 'Логи были успешно экспортированы.';

  @override
  String get snack_bar_no_labels => 'Нет тегов.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Добро пожаловать в Material Notes!';

  @override
  String get welcome_note_content =>
      'Простые, локальные заметки в стиле Material Design';

  @override
  String get font_system_default => 'Системный по умолчанию';

  @override
  String get note_type_plain_text => 'Plain text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Rich text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground =>
      'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background =>
      'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description =>
      'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description =>
      'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description =>
      'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description =>
      'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description =>
      'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting =>
      'Press back again to exit the application.';
}
