// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class AppLocalizationsHi extends AppLocalizations {
  AppLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get app_name => 'मटेरियल नोट्स';

  @override
  String get app_tagline => 'सरल, स्थानीय, मैटेरियल डिज़ाइन नोट्स';

  @override
  String app_about(String appName) {
    return '$appName यह एक टेक्स्ट-आधारित नोट लेने वाला एप्लिकेशन है, जो सरलता के लिए डिज़ाइन किया गया है। यह मैटेरियल डिज़ाइन का पालन करता है। यह नोट्स को स्थानीय रूप से संग्रहीत करता है और इसमें कोई इंटरनेट अनुमति नहीं है, इसलिए केवल आप ही नोट्स तक पहुँच सकते हैं।';
  }

  @override
  String get error_snack_bar => 'त्रुटी:';

  @override
  String get error_widget_title => 'एक त्रुटी हो गई है।';

  @override
  String get error_widget_description =>
      'कृपया इस समस्या की रिपोर्ट GitHub या मेल के ज़रिए करें। इस पेज और लॉग का स्क्रीनशॉट संलग्न करें जिसे आप नीचे कॉपी या एक्सपोर्ट कर सकते हैं। सावधानी के लिए आपको अपने नोट्स भी एक्सपोर्ट कर लेने चाहिए।';

  @override
  String get error_widget_disabled_secure_flag =>
      'ऐप को सुरक्षित के रूप में चिह्नित करने की सेटिंग अगले पुनः आरंभ तक अक्षम कर दी गई है, ताकि स्क्रीनशॉट सक्षम हो सके।';

  @override
  String get error_widget_button_export_notes => 'निर्यात नोट्स';

  @override
  String get error_widget_button_copy_logs => 'कॉपी लाॅग';

  @override
  String get error_widget_button_export_logs => 'निर्यात लाॅग';

  @override
  String get error_widget_button_create_github_issue => 'GitHub समस्या बनाएँ';

  @override
  String get error_widget_button_send_mail => 'मेल भेजें';

  @override
  String get navigation_notes => 'नोट्स';

  @override
  String get navigation_manage_labels_destination => 'लेबल प्रबंधन';

  @override
  String get navigation_manage_labels_page => 'लेबल';

  @override
  String get navigation_archives => 'Archives';

  @override
  String get navigation_bin => 'बिन';

  @override
  String get navigation_settings => 'सेटिंग्स';

  @override
  String get navigation_settings_appearance => 'दिखावट';

  @override
  String get navigation_settings_notes_types => 'Notes types';

  @override
  String get navigation_settings_notes_tiles => 'नोट्स टाइल्स';

  @override
  String get navigation_settings_behavior => 'व्यवहार';

  @override
  String get navigation_settings_editor => 'संपादक';

  @override
  String get navigation_settings_labels => 'लेबल';

  @override
  String get navigation_settings_backup => 'बैकअप';

  @override
  String get navigation_settings_security => 'Security';

  @override
  String get navigation_settings_accessibility => 'सुगम्यता';

  @override
  String get navigation_settings_help => 'Help';

  @override
  String get navigation_settings_about => 'के बारे में';

  @override
  String get button_sort_title => 'शीर्षक';

  @override
  String get button_sort_ascending => 'आरोही';

  @override
  String get settings_page_appearance => 'Appearance';

  @override
  String get settings_page_appearance_description => 'Language, theming, fonts';

  @override
  String get settings_language => 'भाषा';

  @override
  String get settings_language_contribute => 'योगदान';

  @override
  String get settings_appearance_section_theming => 'Theming';

  @override
  String get settings_theme => 'थीम';

  @override
  String get settings_theme_system => 'सिस्टम';

  @override
  String get settings_theme_light => 'श्वेत';

  @override
  String get settings_theme_dark => 'श्याम';

  @override
  String get settings_dynamic_theming => 'गतिशील थीमिंग';

  @override
  String get settings_dynamic_theming_description =>
      'सिस्टम से रंग उत्पन्न करें';

  @override
  String get settings_black_theming => 'काला थीमिंग';

  @override
  String get settings_black_theming_description =>
      'श्याम मोड में काली पृष्ठभूमि का उपयोग करें';

  @override
  String get settings_appearance_section_fonts => 'फ़ॉन्ट्स';

  @override
  String get settings_app_font => 'ऐप फ़ॉन्ट';

  @override
  String get settings_app_font_description =>
      'एप्लिकेशन में सभी टेक्स्ट के लिए उपयोग किया जाने वाला फ़ॉन्ट, नोट्स संपादक को छोड़कर';

  @override
  String get settings_editor_font => 'संपादक फ़ॉन्ट';

  @override
  String get settings_editor_font_description =>
      'Font used only for the text in the notes editor';

  @override
  String get settings_page_notes_tiles => 'नोट्स टाइल्स';

  @override
  String get settings_page_notes_tiles_description => 'Appearance, content';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Appearance';

  @override
  String get settings_page_notes_tiles_content_section => 'Content';

  @override
  String get settings_show_tiles_background => 'पृष्ठभूमि';

  @override
  String get settings_show_tiles_background_description =>
      'नोट्स टाइल्स की पृष्ठभूमि दिखाएं';

  @override
  String get settings_show_separators => 'विभाजक';

  @override
  String get settings_show_separators_description =>
      'नोट्स टाइल्स के बीच विभाजक दिखाएं';

  @override
  String get settings_show_note_type_icon => 'Show type icon';

  @override
  String get settings_show_note_type_icon_description =>
      'Show the icon of the type of the note';

  @override
  String get settings_show_titles_only => 'केवल शीर्षक';

  @override
  String get settings_show_titles_only_description =>
      'केवल नोट्स के शीर्षक दिखाएं';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'केवल खोज दृश्य में शीर्षक अक्षम करें';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'केवल खोज दृश्य में शीर्षक अक्षम करें';

  @override
  String get settings_content_preview_max_lines =>
      'अधिकतम पूर्वावलोकन पंक्तियाँ';

  @override
  String get settings_content_preview_max_lines_description =>
      'Maximum number of lines of the content preview to show';

  @override
  String get settings_behavior => 'व्यवहार';

  @override
  String get settings_behavior_description => 'Confirmations, swipe actions';

  @override
  String get settings_behavior_application => 'एप्लिकेशन';

  @override
  String get settings_confirmations => 'पुष्टिकरण संवाद';

  @override
  String get settings_confirmations_description =>
      'नोट पर कोई कार्रवाई करते समय पुष्टिकरण संवाद कब दिखाना है';

  @override
  String get settings_confirmations_title_none => 'कभी नहीं';

  @override
  String get settings_confirmations_title_irreversible =>
      'केवल अपरिवर्तनीय क्रियाएँ';

  @override
  String get settings_confirmations_title_all => 'सदैव';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description =>
      'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'स्वाइप क्रियाएँ';

  @override
  String get settings_behavior_swipe_actions_archives =>
      'Swipe actions (archives)';

  @override
  String get settings_behavior_swipe_actions_bin => 'स्वाइप क्रियाएँ (बिन)';

  @override
  String get settings_swipe_action_right => 'दायाँ स्वाइप क्रिया';

  @override
  String get settings_swipe_action_right_description =>
      'नोट टाइल पर दायाँ स्वाइप करने पर ट्रिगर होने वाली क्रिया';

  @override
  String get settings_bin_swipe_action_right_description =>
      'बिन में नोट टाइल पर दायाँ स्वाइप करने पर ट्रिगर होने वाली क्रिया';

  @override
  String get settings_swipe_action_left => 'बाएँ स्वाइप क्रिया';

  @override
  String get settings_swipe_action_left_description =>
      'नोट टाइल पर बाईं ओर स्वाइप करने पर ट्रिगर होने वाली क्रिया';

  @override
  String get settings_bin_swipe_action_left_description =>
      'बिन में नोट टाइल पर बाईं स्वाइप करने पर ट्रिगर होने वाली क्रिया';

  @override
  String get settings_page_notes_types => 'Notes types';

  @override
  String get settings_page_notes_types_description => 'Types to use, rich text';

  @override
  String get settings_section_types_to_use => 'Types to use';

  @override
  String get settings_available_notes_types => 'Available notes types';

  @override
  String get settings_available_notes_types_description =>
      'The list of notes types that can be created with the \"Add\" button from the notes page. When removing a type, already existing notes with that type are not deleted and can still be used normally';

  @override
  String get settings_available_default_share_type => 'Default share type';

  @override
  String get settings_available_default_share_type_description =>
      'The default note type to use when creating a note from a share action. It can be a type that is not available from the \"Add\" button';

  @override
  String get settings_editor => 'संपादक';

  @override
  String get settings_editor_description => 'Behavior';

  @override
  String get settings_editor_behavior => 'व्यवहार';

  @override
  String get settings_show_editor_mode_button => 'संपादक मोड बटन';

  @override
  String get settings_show_editor_mode_button_description =>
      'संपादन मोड और पठन मोड के बीच संपादक को टॉगल करने के लिए बटन को सक्षम करें';

  @override
  String get settings_open_editor_reading_mode => 'पठन मोड में खोलें';

  @override
  String get settings_open_editor_reading_mode_description =>
      'संपादक को डिफ़ॉल्ट रूप से पठन मोड में खोलें';

  @override
  String get settings_focus_title_on_new_note => 'शीर्षक पर ध्यान करें';

  @override
  String get settings_focus_title_on_new_note_description =>
      'नया नोट बनाते समय विषय-वस्तु के बजाय शीर्षक पर ध्यान';

  @override
  String get settings_editor_appearance => 'दिखावट';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description =>
      'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'पैराग्राफ़ स्पेसिंग';

  @override
  String get settings_use_paragraph_spacing_description =>
      'पैराग्राफ़ के बीच स्पेसिंग का उपयोग करें';

  @override
  String get settings_labels => 'लेबल';

  @override
  String get settings_labels_description => 'सक्षम, दिखावट';

  @override
  String get settings_enable_labels => 'सक्षम';

  @override
  String get settings_enable_labels_description =>
      'नोट्स को लेबल्स के साथ वर्गीकृत करने की अनुमति दें (इसे अक्षम करने से लेबल नहीं हटते हैं और न ही उन्हें नोट्स से हटाया जाता है, यह केवल उन्हें छिपाता है)';

  @override
  String get settings_labels_appearance => 'दिखावट';

  @override
  String get settings_show_labels_note_tile => 'नोट टाइल पर लेबल दिखाएं';

  @override
  String get settings_show_labels_note_tile_description =>
      'नोट टाइल्स के लेबल की सूची दिखाएं';

  @override
  String get settings_show_labels_editor => 'संपादक में लेबल दिखाएं';

  @override
  String get settings_show_labels_editor_description =>
      'लेबल की सूची संपादक के निचले भाग में दिखाएँ';

  @override
  String get settings_labels_section_behavior => 'Behavior';

  @override
  String get settings_labels_swipe_action_right => 'Right swipe action';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a label tile';

  @override
  String get settings_labels_swipe_action_left => 'Left swipe action';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a label tile';

  @override
  String get settings_backup => 'बैकअप';

  @override
  String get settings_backup_description =>
      'मैनुअल और स्वचालित निर्यात, एन्क्रिप्शन, आयात';

  @override
  String get settings_backup_import => 'आयात';

  @override
  String get settings_import => 'आयात';

  @override
  String get settings_import_description =>
      'JSON फ़ाइल से नोट्स, लेबल्स और सेटिंग्स आयात करें';

  @override
  String get settings_backup_manual_export => 'मैनुअल निर्यात';

  @override
  String get settings_export_json => 'JSON के रूप में निर्यात करें';

  @override
  String get settings_export_json_description =>
      'Immediately export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_export_markdown => 'मार्कडाउन के रूप में निर्यात करें';

  @override
  String get settings_export_markdown_description =>
      'Immediately export all the notes to a Markdown file';

  @override
  String get settings_backup_auto_export => 'स्वचालित निर्यात';

  @override
  String get settings_auto_export => 'स्वचालित निर्यात';

  @override
  String get settings_auto_export_description =>
      'Automatically export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_auto_export_frequency => 'आवृत्ति';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description =>
      'स्वचालित निर्यात की आवृत्ति';

  @override
  String get settings_auto_export_encryption => 'एन्क्रिप्शन';

  @override
  String get settings_auto_export_encryption_description =>
      'नोट्स के शीर्षक और सामग्री को पासवर्ड से एन्क्रिप्ट करें';

  @override
  String get settings_auto_export_directory => 'निर्देशिका';

  @override
  String get settings_auto_export_directory_description =>
      'निर्देशिका जहां स्वचालित निर्यात को संग्रहीत किया जाना है';

  @override
  String get settings_security => 'Security';

  @override
  String get settings_security_description =>
      'Secure flag, application lock, note lock';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Application lock';

  @override
  String get settings_security_note_lock => 'Note lock';

  @override
  String get settings_flag_secure => 'ऐप को सुरक्षित के रूप में चिह्नित करें';

  @override
  String get settings_flag_secure_description =>
      'ऐप को हाल के ऐप्स से छिपाएं और स्क्रीनशॉट लेने से रोकें';

  @override
  String get settings_application_lock_title => 'Lock';

  @override
  String get settings_application_lock_description =>
      'Lock the application and require to authenticate with the device to unlock it';

  @override
  String get settings_application_lock_delay_title => 'Lock delay';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Note lock';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'सुगम्यता';

  @override
  String get settings_accessibility_text_size => 'Text size';

  @override
  String get settings_accessibility_text_color => 'Text color';

  @override
  String get settings_accessibility_description => 'पाठ का रंग, पाठ का आकार';

  @override
  String get settings_text_scaling => 'पाठ का आकार';

  @override
  String get settings_bigger_titles => 'बड़े शीर्षक';

  @override
  String get settings_bigger_titles_description =>
      'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'डार्क मोड में सफ़ेद टेक्स्ट';

  @override
  String get settings_white_text_dark_mode_description =>
      'डार्क मोड में टेक्स्ट के लिए सफ़ेद रंग का उपयोग करें';

  @override
  String get settings_disable_subdued_note_content_preview =>
      'उज्ज्वल पूर्वावलोकन';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'नोट्स सामग्री पूर्वावलोकन के हल्के अक्षर रंग को अक्षम करें';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues =>
      'त्रुटि की रिपोर्ट करें या सुविधा का अनुरोध करें';

  @override
  String get settings_github_issues_description =>
      'GitHub समस्या बनाकर त्रुटि की रिपोर्ट करें या सुविधा का अनुरोध करें';

  @override
  String get settings_github_discussions => 'प्रश्न पूछें';

  @override
  String get settings_github_discussions_description =>
      'GitHub चर्चाओं पर प्रश्न पूछें';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'निर्माणक से $email पर मेल द्वारा संपर्क करें';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'लॉग कॉपी करें';

  @override
  String get settings_copy_logs_description =>
      'एप्लिकेशन के लॉग को क्लिपबोर्ड पर कॉपी करें';

  @override
  String get settings_export_logs => 'लॉग निर्यात करें';

  @override
  String get settings_export_logs_description =>
      'एप्लिकेशन के लॉग को टेक्स्ट फ़ाइल में निर्यात करें';

  @override
  String get settings_about => 'के बारे में';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'एप्लिकेशन';

  @override
  String get settings_build_mode => 'निर्माण मोड';

  @override
  String get settings_build_mode_release => 'संस्करण';

  @override
  String get settings_build_mode_debug => 'त्रुटि निवारण';

  @override
  String get settings_about_links => 'लिंक';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'स्रोत कोड पर एक नज़र डालें';

  @override
  String get settings_localizations => 'क्राउडिन';

  @override
  String get settings_localizations_description =>
      'क्राउडिन परियोजना पर स्थानीयकरण जोड़ें या सुधारें';

  @override
  String get settings_licence => 'लाइसेंस';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'शीर्षक';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'लिंक';

  @override
  String get hint_label_name => 'नाम';

  @override
  String get dialog_export_encryption_password => 'पासवर्ड';

  @override
  String get dialog_select_labels => 'लेबल्स चुनें';

  @override
  String get dialog_select_labels_to_add => 'जोड़ने के लिए लेबल्स चुनें';

  @override
  String get tooltip_undo => 'अंतिम क्रिया पूर्ववत करें';

  @override
  String get tooltip_redo => 'अंतिम क्रिया पुनः करें';

  @override
  String get tooltip_fab_add_note => 'नोट जोड़े';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'लेबल जोड़ें';

  @override
  String get tooltip_fab_empty_bin => 'बिन खाली करें';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'संपादन मोड पर स्विच करें';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'रीडिंग मोड पर स्विच करें';

  @override
  String get tooltip_layout_list => 'सूची व्यू';

  @override
  String get tooltip_layout_grid => 'ग्रिड व्यू';

  @override
  String get tooltip_sort => 'नोट्स को क्रमबद्ध करें';

  @override
  String get tooltip_search => 'नोट्स खोजें';

  @override
  String get tooltip_unselect_all => 'सभी अचयनित';

  @override
  String get tooltip_reset => 'रीसेट';

  @override
  String get dialog_add_link => 'लिंक जोड़ें';

  @override
  String get dialog_archive => 'Archive';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'मिटाए';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'Do you really want to delete $count $_temp0? You can restore $_temp1 from the bin.';
  }

  @override
  String get dialog_permanently_delete => 'स्थायी रूप से मिटाए';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'Do you really want to permanently delete $count $_temp0? You will not be able to restore $_temp1.';
  }

  @override
  String get dialog_restore => 'पुनर्स्थापित करें';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to restore $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'बिन खाली करें';

  @override
  String get dialog_empty_bin_body =>
      'क्या आप वाकई बिन को हमेशा के लिए खाली करना चाहते हैं? आप उसमें मौजूद नोट्स को वापस नहीं ला पाएंगे।';

  @override
  String get dialog_delete_label => 'मिटाए';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'tags',
      one: 'tag',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They',
      one: 'It',
    );
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'Do you really want to delete $count $_temp0? $_temp1 will be removed from the notes where you added $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'JSON निर्यात एन्क्रिप्ट करें';

  @override
  String get dialog_export_encryption_description =>
      'नोट्स का शीर्षक और सामग्री आपके पासवर्ड का उपयोग करके एन्क्रिप्ट की जाएगी। यह यादृच्छिक रूप से उत्पन्न होना चाहिए, ठीक 32 अक्षर लंबा, मजबूत (कम से कम 1 लोअरकेस, 1 अपरकेस, 1 नंबर और 1 विशेष वर्ण) और सुरक्षित रूप से संग्रहीत होना चाहिए।';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'इस पासवर्ड का उपयोग भविष्य में सभी स्वचालित निर्यातों के लिए किया जाएगा।';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'इस पासवर्ड का उपयोग केवल इस निर्यात के लिए किया जाएगा।';

  @override
  String get dialog_export_encryption_password_invalid => 'अमान्य';

  @override
  String get dialog_import_encryption_password_description =>
      'यह निर्यात एन्क्रिप्टेड है। इसे आयात करने के लिए, आपको इसे एन्क्रिप्ट करने के लिए उपयोग किया गया पासवर्ड प्रदान करना होगा।';

  @override
  String get dialog_import_encryption_password_error =>
      'निर्यात को डिक्रिप्ट करना विफल रहा। कृपया जाँच लें कि आपने वही पासवर्ड दिया है जो आपने निर्यात को एन्क्रिप्ट करने के लिए इस्तेमाल किया था।';

  @override
  String get dialog_label_add => 'लेबल जोड़ें';

  @override
  String get dialog_label_edit => 'लेबल संपादित करें';

  @override
  String get dialog_label_name_cannot_be_empty => 'नाम रिक्त नहीं रह सकता।';

  @override
  String get dialog_label_name_already_used =>
      'यह नाम पहले से ही प्रयोग किया जा रहा है।';

  @override
  String get button_sort_creation_date => 'निर्माण तिथि';

  @override
  String get button_sort_edition_date => 'संस्करण तिथि';

  @override
  String get placeholder_notes => 'कोई नोट्स नहीं';

  @override
  String get placeholder_labels => 'कोई लेबल्स नहीं';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'कोई भी नोट्स मिटाया नहीं गया';

  @override
  String get action_disabled => 'अक्षम';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'पिन';

  @override
  String get action_unpin => 'अनपिन';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'शेयर';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return '$count $_temp0 shared from Material Notes';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'मिटाए';

  @override
  String get action_restore => 'पुनर्स्थापित';

  @override
  String get action_delete_permanently => 'स्थायी रूप से मिटाए';

  @override
  String get action_about => 'के बारे में';

  @override
  String get about_last_edited => 'अंतिम संपादन';

  @override
  String get about_type => 'प्रकार';

  @override
  String get about_created => 'बनाया था';

  @override
  String get about_labels => 'लेबल्स';

  @override
  String get about_words => 'शब्द';

  @override
  String get about_characters => 'वर्ण';

  @override
  String get about_time_at => 'पर';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'टॉगल पिन';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'संपादन';

  @override
  String get action_labels_delete => 'मिटाए';

  @override
  String get filter_labels_all => 'सभी';

  @override
  String get filter_labels_visible => 'दृश्यमान';

  @override
  String get filter_labels_hidden => 'छिपाया गया';

  @override
  String get filter_labels_pinned => 'पिन किया गया';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed =>
      'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 archived';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 unarchived';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success => 'बैकअप सफलतापूर्वक आयात किया गया।';

  @override
  String get snack_bar_export_success => 'बैकअप सफलतापूर्वक निर्यात किया गया।';

  @override
  String get snack_bar_logs_copied =>
      'लॉग आपके क्लिपबोर्ड पर कॉपी कर दिए गए हैं।';

  @override
  String get snack_bar_logs_exported => 'लॉग सफलतापूर्वक निर्यात किए गए।';

  @override
  String get snack_bar_no_labels => 'कोई लेबल्स नहीं है।';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'मैटेरियल नोट्स में आपका स्वागत है!';

  @override
  String get welcome_note_content => 'सरल, स्थानीय, मैटेरियल डिज़ाइन नोट्स';

  @override
  String get font_system_default => 'सिस्टम डिफॉल्ट';

  @override
  String get note_type_plain_text => 'Plain text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Rich text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground =>
      'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background =>
      'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description =>
      'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description =>
      'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description =>
      'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description =>
      'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description =>
      'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting =>
      'Press back again to exit the application.';
}
