// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Notas simples, locais, em material design';

  @override
  String app_about(String appName) {
    return '$appName é um aplicativo de anotações com base em texto, destinado à simplicidade. Abraça Material Design. Ele armazena as notas localmente e não possui nenhuma permissão de internet, então você é o único que pode acessar as notas.';
  }

  @override
  String get error_snack_bar => 'Erro:';

  @override
  String get error_widget_title => 'Ocorreu um erro.';

  @override
  String get error_widget_description =>
      'Por favor, reporte este problema no GitHub ou por email. Anexe uma captura de tela desta página e os logs que você pode copiar ou exportar abaixo. Por precaução, você também deve exportar as suas notas.';

  @override
  String get error_widget_disabled_secure_flag =>
      'A configuração para sinalizar o aplicativo como seguro fica desabilitada até a próxima reinicialização para habilitar capturas de tela.';

  @override
  String get error_widget_button_export_notes => 'Exportar notas';

  @override
  String get error_widget_button_copy_logs => 'Copiar logs';

  @override
  String get error_widget_button_export_logs => 'Exportar logs';

  @override
  String get error_widget_button_create_github_issue => 'Criar issue no GitHub';

  @override
  String get error_widget_button_send_mail => 'Enviar email';

  @override
  String get navigation_notes => 'Notas';

  @override
  String get navigation_manage_labels_destination => 'Gerenciar etiquetas';

  @override
  String get navigation_manage_labels_page => 'Rótulos';

  @override
  String get navigation_archives => 'Arquivos';

  @override
  String get navigation_bin => 'Lixeira';

  @override
  String get navigation_settings => 'Configurações';

  @override
  String get navigation_settings_appearance => 'Aparência';

  @override
  String get navigation_settings_notes_types => 'Tipos de notas';

  @override
  String get navigation_settings_notes_tiles => 'Telhas de notas';

  @override
  String get navigation_settings_behavior => 'Comportamento';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Rótulos';

  @override
  String get navigation_settings_backup => 'Backup';

  @override
  String get navigation_settings_security => 'Security';

  @override
  String get navigation_settings_accessibility => 'Acessibilidade';

  @override
  String get navigation_settings_help => 'Help';

  @override
  String get navigation_settings_about => 'Sobre';

  @override
  String get button_sort_title => 'Título';

  @override
  String get button_sort_ascending => 'Crescente';

  @override
  String get settings_page_appearance => 'Aparência';

  @override
  String get settings_page_appearance_description => 'Idioma, temas, fontes';

  @override
  String get settings_language => 'Idioma';

  @override
  String get settings_language_contribute => 'Contribuir';

  @override
  String get settings_appearance_section_theming => 'Temas';

  @override
  String get settings_theme => 'Tema';

  @override
  String get settings_theme_system => 'Sistema';

  @override
  String get settings_theme_light => 'Claro';

  @override
  String get settings_theme_dark => 'Escuro';

  @override
  String get settings_dynamic_theming => 'Tema dinâmico';

  @override
  String get settings_dynamic_theming_description =>
      'Gerar cores a partir do sistema';

  @override
  String get settings_black_theming => 'Tema preto';

  @override
  String get settings_black_theming_description =>
      'Use um fundo preto no modo escuro';

  @override
  String get settings_appearance_section_fonts => 'Fontes';

  @override
  String get settings_app_font => 'Fonte do aplicativo';

  @override
  String get settings_app_font_description =>
      'Fonte usada para todos os textos no aplicativo, exceto no editor de notas';

  @override
  String get settings_editor_font => 'Fonte do editor';

  @override
  String get settings_editor_font_description =>
      'Fonte usada somente para o texto no editor de notas';

  @override
  String get settings_page_notes_tiles => 'Telhas de notas';

  @override
  String get settings_page_notes_tiles_description => 'Aparência, conteúdo';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Aparência';

  @override
  String get settings_page_notes_tiles_content_section => 'Conteúdo';

  @override
  String get settings_show_tiles_background => 'Plano de Fundo';

  @override
  String get settings_show_tiles_background_description =>
      'Mostrar o fundo dos blocos de notas';

  @override
  String get settings_show_separators => 'Separadores';

  @override
  String get settings_show_separators_description =>
      'Mostrar um separador entre os blocos de notas';

  @override
  String get settings_show_note_type_icon => 'Exibir ícone de tipo';

  @override
  String get settings_show_note_type_icon_description =>
      'Exibir o ícone do tipo da nota';

  @override
  String get settings_show_titles_only => 'Títulos apenas';

  @override
  String get settings_show_titles_only_description =>
      'Mostrar apenas os títulos das notas';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'Desabilitar títulos somente na tela de pesquisa';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Desativar a opção de mostrar apenas os títulos na exibição de pesquisa';

  @override
  String get settings_content_preview_max_lines =>
      'Máximo de linhas de visualização';

  @override
  String get settings_content_preview_max_lines_description =>
      'Número máximo de linhas da visualização do conteúdo a ser exibido';

  @override
  String get settings_behavior => 'Comportamento';

  @override
  String get settings_behavior_description => 'Confirmations, swipe actions';

  @override
  String get settings_behavior_application => 'Aplicativo';

  @override
  String get settings_confirmations => 'Diálogo de confirmação';

  @override
  String get settings_confirmations_description =>
      'Quando mostrar um diálogo de confirmação ao executar uma ação em uma nota';

  @override
  String get settings_confirmations_title_none => 'Nunca';

  @override
  String get settings_confirmations_title_irreversible =>
      'Apenas ações irreversíveis';

  @override
  String get settings_confirmations_title_all => 'Sempre';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description =>
      'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Ações de deslizar';

  @override
  String get settings_behavior_swipe_actions_archives =>
      'Ações de deslizamento (arquivos)';

  @override
  String get settings_behavior_swipe_actions_bin =>
      'Ações de deslizamento (lixeira)';

  @override
  String get settings_swipe_action_right => 'Ação de deslizar para a direita';

  @override
  String get settings_swipe_action_right_description =>
      'Ação a ser executada quando deslizar para a direita num bloco de nota';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Ação a ser acionada quando um deslize para a direita é realizado em um bloco de notas na lixeira';

  @override
  String get settings_swipe_action_left => 'Ação de deslizar para a esquerda';

  @override
  String get settings_swipe_action_left_description =>
      'Ação a ser executada quando deslizar para a esquerda num bloco de nota';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Ação a ser acionada quando um deslize para a esquerda é realizado em um bloco de notas na lixeira';

  @override
  String get settings_page_notes_types => 'Tipos de notas';

  @override
  String get settings_page_notes_types_description =>
      'Tipos de uso, texto rico';

  @override
  String get settings_section_types_to_use => 'Tipos de uso';

  @override
  String get settings_available_notes_types => 'Tipos de notas disponíveis';

  @override
  String get settings_available_notes_types_description =>
      'A lista de tipos de notas que podem ser criadas com o botão “Adicionar” na página de notas. Ao remover um tipo, as notas já existentes com esse tipo não são excluídas e ainda podem ser usadas normalmente';

  @override
  String get settings_available_default_share_type =>
      'Tipo de compartilhamento padrão';

  @override
  String get settings_available_default_share_type_description =>
      'O tipo de nota padrão a ser usado ao criar uma nota a partir de uma ação de compartilhamento. Pode ser um tipo que não esteja disponível no botão “Adicionar”';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Comportamento';

  @override
  String get settings_editor_behavior => 'Comportamento';

  @override
  String get settings_show_editor_mode_button => 'Botão modo editor';

  @override
  String get settings_show_editor_mode_button_description =>
      'Habilite o botão para alternar o editor entre o modo de edição e o modo de leitura';

  @override
  String get settings_open_editor_reading_mode => 'Abrir no modo de leitura';

  @override
  String get settings_open_editor_reading_mode_description =>
      'Abrir o editor no modo leitura por padrão';

  @override
  String get settings_focus_title_on_new_note => 'Focar no título';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Focar no título em vez do conteúdo ao criar uma nota';

  @override
  String get settings_editor_appearance => 'Aparência';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description =>
      'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'Espaçamento dos parágrafos';

  @override
  String get settings_use_paragraph_spacing_description =>
      'Usar espaçamento entre parágrafos';

  @override
  String get settings_labels => 'Rótulos';

  @override
  String get settings_labels_description => 'Habilitar, aparência';

  @override
  String get settings_enable_labels => 'Habilitar';

  @override
  String get settings_enable_labels_description =>
      'Permitir categorizar as notas com rótulos (a desativação não exclui os rótulos nem os remove das notas, apenas os oculta)';

  @override
  String get settings_labels_appearance => 'Aparência';

  @override
  String get settings_show_labels_note_tile =>
      'Exibir rótulos no bloco de notas';

  @override
  String get settings_show_labels_note_tile_description =>
      'Exibir a lista de rótulos dos blocos de notas';

  @override
  String get settings_show_labels_editor => 'Exibir rótulos no editor';

  @override
  String get settings_show_labels_editor_description =>
      'Exibir a lista de rótulos na parte inferior do editor';

  @override
  String get settings_labels_section_behavior => 'Behavior';

  @override
  String get settings_labels_swipe_action_right => 'Right swipe action';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a label tile';

  @override
  String get settings_labels_swipe_action_left => 'Left swipe action';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a label tile';

  @override
  String get settings_backup => 'Backup';

  @override
  String get settings_backup_description =>
      'Exportação manual e automática, criptografia, importação';

  @override
  String get settings_backup_import => 'Importar';

  @override
  String get settings_import => 'Importar';

  @override
  String get settings_import_description =>
      'Importar notas, rótulos e configurações de um arquivo JSON';

  @override
  String get settings_backup_manual_export => 'Exportação manual';

  @override
  String get settings_export_json => 'Exportar como JSON';

  @override
  String get settings_export_json_description =>
      'Immediately export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_export_markdown => 'Exportar como Markdown';

  @override
  String get settings_export_markdown_description =>
      'Immediately export all the notes to a Markdown file';

  @override
  String get settings_backup_auto_export => 'Exportação automática';

  @override
  String get settings_auto_export => 'Exportação automática';

  @override
  String get settings_auto_export_description =>
      'Automatically export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_auto_export_frequency => 'Frequência';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description =>
      'Frequência da exportação automática';

  @override
  String get settings_auto_export_encryption => 'Criptografia';

  @override
  String get settings_auto_export_encryption_description =>
      'Criptografar o título e o conteúdo das notas com uma senha';

  @override
  String get settings_auto_export_directory => 'Diretório';

  @override
  String get settings_auto_export_directory_description =>
      'Diretório onde armazenar as exportações automáticas';

  @override
  String get settings_security => 'Security';

  @override
  String get settings_security_description =>
      'Secure flag, application lock, note lock';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Application lock';

  @override
  String get settings_security_note_lock => 'Note lock';

  @override
  String get settings_flag_secure => 'Sinalizar o aplicativo como seguro';

  @override
  String get settings_flag_secure_description =>
      'Ocultar o aplicativo dos aplicativos recentes e impedir que capturas de tela sejam feitas';

  @override
  String get settings_application_lock_title => 'Lock';

  @override
  String get settings_application_lock_description =>
      'Lock the application and require to authenticate with the device to unlock it';

  @override
  String get settings_application_lock_delay_title => 'Lock delay';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Note lock';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Acessibilidade';

  @override
  String get settings_accessibility_text_size => 'Text size';

  @override
  String get settings_accessibility_text_color => 'Text color';

  @override
  String get settings_accessibility_description => 'Text color, text scaling';

  @override
  String get settings_text_scaling => 'Ajuste da escala do texto';

  @override
  String get settings_bigger_titles => 'Bigger titles';

  @override
  String get settings_bigger_titles_description =>
      'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'White text in dark mode';

  @override
  String get settings_white_text_dark_mode_description =>
      'Use a white color for the text in dark mode';

  @override
  String get settings_disable_subdued_note_content_preview =>
      'Non-subdued preview';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Disable the subdued text color of the notes content preview';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues =>
      'Relatório de bug e solicitação de recurso';

  @override
  String get settings_github_issues_description =>
      'Reportar um bug ou solicitar um recurso criando um issue no GitHub';

  @override
  String get settings_github_discussions => 'Tirar dúvidas';

  @override
  String get settings_github_discussions_description =>
      'Fazer uma pergunta nas discussões do GitHub';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Entre em contacto com o desenvolvedor no e-mail $email';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Copiar registros';

  @override
  String get settings_copy_logs_description =>
      'Copie os registros do aplicativo para a área de transferência';

  @override
  String get settings_export_logs => 'Exportar registros';

  @override
  String get settings_export_logs_description =>
      'Exporte os registros do aplicativo para um arquivo de texto';

  @override
  String get settings_about => 'Sobre';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'Aplicativo';

  @override
  String get settings_build_mode => 'Modo da build';

  @override
  String get settings_build_mode_release => 'Release';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => 'Links';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Dê uma olhada no código-fonte';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description =>
      'Adicione ou melhore as traduções do aplicativo no Crowdin';

  @override
  String get settings_licence => 'Licença';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Título';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Link';

  @override
  String get hint_label_name => 'Name';

  @override
  String get dialog_export_encryption_password => 'Senha';

  @override
  String get dialog_select_labels => 'Select tags';

  @override
  String get dialog_select_labels_to_add => 'Select tags to add';

  @override
  String get tooltip_undo => 'Undo the last action';

  @override
  String get tooltip_redo => 'Redo the last action';

  @override
  String get tooltip_fab_add_note => 'Adicionar uma anotação';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Add a tag';

  @override
  String get tooltip_fab_empty_bin => 'Esvaziar a lixeira';

  @override
  String get tooltip_fab_toggle_editor_mode_edit =>
      'Alternar para o modo de edição';

  @override
  String get tooltip_fab_toggle_editor_mode_read =>
      'Alternar para o modo leitura';

  @override
  String get tooltip_layout_list => 'Visualizar em lista';

  @override
  String get tooltip_layout_grid => 'Visualizar em grade';

  @override
  String get tooltip_sort => 'Ordenar';

  @override
  String get tooltip_search => 'Pesquisar por anotações';

  @override
  String get tooltip_unselect_all => 'Desmarcar tudo';

  @override
  String get tooltip_reset => 'Redefinir';

  @override
  String get dialog_add_link => 'Adicionar link';

  @override
  String get dialog_archive => 'Archive';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Excluir';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'Do you really want to delete $count $_temp0? You can restore $_temp1 from the bin.';
  }

  @override
  String get dialog_permanently_delete => 'Excluir permanentemente';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'Do you really want to permanently delete $count $_temp0? You will not be able to restore $_temp1.';
  }

  @override
  String get dialog_restore => 'Restaurar';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to restore $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Esvaziar a lixeira';

  @override
  String get dialog_empty_bin_body =>
      'Você realmente deseja esvaziar permanentemente a lixeira? Você não poderá restaurar as notas que ele contém.';

  @override
  String get dialog_delete_label => 'Delete';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'tags',
      one: 'tag',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'They',
      one: 'It',
    );
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'them',
      one: 'it',
    );
    return 'Do you really want to delete $count $_temp0? $_temp1 will be removed from the notes where you added $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch =>
      'Criptografar a exportação JSON';

  @override
  String get dialog_export_encryption_description =>
      'O título e o conteúdo das notas serão criptografados com sua senha. Deve ser gerado aleatoriamente, com exatamente 32 caracteres, forte (pelo menos 1 minúsculo, 1 maiúsculo, 1 número e 1 caractere especial) e armazenado de forma segura.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Esta senha será usada em todas as futuras exportações automáticas.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Esta senha será usada apenas para esta exportação.';

  @override
  String get dialog_export_encryption_password_invalid => 'Inválido';

  @override
  String get dialog_import_encryption_password_description =>
      'Esta exportação é criptografada. Para importá-lo, você precisa fornecer a senha usada para criptografá-la.';

  @override
  String get dialog_import_encryption_password_error =>
      'a descriptografia da exportação falhou. Verifique se você forneceu a mesma senha usada para criptografar a exportação.';

  @override
  String get dialog_label_add => 'Add tag';

  @override
  String get dialog_label_edit => 'Edit tag';

  @override
  String get dialog_label_name_cannot_be_empty => 'The name cannot be empty.';

  @override
  String get dialog_label_name_already_used => 'This name is already used.';

  @override
  String get button_sort_creation_date => 'Creation date';

  @override
  String get button_sort_edition_date => 'Edition date';

  @override
  String get placeholder_notes => 'Sem anotações';

  @override
  String get placeholder_labels => 'No tags';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'Nenhuma anotação excluída';

  @override
  String get action_disabled => 'Desabilitado';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Fixar';

  @override
  String get action_unpin => 'Desfixar';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Compartilhar';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return '$count $_temp0 shared from Material Notes';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Excluir';

  @override
  String get action_restore => 'Restaurar';

  @override
  String get action_delete_permanently => 'Excluir permanentemente';

  @override
  String get action_about => 'Sobre';

  @override
  String get about_last_edited => 'Última edição';

  @override
  String get about_type => 'Type';

  @override
  String get about_created => 'Criado';

  @override
  String get about_labels => 'Tags';

  @override
  String get about_words => 'Palavras';

  @override
  String get about_characters => 'Caracteres';

  @override
  String get about_time_at => 'às';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Toggle pins';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Edit';

  @override
  String get action_labels_delete => 'Delete';

  @override
  String get filter_labels_all => 'All';

  @override
  String get filter_labels_visible => 'Visible';

  @override
  String get filter_labels_hidden => 'Hidden';

  @override
  String get filter_labels_pinned => 'Pinned';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed =>
      'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 archived';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 unarchived';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success =>
      'The backup was successfully imported.';

  @override
  String get snack_bar_export_success =>
      'The backup were successfully exported.';

  @override
  String get snack_bar_logs_copied =>
      'Os registros foram copiados para sua área de transferência.';

  @override
  String get snack_bar_logs_exported =>
      'Os registros foram exportados com sucesso.';

  @override
  String get snack_bar_no_labels => 'There are no tags.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Bem-vindo ao Material Notes!';

  @override
  String get welcome_note_content =>
      'Notas simples, locais, em material design';

  @override
  String get font_system_default => 'System default';

  @override
  String get note_type_plain_text => 'Plain text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Rich text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground =>
      'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background =>
      'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description =>
      'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description =>
      'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description =>
      'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description =>
      'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description =>
      'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting =>
      'Press back again to exit the application.';
}
