// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Notas simples, locales, en Material Design';

  @override
  String app_about(String appName) {
    return '$appName es una aplicación de toma de notas basadas en texto, orientada a la simplicidad, diseñada adoptando Material Design. $appName almacena las notas localmente y no requiere ningún permiso de internet, siendo tú el único que puede acceder a las notas.';
  }

  @override
  String get error_snack_bar => 'Error:';

  @override
  String get error_widget_title => 'Ha ocurrido un error.';

  @override
  String get error_widget_description =>
      'Informa de este problema en GitHub o por correo. Adjunta una captura de pantalla de esta página y los registros que puedes copiar o exportar a continuación. Como precaución, también debes exportar tus notas.';

  @override
  String get error_widget_disabled_secure_flag =>
      'La configuración para marcar la aplicación como segura está desactivada hasta el próximo reinicio para habilitar las capturas de pantalla.';

  @override
  String get error_widget_button_export_notes => 'Exportar notas';

  @override
  String get error_widget_button_copy_logs => 'Copiar registros';

  @override
  String get error_widget_button_export_logs => 'Exportar registros';

  @override
  String get error_widget_button_create_github_issue =>
      'Crear un problema en GitHub';

  @override
  String get error_widget_button_send_mail => 'Enviar correo electrónico';

  @override
  String get navigation_notes => 'Notas';

  @override
  String get navigation_manage_labels_destination => 'Administrar etiquetas';

  @override
  String get navigation_manage_labels_page => 'Etiquetas';

  @override
  String get navigation_archives => 'Archivos';

  @override
  String get navigation_bin => 'Papelera';

  @override
  String get navigation_settings => 'Ajustes';

  @override
  String get navigation_settings_appearance => 'Apariencia';

  @override
  String get navigation_settings_notes_types => 'Notes types';

  @override
  String get navigation_settings_notes_tiles => 'Tarjetas de las notas';

  @override
  String get navigation_settings_behavior => 'Comportamiento';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Etiquetas';

  @override
  String get navigation_settings_backup => 'Copia de seguridad';

  @override
  String get navigation_settings_security => 'Security';

  @override
  String get navigation_settings_accessibility => 'Accesibilidad';

  @override
  String get navigation_settings_help => 'Help';

  @override
  String get navigation_settings_about => 'Acerca de';

  @override
  String get button_sort_title => 'Título';

  @override
  String get button_sort_ascending => 'Ascendente';

  @override
  String get settings_page_appearance => 'Apariencia';

  @override
  String get settings_page_appearance_description => 'Idioma, temas, fuentes';

  @override
  String get settings_language => 'Idioma';

  @override
  String get settings_language_contribute => 'Contribuir';

  @override
  String get settings_appearance_section_theming => 'Tematización';

  @override
  String get settings_theme => 'Tema';

  @override
  String get settings_theme_system => 'Sistema';

  @override
  String get settings_theme_light => 'Claro';

  @override
  String get settings_theme_dark => 'Oscuro';

  @override
  String get settings_dynamic_theming => 'Tema dinámico';

  @override
  String get settings_dynamic_theming_description =>
      'Generar colores desde el sistema';

  @override
  String get settings_black_theming => 'Negro puro';

  @override
  String get settings_black_theming_description =>
      'Fondo negro puro para el tema oscuro';

  @override
  String get settings_appearance_section_fonts => 'Fuentes';

  @override
  String get settings_app_font => 'Fuente de la aplicación';

  @override
  String get settings_app_font_description =>
      'Fuente utilizada para todos los textos de la aplicación, excepto en el editor de notas';

  @override
  String get settings_editor_font => 'Fuente del editor';

  @override
  String get settings_editor_font_description =>
      'Fuente utilizada sólo para el texto en el editor de notas';

  @override
  String get settings_page_notes_tiles => 'Tarjetas de las notas';

  @override
  String get settings_page_notes_tiles_description => 'Apariencia, contenido';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Apariencia';

  @override
  String get settings_page_notes_tiles_content_section => 'Contenido';

  @override
  String get settings_show_tiles_background => 'Fondo';

  @override
  String get settings_show_tiles_background_description =>
      'Muestra el fondo de tarjetas en las notas';

  @override
  String get settings_show_separators => 'Separadores';

  @override
  String get settings_show_separators_description =>
      'Mostrar un separador entre las notas';

  @override
  String get settings_show_note_type_icon => 'Show type icon';

  @override
  String get settings_show_note_type_icon_description =>
      'Show the icon of the type of the note';

  @override
  String get settings_show_titles_only => 'Sólo títulos';

  @override
  String get settings_show_titles_only_description =>
      'Sólo mostrar los títulos de las notas';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'Deshabilitar mostrar solo los títulos en la búsqueda';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Deshabilitar la opción de sólo mostrar los títulos cuando se muestra la vista de búsqueda';

  @override
  String get settings_content_preview_max_lines =>
      'Máximas líneas en la vista previa';

  @override
  String get settings_content_preview_max_lines_description =>
      'Número máximo de líneas a mostrar en la vista previa del contenido';

  @override
  String get settings_behavior => 'Comportamiento';

  @override
  String get settings_behavior_description => 'Confirmations, swipe actions';

  @override
  String get settings_behavior_application => 'Aplicación';

  @override
  String get settings_confirmations => 'Diálogo de confirmación';

  @override
  String get settings_confirmations_description =>
      'Cuándo mostrar un cuadro de diálogo de confirmación al realizar una acción en una nota';

  @override
  String get settings_confirmations_title_none => 'Nunca';

  @override
  String get settings_confirmations_title_irreversible =>
      'En acciones irreversibles';

  @override
  String get settings_confirmations_title_all => 'Siempre';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description =>
      'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Acciones de deslizamiento';

  @override
  String get settings_behavior_swipe_actions_archives =>
      'Swipe actions (archives)';

  @override
  String get settings_behavior_swipe_actions_bin =>
      'Acciones de deslizamiento (papelera)';

  @override
  String get settings_swipe_action_right => 'Deslizar a la derecha';

  @override
  String get settings_swipe_action_right_description =>
      'Acción a realizar al deslizar a la derecha la tarjeta se una nota';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Acción a realizar cuando se desliza a la derecha la tarjeta de una nota en la papelera';

  @override
  String get settings_swipe_action_left => 'Desliza a la izquierda';

  @override
  String get settings_swipe_action_left_description =>
      'Acción a realizar al deslizar a la izquierda la tarjeta de una nota';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Acción a realizar al deslizar a la izquierda la tarjeta de una nota';

  @override
  String get settings_page_notes_types => 'Notes types';

  @override
  String get settings_page_notes_types_description => 'Types to use, rich text';

  @override
  String get settings_section_types_to_use => 'Types to use';

  @override
  String get settings_available_notes_types => 'Available notes types';

  @override
  String get settings_available_notes_types_description =>
      'The list of notes types that can be created with the \"Add\" button from the notes page. When removing a type, already existing notes with that type are not deleted and can still be used normally';

  @override
  String get settings_available_default_share_type => 'Default share type';

  @override
  String get settings_available_default_share_type_description =>
      'The default note type to use when creating a note from a share action. It can be a type that is not available from the \"Add\" button';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Behavior';

  @override
  String get settings_editor_behavior => 'Comportamiento';

  @override
  String get settings_show_editor_mode_button => 'Botón del modo editor';

  @override
  String get settings_show_editor_mode_button_description =>
      'Activar el botón para cambiar el editor entre el modo de edición y el modo de lectura';

  @override
  String get settings_open_editor_reading_mode => 'Abrir en modo de lectura';

  @override
  String get settings_open_editor_reading_mode_description =>
      'Abrir el editor en modo de lectura por defecto';

  @override
  String get settings_focus_title_on_new_note => 'Enfocar el título';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Enfocar el título en lugar del contenido cuando se crea una nueva nota';

  @override
  String get settings_editor_appearance => 'Apariencia';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description =>
      'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'Espacio entre párrafos';

  @override
  String get settings_use_paragraph_spacing_description =>
      'Usar espaciado entre párrafos';

  @override
  String get settings_labels => 'Etiquetas';

  @override
  String get settings_labels_description => 'Habilitar, apariencia';

  @override
  String get settings_enable_labels => 'Habilitar';

  @override
  String get settings_enable_labels_description =>
      'Permitir categorizar las notas con etiquetas (deshabilitarlo no elimina etiquetas ni las elimina de las notas, solo las oculta)';

  @override
  String get settings_labels_appearance => 'Apariencia';

  @override
  String get settings_show_labels_note_tile =>
      'Mostrar etiquetas en el título de las notas';

  @override
  String get settings_show_labels_note_tile_description =>
      'Mostrar la lista de etiquetas en los títulos de las notas';

  @override
  String get settings_show_labels_editor =>
      'Mostrar las etiquetas en el editor';

  @override
  String get settings_show_labels_editor_description =>
      'Muestra la lista de etiquetas en la parte inferior del editor';

  @override
  String get settings_labels_section_behavior => 'Behavior';

  @override
  String get settings_labels_swipe_action_right => 'Right swipe action';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a label tile';

  @override
  String get settings_labels_swipe_action_left => 'Left swipe action';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a label tile';

  @override
  String get settings_backup => 'Respaldo';

  @override
  String get settings_backup_description =>
      'Exportación manual y automática, cifrado, importación';

  @override
  String get settings_backup_import => 'Importar';

  @override
  String get settings_import => 'Importar';

  @override
  String get settings_import_description =>
      'Importar notas, etiquetas y configuraciones desde un archivo JSON';

  @override
  String get settings_backup_manual_export => 'Exportar manualmente';

  @override
  String get settings_export_json => 'Exportar a JSON';

  @override
  String get settings_export_json_description =>
      'Immediately export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_export_markdown => 'Exportar a Markdown';

  @override
  String get settings_export_markdown_description =>
      'Immediately export all the notes to a Markdown file';

  @override
  String get settings_backup_auto_export => 'Exportación automática';

  @override
  String get settings_auto_export => 'Exportación automática';

  @override
  String get settings_auto_export_description =>
      'Automatically export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_auto_export_frequency => 'Frecuencia';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description =>
      'Frecuencia de la exportación automática';

  @override
  String get settings_auto_export_encryption => 'Encriptación';

  @override
  String get settings_auto_export_encryption_description =>
      'Encriptar el título y el contenido de las notas con una contraseña';

  @override
  String get settings_auto_export_directory => 'Directorio';

  @override
  String get settings_auto_export_directory_description =>
      'Directorio donde almacenar las exportaciones automáticas';

  @override
  String get settings_security => 'Security';

  @override
  String get settings_security_description =>
      'Secure flag, application lock, note lock';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Application lock';

  @override
  String get settings_security_note_lock => 'Note lock';

  @override
  String get settings_flag_secure => 'Marcar la aplicación cómo segura';

  @override
  String get settings_flag_secure_description =>
      'Oculta la aplicación de las aplicaciones recientes y previene que se realicen capturas de pantalla';

  @override
  String get settings_application_lock_title => 'Lock';

  @override
  String get settings_application_lock_description =>
      'Bloquea la aplicación y requiere autentificarse con el dispositivo para desbloquearla';

  @override
  String get settings_application_lock_delay_title => 'Lock delay';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Note lock';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Accesibilidad';

  @override
  String get settings_accessibility_text_size => 'Tamaño del texto';

  @override
  String get settings_accessibility_text_color => 'Color del texto';

  @override
  String get settings_accessibility_description =>
      'Color de texto, escala del texto';

  @override
  String get settings_text_scaling => 'Escala del texto';

  @override
  String get settings_bigger_titles => 'Títulos grandes';

  @override
  String get settings_bigger_titles_description =>
      'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'Texto blanco en el modo oscuro';

  @override
  String get settings_white_text_dark_mode_description =>
      'Usar un color blanco para el texto en modo oscuro';

  @override
  String get settings_disable_subdued_note_content_preview =>
      'No subrayado en vista previa';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Desactiva el color de texto subrayado de la vista previa del contenido de las notas';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues =>
      'Reporta errores o solicita nuevas características';

  @override
  String get settings_github_issues_description =>
      'Reportar un error o solicitar una característica creando un problema de GitHub';

  @override
  String get settings_github_discussions => 'Hacer una pregunta';

  @override
  String get settings_github_discussions_description =>
      'Hacer una pregunta en las discusiones de GitHub';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Póngase en contacto con el desarrollador por correo electrónico en $email';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Copiar registros';

  @override
  String get settings_copy_logs_description =>
      'Copia los registros de la aplicación al portapapeles';

  @override
  String get settings_export_logs => 'Exportar los registros';

  @override
  String get settings_export_logs_description =>
      'Exporta los registros de la aplicación a un archivo de texto';

  @override
  String get settings_about => 'Acerca de';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'Aplicación';

  @override
  String get settings_build_mode => 'Modo de compilación';

  @override
  String get settings_build_mode_release => 'Versión';

  @override
  String get settings_build_mode_debug => 'Depuración';

  @override
  String get settings_about_links => 'Enlaces';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Da un vistazo al código fuente';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description =>
      'Añade o mejora las localizaciones en el proyecto Crowdin';

  @override
  String get settings_licence => 'Licencia';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Título';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Enlace';

  @override
  String get hint_label_name => 'Nombre';

  @override
  String get dialog_export_encryption_password => 'Contraseña';

  @override
  String get dialog_select_labels => 'Seleccionar etiquetas';

  @override
  String get dialog_select_labels_to_add => 'Seleccionar etiquetas a añadir';

  @override
  String get tooltip_undo => 'Deshacer la última acción';

  @override
  String get tooltip_redo => 'Rehacer la última acción';

  @override
  String get tooltip_fab_add_note => 'Agregar una nota';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Añadir etiqueta';

  @override
  String get tooltip_fab_empty_bin => 'Vaciar la papelera';

  @override
  String get tooltip_fab_toggle_editor_mode_edit =>
      'Cambiar al modo de edición';

  @override
  String get tooltip_fab_toggle_editor_mode_read =>
      'Cambiar al modo de lectura';

  @override
  String get tooltip_layout_list => 'Vista en lista';

  @override
  String get tooltip_layout_grid => 'Vista en cuadrícula';

  @override
  String get tooltip_sort => 'Ordenar las notas';

  @override
  String get tooltip_search => 'Buscar entre las notas';

  @override
  String get tooltip_unselect_all => 'Deseleccionar todo';

  @override
  String get tooltip_reset => 'Restablecer';

  @override
  String get dialog_add_link => 'Agregar un vínculo';

  @override
  String get dialog_archive => 'Archive';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Eliminar';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notas',
      one: 'nota',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'las',
      one: 'la',
    );
    return '¿Realmente quieres eliminar $count $_temp0? ¡Puedes restaurar$_temp1 de la papelera.';
  }

  @override
  String get dialog_permanently_delete => 'Eliminar permanentemente';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notas',
      one: 'nota',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'las',
      one: 'la',
    );
    return '¿Realmente quieres eliminar permanentemente $count $_temp0? No podrás restaurar$_temp1.';
  }

  @override
  String get dialog_restore => 'Restaurar';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notas',
      one: 'nota',
    );
    return '¿Realmente quieres restaurar $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Vaciar la papelera';

  @override
  String get dialog_empty_bin_body =>
      '¿Realmente quieres restaurar la papelera? No podrás restaurar las notas en ella.';

  @override
  String get dialog_delete_label => 'Eliminar';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'etiquetas',
      one: 'etiqueta',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Estas',
      one: 'Esta',
    );
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: '');
    return '¿Estás seguro de que quieres eliminar $count $_temp0? $_temp1 serán removidas de las notas donde las agregaste$_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'Encriptar la exportación JSON';

  @override
  String get dialog_export_encryption_description =>
      'El título y el contenido de las notas serán cifrados usando su contraseña. Debe ser generado aleatoriamente, exactamente 32 caracteres de largo, fuerte (al menos 1 minúscula, 1 mayúscula, 1 número y 1 carácter especial) y almacenado de forma segura.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Esta contraseña se utilizará para todas las exportaciones automáticas futuras.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Esta contraseña sólo se usará para esta exportación.';

  @override
  String get dialog_export_encryption_password_invalid => 'Inválido';

  @override
  String get dialog_import_encryption_password_description =>
      'Esta exportación está encriptada. Para importarla, necesita proporcionar la contraseña utilizada para encriptarla.';

  @override
  String get dialog_import_encryption_password_error =>
      'el desencriptado de la exportación falló. Por favor, compruebe que proporcionó la misma contraseña que la que utilizó para encriptar la exportación.';

  @override
  String get dialog_label_add => 'Añadir etiqueta';

  @override
  String get dialog_label_edit => 'Editar etiqueta';

  @override
  String get dialog_label_name_cannot_be_empty =>
      'El nombre no puede estar vacío.';

  @override
  String get dialog_label_name_already_used => 'Este nombre ya está en uso.';

  @override
  String get button_sort_creation_date => 'Fecha de creación';

  @override
  String get button_sort_edition_date => 'Fecha de modificación';

  @override
  String get placeholder_notes => 'No hay notas';

  @override
  String get placeholder_labels => 'Sin etiquetas';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'No hay notas eliminadas';

  @override
  String get action_disabled => 'Desactivado';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Fijar';

  @override
  String get action_unpin => 'Desfijar';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Compartir';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notas',
      one: 'nota',
    );
    return '$count $_temp0 compartidas de Notas Material';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Eliminar';

  @override
  String get action_restore => 'Restaurar';

  @override
  String get action_delete_permanently => 'Eliminar permanentemente';

  @override
  String get action_about => 'Acerca de';

  @override
  String get about_last_edited => 'Última edición';

  @override
  String get about_type => 'Tipo';

  @override
  String get about_created => 'Creación';

  @override
  String get about_labels => 'Etiquetas';

  @override
  String get about_words => 'Palabras';

  @override
  String get about_characters => 'Caracteres';

  @override
  String get about_time_at => 'a las';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Alternar fijado';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Editar';

  @override
  String get action_labels_delete => 'Eliminar';

  @override
  String get filter_labels_all => 'Todas';

  @override
  String get filter_labels_visible => 'Visible';

  @override
  String get filter_labels_hidden => 'Ocultas';

  @override
  String get filter_labels_pinned => 'Fijadas';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed =>
      'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 archived';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 unarchived';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success =>
      'La copia de seguridad se ha importado correctamente.';

  @override
  String get snack_bar_export_success =>
      'La copia de seguridad se ha exportado correctamente.';

  @override
  String get snack_bar_logs_copied =>
      'Los registros han sido copiados al portapapeles.';

  @override
  String get snack_bar_logs_exported =>
      'Los registros se exportaron correctamente.';

  @override
  String get snack_bar_no_labels => 'No hay etiquetas.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Bienvenido a Material Notes !';

  @override
  String get welcome_note_content =>
      'Notas simples, locales, en Material Design';

  @override
  String get font_system_default => 'Predeterminado del sistema';

  @override
  String get note_type_plain_text => 'Texto sin formato';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Texto enriquecido';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground =>
      'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background =>
      'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description =>
      'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description =>
      'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description =>
      'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description =>
      'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description =>
      'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting =>
      'Press back again to exit the application.';
}
