// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Einfache, lokale Notizen-App im Material-Design';

  @override
  String app_about(String appName) {
    return '$appName ist eine auf Einfachheit abzielende, auf getipptem Text basierende Notizen Anwendung im Material-Design. Sie speichert die Notizen lokal und benötigt keine Berechtigung zum Internetzugriff, so dass nur Sie als einziges Zugriff auf die Notizen haben.';
  }

  @override
  String get error_snack_bar => 'Fehler:';

  @override
  String get error_widget_title => 'Es ist ein Fehler aufgetreten.';

  @override
  String get error_widget_description =>
      'Bitte melde dieses Problem auf GitHub oder per E-Mail. Füge einen Screenshot dieser Seite und die Logs hinzu, die du unten kopieren oder exportieren kannst. Als Vorsichtsmaßnahme solltest Du Deine Notizen auch exportieren.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Die Einstellung, die App als sicher zu kennzeichnen, ist bis zum nächsten Neustart deaktiviert, um Screenshots zu ermöglichen.';

  @override
  String get error_widget_button_export_notes => 'Notizen exportieren';

  @override
  String get error_widget_button_copy_logs => 'Logdateien kopieren';

  @override
  String get error_widget_button_export_logs => 'Logdateien exportieren';

  @override
  String get error_widget_button_create_github_issue =>
      'Erstelle ein Issue auf GitHub';

  @override
  String get error_widget_button_send_mail => 'E-Mail senden';

  @override
  String get navigation_notes => 'Notizen';

  @override
  String get navigation_manage_labels_destination => 'Labels verwalten';

  @override
  String get navigation_manage_labels_page => 'Labels';

  @override
  String get navigation_archives => 'Archive';

  @override
  String get navigation_bin => 'Papierkorb';

  @override
  String get navigation_settings => 'Einstellungen';

  @override
  String get navigation_settings_appearance => 'Aussehen';

  @override
  String get navigation_settings_notes_types => 'Notizarten';

  @override
  String get navigation_settings_notes_tiles => 'Notizkacheln';

  @override
  String get navigation_settings_behavior => 'Verhalten';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Labels';

  @override
  String get navigation_settings_backup => 'Sicherheitskopie';

  @override
  String get navigation_settings_security => 'Sicherheit';

  @override
  String get navigation_settings_accessibility => 'Barrierefreiheit';

  @override
  String get navigation_settings_help => 'Hilfe';

  @override
  String get navigation_settings_about => 'Über';

  @override
  String get button_sort_title => 'Titel';

  @override
  String get button_sort_ascending => 'Aufsteigend';

  @override
  String get settings_page_appearance => 'Aussehen';

  @override
  String get settings_page_appearance_description =>
      'Sprache, Aussehen, Schrift';

  @override
  String get settings_language => 'Sprache';

  @override
  String get settings_language_contribute => 'Mitwirken';

  @override
  String get settings_appearance_section_theming => 'Design';

  @override
  String get settings_theme => 'Gestaltung';

  @override
  String get settings_theme_system => 'System';

  @override
  String get settings_theme_light => 'Hell';

  @override
  String get settings_theme_dark => 'Dunkel';

  @override
  String get settings_dynamic_theming => 'Dynamisches Design';

  @override
  String get settings_dynamic_theming_description =>
      'Übernehme die Farben vom System';

  @override
  String get settings_black_theming => 'Schwarze Gestaltung';

  @override
  String get settings_black_theming_description =>
      'Nutze einen schwarzen Hintergrund im dunklen Modus';

  @override
  String get settings_appearance_section_fonts => 'Schriftart';

  @override
  String get settings_app_font => 'App Schriftart';

  @override
  String get settings_app_font_description =>
      'Schriftart, die für alles in der App außer für den Notizen Editor benutzt wird';

  @override
  String get settings_editor_font => 'Editor Schriftart';

  @override
  String get settings_editor_font_description =>
      'Schriftart die nur für den Text im Notizen Editor benutzt wird';

  @override
  String get settings_page_notes_tiles => 'Notizkacheln';

  @override
  String get settings_page_notes_tiles_description => 'Aussehen, Inhalt';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Aussehen';

  @override
  String get settings_page_notes_tiles_content_section => 'Inhalt';

  @override
  String get settings_show_tiles_background => 'Hintergrund';

  @override
  String get settings_show_tiles_background_description =>
      'Hintergrund der Notizkacheln anzeigen';

  @override
  String get settings_show_separators => 'Trennlinien';

  @override
  String get settings_show_separators_description =>
      'Trennlinie zwischen den Notizkacheln anzeigen';

  @override
  String get settings_show_note_type_icon => 'Typ-Icon anzeigen';

  @override
  String get settings_show_note_type_icon_description =>
      'Icon des Notiztyps zeigen';

  @override
  String get settings_show_titles_only => 'Nur Titel';

  @override
  String get settings_show_titles_only_description => 'Nur Notiztitel anzeigen';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'Nur Titel in Suche deaktivieren';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      '\"Nur Titel anzeigen\" deaktivieren, wenn Du Dich in der Suchansicht befindest';

  @override
  String get settings_content_preview_max_lines => 'Maximale Vorschauzeilen';

  @override
  String get settings_content_preview_max_lines_description =>
      'Maximale Anzahl an Zeilen der Inhaltsvorschau';

  @override
  String get settings_behavior => 'Verhalten';

  @override
  String get settings_behavior_description => 'Bestätigungen, Wischgesten';

  @override
  String get settings_behavior_application => 'Anwendung';

  @override
  String get settings_confirmations => 'Bestätigungsdialog';

  @override
  String get settings_confirmations_description =>
      'Bestätigungsdialog bei Aktion';

  @override
  String get settings_confirmations_title_none => 'Niemals';

  @override
  String get settings_confirmations_title_irreversible =>
      'Nur unwiderrufliche Aktionen';

  @override
  String get settings_confirmations_title_all => 'Immer';

  @override
  String get settings_auto_remove_from_bin_title =>
      'Automatisch aus dem Papierkorb entfernen';

  @override
  String get settings_auto_remove_from_bin_description =>
      'Notizen automatisch aus dem Papierkorb entfernen';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'Nach 1 Woche',
      '14': 'Nach 2 Wochen',
      '30': 'Nach 1 Monat',
      '90': 'Nach 3 Monaten',
      '180': 'Nach 6 Monaten',
      '365': 'Nach 1 Jahr',
      'other': 'Nie',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Wischgesten';

  @override
  String get settings_behavior_swipe_actions_archives =>
      'Wischgesten (Archive)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Wischgesten (Papierkorb)';

  @override
  String get settings_swipe_action_right => 'Aktion für Rechtswischen';

  @override
  String get settings_swipe_action_right_description =>
      'Aktion bei Nach-Rechts-Wischen';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Aktion, die ausgelöst wird, wenn man auf einer Notizkachel im Papierkorb nach rechts wischt';

  @override
  String get settings_swipe_action_left => 'Aktion für Linkswischen';

  @override
  String get settings_swipe_action_left_description =>
      'Aktion bei Nach-Links-Wischen';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Aktion, die ausgelöst wird, wenn man auf einer Notizkachel im Papierkorb nach links wischt';

  @override
  String get settings_page_notes_types => 'Notiztypen';

  @override
  String get settings_page_notes_types_description =>
      'Zu verwendende Typen, Rich-Text';

  @override
  String get settings_section_types_to_use => 'Zu verwendende Typen';

  @override
  String get settings_available_notes_types => 'Verfügbare Notiztypen';

  @override
  String get settings_available_notes_types_description =>
      'Die Liste der Notiztypen, die mit dem Button \"Hinzufügen\" von der Notizseite erstellt werden können. Beim Entfernen eines Typs werden bereits bestehende Notizen mit diesem Typ nicht gelöscht und können weiterhin normal verwendet werden';

  @override
  String get settings_available_default_share_type => 'Standardtyp fürs Teilen';

  @override
  String get settings_available_default_share_type_description =>
      'Der Standard-Notiztyp, der beim Erstellen einer Notiz aus einer Teilen-Aktion verwendet werden soll. Es kann auch ein Typ sein, der nicht über den \"Hinzufügen\"-Button verfügbar ist';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Verhalten';

  @override
  String get settings_editor_behavior => 'Verhalten';

  @override
  String get settings_show_editor_mode_button =>
      'Bearbeitungsmodus-Schaltfläche';

  @override
  String get settings_show_editor_mode_button_description =>
      'Schaltfläche zum Umschalten zwischen Bearbeitungs- und Lesemodus anzeigen';

  @override
  String get settings_open_editor_reading_mode => 'Im Lesemodus öffnen';

  @override
  String get settings_open_editor_reading_mode_description =>
      'Editor standardmäßig im Lesemodus öffnen';

  @override
  String get settings_focus_title_on_new_note => 'Cursor ins Titelfeld setzen';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Den Cursor beim Erstellen einer neuen Notiz ins Titelfeld setzen anstelle des Inhaltsfeldes';

  @override
  String get settings_editor_appearance => 'Aussehen';

  @override
  String get settings_toolbar_style_title => 'Symbolleisten-Stil';

  @override
  String get settings_toolbar_style_description =>
      'Der Stil der Symbolleiste des Rich-Text-Editors';

  @override
  String get settings_use_paragraph_spacing => 'Absatzabstand';

  @override
  String get settings_use_paragraph_spacing_description =>
      'Verwende Abstand zwischen Absätzen';

  @override
  String get settings_labels => 'Labels';

  @override
  String get settings_labels_description => 'Aktivierung, Aussehen';

  @override
  String get settings_enable_labels => 'Aktivieren';

  @override
  String get settings_enable_labels_description =>
      'Erlaubt das Kategorisieren der Notizen mit Beschriftungen (das Deaktivieren dieser Funktion löscht die Beschriftungen weder, noch entfernt sie sie aus den Notizen, es verbirgt sie nur)';

  @override
  String get settings_labels_appearance => 'Aussehen';

  @override
  String get settings_show_labels_note_tile =>
      'Labels auf Notizkacheln anzeigen';

  @override
  String get settings_show_labels_note_tile_description =>
      'Auf der Startseite Notizen mit ihren Labels anzeigen';

  @override
  String get settings_show_labels_editor => 'Labels im Editor anzeigen';

  @override
  String get settings_show_labels_editor_description =>
      'Liste der Labels am unteren Rand des Editors anzeigen';

  @override
  String get settings_labels_section_behavior => 'Verhalten';

  @override
  String get settings_labels_swipe_action_right =>
      'Aktion bei nach rechts wischen';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Aktion die ausgeführt wird, wenn auf den Notizkacheln nach rechts gewischt wird';

  @override
  String get settings_labels_swipe_action_left =>
      'Aktion bei nach links wischen';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Aktion die ausgeführt wird, wenn auf den Notizkacheln nach links gewischt wird';

  @override
  String get settings_backup => 'Sicherung';

  @override
  String get settings_backup_description =>
      'Manueller und automatischer Export, Verschlüsselung, Import';

  @override
  String get settings_backup_import => 'Import';

  @override
  String get settings_import => 'Import';

  @override
  String get settings_import_description =>
      'Importieren Sie Notizen, Beschriftungen und Einstellungen aus einer JSON-Datei';

  @override
  String get settings_backup_manual_export => 'Manueller Export';

  @override
  String get settings_export_json => 'Exportiere als JSON';

  @override
  String get settings_export_json_description =>
      'Exportieren Sie alle Notizen, Beschriftungen und Einstellungen sofort in eine JSON-Datei, die wieder importiert werden kann';

  @override
  String get settings_export_markdown => 'Exportiere als Markdown';

  @override
  String get settings_export_markdown_description =>
      'Exportieren Sie alle Notizen sofort in eine Markdown-Datei';

  @override
  String get settings_backup_auto_export => 'Automatischer Export';

  @override
  String get settings_auto_export => 'Automatischer Export';

  @override
  String get settings_auto_export_description =>
      'Exportieren Sie automatisch alle Notizen, Beschriftungen und Einstellungen in eine JSON-Datei, die wieder importiert werden kann';

  @override
  String get settings_auto_export_frequency => 'Häufigkeit';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Alle $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description =>
      'Häufigkeit des automatischen Exports';

  @override
  String get settings_auto_export_encryption => 'Verschlüsselung';

  @override
  String get settings_auto_export_encryption_description =>
      'Verschlüssele den Titel und den Inhalt er Notizen mit einem Passwort';

  @override
  String get settings_auto_export_directory => 'Pfad';

  @override
  String get settings_auto_export_directory_description =>
      'Verzeichnis für automatische Exports';

  @override
  String get settings_security => 'Sicherheit';

  @override
  String get settings_security_description =>
      'Sichere Flagge, Sperre der Anwendung, Notiz';

  @override
  String get settings_security_application => 'App';

  @override
  String get settings_security_application_lock => 'App Sperre';

  @override
  String get settings_security_note_lock => 'Notizen Sperre';

  @override
  String get settings_flag_secure => 'App als sicher markieren';

  @override
  String get settings_flag_secure_description =>
      'Die App im App-Umschalter nicht anzeigen und verhindern, dass Screenshots gemacht werden';

  @override
  String get settings_application_lock_title => 'Sperre';

  @override
  String get settings_application_lock_description =>
      'Lock the application and require to authenticate with the device to unlock it';

  @override
  String get settings_application_lock_delay_title => 'Sperrverzögerung';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Notizen Sperre';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Barrierefreiheit';

  @override
  String get settings_accessibility_text_size => 'Textgröße';

  @override
  String get settings_accessibility_text_color => 'Textfarbe';

  @override
  String get settings_accessibility_description => 'Textfarbe, Textgröße';

  @override
  String get settings_text_scaling => 'Textskalierung';

  @override
  String get settings_bigger_titles => 'Größere Titel';

  @override
  String get settings_bigger_titles_description =>
      'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'Weißer Text im dunklen Modus';

  @override
  String get settings_white_text_dark_mode_description =>
      'Verwende Weiß für den Text im dunklen Modus';

  @override
  String get settings_disable_subdued_note_content_preview =>
      'Ungedämpfte Notiz Vorschau';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Blassere Textfarbe der Notizvorschau deaktivieren';

  @override
  String get settings_help_section_contact => 'Kontakt';

  @override
  String get settings_github_issues =>
      'Melde einen Fehler oder frage eine Funktion an';

  @override
  String get settings_github_issues_description =>
      'Melde einen Fehler oder frage eine Funktion über ein GitHub Issue an';

  @override
  String get settings_github_discussions => 'Stelle eine Frage';

  @override
  String get settings_github_discussions_description =>
      'Stelle eine Frage in GitHub Diskussionen';

  @override
  String get settings_contact_developer => 'Kontaktiere den Entwickler';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Kontaktiere den Entwickler über Mail an $email';
  }

  @override
  String get settings_help => 'Hilfe';

  @override
  String get settings_help_description => 'Kontakt, Logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Kopiere die Logs';

  @override
  String get settings_copy_logs_description =>
      'Kopiere die Logs der App in die Zwischenablage';

  @override
  String get settings_export_logs => 'Exportiere die Logs';

  @override
  String get settings_export_logs_description =>
      'Exportiere die Logs der App in eine Textdatei';

  @override
  String get settings_about => 'Über';

  @override
  String get settings_about_description => 'Informationen, Links, Spenden';

  @override
  String get settings_about_application => 'Anwendung';

  @override
  String get settings_build_mode => 'Build Modus';

  @override
  String get settings_build_mode_release => 'Veröffentlichung';

  @override
  String get settings_build_mode_debug => 'Fehlerbehebung';

  @override
  String get settings_about_links => 'Links';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Den Quellcode einsehen';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description =>
      'Lokalisierungen im Crowdin-Projekt hinzufügen oder verbessern';

  @override
  String get settings_licence => 'Lizenz';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Spenden';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Titel';

  @override
  String get hint_content => 'Notiz';

  @override
  String get hint_link => 'Verknüpfung';

  @override
  String get hint_label_name => 'Name';

  @override
  String get dialog_export_encryption_password => 'Passwort';

  @override
  String get dialog_select_labels => 'Labels auswählen';

  @override
  String get dialog_select_labels_to_add => 'Labels zum hinzufügen auswählen';

  @override
  String get tooltip_undo => 'Letzte Aktion rückgängig machen';

  @override
  String get tooltip_redo => 'Letzte Aktion wiederholen';

  @override
  String get tooltip_fab_add_note => 'Notiz hinzufügen';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Label hinzufügen';

  @override
  String get tooltip_fab_empty_bin => 'Papierkorb leeren';

  @override
  String get tooltip_fab_toggle_editor_mode_edit =>
      'In Bearbeitungsmodus wechseln';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'In Lesemodus wechseln';

  @override
  String get tooltip_layout_list => 'Listenansicht';

  @override
  String get tooltip_layout_grid => 'Tabellenansicht';

  @override
  String get tooltip_sort => 'Notizen sortieren';

  @override
  String get tooltip_search => 'Notizen suchen';

  @override
  String get tooltip_unselect_all => 'Alle abwählen';

  @override
  String get tooltip_reset => 'Zurücksetzen';

  @override
  String get dialog_add_link => 'Verknüpfung hinzufügen';

  @override
  String get dialog_archive => 'Archivieren';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Löschen';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notizen',
      one: 'Notiz',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'diese',
      one: 'diese',
    );
    return 'Willst du wirklich $count $_temp0 löschen? Du kannst $_temp1 aus dem Papierkorb wiederherstellen.';
  }

  @override
  String get dialog_permanently_delete => 'Dauerhaft löschen';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notizen',
      one: 'Notiz',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'diese',
      one: 'diese',
    );
    return 'Willst du wirklich $count $_temp0 dauerhaft löschen? Du kannst $_temp1 nicht mehr wiederherstellen.';
  }

  @override
  String get dialog_restore => 'Wiederherstellen';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notizen',
      one: 'Notiz',
    );
    return 'Willst du wirklich $count $_temp0 wiederherstellen?';
  }

  @override
  String get dialog_empty_bin => 'Papierkorb leeren';

  @override
  String get dialog_empty_bin_body =>
      'Willst du den Papierkorb wirklich dauerhaft leeren? Du kannst die enthaltenen Notizen nicht wiederherstellen.';

  @override
  String get dialog_delete_label => 'Löschen';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Labels',
      one: 'Label',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Sie werden',
      one: 'Es wird',
    );
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'diese',
      one: 'es',
    );
    return 'Willst du wirklich $count $_temp0 löschen? $_temp1 von den Notizen entfernt, denen du $_temp2 hinzugefügt hast.';
  }

  @override
  String get dialog_export_encryption_switch => 'Verschlüssele den JSON Export';

  @override
  String get dialog_export_encryption_description =>
      'Der Titel und der Inhalt der Notiz werden mit deinem Passwort verschlüsselt. Es sollte zufällig generiert, 32 Zeichen lang, stark (mindestens 1 Kleinbuchstabe, 1 Großbuchstabe, 1 Ziffer, 1 Sonderzeichen) und sicher gespeichert sein.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Passwort, das für alle zukünftigen automatischen Exporte genutzt wird.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Dieses Passwort wird nur für diesen Export verwendet.';

  @override
  String get dialog_export_encryption_password_invalid => 'Ungültig';

  @override
  String get dialog_import_encryption_password_description =>
      'Dieser Export ist verschlüsselt. Um ihn zu importieren, musst du das Passwort eingeben, das du zum Verschlüsseln verwendet hast.';

  @override
  String get dialog_import_encryption_password_error =>
      'Die Entschlüsselung des Exportes ist fehlgeschlagen. Bitte überprüfe, dass du das Passwort eingegeben hast, das du zum Verschlüsseln verwendet hast.';

  @override
  String get dialog_label_add => 'Label hinzufügen';

  @override
  String get dialog_label_edit => 'Label bearbeiten';

  @override
  String get dialog_label_name_cannot_be_empty =>
      'Der Name darf nicht leer sein.';

  @override
  String get dialog_label_name_already_used =>
      'Dieser Name wird bereits verwendet.';

  @override
  String get button_sort_creation_date => 'Erstellungsdatum';

  @override
  String get button_sort_edition_date => 'Datum der Bearbeitung';

  @override
  String get placeholder_notes => 'Keine Notizen';

  @override
  String get placeholder_labels => 'Keine Labels';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'Keine gelöschten Notizen';

  @override
  String get action_disabled => 'Aus';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Anheften';

  @override
  String get action_unpin => 'Loslösen';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Teilen';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notizen',
      one: 'Notiz',
    );
    return '$count $_temp0 von Material Notes geteilt';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Löschen';

  @override
  String get action_restore => 'Wiederherstellen';

  @override
  String get action_delete_permanently => 'Endgültig löschen';

  @override
  String get action_about => 'Über';

  @override
  String get about_last_edited => 'Zuletzt bearbeitet';

  @override
  String get about_type => 'Typ';

  @override
  String get about_created => 'Erstellt';

  @override
  String get about_labels => 'Labels';

  @override
  String get about_words => 'Wörter';

  @override
  String get about_characters => 'Zeichen';

  @override
  String get about_time_at => 'um';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Fixierung umschalten';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Bearbeiten';

  @override
  String get action_labels_delete => 'Löschen';

  @override
  String get filter_labels_all => 'Alle';

  @override
  String get filter_labels_visible => 'Sichtbar';

  @override
  String get filter_labels_hidden => 'Verborgen';

  @override
  String get filter_labels_pinned => 'Fixiert';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed =>
      'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notizen wurden',
      one: 'Notiz wurde',
    );
    return 'Die $_temp0 archiviert';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notizen wurden',
      one: 'Notiz wurde',
    );
    return 'Die $_temp0 aus dem Archiv geholt';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes were',
      one: 'note was',
    );
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'notes',
      one: 'note',
    );
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success =>
      'Das Backup wurde erfolgreich importiert.';

  @override
  String get snack_bar_export_success =>
      'Das Backup wurde erfolgreich exportiert.';

  @override
  String get snack_bar_logs_copied =>
      'Die Logs wurden in deine Zwischenablage kopiert.';

  @override
  String get snack_bar_logs_exported =>
      'Die Logs wurden erfolgreich exportiert.';

  @override
  String get snack_bar_no_labels => 'Es gibt keine Labels.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Willkommen bei Material Notes!';

  @override
  String get welcome_note_content =>
      'Einfache, lokale, materiell designte Notizen';

  @override
  String get font_system_default => 'System Standard';

  @override
  String get note_type_plain_text => 'Unformatierter Text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Formatierter Text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground =>
      'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background =>
      'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description =>
      'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description =>
      'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description =>
      'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description =>
      'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description =>
      'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting =>
      'Press back again to exit the application.';
}
