// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Jednoduché, lokální poznámky s material designem';

  @override
  String app_about(String appName) {
    return '$appName je textová aplikace pro psaní poznámek, jejímž cílem je jednoduchost. Používá material design. Ukládá poznámky lokálně a nemá žádná oprávnění k internetu, takže jste jediný, který má k poznámkám přístup.';
  }

  @override
  String get error_snack_bar => 'Chyba:';

  @override
  String get error_widget_title => 'Došlo k chybě.';

  @override
  String get error_widget_description =>
      'Prosím nahlaste tento problém na GitHub nebo prostřednictvím e-mailu. Připojte snímek této stránky a logy, které můžete zkopírovat nebo exportovat níže. Jako preventivní opatření byste také měli exportovat své poznámky.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Nastavení označující aplikaci jako bezpečnou je zakázáno, dokud nedojde k dalšímu restartu pro povolení snímků obrazovky.';

  @override
  String get error_widget_button_export_notes => 'Exportovat poznámky';

  @override
  String get error_widget_button_copy_logs => 'Kopírovat logy';

  @override
  String get error_widget_button_export_logs => 'Exportovat logy';

  @override
  String get error_widget_button_create_github_issue =>
      'Oznámit chybu na GitHubu';

  @override
  String get error_widget_button_send_mail => 'Poslat e-mail';

  @override
  String get navigation_notes => 'Poznámky';

  @override
  String get navigation_manage_labels_destination => 'Spravovat štítky';

  @override
  String get navigation_manage_labels_page => 'Štítky';

  @override
  String get navigation_archives => 'Archivy';

  @override
  String get navigation_bin => 'Koš';

  @override
  String get navigation_settings => 'Nastavení';

  @override
  String get navigation_settings_appearance => 'Vzhled';

  @override
  String get navigation_settings_notes_types => 'Typy poznámek';

  @override
  String get navigation_settings_notes_tiles => 'Dlaždice poznámek';

  @override
  String get navigation_settings_behavior => 'Chování';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Štítky';

  @override
  String get navigation_settings_backup => 'Záloha';

  @override
  String get navigation_settings_security => 'Zabezpečení';

  @override
  String get navigation_settings_accessibility => 'Přístupnost';

  @override
  String get navigation_settings_help => 'Nápověda';

  @override
  String get navigation_settings_about => 'O aplikaci';

  @override
  String get button_sort_title => 'Název';

  @override
  String get button_sort_ascending => 'Vzestupně';

  @override
  String get settings_page_appearance => 'Vzhled';

  @override
  String get settings_page_appearance_description => 'Jazyk, motiv, písma';

  @override
  String get settings_language => 'Jazyk';

  @override
  String get settings_language_contribute => 'Zapojte se';

  @override
  String get settings_appearance_section_theming => 'Motiv';

  @override
  String get settings_theme => 'Motiv';

  @override
  String get settings_theme_system => 'Systémový';

  @override
  String get settings_theme_light => 'Světlý';

  @override
  String get settings_theme_dark => 'Tmavý';

  @override
  String get settings_dynamic_theming => 'Dynamický motiv';

  @override
  String get settings_dynamic_theming_description =>
      'Generovat barvy ze systému';

  @override
  String get settings_black_theming => 'Černý motiv';

  @override
  String get settings_black_theming_description =>
      'Použít černé pozadí v tmavém režimu';

  @override
  String get settings_appearance_section_fonts => 'Písmo';

  @override
  String get settings_app_font => 'Písmo aplikace';

  @override
  String get settings_app_font_description =>
      'Písmo používané pro všechny texty v aplikaci, kromě editoru poznámek';

  @override
  String get settings_editor_font => 'Písmo editoru';

  @override
  String get settings_editor_font_description =>
      'Písmo používané pouze pro text v editoru poznámek';

  @override
  String get settings_page_notes_tiles => 'Dlaždice poznámek';

  @override
  String get settings_page_notes_tiles_description => 'Vzhled, obsah';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Vzhled';

  @override
  String get settings_page_notes_tiles_content_section => 'Obsah';

  @override
  String get settings_show_tiles_background => 'Pozadí';

  @override
  String get settings_show_tiles_background_description =>
      'Zobrazit pozadí dlaždic poznámek';

  @override
  String get settings_show_separators => 'Oddělovače';

  @override
  String get settings_show_separators_description =>
      'Zobrazit oddělovač mezi dlaždicemi poznámek';

  @override
  String get settings_show_note_type_icon => 'Zobrazit ikonku typu';

  @override
  String get settings_show_note_type_icon_description =>
      'Zobrazit ikonku typu poznámky';

  @override
  String get settings_show_titles_only => 'Pouze názvy';

  @override
  String get settings_show_titles_only_description =>
      'Zobrazit pouze názvy poznámek';

  @override
  String get settings_show_titles_only_disable_in_search_view =>
      'Zakázat zobrazování pouze názvů při hledání';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Zakázat možnost zobrazující pouze názvy při vyhledávání';

  @override
  String get settings_content_preview_max_lines =>
      'Maximální počet řádků náhledu';

  @override
  String get settings_content_preview_max_lines_description =>
      'Maximální počet zobrazených řádků při zobrazování náhledu obsahu';

  @override
  String get settings_behavior => 'Chování';

  @override
  String get settings_behavior_description => 'Potvrzování, akce přejetím';

  @override
  String get settings_behavior_application => 'Aplikace';

  @override
  String get settings_confirmations => 'Potvrzovací dialog';

  @override
  String get settings_confirmations_description =>
      'Kdy zobrazit dialogové okno s potvrzením při provádění akce na poznámce';

  @override
  String get settings_confirmations_title_none => 'Nikdy';

  @override
  String get settings_confirmations_title_irreversible => 'Pouze nevratné akce';

  @override
  String get settings_confirmations_title_all => 'Vždy';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description =>
      'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Akce přejetím';

  @override
  String get settings_behavior_swipe_actions_archives =>
      'Akce přejetím (archivy)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Akce přejetím (koš)';

  @override
  String get settings_swipe_action_right => 'Akce přejetím doprava';

  @override
  String get settings_swipe_action_right_description =>
      'Akce spuštěná po přejetí po dlaždici poznámky prstem doprava';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Akce spuštěná po přejetí po dlaždici poznámky v koši prstem doprava';

  @override
  String get settings_swipe_action_left => 'Akce přejetím doleva';

  @override
  String get settings_swipe_action_left_description =>
      'Akce spuštěná po přejetí po dlaždici poznámky prstem doleva';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Akce spuštěná po přejetí po dlaždici poznámky v koši prstem doleva';

  @override
  String get settings_page_notes_types => 'Typy poznámek';

  @override
  String get settings_page_notes_types_description =>
      'Používané typy, bohatý text';

  @override
  String get settings_section_types_to_use => 'Používané typy';

  @override
  String get settings_available_notes_types => 'Dostupné typy poznámek';

  @override
  String get settings_available_notes_types_description =>
      'Seznam typů poznámek, které lze vytvořit pomocí tlačítka \"Přidat\" ze stránky s poznámkami. Při odebrání typu nejsou již existující poznámky s tímto typem smazány a mohou být stále normálně používány';

  @override
  String get settings_available_default_share_type => 'Výchozí typ ze sdílení';

  @override
  String get settings_available_default_share_type_description =>
      'Výchozí typ poznámky, který se použije při vytváření poznámky ze sdílení. Může to být typ, který není k dispozici z tlačítka \"Přidat\"';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Chování';

  @override
  String get settings_editor_behavior => 'Chování';

  @override
  String get settings_show_editor_mode_button => 'Tlačítko režimu editoru';

  @override
  String get settings_show_editor_mode_button_description =>
      'Povolit tlačítko pro přepnutí editoru mezi režimem úpravy a čtení';

  @override
  String get settings_open_editor_reading_mode => 'Otevřít v režimu čtení';

  @override
  String get settings_open_editor_reading_mode_description =>
      'Ve výchozím nastavení otevírat editor v režimu čtení';

  @override
  String get settings_focus_title_on_new_note => 'Zaměřit název';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Zaměřit název namísto obsahu při vytvoření nové poznámky';

  @override
  String get settings_editor_appearance => 'Vzhled';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description =>
      'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'Rozestup mezi odstavci';

  @override
  String get settings_use_paragraph_spacing_description =>
      'Používat odstup mezi odstavci';

  @override
  String get settings_labels => 'Štítky';

  @override
  String get settings_labels_description => 'Povolit, vzhled';

  @override
  String get settings_enable_labels => 'Povolit';

  @override
  String get settings_enable_labels_description =>
      'Povolit kategorizaci poznámek pomocí štítků (vypnutí neodstraní štítky ani je neodstraní z poznámek, pouze je skryje)';

  @override
  String get settings_labels_appearance => 'Vzhled';

  @override
  String get settings_show_labels_note_tile =>
      'Zobrazit štítky na dlaždici poznámky';

  @override
  String get settings_show_labels_note_tile_description =>
      'Zobrazit seznam štítků na dlaždicích poznámek';

  @override
  String get settings_show_labels_editor => 'Zobrazit štítky v editoru';

  @override
  String get settings_show_labels_editor_description =>
      'Zobrazit seznam štítků na spodní části editoru';

  @override
  String get settings_labels_section_behavior => 'Chování';

  @override
  String get settings_labels_swipe_action_right => 'Akce přejetím doprava';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Akce spuštěná po přejetí po dlaždici štítku prstem doprava';

  @override
  String get settings_labels_swipe_action_left => 'Akce přejetím doleva';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Akce spuštěná po přejetí po dlaždici štítku prstem doleva';

  @override
  String get settings_backup => 'Zálohování';

  @override
  String get settings_backup_description =>
      'Manuální a automatický export, šifrování, import';

  @override
  String get settings_backup_import => 'Import';

  @override
  String get settings_import => 'Import';

  @override
  String get settings_import_description =>
      'Importovat poznámky, štítky a nastavení ze souboru JSON';

  @override
  String get settings_backup_manual_export => 'Manuální export';

  @override
  String get settings_export_json => 'Exportovat jako JSON';

  @override
  String get settings_export_json_description =>
      'Okamžitě exportovat všechny poznámky, štítky a nastavení do JSON souboru, který lze importovat zpět';

  @override
  String get settings_export_markdown => 'Exportovat jako Markdown';

  @override
  String get settings_export_markdown_description =>
      'Okamžitě exportovat všechny poznámky do Markdown souboru';

  @override
  String get settings_backup_auto_export => 'Automatický export';

  @override
  String get settings_auto_export => 'Automatický export';

  @override
  String get settings_auto_export_description =>
      'Automaticky exportovat všechny poznámky, štítky a nastavení do JSON souboru, který lze importovat zpět';

  @override
  String get settings_auto_export_frequency => 'Frekvence';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description =>
      'Frekvence automatického exportu';

  @override
  String get settings_auto_export_encryption => 'Šifrování';

  @override
  String get settings_auto_export_encryption_description =>
      'Šifrovat názvy a obsah poznámek heslem';

  @override
  String get settings_auto_export_directory => 'Složka';

  @override
  String get settings_auto_export_directory_description =>
      'Složka, kam ukládat automatické exporty';

  @override
  String get settings_security => 'Zabezpečení';

  @override
  String get settings_security_description =>
      'Označit zabezpečeně, zámek aplikace, zámek poznámky';

  @override
  String get settings_security_application => 'Aplikace';

  @override
  String get settings_security_application_lock => 'Zámek aplikace';

  @override
  String get settings_security_note_lock => 'Zámek poznámky';

  @override
  String get settings_flag_secure => 'Označit aplikaci jako zabezpečenou';

  @override
  String get settings_flag_secure_description =>
      'Skryje aplikaci z nedávných aplikací a zabrání snímkům obrazovky';

  @override
  String get settings_application_lock_title => 'Zamykat';

  @override
  String get settings_application_lock_description =>
      'Zamykat aplikaci a požadovat ověření zařízení pro odemčení';

  @override
  String get settings_application_lock_delay_title => 'Zpoždění uzamknutí';

  @override
  String get settings_application_lock_delay_description =>
      'Zpoždění, po kterém se aplikace uzamkne když je přesunuta na pozadí';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Zámek poznámky';

  @override
  String get settings_note_lock_description =>
      'Zamykat poznámku a požadovat ověření zařízení pro její zobrazení a úpravu';

  @override
  String get settings_label_lock_title => 'Zámek štítku';

  @override
  String get settings_label_lock_description =>
      'Zamykat štítek a požadovat ověření zařízení pro zobrazení a úpravu jakékoli poznámky s tímto štítkem';

  @override
  String get settings_note_lock_delay_title => 'Zpoždění uzamknutí';

  @override
  String get settings_note_lock_delay_description =>
      'Zpoždění, po kterém se poznámka zamkne, když je aplikace přesunuta na pozadí';

  @override
  String get settings_accessibility => 'Přístupnost';

  @override
  String get settings_accessibility_text_size => 'Velikost písma';

  @override
  String get settings_accessibility_text_color => 'Barva textu';

  @override
  String get settings_accessibility_description => 'Barva textu, měřítko textu';

  @override
  String get settings_text_scaling => 'Měřítko textu';

  @override
  String get settings_bigger_titles => 'Větší názvy';

  @override
  String get settings_bigger_titles_description =>
      'Zobrazit větší názvy na dlaždicích poznámek a v editoru';

  @override
  String get settings_white_text_dark_mode => 'Bílý text v tmavém režimu';

  @override
  String get settings_white_text_dark_mode_description =>
      'Použít v tmavém režimu bílou barvu pro text';

  @override
  String get settings_disable_subdued_note_content_preview =>
      'Neutlumený náhled';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Zakázat utlumenou barvu textu v náhledu poznámek';

  @override
  String get settings_help_section_contact => 'Kontakt';

  @override
  String get settings_github_issues => 'Nahlásit chybu nebo požádat o funkci';

  @override
  String get settings_github_issues_description =>
      'Nahlásit chybu nebo požádat o funkci vytvořením problému na GitHubu';

  @override
  String get settings_github_discussions => 'Zeptejte se';

  @override
  String get settings_github_discussions_description =>
      'Položit otázku v diskuzi na GitHubu';

  @override
  String get settings_contact_developer => 'Kontaktovat vývojáře';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Kontaktujte vývojáře e-mailem na $email';
  }

  @override
  String get settings_help => 'Nápověda';

  @override
  String get settings_help_description => 'Kontakt, logy';

  @override
  String get settings_help_section_logs => 'Logy';

  @override
  String get settings_copy_logs => 'Zkopírovat logy';

  @override
  String get settings_copy_logs_description =>
      'Zkopírovat logy aplikace do schránky';

  @override
  String get settings_export_logs => 'Exportovat logy';

  @override
  String get settings_export_logs_description =>
      'Exportovat logy aplikace do textového souboru';

  @override
  String get settings_about => 'O aplikaci';

  @override
  String get settings_about_description => 'Informace, odkazy, přispět';

  @override
  String get settings_about_application => 'Aplikace';

  @override
  String get settings_build_mode => 'Režim sestavení';

  @override
  String get settings_build_mode_release => 'Vydání';

  @override
  String get settings_build_mode_debug => 'Ladění';

  @override
  String get settings_about_links => 'Odkazy';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Prohlédněte si zdrojový kód';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description =>
      'Přidat nebo vylepšit lokalizaci na projektu Crowdin';

  @override
  String get settings_licence => 'Licence';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Přispět';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Nadpis';

  @override
  String get hint_content => 'Poznámka';

  @override
  String get hint_link => 'Odkaz';

  @override
  String get hint_label_name => 'Název';

  @override
  String get dialog_export_encryption_password => 'Heslo';

  @override
  String get dialog_select_labels => 'Vybrat štítky';

  @override
  String get dialog_select_labels_to_add => 'Vyberte štítky k přidání';

  @override
  String get tooltip_undo => 'Vrátit poslední akci';

  @override
  String get tooltip_redo => 'Opakovat poslední akci';

  @override
  String get tooltip_fab_add_note => 'Přidat poznámku';

  @override
  String get tooltip_fab_add_plain_text_note =>
      'Přidat poznámku s prostým textem';

  @override
  String get tooltip_fab_add_markdown_note => 'Přidat markdown poznámku';

  @override
  String get tooltip_fab_add_rich_text_note =>
      'Přidat poznámku s bohatým textem';

  @override
  String get tooltip_fab_add_checklist_note =>
      'Přidat poznámku se zaškrtávacím seznamem';

  @override
  String get tooltip_fab_add_label => 'Přidat štítek';

  @override
  String get tooltip_fab_empty_bin => 'Vysypat koš';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Přepnout do režimu úprav';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Přepnout do režimu čtení';

  @override
  String get tooltip_layout_list => 'Zobrazit jako seznam';

  @override
  String get tooltip_layout_grid => 'Zobrazit jako mřížku';

  @override
  String get tooltip_sort => 'Řazení poznámek';

  @override
  String get tooltip_search => 'Hledat poznámky';

  @override
  String get tooltip_unselect_all => 'Zrušit výběr';

  @override
  String get tooltip_reset => 'Výchozí';

  @override
  String get dialog_add_link => 'Přidat odkaz';

  @override
  String get dialog_archive => 'Archivovat';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek',
      many: 'poznámek',
      few: 'poznámky',
      one: 'poznámku',
    );
    return 'Opravdu chcete archivovat $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Obnovit z archivu';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek',
      many: 'poznámek',
      few: 'poznámky',
      one: 'poznámku',
    );
    return 'Opravdu chcete obnovit $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Odstranit';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek',
      few: 'poznámky',
      one: 'poznámku',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'je',
      one: 'ji',
    );
    return 'Opravdu chcete odstranit $count $_temp0? Můžete $_temp1 obnovit z koše.';
  }

  @override
  String get dialog_permanently_delete => 'Trvale odstranit';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek',
      few: 'poznámky',
      one: 'poznámku',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'je',
      one: 'ji',
    );
    return 'Opravdu chcete trvale odstranit $count $_temp0? Už $_temp1 nebudete moci obnovit z koše.';
  }

  @override
  String get dialog_restore => 'Obnovit';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek',
      many: 'poznámek',
      few: 'poznámky',
      one: 'poznámku',
    );
    return 'Opravdu chcete obnovit $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Vysypat koš';

  @override
  String get dialog_empty_bin_body =>
      'Opravdu chcete trvale vyprázdnit koš? Nebudete moci obnovit poznámky, které obsahuje.';

  @override
  String get dialog_delete_label => 'Odstranit';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'štítků',
      many: 'štítků',
      few: 'štítky',
      one: 'štítek',
    );
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Budou odstraněny',
      one: 'Bude odstraněn',
    );
    String _temp2 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'je',
      one: 'ho',
    );
    return 'Opravdu chcete odstranit $count $_temp0? $_temp1 ze všech poznámek na které jste $_temp2 přidali.';
  }

  @override
  String get dialog_export_encryption_switch => 'Šifrovat export JSON';

  @override
  String get dialog_export_encryption_description =>
      'Název a obsah poznámek bude šifrován pomocí vašeho hesla. Mělo by být náhodně vygenerované, přesně 32 znaků dlouhé, silné (alespoň 1 malé písmeno, 1 velké písmeno, 1 číslo a 1 speciální znak) a bezpečně uložené.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'Toto heslo bude použito pro všechny budoucí automatické exporty.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'Toto heslo bude použito pouze pro tento export.';

  @override
  String get dialog_export_encryption_password_invalid => 'Neplatné';

  @override
  String get dialog_import_encryption_password_description =>
      'Tento export je zašifrovaný. Chcete-li jej importovat, musíte zadat heslo použité k jeho šifrování.';

  @override
  String get dialog_import_encryption_password_error =>
      'dešifrování exportu se nezdařilo. Zkontrolujte, zda jste zadali stejné heslo, které jste použili pro šifrování exportu.';

  @override
  String get dialog_label_add => 'Přidat štítek';

  @override
  String get dialog_label_edit => 'Upravit štítek';

  @override
  String get dialog_label_name_cannot_be_empty => 'Název nemůže být prázdný.';

  @override
  String get dialog_label_name_already_used => 'Tento název se již používá.';

  @override
  String get button_sort_creation_date => 'Datum vytvoření';

  @override
  String get button_sort_edition_date => 'Datum úpravy';

  @override
  String get placeholder_notes => 'Žádné poznámky';

  @override
  String get placeholder_labels => 'Žádné štítky';

  @override
  String get placeholder_archives => 'Žádné archivované poznámky';

  @override
  String get placeholder_bin => 'Žádné odstraněné poznámky';

  @override
  String get action_disabled => 'Vypnuto';

  @override
  String get action_toggle_pin => 'Přepnout připnutí';

  @override
  String get action_pin_unpin => 'Připnout / Odepnout';

  @override
  String get action_pin => 'Připnout';

  @override
  String get action_unpin => 'Odepnout';

  @override
  String get action_toggle_lock => 'Přepnout zámek';

  @override
  String get action_lock_unlock => 'Zamknout / Odemknout';

  @override
  String get action_lock => 'Zamknout';

  @override
  String get action_unlock => 'Odemknout';

  @override
  String get action_share => 'Sdílet';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek sdíleno',
      many: 'poznámek sdíleno',
      few: 'poznámky sdíleny',
      one: 'poznámka sdílena',
    );
    return '$count $_temp0 z aplikace Material Notes';
  }

  @override
  String get action_archive => 'Archivovat';

  @override
  String get action_unarchive => 'Obnovit z archivu';

  @override
  String get action_delete => 'Odstranit';

  @override
  String get action_restore => 'Obnovit';

  @override
  String get action_delete_permanently => 'Trvale odstranit';

  @override
  String get action_about => 'Informace';

  @override
  String get about_last_edited => 'Naposledy upraveno';

  @override
  String get about_type => 'Typ';

  @override
  String get about_created => 'Vytvořeno';

  @override
  String get about_labels => 'Štítky';

  @override
  String get about_words => 'Počet slov';

  @override
  String get about_characters => 'Znaky';

  @override
  String get about_time_at => 'v';

  @override
  String get menu_action_select_labels => 'Štítky';

  @override
  String get menu_action_add_labels => 'Přidat štítky';

  @override
  String get action_labels_toggle_visibile => 'Přepnout viditelnost';

  @override
  String get action_labels_show_hide => 'Zobrazit / Skrýt';

  @override
  String get action_labels_show => 'Zobrazit';

  @override
  String get action_labels_hide => 'Skrýt';

  @override
  String get action_labels_toggle_pins => 'Přepnout připnutí';

  @override
  String get action_labels_pin_unpin => 'Připnout / Odepnout';

  @override
  String get action_labels_pin => 'Připnout';

  @override
  String get action_labels_unpin => 'Odepnout';

  @override
  String get action_labels_toggle_lock => 'Přepnout zámek';

  @override
  String get action_labels_lock_unlock => 'Zamknout / Odemknout';

  @override
  String get action_labels_lock => 'Zamknout';

  @override
  String get action_labels_unlock => 'Odemknout';

  @override
  String get action_labels_edit => 'Upravit';

  @override
  String get action_labels_delete => 'Odstranit';

  @override
  String get filter_labels_all => 'Vše';

  @override
  String get filter_labels_visible => 'Viditelné';

  @override
  String get filter_labels_hidden => 'Skryté';

  @override
  String get filter_labels_pinned => 'Připnuté';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed =>
      'Ověření se nezdařilo, zkuste to prosím znovu.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Poznámky byly archivovány',
      one: 'Poznámka byla archivována',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Poznámky byly obnoveny',
      one: 'Poznámka byla obnovena',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Poznámky byly odstraněny',
      one: 'Poznámka byla odstraněna',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Poznámky byly obnoveny',
      one: 'Poznámka byla obnovena',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'poznámek',
      one: 'poznámky',
    );
    return 'Obsah $_temp0 zkopírovan do schránky.';
  }

  @override
  String get snack_bar_import_success => 'Záloha byla úspěšně importována.';

  @override
  String get snack_bar_export_success => 'Záloha byla úspěšně exportována.';

  @override
  String get snack_bar_logs_copied => 'Logy byly zkopírovány do schránky.';

  @override
  String get snack_bar_logs_exported => 'Logy byly úspěšně exportovány.';

  @override
  String get snack_bar_no_labels => 'Nemáte žádné štítky.';

  @override
  String get quick_action_add_plain_text_note_title =>
      'Přidat poznámku s prostým textem';

  @override
  String get quick_action_add_markdown_note_title => 'Přidat markdown poznámku';

  @override
  String get quick_action_add_rich_text_note_title =>
      'Přidat poznámku s bohatým textem';

  @override
  String get quick_action_add_checklist_note_title =>
      'Přidat poznámku se zaškrtávacím seznamem';

  @override
  String get welcome_note_title => 'Vítejte v Material Notes!';

  @override
  String get welcome_note_content =>
      'Jednoduché, lokální poznámky s material designem';

  @override
  String get font_system_default => 'Výchozí systémový';

  @override
  String get note_type_plain_text => 'Prostý text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Formátovaný text';

  @override
  String get note_type_checklist => 'Zaškrtávací seznam';

  @override
  String get lock_page_reason_app => 'Odemknout Material Notes';

  @override
  String get lock_page_reason_note => 'Odemknout tuto poznámku';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'Aplikace je uzamčena.';

  @override
  String get lock_page_description_note => 'Tato poznámka je uzamčena.';

  @override
  String get lock_page_unlock => 'Odemknout';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground =>
      'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background =>
      'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description =>
      'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description =>
      'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description =>
      'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description =>
      'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description =>
      'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting =>
      'Press back again to exit the application.';
}
