/// A list of raw data of countries.
List<Map<String, dynamic>> getRawCountriesData() => const [
      {
        'commonName': 'Aruba',
        'officialName': 'Aruba',
        'nativeNames': {
          'nld': {'official': 'Aruba', 'common': 'Aruba'},
          'pap': {'official': 'Aruba', 'common': 'Aruba'},
        },
        'iso2': 'AW',
        'iso3': 'ABW',
        'phoneCode': '+297',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [12.5, -69.96666666],
        'capital': 'Oranjestad',
        'currencies': {
          'AWG': {'name': 'Aruban florin', 'symbol': '\u0192'},
        },
        'languages': {'nld': 'Dutch', 'pap': 'Papiamento'},
        'flag': '\ud83c\udde6\ud83c\uddfc',
        'borders': <String>[],
        'tld': '.aw',
        'area': 180,
        'timezones': ['America/Aruba'],
      },
      {
        'commonName': 'Afghanistan',
        'officialName': 'Islamic Republic of Afghanistan',
        'nativeNames': {
          'prs': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u06cc \u0627\u0633\u0644\u0627\u0645\u06cc \u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646',
            'common': '\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646',
          },
          'pus': {
            'official':
                '\u062f \u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646 \u0627\u0633\u0644\u0627\u0645\u064a \u062c\u0645\u0647\u0648\u0631\u06cc\u062a',
            'common': '\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646',
          },
          'tuk': {
            'official': 'Owganystan Yslam Respublikasy',
            'common': 'Owganystan',
          },
        },
        'iso2': 'AF',
        'iso3': 'AFG',
        'phoneCode': '+93',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [33, 65],
        'capital': 'Kabul',
        'currencies': {
          'AFN': {'name': 'Afghan afghani', 'symbol': '\u060b'},
        },
        'languages': {'prs': 'Dari', 'pus': 'Pashto', 'tuk': 'Turkmen'},
        'flag': '\ud83c\udde6\ud83c\uddeb',
        'borders': ['IRN', 'PAK', 'TKM', 'UZB', 'TJK', 'CHN'],
        'tld': '.af',
        'area': 652230,
        'timezones': ['Asia/Kabul'],
      },
      {
        'commonName': 'Angola',
        'officialName': 'Republic of Angola',
        'nativeNames': {
          'por': {'official': 'Rep\u00fablica de Angola', 'common': 'Angola'},
        },
        'iso2': 'AO',
        'iso3': 'AGO',
        'phoneCode': '+244',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [-12.5, 18.5],
        'capital': 'Luanda',
        'currencies': {
          'AOA': {'name': 'Angolan kwanza', 'symbol': 'Kz'},
        },
        'languages': {'por': 'Portuguese'},
        'flag': '\ud83c\udde6\ud83c\uddf4',
        'borders': ['COG', 'COD', 'ZMB', 'NAM'],
        'tld': '.ao',
        'area': 1246700,
        'timezones': ['Africa/Luanda'],
      },
      {
        'commonName': 'Anguilla',
        'officialName': 'Anguilla',
        'nativeNames': {
          'eng': {'official': 'Anguilla', 'common': 'Anguilla'},
        },
        'iso2': 'AI',
        'iso3': 'AIA',
        'phoneCode': '+1264',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.25, -63.16666666],
        'capital': 'The Valley',
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde6\ud83c\uddee',
        'borders': <String>[],
        'tld': '.ai',
        'area': 91,
        'timezones': ['America/Anguilla'],
      },
      {
        'commonName': '\u00c5land Islands',
        'officialName': '\u00c5land Islands',
        'nativeNames': {
          'swe': {'official': 'Landskapet \u00c5land', 'common': '\u00c5land'},
        },
        'iso2': 'AX',
        'iso3': 'ALA',
        'phoneCode': '+358',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [60.116667, 19.9],
        'capital': 'Mariehamn',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'swe': 'Swedish'},
        'flag': '\ud83c\udde6\ud83c\uddfd',
        'borders': <String>[],
        'tld': '.ax',
        'area': 1580,
        'timezones': ['Europe/Mariehamn'],
      },
      {
        'commonName': 'Albania',
        'officialName': 'Republic of Albania',
        'nativeNames': {
          'sqi': {
            'official': 'Republika e Shqip\u00ebris\u00eb',
            'common': 'Shqip\u00ebria',
          },
        },
        'iso2': 'AL',
        'iso3': 'ALB',
        'phoneCode': '+355',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [41, 20],
        'capital': 'Tirana',
        'currencies': {
          'ALL': {'name': 'Albanian lek', 'symbol': 'L'},
        },
        'languages': {'sqi': 'Albanian'},
        'flag': '\ud83c\udde6\ud83c\uddf1',
        'borders': ['MNE', 'GRC', 'MKD', 'UNK'],
        'tld': '.al',
        'area': 28748,
        'timezones': ['Europe/Tirane'],
      },
      {
        'commonName': 'Andorra',
        'officialName': 'Principality of Andorra',
        'nativeNames': {
          'cat': {'official': "Principat d'Andorra", 'common': 'Andorra'},
        },
        'iso2': 'AD',
        'iso3': 'AND',
        'phoneCode': '+376',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [42.5, 1.5],
        'capital': 'Andorra la Vella',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'cat': 'Catalan'},
        'flag': '\ud83c\udde6\ud83c\udde9',
        'borders': ['FRA', 'ESP'],
        'tld': '.ad',
        'area': 468,
        'timezones': ['Europe/Andorra'],
      },
      {
        'commonName': 'United Arab Emirates',
        'officialName': 'United Arab Emirates',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629',
            'common':
                '\u062f\u0648\u0644\u0629 \u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062a \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0645\u062a\u062d\u062f\u0629',
          },
        },
        'iso2': 'AE',
        'iso3': 'ARE',
        'phoneCode': '+971',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [24, 54],
        'capital': 'Abu Dhabi',
        'currencies': {
          'AED': {
            'name': 'United Arab Emirates dirham',
            'symbol': '\u062f.\u0625',
          },
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\udde6\ud83c\uddea',
        'borders': ['OMN', 'SAU'],
        'tld': '.ae',
        'area': 83600,
        'timezones': ['Asia/Dubai'],
      },
      {
        'commonName': 'Argentina',
        'officialName': 'Argentine Republic',
        'nativeNames': {
          'grn': {'official': 'Argentine Republic', 'common': 'Argentina'},
          'spa': {
            'official': 'Rep\u00fablica Argentina',
            'common': 'Argentina',
          },
        },
        'iso2': 'AR',
        'iso3': 'ARG',
        'phoneCode': '+54',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-34, -64],
        'capital': 'Buenos Aires',
        'currencies': {
          'ARS': {'name': 'Argentine peso', 'symbol': r'$'},
        },
        'languages': {'grn': 'Guaran\u00ed', 'spa': 'Spanish'},
        'flag': '\ud83c\udde6\ud83c\uddf7',
        'borders': ['BOL', 'BRA', 'CHL', 'PRY', 'URY'],
        'tld': '.ar',
        'area': 2780400,
        'timezones': [
          'America/Argentina/Buenos_Aires',
          'America/Argentina/Cordoba',
          'America/Argentina/Salta',
          'America/Argentina/Jujuy',
          'America/Argentina/Tucuman',
          'America/Argentina/Catamarca',
          'America/Argentina/La_Rioja',
          'America/Argentina/San_Juan',
          'America/Argentina/Mendoza',
          'America/Argentina/San_Luis',
          'America/Argentina/Rio_Gallegos',
          'America/Argentina/Ushuaia',
        ],
      },
      {
        'commonName': 'Armenia',
        'officialName': 'Republic of Armenia',
        'nativeNames': {
          'hye': {
            'official':
                '\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576\u056b \u0540\u0561\u0576\u0580\u0561\u057a\u0565\u057f\u0578\u0582\u0569\u0575\u0578\u0582\u0576',
            'common': '\u0540\u0561\u0575\u0561\u057d\u057f\u0561\u0576',
          },
        },
        'iso2': 'AM',
        'iso3': 'ARM',
        'phoneCode': '+374',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [40, 45],
        'capital': 'Yerevan',
        'currencies': {
          'AMD': {'name': 'Armenian dram', 'symbol': '\u058f'},
        },
        'languages': {'hye': 'Armenian'},
        'flag': '\ud83c\udde6\ud83c\uddf2',
        'borders': ['AZE', 'GEO', 'IRN', 'TUR'],
        'tld': '.am',
        'area': 29743,
        'timezones': ['Asia/Yerevan'],
      },
      {
        'commonName': 'American Samoa',
        'officialName': 'American Samoa',
        'nativeNames': {
          'eng': {'official': 'American Samoa', 'common': 'American Samoa'},
          'smo': {
            'official': 'S\u0101moa Amelika',
            'common': 'S\u0101moa Amelika',
          },
        },
        'iso2': 'AS',
        'iso3': 'ASM',
        'phoneCode': '+1684',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-14.33333333, -170],
        'capital': 'Pago Pago',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'smo': 'Samoan'},
        'flag': '\ud83c\udde6\ud83c\uddf8',
        'borders': <String>[],
        'tld': '.as',
        'area': 199,
        'timezones': ['Pacific/Pago_Pago'],
      },
      {
        'commonName': 'Antarctica',
        'officialName': 'Antarctica',
        'nativeNames': <String, dynamic>{},
        'iso2': 'AQ',
        'iso3': 'ATA',
        'phoneCode': '+672',
        'region': 'Antarctic',
        'subregion': '',
        'latlng': [-90, 0],
        'capital': null,
        'currencies': <String, dynamic>{},
        'languages': <String, String>{},
        'flag': '\ud83c\udde6\ud83c\uddf6',
        'borders': <String>[],
        'tld': '.aq',
        'area': 14000000,
        'timezones': [
          'Antarctica/McMurdo',
          'Antarctica/Casey',
          'Antarctica/Davis',
          'Antarctica/DumontDUrville',
          'Antarctica/Mawson',
          'Antarctica/Palmer',
          'Antarctica/Rothera',
          'Antarctica/Syowa',
          'Antarctica/Troll',
          'Antarctica/Vostok',
        ],
      },
      {
        'commonName': 'French Southern and Antarctic Lands',
        'officialName': 'Territory of the French Southern and Antarctic Lands',
        'nativeNames': {
          'fra': {
            'official':
                'Territoire des Terres australes et antarctiques fran\u00e7aises',
            'common': 'Terres australes et antarctiques fran\u00e7aises',
          },
        },
        'iso2': 'TF',
        'iso3': 'ATF',
        'phoneCode': '+262',
        'region': 'Antarctic',
        'subregion': '',
        'latlng': [-49.25, 69.167],
        'capital': 'Port-aux-Fran\u00e7ais',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf9\ud83c\uddeb',
        'borders': <String>[],
        'tld': '.tf',
        'area': 7747,
        'timezones': ['Indian/Kerguelen'],
      },
      {
        'commonName': 'Antigua and Barbuda',
        'officialName': 'Antigua and Barbuda',
        'nativeNames': {
          'eng': {
            'official': 'Antigua and Barbuda',
            'common': 'Antigua and Barbuda',
          },
        },
        'iso2': 'AG',
        'iso3': 'ATG',
        'phoneCode': '+1268',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [17.05, -61.8],
        'capital': "Saint John's",
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde6\ud83c\uddec',
        'borders': <String>[],
        'tld': '.ag',
        'area': 442,
        'timezones': ['America/Antigua'],
      },
      {
        'commonName': 'Australia',
        'officialName': 'Commonwealth of Australia',
        'nativeNames': {
          'eng': {
            'official': 'Commonwealth of Australia',
            'common': 'Australia',
          },
        },
        'iso2': 'AU',
        'iso3': 'AUS',
        'phoneCode': '+61',
        'region': 'Oceania',
        'subregion': 'Australia and New Zealand',
        'latlng': [-27, 133],
        'capital': 'Canberra',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde6\ud83c\uddfa',
        'borders': <String>[],
        'tld': '.au',
        'area': 7692024,
        'timezones': [
          'Australia/Lord_Howe',
          'Antarctica/Macquarie',
          'Australia/Hobart',
          'Australia/Currie',
          'Australia/Melbourne',
          'Australia/Sydney',
          'Australia/Broken_Hill',
          'Australia/Brisbane',
          'Australia/Lindeman',
          'Australia/Adelaide',
          'Australia/Darwin',
          'Australia/Perth',
          'Australia/Eucla',
        ],
      },
      {
        'commonName': 'Austria',
        'officialName': 'Republic of Austria',
        'nativeNames': {
          'bar': {
            'official': 'Republik \u00d6sterreich',
            'common': '\u00d6sterreich',
          },
        },
        'iso2': 'AT',
        'iso3': 'AUT',
        'phoneCode': '+43',
        'region': 'Europe',
        'subregion': 'Central Europe',
        'latlng': [47.33333333, 13.33333333],
        'capital': 'Vienna',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'bar': 'Austro-Bavarian German'},
        'flag': '\ud83c\udde6\ud83c\uddf9',
        'borders': ['CZE', 'DEU', 'HUN', 'ITA', 'LIE', 'SVK', 'SVN', 'CHE'],
        'tld': '.at',
        'area': 83871,
        'timezones': ['Europe/Vienna'],
      },
      {
        'commonName': 'Azerbaijan',
        'officialName': 'Republic of Azerbaijan',
        'nativeNames': {
          'aze': {
            'official': 'Az\u0259rbaycan Respublikas\u0131',
            'common': 'Az\u0259rbaycan',
          },
          'rus': {
            'official':
                '\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430',
            'common':
                '\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d',
          },
        },
        'iso2': 'AZ',
        'iso3': 'AZE',
        'phoneCode': '+994',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [40.5, 47.5],
        'capital': 'Baku',
        'currencies': {
          'AZN': {'name': 'Azerbaijani manat', 'symbol': '\u20bc'},
        },
        'languages': {'aze': 'Azerbaijani', 'rus': 'Russian'},
        'flag': '\ud83c\udde6\ud83c\uddff',
        'borders': ['ARM', 'GEO', 'IRN', 'RUS', 'TUR'],
        'tld': '.az',
        'area': 86600,
        'timezones': ['Asia/Baku'],
      },
      {
        'commonName': 'Burundi',
        'officialName': 'Republic of Burundi',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique du Burundi',
            'common': 'Burundi',
          },
          'run': {'official': "Republika y'Uburundi ", 'common': 'Uburundi'},
        },
        'iso2': 'BI',
        'iso3': 'BDI',
        'phoneCode': '+257',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-3.5, 30],
        'capital': 'Gitega',
        'currencies': {
          'BIF': {'name': 'Burundian franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French', 'run': 'Kirundi'},
        'flag': '\ud83c\udde7\ud83c\uddee',
        'borders': ['COD', 'RWA', 'TZA'],
        'tld': '.bi',
        'area': 27834,
        'timezones': ['Africa/Bujumbura'],
      },
      {
        'commonName': 'Belgium',
        'officialName': 'Kingdom of Belgium',
        'nativeNames': {
          'deu': {'official': 'K\u00f6nigreich Belgien', 'common': 'Belgien'},
          'fra': {'official': 'Royaume de Belgique', 'common': 'Belgique'},
          'nld': {
            'official': 'Koninkrijk Belgi\u00eb',
            'common': 'Belgi\u00eb',
          },
        },
        'iso2': 'BE',
        'iso3': 'BEL',
        'phoneCode': '+32',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [50.83333333, 4],
        'capital': 'Brussels',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'deu': 'German', 'fra': 'French', 'nld': 'Dutch'},
        'flag': '\ud83c\udde7\ud83c\uddea',
        'borders': ['FRA', 'DEU', 'LUX', 'NLD'],
        'tld': '.be',
        'area': 30528,
        'timezones': ['Europe/Brussels'],
      },
      {
        'commonName': 'Benin',
        'officialName': 'Republic of Benin',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique du B\u00e9nin',
            'common': 'B\u00e9nin',
          },
        },
        'iso2': 'BJ',
        'iso3': 'BEN',
        'phoneCode': '+229',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [9.5, 2.25],
        'capital': 'Porto-Novo',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\udde7\ud83c\uddef',
        'borders': ['BFA', 'NER', 'NGA', 'TGO'],
        'tld': '.bj',
        'area': 112622,
        'timezones': ['Africa/Porto-Novo'],
      },
      {
        'commonName': 'Burkina Faso',
        'officialName': 'Burkina Faso',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique du Burkina',
            'common': 'Burkina Faso',
          },
        },
        'iso2': 'BF',
        'iso3': 'BFA',
        'phoneCode': '+226',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [13, -2],
        'capital': 'Ouagadougou',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\udde7\ud83c\uddeb',
        'borders': ['BEN', 'CIV', 'GHA', 'MLI', 'NER', 'TGO'],
        'tld': '.bf',
        'area': 272967,
        'timezones': ['Africa/Ouagadougou'],
      },
      {
        'commonName': 'Bangladesh',
        'officialName': "People's Republic of Bangladesh",
        'nativeNames': {
          'ben': {
            'official':
                '\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6 \u0997\u09a3\u09aa\u09cd\u09b0\u099c\u09be\u09a4\u09a8\u09cd\u09a4\u09cd\u09b0\u09c0',
            'common': '\u09ac\u09be\u0982\u09b2\u09be\u09a6\u09c7\u09b6',
          },
        },
        'iso2': 'BD',
        'iso3': 'BGD',
        'phoneCode': '+880',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [24, 90],
        'capital': 'Dhaka',
        'currencies': {
          'BDT': {'name': 'Bangladeshi taka', 'symbol': '\u09f3'},
        },
        'languages': {'ben': 'Bengali'},
        'flag': '\ud83c\udde7\ud83c\udde9',
        'borders': ['MMR', 'IND'],
        'tld': '.bd',
        'area': 147570,
        'timezones': ['Asia/Dhaka'],
      },
      {
        'commonName': 'Bulgaria',
        'officialName': 'Republic of Bulgaria',
        'nativeNames': {
          'bul': {
            'official':
                '\u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f',
            'common': '\u0411\u044a\u043b\u0433\u0430\u0440\u0438\u044f',
          },
        },
        'iso2': 'BG',
        'iso3': 'BGR',
        'phoneCode': '+359',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [43, 25],
        'capital': 'Sofia',
        'currencies': {
          'BGN': {'name': 'Bulgarian lev', 'symbol': '\u043b\u0432'},
        },
        'languages': {'bul': 'Bulgarian'},
        'flag': '\ud83c\udde7\ud83c\uddec',
        'borders': ['GRC', 'MKD', 'ROU', 'SRB', 'TUR'],
        'tld': '.bg',
        'area': 110879,
        'timezones': ['Europe/Sofia'],
      },
      {
        'commonName': 'Bahrain',
        'officialName': 'Kingdom of Bahrain',
        'nativeNames': {
          'ara': {
            'official':
                '\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0628\u062d\u0631\u064a\u0646',
            'common': '\u200f\u0627\u0644\u0628\u062d\u0631\u064a\u0646',
          },
        },
        'iso2': 'BH',
        'iso3': 'BHR',
        'phoneCode': '+973',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [26, 50.55],
        'capital': 'Manama',
        'currencies': {
          'BHD': {'name': 'Bahraini dinar', 'symbol': '.\u062f.\u0628'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\udde7\ud83c\udded',
        'borders': <String>[],
        'tld': '.bh',
        'area': 765,
        'timezones': ['Asia/Bahrain'],
      },
      {
        'commonName': 'Bahamas',
        'officialName': 'Commonwealth of the Bahamas',
        'nativeNames': {
          'eng': {
            'official': 'Commonwealth of the Bahamas',
            'common': 'Bahamas',
          },
        },
        'iso2': 'BS',
        'iso3': 'BHS',
        'phoneCode': '+1242',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [24.25, -76],
        'capital': 'Nassau',
        'currencies': {
          'BSD': {'name': 'Bahamian dollar', 'symbol': r'$'},
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde7\ud83c\uddf8',
        'borders': <String>[],
        'tld': '.bs',
        'area': 13943,
        'timezones': ['America/Nassau'],
      },
      {
        'commonName': 'Bosnia and Herzegovina',
        'officialName': 'Bosnia and Herzegovina',
        'nativeNames': {
          'bos': {
            'official': 'Bosna i Hercegovina',
            'common': 'Bosna i Hercegovina',
          },
          'hrv': {
            'official': 'Bosna i Hercegovina',
            'common': 'Bosna i Hercegovina',
          },
          'srp': {
            'official':
                '\u0411\u043e\u0441\u043da \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430',
            'common':
                '\u0411\u043e\u0441\u043da \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430',
          },
        },
        'iso2': 'BA',
        'iso3': 'BIH',
        'phoneCode': '+387',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [44, 18],
        'capital': 'Sarajevo',
        'currencies': {
          'BAM': {
            'name': 'Bosnia and Herzegovina convertible mark',
            'symbol': 'KM',
          },
        },
        'languages': {'bos': 'Bosnian', 'hrv': 'Croatian', 'srp': 'Serbian'},
        'flag': '\ud83c\udde7\ud83c\udde6',
        'borders': ['HRV', 'MNE', 'SRB'],
        'tld': '.ba',
        'area': 51209,
        'timezones': ['Europe/Sarajevo'],
      },
      {
        'commonName': 'Saint Barth\u00e9lemy',
        'officialName': 'Collectivity of Saint Barth\u00e9lemy',
        'nativeNames': {
          'fra': {
            'official': 'Collectivit\u00e9 de Saint-Barth\u00e9lemy',
            'common': 'Saint-Barth\u00e9lemy',
          },
        },
        'iso2': 'BL',
        'iso3': 'BLM',
        'phoneCode': '+590',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.5, -63.41666666],
        'capital': 'Gustavia',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\udde7\ud83c\uddf1',
        'borders': <String>[],
        'tld': '.bl',
        'area': 21,
        'timezones': ['America/St_Barthelemy'],
      },
      {
        'commonName': 'Saint Helena, Ascension and Tristan da Cunha',
        'officialName': 'Saint Helena, Ascension and Tristan da Cunha',
        'nativeNames': {
          'eng': {
            'official': 'Saint Helena, Ascension and Tristan da Cunha',
            'common': 'Saint Helena, Ascension and Tristan da Cunha',
          },
        },
        'iso2': 'SH',
        'iso3': 'SHN',
        'phoneCode': '+290',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [-15.95, -5.72],
        'capital': 'Jamestown',
        'currencies': {
          'GBP': {'name': 'Pound sterling', 'symbol': '\u00a3'},
          'SHP': {'name': 'Saint Helena pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf8\ud83c\udded',
        'borders': <String>[],
        'tld': '.sh',
        'area': 394,
        'timezones': ['Atlantic/St_Helena'],
      },
      {
        'commonName': 'Belarus',
        'officialName': 'Republic of Belarus',
        'nativeNames': {
          'bel': {
            'official':
                '\u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430 \u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c',
            'common': '\u0411\u0435\u043b\u0430\u0440\u0443\u0301\u0441\u044c',
          },
          'rus': {
            'official':
                '\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c',
            'common': '\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c',
          },
        },
        'iso2': 'BY',
        'iso3': 'BLR',
        'phoneCode': '+375',
        'region': 'Europe',
        'subregion': 'Eastern Europe',
        'latlng': [53, 28],
        'capital': 'Minsk',
        'currencies': {
          'BYN': {'name': 'Belarusian ruble', 'symbol': 'Br'},
        },
        'languages': {'bel': 'Belarusian', 'rus': 'Russian'},
        'flag': '\ud83c\udde7\ud83c\uddfe',
        'borders': ['LVA', 'LTU', 'POL', 'RUS', 'UKR'],
        'tld': '.by',
        'area': 207600,
        'timezones': ['Europe/Minsk'],
      },
      {
        'commonName': 'Belize',
        'officialName': 'Belize',
        'nativeNames': {
          'bjz': {'official': 'Belize', 'common': 'Belize'},
          'eng': {'official': 'Belize', 'common': 'Belize'},
          'spa': {'official': 'Belice', 'common': 'Belice'},
        },
        'iso2': 'BZ',
        'iso3': 'BLZ',
        'phoneCode': '+501',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [17.25, -88.75],
        'capital': 'Belmopan',
        'currencies': {
          'BZD': {'name': 'Belize dollar', 'symbol': r'$'},
        },
        'languages': {
          'bjz': 'Belizean Creole',
          'eng': 'English',
          'spa': 'Spanish',
        },
        'flag': '\ud83c\udde7\ud83c\uddff',
        'borders': ['GTM', 'MEX'],
        'tld': '.bz',
        'area': 22966,
        'timezones': ['America/Belize'],
      },
      {
        'commonName': 'Bermuda',
        'officialName': 'Bermuda',
        'nativeNames': {
          'eng': {'official': 'Bermuda', 'common': 'Bermuda'},
        },
        'iso2': 'BM',
        'iso3': 'BMU',
        'phoneCode': '+1441',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [32.33333333, -64.75],
        'capital': 'Hamilton',
        'currencies': {
          'BMD': {'name': 'Bermudian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde7\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.bm',
        'area': 54,
        'timezones': ['Atlantic/Bermuda'],
      },
      {
        'commonName': 'Bolivia',
        'officialName': 'Plurinational State of Bolivia',
        'nativeNames': {
          'aym': {'official': 'Wuliwya Suyu', 'common': 'Wuliwya'},
          'grn': {
            'official': 'Tet\u00e3 Vol\u00edvia',
            'common': 'Vol\u00edvia',
          },
          'que': {'official': 'Buliwya Mamallaqta', 'common': 'Buliwya'},
          'spa': {
            'official': 'Estado Plurinacional de Bolivia',
            'common': 'Bolivia',
          },
        },
        'iso2': 'BO',
        'iso3': 'BOL',
        'phoneCode': '+591',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-17, -65],
        'capital': 'Sucre',
        'currencies': {
          'BOB': {'name': 'Bolivian boliviano', 'symbol': 'Bs.'},
        },
        'languages': {
          'aym': 'Aymara',
          'grn': 'Guaran\u00ed',
          'que': 'Quechua',
          'spa': 'Spanish',
        },
        'flag': '\ud83c\udde7\ud83c\uddf4',
        'borders': ['ARG', 'BRA', 'CHL', 'PRY', 'PER'],
        'tld': '.bo',
        'area': 1098581,
        'timezones': ['America/La_Paz'],
      },
      {
        'commonName': 'Caribbean Netherlands',
        'officialName': 'Bonaire, Sint Eustatius and Saba',
        'nativeNames': {
          'nld': {
            'official': 'Bonaire, Sint Eustatius en Saba',
            'common': 'Caribisch Nederland',
          },
          'pap': {
            'official': 'Boneiru, Sint Eustatius y Saba',
            'common': 'Boneiru, Sint Eustatius y Saba',
          },
        },
        'iso2': 'BQ',
        'iso3': 'BES',
        'phoneCode': '+599',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [12.18, -68.25],
        'capital': 'Kralendijk',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'nld': 'Dutch', 'pap': 'Papiamento'},
        'flag': '',
        'borders': <String>[],
        'tld': '.bq',
        'area': 328,
        'timezones': ['America/Kralendijk'],
      },
      {
        'commonName': 'Brazil',
        'officialName': 'Federative Republic of Brazil',
        'nativeNames': {
          'por': {
            'official': 'Rep\u00fablica Federativa do Brasil',
            'common': 'Brasil',
          },
        },
        'iso2': 'BR',
        'iso3': 'BRA',
        'phoneCode': '+55',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-10, -55],
        'capital': 'Bras\u00edlia',
        'currencies': {
          'BRL': {'name': 'Brazilian real', 'symbol': r'R$'},
        },
        'languages': {'por': 'Portuguese'},
        'flag': '\ud83c\udde7\ud83c\uddf7',
        'borders': [
          'ARG',
          'BOL',
          'COL',
          'GUF',
          'GUY',
          'PRY',
          'PER',
          'SUR',
          'URY',
          'VEN',
        ],
        'tld': '.br',
        'area': 8515767,
        'timezones': [
          'America/Noronha',
          'America/Belem',
          'America/Fortaleza',
          'America/Recife',
          'America/Araguaina',
          'America/Maceio',
          'America/Bahia',
          'America/Sao_Paulo',
          'America/Campo_Grande',
          'America/Cuiaba',
          'America/Santarem',
          'America/Porto_Velho',
          'America/Boa_Vista',
          'America/Manaus',
          'America/Eirunepe',
          'America/Rio_Branco',
        ],
      },
      {
        'commonName': 'Barbados',
        'officialName': 'Barbados',
        'nativeNames': {
          'eng': {'official': 'Barbados', 'common': 'Barbados'},
        },
        'iso2': 'BB',
        'iso3': 'BRB',
        'phoneCode': '+1246',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [13.16666666, -59.53333333],
        'capital': 'Bridgetown',
        'currencies': {
          'BBD': {'name': 'Barbadian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde7\ud83c\udde7',
        'borders': <String>[],
        'tld': '.bb',
        'area': 430,
        'timezones': ['America/Barbados'],
      },
      {
        'commonName': 'Brunei',
        'officialName': 'Nation of Brunei, Abode of Peace',
        'nativeNames': {
          'msa': {
            'official': 'Nation of Brunei, Abode Damai',
            'common': 'Negara Brunei Darussalam',
          },
        },
        'iso2': 'BN',
        'iso3': 'BRN',
        'phoneCode': '+673',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [4.5, 114.66666666],
        'capital': 'Bandar Seri Begawan',
        'currencies': {
          'BND': {'name': 'Brunei dollar', 'symbol': r'$'},
          'SGD': {'name': 'Singapore dollar', 'symbol': r'$'},
        },
        'languages': {'msa': 'Malay'},
        'flag': '\ud83c\udde7\ud83c\uddf3',
        'borders': ['MYS'],
        'tld': '.bn',
        'area': 5765,
        'timezones': ['Asia/Brunei'],
      },
      {
        'commonName': 'Bhutan',
        'officialName': 'Kingdom of Bhutan',
        'nativeNames': {
          'dzo': {
            'official':
                '\u0f60\u0f56\u0fb2\u0f74\u0f42\u0f0b\u0f62\u0f92\u0fb1\u0f63\u0f0b\u0f41\u0f56\u0f0b',
            'common':
                '\u0f60\u0f56\u0fb2\u0f74\u0f42\u0f0b\u0f61\u0f74\u0f63\u0f0b',
          },
        },
        'iso2': 'BT',
        'iso3': 'BTN',
        'phoneCode': '+975',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [27.5, 90.5],
        'capital': 'Thimphu',
        'currencies': {
          'BTN': {'name': 'Bhutanese ngultrum', 'symbol': 'Nu.'},
          'INR': {'name': 'Indian rupee', 'symbol': '\u20b9'},
        },
        'languages': {'dzo': 'Dzongkha'},
        'flag': '\ud83c\udde7\ud83c\uddf9',
        'borders': ['CHN', 'IND'],
        'tld': '.bt',
        'area': 38394,
        'timezones': ['Asia/Thimphu'],
      },
      {
        'commonName': 'Bouvet Island',
        'officialName': 'Bouvet Island',
        'nativeNames': {
          'nor': {'official': 'Bouvet\u00f8ya', 'common': 'Bouvet\u00f8ya'},
        },
        'iso2': 'BV',
        'iso3': 'BVT',
        'phoneCode': '+47',
        'region': 'Antarctic',
        'subregion': '',
        'latlng': [-54.43333333, 3.4],
        'capital': null,
        'currencies': <String, dynamic>{},
        'languages': {'nor': 'Norwegian'},
        'flag': '\ud83c\udde7\ud83c\uddfb',
        'borders': <String>[],
        'tld': '.bv',
        'area': 49,
        'timezones': ['Europe/Oslo'],
      },
      {
        'commonName': 'Botswana',
        'officialName': 'Republic of Botswana',
        'nativeNames': {
          'eng': {'official': 'Republic of Botswana', 'common': 'Botswana'},
          'tsn': {'official': 'Lefatshe la Botswana', 'common': 'Botswana'},
        },
        'iso2': 'BW',
        'iso3': 'BWA',
        'phoneCode': '+267',
        'region': 'Africa',
        'subregion': 'Southern Africa',
        'latlng': [-22, 24],
        'capital': 'Gaborone',
        'currencies': {
          'BWP': {'name': 'Botswana pula', 'symbol': 'P'},
        },
        'languages': {'eng': 'English', 'tsn': 'Tswana'},
        'flag': '\ud83c\udde7\ud83c\uddfc',
        'borders': ['NAM', 'ZAF', 'ZMB', 'ZWE'],
        'tld': '.bw',
        'area': 582000,
        'timezones': ['Africa/Gaborone'],
      },
      {
        'commonName': 'Central African Republic',
        'officialName': 'Central African Republic',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique centrafricaine',
            'common': 'R\u00e9publique centrafricaine',
          },
          'sag': {
            'official':
                'K\u00f6d\u00f6r\u00f6s\u00ease t\u00ee B\u00eaafr\u00eeka',
            'common': 'B\u00eaafr\u00eeka',
          },
        },
        'iso2': 'CF',
        'iso3': 'CAF',
        'phoneCode': '+236',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [7, 21],
        'capital': 'Bangui',
        'currencies': {
          'XAF': {'name': 'Central African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French', 'sag': 'Sango'},
        'flag': '\ud83c\udde8\ud83c\uddeb',
        'borders': ['CMR', 'TCD', 'COD', 'COG', 'SSD', 'SDN'],
        'tld': '.cf',
        'area': 622984,
        'timezones': ['Africa/Bangui'],
      },
      {
        'commonName': 'Canada',
        'officialName': 'Canada',
        'nativeNames': {
          'eng': {'official': 'Canada', 'common': 'Canada'},
          'fra': {'official': 'Canada', 'common': 'Canada'},
        },
        'iso2': 'CA',
        'iso3': 'CAN',
        'phoneCode': '+1',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [60, -95],
        'capital': 'Ottawa',
        'currencies': {
          'CAD': {'name': 'Canadian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'fra': 'French'},
        'flag': '\ud83c\udde8\ud83c\udde6',
        'borders': ['USA'],
        'tld': '.ca',
        'area': 9984670,
        'timezones': [
          'America/St_Johns',
          'America/Halifax',
          'America/Glace_Bay',
          'America/Moncton',
          'America/Goose_Bay',
          'America/Blanc-Sablon',
          'America/Toronto',
          'America/Nipigon',
          'America/Thunder_Bay',
          'America/Iqaluit',
          'America/Pangnirtung',
          'America/Atikokan',
          'America/Winnipeg',
          'America/Rainy_River',
          'America/Resolute',
          'America/Rankin_Inlet',
          'America/Regina',
          'America/Swift_Current',
          'America/Edmonton',
          'America/Cambridge_Bay',
          'America/Yellowknife',
          'America/Inuvik',
          'America/Creston',
          'America/Dawson_Creek',
          'America/Fort_Nelson',
          'America/Vancouver',
          'America/Whitehorse',
          'America/Dawson',
        ],
      },
      {
        'commonName': 'Cocos (Keeling) Islands',
        'officialName': 'Territory of the Cocos (Keeling) Islands',
        'nativeNames': {
          'eng': {
            'official': 'Territory of the Cocos (Keeling) Islands',
            'common': 'Cocos (Keeling) Islands',
          },
        },
        'iso2': 'CC',
        'iso3': 'CCK',
        'phoneCode': '+61',
        'region': 'Oceania',
        'subregion': 'Australia and New Zealand',
        'latlng': [-12.5, 96.83333333],
        'capital': 'West Island',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde8\ud83c\udde8',
        'borders': <String>[],
        'tld': '.cc',
        'area': 14,
        'timezones': ['Indian/Cocos'],
      },
      {
        'commonName': 'Switzerland',
        'officialName': 'Swiss Confederation',
        'nativeNames': {
          'fra': {
            'official': 'Conf\u00e9d\u00e9ration suisse',
            'common': 'Suisse',
          },
          'gsw': {
            'official': 'Schweizerische Eidgenossenschaft',
            'common': 'Schweiz',
          },
          'ita': {'official': 'Confederazione Svizzera', 'common': 'Svizzera'},
          'roh': {'official': 'Confederaziun svizra', 'common': 'Svizra'},
        },
        'iso2': 'CH',
        'iso3': 'CHE',
        'phoneCode': '+41',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [47, 8],
        'capital': 'Bern',
        'currencies': {
          'CHF': {'name': 'Swiss franc', 'symbol': 'Fr.'},
        },
        'languages': {
          'fra': 'French',
          'gsw': 'Swiss German',
          'ita': 'Italian',
          'roh': 'Romansh',
        },
        'flag': '\ud83c\udde8\ud83c\udded',
        'borders': ['AUT', 'FRA', 'ITA', 'LIE', 'DEU'],
        'tld': '.ch',
        'area': 41284,
        'timezones': ['Europe/Zurich'],
      },
      {
        'commonName': 'Chile',
        'officialName': 'Republic of Chile',
        'nativeNames': {
          'spa': {'official': 'Rep\u00fablica de Chile', 'common': 'Chile'},
        },
        'iso2': 'CL',
        'iso3': 'CHL',
        'phoneCode': '+56',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-30, -71],
        'capital': 'Santiago',
        'currencies': {
          'CLP': {'name': 'Chilean peso', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\udde8\ud83c\uddf1',
        'borders': ['ARG', 'BOL', 'PER'],
        'tld': '.cl',
        'area': 756102,
        'timezones': ['America/Santiago', 'Pacific/Easter'],
      },
      {
        'commonName': 'China',
        'officialName': "People's Republic of China",
        'nativeNames': {
          'zho': {
            'official': '\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd',
            'common': '\u4e2d\u56fd',
          },
        },
        'iso2': 'CN',
        'iso3': 'CHN',
        'phoneCode': '+86',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [35, 105],
        'capital': 'Beijing',
        'currencies': {
          'CNY': {'name': 'Chinese yuan', 'symbol': '\u00a5'},
        },
        'languages': {'zho': 'Chinese'},
        'flag': '\ud83c\udde8\ud83c\uddf3',
        'borders': [
          'AFG',
          'BTN',
          'MMR',
          'HKG',
          'IND',
          'KAZ',
          'NPL',
          'PRK',
          'KGZ',
          'LAO',
          'MAC',
          'MNG',
          'PAK',
          'RUS',
          'TJK',
          'VNM',
        ],
        'tld': '.cn',
        'area': 9706961,
        'timezones': ['Asia/Shanghai', 'Asia/Urumqi'],
      },
      {
        'commonName': 'Ivory Coast',
        'officialName': "Republic of C\u00f4te d'Ivoire",
        'nativeNames': {
          'fra': {
            'official': "R\u00e9publique de C\u00f4te d'Ivoire",
            'common': "C\u00f4te d'Ivoire",
          },
        },
        'iso2': 'CI',
        'iso3': 'CIV',
        'phoneCode': '+225',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [8, -5],
        'capital': 'Yamoussoukro',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\udde8\ud83c\uddee',
        'borders': ['BFA', 'GHA', 'GIN', 'LBR', 'MLI'],
        'tld': '.ci',
        'area': 322463,
        'timezones': ['Africa/Abidjan'],
      },
      {
        'commonName': 'Cameroon',
        'officialName': 'Republic of Cameroon',
        'nativeNames': {
          'eng': {'official': 'Republic of Cameroon', 'common': 'Cameroon'},
          'fra': {
            'official': 'R\u00e9publique du Cameroun',
            'common': 'Cameroun',
          },
        },
        'iso2': 'CM',
        'iso3': 'CMR',
        'phoneCode': '+237',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [6, 12],
        'capital': 'Yaound\u00e9',
        'currencies': {
          'XAF': {'name': 'Central African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'eng': 'English', 'fra': 'French'},
        'flag': '\ud83c\udde8\ud83c\uddf2',
        'borders': ['CAF', 'TCD', 'COG', 'GNQ', 'GAB', 'NGA'],
        'tld': '.cm',
        'area': 475442,
        'timezones': ['Africa/Douala'],
      },
      {
        'commonName': 'DR Congo',
        'officialName': 'Democratic Republic of the Congo',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique d\u00e9mocratique du Congo',
            'common': 'RD Congo',
          },
          'kon': {
            'official': 'Repubilika ya Kongo Demokratiki',
            'common': 'Repubilika ya Kongo Demokratiki',
          },
          'lin': {
            'official': 'Republiki ya Kong\u00f3 Demokratiki',
            'common': 'Republiki ya Kong\u00f3 Demokratiki',
          },
          'lua': {
            'official': 'Ditunga dia Kongu wa Mungalaata',
            'common': 'Ditunga dia Kongu wa Mungalaata',
          },
          'swa': {
            'official': 'Jamhuri ya Kidemokrasia ya Kongo',
            'common': 'Jamhuri ya Kidemokrasia ya Kongo',
          },
        },
        'iso2': 'CD',
        'iso3': 'COD',
        'phoneCode': '+243',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [0, 25],
        'capital': 'Kinshasa',
        'currencies': {
          'CDF': {'name': 'Congolese franc', 'symbol': 'FC'},
        },
        'languages': {
          'fra': 'French',
          'kon': 'Kikongo',
          'lin': 'Lingala',
          'lua': 'Tshiluba',
          'swa': 'Swahili',
        },
        'flag': '\ud83c\udde8\ud83c\udde9',
        'borders': [
          'AGO',
          'BDI',
          'CAF',
          'COG',
          'RWA',
          'SSD',
          'TZA',
          'UGA',
          'ZMB',
        ],
        'tld': '.cd',
        'area': 2344858,
        'timezones': ['Africa/Kinshasa', 'Africa/Lubumbashi'],
      },
      {
        'commonName': 'Republic of the Congo',
        'officialName': 'Republic of the Congo',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique du Congo',
            'common': 'R\u00e9publique du Congo',
          },
          'kon': {
            'official': 'Repubilika ya Kongo',
            'common': 'Repubilika ya Kongo',
          },
          'lin': {
            'official': 'Republ\u00edki ya Kong\u00f3',
            'common': 'Republ\u00edki ya Kong\u00f3',
          },
        },
        'iso2': 'CG',
        'iso3': 'COG',
        'phoneCode': '+242',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [-1, 15],
        'capital': 'Brazzaville',
        'currencies': {
          'XAF': {'name': 'Central African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French', 'kon': 'Kikongo', 'lin': 'Lingala'},
        'flag': '\ud83c\udde8\ud83c\uddec',
        'borders': ['AGO', 'CMR', 'CAF', 'COD', 'GAB'],
        'tld': '.cg',
        'area': 342000,
        'timezones': ['Africa/Brazzaville'],
      },
      {
        'commonName': 'Cook Islands',
        'officialName': 'Cook Islands',
        'nativeNames': {
          'eng': {'official': 'Cook Islands', 'common': 'Cook Islands'},
          'rar': {
            'official': "K\u016bki '\u0100irani",
            'common': "K\u016bki '\u0100irani",
          },
        },
        'iso2': 'CK',
        'iso3': 'COK',
        'phoneCode': '+682',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-21.23333333, -159.76666666],
        'capital': 'Avarua',
        'currencies': {
          'CKD': {'name': 'Cook Islands dollar', 'symbol': r'$'},
          'NZD': {'name': 'New Zealand dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'rar': 'Cook Islands M\u0101ori'},
        'flag': '\ud83c\udde8\ud83c\uddf0',
        'borders': <String>[],
        'tld': '.ck',
        'area': 236,
        'timezones': ['Pacific/Rarotonga'],
      },
      {
        'commonName': 'Colombia',
        'officialName': 'Republic of Colombia',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de Colombia',
            'common': 'Colombia',
          },
        },
        'iso2': 'CO',
        'iso3': 'COL',
        'phoneCode': '+57',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [4, -72],
        'capital': 'Bogot\u00e1',
        'currencies': {
          'COP': {'name': 'Colombian peso', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\udde8\ud83c\uddf4',
        'borders': ['BRA', 'ECU', 'PAN', 'PER', 'VEN'],
        'tld': '.co',
        'area': 1141748,
        'timezones': ['America/Bogota'],
      },
      {
        'commonName': 'Comoros',
        'officialName': 'Union of the Comoros',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u0627\u062a\u062d\u0627\u062f \u0627\u0644\u0642\u0645\u0631\u064a',
            'common': '\u0627\u0644\u0642\u0645\u0631\u200e',
          },
          'fra': {'official': 'Union des Comores', 'common': 'Comores'},
          'zdj': {'official': 'Udzima wa Komori', 'common': 'Komori'},
        },
        'iso2': 'KM',
        'iso3': 'COM',
        'phoneCode': '+269',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-12.16666666, 44.25],
        'capital': 'Moroni',
        'currencies': {
          'KMF': {'name': 'Comorian franc', 'symbol': 'Fr'},
        },
        'languages': {'ara': 'Arabic', 'fra': 'French', 'zdj': 'Comorian'},
        'flag': '\ud83c\uddf0\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.km',
        'area': 1862,
        'timezones': ['Indian/Comoro'],
      },
      {
        'commonName': 'Cape Verde',
        'officialName': 'Republic of Cabo Verde',
        'nativeNames': {
          'por': {
            'official': 'Rep\u00fablica de Cabo Verde',
            'common': 'Cabo Verde',
          },
        },
        'iso2': 'CV',
        'iso3': 'CPV',
        'phoneCode': '+238',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [16, -24],
        'capital': 'Praia',
        'currencies': {
          'CVE': {'name': 'Cape Verdean escudo', 'symbol': 'Esc'},
        },
        'languages': {'por': 'Portuguese'},
        'flag': '\ud83c\udde8\ud83c\uddfb',
        'borders': <String>[],
        'tld': '.cv',
        'area': 4033,
        'timezones': ['Atlantic/Cape_Verde'],
      },
      {
        'commonName': 'Costa Rica',
        'officialName': 'Republic of Costa Rica',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de Costa Rica',
            'common': 'Costa Rica',
          },
        },
        'iso2': 'CR',
        'iso3': 'CRI',
        'phoneCode': '+506',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [10, -84],
        'capital': 'San Jos\u00e9',
        'currencies': {
          'CRC': {'name': 'Costa Rican col\u00f3n', 'symbol': '\u20a1'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\udde8\ud83c\uddf7',
        'borders': ['NIC', 'PAN'],
        'tld': '.cr',
        'area': 51100,
        'timezones': ['America/Costa_Rica'],
      },
      {
        'commonName': 'Cuba',
        'officialName': 'Republic of Cuba',
        'nativeNames': {
          'spa': {'official': 'Rep\u00fablica de Cuba', 'common': 'Cuba'},
        },
        'iso2': 'CU',
        'iso3': 'CUB',
        'phoneCode': '+53',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [21.5, -80],
        'capital': 'Havana',
        'currencies': {
          'CUC': {'name': 'Cuban convertible peso', 'symbol': r'$'},
          'CUP': {'name': 'Cuban peso', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\udde8\ud83c\uddfa',
        'borders': <String>[],
        'tld': '.cu',
        'area': 109884,
        'timezones': ['America/Havana'],
      },
      {
        'commonName': 'Cura\u00e7ao',
        'officialName': 'Country of Cura\u00e7ao',
        'nativeNames': {
          'eng': {
            'official': 'Country of Cura\u00e7ao',
            'common': 'Cura\u00e7ao',
          },
          'nld': {'official': 'Land Cura\u00e7ao', 'common': 'Cura\u00e7ao'},
          'pap': {'official': 'Pais K\u00f2rsou', 'common': 'Pais K\u00f2rsou'},
        },
        'iso2': 'CW',
        'iso3': 'CUW',
        'phoneCode': '+599',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [12.116667, -68.933333],
        'capital': 'Willemstad',
        'currencies': {
          'ANG': {'name': 'Netherlands Antillean guilder', 'symbol': '\u0192'},
        },
        'languages': {'eng': 'English', 'nld': 'Dutch', 'pap': 'Papiamento'},
        'flag': '\ud83c\udde8\ud83c\uddfc',
        'borders': <String>[],
        'tld': '.cw',
        'area': 444,
        'timezones': ['America/Curacao'],
      },
      {
        'commonName': 'Christmas Island',
        'officialName': 'Territory of Christmas Island',
        'nativeNames': {
          'eng': {
            'official': 'Territory of Christmas Island',
            'common': 'Christmas Island',
          },
        },
        'iso2': 'CX',
        'iso3': 'CXR',
        'phoneCode': '+61',
        'region': 'Oceania',
        'subregion': 'Australia and New Zealand',
        'latlng': [-10.5, 105.66666666],
        'capital': 'Flying Fish Cove',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde8\ud83c\uddfd',
        'borders': <String>[],
        'tld': '.cx',
        'area': 135,
        'timezones': ['Indian/Christmas'],
      },
      {
        'commonName': 'Cayman Islands',
        'officialName': 'Cayman Islands',
        'nativeNames': {
          'eng': {'official': 'Cayman Islands', 'common': 'Cayman Islands'},
        },
        'iso2': 'KY',
        'iso3': 'CYM',
        'phoneCode': '+1345',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [19.5, -80.5],
        'capital': 'George Town',
        'currencies': {
          'KYD': {'name': 'Cayman Islands dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf0\ud83c\uddfe',
        'borders': <String>[],
        'tld': '.ky',
        'area': 264,
        'timezones': ['America/Cayman'],
      },
      {
        'commonName': 'Cyprus',
        'officialName': 'Republic of Cyprus',
        'nativeNames': {
          'ell': {
            'official':
                '\u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1 \u03c4\u03b7\u03c2 \u039a\u03cd\u03c0\u03c1\u03bf\u03c2',
            'common': '\u039a\u03cd\u03c0\u03c1\u03bf\u03c2',
          },
          'tur': {
            'official': 'K\u0131br\u0131s Cumhuriyeti',
            'common': 'K\u0131br\u0131s',
          },
        },
        'iso2': 'CY',
        'iso3': 'CYP',
        'phoneCode': '+357',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [35, 33],
        'capital': 'Nicosia',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'ell': 'Greek', 'tur': 'Turkish'},
        'flag': '\ud83c\udde8\ud83c\uddfe',
        'borders': <String>[],
        'tld': '.cy',
        'area': 9251,
        'timezones': ['Asia/Nicosia'],
      },
      {
        'commonName': 'Czechia',
        'officialName': 'Czech Republic',
        'nativeNames': {
          'ces': {
            'official': '\u010cesk\u00e1 republika',
            'common': '\u010cesko',
          },
          'slk': {
            'official': '\u010cesk\u00e1 republika',
            'common': '\u010cesko',
          },
        },
        'iso2': 'CZ',
        'iso3': 'CZE',
        'phoneCode': '+420',
        'region': 'Europe',
        'subregion': 'Central Europe',
        'latlng': [49.75, 15.5],
        'capital': 'Prague',
        'currencies': {
          'CZK': {'name': 'Czech koruna', 'symbol': 'K\u010d'},
        },
        'languages': {'ces': 'Czech', 'slk': 'Slovak'},
        'flag': '\ud83c\udde8\ud83c\uddff',
        'borders': ['AUT', 'DEU', 'POL', 'SVK'],
        'tld': '.cz',
        'area': 78865,
        'timezones': ['Europe/Prague'],
      },
      {
        'commonName': 'Germany',
        'officialName': 'Federal Republic of Germany',
        'nativeNames': {
          'deu': {
            'official': 'Bundesrepublik Deutschland',
            'common': 'Deutschland',
          },
        },
        'iso2': 'DE',
        'iso3': 'DEU',
        'phoneCode': '+49',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [51, 9],
        'capital': 'Berlin',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'deu': 'German'},
        'flag': '\ud83c\udde9\ud83c\uddea',
        'borders': [
          'AUT',
          'BEL',
          'CZE',
          'DNK',
          'FRA',
          'LUX',
          'NLD',
          'POL',
          'CHE',
        ],
        'tld': '.de',
        'area': 357114,
        'timezones': ['Europe/Berlin', 'Europe/Busingen'],
      },
      {
        'commonName': 'Djibouti',
        'officialName': 'Republic of Djibouti',
        'nativeNames': {
          'ara': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u062c\u064a\u0628\u0648\u062a\u064a',
            'common': '\u062c\u064a\u0628\u0648\u062a\u064a\u200e',
          },
          'fra': {
            'official': 'R\u00e9publique de Djibouti',
            'common': 'Djibouti',
          },
        },
        'iso2': 'DJ',
        'iso3': 'DJI',
        'phoneCode': '+253',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [11.5, 43],
        'capital': 'Djibouti',
        'currencies': {
          'DJF': {'name': 'Djiboutian franc', 'symbol': 'Fr'},
        },
        'languages': {'ara': 'Arabic', 'fra': 'French'},
        'flag': '\ud83c\udde9\ud83c\uddef',
        'borders': ['ERI', 'ETH', 'SOM'],
        'tld': '.dj',
        'area': 23200,
        'timezones': ['Africa/Djibouti'],
      },
      {
        'commonName': 'Dominica',
        'officialName': 'Commonwealth of Dominica',
        'nativeNames': {
          'eng': {'official': 'Commonwealth of Dominica', 'common': 'Dominica'},
        },
        'iso2': 'DM',
        'iso3': 'DMA',
        'phoneCode': '+1767',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [15.41666666, -61.33333333],
        'capital': 'Roseau',
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udde9\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.dm',
        'area': 751,
        'timezones': ['America/Dominica'],
      },
      {
        'commonName': 'Denmark',
        'officialName': 'Kingdom of Denmark',
        'nativeNames': {
          'dan': {'official': 'Kongeriget Danmark', 'common': 'Danmark'},
        },
        'iso2': 'DK',
        'iso3': 'DNK',
        'phoneCode': '+45',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [56, 10],
        'capital': 'Copenhagen',
        'currencies': {
          'DKK': {'name': 'Danish krone', 'symbol': 'kr'},
        },
        'languages': {'dan': 'Danish'},
        'flag': '\ud83c\udde9\ud83c\uddf0',
        'borders': ['DEU'],
        'tld': '.dk',
        'area': 43094,
        'timezones': ['Europe/Copenhagen'],
      },
      {
        'commonName': 'Dominican Republic',
        'officialName': 'Dominican Republic',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica Dominicana',
            'common': 'Rep\u00fablica Dominicana',
          },
        },
        'iso2': 'DO',
        'iso3': 'DOM',
        'phoneCode': '+1809',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [19, -70.66666666],
        'capital': 'Santo Domingo',
        'currencies': {
          'DOP': {'name': 'Dominican peso', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\udde9\ud83c\uddf4',
        'borders': ['HTI'],
        'tld': '.do',
        'area': 48671,
        'timezones': ['America/Santo_Domingo'],
      },
      {
        'commonName': 'Algeria',
        'officialName': "People's Democratic Republic of Algeria",
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062f\u064a\u0645\u0642\u0631\u0627\u0637\u064a\u0629 \u0627\u0644\u0634\u0639\u0628\u064a\u0629 \u0627\u0644\u062c\u0632\u0627\u0626\u0631\u064a\u0629',
            'common': '\u0627\u0644\u062c\u0632\u0627\u0626\u0631',
          },
        },
        'iso2': 'DZ',
        'iso3': 'DZA',
        'phoneCode': '+213',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [28, 3],
        'capital': 'Algiers',
        'currencies': {
          'DZD': {'name': 'Algerian dinar', 'symbol': '\u062f.\u062c'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\udde9\ud83c\uddff',
        'borders': ['TUN', 'LBY', 'NER', 'ESH', 'MRT', 'MLI', 'MAR'],
        'tld': '.dz',
        'area': 2381741,
        'timezones': ['Africa/Algiers'],
      },
      {
        'commonName': 'Ecuador',
        'officialName': 'Republic of Ecuador',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica del Ecuador',
            'common': 'Ecuador',
          },
        },
        'iso2': 'EC',
        'iso3': 'ECU',
        'phoneCode': '+593',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-2, -77.5],
        'capital': 'Quito',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddea\ud83c\udde8',
        'borders': ['COL', 'PER'],
        'tld': '.ec',
        'area': 276841,
        'timezones': ['America/Guayaquil', 'Pacific/Galapagos'],
      },
      {
        'commonName': 'Egypt',
        'officialName': 'Arab Republic of Egypt',
        'nativeNames': {
          'ara': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0645\u0635\u0631 \u0627\u0644\u0639\u0631\u0628\u064a\u0629',
            'common': '\u0645\u0635\u0631',
          },
        },
        'iso2': 'EG',
        'iso3': 'EGY',
        'phoneCode': '+20',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [27, 30],
        'capital': 'Cairo',
        'currencies': {
          'EGP': {'name': 'Egyptian pound', 'symbol': '\u00a3'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddea\ud83c\uddec',
        'borders': ['ISR', 'LBY', 'PSE', 'SDN'],
        'tld': '.eg',
        'area': 1002450,
        'timezones': ['Africa/Cairo'],
      },
      {
        'commonName': 'Eritrea',
        'officialName': 'State of Eritrea',
        'nativeNames': {
          'ara': {
            'official':
                '\u062f\u0648\u0644\u0629 \u0625\u0631\u062a\u0631\u064a\u0627',
            'common': '\u0625\u0631\u062a\u0631\u064a\u0627\u200e',
          },
          'eng': {'official': 'State of Eritrea', 'common': 'Eritrea'},
          'tir': {
            'official': '\u1203\u1308\u1228 \u12a4\u122d\u1275\u122b',
            'common': '\u12a4\u122d\u1275\u122b',
          },
        },
        'iso2': 'ER',
        'iso3': 'ERI',
        'phoneCode': '+291',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [15, 39],
        'capital': 'Asmara',
        'currencies': {
          'ERN': {'name': 'Eritrean nakfa', 'symbol': 'Nfk'},
        },
        'languages': {'ara': 'Arabic', 'eng': 'English', 'tir': 'Tigrinya'},
        'flag': '\ud83c\uddea\ud83c\uddf7',
        'borders': ['DJI', 'ETH', 'SDN'],
        'tld': '.er',
        'area': 117600,
        'timezones': ['Africa/Asmara'],
      },
      {
        'commonName': 'Western Sahara',
        'officialName': 'Sahrawi Arab Democratic Republic',
        'nativeNames': {
          'ber': {
            'official': 'Sahrawi Arab Democratic Republic',
            'common': 'Western Sahara',
          },
          'mey': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0635\u062d\u0631\u0627\u0648\u064a\u0629 \u0627\u0644\u062f\u064a\u0645\u0642\u0631\u0627\u0637\u064a\u0629',
            'common':
                '\u0627\u0644\u0635\u062d\u0631\u0627\u0621 \u0627\u0644\u063a\u0631\u0628\u064a\u0629',
          },
          'spa': {
            'official': 'Rep\u00fablica \u00c1rabe Saharaui Democr\u00e1tica',
            'common': 'Sahara Occidental',
          },
        },
        'iso2': 'EH',
        'iso3': 'ESH',
        'phoneCode': '+212',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [24.5, -13],
        'capital': 'El Aai\u00fan',
        'currencies': {
          'DZD': {'name': 'Algerian dinar', 'symbol': '\u062f\u062c'},
          'MAD': {'name': 'Moroccan dirham', 'symbol': 'DH'},
          'MRU': {'name': 'Mauritanian ouguiya', 'symbol': 'UM'},
        },
        'languages': {'ber': 'Berber', 'mey': 'Hassaniya', 'spa': 'Spanish'},
        'flag': '\ud83c\uddea\ud83c\udded',
        'borders': ['DZA', 'MRT', 'MAR'],
        'tld': '.eh',
        'area': 266000,
        'timezones': ['Africa/El_Aaiun'],
      },
      {
        'commonName': 'Spain',
        'officialName': 'Kingdom of Spain',
        'nativeNames': {
          'spa': {'official': 'Reino de Espa\u00f1a', 'common': 'Espa\u00f1a'},
        },
        'iso2': 'ES',
        'iso3': 'ESP',
        'phoneCode': '+34',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [40, -4],
        'capital': 'Madrid',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddea\ud83c\uddf8',
        'borders': ['AND', 'FRA', 'GIB', 'PRT', 'MAR'],
        'tld': '.es',
        'area': 505992,
        'timezones': ['Europe/Madrid', 'Africa/Ceuta', 'Atlantic/Canary'],
      },
      {
        'commonName': 'Estonia',
        'officialName': 'Republic of Estonia',
        'nativeNames': {
          'est': {'official': 'Eesti Vabariik', 'common': 'Eesti'},
        },
        'iso2': 'EE',
        'iso3': 'EST',
        'phoneCode': '+372',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [59, 26],
        'capital': 'Tallinn',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'est': 'Estonian'},
        'flag': '\ud83c\uddea\ud83c\uddea',
        'borders': ['LVA', 'RUS'],
        'tld': '.ee',
        'area': 45227,
        'timezones': ['Europe/Tallinn'],
      },
      {
        'commonName': 'Ethiopia',
        'officialName': 'Federal Democratic Republic of Ethiopia',
        'nativeNames': {
          'amh': {
            'official':
                '\u12e8\u12a2\u1275\u12ee\u1335\u12eb \u134c\u12f4\u122b\u120b\u12ca \u12f2\u121e\u12ad\u122b\u1232\u12eb\u12ca \u122a\u1350\u1265\u120a\u12ad',
            'common': '\u12a2\u1275\u12ee\u1335\u12eb',
          },
        },
        'iso2': 'ET',
        'iso3': 'ETH',
        'phoneCode': '+251',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [8, 38],
        'capital': 'Addis Ababa',
        'currencies': {
          'ETB': {'name': 'Ethiopian birr', 'symbol': 'Br'},
        },
        'languages': {'amh': 'Amharic'},
        'flag': '\ud83c\uddea\ud83c\uddf9',
        'borders': ['DJI', 'ERI', 'KEN', 'SOM', 'SSD', 'SDN'],
        'tld': '.et',
        'area': 1104300,
        'timezones': ['Africa/Addis_Ababa'],
      },
      {
        'commonName': 'Finland',
        'officialName': 'Republic of Finland',
        'nativeNames': {
          'fin': {'official': 'Suomen tasavalta', 'common': 'Suomi'},
          'swe': {'official': 'Republiken Finland', 'common': 'Finland'},
        },
        'iso2': 'FI',
        'iso3': 'FIN',
        'phoneCode': '+358',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [64, 26],
        'capital': 'Helsinki',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fin': 'Finnish', 'swe': 'Swedish'},
        'flag': '\ud83c\uddeb\ud83c\uddee',
        'borders': ['NOR', 'SWE', 'RUS'],
        'tld': '.fi',
        'area': 338424,
        'timezones': ['Europe/Helsinki'],
      },
      {
        'commonName': 'Fiji',
        'officialName': 'Republic of Fiji',
        'nativeNames': {
          'eng': {'official': 'Republic of Fiji', 'common': 'Fiji'},
          'fij': {'official': 'Matanitu Tugalala o Viti', 'common': 'Viti'},
          'hif': {
            'official':
                '\u0930\u093f\u092a\u092c\u094d\u0932\u093f\u0915 \u0911\u092b \u092b\u0940\u091c\u0940',
            'common': '\u092b\u093f\u091c\u0940',
          },
        },
        'iso2': 'FJ',
        'iso3': 'FJI',
        'phoneCode': '+679',
        'region': 'Oceania',
        'subregion': 'Melanesia',
        'latlng': [-18, 175],
        'capital': 'Suva',
        'currencies': {
          'FJD': {'name': 'Fijian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'fij': 'Fijian', 'hif': 'Fiji Hindi'},
        'flag': '\ud83c\uddeb\ud83c\uddef',
        'borders': <String>[],
        'tld': '.fj',
        'area': 18272,
        'timezones': ['Pacific/Fiji'],
      },
      {
        'commonName': 'Falkland Islands',
        'officialName': 'Falkland Islands',
        'nativeNames': {
          'eng': {'official': 'Falkland Islands', 'common': 'Falkland Islands'},
        },
        'iso2': 'FK',
        'iso3': 'FLK',
        'phoneCode': '+500',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-51.75, -59],
        'capital': 'Stanley',
        'currencies': {
          'FKP': {'name': 'Falkland Islands pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddeb\ud83c\uddf0',
        'borders': <String>[],
        'tld': '.fk',
        'area': 12173,
        'timezones': ['Atlantic/Stanley'],
      },
      {
        'commonName': 'France',
        'officialName': 'French Republic',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique fran\u00e7aise',
            'common': 'France',
          },
        },
        'iso2': 'FR',
        'iso3': 'FRA',
        'phoneCode': '+33',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [46, 2],
        'capital': 'Paris',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddeb\ud83c\uddf7',
        'borders': ['AND', 'BEL', 'DEU', 'ITA', 'LUX', 'MCO', 'ESP', 'CHE'],
        'tld': '.fr',
        'area': 551695,
        'timezones': ['Europe/Paris'],
      },
      {
        'commonName': 'Faroe Islands',
        'officialName': 'Faroe Islands',
        'nativeNames': {
          'dan': {
            'official': 'F\u00e6r\u00f8erne',
            'common': 'F\u00e6r\u00f8erne',
          },
          'fao': {'official': 'F\u00f8royar', 'common': 'F\u00f8royar'},
        },
        'iso2': 'FO',
        'iso3': 'FRO',
        'phoneCode': '+298',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [62, -7],
        'capital': 'T\u00f3rshavn',
        'currencies': {
          'DKK': {'name': 'Danish krone', 'symbol': 'kr'},
          'FOK': {'name': 'Faroese kr\u00f3na', 'symbol': 'kr'},
        },
        'languages': {'dan': 'Danish', 'fao': 'Faroese'},
        'flag': '\ud83c\uddeb\ud83c\uddf4',
        'borders': <String>[],
        'tld': '.fo',
        'area': 1393,
        'timezones': ['Atlantic/Faroe'],
      },
      {
        'commonName': 'Micronesia',
        'officialName': 'Federated States of Micronesia',
        'nativeNames': {
          'eng': {
            'official': 'Federated States of Micronesia',
            'common': 'Micronesia',
          },
        },
        'iso2': 'FM',
        'iso3': 'FSM',
        'phoneCode': '+691',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [6.91666666, 158.25],
        'capital': 'Palikir',
        'currencies': <String, dynamic>{},
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddeb\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.fm',
        'area': 702,
        'timezones': ['Pacific/Chuuk', 'Pacific/Pohnpei', 'Pacific/Kosrae'],
      },
      {
        'commonName': 'Gabon',
        'officialName': 'Gabonese Republic',
        'nativeNames': {
          'fra': {'official': 'R\u00e9publique gabonaise', 'common': 'Gabon'},
        },
        'iso2': 'GA',
        'iso3': 'GAB',
        'phoneCode': '+241',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [-1, 11.75],
        'capital': 'Libreville',
        'currencies': {
          'XAF': {'name': 'Central African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddec\ud83c\udde6',
        'borders': ['CMR', 'COG', 'GNQ'],
        'tld': '.ga',
        'area': 267668,
        'timezones': ['Africa/Libreville'],
      },
      {
        'commonName': 'United Kingdom',
        'officialName': 'United Kingdom of Great Britain and Northern Ireland',
        'nativeNames': {
          'eng': {
            'official': 'United Kingdom of Great Britain and Northern Ireland',
            'common': 'United Kingdom',
          },
        },
        'iso2': 'GB',
        'iso3': 'GBR',
        'phoneCode': '+44',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [54, -2],
        'capital': 'London',
        'currencies': {
          'GBP': {'name': 'British pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\udde7',
        'borders': ['IRL'],
        'tld': '.uk',
        'area': 242900,
        'timezones': ['Europe/London'],
      },
      {
        'commonName': 'Georgia',
        'officialName': 'Georgia',
        'nativeNames': {
          'kat': {
            'official':
                '\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd',
            'common':
                '\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd',
          },
        },
        'iso2': 'GE',
        'iso3': 'GEO',
        'phoneCode': '+995',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [42, 43.5],
        'capital': 'Tbilisi',
        'currencies': {
          'GEL': {'name': 'lari', 'symbol': '\u20be'},
        },
        'languages': {'kat': 'Georgian'},
        'flag': '\ud83c\uddec\ud83c\uddea',
        'borders': ['ARM', 'AZE', 'RUS', 'TUR'],
        'tld': '.ge',
        'area': 69700,
        'timezones': ['Asia/Tbilisi'],
      },
      {
        'commonName': 'Guernsey',
        'officialName': 'Bailiwick of Guernsey',
        'nativeNames': {
          'eng': {'official': 'Bailiwick of Guernsey', 'common': 'Guernsey'},
          'fra': {'official': 'Bailliage de Guernesey', 'common': 'Guernesey'},
          'nfr': {
            'official': 'Dg\u00e8rn\u00e9siais',
            'common': 'Dg\u00e8rn\u00e9siais',
          },
        },
        'iso2': 'GG',
        'iso3': 'GGY',
        'phoneCode': '+44',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [49.46666666, -2.58333333],
        'capital': 'St. Peter Port',
        'currencies': {
          'GBP': {'name': 'British pound', 'symbol': '\u00a3'},
          'GGP': {'name': 'Guernsey pound', 'symbol': '\u00a3'},
        },
        'languages': {
          'eng': 'English',
          'fra': 'French',
          'nfr': 'Guern\u00e9siais',
        },
        'flag': '\ud83c\uddec\ud83c\uddec',
        'borders': <String>[],
        'tld': '.gg',
        'area': 78,
        'timezones': ['Europe/Guernsey'],
      },
      {
        'commonName': 'Ghana',
        'officialName': 'Republic of Ghana',
        'nativeNames': {
          'eng': {'official': 'Republic of Ghana', 'common': 'Ghana'},
        },
        'iso2': 'GH',
        'iso3': 'GHA',
        'phoneCode': '+233',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [8, -2],
        'capital': 'Accra',
        'currencies': {
          'GHS': {'name': 'Ghanaian cedi', 'symbol': '\u20b5'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\udded',
        'borders': ['BFA', 'CIV', 'TGO'],
        'tld': '.gh',
        'area': 238533,
        'timezones': ['Africa/Accra'],
      },
      {
        'commonName': 'Gibraltar',
        'officialName': 'Gibraltar',
        'nativeNames': {
          'eng': {'official': 'Gibraltar', 'common': 'Gibraltar'},
        },
        'iso2': 'GI',
        'iso3': 'GIB',
        'phoneCode': '+350',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [36.13333333, -5.35],
        'capital': 'Gibraltar',
        'currencies': {
          'GIP': {'name': 'Gibraltar pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\uddee',
        'borders': ['ESP'],
        'tld': '.gi',
        'area': 6,
        'timezones': ['Europe/Gibraltar'],
      },
      {
        'commonName': 'Guinea',
        'officialName': 'Republic of Guinea',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique de Guin\u00e9e',
            'common': 'Guin\u00e9e',
          },
        },
        'iso2': 'GN',
        'iso3': 'GIN',
        'phoneCode': '+224',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [11, -10],
        'capital': 'Conakry',
        'currencies': {
          'GNF': {'name': 'Guinean franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddec\ud83c\uddf3',
        'borders': ['CIV', 'GNB', 'LBR', 'MLI', 'SEN', 'SLE'],
        'tld': '.gn',
        'area': 245857,
        'timezones': ['Africa/Conakry'],
      },
      {
        'commonName': 'Guadeloupe',
        'officialName': 'Guadeloupe',
        'nativeNames': {
          'fra': {'official': 'Guadeloupe', 'common': 'Guadeloupe'},
        },
        'iso2': 'GP',
        'iso3': 'GLP',
        'phoneCode': '+590',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [16.25, -61.583333],
        'capital': 'Basse-Terre',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddec\ud83c\uddf5',
        'borders': <String>[],
        'tld': '.gp',
        'area': 1628,
        'timezones': ['America/Guadeloupe'],
      },
      {
        'commonName': 'Gambia',
        'officialName': 'Republic of the Gambia',
        'nativeNames': {
          'eng': {'official': 'Republic of the Gambia', 'common': 'Gambia'},
        },
        'iso2': 'GM',
        'iso3': 'GMB',
        'phoneCode': '+220',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [13.46666666, -16.56666666],
        'capital': 'Banjul',
        'currencies': {
          'GMD': {'name': 'dalasi', 'symbol': 'D'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\uddf2',
        'borders': ['SEN'],
        'tld': '.gm',
        'area': 10689,
        'timezones': ['Africa/Banjul'],
      },
      {
        'commonName': 'Guinea-Bissau',
        'officialName': 'Republic of Guinea-Bissau',
        'nativeNames': {
          'por': {
            'official': 'Rep\u00fablica da Guin\u00e9-Bissau',
            'common': 'Guin\u00e9-Bissau',
          },
          'pov': {
            'official': 'Rep\u00fablica da Guin\u00e9-Bissau',
            'common': 'Guin\u00e9-Bissau',
          },
        },
        'iso2': 'GW',
        'iso3': 'GNB',
        'phoneCode': '+245',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [12, -15],
        'capital': 'Bissau',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'por': 'Portuguese', 'pov': 'Upper Guinea Creole'},
        'flag': '\ud83c\uddec\ud83c\uddfc',
        'borders': ['GIN', 'SEN'],
        'tld': '.gw',
        'area': 36125,
        'timezones': ['Africa/Bissau'],
      },
      {
        'commonName': 'Equatorial Guinea',
        'officialName': 'Republic of Equatorial Guinea',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique de la Guin\u00e9e \u00c9quatoriale',
            'common': 'Guin\u00e9e \u00e9quatoriale',
          },
          'por': {
            'official': 'Rep\u00fablica da Guin\u00e9 Equatorial',
            'common': 'Guin\u00e9 Equatorial',
          },
          'spa': {
            'official': 'Rep\u00fablica de Guinea Ecuatorial',
            'common': 'Guinea Ecuatorial',
          },
        },
        'iso2': 'GQ',
        'iso3': 'GNQ',
        'phoneCode': '+240',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [2, 10],
        'capital': 'Malabo',
        'currencies': {
          'XAF': {'name': 'Central African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French', 'por': 'Portuguese', 'spa': 'Spanish'},
        'flag': '\ud83c\uddec\ud83c\uddf6',
        'borders': ['CMR', 'GAB'],
        'tld': '.gq',
        'area': 28051,
        'timezones': ['Africa/Malabo'],
      },
      {
        'commonName': 'Greece',
        'officialName': 'Hellenic Republic',
        'nativeNames': {
          'ell': {
            'official':
                '\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ae \u0394\u03b7\u03bc\u03bf\u03ba\u03c1\u03b1\u03c4\u03af\u03b1',
            'common': '\u0395\u03bb\u03bb\u03ac\u03b4\u03b1',
          },
        },
        'iso2': 'GR',
        'iso3': 'GRC',
        'phoneCode': '+30',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [39, 22],
        'capital': 'Athens',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'ell': 'Greek'},
        'flag': '\ud83c\uddec\ud83c\uddf7',
        'borders': ['ALB', 'BGR', 'TUR', 'MKD'],
        'tld': '.gr',
        'area': 131990,
        'timezones': ['Europe/Athens'],
      },
      {
        'commonName': 'Grenada',
        'officialName': 'Grenada',
        'nativeNames': {
          'eng': {'official': 'Grenada', 'common': 'Grenada'},
        },
        'iso2': 'GD',
        'iso3': 'GRD',
        'phoneCode': '+1473',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [12.11666666, -61.66666666],
        'capital': "St. George's",
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\udde9',
        'borders': <String>[],
        'tld': '.gd',
        'area': 344,
        'timezones': ['America/Grenada'],
      },
      {
        'commonName': 'Greenland',
        'officialName': 'Greenland',
        'nativeNames': {
          'kal': {'official': 'Kalaallit Nunaat', 'common': 'Kalaallit Nunaat'},
        },
        'iso2': 'GL',
        'iso3': 'GRL',
        'phoneCode': '+299',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [72, -40],
        'capital': 'Nuuk',
        'currencies': {
          'DKK': {'name': 'krone', 'symbol': 'kr.'},
        },
        'languages': {'kal': 'Greenlandic'},
        'flag': '\ud83c\uddec\ud83c\uddf1',
        'borders': <String>[],
        'tld': '.gl',
        'area': 2166086,
        'timezones': [
          'America/Godthab',
          'America/Danmarkshavn',
          'America/Scoresbysund',
          'America/Thule',
        ],
      },
      {
        'commonName': 'Guatemala',
        'officialName': 'Republic of Guatemala',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de Guatemala',
            'common': 'Guatemala',
          },
        },
        'iso2': 'GT',
        'iso3': 'GTM',
        'phoneCode': '+502',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [15.5, -90.25],
        'capital': 'Guatemala City',
        'currencies': {
          'GTQ': {'name': 'Guatemalan quetzal', 'symbol': 'Q'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddec\ud83c\uddf9',
        'borders': ['BLZ', 'SLV', 'HND', 'MEX'],
        'tld': '.gt',
        'area': 108889,
        'timezones': ['America/Guatemala'],
      },
      {
        'commonName': 'French Guiana',
        'officialName': 'Guiana',
        'nativeNames': {
          'fra': {'official': 'Guyane', 'common': 'Guyane fran\u00e7aise'},
        },
        'iso2': 'GF',
        'iso3': 'GUF',
        'phoneCode': '+594',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [4, -53],
        'capital': 'Cayenne',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddec\ud83c\uddeb',
        'borders': ['BRA', 'SUR'],
        'tld': '.gf',
        'area': 83534,
        'timezones': ['America/Cayenne'],
      },
      {
        'commonName': 'Guam',
        'officialName': 'Guam',
        'nativeNames': {
          'cha': {'official': 'Gu\u00e5h\u00e5n', 'common': 'Gu\u00e5h\u00e5n'},
          'eng': {'official': 'Guam', 'common': 'Guam'},
          'spa': {'official': 'Guam', 'common': 'Guam'},
        },
        'iso2': 'GU',
        'iso3': 'GUM',
        'phoneCode': '+1671',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [13.46666666, 144.78333333],
        'capital': 'Hag\u00e5t\u00f1a',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'cha': 'Chamorro', 'eng': 'English', 'spa': 'Spanish'},
        'flag': '\ud83c\uddec\ud83c\uddfa',
        'borders': <String>[],
        'tld': '.gu',
        'area': 549,
        'timezones': ['Pacific/Guam'],
      },
      {
        'commonName': 'Guyana',
        'officialName': 'Co-operative Republic of Guyana',
        'nativeNames': {
          'eng': {
            'official': 'Co-operative Republic of Guyana',
            'common': 'Guyana',
          },
        },
        'iso2': 'GY',
        'iso3': 'GUY',
        'phoneCode': '+592',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [5, -59],
        'capital': 'Georgetown',
        'currencies': {
          'GYD': {'name': 'Guyanese dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\uddfe',
        'borders': ['BRA', 'SUR', 'VEN'],
        'tld': '.gy',
        'area': 214969,
        'timezones': ['America/Guyana'],
      },
      {
        'commonName': 'Hong Kong',
        'officialName':
            "Hong Kong Special Administrative Region of the People's Republic of China",
        'nativeNames': {
          'eng': {
            'official':
                "Hong Kong Special Administrative Region of the People's Republic of China",
            'common': 'Hong Kong',
          },
          'zho': {
            'official':
                '\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a',
            'common': '\u9999\u6e2f',
          },
        },
        'iso2': 'HK',
        'iso3': 'HKG',
        'phoneCode': '+852',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [22.267, 114.188],
        'capital': 'City of Victoria',
        'currencies': {
          'HKD': {'name': 'Hong Kong dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'zho': 'Chinese'},
        'flag': '\ud83c\udded\ud83c\uddf0',
        'borders': ['CHN'],
        'tld': '.hk',
        'area': 1104,
        'timezones': ['Asia/Hong_Kong'],
      },
      {
        'commonName': 'Heard Island and McDonald Islands',
        'officialName': 'Heard Island and McDonald Islands',
        'nativeNames': {
          'eng': {
            'official': 'Heard Island and McDonald Islands',
            'common': 'Heard Island and McDonald Islands',
          },
        },
        'iso2': 'HM',
        'iso3': 'HMD',
        'phoneCode': '+672',
        'region': 'Antarctic',
        'subregion': '',
        'latlng': [-53.1, 72.51666666],
        'capital': null,
        'currencies': <String, dynamic>{},
        'languages': {'eng': 'English'},
        'flag': '\ud83c\udded\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.hm',
        'area': 412,
        'timezones': ['Indian/Kerguelen'],
      },
      {
        'commonName': 'Honduras',
        'officialName': 'Republic of Honduras',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de Honduras',
            'common': 'Honduras',
          },
        },
        'iso2': 'HN',
        'iso3': 'HND',
        'phoneCode': '+504',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [15, -86.5],
        'capital': 'Tegucigalpa',
        'currencies': {
          'HNL': {'name': 'Honduran lempira', 'symbol': 'L'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\udded\ud83c\uddf3',
        'borders': ['GTM', 'SLV', 'NIC'],
        'tld': '.hn',
        'area': 112492,
        'timezones': ['America/Tegucigalpa'],
      },
      {
        'commonName': 'Croatia',
        'officialName': 'Republic of Croatia',
        'nativeNames': {
          'hrv': {'official': 'Republika Hrvatska', 'common': 'Hrvatska'},
        },
        'iso2': 'HR',
        'iso3': 'HRV',
        'phoneCode': '+385',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [45.16666666, 15.5],
        'capital': 'Zagreb',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'hrv': 'Croatian'},
        'flag': '\ud83c\udded\ud83c\uddf7',
        'borders': ['BIH', 'HUN', 'MNE', 'SRB', 'SVN'],
        'tld': '.hr',
        'area': 56594,
        'timezones': ['Europe/Zagreb'],
      },
      {
        'commonName': 'Haiti',
        'officialName': 'Republic of Haiti',
        'nativeNames': {
          'fra': {
            'official': "R\u00e9publique d'Ha\u00efti",
            'common': 'Ha\u00efti',
          },
          'hat': {'official': 'Repiblik Ayiti', 'common': 'Ayiti'},
        },
        'iso2': 'HT',
        'iso3': 'HTI',
        'phoneCode': '+509',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [19, -72.41666666],
        'capital': 'Port-au-Prince',
        'currencies': {
          'HTG': {'name': 'Haitian gourde', 'symbol': 'G'},
        },
        'languages': {'fra': 'French', 'hat': 'Haitian Creole'},
        'flag': '\ud83c\udded\ud83c\uddf9',
        'borders': ['DOM'],
        'tld': '.ht',
        'area': 27750,
        'timezones': ['America/Port-au-Prince'],
      },
      {
        'commonName': 'Hungary',
        'officialName': 'Hungary',
        'nativeNames': {
          'hun': {
            'official': 'Magyarorsz\u00e1g',
            'common': 'Magyarorsz\u00e1g',
          },
        },
        'iso2': 'HU',
        'iso3': 'HUN',
        'phoneCode': '+36',
        'region': 'Europe',
        'subregion': 'Central Europe',
        'latlng': [47, 20],
        'capital': 'Budapest',
        'currencies': {
          'HUF': {'name': 'Hungarian forint', 'symbol': 'Ft'},
        },
        'languages': {'hun': 'Hungarian'},
        'flag': '\ud83c\udded\ud83c\uddfa',
        'borders': ['AUT', 'HRV', 'ROU', 'SRB', 'SVK', 'SVN', 'UKR'],
        'tld': '.hu',
        'area': 93028,
        'timezones': ['Europe/Budapest'],
      },
      {
        'commonName': 'Indonesia',
        'officialName': 'Republic of Indonesia',
        'nativeNames': {
          'ind': {'official': 'Republik Indonesia', 'common': 'Indonesia'},
        },
        'iso2': 'ID',
        'iso3': 'IDN',
        'phoneCode': '+62',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [-5, 120],
        'capital': 'Jakarta',
        'currencies': {
          'IDR': {'name': 'Indonesian rupiah', 'symbol': 'Rp'},
        },
        'languages': {'ind': 'Indonesian'},
        'flag': '\ud83c\uddee\ud83c\udde9',
        'borders': ['TLS', 'MYS', 'PNG'],
        'tld': '.id',
        'area': 1904569,
        'timezones': [
          'Asia/Jakarta',
          'Asia/Pontianak',
          'Asia/Makassar',
          'Asia/Jayapura',
        ],
      },
      {
        'commonName': 'Isle of Man',
        'officialName': 'Isle of Man',
        'nativeNames': {
          'eng': {'official': 'Isle of Man', 'common': 'Isle of Man'},
          'glv': {'official': 'Ellan Vannin or Mannin', 'common': 'Mannin'},
        },
        'iso2': 'IM',
        'iso3': 'IMN',
        'phoneCode': '+44',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [54.25, -4.5],
        'capital': 'Douglas',
        'currencies': {
          'GBP': {'name': 'British pound', 'symbol': '\u00a3'},
          'IMP': {'name': 'Manx pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English', 'glv': 'Manx'},
        'flag': '\ud83c\uddee\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.im',
        'area': 572,
        'timezones': ['Europe/Isle_of_Man'],
      },
      {
        'commonName': 'India',
        'officialName': 'Republic of India',
        'nativeNames': {
          'eng': {'official': 'Republic of India', 'common': 'India'},
          'hin': {
            'official':
                '\u092d\u093e\u0930\u0924 \u0917\u0923\u0930\u093e\u091c\u094d\u092f',
            'common': '\u092d\u093e\u0930\u0924',
          },
          'tam': {
            'official':
                '\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1',
            'common': '\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0bbe',
          },
        },
        'iso2': 'IN',
        'iso3': 'IND',
        'phoneCode': '+91',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [20, 77],
        'capital': 'New Delhi',
        'currencies': {
          'INR': {'name': 'Indian rupee', 'symbol': '\u20b9'},
        },
        'languages': {'eng': 'English', 'hin': 'Hindi', 'tam': 'Tamil'},
        'flag': '\ud83c\uddee\ud83c\uddf3',
        'borders': ['BGD', 'BTN', 'MMR', 'CHN', 'NPL', 'PAK'],
        'tld': '.in',
        'area': 3287590,
        'timezones': ['Asia/Kolkata'],
      },
      {
        'commonName': 'British Indian Ocean Territory',
        'officialName': 'British Indian Ocean Territory',
        'nativeNames': {
          'eng': {
            'official': 'British Indian Ocean Territory',
            'common': 'British Indian Ocean Territory',
          },
        },
        'iso2': 'IO',
        'iso3': 'IOT',
        'phoneCode': '+246',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-6, 71.5],
        'capital': 'Diego Garcia',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddee\ud83c\uddf4',
        'borders': <String>[],
        'tld': '.io',
        'area': 60,
        'timezones': ['Indian/Chagos'],
      },
      {
        'commonName': 'Ireland',
        'officialName': 'Republic of Ireland',
        'nativeNames': {
          'eng': {'official': 'Republic of Ireland', 'common': 'Ireland'},
          'gle': {
            'official': 'Poblacht na h\u00c9ireann',
            'common': '\u00c9ire',
          },
        },
        'iso2': 'IE',
        'iso3': 'IRL',
        'phoneCode': '+353',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [53, -8],
        'capital': 'Dublin',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'eng': 'English', 'gle': 'Irish'},
        'flag': '\ud83c\uddee\ud83c\uddea',
        'borders': ['GBR'],
        'tld': '.ie',
        'area': 70273,
        'timezones': ['Europe/Dublin'],
      },
      {
        'commonName': 'Iran',
        'officialName': 'Islamic Republic of Iran',
        'nativeNames': {
          'fas': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u06cc \u0627\u0633\u0644\u0627\u0645\u06cc \u0627\u06cc\u0631\u0627\u0646',
            'common': '\u0627\u06cc\u0631\u0627\u0646',
          },
        },
        'iso2': 'IR',
        'iso3': 'IRN',
        'phoneCode': '+98',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [32, 53],
        'capital': 'Tehran',
        'currencies': {
          'IRR': {'name': 'Iranian rial', 'symbol': '\ufdfc'},
        },
        'languages': {'fas': 'Persian (Farsi)'},
        'flag': '\ud83c\uddee\ud83c\uddf7',
        'borders': ['AFG', 'ARM', 'AZE', 'IRQ', 'PAK', 'TUR', 'TKM'],
        'tld': '.ir',
        'area': 1648195,
        'timezones': ['Asia/Tehran'],
      },
      {
        'commonName': 'Iraq',
        'officialName': 'Republic of Iraq',
        'nativeNames': {
          'ara': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0639\u0631\u0627\u0642',
            'common': '\u0627\u0644\u0639\u0631\u0627\u0642',
          },
          'arc': {
            'official':
                '\u0729\u0718\u073c\u071b\u0722\u0735\u0710 \u0710\u071d\u073c\u072a\u0732\u0729',
            'common': '\u0729\u0718\u073c\u071b\u0722\u0735\u0710',
          },
          'ckb': {
            'official':
                '\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0639\u06ce\u0631\u0627\u0642',
            'common': '\u06a9\u06c6\u0645\u0627\u0631\u06cc',
          },
        },
        'iso2': 'IQ',
        'iso3': 'IRQ',
        'phoneCode': '+964',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [33, 44],
        'capital': 'Baghdad',
        'currencies': {
          'IQD': {'name': 'Iraqi dinar', 'symbol': '\u0639.\u062f'},
        },
        'languages': {'ara': 'Arabic', 'arc': 'Aramaic', 'ckb': 'Sorani'},
        'flag': '\ud83c\uddee\ud83c\uddf6',
        'borders': ['IRN', 'JOR', 'KWT', 'SAU', 'SYR', 'TUR'],
        'tld': '.iq',
        'area': 438317,
        'timezones': ['Asia/Baghdad'],
      },
      {
        'commonName': 'Iceland',
        'officialName': 'Iceland',
        'nativeNames': {
          'isl': {'official': '\u00cdsland', 'common': '\u00cdsland'},
        },
        'iso2': 'IS',
        'iso3': 'ISL',
        'phoneCode': '+354',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [65, -18],
        'capital': 'Reykjavik',
        'currencies': {
          'ISK': {'name': 'Icelandic kr\u00f3na', 'symbol': 'kr'},
        },
        'languages': {'isl': 'Icelandic'},
        'flag': '\ud83c\uddee\ud83c\uddf8',
        'borders': <String>[],
        'tld': '.is',
        'area': 103000,
        'timezones': ['Atlantic/Reykjavik'],
      },
      // {
      //   'commonName': 'Israel',
      //   'officialName': 'State of Israel',
      //   'nativeNames': {
      //     'ara': {
      //       'official':
      //           '\u062f\u0648\u0644\u0629 \u0625\u0633\u0631\u0627\u0626\u064a\u0644',
      //       'common': '\u0625\u0633\u0631\u0627\u0626\u064a\u0644'
      //     },
      //     'heb': {
      //       'official':
      //           '\u05de\u05d3\u05d9\u05e0\u05ea \u05d9\u05e9\u05e8\u05d0\u05dc',
      //       'common': '\u05d9\u05e9\u05e8\u05d0\u05dc'
      //     }
      //   },
      //   'iso2': 'IL',
      //   'iso3': 'ISR',
      //   'phoneCode': '+972',
      //   'region': 'Asia',
      //   'subregion': 'Western Asia',
      //   'latlng': [31.47, 35.13],
      //   'capital': 'Jerusalem',
      //   'currencies': {
      //     'ILS': {'name': 'Israeli new shekel', 'symbol': '\u20aa'}
      //   },
      //   'languages': {'ara': 'Arabic', 'heb': 'Hebrew'},
      //   'flag': '\ud83c\uddee\ud83c\uddf1',
      //   'borders': ['EGY', 'JOR', 'LBN', 'PSE', 'SYR'],
      //   'tld': '.il',
      //   'area': 20770,
      //   'timezones': ['Asia/Jerusalem']
      // },
      {
        'commonName': 'Italy',
        'officialName': 'Italian Republic',
        'nativeNames': {
          'ita': {'official': 'Repubblica italiana', 'common': 'Italia'},
        },
        'iso2': 'IT',
        'iso3': 'ITA',
        'phoneCode': '+39',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [42.83333333, 12.83333333],
        'capital': 'Rome',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'ita': 'Italian'},
        'flag': '\ud83c\uddee\ud83c\uddf9',
        'borders': ['AUT', 'FRA', 'SMR', 'SVN', 'CHE', 'VAT'],
        'tld': '.it',
        'area': 301336,
        'timezones': ['Europe/Rome'],
      },
      {
        'commonName': 'Jamaica',
        'officialName': 'Jamaica',
        'nativeNames': {
          'eng': {'official': 'Jamaica', 'common': 'Jamaica'},
          'jam': {'official': 'Jamaica', 'common': 'Jamaica'},
        },
        'iso2': 'JM',
        'iso3': 'JAM',
        'phoneCode': '+1876',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.25, -77.5],
        'capital': 'Kingston',
        'currencies': {
          'JMD': {'name': 'Jamaican dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'jam': 'Jamaican Patois'},
        'flag': '\ud83c\uddef\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.jm',
        'area': 10991,
        'timezones': ['America/Jamaica'],
      },
      {
        'commonName': 'Jersey',
        'officialName': 'Bailiwick of Jersey',
        'nativeNames': {
          'eng': {'official': 'Bailiwick of Jersey', 'common': 'Jersey'},
          'fra': {'official': 'Bailliage de Jersey', 'common': 'Jersey'},
          'nrf': {
            'official': 'Bailliage d\u00e9 J\u00e8rri',
            'common': 'J\u00e8rri',
          },
        },
        'iso2': 'JE',
        'iso3': 'JEY',
        'phoneCode': '+44',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [49.25, -2.16666666],
        'capital': 'Saint Helier',
        'currencies': {
          'GBP': {'name': 'British pound', 'symbol': '\u00a3'},
          'JEP': {'name': 'Jersey pound', 'symbol': '\u00a3'},
        },
        'languages': {
          'eng': 'English',
          'fra': 'French',
          'nrf': 'J\u00e8rriais',
        },
        'flag': '\ud83c\uddef\ud83c\uddea',
        'borders': <String>[],
        'tld': '.je',
        'area': 116,
        'timezones': ['Europe/Jersey'],
      },
      {
        'commonName': 'Jordan',
        'officialName': 'Hashemite Kingdom of Jordan',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0623\u0631\u062f\u0646\u064a\u0629 \u0627\u0644\u0647\u0627\u0634\u0645\u064a\u0629',
            'common': '\u0627\u0644\u0623\u0631\u062f\u0646',
          },
        },
        'iso2': 'JO',
        'iso3': 'JOR',
        'phoneCode': '+962',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [31, 36],
        'capital': 'Amman',
        'currencies': {
          'JOD': {'name': 'Jordanian dinar', 'symbol': '\u062f.\u0627'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddef\ud83c\uddf4',
        'borders': ['IRQ', 'ISR', 'PSE', 'SAU', 'SYR'],
        'tld': '.jo',
        'area': 89342,
        'timezones': ['Asia/Amman'],
      },
      {
        'commonName': 'Japan',
        'officialName': 'Japan',
        'nativeNames': {
          'jpn': {'official': '\u65e5\u672c', 'common': '\u65e5\u672c'},
        },
        'iso2': 'JP',
        'iso3': 'JPN',
        'phoneCode': '+81',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [36, 138],
        'capital': 'Tokyo',
        'currencies': {
          'JPY': {'name': 'Japanese yen', 'symbol': '\u00a5'},
        },
        'languages': {'jpn': 'Japanese'},
        'flag': '\ud83c\uddef\ud83c\uddf5',
        'borders': <String>[],
        'tld': '.jp',
        'area': 377930,
        'timezones': ['Asia/Tokyo'],
      },
      {
        'commonName': 'Kazakhstan',
        'officialName': 'Republic of Kazakhstan',
        'nativeNames': {
          'kaz': {
            'official':
                '\u049a\u0430\u0437\u0430\u049b\u0441\u0442\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b',
            'common': '\u049a\u0430\u0437\u0430\u049b\u0441\u0442\u0430\u043d',
          },
          'rus': {
            'official':
                '\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d',
            'common': '\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d',
          },
        },
        'iso2': 'KZ',
        'iso3': 'KAZ',
        'phoneCode': '+7',
        'region': 'Asia',
        'subregion': 'Central Asia',
        'latlng': [48, 68],
        'capital': 'Astana',
        'currencies': {
          'KZT': {'name': 'Kazakhstani tenge', 'symbol': '\u20b8'},
        },
        'languages': {'kaz': 'Kazakh', 'rus': 'Russian'},
        'flag': '\ud83c\uddf0\ud83c\uddff',
        'borders': ['CHN', 'KGZ', 'RUS', 'TKM', 'UZB'],
        'tld': '.kz',
        'area': 2724900,
        'timezones': [
          'Asia/Almaty',
          'Asia/Qyzylorda',
          'Asia/Aqtobe',
          'Asia/Aqtau',
          'Asia/Oral',
        ],
      },
      {
        'commonName': 'Kenya',
        'officialName': 'Republic of Kenya',
        'nativeNames': {
          'eng': {'official': 'Republic of Kenya', 'common': 'Kenya'},
          'swa': {'official': 'Republic of Kenya', 'common': 'Kenya'},
        },
        'iso2': 'KE',
        'iso3': 'KEN',
        'phoneCode': '+254',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [1, 38],
        'capital': 'Nairobi',
        'currencies': {
          'KES': {'name': 'Kenyan shilling', 'symbol': 'Sh'},
        },
        'languages': {'eng': 'English', 'swa': 'Swahili'},
        'flag': '\ud83c\uddf0\ud83c\uddea',
        'borders': ['ETH', 'SOM', 'SSD', 'TZA', 'UGA'],
        'tld': '.ke',
        'area': 580367,
        'timezones': ['Africa/Nairobi'],
      },
      {
        'commonName': 'Kyrgyzstan',
        'officialName': 'Kyrgyz Republic',
        'nativeNames': {
          'kir': {
            'official':
                '\u041a\u044b\u0440\u0433\u044b\u0437 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b',
            'common':
                '\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d',
          },
          'rus': {
            'official':
                '\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430',
            'common': '\u041a\u0438\u0440\u0433\u0438\u0437\u0438\u044f',
          },
        },
        'iso2': 'KG',
        'iso3': 'KGZ',
        'phoneCode': '+996',
        'region': 'Asia',
        'subregion': 'Central Asia',
        'latlng': [41, 75],
        'capital': 'Bishkek',
        'currencies': {
          'KGS': {'name': 'Kyrgyzstani som', 'symbol': '\u0441'},
        },
        'languages': {'kir': 'Kyrgyz', 'rus': 'Russian'},
        'flag': '\ud83c\uddf0\ud83c\uddec',
        'borders': ['CHN', 'KAZ', 'TJK', 'UZB'],
        'tld': '.kg',
        'area': 199951,
        'timezones': ['Asia/Bishkek'],
      },
      {
        'commonName': 'Cambodia',
        'officialName': 'Kingdom of Cambodia',
        'nativeNames': {
          'khm': {
            'official':
                '\u1796\u17d2\u179a\u17c7\u179a\u17b6\u1787\u17b6\u178e\u17b6\u1785\u1780\u17d2\u179a\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6',
            'common': 'K\u00e2mp\u016dch\u00e9a',
          },
        },
        'iso2': 'KH',
        'iso3': 'KHM',
        'phoneCode': '+855',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [13, 105],
        'capital': 'Phnom Penh',
        'currencies': {
          'KHR': {'name': 'Cambodian riel', 'symbol': '\u17db'},
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'khm': 'Khmer'},
        'flag': '\ud83c\uddf0\ud83c\udded',
        'borders': ['LAO', 'THA', 'VNM'],
        'tld': '.kh',
        'area': 181035,
        'timezones': ['Asia/Phnom_Penh'],
      },
      {
        'commonName': 'Kiribati',
        'officialName': 'Independent and Sovereign Republic of Kiribati',
        'nativeNames': {
          'eng': {
            'official': 'Independent and Sovereign Republic of Kiribati',
            'common': 'Kiribati',
          },
          'gil': {'official': 'Ribaberiki Kiribati', 'common': 'Kiribati'},
        },
        'iso2': 'KI',
        'iso3': 'KIR',
        'phoneCode': '+686',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [1.41666666, 173],
        'capital': 'South Tarawa',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
          'KID': {'name': 'Kiribati dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'gil': 'Gilbertese'},
        'flag': '\ud83c\uddf0\ud83c\uddee',
        'borders': <String>[],
        'tld': '.ki',
        'area': 811,
        'timezones': [
          'Pacific/Tarawa',
          'Pacific/Enderbury',
          'Pacific/Kiritimati',
        ],
      },
      {
        'commonName': 'Saint Kitts and Nevis',
        'officialName': 'Federation of Saint Christopher and Nevis',
        'nativeNames': {
          'eng': {
            'official': 'Federation of Saint Christopher and Nevis',
            'common': 'Saint Kitts and Nevis',
          },
        },
        'iso2': 'KN',
        'iso3': 'KNA',
        'phoneCode': '+1869',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [17.33333333, -62.75],
        'capital': 'Basseterre',
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf0\ud83c\uddf3',
        'borders': <String>[],
        'tld': '.kn',
        'area': 261,
        'timezones': ['America/St_Kitts'],
      },
      {
        'commonName': 'South Korea',
        'officialName': 'Republic of Korea',
        'nativeNames': {
          'kor': {
            'official': '\ub300\ud55c\ubbfc\uad6d',
            'common': '\ud55c\uad6d',
          },
        },
        'iso2': 'KR',
        'iso3': 'KOR',
        'phoneCode': '+82',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [37, 127.5],
        'capital': 'Seoul',
        'currencies': {
          'KRW': {'name': 'South Korean won', 'symbol': '\u20a9'},
        },
        'languages': {'kor': 'Korean'},
        'flag': '\ud83c\uddf0\ud83c\uddf7',
        'borders': ['PRK'],
        'tld': '.kr',
        'area': 100210,
        'timezones': ['Asia/Seoul'],
      },
      {
        'commonName': 'Kosovo',
        'officialName': 'Republic of Kosovo',
        'nativeNames': {
          'sqi': {'official': 'Republika e Kosov\u00ebs', 'common': 'Kosova'},
          'srp': {
            'official':
                '\u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u0441\u043e\u0432\u043e',
            'common': '\u041a\u043e\u0441\u043e\u0432\u043e',
          },
        },
        'iso2': 'XK',
        'iso3': 'UNK',
        'phoneCode': '+383',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [42.666667, 21.166667],
        'capital': 'Pristina',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'sqi': 'Albanian', 'srp': 'Serbian'},
        'flag': '\ud83c\uddfd\ud83c\uddf0',
        'borders': ['ALB', 'MKD', 'MNE', 'SRB'],
        'tld': '.xk',
        'area': 10908,
        'timezones': ['Europe/Belgrade'],
      },
      {
        'commonName': 'Kuwait',
        'officialName': 'State of Kuwait',
        'nativeNames': {
          'ara': {
            'official':
                '\u062f\u0648\u0644\u0629 \u0627\u0644\u0643\u0648\u064a\u062a',
            'common': '\u0627\u0644\u0643\u0648\u064a\u062a',
          },
        },
        'iso2': 'KW',
        'iso3': 'KWT',
        'phoneCode': '+965',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [29.5, 45.75],
        'capital': 'Kuwait City',
        'currencies': {
          'KWD': {'name': 'Kuwaiti dinar', 'symbol': '\u062f.\u0643'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf0\ud83c\uddfc',
        'borders': ['IRQ', 'SAU'],
        'tld': '.kw',
        'area': 17818,
        'timezones': ['Asia/Kuwait'],
      },
      {
        'commonName': 'Laos',
        'officialName': "Lao People's Democratic Republic",
        'nativeNames': {
          'lao': {
            'official':
                '\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0 \u0e8a\u0eb2\u0e97\u0eb4\u0e9b\u0eb0\u0ec4\u0e95 \u0e84\u0ebb\u0e99\u0ea5\u0eb2\u0ea7 \u0e82\u0ead\u0e87',
            'common': '\u0eaa\u0e9b\u0e9b\u0ea5\u0eb2\u0ea7',
          },
        },
        'iso2': 'LA',
        'iso3': 'LAO',
        'phoneCode': '+856',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [18, 105],
        'capital': 'Vientiane',
        'currencies': {
          'LAK': {'name': 'Lao kip', 'symbol': '\u20ad'},
        },
        'languages': {'lao': 'Lao'},
        'flag': '\ud83c\uddf1\ud83c\udde6',
        'borders': ['MMR', 'KHM', 'CHN', 'THA', 'VNM'],
        'tld': '.la',
        'area': 236800,
        'timezones': ['Asia/Vientiane'],
      },
      {
        'commonName': 'Lebanon',
        'officialName': 'Lebanese Republic',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0644\u0628\u0646\u0627\u0646\u064a\u0629',
            'common': '\u0644\u0628\u0646\u0627\u0646',
          },
          'fra': {'official': 'R\u00e9publique libanaise', 'common': 'Liban'},
        },
        'iso2': 'LB',
        'iso3': 'LBN',
        'phoneCode': '+961',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [33.83333333, 35.83333333],
        'capital': 'Beirut',
        'currencies': {
          'LBP': {'name': 'Lebanese pound', 'symbol': '\u0644.\u0644'},
        },
        'languages': {'ara': 'Arabic', 'fra': 'French'},
        'flag': '\ud83c\uddf1\ud83c\udde7',
        'borders': ['ISR', 'SYR'],
        'tld': '.lb',
        'area': 10452,
        'timezones': ['Asia/Beirut'],
      },
      {
        'commonName': 'Liberia',
        'officialName': 'Republic of Liberia',
        'nativeNames': {
          'eng': {'official': 'Republic of Liberia', 'common': 'Liberia'},
        },
        'iso2': 'LR',
        'iso3': 'LBR',
        'phoneCode': '+231',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [6.5, -9.5],
        'capital': 'Monrovia',
        'currencies': {
          'LRD': {'name': 'Liberian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf1\ud83c\uddf7',
        'borders': ['GIN', 'CIV', 'SLE'],
        'tld': '.lr',
        'area': 111369,
        'timezones': ['Africa/Monrovia'],
      },
      {
        'commonName': 'Libya',
        'officialName': 'State of Libya',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062f\u0648\u0644\u0629 \u0644\u064a\u0628\u064a\u0627',
            'common': '\u200f\u0644\u064a\u0628\u064a\u0627',
          },
        },
        'iso2': 'LY',
        'iso3': 'LBY',
        'phoneCode': '+218',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [25, 17],
        'capital': 'Tripoli',
        'currencies': {
          'LYD': {'name': 'Libyan dinar', 'symbol': '\u0644.\u062f'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf1\ud83c\uddfe',
        'borders': ['DZA', 'TCD', 'EGY', 'NER', 'SDN', 'TUN'],
        'tld': '.ly',
        'area': 1759540,
        'timezones': ['Africa/Tripoli'],
      },
      {
        'commonName': 'Saint Lucia',
        'officialName': 'Saint Lucia',
        'nativeNames': {
          'eng': {'official': 'Saint Lucia', 'common': 'Saint Lucia'},
        },
        'iso2': 'LC',
        'iso3': 'LCA',
        'phoneCode': '+1758',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [13.88333333, -60.96666666],
        'capital': 'Castries',
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf1\ud83c\udde8',
        'borders': <String>[],
        'tld': '.lc',
        'area': 616,
        'timezones': ['America/St_Lucia'],
      },
      {
        'commonName': 'Liechtenstein',
        'officialName': 'Principality of Liechtenstein',
        'nativeNames': {
          'deu': {
            'official': 'F\u00fcrstentum Liechtenstein',
            'common': 'Liechtenstein',
          },
        },
        'iso2': 'LI',
        'iso3': 'LIE',
        'phoneCode': '+423',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [47.26666666, 9.53333333],
        'capital': 'Vaduz',
        'currencies': {
          'CHF': {'name': 'Swiss franc', 'symbol': 'Fr'},
        },
        'languages': {'deu': 'German'},
        'flag': '\ud83c\uddf1\ud83c\uddee',
        'borders': ['AUT', 'CHE'],
        'tld': '.li',
        'area': 160,
        'timezones': ['Europe/Vaduz'],
      },
      {
        'commonName': 'Sri Lanka',
        'officialName': 'Democratic Socialist Republic of Sri Lanka',
        'nativeNames': {
          'sin': {
            'official':
                '\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf \u0db4\u0dca\u200d\u0dbb\u0da2\u0dcf\u0dad\u0dcf\u0db1\u0dca\u0dad\u0dca\u200d\u0dbb\u0dd2\u0d9a \u0dc3\u0db8\u0dcf\u0da2\u0dc0\u0dcf\u0daf\u0dd3 \u0da2\u0db1\u0dbb\u0da2\u0dba',
            'common':
                '\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf\u0dc0',
          },
          'tam': {
            'official':
                '\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8 \u0b9a\u0ba9\u0ba8\u0bbe\u0baf\u0b95 \u0b9a\u0bcb\u0b9a\u0bb2\u0bbf\u0b9a\u0b95\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1',
            'common': '\u0b87\u0bb2\u0b99\u0bcd\u0b95\u0bc8',
          },
        },
        'iso2': 'LK',
        'iso3': 'LKA',
        'phoneCode': '+94',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [7, 81],
        'capital': 'Colombo',
        'currencies': {
          'LKR': {'name': 'Sri Lankan rupee', 'symbol': 'Rs  \u0dbb\u0dd4'},
        },
        'languages': {'sin': 'Sinhala', 'tam': 'Tamil'},
        'flag': '\ud83c\uddf1\ud83c\uddf0',
        'borders': ['IND'],
        'tld': '.lk',
        'area': 65610,
        'timezones': ['Asia/Colombo'],
      },
      {
        'commonName': 'Lesotho',
        'officialName': 'Kingdom of Lesotho',
        'nativeNames': {
          'eng': {'official': 'Kingdom of Lesotho', 'common': 'Lesotho'},
          'sot': {'official': 'Kingdom of Lesotho', 'common': 'Lesotho'},
        },
        'iso2': 'LS',
        'iso3': 'LSO',
        'phoneCode': '+266',
        'region': 'Africa',
        'subregion': 'Southern Africa',
        'latlng': [-29.5, 28.5],
        'capital': 'Maseru',
        'currencies': {
          'LSL': {'name': 'Lesotho loti', 'symbol': 'L'},
          'ZAR': {'name': 'South African rand', 'symbol': 'R'},
        },
        'languages': {'eng': 'English', 'sot': 'Sotho'},
        'flag': '\ud83c\uddf1\ud83c\uddf8',
        'borders': ['ZAF'],
        'tld': '.ls',
        'area': 30355,
        'timezones': ['Africa/Maseru'],
      },
      {
        'commonName': 'Lithuania',
        'officialName': 'Republic of Lithuania',
        'nativeNames': {
          'lit': {'official': 'Lietuvos Respublikos', 'common': 'Lietuva'},
        },
        'iso2': 'LT',
        'iso3': 'LTU',
        'phoneCode': '+370',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [56, 24],
        'capital': 'Vilnius',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'lit': 'Lithuanian'},
        'flag': '\ud83c\uddf1\ud83c\uddf9',
        'borders': ['BLR', 'LVA', 'POL', 'RUS'],
        'tld': '.lt',
        'area': 65300,
        'timezones': ['Europe/Vilnius'],
      },
      {
        'commonName': 'Luxembourg',
        'officialName': 'Grand Duchy of Luxembourg',
        'nativeNames': {
          'deu': {
            'official': 'Gro\u00dfherzogtum Luxemburg',
            'common': 'Luxemburg',
          },
          'fra': {
            'official': 'Grand-Duch\u00e9 de Luxembourg',
            'common': 'Luxembourg',
          },
          'ltz': {
            'official': 'Groussherzogtum L\u00ebtzebuerg',
            'common': 'L\u00ebtzebuerg',
          },
        },
        'iso2': 'LU',
        'iso3': 'LUX',
        'phoneCode': '+352',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [49.75, 6.16666666],
        'capital': 'Luxembourg',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'deu': 'German', 'fra': 'French', 'ltz': 'Luxembourgish'},
        'flag': '\ud83c\uddf1\ud83c\uddfa',
        'borders': ['BEL', 'FRA', 'DEU'],
        'tld': '.lu',
        'area': 2586,
        'timezones': ['Europe/Luxembourg'],
      },
      {
        'commonName': 'Latvia',
        'officialName': 'Republic of Latvia',
        'nativeNames': {
          'lav': {'official': 'Latvijas Republikas', 'common': 'Latvija'},
        },
        'iso2': 'LV',
        'iso3': 'LVA',
        'phoneCode': '+371',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [57, 25],
        'capital': 'Riga',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'lav': 'Latvian'},
        'flag': '\ud83c\uddf1\ud83c\uddfb',
        'borders': ['BLR', 'EST', 'LTU', 'RUS'],
        'tld': '.lv',
        'area': 64559,
        'timezones': ['Europe/Riga'],
      },
      {
        'commonName': 'Macau',
        'officialName':
            "Macao Special Administrative Region of the People's Republic of China",
        'nativeNames': {
          'por': {
            'official':
                'Regi\u00e3o Administrativa Especial de Macau da Rep\u00fablica Popular da China',
            'common': 'Macau',
          },
          'zho': {
            'official':
                '\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a',
            'common': '\u6fb3\u95e8',
          },
        },
        'iso2': 'MO',
        'iso3': 'MAC',
        'phoneCode': '+853',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [22.16666666, 113.55],
        'capital': null,
        'currencies': {
          'MOP': {'name': 'Macanese pataca', 'symbol': 'P'},
        },
        'languages': {'por': 'Portuguese', 'zho': 'Chinese'},
        'flag': '\ud83c\uddf2\ud83c\uddf4',
        'borders': ['CHN'],
        'tld': '.mo',
        'area': 30,
        'timezones': ['Asia/Macau'],
      },
      {
        'commonName': 'Saint Martin',
        'officialName': 'Saint Martin',
        'nativeNames': {
          'fra': {'official': 'Saint-Martin', 'common': 'Saint-Martin'},
        },
        'iso2': 'MF',
        'iso3': 'MAF',
        'phoneCode': '+590',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.08333333, -63.95],
        'capital': 'Marigot',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf2\ud83c\uddeb',
        'borders': ['SXM'],
        'tld': '.fr',
        'area': 53,
        'timezones': ['America/Marigot'],
      },
      {
        'commonName': 'Morocco',
        'officialName': 'Kingdom of Morocco',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u063a\u0631\u0628\u064a\u0629',
            'common': '\u0627\u0644\u0645\u063a\u0631\u0628',
          },
          'ber': {
            'official':
                '\u2d5c\u2d30\u2d33\u2d4d\u2d37\u2d49\u2d5c \u2d4f \u2d4d\u2d4e\u2d56\u2d54\u2d49\u2d31',
            'common': '\u2d4d\u2d4e\u2d30\u2d56\u2d54\u2d49\u2d31',
          },
        },
        'iso2': 'MA',
        'iso3': 'MAR',
        'phoneCode': '+212',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [32, -5],
        'capital': 'Rabat',
        'currencies': {
          'MAD': {'name': 'Moroccan dirham', 'symbol': '\u062f.\u0645.'},
        },
        'languages': {'ara': 'Arabic', 'ber': 'Berber'},
        'flag': '\ud83c\uddf2\ud83c\udde6',
        'borders': ['DZA', 'ESH', 'ESP'],
        'tld': '.ma',
        'area': 446550,
        'timezones': ['Africa/Casablanca'],
      },
      {
        'commonName': 'Monaco',
        'officialName': 'Principality of Monaco',
        'nativeNames': {
          'fra': {'official': 'Principaut\u00e9 de Monaco', 'common': 'Monaco'},
        },
        'iso2': 'MC',
        'iso3': 'MCO',
        'phoneCode': '+377',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [43.73333333, 7.4],
        'capital': 'Monaco',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf2\ud83c\udde8',
        'borders': ['FRA'],
        'tld': '.mc',
        'area': 2.02,
        'timezones': ['Europe/Monaco'],
      },
      {
        'commonName': 'Moldova',
        'officialName': 'Republic of Moldova',
        'nativeNames': {
          'ron': {'official': 'Republica Moldova', 'common': 'Moldova'},
        },
        'iso2': 'MD',
        'iso3': 'MDA',
        'phoneCode': '+373',
        'region': 'Europe',
        'subregion': 'Eastern Europe',
        'latlng': [47, 29],
        'capital': 'Chi\u0219in\u0103u',
        'currencies': {
          'MDL': {'name': 'Moldovan leu', 'symbol': 'L'},
        },
        'languages': {'ron': 'Moldavian'},
        'flag': '\ud83c\uddf2\ud83c\udde9',
        'borders': ['ROU', 'UKR'],
        'tld': '.md',
        'area': 33846,
        'timezones': ['Europe/Chisinau'],
      },
      {
        'commonName': 'Madagascar',
        'officialName': 'Republic of Madagascar',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique de Madagascar',
            'common': 'Madagascar',
          },
          'mlg': {
            'official': "Repoblikan'i Madagasikara",
            'common': 'Madagasikara',
          },
        },
        'iso2': 'MG',
        'iso3': 'MDG',
        'phoneCode': '+261',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-20, 47],
        'capital': 'Antananarivo',
        'currencies': {
          'MGA': {'name': 'Malagasy ariary', 'symbol': 'Ar'},
        },
        'languages': {'fra': 'French', 'mlg': 'Malagasy'},
        'flag': '\ud83c\uddf2\ud83c\uddec',
        'borders': <String>[],
        'tld': '.mg',
        'area': 587041,
        'timezones': ['Indian/Antananarivo'],
      },
      {
        'commonName': 'Maldives',
        'officialName': 'Republic of the Maldives',
        'nativeNames': {
          'div': {
            'official':
                '\u078b\u07a8\u0788\u07ac\u0780\u07a8\u0783\u07a7\u0787\u07b0\u0796\u07ad\u078e\u07ac \u0796\u07aa\u0789\u07b0\u0780\u07ab\u0783\u07a8\u0787\u07b0\u0794\u07a7',
            'common':
                '\u078b\u07a8\u0788\u07ac\u0780\u07a8\u0783\u07a7\u0787\u07b0\u0796\u07ad\u078e\u07ac',
          },
        },
        'iso2': 'MV',
        'iso3': 'MDV',
        'phoneCode': '+960',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [3.25, 73],
        'capital': 'Mal\u00e9',
        'currencies': {
          'MVR': {'name': 'Maldivian rufiyaa', 'symbol': '.\u0783'},
        },
        'languages': {'div': 'Maldivian'},
        'flag': '\ud83c\uddf2\ud83c\uddfb',
        'borders': <String>[],
        'tld': '.mv',
        'area': 300,
        'timezones': ['Indian/Maldives'],
      },
      {
        'commonName': 'Mexico',
        'officialName': 'United Mexican States',
        'nativeNames': {
          'spa': {
            'official': 'Estados Unidos Mexicanos',
            'common': 'M\u00e9xico',
          },
        },
        'iso2': 'MX',
        'iso3': 'MEX',
        'phoneCode': '+52',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [23, -102],
        'capital': 'Mexico City',
        'currencies': {
          'MXN': {'name': 'Mexican peso', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddf2\ud83c\uddfd',
        'borders': ['BLZ', 'GTM', 'USA'],
        'tld': '.mx',
        'area': 1964375,
        'timezones': [
          'America/Mexico_City',
          'America/Cancun',
          'America/Merida',
          'America/Monterrey',
          'America/Matamoros',
          'America/Mazatlan',
          'America/Chihuahua',
          'America/Ojinaga',
          'America/Hermosillo',
          'America/Tijuana',
          'America/Bahia_Banderas',
        ],
      },
      {
        'commonName': 'Marshall Islands',
        'officialName': 'Republic of the Marshall Islands',
        'nativeNames': {
          'eng': {
            'official': 'Republic of the Marshall Islands',
            'common': 'Marshall Islands',
          },
          'mah': {
            'official': 'Republic of the Marshall Islands',
            'common': 'M\u0327aje\u013c',
          },
        },
        'iso2': 'MH',
        'iso3': 'MHL',
        'phoneCode': '+692',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [9, 168],
        'capital': 'Majuro',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'mah': 'Marshallese'},
        'flag': '\ud83c\uddf2\ud83c\udded',
        'borders': <String>[],
        'tld': '.mh',
        'area': 181,
        'timezones': ['Pacific/Majuro', 'Pacific/Kwajalein'],
      },
      {
        'commonName': 'North Macedonia',
        'officialName': 'Republic of North Macedonia',
        'nativeNames': {
          'mkd': {
            'official':
                '\u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430',
            'common':
                '\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430',
          },
        },
        'iso2': 'MK',
        'iso3': 'MKD',
        'phoneCode': '+389',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [41.83333333, 22],
        'capital': 'Skopje',
        'currencies': {
          'MKD': {'name': 'denar', 'symbol': 'den'},
        },
        'languages': {'mkd': 'Macedonian'},
        'flag': '\ud83c\uddf2\ud83c\uddf0',
        'borders': ['ALB', 'BGR', 'GRC', 'UNK', 'SRB'],
        'tld': '.mk',
        'area': 25713,
        'timezones': ['Europe/Skopje'],
      },
      {
        'commonName': 'Mali',
        'officialName': 'Republic of Mali',
        'nativeNames': {
          'fra': {'official': 'R\u00e9publique du Mali', 'common': 'Mali'},
        },
        'iso2': 'ML',
        'iso3': 'MLI',
        'phoneCode': '+223',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [17, -4],
        'capital': 'Bamako',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf2\ud83c\uddf1',
        'borders': ['DZA', 'BFA', 'GIN', 'CIV', 'MRT', 'NER', 'SEN'],
        'tld': '.ml',
        'area': 1240192,
        'timezones': ['Africa/Bamako'],
      },
      {
        'commonName': 'Malta',
        'officialName': 'Republic of Malta',
        'nativeNames': {
          'eng': {'official': 'Republic of Malta', 'common': 'Malta'},
          'mlt': {'official': "Repubblika ta ' Malta", 'common': 'Malta'},
        },
        'iso2': 'MT',
        'iso3': 'MLT',
        'phoneCode': '+356',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [35.83333333, 14.58333333],
        'capital': 'Valletta',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'eng': 'English', 'mlt': 'Maltese'},
        'flag': '\ud83c\uddf2\ud83c\uddf9',
        'borders': <String>[],
        'tld': '.mt',
        'area': 316,
        'timezones': ['Europe/Malta'],
      },
      {
        'commonName': 'Myanmar',
        'officialName': 'Republic of the Union of Myanmar',
        'nativeNames': {
          'mya': {
            'official':
                '\u1015\u103c\u100a\u103a\u1011\u1031\u102c\u1004\u103a\u1005\u102f \u101e\u1019\u1039\u1019\u1010 \u1019\u103c\u1014\u103a\u1019\u102c\u1014\u102d\u102f\u1004\u103a\u1004\u1036\u1010\u1031\u102c\u103a',
            'common': '\u1019\u103c\u1014\u103a\u1019\u102c',
          },
        },
        'iso2': 'MM',
        'iso3': 'MMR',
        'phoneCode': '+95',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [22, 98],
        'capital': 'Naypyidaw',
        'currencies': {
          'MMK': {'name': 'Burmese kyat', 'symbol': 'Ks'},
        },
        'languages': {'mya': 'Burmese'},
        'flag': '\ud83c\uddf2\ud83c\uddf2',
        'borders': ['BGD', 'CHN', 'IND', 'LAO', 'THA'],
        'tld': '.mm',
        'area': 676578,
        'timezones': ['Asia/Rangoon'],
      },
      {
        'commonName': 'Montenegro',
        'officialName': 'Montenegro',
        'nativeNames': {
          'cnr': {
            'official': '\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430',
            'common': '\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430',
          },
        },
        'iso2': 'ME',
        'iso3': 'MNE',
        'phoneCode': '+382',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [42.5, 19.3],
        'capital': 'Podgorica',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'cnr': 'Montenegrin'},
        'flag': '\ud83c\uddf2\ud83c\uddea',
        'borders': ['ALB', 'BIH', 'HRV', 'UNK', 'SRB'],
        'tld': '.me',
        'area': 13812,
        'timezones': ['Europe/Podgorica'],
      },
      {
        'commonName': 'Mongolia',
        'officialName': 'Mongolia',
        'nativeNames': {
          'mon': {
            'official':
                '\u041c\u043e\u043d\u0433\u043e\u043b \u0443\u043b\u0441',
            'common': '\u041c\u043e\u043d\u0433\u043e\u043b \u0443\u043b\u0441',
          },
        },
        'iso2': 'MN',
        'iso3': 'MNG',
        'phoneCode': '+976',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [46, 105],
        'capital': 'Ulan Bator',
        'currencies': {
          'MNT': {'name': 'Mongolian t\u00f6gr\u00f6g', 'symbol': '\u20ae'},
        },
        'languages': {'mon': 'Mongolian'},
        'flag': '\ud83c\uddf2\ud83c\uddf3',
        'borders': ['CHN', 'RUS'],
        'tld': '.mn',
        'area': 1564110,
        'timezones': ['Asia/Ulaanbaatar', 'Asia/Hovd', 'Asia/Choibalsan'],
      },
      {
        'commonName': 'Northern Mariana Islands',
        'officialName': 'Commonwealth of the Northern Mariana Islands',
        'nativeNames': {
          'cal': {
            'official': 'Commonwealth of the Northern Mariana Islands',
            'common': 'Northern Mariana Islands',
          },
          'cha': {
            'official': 'Sankattan Siha Na Islas Mari\u00e5nas',
            'common': 'Na Islas Mari\u00e5nas',
          },
          'eng': {
            'official': 'Commonwealth of the Northern Mariana Islands',
            'common': 'Northern Mariana Islands',
          },
        },
        'iso2': 'MP',
        'iso3': 'MNP',
        'phoneCode': '+1670',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [15.2, 145.75],
        'capital': 'Saipan',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'cal': 'Carolinian', 'cha': 'Chamorro', 'eng': 'English'},
        'flag': '\ud83c\uddf2\ud83c\uddf5',
        'borders': <String>[],
        'tld': '.mp',
        'area': 464,
        'timezones': ['Pacific/Saipan'],
      },
      {
        'commonName': 'Mozambique',
        'officialName': 'Republic of Mozambique',
        'nativeNames': {
          'por': {
            'official': 'Rep\u00fablica de Mo\u00e7ambique',
            'common': 'Mo\u00e7ambique',
          },
        },
        'iso2': 'MZ',
        'iso3': 'MOZ',
        'phoneCode': '+258',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-18.25, 35],
        'capital': 'Maputo',
        'currencies': {
          'MZN': {'name': 'Mozambican metical', 'symbol': 'MT'},
        },
        'languages': {'por': 'Portuguese'},
        'flag': '\ud83c\uddf2\ud83c\uddff',
        'borders': ['MWI', 'ZAF', 'SWZ', 'TZA', 'ZMB', 'ZWE'],
        'tld': '.mz',
        'area': 801590,
        'timezones': ['Africa/Maputo'],
      },
      {
        'commonName': 'Mauritania',
        'officialName': 'Islamic Republic of Mauritania',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0625\u0633\u0644\u0627\u0645\u064a\u0629 \u0627\u0644\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0629',
            'common': '\u0645\u0648\u0631\u064a\u062a\u0627\u0646\u064a\u0627',
          },
        },
        'iso2': 'MR',
        'iso3': 'MRT',
        'phoneCode': '+222',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [20, -12],
        'capital': 'Nouakchott',
        'currencies': {
          'MRU': {'name': 'Mauritanian ouguiya', 'symbol': 'UM'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf2\ud83c\uddf7',
        'borders': ['DZA', 'MLI', 'SEN', 'ESH'],
        'tld': '.mr',
        'area': 1030700,
        'timezones': ['Africa/Nouakchott'],
      },
      {
        'commonName': 'Montserrat',
        'officialName': 'Montserrat',
        'nativeNames': {
          'eng': {'official': 'Montserrat', 'common': 'Montserrat'},
        },
        'iso2': 'MS',
        'iso3': 'MSR',
        'phoneCode': '+1664',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [16.75, -62.2],
        'capital': 'Plymouth',
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf2\ud83c\uddf8',
        'borders': <String>[],
        'tld': '.ms',
        'area': 102,
        'timezones': ['America/Montserrat'],
      },
      {
        'commonName': 'Martinique',
        'officialName': 'Martinique',
        'nativeNames': {
          'fra': {'official': 'Martinique', 'common': 'Martinique'},
        },
        'iso2': 'MQ',
        'iso3': 'MTQ',
        'phoneCode': '+596',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [14.666667, -61],
        'capital': 'Fort-de-France',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf2\ud83c\uddf6',
        'borders': <String>[],
        'tld': '.mq',
        'area': 1128,
        'timezones': ['America/Martinique'],
      },
      {
        'commonName': 'Mauritius',
        'officialName': 'Republic of Mauritius',
        'nativeNames': {
          'eng': {'official': 'Republic of Mauritius', 'common': 'Mauritius'},
          'fra': {
            'official': 'R\u00e9publique de Maurice',
            'common': 'Maurice',
          },
          'mfe': {'official': 'Republik Moris', 'common': 'Moris'},
        },
        'iso2': 'MU',
        'iso3': 'MUS',
        'phoneCode': '+230',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-20.28333333, 57.55],
        'capital': 'Port Louis',
        'currencies': {
          'MUR': {'name': 'Mauritian rupee', 'symbol': '\u20a8'},
        },
        'languages': {
          'eng': 'English',
          'fra': 'French',
          'mfe': 'Mauritian Creole',
        },
        'flag': '\ud83c\uddf2\ud83c\uddfa',
        'borders': <String>[],
        'tld': '.mu',
        'area': 2040,
        'timezones': ['Indian/Mauritius'],
      },
      {
        'commonName': 'Malawi',
        'officialName': 'Republic of Malawi',
        'nativeNames': {
          'eng': {'official': 'Republic of Malawi', 'common': 'Malawi'},
          'nya': {
            'official': 'Chalo cha Malawi, Dziko la Mala\u0175i',
            'common': 'Mala\u0175i',
          },
        },
        'iso2': 'MW',
        'iso3': 'MWI',
        'phoneCode': '+265',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-13.5, 34],
        'capital': 'Lilongwe',
        'currencies': {
          'MWK': {'name': 'Malawian kwacha', 'symbol': 'MK'},
        },
        'languages': {'eng': 'English', 'nya': 'Chewa'},
        'flag': '\ud83c\uddf2\ud83c\uddfc',
        'borders': ['MOZ', 'TZA', 'ZMB'],
        'tld': '.mw',
        'area': 118484,
        'timezones': ['Africa/Blantyre'],
      },
      {
        'commonName': 'Malaysia',
        'officialName': 'Malaysia',
        'nativeNames': {
          'eng': {'official': 'Malaysia', 'common': 'Malaysia'},
          'msa': {
            'official': '\u0645\u0644\u064a\u0633\u064a\u0627',
            'common': '\u0645\u0644\u064a\u0633\u064a\u0627',
          },
        },
        'iso2': 'MY',
        'iso3': 'MYS',
        'phoneCode': '+60',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [2.5, 112.5],
        'capital': 'Kuala Lumpur',
        'currencies': {
          'MYR': {'name': 'Malaysian ringgit', 'symbol': 'RM'},
        },
        'languages': {'eng': 'English', 'msa': 'Malay'},
        'flag': '\ud83c\uddf2\ud83c\uddfe',
        'borders': ['BRN', 'IDN', 'THA'],
        'tld': '.my',
        'area': 330803,
        'timezones': ['Asia/Kuala_Lumpur', 'Asia/Kuching'],
      },
      {
        'commonName': 'Mayotte',
        'officialName': 'Department of Mayotte',
        'nativeNames': {
          'fra': {
            'official': 'D\u00e9partement de Mayotte',
            'common': 'Mayotte',
          },
        },
        'iso2': 'YT',
        'iso3': 'MYT',
        'phoneCode': '+262',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-12.83333333, 45.16666666],
        'capital': 'Mamoudzou',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddfe\ud83c\uddf9',
        'borders': <String>[],
        'tld': '.yt',
        'area': 374,
        'timezones': ['Indian/Mayotte'],
      },
      {
        'commonName': 'Namibia',
        'officialName': 'Republic of Namibia',
        'nativeNames': {
          'afr': {
            'official': 'Republiek van Namibi\u00eb',
            'common': 'Namibi\u00eb',
          },
          'deu': {'official': 'Republik Namibia', 'common': 'Namibia'},
          'eng': {'official': 'Republic of Namibia', 'common': 'Namibia'},
          'her': {'official': 'Republic of Namibia', 'common': 'Namibia'},
          'hgm': {'official': 'Republic of Namibia', 'common': 'Namibia'},
          'kwn': {'official': 'Republic of Namibia', 'common': 'Namibia'},
          'loz': {'official': 'Republic of Namibia', 'common': 'Namibia'},
          'ndo': {'official': 'Republic of Namibia', 'common': 'Namibia'},
          'tsn': {'official': 'Lefatshe la Namibia', 'common': 'Namibia'},
        },
        'iso2': 'NA',
        'iso3': 'NAM',
        'phoneCode': '+264',
        'region': 'Africa',
        'subregion': 'Southern Africa',
        'latlng': [-22, 17],
        'capital': 'Windhoek',
        'currencies': {
          'NAD': {'name': 'Namibian dollar', 'symbol': r'$'},
          'ZAR': {'name': 'South African rand', 'symbol': 'R'},
        },
        'languages': {
          'afr': 'Afrikaans',
          'deu': 'German',
          'eng': 'English',
          'her': 'Herero',
          'hgm': 'Khoekhoe',
          'kwn': 'Kwangali',
          'loz': 'Lozi',
          'ndo': 'Ndonga',
          'tsn': 'Tswana',
        },
        'flag': '\ud83c\uddf3\ud83c\udde6',
        'borders': ['AGO', 'BWA', 'ZAF', 'ZMB'],
        'tld': '.na',
        'area': 825615,
        'timezones': ['Africa/Windhoek'],
      },
      {
        'commonName': 'New Caledonia',
        'officialName': 'New Caledonia',
        'nativeNames': {
          'fra': {
            'official': 'Nouvelle-Cal\u00e9donie',
            'common': 'Nouvelle-Cal\u00e9donie',
          },
        },
        'iso2': 'NC',
        'iso3': 'NCL',
        'phoneCode': '+687',
        'region': 'Oceania',
        'subregion': 'Melanesia',
        'latlng': [-21.5, 165.5],
        'capital': 'Noum\u00e9a',
        'currencies': {
          'XPF': {'name': 'CFP franc', 'symbol': '\u20a3'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf3\ud83c\udde8',
        'borders': <String>[],
        'tld': '.nc',
        'area': 18575,
        'timezones': ['Pacific/Noumea'],
      },
      {
        'commonName': 'Niger',
        'officialName': 'Republic of Niger',
        'nativeNames': {
          'fra': {'official': 'R\u00e9publique du Niger', 'common': 'Niger'},
        },
        'iso2': 'NE',
        'iso3': 'NER',
        'phoneCode': '+227',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [16, 8],
        'capital': 'Niamey',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf3\ud83c\uddea',
        'borders': ['DZA', 'BEN', 'BFA', 'TCD', 'LBY', 'MLI', 'NGA'],
        'tld': '.ne',
        'area': 1267000,
        'timezones': ['Africa/Niamey'],
      },
      {
        'commonName': 'Norfolk Island',
        'officialName': 'Territory of Norfolk Island',
        'nativeNames': {
          'eng': {
            'official': 'Territory of Norfolk Island',
            'common': 'Norfolk Island',
          },
          'pih': {
            'official': "Teratri of Norf'k Ailen",
            'common': "Norf'k Ailen",
          },
        },
        'iso2': 'NF',
        'iso3': 'NFK',
        'phoneCode': '+672',
        'region': 'Oceania',
        'subregion': 'Australia and New Zealand',
        'latlng': [-29.03333333, 167.95],
        'capital': 'Kingston',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'pih': 'Norfuk'},
        'flag': '\ud83c\uddf3\ud83c\uddeb',
        'borders': <String>[],
        'tld': '.nf',
        'area': 36,
        'timezones': ['Pacific/Norfolk'],
      },
      {
        'commonName': 'Nigeria',
        'officialName': 'Federal Republic of Nigeria',
        'nativeNames': {
          'eng': {
            'official': 'Federal Republic of Nigeria',
            'common': 'Nigeria',
          },
        },
        'iso2': 'NG',
        'iso3': 'NGA',
        'phoneCode': '+234',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [10, 8],
        'capital': 'Abuja',
        'currencies': {
          'NGN': {'name': 'Nigerian naira', 'symbol': '\u20a6'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf3\ud83c\uddec',
        'borders': ['BEN', 'CMR', 'TCD', 'NER'],
        'tld': '.ng',
        'area': 923768,
        'timezones': ['Africa/Lagos'],
      },
      {
        'commonName': 'Nicaragua',
        'officialName': 'Republic of Nicaragua',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de Nicaragua',
            'common': 'Nicaragua',
          },
        },
        'iso2': 'NI',
        'iso3': 'NIC',
        'phoneCode': '+505',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [13, -85],
        'capital': 'Managua',
        'currencies': {
          'NIO': {'name': 'Nicaraguan c\u00f3rdoba', 'symbol': r'C$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddf3\ud83c\uddee',
        'borders': ['CRI', 'HND'],
        'tld': '.ni',
        'area': 130373,
        'timezones': ['America/Managua'],
      },
      {
        'commonName': 'Niue',
        'officialName': 'Niue',
        'nativeNames': {
          'eng': {'official': 'Niue', 'common': 'Niue'},
          'niu': {'official': 'Niu\u0113', 'common': 'Niu\u0113'},
        },
        'iso2': 'NU',
        'iso3': 'NIU',
        'phoneCode': '+683',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-19.03333333, -169.86666666],
        'capital': 'Alofi',
        'currencies': {
          'NZD': {'name': 'New Zealand dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'niu': 'Niuean'},
        'flag': '\ud83c\uddf3\ud83c\uddfa',
        'borders': <String>[],
        'tld': '.nu',
        'area': 260,
        'timezones': ['Pacific/Niue'],
      },
      {
        'commonName': 'Netherlands',
        'officialName': 'Kingdom of the Netherlands',
        'nativeNames': {
          'nld': {
            'official': 'Koninkrijk der Nederlanden',
            'common': 'Nederland',
          },
        },
        'iso2': 'NL',
        'iso3': 'NLD',
        'phoneCode': '+31',
        'region': 'Europe',
        'subregion': 'Western Europe',
        'latlng': [52.5, 5.75],
        'capital': 'Amsterdam',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'nld': 'Dutch'},
        'flag': '\ud83c\uddf3\ud83c\uddf1',
        'borders': ['BEL', 'DEU'],
        'tld': '.nl',
        'area': 41850,
        'timezones': ['Europe/Amsterdam'],
      },
      {
        'commonName': 'Norway',
        'officialName': 'Kingdom of Norway',
        'nativeNames': {
          'nno': {'official': 'Kongeriket Noreg', 'common': 'Noreg'},
          'nob': {'official': 'Kongeriket Norge', 'common': 'Norge'},
          'smi': {'official': 'Norgga gonagasriika', 'common': 'Norgga'},
        },
        'iso2': 'NO',
        'iso3': 'NOR',
        'phoneCode': '+47',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [62, 10],
        'capital': 'Oslo',
        'currencies': {
          'NOK': {'name': 'Norwegian krone', 'symbol': 'kr'},
        },
        'languages': {
          'nno': 'Norwegian Nynorsk',
          'nob': 'Norwegian Bokm\u00e5l',
          'smi': 'Sami',
        },
        'flag': '\ud83c\uddf3\ud83c\uddf4',
        'borders': ['FIN', 'SWE', 'RUS'],
        'tld': '.no',
        'area': 323802,
        'timezones': ['Europe/Oslo'],
      },
      {
        'commonName': 'Nepal',
        'officialName': 'Federal Democratic Republic of Nepal',
        'nativeNames': {
          'nep': {
            'official':
                '\u0928\u0947\u092a\u093e\u0932 \u0938\u0902\u0918\u0940\u092f \u0932\u094b\u0915\u0924\u093e\u0928\u094d\u0924\u094d\u0930\u093f\u0915 \u0917\u0923\u0924\u0928\u094d\u0924\u094d\u0930',
            'common': '\u0928\u0947\u092a\u093e\u0932',
          },
        },
        'iso2': 'NP',
        'iso3': 'NPL',
        'phoneCode': '+977',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [28, 84],
        'capital': 'Kathmandu',
        'currencies': {
          'NPR': {'name': 'Nepalese rupee', 'symbol': '\u20a8'},
        },
        'languages': {'nep': 'Nepali'},
        'flag': '\ud83c\uddf3\ud83c\uddf5',
        'borders': ['CHN', 'IND'],
        'tld': '.np',
        'area': 147181,
        'timezones': ['Asia/Kathmandu'],
      },
      {
        'commonName': 'Nauru',
        'officialName': 'Republic of Nauru',
        'nativeNames': {
          'eng': {'official': 'Republic of Nauru', 'common': 'Nauru'},
          'nau': {'official': 'Republic of Nauru', 'common': 'Nauru'},
        },
        'iso2': 'NR',
        'iso3': 'NRU',
        'phoneCode': '+674',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [-0.53333333, 166.91666666],
        'capital': 'Yaren',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'nau': 'Nauru'},
        'flag': '\ud83c\uddf3\ud83c\uddf7',
        'borders': <String>[],
        'tld': '.nr',
        'area': 21,
        'timezones': ['Pacific/Nauru'],
      },
      {
        'commonName': 'New Zealand',
        'officialName': 'New Zealand',
        'nativeNames': {
          'eng': {'official': 'New Zealand', 'common': 'New Zealand'},
          'mri': {'official': 'Aotearoa', 'common': 'Aotearoa'},
          'nzs': {'official': 'New Zealand', 'common': 'New Zealand'},
        },
        'iso2': 'NZ',
        'iso3': 'NZL',
        'phoneCode': '+64',
        'region': 'Oceania',
        'subregion': 'Australia and New Zealand',
        'latlng': [-41, 174],
        'capital': 'Wellington',
        'currencies': {
          'NZD': {'name': 'New Zealand dollar', 'symbol': r'$'},
        },
        'languages': {
          'eng': 'English',
          'mri': 'M\u0101ori',
          'nzs': 'New Zealand Sign Language',
        },
        'flag': '\ud83c\uddf3\ud83c\uddff',
        'borders': <String>[],
        'tld': '.nz',
        'area': 270467,
        'timezones': ['Pacific/Auckland', 'Pacific/Chatham'],
      },
      {
        'commonName': 'Oman',
        'officialName': 'Sultanate of Oman',
        'nativeNames': {
          'ara': {
            'official':
                '\u0633\u0644\u0637\u0646\u0629 \u0639\u0645\u0627\u0646',
            'common': '\u0639\u0645\u0627\u0646',
          },
        },
        'iso2': 'OM',
        'iso3': 'OMN',
        'phoneCode': '+968',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [21, 57],
        'capital': 'Muscat',
        'currencies': {
          'OMR': {'name': 'Omani rial', 'symbol': '\u0631.\u0639.'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf4\ud83c\uddf2',
        'borders': ['SAU', 'ARE', 'YEM'],
        'tld': '.om',
        'area': 309500,
        'timezones': ['Asia/Muscat'],
      },
      {
        'commonName': 'Pakistan',
        'officialName': 'Islamic Republic of Pakistan',
        'nativeNames': {
          'eng': {
            'official': 'Islamic Republic of Pakistan',
            'common': 'Pakistan',
          },
          'urd': {
            'official':
                '\u0627\u0633\u0644\u0627\u0645\u06cc \u062c\u0645\u06c1\u0648\u0631\u06cc\u06c2 \u067e\u0627\u0643\u0633\u062a\u0627\u0646',
            'common': '\u067e\u0627\u0643\u0633\u062a\u0627\u0646',
          },
        },
        'iso2': 'PK',
        'iso3': 'PAK',
        'phoneCode': '+92',
        'region': 'Asia',
        'subregion': 'Southern Asia',
        'latlng': [30, 70],
        'capital': 'Islamabad',
        'currencies': {
          'PKR': {'name': 'Pakistani rupee', 'symbol': '\u20a8'},
        },
        'languages': {'eng': 'English', 'urd': 'Urdu'},
        'flag': '\ud83c\uddf5\ud83c\uddf0',
        'borders': ['AFG', 'CHN', 'IND', 'IRN'],
        'tld': '.pk',
        'area': 881912,
        'timezones': ['Asia/Karachi'],
      },
      {
        'commonName': 'Panama',
        'officialName': 'Republic of Panama',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de Panam\u00e1',
            'common': 'Panam\u00e1',
          },
        },
        'iso2': 'PA',
        'iso3': 'PAN',
        'phoneCode': '+507',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [9, -80],
        'capital': 'Panama City',
        'currencies': {
          'PAB': {'name': 'Panamanian balboa', 'symbol': 'B/.'},
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddf5\ud83c\udde6',
        'borders': ['COL', 'CRI'],
        'tld': '.pa',
        'area': 75417,
        'timezones': ['America/Panama'],
      },
      {
        'commonName': 'Pitcairn Islands',
        'officialName': 'Pitcairn Group of Islands',
        'nativeNames': {
          'eng': {
            'official': 'Pitcairn Group of Islands',
            'common': 'Pitcairn Islands',
          },
        },
        'iso2': 'PN',
        'iso3': 'PCN',
        'phoneCode': '+870',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-25.06666666, -130.1],
        'capital': 'Adamstown',
        'currencies': {
          'NZD': {'name': 'New Zealand dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf5\ud83c\uddf3',
        'borders': <String>[],
        'tld': '.pn',
        'area': 47,
        'timezones': ['Pacific/Pitcairn'],
      },
      {
        'commonName': 'Peru',
        'officialName': 'Republic of Peru',
        'nativeNames': {
          'aym': {'official': 'Piruw Suyu', 'common': 'Piruw'},
          'que': {'official': 'Piruw Ripuwlika', 'common': 'Piruw'},
          'spa': {
            'official': 'Rep\u00fablica del Per\u00fa',
            'common': 'Per\u00fa',
          },
        },
        'iso2': 'PE',
        'iso3': 'PER',
        'phoneCode': '+51',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-10, -76],
        'capital': 'Lima',
        'currencies': {
          'PEN': {'name': 'Peruvian sol', 'symbol': 'S/.'},
        },
        'languages': {'aym': 'Aymara', 'que': 'Quechua', 'spa': 'Spanish'},
        'flag': '\ud83c\uddf5\ud83c\uddea',
        'borders': ['BOL', 'BRA', 'CHL', 'COL', 'ECU'],
        'tld': '.pe',
        'area': 1285216,
        'timezones': ['America/Lima'],
      },
      {
        'commonName': 'Philippines',
        'officialName': 'Republic of the Philippines',
        'nativeNames': {
          'eng': {
            'official': 'Republic of the Philippines',
            'common': 'Philippines',
          },
          'fil': {
            'official': 'Republic of the Philippines',
            'common': 'Pilipinas',
          },
        },
        'iso2': 'PH',
        'iso3': 'PHL',
        'phoneCode': '+63',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [13, 122],
        'capital': 'Manila',
        'currencies': {
          'PHP': {'name': 'Philippine peso', 'symbol': '\u20b1'},
        },
        'languages': {'eng': 'English', 'fil': 'Filipino'},
        'flag': '\ud83c\uddf5\ud83c\udded',
        'borders': <String>[],
        'tld': '.ph',
        'area': 342353,
        'timezones': ['Asia/Manila'],
      },
      {
        'commonName': 'Palau',
        'officialName': 'Republic of Palau',
        'nativeNames': {
          'eng': {'official': 'Republic of Palau', 'common': 'Palau'},
          'pau': {'official': 'Beluu er a Belau', 'common': 'Belau'},
        },
        'iso2': 'PW',
        'iso3': 'PLW',
        'phoneCode': '+680',
        'region': 'Oceania',
        'subregion': 'Micronesia',
        'latlng': [7.5, 134.5],
        'capital': 'Ngerulmud',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'pau': 'Palauan'},
        'flag': '\ud83c\uddf5\ud83c\uddfc',
        'borders': <String>[],
        'tld': '.pw',
        'area': 459,
        'timezones': ['Pacific/Palau'],
      },
      {
        'commonName': 'Papua New Guinea',
        'officialName': 'Independent State of Papua New Guinea',
        'nativeNames': {
          'eng': {
            'official': 'Independent State of Papua New Guinea',
            'common': 'Papua New Guinea',
          },
          'hmo': {
            'official': 'Independen Stet bilong Papua Niugini',
            'common': 'Papua Niu Gini',
          },
          'tpi': {
            'official': 'Independen Stet bilong Papua Niugini',
            'common': 'Papua Niugini',
          },
        },
        'iso2': 'PG',
        'iso3': 'PNG',
        'phoneCode': '+675',
        'region': 'Oceania',
        'subregion': 'Melanesia',
        'latlng': [-6, 147],
        'capital': 'Port Moresby',
        'currencies': {
          'PGK': {'name': 'Papua New Guinean kina', 'symbol': 'K'},
        },
        'languages': {'eng': 'English', 'hmo': 'Hiri Motu', 'tpi': 'Tok Pisin'},
        'flag': '\ud83c\uddf5\ud83c\uddec',
        'borders': ['IDN'],
        'tld': '.pg',
        'area': 462840,
        'timezones': ['Pacific/Port_Moresby', 'Pacific/Bougainville'],
      },
      {
        'commonName': 'Poland',
        'officialName': 'Republic of Poland',
        'nativeNames': {
          'pol': {'official': 'Rzeczpospolita Polska', 'common': 'Polska'},
        },
        'iso2': 'PL',
        'iso3': 'POL',
        'phoneCode': '+48',
        'region': 'Europe',
        'subregion': 'Central Europe',
        'latlng': [52, 20],
        'capital': 'Warsaw',
        'currencies': {
          'PLN': {'name': 'Polish z\u0142oty', 'symbol': 'z\u0142'},
        },
        'languages': {'pol': 'Polish'},
        'flag': '\ud83c\uddf5\ud83c\uddf1',
        'borders': ['BLR', 'CZE', 'DEU', 'LTU', 'RUS', 'SVK', 'UKR'],
        'tld': '.pl',
        'area': 312679,
        'timezones': ['Europe/Warsaw'],
      },
      {
        'commonName': 'Puerto Rico',
        'officialName': 'Commonwealth of Puerto Rico',
        'nativeNames': {
          'eng': {
            'official': 'Commonwealth of Puerto Rico',
            'common': 'Puerto Rico',
          },
          'spa': {
            'official': 'Estado Libre Asociado de Puerto Rico',
            'common': 'Puerto Rico',
          },
        },
        'iso2': 'PR',
        'iso3': 'PRI',
        'phoneCode': '+1',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.25, -66.5],
        'capital': 'San Juan',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'spa': 'Spanish'},
        'flag': '\ud83c\uddf5\ud83c\uddf7',
        'borders': <String>[],
        'tld': '.pr',
        'area': 8870,
        'timezones': ['America/Puerto_Rico'],
      },
      {
        'commonName': 'North Korea',
        'officialName': "Democratic People's Republic of Korea",
        'nativeNames': {
          'kor': {
            'official':
                '\uc870\uc120\ubbfc\uc8fc\uc8fc\uc758\uc778\ubbfc\uacf5\ud654\uad6d',
            'common': '\uc870\uc120',
          },
        },
        'iso2': 'KP',
        'iso3': 'PRK',
        'phoneCode': '+850',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [40, 127],
        'capital': 'Pyongyang',
        'currencies': {
          'KPW': {'name': 'North Korean won', 'symbol': '\u20a9'},
        },
        'languages': {'kor': 'Korean'},
        'flag': '\ud83c\uddf0\ud83c\uddf5',
        'borders': ['CHN', 'KOR', 'RUS'],
        'tld': '.kp',
        'area': 120538,
        'timezones': ['Asia/Pyongyang'],
      },
      {
        'commonName': 'Portugal',
        'officialName': 'Portuguese Republic',
        'nativeNames': {
          'por': {
            'official': 'Rep\u00fablica portugu\u00eas',
            'common': 'Portugal',
          },
        },
        'iso2': 'PT',
        'iso3': 'PRT',
        'phoneCode': '+351',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [39.5, -8],
        'capital': 'Lisbon',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'por': 'Portuguese'},
        'flag': '\ud83c\uddf5\ud83c\uddf9',
        'borders': ['ESP'],
        'tld': '.pt',
        'area': 92090,
        'timezones': ['Europe/Lisbon', 'Atlantic/Madeira', 'Atlantic/Azores'],
      },
      {
        'commonName': 'Paraguay',
        'officialName': 'Republic of Paraguay',
        'nativeNames': {
          'grn': {
            'official': 'Tet\u00e3 Paragu\u00e1i',
            'common': 'Paragu\u00e1i',
          },
          'spa': {
            'official': 'Rep\u00fablica de Paraguay',
            'common': 'Paraguay',
          },
        },
        'iso2': 'PY',
        'iso3': 'PRY',
        'phoneCode': '+595',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-23, -58],
        'capital': 'Asunci\u00f3n',
        'currencies': {
          'PYG': {'name': 'Paraguayan guaran\u00ed', 'symbol': '\u20b2'},
        },
        'languages': {'grn': 'Guaran\u00ed', 'spa': 'Spanish'},
        'flag': '\ud83c\uddf5\ud83c\uddfe',
        'borders': ['ARG', 'BOL', 'BRA'],
        'tld': '.py',
        'area': 406752,
        'timezones': ['America/Asuncion'],
      },
      {
        'commonName': 'Palestine',
        'officialName': 'State of Palestine',
        'nativeNames': {
          'ara': {
            'official':
                '\u062f\u0648\u0644\u0629 \u0641\u0644\u0633\u0637\u064a\u0646',
            'common': '\u0641\u0644\u0633\u0637\u064a\u0646',
          },
        },
        'iso2': 'PS',
        'iso3': 'PSE',
        'phoneCode': '+970',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [31.9, 35.2],
        'capital': 'Ramallah',
        'currencies': {
          'EGP': {'name': 'Egyptian pound', 'symbol': 'E\u00a3'},
          'ILS': {'name': 'Israeli new shekel', 'symbol': '\u20aa'},
          'JOD': {'name': 'Jordanian dinar', 'symbol': 'JD'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf5\ud83c\uddf8',
        'borders': ['ISR', 'EGY', 'JOR'],
        'tld': '.ps',
        'area': 6220,
        'timezones': ['Asia/Gaza', 'Asia/Hebron'],
      },
      {
        'commonName': 'French Polynesia',
        'officialName': 'French Polynesia',
        'nativeNames': {
          'fra': {
            'official': 'Polyn\u00e9sie fran\u00e7aise',
            'common': 'Polyn\u00e9sie fran\u00e7aise',
          },
        },
        'iso2': 'PF',
        'iso3': 'PYF',
        'phoneCode': '+689',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-15, -140],
        'capital': 'Papeet\u0113',
        'currencies': {
          'XPF': {'name': 'CFP franc', 'symbol': '\u20a3'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf5\ud83c\uddeb',
        'borders': <String>[],
        'tld': '.pf',
        'area': 4167,
        'timezones': ['Pacific/Tahiti', 'Pacific/Marquesas', 'Pacific/Gambier'],
      },
      {
        'commonName': 'Qatar',
        'officialName': 'State of Qatar',
        'nativeNames': {
          'ara': {
            'official': '\u062f\u0648\u0644\u0629 \u0642\u0637\u0631',
            'common': '\u0642\u0637\u0631',
          },
        },
        'iso2': 'QA',
        'iso3': 'QAT',
        'phoneCode': '+974',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [25.5, 51.25],
        'capital': 'Doha',
        'currencies': {
          'QAR': {'name': 'Qatari riyal', 'symbol': '\u0631.\u0642'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf6\ud83c\udde6',
        'borders': ['SAU'],
        'tld': '.qa',
        'area': 11586,
        'timezones': ['Asia/Qatar'],
      },
      {
        'commonName': 'R\u00e9union',
        'officialName': 'R\u00e9union Island',
        'nativeNames': {
          'fra': {
            'official': 'Ile de la R\u00e9union',
            'common': 'La R\u00e9union',
          },
        },
        'iso2': 'RE',
        'iso3': 'REU',
        'phoneCode': '+262',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-21.15, 55.5],
        'capital': 'Saint-Denis',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf7\ud83c\uddea',
        'borders': <String>[],
        'tld': '.re',
        'area': 2511,
        'timezones': ['Indian/Reunion'],
      },
      {
        'commonName': 'Romania',
        'officialName': 'Romania',
        'nativeNames': {
          'ron': {'official': 'Rom\u00e2nia', 'common': 'Rom\u00e2nia'},
        },
        'iso2': 'RO',
        'iso3': 'ROU',
        'phoneCode': '+40',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [46, 25],
        'capital': 'Bucharest',
        'currencies': {
          'RON': {'name': 'Romanian leu', 'symbol': 'lei'},
        },
        'languages': {'ron': 'Romanian'},
        'flag': '\ud83c\uddf7\ud83c\uddf4',
        'borders': ['BGR', 'HUN', 'MDA', 'SRB', 'UKR'],
        'tld': '.ro',
        'area': 238391,
        'timezones': ['Europe/Bucharest'],
      },
      {
        'commonName': 'Russia',
        'officialName': 'Russian Federation',
        'nativeNames': {
          'rus': {
            'official':
                '\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0430\u044f \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u044f',
            'common': '\u0420\u043e\u0441\u0441\u0438\u044f',
          },
        },
        'iso2': 'RU',
        'iso3': 'RUS',
        'phoneCode': '+7',
        'region': 'Europe',
        'subregion': 'Eastern Europe',
        'latlng': [60, 100],
        'capital': 'Moscow',
        'currencies': {
          'RUB': {'name': 'Russian ruble', 'symbol': '\u20bd'},
        },
        'languages': {'rus': 'Russian'},
        'flag': '\ud83c\uddf7\ud83c\uddfa',
        'borders': [
          'AZE',
          'BLR',
          'CHN',
          'EST',
          'FIN',
          'GEO',
          'KAZ',
          'PRK',
          'LVA',
          'LTU',
          'MNG',
          'NOR',
          'POL',
          'UKR',
        ],
        'tld': '.ru',
        'area': 17098242,
        'timezones': [
          'Europe/Kaliningrad',
          'Europe/Moscow',
          'Europe/Simferopol',
          'Europe/Volgograd',
          'Europe/Kirov',
          'Europe/Astrakhan',
          'Europe/Samara',
          'Europe/Ulyanovsk',
          'Asia/Yekaterinburg',
          'Asia/Omsk',
          'Asia/Novosibirsk',
          'Asia/Barnaul',
          'Asia/Tomsk',
          'Asia/Novokuznetsk',
          'Asia/Krasnoyarsk',
          'Asia/Irkutsk',
          'Asia/Chita',
          'Asia/Yakutsk',
          'Asia/Khandyga',
          'Asia/Vladivostok',
          'Asia/Ust-Nera',
          'Asia/Magadan',
          'Asia/Sakhalin',
          'Asia/Srednekolymsk',
          'Asia/Kamchatka',
          'Asia/Anadyr',
        ],
      },
      {
        'commonName': 'Rwanda',
        'officialName': 'Republic of Rwanda',
        'nativeNames': {
          'eng': {'official': 'Republic of Rwanda', 'common': 'Rwanda'},
          'fra': {'official': 'R\u00e9publique rwandaise', 'common': 'Rwanda'},
          'kin': {'official': "Repubulika y'u Rwanda", 'common': 'Rwanda'},
        },
        'iso2': 'RW',
        'iso3': 'RWA',
        'phoneCode': '+250',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-2, 30],
        'capital': 'Kigali',
        'currencies': {
          'RWF': {'name': 'Rwandan franc', 'symbol': 'Fr'},
        },
        'languages': {'eng': 'English', 'fra': 'French', 'kin': 'Kinyarwanda'},
        'flag': '\ud83c\uddf7\ud83c\uddfc',
        'borders': ['BDI', 'COD', 'TZA', 'UGA'],
        'tld': '.rw',
        'area': 26338,
        'timezones': ['Africa/Kigali'],
      },
      {
        'commonName': 'Saudi Arabia',
        'officialName': 'Kingdom of Saudi Arabia',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629',
            'common':
                '\u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0639\u0648\u062f\u064a\u0629',
          },
        },
        'iso2': 'SA',
        'iso3': 'SAU',
        'phoneCode': '+966',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [25, 45],
        'capital': 'Riyadh',
        'currencies': {
          'SAR': {'name': 'Saudi riyal', 'symbol': '\u0631.\u0633'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf8\ud83c\udde6',
        'borders': ['IRQ', 'JOR', 'KWT', 'OMN', 'QAT', 'ARE', 'YEM'],
        'tld': '.sa',
        'area': 2149690,
        'timezones': ['Asia/Riyadh'],
      },
      {
        'commonName': 'Sudan',
        'officialName': 'Republic of the Sudan',
        'nativeNames': {
          'ara': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0633\u0648\u062f\u0627\u0646',
            'common': '\u0627\u0644\u0633\u0648\u062f\u0627\u0646',
          },
          'eng': {'official': 'Republic of the Sudan', 'common': 'Sudan'},
        },
        'iso2': 'SD',
        'iso3': 'SDN',
        'phoneCode': '+249',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [15, 30],
        'capital': 'Khartoum',
        'currencies': {
          'SDG': {'name': 'Sudanese pound', 'symbol': 'PT'},
        },
        'languages': {'ara': 'Arabic', 'eng': 'English'},
        'flag': '\ud83c\uddf8\ud83c\udde9',
        'borders': ['CAF', 'TCD', 'EGY', 'ERI', 'ETH', 'LBY', 'SSD'],
        'tld': '.sd',
        'area': 1886068,
        'timezones': ['Africa/Khartoum'],
      },
      {
        'commonName': 'Senegal',
        'officialName': 'Republic of Senegal',
        'nativeNames': {
          'fra': {
            'official': 'R\u00e9publique du S\u00e9n\u00e9gal',
            'common': 'S\u00e9n\u00e9gal',
          },
        },
        'iso2': 'SN',
        'iso3': 'SEN',
        'phoneCode': '+221',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [14, -14],
        'capital': 'Dakar',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf8\ud83c\uddf3',
        'borders': ['GMB', 'GIN', 'GNB', 'MLI', 'MRT'],
        'tld': '.sn',
        'area': 196722,
        'timezones': ['Africa/Dakar'],
      },
      {
        'commonName': 'Singapore',
        'officialName': 'Republic of Singapore',
        'nativeNames': {
          'eng': {'official': 'Republic of Singapore', 'common': 'Singapore'},
          'msa': {'official': 'Republik Singapura', 'common': 'Singapura'},
          'tam': {
            'official':
                '\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd \u0b95\u0bc1\u0b9f\u0bbf\u0baf\u0bb0\u0b9a\u0bc1',
            'common':
                '\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd',
          },
          'zho': {
            'official': '\u65b0\u52a0\u5761\u5171\u548c\u56fd',
            'common': '\u65b0\u52a0\u5761',
          },
        },
        'iso2': 'SG',
        'iso3': 'SGP',
        'phoneCode': '+65',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [1.36666666, 103.8],
        'capital': 'Singapore',
        'currencies': {
          'SGD': {'name': 'Singapore dollar', 'symbol': r'$'},
        },
        'languages': {
          'eng': 'English',
          'msa': 'Malay',
          'tam': 'Tamil',
          'zho': 'Chinese',
        },
        'flag': '\ud83c\uddf8\ud83c\uddec',
        'borders': <String>[],
        'tld': '.sg',
        'area': 710,
        'timezones': ['Asia/Singapore'],
      },
      {
        'commonName': 'South Georgia',
        'officialName': 'South Georgia and the South Sandwich Islands',
        'nativeNames': {
          'eng': {
            'official': 'South Georgia and the South Sandwich Islands',
            'common': 'South Georgia',
          },
        },
        'iso2': 'GS',
        'iso3': 'SGS',
        'phoneCode': '+500',
        'region': 'Antarctic',
        'subregion': '',
        'latlng': [-54.5, -37],
        'capital': 'King Edward Point',
        'currencies': {
          'SHP': {'name': 'Saint Helena pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddec\ud83c\uddf8',
        'borders': <String>[],
        'tld': '.gs',
        'area': 3903,
        'timezones': ['Atlantic/South_Georgia'],
      },
      {
        'commonName': 'Svalbard and Jan Mayen',
        'officialName': 'Svalbard og Jan Mayen',
        'nativeNames': {
          'nor': {
            'official': 'Svalbard og Jan Mayen',
            'common': 'Svalbard og Jan Mayen',
          },
        },
        'iso2': 'SJ',
        'iso3': 'SJM',
        'phoneCode': '+47',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [78, 20],
        'capital': 'Longyearbyen',
        'currencies': {
          'NOK': {'name': 'krone', 'symbol': 'kr'},
        },
        'languages': {'nor': 'Norwegian'},
        'flag': '\ud83c\uddf8\ud83c\uddef',
        'borders': <String>[],
        'tld': '.sj',
        'area': -1,
        'timezones': ['Arctic/Longyearbyen'],
      },
      {
        'commonName': 'Solomon Islands',
        'officialName': 'Solomon Islands',
        'nativeNames': {
          'eng': {'official': 'Solomon Islands', 'common': 'Solomon Islands'},
        },
        'iso2': 'SB',
        'iso3': 'SLB',
        'phoneCode': '+677',
        'region': 'Oceania',
        'subregion': 'Melanesia',
        'latlng': [-8, 159],
        'capital': 'Honiara',
        'currencies': {
          'SBD': {'name': 'Solomon Islands dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf8\ud83c\udde7',
        'borders': <String>[],
        'tld': '.sb',
        'area': 28896,
        'timezones': ['Pacific/Guadalcanal'],
      },
      {
        'commonName': 'Sierra Leone',
        'officialName': 'Republic of Sierra Leone',
        'nativeNames': {
          'eng': {
            'official': 'Republic of Sierra Leone',
            'common': 'Sierra Leone',
          },
        },
        'iso2': 'SL',
        'iso3': 'SLE',
        'phoneCode': '+232',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [8.5, -11.5],
        'capital': 'Freetown',
        'currencies': {
          'SLL': {'name': 'Sierra Leonean leone', 'symbol': 'Le'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf8\ud83c\uddf1',
        'borders': ['GIN', 'LBR'],
        'tld': '.sl',
        'area': 71740,
        'timezones': ['Africa/Freetown'],
      },
      {
        'commonName': 'El Salvador',
        'officialName': 'Republic of El Salvador',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica de El Salvador',
            'common': 'El Salvador',
          },
        },
        'iso2': 'SV',
        'iso3': 'SLV',
        'phoneCode': '+503',
        'region': 'Americas',
        'subregion': 'Central America',
        'latlng': [13.83333333, -88.91666666],
        'capital': 'San Salvador',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddf8\ud83c\uddfb',
        'borders': ['GTM', 'HND'],
        'tld': '.sv',
        'area': 21041,
        'timezones': ['America/El_Salvador'],
      },
      {
        'commonName': 'San Marino',
        'officialName': 'Most Serene Republic of San Marino',
        'nativeNames': {
          'ita': {
            'official': 'Serenissima Repubblica di San Marino',
            'common': 'San Marino',
          },
        },
        'iso2': 'SM',
        'iso3': 'SMR',
        'phoneCode': '+378',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [43.76666666, 12.41666666],
        'capital': 'City of San Marino',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'ita': 'Italian'},
        'flag': '\ud83c\uddf8\ud83c\uddf2',
        'borders': ['ITA'],
        'tld': '.sm',
        'area': 61,
        'timezones': ['Europe/San_Marino'],
      },
      {
        'commonName': 'Somalia',
        'officialName': 'Federal Republic of Somalia',
        'nativeNames': {
          'ara': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0635\u0648\u0645\u0627\u0644\u200e\u200e',
            'common': '\u0627\u0644\u0635\u0648\u0645\u0627\u0644\u200e\u200e',
          },
          'som': {
            'official': 'Jamhuuriyadda Federaalka Soomaaliya',
            'common': 'Soomaaliya',
          },
        },
        'iso2': 'SO',
        'iso3': 'SOM',
        'phoneCode': '+252',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [10, 49],
        'capital': 'Mogadishu',
        'currencies': {
          'SOS': {'name': 'Somali shilling', 'symbol': 'Sh'},
        },
        'languages': {'ara': 'Arabic', 'som': 'Somali'},
        'flag': '\ud83c\uddf8\ud83c\uddf4',
        'borders': ['DJI', 'ETH', 'KEN'],
        'tld': '.so',
        'area': 637657,
        'timezones': ['Africa/Mogadishu'],
      },
      {
        'commonName': 'Saint Pierre and Miquelon',
        'officialName': 'Saint Pierre and Miquelon',
        'nativeNames': {
          'fra': {
            'official':
                'Collectivit\u00e9 territoriale de Saint-Pierre-et-Miquelon',
            'common': 'Saint-Pierre-et-Miquelon',
          },
        },
        'iso2': 'PM',
        'iso3': 'SPM',
        'phoneCode': '+508',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [46.83333333, -56.33333333],
        'capital': 'Saint-Pierre',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf5\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.pm',
        'area': 242,
        'timezones': ['America/Miquelon'],
      },
      {
        'commonName': 'Serbia',
        'officialName': 'Republic of Serbia',
        'nativeNames': {
          'srp': {
            'official':
                '\u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0421\u0440\u0431\u0438\u0458\u0430',
            'common': '\u0421\u0440\u0431\u0438\u0458\u0430',
          },
        },
        'iso2': 'RS',
        'iso3': 'SRB',
        'phoneCode': '+381',
        'region': 'Europe',
        'subregion': 'Southeast Europe',
        'latlng': [44, 21],
        'capital': 'Belgrade',
        'currencies': {
          'RSD': {'name': 'Serbian dinar', 'symbol': '\u0434\u0438\u043d.'},
        },
        'languages': {'srp': 'Serbian'},
        'flag': '\ud83c\uddf7\ud83c\uddf8',
        'borders': ['BIH', 'BGR', 'HRV', 'HUN', 'UNK', 'MKD', 'MNE', 'ROU'],
        'tld': '.rs',
        'area': 88361,
        'timezones': ['Europe/Belgrade'],
      },
      {
        'commonName': 'South Sudan',
        'officialName': 'Republic of South Sudan',
        'nativeNames': {
          'eng': {
            'official': 'Republic of South Sudan',
            'common': 'South Sudan',
          },
        },
        'iso2': 'SS',
        'iso3': 'SSD',
        'phoneCode': '+211',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [7, 30],
        'capital': 'Juba',
        'currencies': {
          'SSP': {'name': 'South Sudanese pound', 'symbol': '\u00a3'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf8\ud83c\uddf8',
        'borders': ['CAF', 'COD', 'ETH', 'KEN', 'SDN', 'UGA'],
        'tld': '.ss',
        'area': 619745,
        'timezones': ['Africa/Juba'],
      },
      {
        'commonName': 'S\u00e3o Tom\u00e9 and Pr\u00edncipe',
        'officialName':
            'Democratic Republic of S\u00e3o Tom\u00e9 and Pr\u00edncipe',
        'nativeNames': {
          'por': {
            'official':
                'Rep\u00fablica Democr\u00e1tica do S\u00e3o Tom\u00e9 e Pr\u00edncipe',
            'common': 'S\u00e3o Tom\u00e9 e Pr\u00edncipe',
          },
        },
        'iso2': 'ST',
        'iso3': 'STP',
        'phoneCode': '+239',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [1, 7],
        'capital': 'S\u00e3o Tom\u00e9',
        'currencies': {
          'STN': {
            'name': 'S\u00e3o Tom\u00e9 and Pr\u00edncipe dobra',
            'symbol': 'Db',
          },
        },
        'languages': {'por': 'Portuguese'},
        'flag': '\ud83c\uddf8\ud83c\uddf9',
        'borders': <String>[],
        'tld': '.st',
        'area': 964,
        'timezones': ['Africa/Sao_Tome'],
      },
      {
        'commonName': 'Suriname',
        'officialName': 'Republic of Suriname',
        'nativeNames': {
          'nld': {'official': 'Republiek Suriname', 'common': 'Suriname'},
        },
        'iso2': 'SR',
        'iso3': 'SUR',
        'phoneCode': '+597',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [4, -56],
        'capital': 'Paramaribo',
        'currencies': {
          'SRD': {'name': 'Surinamese dollar', 'symbol': r'$'},
        },
        'languages': {'nld': 'Dutch'},
        'flag': '\ud83c\uddf8\ud83c\uddf7',
        'borders': ['BRA', 'GUF', 'GUY'],
        'tld': '.sr',
        'area': 163820,
        'timezones': ['America/Paramaribo'],
      },
      {
        'commonName': 'Slovakia',
        'officialName': 'Slovak Republic',
        'nativeNames': {
          'slk': {
            'official': 'Slovensk\u00e1 republika',
            'common': 'Slovensko',
          },
        },
        'iso2': 'SK',
        'iso3': 'SVK',
        'phoneCode': '+421',
        'region': 'Europe',
        'subregion': 'Central Europe',
        'latlng': [48.66666666, 19.5],
        'capital': 'Bratislava',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'slk': 'Slovak'},
        'flag': '\ud83c\uddf8\ud83c\uddf0',
        'borders': ['AUT', 'CZE', 'HUN', 'POL', 'UKR'],
        'tld': '.sk',
        'area': 49037,
        'timezones': ['Europe/Bratislava'],
      },
      {
        'commonName': 'Slovenia',
        'officialName': 'Republic of Slovenia',
        'nativeNames': {
          'slv': {'official': 'Republika Slovenija', 'common': 'Slovenija'},
        },
        'iso2': 'SI',
        'iso3': 'SVN',
        'phoneCode': '+386',
        'region': 'Europe',
        'subregion': 'Central Europe',
        'latlng': [46.11666666, 14.81666666],
        'capital': 'Ljubljana',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'slv': 'Slovene'},
        'flag': '\ud83c\uddf8\ud83c\uddee',
        'borders': ['AUT', 'HRV', 'ITA', 'HUN'],
        'tld': '.si',
        'area': 20273,
        'timezones': ['Europe/Ljubljana'],
      },
      {
        'commonName': 'Sweden',
        'officialName': 'Kingdom of Sweden',
        'nativeNames': {
          'swe': {'official': 'Konungariket Sverige', 'common': 'Sverige'},
        },
        'iso2': 'SE',
        'iso3': 'SWE',
        'phoneCode': '+46',
        'region': 'Europe',
        'subregion': 'Northern Europe',
        'latlng': [62, 15],
        'capital': 'Stockholm',
        'currencies': {
          'SEK': {'name': 'Swedish krona', 'symbol': 'kr'},
        },
        'languages': {'swe': 'Swedish'},
        'flag': '\ud83c\uddf8\ud83c\uddea',
        'borders': ['FIN', 'NOR'],
        'tld': '.se',
        'area': 450295,
        'timezones': ['Europe/Stockholm'],
      },
      {
        'commonName': 'Eswatini',
        'officialName': 'Kingdom of Eswatini',
        'nativeNames': {
          'eng': {'official': 'Kingdom of Eswatini', 'common': 'Eswatini'},
          'ssw': {'official': 'Umbuso weSwatini', 'common': 'eSwatini'},
        },
        'iso2': 'SZ',
        'iso3': 'SWZ',
        'phoneCode': '+268',
        'region': 'Africa',
        'subregion': 'Southern Africa',
        'latlng': [-26.5, 31.5],
        'capital': 'Lobamba',
        'currencies': {
          'SZL': {'name': 'Swazi lilangeni', 'symbol': 'L'},
          'ZAR': {'name': 'South African rand', 'symbol': 'R'},
        },
        'languages': {'eng': 'English', 'ssw': 'Swazi'},
        'flag': '\ud83c\uddf8\ud83c\uddff',
        'borders': ['MOZ', 'ZAF'],
        'tld': '.sz',
        'area': 17364,
        'timezones': ['Africa/Mbabane'],
      },
      {
        'commonName': 'Sint Maarten',
        'officialName': 'Sint Maarten',
        'nativeNames': {
          'eng': {'official': 'Sint Maarten', 'common': 'Sint Maarten'},
          'fra': {'official': 'Saint-Martin', 'common': 'Saint-Martin'},
          'nld': {'official': 'Sint Maarten', 'common': 'Sint Maarten'},
        },
        'iso2': 'SX',
        'iso3': 'SXM',
        'phoneCode': '+1-721',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.033333, -63.05],
        'capital': 'Philipsburg',
        'currencies': {
          'ANG': {'name': 'Netherlands Antillean guilder', 'symbol': '\u0192'},
        },
        'languages': {'eng': 'English', 'fra': 'French', 'nld': 'Dutch'},
        'flag': '\ud83c\uddf8\ud83c\uddfd',
        'borders': ['MAF'],
        'tld': '.sx',
        'area': 34,
        'timezones': ['America/Lower_Princes'],
      },
      {
        'commonName': 'Seychelles',
        'officialName': 'Republic of Seychelles',
        'nativeNames': {
          'crs': {'official': 'Repiblik Sesel', 'common': 'Sesel'},
          'eng': {'official': 'Republic of Seychelles', 'common': 'Seychelles'},
          'fra': {
            'official': 'R\u00e9publique des Seychelles',
            'common': 'Seychelles',
          },
        },
        'iso2': 'SC',
        'iso3': 'SYC',
        'phoneCode': '+248',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-4.58333333, 55.66666666],
        'capital': 'Victoria',
        'currencies': {
          'SCR': {'name': 'Seychellois rupee', 'symbol': '\u20a8'},
        },
        'languages': {
          'crs': 'Seychellois Creole',
          'eng': 'English',
          'fra': 'French',
        },
        'flag': '\ud83c\uddf8\ud83c\udde8',
        'borders': <String>[],
        'tld': '.sc',
        'area': 452,
        'timezones': ['Indian/Mahe'],
      },
      {
        'commonName': 'Syria',
        'officialName': 'Syrian Arab Republic',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0627\u0644\u0633\u0648\u0631\u064a\u0629',
            'common': '\u0633\u0648\u0631\u064a\u0627',
          },
        },
        'iso2': 'SY',
        'iso3': 'SYR',
        'phoneCode': '+963',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [35, 38],
        'capital': 'Damascus',
        'currencies': {
          'SYP': {'name': 'Syrian pound', 'symbol': '\u00a3'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf8\ud83c\uddfe',
        'borders': ['IRQ', 'ISR', 'JOR', 'LBN', 'TUR'],
        'tld': '.sy',
        'area': 185180,
        'timezones': ['Asia/Damascus'],
      },
      {
        'commonName': 'Turks and Caicos Islands',
        'officialName': 'Turks and Caicos Islands',
        'nativeNames': {
          'eng': {
            'official': 'Turks and Caicos Islands',
            'common': 'Turks and Caicos Islands',
          },
        },
        'iso2': 'TC',
        'iso3': 'TCA',
        'phoneCode': '+1649',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [21.75, -71.58333333],
        'capital': 'Cockburn Town',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf9\ud83c\udde8',
        'borders': <String>[],
        'tld': '.tc',
        'area': 948,
        'timezones': ['America/Grand_Turk'],
      },
      {
        'commonName': 'Chad',
        'officialName': 'Republic of Chad',
        'nativeNames': {
          'ara': {
            'official':
                '\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u062a\u0634\u0627\u062f',
            'common': '\u062a\u0634\u0627\u062f\u200e',
          },
          'fra': {'official': 'R\u00e9publique du Tchad', 'common': 'Tchad'},
        },
        'iso2': 'TD',
        'iso3': 'TCD',
        'phoneCode': '+235',
        'region': 'Africa',
        'subregion': 'Middle Africa',
        'latlng': [15, 19],
        'capital': "N'Djamena",
        'currencies': {
          'XAF': {'name': 'Central African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'ara': 'Arabic', 'fra': 'French'},
        'flag': '\ud83c\uddf9\ud83c\udde9',
        'borders': ['CMR', 'CAF', 'LBY', 'NER', 'NGA', 'SDN'],
        'tld': '.td',
        'area': 1284000,
        'timezones': ['Africa/Ndjamena'],
      },
      {
        'commonName': 'Togo',
        'officialName': 'Togolese Republic',
        'nativeNames': {
          'fra': {'official': 'R\u00e9publique togolaise', 'common': 'Togo'},
        },
        'iso2': 'TG',
        'iso3': 'TGO',
        'phoneCode': '+228',
        'region': 'Africa',
        'subregion': 'Western Africa',
        'latlng': [8, 1.16666666],
        'capital': 'Lom\u00e9',
        'currencies': {
          'XOF': {'name': 'West African CFA franc', 'symbol': 'Fr'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddf9\ud83c\uddec',
        'borders': ['BEN', 'BFA', 'GHA'],
        'tld': '.tg',
        'area': 56785,
        'timezones': ['Africa/Lome'],
      },
      {
        'commonName': 'Thailand',
        'officialName': 'Kingdom of Thailand',
        'nativeNames': {
          'tha': {
            'official':
                '\u0e23\u0e32\u0e0a\u0e2d\u0e32\u0e13\u0e32\u0e08\u0e31\u0e01\u0e23\u0e44\u0e17\u0e22',
            'common': '\u0e1b\u0e23\u0e30\u0e40\u0e17\u0e28\u0e44\u0e17\u0e22',
          },
        },
        'iso2': 'TH',
        'iso3': 'THA',
        'phoneCode': '+66',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [15, 100],
        'capital': 'Bangkok',
        'currencies': {
          'THB': {'name': 'Thai baht', 'symbol': '\u0e3f'},
        },
        'languages': {'tha': 'Thai'},
        'flag': '\ud83c\uddf9\ud83c\udded',
        'borders': ['MMR', 'KHM', 'LAO', 'MYS'],
        'tld': '.th',
        'area': 513120,
        'timezones': ['Asia/Bangkok'],
      },
      {
        'commonName': 'Tajikistan',
        'officialName': 'Republic of Tajikistan',
        'nativeNames': {
          'rus': {
            'official':
                '\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d',
            'common':
                '\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d',
          },
          'tgk': {
            'official':
                '\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0422\u043e\u04b7\u0438\u043a\u0438\u0441\u0442\u043e\u043d',
            'common':
                '\u0422\u043e\u04b7\u0438\u043a\u0438\u0441\u0442\u043e\u043d',
          },
        },
        'iso2': 'TJ',
        'iso3': 'TJK',
        'phoneCode': '+992',
        'region': 'Asia',
        'subregion': 'Central Asia',
        'latlng': [39, 71],
        'capital': 'Dushanbe',
        'currencies': {
          'TJS': {'name': 'Tajikistani somoni', 'symbol': '\u0405\u041c'},
        },
        'languages': {'rus': 'Russian', 'tgk': 'Tajik'},
        'flag': '\ud83c\uddf9\ud83c\uddef',
        'borders': ['AFG', 'CHN', 'KGZ', 'UZB'],
        'tld': '.tj',
        'area': 143100,
        'timezones': ['Asia/Dushanbe'],
      },
      {
        'commonName': 'Tokelau',
        'officialName': 'Tokelau',
        'nativeNames': {
          'eng': {'official': 'Tokelau', 'common': 'Tokelau'},
          'smo': {'official': 'Tokelau', 'common': 'Tokelau'},
          'tkl': {'official': 'Tokelau', 'common': 'Tokelau'},
        },
        'iso2': 'TK',
        'iso3': 'TKL',
        'phoneCode': '+690',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-9, -172],
        'capital': 'Fakaofo',
        'currencies': {
          'NZD': {'name': 'New Zealand dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'smo': 'Samoan', 'tkl': 'Tokelauan'},
        'flag': '\ud83c\uddf9\ud83c\uddf0',
        'borders': <String>[],
        'tld': '.tk',
        'area': 12,
        'timezones': ['Pacific/Fakaofo'],
      },
      {
        'commonName': 'Turkmenistan',
        'officialName': 'Turkmenistan',
        'nativeNames': {
          'rus': {
            'official':
                '\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d',
            'common': '\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u044f',
          },
          'tuk': {
            'official': 'T\u00fcrkmenistan',
            'common': 'T\u00fcrkmenistan',
          },
        },
        'iso2': 'TM',
        'iso3': 'TKM',
        'phoneCode': '+993',
        'region': 'Asia',
        'subregion': 'Central Asia',
        'latlng': [40, 60],
        'capital': 'Ashgabat',
        'currencies': {
          'TMT': {'name': 'Turkmenistan manat', 'symbol': 'm'},
        },
        'languages': {'rus': 'Russian', 'tuk': 'Turkmen'},
        'flag': '\ud83c\uddf9\ud83c\uddf2',
        'borders': ['AFG', 'IRN', 'KAZ', 'UZB'],
        'tld': '.tm',
        'area': 488100,
        'timezones': ['Asia/Ashgabat'],
      },
      {
        'commonName': 'Timor-Leste',
        'officialName': 'Democratic Republic of Timor-Leste',
        'nativeNames': {
          'por': {
            'official': 'Rep\u00fablica Democr\u00e1tica de Timor-Leste',
            'common': 'Timor-Leste',
          },
          'tet': {
            'official': 'Rep\u00fablika Demokr\u00e1tika Tim\u00f3r-Leste',
            'common': 'Tim\u00f3r-Leste',
          },
        },
        'iso2': 'TL',
        'iso3': 'TLS',
        'phoneCode': '+670',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [-8.83333333, 125.91666666],
        'capital': 'Dili',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'por': 'Portuguese', 'tet': 'Tetum'},
        'flag': '\ud83c\uddf9\ud83c\uddf1',
        'borders': ['IDN'],
        'tld': '.tl',
        'area': 14874,
        'timezones': ['Asia/Dili'],
      },
      {
        'commonName': 'Tonga',
        'officialName': 'Kingdom of Tonga',
        'nativeNames': {
          'eng': {'official': 'Kingdom of Tonga', 'common': 'Tonga'},
          'ton': {'official': 'Kingdom of Tonga', 'common': 'Tonga'},
        },
        'iso2': 'TO',
        'iso3': 'TON',
        'phoneCode': '+676',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-20, -175],
        'capital': "Nuku'alofa",
        'currencies': {
          'TOP': {'name': 'Tongan pa\u02bbanga', 'symbol': r'T$'},
        },
        'languages': {'eng': 'English', 'ton': 'Tongan'},
        'flag': '\ud83c\uddf9\ud83c\uddf4',
        'borders': <String>[],
        'tld': '.to',
        'area': 747,
        'timezones': ['Pacific/Tongatapu'],
      },
      {
        'commonName': 'Trinidad and Tobago',
        'officialName': 'Republic of Trinidad and Tobago',
        'nativeNames': {
          'eng': {
            'official': 'Republic of Trinidad and Tobago',
            'common': 'Trinidad and Tobago',
          },
        },
        'iso2': 'TT',
        'iso3': 'TTO',
        'phoneCode': '+1868',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [11, -61],
        'capital': 'Port of Spain',
        'currencies': {
          'TTD': {'name': 'Trinidad and Tobago dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddf9\ud83c\uddf9',
        'borders': <String>[],
        'tld': '.tt',
        'area': 5130,
        'timezones': ['America/Port_of_Spain'],
      },
      {
        'commonName': 'Tunisia',
        'officialName': 'Tunisian Republic',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u062a\u0648\u0646\u0633\u064a\u0629',
            'common': '\u062a\u0648\u0646\u0633',
          },
        },
        'iso2': 'TN',
        'iso3': 'TUN',
        'phoneCode': '+216',
        'region': 'Africa',
        'subregion': 'Northern Africa',
        'latlng': [34, 9],
        'capital': 'Tunis',
        'currencies': {
          'TND': {'name': 'Tunisian dinar', 'symbol': '\u062f.\u062a'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddf9\ud83c\uddf3',
        'borders': ['DZA', 'LBY'],
        'tld': '.tn',
        'area': 163610,
        'timezones': ['Africa/Tunis'],
      },
      {
        'commonName': 'Turkey',
        'officialName': 'Republic of T\u00fcrkiye',
        'nativeNames': {
          'tur': {
            'official': 'T\u00fcrkiye Cumhuriyeti',
            'common': 'T\u00fcrkiye',
          },
        },
        'iso2': 'TR',
        'iso3': 'TUR',
        'phoneCode': '+90',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [39, 35],
        'capital': 'Ankara',
        'currencies': {
          'TRY': {'name': 'Turkish lira', 'symbol': '\u20ba'},
        },
        'languages': {'tur': 'Turkish'},
        'flag': '\ud83c\uddf9\ud83c\uddf7',
        'borders': ['ARM', 'AZE', 'BGR', 'GEO', 'GRC', 'IRN', 'IRQ', 'SYR'],
        'tld': '.tr',
        'area': 783562,
        'timezones': ['Europe/Istanbul'],
      },
      {
        'commonName': 'Tuvalu',
        'officialName': 'Tuvalu',
        'nativeNames': {
          'eng': {'official': 'Tuvalu', 'common': 'Tuvalu'},
          'tvl': {'official': 'Tuvalu', 'common': 'Tuvalu'},
        },
        'iso2': 'TV',
        'iso3': 'TUV',
        'phoneCode': '+688',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-8, 178],
        'capital': 'Funafuti',
        'currencies': {
          'AUD': {'name': 'Australian dollar', 'symbol': r'$'},
          'TVD': {'name': 'Tuvaluan dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English', 'tvl': 'Tuvaluan'},
        'flag': '\ud83c\uddf9\ud83c\uddfb',
        'borders': <String>[],
        'tld': '.tv',
        'area': 26,
        'timezones': ['Pacific/Funafuti'],
      },
      {
        'commonName': 'Taiwan',
        'officialName': 'Republic of China (Taiwan)',
        'nativeNames': {
          'zho': {
            'official': '\u4e2d\u83ef\u6c11\u570b',
            'common': '\u53f0\u7063',
          },
        },
        'iso2': 'TW',
        'iso3': 'TWN',
        'phoneCode': '+886',
        'region': 'Asia',
        'subregion': 'Eastern Asia',
        'latlng': [23.5, 121],
        'capital': 'Taipei',
        'currencies': {
          'TWD': {'name': 'New Taiwan dollar', 'symbol': r'$'},
        },
        'languages': {'zho': 'Chinese'},
        'flag': '\ud83c\uddf9\ud83c\uddfc',
        'borders': <String>[],
        'tld': '.tw',
        'area': 36193,
        'timezones': ['Asia/Taipei'],
      },
      {
        'commonName': 'Tanzania',
        'officialName': 'United Republic of Tanzania',
        'nativeNames': {
          'eng': {
            'official': 'United Republic of Tanzania',
            'common': 'Tanzania',
          },
          'swa': {
            'official': 'Jamhuri ya Muungano wa Tanzania',
            'common': 'Tanzania',
          },
        },
        'iso2': 'TZ',
        'iso3': 'TZA',
        'phoneCode': '+255',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-6, 35],
        'capital': 'Dodoma',
        'currencies': {
          'TZS': {'name': 'Tanzanian shilling', 'symbol': 'Sh'},
        },
        'languages': {'eng': 'English', 'swa': 'Swahili'},
        'flag': '\ud83c\uddf9\ud83c\uddff',
        'borders': ['BDI', 'COD', 'KEN', 'MWI', 'MOZ', 'RWA', 'UGA', 'ZMB'],
        'tld': '.tz',
        'area': 945087,
        'timezones': ['Africa/Dar_es_Salaam'],
      },
      {
        'commonName': 'Uganda',
        'officialName': 'Republic of Uganda',
        'nativeNames': {
          'eng': {'official': 'Republic of Uganda', 'common': 'Uganda'},
          'swa': {'official': 'Republic of Uganda', 'common': 'Uganda'},
        },
        'iso2': 'UG',
        'iso3': 'UGA',
        'phoneCode': '+256',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [1, 32],
        'capital': 'Kampala',
        'currencies': {
          'UGX': {'name': 'Ugandan shilling', 'symbol': 'Sh'},
        },
        'languages': {'eng': 'English', 'swa': 'Swahili'},
        'flag': '\ud83c\uddfa\ud83c\uddec',
        'borders': ['COD', 'KEN', 'RWA', 'SSD', 'TZA'],
        'tld': '.ug',
        'area': 241550,
        'timezones': ['Africa/Kampala'],
      },
      {
        'commonName': 'Ukraine',
        'officialName': 'Ukraine',
        'nativeNames': {
          'ukr': {
            'official': '\u0423\u043a\u0440\u0430\u0457\u043d\u0430',
            'common': '\u0423\u043a\u0440\u0430\u0457\u043d\u0430',
          },
        },
        'iso2': 'UA',
        'iso3': 'UKR',
        'phoneCode': '+380',
        'region': 'Europe',
        'subregion': 'Eastern Europe',
        'latlng': [49, 32],
        'capital': 'Kyiv',
        'currencies': {
          'UAH': {'name': 'Ukrainian hryvnia', 'symbol': '\u20b4'},
        },
        'languages': {'ukr': 'Ukrainian'},
        'flag': '\ud83c\uddfa\ud83c\udde6',
        'borders': ['BLR', 'HUN', 'MDA', 'POL', 'ROU', 'RUS', 'SVK'],
        'tld': '.ua',
        'area': 603500,
        'timezones': ['Europe/Kiev', 'Europe/Uzhgorod', 'Europe/Zaporozhye'],
      },
      {
        'commonName': 'United States Minor Outlying Islands',
        'officialName': 'United States Minor Outlying Islands',
        'nativeNames': {
          'eng': {
            'official': 'United States Minor Outlying Islands',
            'common': 'United States Minor Outlying Islands',
          },
        },
        'iso2': 'UM',
        'iso3': 'UMI',
        'phoneCode': '+1',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [19.3, 166.633333],
        'capital': null,
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddfa\ud83c\uddf2',
        'borders': <String>[],
        'tld': '.us',
        'area': 34.2,
        'timezones': ['Pacific/Johnston', 'Pacific/Midway', 'Pacific/Wake'],
      },
      {
        'commonName': 'Uruguay',
        'officialName': 'Oriental Republic of Uruguay',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica Oriental del Uruguay',
            'common': 'Uruguay',
          },
        },
        'iso2': 'UY',
        'iso3': 'URY',
        'phoneCode': '+598',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [-33, -56],
        'capital': 'Montevideo',
        'currencies': {
          'UYU': {'name': 'Uruguayan peso', 'symbol': r'$'},
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddfa\ud83c\uddfe',
        'borders': ['ARG', 'BRA'],
        'tld': '.uy',
        'area': 181034,
        'timezones': ['America/Montevideo'],
      },
      {
        'commonName': 'United States',
        'officialName': 'United States of America',
        'nativeNames': {
          'eng': {
            'official': 'United States of America',
            'common': 'United States',
          },
        },
        'iso2': 'US',
        'iso3': 'USA',
        'phoneCode': '+1',
        'region': 'Americas',
        'subregion': 'North America',
        'latlng': [38, -97],
        'capital': 'Washington D.C.',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddfa\ud83c\uddf8',
        'borders': ['CAN', 'MEX'],
        'tld': '.us',
        'area': 9372610,
        'timezones': [
          'America/New_York',
          'America/Detroit',
          'America/Kentucky/Louisville',
          'America/Kentucky/Monticello',
          'America/Indiana/Indianapolis',
          'America/Indiana/Vincennes',
          'America/Indiana/Winamac',
          'America/Indiana/Marengo',
          'America/Indiana/Petersburg',
          'America/Indiana/Vevay',
          'America/Chicago',
          'America/Indiana/Tell_City',
          'America/Indiana/Knox',
          'America/Menominee',
          'America/North_Dakota/Center',
          'America/North_Dakota/New_Salem',
          'America/North_Dakota/Beulah',
          'America/Denver',
          'America/Boise',
          'America/Phoenix',
          'America/Los_Angeles',
          'America/Anchorage',
          'America/Juneau',
          'America/Sitka',
          'America/Metlakatla',
          'America/Yakutat',
          'America/Nome',
          'America/Adak',
          'Pacific/Honolulu',
        ],
      },
      {
        'commonName': 'Uzbekistan',
        'officialName': 'Republic of Uzbekistan',
        'nativeNames': {
          'rus': {
            'official':
                '\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d',
            'common':
                '\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d',
          },
          'uzb': {
            'official': "O'zbekiston Respublikasi",
            'common': 'O\u2018zbekiston',
          },
        },
        'iso2': 'UZ',
        'iso3': 'UZB',
        'phoneCode': '+998',
        'region': 'Asia',
        'subregion': 'Central Asia',
        'latlng': [41, 64],
        'capital': 'Tashkent',
        'currencies': {
          'UZS': {'name': 'Uzbekistani so\u02bbm', 'symbol': "so'm"},
        },
        'languages': {'rus': 'Russian', 'uzb': 'Uzbek'},
        'flag': '\ud83c\uddfa\ud83c\uddff',
        'borders': ['AFG', 'KAZ', 'KGZ', 'TJK', 'TKM'],
        'tld': '.uz',
        'area': 447400,
        'timezones': ['Asia/Samarkand', 'Asia/Tashkent'],
      },
      {
        'commonName': 'Vatican City',
        'officialName': 'Vatican City State',
        'nativeNames': {
          'ita': {
            'official': 'Stato della Citt\u00e0 del Vaticano',
            'common': 'Vaticano',
          },
          'lat': {
            'official': 'Status Civitatis Vatican\u00e6',
            'common': 'Vatican\u00e6',
          },
        },
        'iso2': 'VA',
        'iso3': 'VAT',
        'phoneCode': '+39',
        'region': 'Europe',
        'subregion': 'Southern Europe',
        'latlng': [41.9, 12.45],
        'capital': 'Vatican City',
        'currencies': {
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
        },
        'languages': {'ita': 'Italian', 'lat': 'Latin'},
        'flag': '\ud83c\uddfb\ud83c\udde6',
        'borders': ['ITA'],
        'tld': '.va',
        'area': 0.44,
        'timezones': ['Europe/Vatican'],
      },
      {
        'commonName': 'Saint Vincent and the Grenadines',
        'officialName': 'Saint Vincent and the Grenadines',
        'nativeNames': {
          'eng': {
            'official': 'Saint Vincent and the Grenadines',
            'common': 'Saint Vincent and the Grenadines',
          },
        },
        'iso2': 'VC',
        'iso3': 'VCT',
        'phoneCode': '+1784',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [13.25, -61.2],
        'capital': 'Kingstown',
        'currencies': {
          'XCD': {'name': 'Eastern Caribbean dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddfb\ud83c\udde8',
        'borders': <String>[],
        'tld': '.vc',
        'area': 389,
        'timezones': ['America/St_Vincent'],
      },
      {
        'commonName': 'Venezuela',
        'officialName': 'Bolivarian Republic of Venezuela',
        'nativeNames': {
          'spa': {
            'official': 'Rep\u00fablica Bolivariana de Venezuela',
            'common': 'Venezuela',
          },
        },
        'iso2': 'VE',
        'iso3': 'VEN',
        'phoneCode': '+58',
        'region': 'Americas',
        'subregion': 'South America',
        'latlng': [8, -66],
        'capital': 'Caracas',
        'currencies': {
          'VES': {
            'name': 'Venezuelan bol\u00edvar soberano',
            'symbol': 'Bs.S.',
          },
        },
        'languages': {'spa': 'Spanish'},
        'flag': '\ud83c\uddfb\ud83c\uddea',
        'borders': ['BRA', 'COL', 'GUY'],
        'tld': '.ve',
        'area': 916445,
        'timezones': ['America/Caracas'],
      },
      {
        'commonName': 'British Virgin Islands',
        'officialName': 'Virgin Islands',
        'nativeNames': {
          'eng': {
            'official': 'Virgin Islands',
            'common': 'British Virgin Islands',
          },
        },
        'iso2': 'VG',
        'iso3': 'VGB',
        'phoneCode': '+1284',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.431383, -64.62305],
        'capital': 'Road Town',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddfb\ud83c\uddec',
        'borders': <String>[],
        'tld': '.vg',
        'area': 151,
        'timezones': ['America/Tortola'],
      },
      {
        'commonName': 'United States Virgin Islands',
        'officialName': 'Virgin Islands of the United States',
        'nativeNames': {
          'eng': {
            'official': 'Virgin Islands of the United States',
            'common': 'United States Virgin Islands',
          },
        },
        'iso2': 'VI',
        'iso3': 'VIR',
        'phoneCode': '+1340',
        'region': 'Americas',
        'subregion': 'Caribbean',
        'latlng': [18.35, -64.933333],
        'capital': 'Charlotte Amalie',
        'currencies': {
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddfb\ud83c\uddee',
        'borders': <String>[],
        'tld': '.vi',
        'area': 347,
        'timezones': ['America/St_Thomas'],
      },
      {
        'commonName': 'Vietnam',
        'officialName': 'Socialist Republic of Vietnam',
        'nativeNames': {
          'vie': {
            'official':
                'C\u1ed9ng h\u00f2a x\u00e3 h\u1ed9i ch\u1ee7 ngh\u0129a Vi\u1ec7t Nam',
            'common': 'Vi\u1ec7t Nam',
          },
        },
        'iso2': 'VN',
        'iso3': 'VNM',
        'phoneCode': '+84',
        'region': 'Asia',
        'subregion': 'South-Eastern Asia',
        'latlng': [16.16666666, 107.83333333],
        'capital': 'Hanoi',
        'currencies': {
          'VND': {'name': 'Vietnamese \u0111\u1ed3ng', 'symbol': '\u20ab'},
        },
        'languages': {'vie': 'Vietnamese'},
        'flag': '\ud83c\uddfb\ud83c\uddf3',
        'borders': ['KHM', 'CHN', 'LAO'],
        'tld': '.vn',
        'area': 331212,
        'timezones': ['Asia/Ho_Chi_Minh'],
      },
      {
        'commonName': 'Vanuatu',
        'officialName': 'Republic of Vanuatu',
        'nativeNames': {
          'bis': {'official': 'Ripablik blong Vanuatu', 'common': 'Vanuatu'},
          'eng': {'official': 'Republic of Vanuatu', 'common': 'Vanuatu'},
          'fra': {
            'official': 'R\u00e9publique de Vanuatu',
            'common': 'Vanuatu',
          },
        },
        'iso2': 'VU',
        'iso3': 'VUT',
        'phoneCode': '+678',
        'region': 'Oceania',
        'subregion': 'Melanesia',
        'latlng': [-16, 167],
        'capital': 'Port Vila',
        'currencies': {
          'VUV': {'name': 'Vanuatu vatu', 'symbol': 'Vt'},
        },
        'languages': {'bis': 'Bislama', 'eng': 'English', 'fra': 'French'},
        'flag': '\ud83c\uddfb\ud83c\uddfa',
        'borders': <String>[],
        'tld': '.vu',
        'area': 12189,
        'timezones': ['Pacific/Efate'],
      },
      {
        'commonName': 'Wallis and Futuna',
        'officialName': 'Territory of the Wallis and Futuna Islands',
        'nativeNames': {
          'fra': {
            'official': 'Territoire des \u00eeles Wallis et Futuna',
            'common': 'Wallis et Futuna',
          },
        },
        'iso2': 'WF',
        'iso3': 'WLF',
        'phoneCode': '+681',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-13.3, -176.2],
        'capital': 'Mata-Utu',
        'currencies': {
          'XPF': {'name': 'CFP franc', 'symbol': '\u20a3'},
        },
        'languages': {'fra': 'French'},
        'flag': '\ud83c\uddfc\ud83c\uddeb',
        'borders': <String>[],
        'tld': '.wf',
        'area': 142,
        'timezones': ['Pacific/Wallis'],
      },
      {
        'commonName': 'Samoa',
        'officialName': 'Independent State of Samoa',
        'nativeNames': {
          'eng': {'official': 'Independent State of Samoa', 'common': 'Samoa'},
          'smo': {
            'official': 'Malo Sa\u02bboloto Tuto\u02bbatasi o S\u0101moa',
            'common': 'S\u0101moa',
          },
        },
        'iso2': 'WS',
        'iso3': 'WSM',
        'phoneCode': '+685',
        'region': 'Oceania',
        'subregion': 'Polynesia',
        'latlng': [-13.58333333, -172.33333333],
        'capital': 'Apia',
        'currencies': {
          'WST': {'name': 'Samoan t\u0101l\u0101', 'symbol': 'T'},
        },
        'languages': {'eng': 'English', 'smo': 'Samoan'},
        'flag': '\ud83c\uddfc\ud83c\uddf8',
        'borders': <String>[],
        'tld': '.ws',
        'area': 2842,
        'timezones': ['Pacific/Apia'],
      },
      {
        'commonName': 'Yemen',
        'officialName': 'Republic of Yemen',
        'nativeNames': {
          'ara': {
            'official':
                '\u0627\u0644\u062c\u0645\u0647\u0648\u0631\u064a\u0629 \u0627\u0644\u064a\u0645\u0646\u064a\u0629',
            'common': '\u0627\u0644\u064a\u064e\u0645\u064e\u0646',
          },
        },
        'iso2': 'YE',
        'iso3': 'YEM',
        'phoneCode': '+967',
        'region': 'Asia',
        'subregion': 'Western Asia',
        'latlng': [15, 48],
        'capital': "Sana'a",
        'currencies': {
          'YER': {'name': 'Yemeni rial', 'symbol': '\ufdfc'},
        },
        'languages': {'ara': 'Arabic'},
        'flag': '\ud83c\uddfe\ud83c\uddea',
        'borders': ['OMN', 'SAU'],
        'tld': '.ye',
        'area': 527968,
        'timezones': ['Asia/Aden'],
      },
      {
        'commonName': 'South Africa',
        'officialName': 'Republic of South Africa',
        'nativeNames': {
          'afr': {
            'official': 'Republiek van Suid-Afrika',
            'common': 'South Africa',
          },
          'eng': {
            'official': 'Republic of South Africa',
            'common': 'South Africa',
          },
          'nbl': {
            'official': 'IRiphabliki yeSewula Afrika',
            'common': 'Sewula Afrika',
          },
          'nso': {
            'official': 'Rephaboliki ya Afrika-Borwa ',
            'common': 'Afrika-Borwa',
          },
          'sot': {
            'official': 'Rephaboliki ya Afrika Borwa',
            'common': 'Afrika Borwa',
          },
          'ssw': {
            'official': 'IRiphabhulikhi yeNingizimu Afrika',
            'common': 'Ningizimu Afrika',
          },
          'tsn': {
            'official': 'Rephaboliki ya Aforika Borwa',
            'common': 'Aforika Borwa',
          },
          'tso': {
            'official': 'Riphabliki ra Afrika Dzonga',
            'common': 'Afrika Dzonga',
          },
          'ven': {
            'official': 'Riphabu\u1e3diki ya Afurika Tshipembe',
            'common': 'Afurika Tshipembe',
          },
          'xho': {
            'official': 'IRiphabliki yaseMzantsi Afrika',
            'common': 'Mzantsi Afrika',
          },
          'zul': {
            'official': 'IRiphabliki yaseNingizimu Afrika',
            'common': 'Ningizimu Afrika',
          },
        },
        'iso2': 'ZA',
        'iso3': 'ZAF',
        'phoneCode': '+27',
        'region': 'Africa',
        'subregion': 'Southern Africa',
        'latlng': [-29, 24],
        'capital': 'Pretoria',
        'currencies': {
          'ZAR': {'name': 'South African rand', 'symbol': 'R'},
        },
        'languages': {
          'afr': 'Afrikaans',
          'eng': 'English',
          'nbl': 'Southern Ndebele',
          'nso': 'Northern Sotho',
          'sot': 'Southern Sotho',
          'ssw': 'Swazi',
          'tsn': 'Tswana',
          'tso': 'Tsonga',
          'ven': 'Venda',
          'xho': 'Xhosa',
          'zul': 'Zulu',
        },
        'flag': '\ud83c\uddff\ud83c\udde6',
        'borders': ['BWA', 'LSO', 'MOZ', 'NAM', 'SWZ', 'ZWE'],
        'tld': '.za',
        'area': 1221037,
        'timezones': ['Africa/Johannesburg'],
      },
      {
        'commonName': 'Zambia',
        'officialName': 'Republic of Zambia',
        'nativeNames': {
          'eng': {'official': 'Republic of Zambia', 'common': 'Zambia'},
        },
        'iso2': 'ZM',
        'iso3': 'ZMB',
        'phoneCode': '+260',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-15, 30],
        'capital': 'Lusaka',
        'currencies': {
          'ZMW': {'name': 'Zambian kwacha', 'symbol': 'ZK'},
        },
        'languages': {'eng': 'English'},
        'flag': '\ud83c\uddff\ud83c\uddf2',
        'borders': ['AGO', 'BWA', 'COD', 'MWI', 'MOZ', 'NAM', 'TZA', 'ZWE'],
        'tld': '.zm',
        'area': 752612,
        'timezones': ['Africa/Lusaka'],
      },
      {
        'commonName': 'Zimbabwe',
        'officialName': 'Republic of Zimbabwe',
        'nativeNames': {
          'bwg': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'eng': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'kck': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'khi': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'ndc': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'nde': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'nya': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'sna': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'sot': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'toi': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'tsn': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'tso': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'ven': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'xho': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
          'zib': {'official': 'Republic of Zimbabwe', 'common': 'Zimbabwe'},
        },
        'iso2': 'ZW',
        'iso3': 'ZWE',
        'phoneCode': '+263',
        'region': 'Africa',
        'subregion': 'Eastern Africa',
        'latlng': [-20, 30],
        'capital': 'Harare',
        'currencies': {
          'BWP': {'name': 'Botswana pula', 'symbol': 'P'},
          'CNY': {'name': 'Chinese yuan', 'symbol': '\u00a5'},
          'EUR': {'name': 'Euro', 'symbol': '\u20ac'},
          'GBP': {'name': 'British pound', 'symbol': '\u00a3'},
          'INR': {'name': 'Indian rupee', 'symbol': '\u20b9'},
          'JPY': {'name': 'Japanese yen', 'symbol': '\u00a5'},
          'USD': {'name': 'United States dollar', 'symbol': r'$'},
          'ZAR': {'name': 'South African rand', 'symbol': 'Rs'},
          'ZWB': {'name': 'Zimbabwean bonds', 'symbol': r'$'},
        },
        'languages': {
          'bwg': 'Chibarwe',
          'eng': 'English',
          'kck': 'Kalanga',
          'khi': 'Khoisan',
          'ndc': 'Ndau',
          'nde': 'Northern Ndebele',
          'nya': 'Chewa',
          'sna': 'Shona',
          'sot': 'Sotho',
          'toi': 'Tonga',
          'tsn': 'Tswana',
          'tso': 'Tsonga',
          'ven': 'Venda',
          'xho': 'Xhosa',
          'zib': 'Zimbabwean Sign Language',
        },
        'flag': '\ud83c\uddff\ud83c\uddfc',
        'borders': ['BWA', 'MOZ', 'ZAF', 'ZMB'],
        'tld': '.zw',
        'area': 390757,
        'timezones': ['Africa/Harare'],
      }
    ];
