// Autogenerated from Pigeon (v25.5.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
@file:Suppress("UNCHECKED_CAST", "ArrayInDataClass")

package com.talesbarreto.uri_content

import android.util.Log
import io.flutter.plugin.common.BasicMessageChannel
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.EventChannel
import io.flutter.plugin.common.MessageCodec
import io.flutter.plugin.common.StandardMethodCodec
import io.flutter.plugin.common.StandardMessageCodec
import java.io.ByteArrayOutputStream
import java.nio.ByteBuffer
private object UriContentPlatformApiPigeonUtils {

  fun wrapResult(result: Any?): List<Any?> {
    return listOf(result)
  }

  fun wrapError(exception: Throwable): List<Any?> {
    return if (exception is FlutterError) {
      listOf(
        exception.code,
        exception.message,
        exception.details
      )
    } else {
      listOf(
        exception.javaClass.simpleName,
        exception.toString(),
        "Cause: " + exception.cause + ", Stacktrace: " + Log.getStackTraceString(exception)
      )
    }
  }
  fun deepEquals(a: Any?, b: Any?): Boolean {
    if (a is ByteArray && b is ByteArray) {
        return a.contentEquals(b)
    }
    if (a is IntArray && b is IntArray) {
        return a.contentEquals(b)
    }
    if (a is LongArray && b is LongArray) {
        return a.contentEquals(b)
    }
    if (a is DoubleArray && b is DoubleArray) {
        return a.contentEquals(b)
    }
    if (a is Array<*> && b is Array<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is List<*> && b is List<*>) {
      return a.size == b.size &&
          a.indices.all{ deepEquals(a[it], b[it]) }
    }
    if (a is Map<*, *> && b is Map<*, *>) {
      return a.size == b.size && a.all {
          (b as Map<Any?, Any?>).containsKey(it.key) &&
          deepEquals(it.value, b[it.key])
      }
    }
    return a == b
  }
      
}

/**
 * Error class for passing custom error details to Flutter via a thrown PlatformException.
 * @property code The error code.
 * @property message The error message.
 * @property details The error details. Must be a datatype supported by the api codec.
 */
class FlutterError (
  val code: String,
  override val message: String? = null,
  val details: Any? = null
) : Throwable()

/** Generated class from Pigeon that represents data sent in messages. */
data class UriContentChunkResult (
  val chunk: ByteArray? = null,
  val done: Boolean,
  val error: String? = null
)
 {
  companion object {
    fun fromList(pigeonVar_list: List<Any?>): UriContentChunkResult {
      val chunk = pigeonVar_list[0] as ByteArray?
      val done = pigeonVar_list[1] as Boolean
      val error = pigeonVar_list[2] as String?
      return UriContentChunkResult(chunk, done, error)
    }
  }
  fun toList(): List<Any?> {
    return listOf(
      chunk,
      done,
      error,
    )
  }
  override fun equals(other: Any?): Boolean {
    if (other !is UriContentChunkResult) {
      return false
    }
    if (this === other) {
      return true
    }
    return UriContentPlatformApiPigeonUtils.deepEquals(toList(), other.toList())  }

  override fun hashCode(): Int = toList().hashCode()
}
private open class UriContentPlatformApiPigeonCodec : StandardMessageCodec() {
  override fun readValueOfType(type: Byte, buffer: ByteBuffer): Any? {
    return when (type) {
      129.toByte() -> {
        return (readValue(buffer) as? List<Any?>)?.let {
          UriContentChunkResult.fromList(it)
        }
      }
      else -> super.readValueOfType(type, buffer)
    }
  }
  override fun writeValue(stream: ByteArrayOutputStream, value: Any?)   {
    when (value) {
      is UriContentChunkResult -> {
        stream.write(129)
        writeValue(stream, value.toList())
      }
      else -> super.writeValue(stream, value)
    }
  }
}


/** Generated interface from Pigeon that represents a handler of messages from Flutter. */
interface UriContentPlatformApi {
  fun registerRequest(url: String, requestId: Long, bufferSize: Long, callback: (Result<Unit>) -> Unit)
  fun requestNextChunk(requestId: Long, callback: (Result<UriContentChunkResult>) -> Unit)
  fun cancelRequest(requestId: Long)
  fun getContentLength(url: String, callback: (Result<Long?>) -> Unit)
  fun exists(url: String, callback: (Result<Boolean>) -> Unit)

  companion object {
    /** The codec used by UriContentPlatformApi. */
    val codec: MessageCodec<Any?> by lazy {
      UriContentPlatformApiPigeonCodec()
    }
    /** Sets up an instance of `UriContentPlatformApi` to handle messages through the `binaryMessenger`. */
    @JvmOverloads
    fun setUp(binaryMessenger: BinaryMessenger, api: UriContentPlatformApi?, messageChannelSuffix: String = "") {
      val separatedMessageChannelSuffix = if (messageChannelSuffix.isNotEmpty()) ".$messageChannelSuffix" else ""
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.uri_content.UriContentPlatformApi.registerRequest$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            val requestIdArg = args[1] as Long
            val bufferSizeArg = args[2] as Long
            api.registerRequest(urlArg, requestIdArg, bufferSizeArg) { result: Result<Unit> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(UriContentPlatformApiPigeonUtils.wrapError(error))
              } else {
                reply.reply(UriContentPlatformApiPigeonUtils.wrapResult(null))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.uri_content.UriContentPlatformApi.requestNextChunk$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestIdArg = args[0] as Long
            api.requestNextChunk(requestIdArg) { result: Result<UriContentChunkResult> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(UriContentPlatformApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(UriContentPlatformApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.uri_content.UriContentPlatformApi.cancelRequest$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val requestIdArg = args[0] as Long
            val wrapped: List<Any?> = try {
              api.cancelRequest(requestIdArg)
              listOf(null)
            } catch (exception: Throwable) {
              UriContentPlatformApiPigeonUtils.wrapError(exception)
            }
            reply.reply(wrapped)
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.uri_content.UriContentPlatformApi.getContentLength$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            api.getContentLength(urlArg) { result: Result<Long?> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(UriContentPlatformApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(UriContentPlatformApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
      run {
        val channel = BasicMessageChannel<Any?>(binaryMessenger, "dev.flutter.pigeon.uri_content.UriContentPlatformApi.exists$separatedMessageChannelSuffix", codec)
        if (api != null) {
          channel.setMessageHandler { message, reply ->
            val args = message as List<Any?>
            val urlArg = args[0] as String
            api.exists(urlArg) { result: Result<Boolean> ->
              val error = result.exceptionOrNull()
              if (error != null) {
                reply.reply(UriContentPlatformApiPigeonUtils.wrapError(error))
              } else {
                val data = result.getOrNull()
                reply.reply(UriContentPlatformApiPigeonUtils.wrapResult(data))
              }
            }
          }
        } else {
          channel.setMessageHandler(null)
        }
      }
    }
  }
}
