import "../../iso_codes/iso_code.dart";
import "../models/phone_metadata_lengths.dart";

const metadataLenghtsByIsoCode = {
  IsoCode.AC: PhoneMetadataLengths(
    general: [],
    mobile: [5],
    fixedLine: [5],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [6],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AD: PhoneMetadataLengths(
    general: [],
    mobile: [6, 9],
    fixedLine: [6],
    voip: [],
    tollFree: [8],
    premiumRate: [6],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [5, 6, 7, 8, 9, 10, 11, 12],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AF: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AG: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.AI: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.AL: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [7],
    premiumRate: [6],
    sharedCost: [6],
    personalNumber: [8],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AM: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AO: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AR: PhoneMetadataLengths(
    general: [],
    mobile: [10, 11],
    fixedLine: [10],
    voip: [],
    tollFree: [10, 11],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AS: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AT: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8, 9, 10, 11, 12, 13],
    fixedLine: [4, 5, 6, 7, 8, 9, 10, 11, 12, 13],
    voip: [5, 6, 7, 8, 9, 10, 11, 12, 13],
    tollFree: [9, 10, 11, 12, 13],
    premiumRate: [9, 10, 11, 12, 13],
    sharedCost: [8, 9, 10, 11, 12, 13],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AU: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [7, 10],
    premiumRate: [10],
    sharedCost: [6, 8, 10, 12],
    personalNumber: [],
    uan: [],
    pager: [5, 6, 7, 8, 9],
    voiceMail: [],
  ),
  IsoCode.AW: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [7],
    tollFree: [7],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AX: PhoneMetadataLengths(
    general: [],
    mobile: [6, 7, 8, 9, 10],
    fixedLine: [6, 7, 8, 9],
    voip: [],
    tollFree: [7, 8, 9],
    premiumRate: [8, 9],
    sharedCost: [],
    personalNumber: [],
    uan: [5, 6, 7, 8, 9, 10, 11, 12],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.AZ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BA: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BB: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BD: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [6, 7, 8, 9, 10],
    voip: [10],
    tollFree: [10],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BF: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BG: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9],
    fixedLine: [6, 7, 8],
    voip: [],
    tollFree: [8, 12],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BH: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BI: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BJ: PhoneMetadataLengths(
    general: [],
    mobile: [8, 10],
    fixedLine: [8, 10],
    voip: [8],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BL: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BM: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BN: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [7],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BO: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BQ: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BR: PhoneMetadataLengths(
    general: [],
    mobile: [10, 11],
    fixedLine: [10],
    voip: [],
    tollFree: [9, 10],
    premiumRate: [9, 10],
    sharedCost: [8, 10],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BS: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BT: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BW: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [7],
    voip: [8],
    tollFree: [10],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BY: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [6, 7, 8, 9, 10, 11],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.BZ: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CA: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [7],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CC: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [7, 10],
    premiumRate: [10],
    sharedCost: [6, 8, 10, 12],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CD: PhoneMetadataLengths(
    general: [],
    mobile: [7, 9],
    fixedLine: [7, 8, 9, 10],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CF: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CG: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CH: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [9],
    uan: [9],
    pager: [9],
    voiceMail: [12],
  ),
  IsoCode.CI: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CK: PhoneMetadataLengths(
    general: [],
    mobile: [5],
    fixedLine: [5],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CL: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9, 11],
    premiumRate: [],
    sharedCost: [10, 11],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CM: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [8, 9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CN: PhoneMetadataLengths(
    general: [],
    mobile: [11],
    fixedLine: [7, 8, 9, 10, 11],
    voip: [],
    tollFree: [10, 12],
    premiumRate: [8],
    sharedCost: [7, 8, 9, 10, 11],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CO: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8, 10],
    voip: [],
    tollFree: [11],
    premiumRate: [10, 11],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CR: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CU: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [6, 7, 8, 10],
    voip: [],
    tollFree: [10],
    premiumRate: [],
    sharedCost: [10],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CV: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [7],
    tollFree: [7],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CW: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8],
    fixedLine: [7, 8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [7],
    personalNumber: [],
    uan: [],
    pager: [8],
    voiceMail: [],
  ),
  IsoCode.CX: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [7, 10],
    premiumRate: [10],
    sharedCost: [6, 8, 10, 12],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CY: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [8],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.CZ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [9],
    uan: [9],
    pager: [],
    voiceMail: [9, 10, 11, 12],
  ),
  IsoCode.DE: PhoneMetadataLengths(
    general: [],
    mobile: [10, 11],
    fixedLine: [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
    voip: [],
    tollFree: [10, 11, 12, 13, 14, 15],
    premiumRate: [10, 11],
    sharedCost: [7, 8, 9, 10, 11, 12, 13, 14],
    personalNumber: [11],
    uan: [8, 9, 10, 11, 12, 13, 14],
    pager: [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14],
    voiceMail: [12, 13],
  ),
  IsoCode.DJ: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.DK: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.DM: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.DO: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.DZ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8, 9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.EC: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [8],
    tollFree: [10, 11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.EE: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8],
    fixedLine: [7],
    voip: [],
    tollFree: [7, 8, 10],
    premiumRate: [7, 8],
    sharedCost: [],
    personalNumber: [8],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.EG: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8, 9],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.EH: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ER: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ES: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [9],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ET: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.FI: PhoneMetadataLengths(
    general: [],
    mobile: [6, 7, 8, 9, 10],
    fixedLine: [5, 6, 7, 8, 9],
    voip: [],
    tollFree: [7, 8, 9],
    premiumRate: [8, 9],
    sharedCost: [],
    personalNumber: [],
    uan: [5, 6, 7, 8, 9, 10, 11, 12],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.FJ: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.FK: PhoneMetadataLengths(
    general: [],
    mobile: [5],
    fixedLine: [5],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.FM: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.FO: PhoneMetadataLengths(
    general: [],
    mobile: [6],
    fixedLine: [6],
    voip: [6],
    tollFree: [6],
    premiumRate: [6],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.FR: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GA: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GB: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [9, 10],
    voip: [10],
    tollFree: [7, 9, 10],
    premiumRate: [7, 10],
    sharedCost: [],
    personalNumber: [10],
    uan: [10],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.GD: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GF: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GG: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [7, 9, 10],
    premiumRate: [7, 10],
    sharedCost: [],
    personalNumber: [10],
    uan: [10],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.GH: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GI: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GL: PhoneMetadataLengths(
    general: [],
    mobile: [6],
    fixedLine: [6],
    voip: [6],
    tollFree: [6],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GM: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GN: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [9],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GP: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GQ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GR: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10, 11, 12],
    premiumRate: [10],
    sharedCost: [10],
    personalNumber: [10],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GT: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [11],
    premiumRate: [11],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GU: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GW: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [7],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.GY: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [7],
    tollFree: [7],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.HK: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [9],
    premiumRate: [5, 6, 7, 8, 11],
    sharedCost: [],
    personalNumber: [8],
    uan: [8],
    pager: [8],
    voiceMail: [],
  ),
  IsoCode.HN: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.HR: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9],
    fixedLine: [8, 9],
    voip: [],
    tollFree: [7, 8, 9],
    premiumRate: [6, 7, 8],
    sharedCost: [],
    personalNumber: [8],
    uan: [8, 9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.HT: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.HU: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [9],
    tollFree: [8, 9],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ID: PhoneMetadataLengths(
    general: [],
    mobile: [9, 10, 11, 12],
    fixedLine: [7, 8, 9, 10, 11],
    voip: [],
    tollFree: [8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
    premiumRate: [10],
    sharedCost: [10],
    personalNumber: [],
    uan: [7, 10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.IE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 8, 9, 10],
    voip: [9],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [10],
    personalNumber: [9],
    uan: [9],
    pager: [],
    voiceMail: [10],
  ),
  IsoCode.IL: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8, 11, 12],
    voip: [9],
    tollFree: [7, 10],
    premiumRate: [8, 10],
    sharedCost: [10],
    personalNumber: [],
    uan: [10],
    pager: [],
    voiceMail: [11, 12],
  ),
  IsoCode.IM: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.IN: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [8, 9, 10, 11, 12, 13],
    premiumRate: [13],
    sharedCost: [11],
    personalNumber: [],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.IO: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.IQ: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8, 9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.IR: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [6, 7, 10],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [4, 5],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.IS: PhoneMetadataLengths(
    general: [],
    mobile: [7, 9],
    fixedLine: [7],
    voip: [7],
    tollFree: [7],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [7],
    pager: [],
    voiceMail: [7],
  ),
  IsoCode.IT: PhoneMetadataLengths(
    general: [],
    mobile: [9, 10],
    fixedLine: [6, 7, 8, 9, 10, 11],
    voip: [10],
    tollFree: [6, 9],
    premiumRate: [6, 8, 9, 10],
    sharedCost: [6, 9],
    personalNumber: [9, 10],
    uan: [],
    pager: [],
    voiceMail: [11, 12],
  ),
  IsoCode.JE: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [10],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.JM: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.JO: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [9],
    uan: [8],
    pager: [9],
    voiceMail: [],
  ),
  IsoCode.JP: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [9],
    voip: [10],
    tollFree: [8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [9],
    uan: [9],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.KE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 8, 9],
    voip: [],
    tollFree: [9, 10],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KG: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [9, 10],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KH: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9],
    fixedLine: [8, 9],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KI: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [5, 8],
    voip: [8],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KM: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KN: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KP: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8, 10],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KR: PhoneMetadataLengths(
    general: [],
    mobile: [9, 10],
    fixedLine: [5, 6, 8, 9, 10],
    voip: [10],
    tollFree: [9, 11, 12, 13, 14],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [10, 11],
    uan: [8],
    pager: [9, 10],
    voiceMail: [],
  ),
  IsoCode.KW: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [7],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.KY: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.KZ: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10, 14],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LA: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LB: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8],
    fixedLine: [7, 8],
    voip: [],
    tollFree: [],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LC: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LI: PhoneMetadataLengths(
    general: [],
    mobile: [7, 9],
    fixedLine: [7],
    voip: [],
    tollFree: [7, 9],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [7],
    pager: [],
    voiceMail: [9],
  ),
  IsoCode.LK: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LR: PhoneMetadataLengths(
    general: [],
    mobile: [7, 9],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LS: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LT: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [8],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LU: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [4, 5, 6, 7, 8, 9, 10, 11],
    voip: [4, 5, 6, 7, 8, 9, 10],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LV: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.LY: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MA: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MC: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MD: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ME: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8, 9],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MF: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MG: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MH: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [7],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MK: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ML: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MM: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8, 9, 10],
    fixedLine: [6, 7, 8, 9],
    voip: [8],
    tollFree: [10],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MN: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8, 9, 10],
    voip: [8],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MO: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [7],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MP: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MQ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MR: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MS: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MT: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [8],
    pager: [8],
    voiceMail: [],
  ),
  IsoCode.MU: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [7, 8],
    voip: [7],
    tollFree: [7, 10],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MV: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [7],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MW: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MX: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [10],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MY: PhoneMetadataLengths(
    general: [],
    mobile: [9, 10],
    fixedLine: [8, 9],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.MZ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NA: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8, 9],
    voip: [8, 9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NC: PhoneMetadataLengths(
    general: [],
    mobile: [6],
    fixedLine: [6],
    voip: [],
    tollFree: [6],
    premiumRate: [6],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NE: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NF: PhoneMetadataLengths(
    general: [],
    mobile: [6],
    fixedLine: [6],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NG: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8, 10],
    voip: [],
    tollFree: [10, 11, 12, 13, 14],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [10, 11, 12, 13, 14],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NI: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NL: PhoneMetadataLengths(
    general: [],
    mobile: [9, 11],
    fixedLine: [9],
    voip: [9],
    tollFree: [7, 8, 9, 10],
    premiumRate: [7, 8, 9, 10],
    sharedCost: [],
    personalNumber: [],
    uan: [5, 6, 9],
    pager: [9],
    voiceMail: [],
  ),
  IsoCode.NO: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [8],
    uan: [5, 8],
    pager: [],
    voiceMail: [8],
  ),
  IsoCode.NP: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [8],
    voip: [],
    tollFree: [11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NR: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NU: PhoneMetadataLengths(
    general: [],
    mobile: [4, 7],
    fixedLine: [4],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.NZ: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9, 10],
    fixedLine: [8],
    voip: [],
    tollFree: [8, 9, 10],
    premiumRate: [7, 8, 9, 10],
    sharedCost: [],
    personalNumber: [9],
    uan: [5, 6, 7, 8, 9, 10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.OM: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [7, 8, 9],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PA: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8],
    fixedLine: [7],
    voip: [],
    tollFree: [7, 8, 10, 11],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [8],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PF: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [6],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PG: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [7],
    voip: [7],
    tollFree: [7],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [7],
    voiceMail: [],
  ),
  IsoCode.PH: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [6, 8, 9, 10],
    voip: [],
    tollFree: [11, 12, 13],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PK: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [9, 10],
    voip: [],
    tollFree: [8, 11],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [9],
    uan: [11, 12],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PL: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 9],
    voip: [9],
    tollFree: [9, 10],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [9],
    pager: [6, 7, 8, 9],
    voiceMail: [],
  ),
  IsoCode.PM: PhoneMetadataLengths(
    general: [],
    mobile: [6, 9],
    fixedLine: [6, 9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PR: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PS: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [],
    tollFree: [10],
    premiumRate: [],
    sharedCost: [10],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PT: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [9],
    uan: [9],
    pager: [9],
    voiceMail: [9],
  ),
  IsoCode.PW: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.PY: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 8, 9],
    voip: [9],
    tollFree: [9, 10, 11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [6, 7, 8, 9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.QA: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [7, 9, 11],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [7],
    voiceMail: [],
  ),
  IsoCode.RE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.RO: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [6, 9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.RS: PhoneMetadataLengths(
    general: [],
    mobile: [8, 9, 10],
    fixedLine: [7, 8, 9, 10, 11, 12],
    voip: [],
    tollFree: [6, 7, 8, 9, 10, 11, 12],
    premiumRate: [6, 7, 8, 9, 10],
    sharedCost: [],
    personalNumber: [],
    uan: [6, 7, 8, 9, 10, 11, 12],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.RU: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10, 14],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.RW: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8, 9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SA: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [10],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SB: PhoneMetadataLengths(
    general: [],
    mobile: [5, 7],
    fixedLine: [5],
    voip: [5],
    tollFree: [5],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SC: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [7],
    tollFree: [7],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SD: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 8, 9],
    voip: [],
    tollFree: [6, 7, 8, 9],
    premiumRate: [7, 8, 9, 10],
    sharedCost: [9],
    personalNumber: [9],
    uan: [9],
    pager: [9],
    voiceMail: [12],
  ),
  IsoCode.SG: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [10, 11],
    premiumRate: [11],
    sharedCost: [],
    personalNumber: [],
    uan: [11],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SH: PhoneMetadataLengths(
    general: [],
    mobile: [5],
    fixedLine: [4, 5],
    voip: [5],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SI: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [6, 7, 8],
    premiumRate: [5, 6, 7, 8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SJ: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [8],
    uan: [5, 8],
    pager: [],
    voiceMail: [8],
  ),
  IsoCode.SK: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [6, 7, 9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [9],
    pager: [7],
    voiceMail: [],
  ),
  IsoCode.SL: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SM: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [10],
    voip: [8],
    tollFree: [],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SN: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SO: PhoneMetadataLengths(
    general: [],
    mobile: [7, 8, 9],
    fixedLine: [6, 7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SR: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [6, 7],
    voip: [6],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SS: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ST: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SV: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [7, 11],
    premiumRate: [7, 11],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SX: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SY: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8, 9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.SZ: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [8],
    tollFree: [8],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TA: PhoneMetadataLengths(
    general: [],
    mobile: [4],
    fixedLine: [4],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TC: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TD: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TG: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TH: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8],
    voip: [9],
    tollFree: [10, 13],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TJ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TK: PhoneMetadataLengths(
    general: [],
    mobile: [4, 5, 6, 7],
    fixedLine: [4, 5, 6, 7],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TL: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [7],
    voip: [],
    tollFree: [7],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [7],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TM: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TN: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [8],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TO: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [5],
    voip: [7],
    tollFree: [7],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TR: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10, 12, 13],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [7],
    pager: [10],
    voiceMail: [],
  ),
  IsoCode.TT: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [10],
  ),
  IsoCode.TV: PhoneMetadataLengths(
    general: [],
    mobile: [6, 7],
    fixedLine: [5],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TW: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [8, 9],
    voip: [10, 11],
    tollFree: [8, 9],
    premiumRate: [7, 9],
    sharedCost: [],
    personalNumber: [9],
    uan: [9],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.TZ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.UA: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9, 10],
    premiumRate: [9, 10],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.UG: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.US: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.UY: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8],
    voip: [],
    tollFree: [6, 7, 8, 9, 10, 11, 12, 13],
    premiumRate: [7],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.UZ: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.VA: PhoneMetadataLengths(
    general: [],
    mobile: [9, 10],
    fixedLine: [6, 7, 8, 9, 10, 11],
    voip: [10],
    tollFree: [6, 9],
    premiumRate: [6, 8, 9, 10],
    sharedCost: [6, 9],
    personalNumber: [9, 10],
    uan: [],
    pager: [],
    voiceMail: [11, 12],
  ),
  IsoCode.VC: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [10],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.VE: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [],
    uan: [10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.VG: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.VI: PhoneMetadataLengths(
    general: [],
    mobile: [10],
    fixedLine: [10],
    voip: [],
    tollFree: [10],
    premiumRate: [10],
    sharedCost: [],
    personalNumber: [10],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.VN: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [10],
    voip: [9],
    tollFree: [8, 9, 10],
    premiumRate: [8, 9, 10],
    sharedCost: [],
    personalNumber: [],
    uan: [7, 8],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.VU: PhoneMetadataLengths(
    general: [],
    mobile: [7],
    fixedLine: [5],
    voip: [7],
    tollFree: [5],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [5, 7],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.WF: PhoneMetadataLengths(
    general: [],
    mobile: [6],
    fixedLine: [6],
    voip: [6],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [6],
  ),
  IsoCode.WS: PhoneMetadataLengths(
    general: [],
    mobile: [7, 10],
    fixedLine: [5, 6],
    voip: [],
    tollFree: [6],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.XK: PhoneMetadataLengths(
    general: [],
    mobile: [8],
    fixedLine: [8, 9, 10, 11, 12],
    voip: [],
    tollFree: [8],
    premiumRate: [8],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.YE: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [7, 8],
    voip: [],
    tollFree: [],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.YT: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ZA: PhoneMetadataLengths(
    general: [],
    mobile: [5, 6, 7, 8, 9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [9],
    sharedCost: [9],
    personalNumber: [],
    uan: [9, 10],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ZM: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [9],
    voip: [9],
    tollFree: [9],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
  IsoCode.ZW: PhoneMetadataLengths(
    general: [],
    mobile: [9],
    fixedLine: [5, 6, 7, 8, 9, 10],
    voip: [10],
    tollFree: [7],
    premiumRate: [],
    sharedCost: [],
    personalNumber: [],
    uan: [],
    pager: [],
    voiceMail: [],
  ),
};
