import { type ReadStream } from 'node:fs';
export declare const refreshTokenURI = "https://www.googleapis.com/oauth2/v4/token";
export type APIClientOptions = {
    extensionId: string;
    clientId: string;
    refreshToken: string;
    clientSecret: string | undefined;
};
export type ItemResource = {
    kind: 'chromewebstore#item';
    id: string;
    publicKey: string;
    uploadState: 'FAILURE' | 'IN_PROGRESS' | 'NOT_FOUND' | 'SUCCESS';
    itemError: Array<{
        error_code: string;
        error_detail: string;
    }>;
};
export type PublishResponse = {
    kind: 'chromewebstore#item';
    item_id: string;
    status: Array<'OK' | 'NOT_AUTHORIZED' | 'INVALID_DEVELOPER' | 'DEVELOPER_NO_OWNERSHIP' | 'DEVELOPER_SUSPENDED' | 'ITEM_NOT_FOUND' | 'ITEM_PENDING_REVIEW' | 'ITEM_TAKEN_DOWN' | 'PUBLISHER_SUSPENDED'>;
    statusDetail: string[];
};
declare class APIClient {
    extensionId: string;
    clientId: string;
    refreshToken: string;
    clientSecret: string | undefined;
    constructor(options: APIClientOptions);
    uploadExisting(readStream: ReadStream | ReadableStream, token?: string | Promise<string>): Promise<ItemResource>;
    publish(target?: string, token?: string | Promise<string>, deployPercentage?: number | undefined): Promise<PublishResponse>;
    get(projection?: string, token?: string | Promise<string>): Promise<ItemResource>;
    fetchToken(): Promise<string>;
    _headers(token: string): {
        Authorization: string;
        'x-goog-api-version': string;
    };
}
export default function chromeWebstoreUpload(options: APIClientOptions): APIClient;
export {};
