require("source-map-support").install();
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createInstance = createInstance;
exports["default"] = void 0;
exports.isRunFromCLI = isRunFromCLI;
var _cli = __webpack_require__(1);
var _linter = _interopRequireDefault(__webpack_require__(8));
var _logger = _interopRequireDefault(__webpack_require__(4));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function isRunFromCLI(_module = module) {
  return __webpack_require__.c[__webpack_require__.s] === _module;
}
function createInstance({
  config = (0, _cli.getConfig)({
    useCLI: isRunFromCLI()
  }).argv,
  runAsBinary = false
} = {}) {
  _logger.default.level = config.logLevel;
  _logger.default.info('Creating new linter instance', {
    config
  });
  // eslint-disable-next-line no-param-reassign
  config.runAsBinary = runAsBinary;
  return new _linter.default(config);
}
var _default = exports["default"] = {
  Linter: _linter.default,
  createInstance,
  isRunFromCLI
};

/***/ }),
/* 1 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getConfig = getConfig;
exports.terminalWidth = terminalWidth;
var _yargs = _interopRequireDefault(__webpack_require__(2));
var _commonTags = __webpack_require__(3);
var _logger = _interopRequireDefault(__webpack_require__(4));
var _yargsOptions = _interopRequireDefault(__webpack_require__(6));
var _package = __webpack_require__(7);
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function terminalWidth(_process = process) {
  if (_process && _process.stdout && _process.stdout.columns > 0) {
    let width = _process.stdout.columns - 2;
    // Terminals less than ten pixels wide seem silly.
    if (width < 10) {
      width = 10;
    }
    return width;
  }
  return 78;
}
function getConfig({
  useCLI = true,
  argv
} = {}) {
  if (useCLI === false) {
    _logger.default.error((0, _commonTags.oneLine)`Config requested from CLI, but not in CLI mode.
      Please supply a config instead of relying on the getConfig() call.`);
    throw new Error('Cannot request config from CLI in library mode');
  }

  // Used by test.main,js to override CLI arguments (because
  // the  process.argv array is controlled by jest),
  // See #1762 for a rationale.
  const cliArgv = argv ? (0, _yargs.default)(argv) : _yargs.default;
  return cliArgv.usage(`Usage: ./$0 [options] addon-package-or-dir \n\n
      Add-ons Linter (JS Edition) v${_package.version}`).options(_yargsOptions.default)
  // Require one non-option.
  .demand(1).help('help').alias('h', 'help').wrap(terminalWidth());
}

/***/ }),
/* 2 */
/***/ ((module) => {

module.exports = require("yargs");

/***/ }),
/* 3 */
/***/ ((module) => {

module.exports = require("common-tags");

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createLogger = createLogger;
exports["default"] = void 0;
var _pino = _interopRequireDefault(__webpack_require__(5));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function createLogger(_process = process) {
  const level = _process.env.LOG_LEVEL || 'fatal';
  return (0, _pino.default)({
    name: 'AddonLinterJS',
    level
  }, process.stdout);
}
var _default = exports["default"] = createLogger();

/***/ }),
/* 5 */
/***/ ((module) => {

module.exports = require("pino");

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
exports.getDefaultConfigValue = getDefaultConfigValue;
const options = {
  'log-level': {
    describe: 'The log-level to generate',
    type: 'string',
    default: 'fatal',
    choices: ['fatal', 'error', 'warn', 'info', 'debug', 'trace']
  },
  'warnings-as-errors': {
    describe: 'Treat warnings as errors',
    type: 'boolean',
    default: false
  },
  output: {
    alias: 'o',
    describe: 'The type of output to generate',
    type: 'string',
    default: 'text',
    choices: ['json', 'text']
  },
  metadata: {
    describe: 'Output only metadata as JSON',
    type: 'boolean',
    default: false
  },
  pretty: {
    describe: 'Prettify JSON output',
    type: 'boolean',
    default: false
  },
  stack: {
    describe: 'Show stacktraces when errors are thrown',
    type: 'boolean',
    default: false
  },
  boring: {
    describe: 'Disable colorful shell output',
    type: 'boolean',
    default: false
  },
  enterprise: {
    describe: 'Treat the input file (or directory) as an enterprise extension (implies --self-hosted)',
    type: 'boolean',
    default: false
  },
  privileged: {
    describe: 'Treat the input file (or directory) as a privileged extension',
    type: 'boolean',
    default: false
  },
  'self-hosted': {
    describe: 'Disable messages related to hosting on addons.mozilla.org',
    type: 'boolean',
    default: false
  },
  'enable-background-service-worker': {
    describe: 'Enable MV3 background service worker support',
    type: 'boolean',
    default: false
  },
  'min-manifest-version': {
    describe: 'Set a custom minimum allowed value for the manifest_version property',
    type: 'number',
    default: 2,
    requiresArg: true
  },
  'max-manifest-version': {
    describe: 'Set a custom maximum allowed value for the manifest_version property',
    type: 'number',
    default: 3,
    requiresArg: true
  },
  'disable-linter-rules': {
    describe: 'Disable list of comma separated eslint rules',
    type: 'string',
    requiresArg: true
  },
  'disable-xpi-autoclose': {
    describe: 'Disable the auto-close feature when linting XPI files',
    type: 'boolean',
    default: false
  }
};
var _default = exports["default"] = options;
function getDefaultConfigValue(name) {
  if (options[name] && 'default' in options[name]) {
    return options[name].default;
  }
  return undefined;
}

/***/ }),
/* 7 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"name":"addons-linter","version":"7.8.0","description":"Mozilla Add-ons Linter","main":"dist/addons-linter.js","bin":{"addons-linter":"bin/addons-linter"},"engines":{"node":">=18.0.0"},"browserslist":["node >=18.0.0"],"scripts":{"build":"webpack --bail --stats-error-details true --color --config webpack.config.js","eslint":"eslint bin/* scripts/* .","test":"jest --runInBand --watch \'tests/.*\'","test-coverage":"jest --runInBand --coverage --watch \'tests/.*\'","test-once":"jest --runInBand","test-coverage-once":"jest --runInBand --coverage","test-ci":"npm run test-coverage-once","test-integration":"jest --runInBand --config=jest.integration.config.js","test-integration-linter":"npm run test-integration -- tests/integration/addons-linter","test-integration:production":"node tests/integration/run-as-production-env.js test-integration tests/integration/addons-linter","lint":"npm run eslint","prettier":"prettier --write \'**\'","prettier-ci":"prettier --list-different \'**\' || (echo \'\\n\\nThis failure means you did not run `npm run prettier-dev` before committing\\n\\n\' && exit 1)","prettier-dev":"pretty-quick --branch master","build-rules":"scripts/build-rules && cp node_modules/github-markdown-css/github-markdown.css docs/github-markdown.css","webext-test-functional":"scripts/webext-test-functional","smoke-test-eslint-version-conflicts":"scripts/smoke-test-eslint-version-conflicts","update-hashes":"scripts/dispensary > src/dispensary/hashes.txt"},"repository":{"type":"git","url":"git+https://github.com/mozilla/addons-linter.git"},"author":"Mozilla Add-ons Team","license":"MPL-2.0","bugs":{"url":"https://github.com/mozilla/addons-linter/issues"},"homepage":"https://github.com/mozilla/addons-linter#readme","dependencies":{"@fluent/syntax":"0.19.0","@fregante/relaxed-json":"2.0.0","@mdn/browser-compat-data":"5.6.31","addons-moz-compare":"1.3.0","addons-scanner-utils":"9.12.0","ajv":"8.17.1","chalk":"4.1.2","cheerio":"1.0.0-rc.12","columnify":"1.6.0","common-tags":"1.8.2","deepmerge":"4.3.1","eslint":"8.57.1","eslint-plugin-no-unsanitized":"4.1.2","eslint-visitor-keys":"4.2.0","espree":"10.3.0","esprima":"4.0.1","fast-json-patch":"3.1.1","image-size":"1.2.0","json-merge-patch":"1.0.2","pino":"8.20.0","semver":"7.6.3","source-map-support":"0.5.21","upath":"2.0.1","yargs":"17.7.2","yauzl":"2.10.0"},"devDependencies":{"@babel/cli":"7.26.4","@babel/core":"7.26.0","@babel/eslint-parser":"7.26.5","@babel/preset-env":"7.26.0","@babel/register":"7.25.9","async":"3.2.6","babel-core":"7.0.0-bridge.0","babel-jest":"29.7.0","babel-loader":"9.2.1","comment-json":"4.2.5","eslint-config-amo":"5.12.0","eslint-plugin-amo":"1.26.0","eslint-plugin-prettier":"5.2.3","github-markdown-css":"5.8.1","gunzip-maybe":"1.4.2","hashish":"0.0.4","jest":"29.7.0","lodash.clonedeep":"4.5.0","lodash.ismatchwith":"4.4.0","markdown-it":"14.1.0","markdown-it-anchor":"9.2.0","markdown-it-footnote":"4.0.0","natural-compare-lite":"1.4.0","node-fetch":"2.6.11","prettier":"3.4.2","pretty-quick":"4.0.0","raw-loader":"4.0.2","replace-in-file":"7.2.0","shelljs":"0.8.5","sinon":"19.0.2","tar-fs":"3.0.8","tmp-promise":"3.0.3","webpack":"5.97.1","webpack-cli":"5.1.4","webpack-node-externals":"3.0.0","yazl":"2.5.1"}}');

/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _path = _interopRequireDefault(__webpack_require__(9));
var _columnify = _interopRequireDefault(__webpack_require__(10));
var _chalk = _interopRequireDefault(__webpack_require__(11));
var _commonTags = __webpack_require__(3);
var _utils = __webpack_require__(12);
var _errors = __webpack_require__(13);
var _io = __webpack_require__(14);
var _cli = __webpack_require__(1);
var constants = _interopRequireWildcard(__webpack_require__(15));
var _libraries = __webpack_require__(16);
var messages = _interopRequireWildcard(__webpack_require__(17));
var _utils2 = __webpack_require__(19);
var _logger = _interopRequireDefault(__webpack_require__(4));
var _collector = _interopRequireDefault(__webpack_require__(29));
var _manifestjson = _interopRequireDefault(__webpack_require__(31));
var _binary = _interopRequireDefault(__webpack_require__(113));
var _filename2 = _interopRequireDefault(__webpack_require__(115));
var _html = _interopRequireDefault(__webpack_require__(116));
var _javascript = _interopRequireDefault(__webpack_require__(121));
var _json = _interopRequireDefault(__webpack_require__(139));
var _langpack = _interopRequireDefault(__webpack_require__(141));
var _miner_blocklist = __webpack_require__(146);
var _dispensary = _interopRequireDefault(__webpack_require__(147));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class Linter {
  constructor(config) {
    this.config = config;
    [this.packagePath] = config._;
    this.io = null;
    this.chalk = new _chalk.default.Instance({
      enabled: !this.config.boring
    });
    this.collector = new _collector.default(config);
    this.addonMetadata = null;
    this.shouldScanFile = this.shouldScanFile.bind(this);
  }
  set config(cfg) {
    this._config = cfg;
  }
  get config() {
    return this._config;
  }
  validateConfig() {
    const {
      minManifestVersion,
      maxManifestVersion
    } = this.config;
    if (maxManifestVersion < minManifestVersion) {
      throw new _utils2.AddonsLinterUserError(_utils2.i18n.sprintf(_utils2.i18n._(`Invalid manifest version range requested:
            --min-manifest-version (currently set to %(minManifestVersion)s)
            should not be greater than
            --max-manifest-version (currently set to %(maxManifestVersion)s).`), {
        minManifestVersion,
        maxManifestVersion
      }));
    }
  }
  colorize(type) {
    switch (type) {
      case constants.VALIDATION_ERROR:
        return this.chalk.red;
      case constants.VALIDATION_WARNING:
        return this.chalk.yellow;
      case constants.VALIDATION_NOTICE:
        return this.chalk.blue;
      default:
        throw new Error((0, _commonTags.oneLine)`colorize passed invalid type.
          Should be one of ${constants.MESSAGE_TYPES.join(', ')}`);
    }
  }
  closeIO() {
    // This is only used when `io` is valid and we disabled the auto-close
    // feature.
    if (this.config.disableXpiAutoclose && this.io) {
      this.io.close();
    }
  }
  handleError(err, _console = console) {
    // The zip files contains invalid entries (likely path names using invalid
    // characters like '\\'), the linter can inspect the package but Firefox
    // would fail to load it.
    if (err instanceof _errors.InvalidZipFileError) {
      this.collector.addError({
        ...messages.INVALID_XPI_ENTRY,
        message: err.message
      });
      this.print(_console);
      return true;
    }

    // The zip file contains multiple entries with the exact same file name.
    if (err instanceof _errors.DuplicateZipEntryError) {
      this.collector.addError(messages.DUPLICATE_XPI_ENTRY);
      this.print(_console);
      return true;
    }

    // The zip file fails to open successfully, the linter can't inspect it
    // at all.
    if (err.message.includes(constants.ZIP_LIB_CORRUPT_FILE_ERROR)) {
      this.collector.addError(messages.BAD_ZIPFILE);
      this.print(_console);
      return true;
    }
    if (this.config.stack === true) {
      _console.error(err.stack);
    } else {
      _console.error(this.chalk.red(err.message || err));
    }
    this.closeIO();
    return false;
  }
  print(_console = console) {
    if (this.config.output === 'none') {
      return;
    }
    if (this.config.output === 'json') {
      _console.log(this.toJSON(this.config.pretty));
    } else {
      _console.log(this.textOutput());
    }
  }
  toJSON({
    input = this.output,
    pretty = this.config.pretty,
    _JSON = JSON
  } = {}) {
    const args = [input];
    if (pretty === true) {
      args.push(null);
      args.push(4);
    }
    return _JSON.stringify.apply(null, args);
  }
  textOutput(_terminalWidth = _cli.terminalWidth) {
    const maxColumns = _terminalWidth();
    const out = [];
    out.push(_utils2.i18n._('Validation Summary:'));
    out.push('');
    out.push((0, _columnify.default)(this.output.summary, {
      showHeaders: false,
      minWidth: 15,
      maxLineWidth: maxColumns
    }));
    out.push('');
    constants.MESSAGE_TYPES.forEach(type => {
      const messageType = `${type}s`;
      if (this.output[messageType].length) {
        const outputConfig = {
          code: {
            dataTransform: value => {
              return this.colorize(type)(value);
            },
            headingTransform: () => {
              return _utils2.i18n._('Code');
            },
            maxWidth: 35
          },
          message: {
            headingTransform: () => {
              return _utils2.i18n._('Message');
            },
            maxWidth: (maxColumns - 35) * 0.25
          },
          description: {
            headingTransform: () => {
              return _utils2.i18n._('Description');
            },
            maxWidth: (maxColumns - 35) * 0.5
          },
          file: {
            headingTransform: () => {
              return _utils2.i18n._('File');
            },
            maxWidth: (maxColumns - 35) * 0.25
          },
          line: {
            headingTransform: () => {
              return _utils2.i18n._('Line');
            },
            maxWidth: 6
          },
          column: {
            headingTransform: () => {
              return _utils2.i18n._('Column');
            },
            maxWidth: 6
          }
        };
        const outputColumns = ['code', 'message', 'description', 'file', 'line', 'column'];

        // If the terminal is this small we cave and don't size things
        // contextually anymore.
        if (maxColumns < 60) {
          delete outputColumns[outputColumns.indexOf('column')];
          delete outputConfig.column;
          delete outputColumns[outputColumns.indexOf('description')];
          delete outputConfig.description;
          delete outputColumns[outputColumns.indexOf('line')];
          delete outputConfig.line;
          outputConfig.message.maxWidth = 15;
          outputConfig.file.maxWidth = 15;
        } else if (maxColumns < 78) {
          delete outputColumns[outputColumns.indexOf('description')];
          delete outputConfig.description;
          outputConfig.message.maxWidth = (maxColumns - 47) * 0.5;
          outputConfig.file.maxWidth = (maxColumns - 35) * 0.5;
        }
        out.push(`${messageType.toUpperCase()}:`);
        out.push('');
        out.push((0, _columnify.default)(this.output[messageType], {
          maxWidth: 35,
          columns: outputColumns,
          columnSplitter: '   ',
          config: outputConfig,
          maxLineWidth: maxColumns
        }));
      }
    });
    return out.join('\n');
  }
  get output() {
    const output = {
      count: this.collector.length,
      summary: {},
      metadata: this.addonMetadata
    };
    constants.MESSAGE_TYPES.forEach(type => {
      const messageType = `${type}s`;
      output[messageType] = this.collector[messageType];
      output.summary[messageType] = this.collector[messageType].length;
    });
    return output;
  }
  async getAddonMetadata({
    _log = _logger.default,
    ManifestJSONParser = _manifestjson.default
  } = {}) {
    if (this.addonMetadata !== null) {
      _log.debug('Metadata already set; returning cached metadata.');
      return this.addonMetadata;
    }
    const files = await this.io.getFiles();
    if (Object.prototype.hasOwnProperty.call(files, constants.MANIFEST_JSON)) {
      _log.info('Retrieving metadata from manifest.json');
      const json = await this.io.getFileAsString(constants.MANIFEST_JSON);
      const manifestParser = new ManifestJSONParser(json, this.collector, {
        io: this.io,
        isAlreadySigned: Object.keys(files).some(filename => constants.ALREADY_SIGNED_REGEX.test(filename)),
        isEnterprise: this.config.enterprise,
        selfHosted: this.config.selfHosted,
        schemaValidatorOptions: {
          privileged: this.config.privileged,
          minManifestVersion: this.config.minManifestVersion,
          maxManifestVersion: this.config.maxManifestVersion,
          enableBackgroundServiceWorker: this.config.enableBackgroundServiceWorker
        }
      });
      await manifestParser.validateIcons();
      if (manifestParser.isStaticTheme) {
        await manifestParser.validateStaticThemeImages();
      }
      this.addonMetadata = manifestParser.getMetadata();
    } else {
      _log.warn(`No ${constants.MANIFEST_JSON} was found in the package metadata`);
      this.collector.addError(messages.TYPE_NO_MANIFEST_JSON);
      this.addonMetadata = {};
    }
    this.addonMetadata.totalScannedFileSize = 0;
    return this.addonMetadata;
  }
  async checkFileExists(filepath, _lstat = _utils.lstat) {
    const invalidMessage = new Error(`Path "${filepath}" is not a file or directory or does not exist.`);
    try {
      const stats = await _lstat(filepath);
      if (stats.isFile() === true || stats.isDirectory() === true) {
        return stats;
      }
    } catch (err) {
      if (err.code !== 'ENOENT') {
        throw err;
      }
    }
    throw invalidMessage;
  }
  scanFiles(files) {
    const promises = [];
    files.forEach(filename => {
      promises.push(this.scanFile(filename));
    });
    return Promise.all(promises);
  }
  getScanner(filename) {
    const filenameWithoutPath = _path.default.basename(filename);
    if (filename.match(constants.HIDDEN_FILE_REGEX) || filename.match(constants.FLAGGED_FILE_REGEX) || constants.FLAGGED_FILE_EXTENSIONS.includes(_path.default.extname(filename)) || filename.match(constants.ALREADY_SIGNED_REGEX) || constants.RESERVED_FILENAMES.includes(filenameWithoutPath)) {
      return _filename2.default;
    }
    switch (_path.default.extname(filename)) {
      case '.html':
      case '.htm':
        return _html.default;
      case '.js':
      case '.jsm':
      case '.mjs':
        return _javascript.default;
      case '.json':
        return _json.default;
      case '.properties':
      case '.ftl':
      case '.dtd':
        return _langpack.default;
      default:
        return _binary.default;
    }
  }
  async scanFile(filename) {
    let scanResult = {
      linterMessages: [],
      scannedFiles: []
    };
    const ScannerClass = this.getScanner(filename);
    const fileData = await this.io.getFile(filename, ScannerClass.fileResultType);

    // First: check that this file is under our 2MB parsing limit. Otherwise
    // it will be very slow and may crash the lint with an out-of-memory
    // error.
    const fileSize = typeof this.io.files[filename].size !== 'undefined' ? this.io.files[filename].size : this.io.files[filename].uncompressedSize;
    const maxSize = 1024 * 1024 * constants.MAX_FILE_SIZE_TO_PARSE_MB;
    if (ScannerClass !== _binary.default && ScannerClass !== _filename2.default && fileSize >= maxSize) {
      const filesizeError = {
        ...messages.FILE_TOO_LARGE,
        file: filename,
        type: constants.VALIDATION_ERROR
      };
      scanResult = {
        linterMessages: [filesizeError],
        scannedFiles: [filename]
      };
    } else {
      if (ScannerClass !== _binary.default && ScannerClass !== _filename2.default) {
        // Check for coin miners
        this._markCoinMinerUsage(filename, fileData);
        if (this.addonMetadata) {
          this.addonMetadata.totalScannedFileSize += fileSize;
        }
      }
      const scanner = new ScannerClass(fileData, filename, {
        addonMetadata: this.addonMetadata,
        // This is for the JSONScanner, which is a bit of an anomaly and
        // accesses the collector directly.
        // TODO: Bring this in line with other scanners, see:
        // https://github.com/mozilla/addons-linter/issues/895
        collector: this.collector,
        // list of disabled rules for js scanner
        disabledRules: this.config.disableLinterRules,
        existingFiles: this.io.files,
        enterprise: this.config.enterprise,
        privileged: this.config.privileged
      });
      scanResult = await scanner.scan();
    }

    // messages should be a list of raw message data objects.
    const {
      linterMessages,
      scannedFiles
    } = scanResult;
    linterMessages.forEach(message => {
      if (typeof message.type === 'undefined') {
        throw new Error('message.type must be defined');
      }
      this.collector._addMessage(message.type, message);
    });
    scannedFiles.forEach(_filename => {
      this.collector.recordScannedFile(_filename, ScannerClass.scannerName);
    });
  }
  async extractMetadata({
    _Crx = _io.Crx,
    _Directory = _io.Directory,
    _Xpi = _io.Xpi,
    _console = console
  } = {}) {
    await (0, _utils2.checkMinNodeVersion)();
    const stats = await this.checkFileExists(this.packagePath);

    // Simple logging adapter for addons-scanner-utils IO.
    const stderr = {
      debug: message => _logger.default.debug(message),
      error: message => _logger.default.error(message),
      info: message => _logger.default.info(message)
    };
    if (stats.isFile()) {
      if (this.packagePath.endsWith('.crx')) {
        _logger.default.info('Package is a file ending in .crx; parsing as a CRX');
        this.io = new _Crx({
          filePath: this.packagePath,
          stderr
        });
      } else {
        _logger.default.info('Package is a file. Attempting to parse as an .xpi/.zip');

        // We should set `autoClose` to `false` when we want to disable this
        // feature. By default, the auto-close feature is enabled.
        const autoClose = this.config.disableXpiAutoclose !== true;
        if (!autoClose) {
          _logger.default.info('Disabling the auto-close feature');
        }
        this.io = new _Xpi({
          autoClose,
          filePath: this.packagePath,
          stderr
        });
      }
    } else {
      // If not a file then it's a directory.
      _logger.default.info('Package path is a directory. Parsing as a directory');
      this.io = new _Directory({
        filePath: this.packagePath,
        stderr
      });
    }
    this.io.setScanFileCallback(this.shouldScanFile);
    let addonMetadata = await this.getAddonMetadata();
    addonMetadata = await this.markSpecialFiles(addonMetadata);
    _logger.default.info('Metadata option is set to %s', this.config.metadata);
    if (this.config.metadata === true) {
      const metadataObject = {
        // Reflects if errors were encountered in extraction
        // of metadata.
        hasErrors: this.output.errors.length !== 0,
        metadata: addonMetadata
      };

      // If errors exist the data is available via the
      // errors list.
      if (metadataObject.hasErrors) {
        metadataObject.errors = this.output.errors;
      }
      _console.log(this.toJSON({
        input: metadataObject
      }));
    }
    return addonMetadata;
  }
  shouldScanFile(fileOrDirName, isDir) {
    if (this.config.shouldScanFile) {
      return this.config.shouldScanFile(fileOrDirName, isDir);
    }

    // Defaults to true.
    return true;
  }
  async scan(deps = {}) {
    try {
      await this.extractMetadata(deps);
      const files = await this.io.getFiles();

      // Known libraries do not need to be scanned
      const filesWithoutJSLibraries = Object.keys(files).filter(file => {
        return !Object.prototype.hasOwnProperty.call(this.addonMetadata.jsLibs, file);
      });
      await this.scanFiles(filesWithoutJSLibraries);
      this.closeIO();
      this.print(deps._console);
      // This is skipped in code coverage because the
      // test runs against un-instrumented code.
      /* istanbul ignore if */
      if (this.config.runAsBinary === true) {
        let exitCode = this.output.errors.length > 0 ? 1 : 0;
        if (exitCode === 0 && this.config.warningsAsErrors === true) {
          exitCode = this.output.warnings.length > 0 ? 1 : 0;
        }
        process.exit(exitCode);
      }
    } catch (err) {
      if (this.handleError(err, deps._console)) {
        return;
      }
      throw err;
    }
  }
  async run(deps = {}) {
    // Validate the config options from a linter perspective (in addition to the
    // yargs validation that already happened when the options are being parsed)
    // and throws if there are invalid options.
    this.validateConfig();
    if (this.config.metadata === true) {
      try {
        await this.extractMetadata(deps);
        this.closeIO();

        // This is skipped in the code coverage because the
        // test runs against un-instrumented code.
        /* istanbul ignore if */
        if (this.config.runAsBinary === true) {
          process.exit(this.output.errors.length > 0 ? 1 : 0);
        }
        return this.output;
      } catch (err) {
        _logger.default.debug(err);
        this.handleError(err, deps._console);
        throw err;
      }
    }
    await this.scan(deps);
    return this.output;
  }
  async markSpecialFiles(addonMetadata) {
    let _addonMetadata = await this._markEmptyFiles(addonMetadata);
    _addonMetadata = await this._markJSLibs(_addonMetadata);
    _addonMetadata = this._markBannedLibs(_addonMetadata);
    return this._markUnknownOrMinifiedCode(_addonMetadata);
  }
  _markBannedLibs(addonMetadata, _unadvisedLibraries = _libraries.UNADVISED_LIBRARIES) {
    Object.keys(addonMetadata.jsLibs).forEach(pathToFile => {
      if (_libraries.BANNED_LIBRARIES.includes(addonMetadata.jsLibs[pathToFile])) {
        this.collector.addError({
          ...messages.BANNED_LIBRARY,
          file: pathToFile
        });
      }
      if (_unadvisedLibraries.includes(addonMetadata.jsLibs[pathToFile])) {
        this.collector.addWarning({
          ...messages.UNADVISED_LIBRARY,
          file: pathToFile
        });
      }
    });
    return addonMetadata;
  }
  async _markEmptyFiles(addonMetadata) {
    const emptyFiles = [];
    const files = await this.io.getFiles();
    Object.keys(files).forEach(filename => {
      if (typeof files[filename].size === 'undefined' && typeof files[filename].uncompressedSize === 'undefined') {
        throw new Error(`No size available for ${filename}`);
      }
      if (files[filename].size === 0 || files[filename].uncompressedSize === 0) {
        emptyFiles.push(filename);
      }
    });

    // eslint-disable-next-line no-param-reassign
    addonMetadata.emptyFiles = emptyFiles;
    return addonMetadata;
  }
  async _markJSLibs(addonMetadata) {
    const dispensary = new _dispensary.default();
    const jsLibs = {};
    const files = await this.io.getFilesByExt('.js');
    await Promise.all(files.map(async filename => {
      const file = await this.io.getFile(filename);
      const hashResult = dispensary.match(file);
      if (hashResult !== false) {
        _logger.default.debug(`${hashResult} detected in ${filename}`);
        jsLibs[filename] = hashResult;
        this.collector.addNotice({
          ...messages.KNOWN_LIBRARY,
          file: filename
        });
      }
    }));

    // eslint-disable-next-line no-param-reassign
    addonMetadata.jsLibs = jsLibs;
    return addonMetadata;
  }
  async _markUnknownOrMinifiedCode(addonMetadata) {
    const unknownMinifiedFiles = [];
    const files = await this.io.getFilesByExt('.js');
    await Promise.all(files.map(async filename => {
      if (filename in addonMetadata.jsLibs) {
        return;
      }
      const fileData = await this.io.getFile(filename);
      if ((0, _utils2.couldBeMinifiedCode)(fileData)) {
        _logger.default.debug(`Minified code detected in ${filename}`);
        unknownMinifiedFiles.push(filename);
      }
    }));

    // eslint-disable-next-line no-param-reassign
    addonMetadata.unknownMinifiedFiles = unknownMinifiedFiles;
    return addonMetadata;
  }
  _markCoinMinerUsage(filename, fileData) {
    if (fileData && fileData.trim()) {
      _miner_blocklist.MINER_BLOCKLIST.filenames.forEach(nameRegex => {
        const filenameMatch = filename.match(nameRegex);
        if (filenameMatch) {
          this.collector.addWarning({
            ...messages.COINMINER_USAGE_DETECTED,
            file: filename
          });
        }
        const fileDataMatch = fileData.match(nameRegex);
        if (fileDataMatch) {
          const {
            matchedLine,
            matchedColumn
          } = (0, _utils2.getLineAndColumnFromMatch)(fileDataMatch);
          this.collector.addWarning({
            ...messages.COINMINER_USAGE_DETECTED,
            file: filename,
            column: matchedColumn,
            line: matchedLine
          });
        }
      });
      _miner_blocklist.MINER_BLOCKLIST.code.forEach(codeRegex => {
        const match = fileData.match(codeRegex);
        if (match) {
          const {
            matchedLine,
            matchedColumn
          } = (0, _utils2.getLineAndColumnFromMatch)(match);
          this.collector.addWarning({
            ...messages.COINMINER_USAGE_DETECTED,
            file: filename,
            line: matchedLine,
            column: matchedColumn,
            // use instancePath for our actual match to avoid any obvious
            // duplicates
            instancePath: match[0]
          });
        }
      });
    }
  }
}
exports["default"] = Linter;

/***/ }),
/* 9 */
/***/ ((module) => {

module.exports = require("path");

/***/ }),
/* 10 */
/***/ ((module) => {

module.exports = require("columnify");

/***/ }),
/* 11 */
/***/ ((module) => {

module.exports = require("chalk");

/***/ }),
/* 12 */
/***/ ((module) => {

module.exports = require("addons-scanner-utils/dist/io/utils");

/***/ }),
/* 13 */
/***/ ((module) => {

module.exports = require("addons-scanner-utils/dist/errors");

/***/ }),
/* 14 */
/***/ ((module) => {

module.exports = require("addons-scanner-utils/dist/io");

/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ZIP_LIB_CORRUPT_FILE_ERROR = exports.VALIDATION_WARNING = exports.VALIDATION_NOTICE = exports.VALIDATION_ERROR = exports.TEMPORARY_APIS = exports.STATIC_THEME_IMAGE_MIMES = exports.SCHEMA_KEYWORDS_CUSTOM = exports.SCHEMA_KEYWORDS = exports.RESTRICTED_PERMISSIONS = exports.RESTRICTED_HOMEPAGE_URLS = exports.RESERVED_FILENAMES = exports.PERMS_DATAPATH_REGEX = exports.PACKAGE_TYPES = exports.PACKAGE_THEME = exports.PACKAGE_SUBPACKAGE = exports.PACKAGE_SEARCHPROV = exports.PACKAGE_MULTI = exports.PACKAGE_LANGPACK = exports.PACKAGE_EXTENSION = exports.PACKAGE_DICTIONARY = exports.PACKAGE_ANY = exports.MESSAGE_TYPES = exports.MESSAGE_PLACEHOLDER_REGEXP = exports.MESSAGES_JSON = exports.MAX_FILE_SIZE_TO_PARSE_MB = exports.MANIFEST_VERSION_MIN = exports.MANIFEST_VERSION_MAX = exports.MANIFEST_VERSION_DEFAULT = exports.MANIFEST_JSON = exports.LOCAL_PROTOCOLS = exports.LOCALES_DIRECTORY = exports.INSTALL_ORIGINS_DATAPATH_REGEX = exports.IMAGE_FILE_EXTENSIONS = exports.HIDDEN_FILE_REGEX = exports.FLAGGED_FILE_REGEX = exports.FLAGGED_FILE_MAGIC_NUMBERS = exports.FLAGGED_FILE_EXTENSIONS = exports.FILE_EXTENSIONS_TO_MIME = exports.EXTERNAL_RULE_MAPPING = exports.ESLINT_WARNING = exports.ESLINT_TYPES = exports.ESLINT_RULE_MAPPING = exports.ESLINT_ERROR = exports.DEPRECATED_MANIFEST_PROPERTIES = exports.DEPRECATED_JAVASCRIPT_APIS = exports.CSP_KEYWORD_RE = exports.ALREADY_SIGNED_REGEX = void 0;
const ESLINT_ERROR = exports.ESLINT_ERROR = 2;
const ESLINT_WARNING = exports.ESLINT_WARNING = 1;
const NO_UNSANITIZED_OPTIONS = {
  variableTracing: false,
  // Disable escapers (Sanitizer.escapeHTML, escapeHTML) and unwrappers
  // (Sanitizer.unwrapSafeHTML, unwrapSafeHTML) which are allowed by default by
  // this plugin.
  escape: {
    taggedTemplates: [],
    methods: []
  }
};
const NO_UNSANITIZED_METHOD_CUSTOMIZATIONS = {
  import: {
    escape: {
      methods: ['chrome.runtime.getURL', 'browser.runtime.getURL']
    }
    // NOTE: Alternatively using the following option would instead
    // configure the plugin to consider any method call as allowed
    // on dynamic import calls:
    //
    // objectMatches: [],
  }
};

// 3rd party / eslint-internal rules
const EXTERNAL_RULE_MAPPING = exports.EXTERNAL_RULE_MAPPING = {
  'no-eval': [ESLINT_WARNING, {
    allowIndirect: false
  }],
  'no-implied-eval': ESLINT_WARNING,
  'no-new-func': ESLINT_WARNING,
  'no-unsanitized/method': [ESLINT_WARNING, NO_UNSANITIZED_OPTIONS, NO_UNSANITIZED_METHOD_CUSTOMIZATIONS],
  'no-unsanitized/property': [ESLINT_WARNING, NO_UNSANITIZED_OPTIONS]
};
const ESLINT_RULE_MAPPING = exports.ESLINT_RULE_MAPPING = {
  'global-require-arg': ESLINT_WARNING,
  'no-document-write': ESLINT_WARNING,
  'opendialog-nonlit-uri': ESLINT_WARNING,
  'opendialog-remote-uri': ESLINT_WARNING,
  'webextension-api': ESLINT_WARNING,
  'webextension-deprecated-api': ESLINT_WARNING,
  'webextension-unsupported-api': ESLINT_WARNING,
  'content-scripts-file-absent': ESLINT_ERROR,
  'webextension-api-compat': ESLINT_WARNING,
  'webextension-api-compat-android': ESLINT_WARNING,
  ...EXTERNAL_RULE_MAPPING
};
const VALIDATION_ERROR = exports.VALIDATION_ERROR = 'error';
const VALIDATION_NOTICE = exports.VALIDATION_NOTICE = 'notice';
const VALIDATION_WARNING = exports.VALIDATION_WARNING = 'warning';
const ESLINT_TYPES = exports.ESLINT_TYPES = {
  0: VALIDATION_NOTICE,
  1: VALIDATION_WARNING,
  2: VALIDATION_ERROR
};
const MESSAGE_TYPES = exports.MESSAGE_TYPES = [VALIDATION_ERROR, VALIDATION_NOTICE, VALIDATION_WARNING];

// Package type constants.
const PACKAGE_ANY = exports.PACKAGE_ANY = 0;
const PACKAGE_EXTENSION = exports.PACKAGE_EXTENSION = 1;
const PACKAGE_THEME = exports.PACKAGE_THEME = 2;
const PACKAGE_DICTIONARY = exports.PACKAGE_DICTIONARY = 3;
const PACKAGE_LANGPACK = exports.PACKAGE_LANGPACK = 4;
const PACKAGE_SEARCHPROV = exports.PACKAGE_SEARCHPROV = 5;
const PACKAGE_MULTI = exports.PACKAGE_MULTI = 1; // A multi extension is an extension
const PACKAGE_SUBPACKAGE = exports.PACKAGE_SUBPACKAGE = 7;
const PACKAGE_TYPES = exports.PACKAGE_TYPES = {
  PACKAGE_ANY,
  PACKAGE_EXTENSION,
  PACKAGE_THEME,
  PACKAGE_DICTIONARY,
  PACKAGE_LANGPACK,
  PACKAGE_SEARCHPROV,
  PACKAGE_MULTI,
  PACKAGE_SUBPACKAGE
};
const LOCAL_PROTOCOLS = exports.LOCAL_PROTOCOLS = ['chrome:', 'resource:'];
const MANIFEST_JSON = exports.MANIFEST_JSON = 'manifest.json';

// The manifest_version value to use to complete the validation if an explicit one
// was missing from the extension manifest.json (but we will still be collecting the
// error for the missing manifest_version property, because it is mandatory).
const MANIFEST_VERSION_DEFAULT = exports.MANIFEST_VERSION_DEFAULT = 2;

// Default min/max_manifest_version values used for schema definitions that do not
// have an explicit one on their own.
const MANIFEST_VERSION_MIN = exports.MANIFEST_VERSION_MIN = 2;
const MANIFEST_VERSION_MAX = exports.MANIFEST_VERSION_MAX = 3;

// This is the limit in megabytes of a file we will parse (eg. CSS, JS, etc.)
// A singular CSS/JS file over 4MB seems bad and may actually be full of data
// best stored in JSON/some other data format rather than code.
// https://github.com/mozilla/addons-linter/issues/730
// We increased this limit from 2MB to 4MB as per:
// https://github.com/mozilla/addons/issues/181
//
// We should be careful about increasing this any further.
const MAX_FILE_SIZE_TO_PARSE_MB = exports.MAX_FILE_SIZE_TO_PARSE_MB = 4;
const HIDDEN_FILE_REGEX = exports.HIDDEN_FILE_REGEX = /^__MACOSX\//;
const FLAGGED_FILE_REGEX = exports.FLAGGED_FILE_REGEX = /thumbs\.db$|\.DS_Store$|\.orig$|\.old$|~$/i;
const ALREADY_SIGNED_REGEX = exports.ALREADY_SIGNED_REGEX = /^META-INF\/manifest\.mf/;
const PERMS_DATAPATH_REGEX = exports.PERMS_DATAPATH_REGEX = /^\/(permissions|optional_permissions|host_permissions)\/([\d+])/;
const INSTALL_ORIGINS_DATAPATH_REGEX = exports.INSTALL_ORIGINS_DATAPATH_REGEX = /^\/(install_origins)\/([\d+])/;
const RESERVED_FILENAMES = exports.RESERVED_FILENAMES = ['mozilla-recommendation.json'];
const FLAGGED_FILE_EXTENSIONS = exports.FLAGGED_FILE_EXTENSIONS = ['.class', '.dll', '.dylib', '.exe', '.jar', '.sh', '.so', '.swf'];
const IMAGE_FILE_EXTENSIONS = exports.IMAGE_FILE_EXTENSIONS = ['jpg', 'jpeg', 'webp', 'gif', 'png', 'svg'];
const FILE_EXTENSIONS_TO_MIME = exports.FILE_EXTENSIONS_TO_MIME = {
  svg: 'image/svg+xml',
  gif: 'image/gif',
  jpg: 'image/jpeg',
  jpeg: 'image/jpeg',
  png: 'image/png',
  webp: 'image/webp'
};

// Unique list of mime types for the allowed static theme images.
const STATIC_THEME_IMAGE_MIMES = exports.STATIC_THEME_IMAGE_MIMES = [...new Set(Object.values(FILE_EXTENSIONS_TO_MIME))];

// Mapping of "schema data paths" of the deprecated properties that we
// issue warnings for.
// If the value is `null` we will be using the `deprecated` message
// from the schema. Otherwise `code`, `message` and `description` will be taken
// from the object provided.
// Note that we have to use the constants name as we can't import
// the message object here.
const DEPRECATED_MANIFEST_PROPERTIES = exports.DEPRECATED_MANIFEST_PROPERTIES = {
  '/theme/images/headerURL': 'MANIFEST_THEME_LWT_ALIAS',
  '/theme/colors/accentcolor': 'MANIFEST_THEME_LWT_ALIAS',
  '/theme/colors/textcolor': 'MANIFEST_THEME_LWT_ALIAS'
};

// Mapping of deprecated javascript apis.
// If the value is `null` we will be using the `deprecated` message
// from the schema. Otherwise `code`, `message` and `description` will be taken
// from the object provided.
// Note that we have to use the constants name as we can't import
// the message object here.
const DEPRECATED_JAVASCRIPT_APIS = exports.DEPRECATED_JAVASCRIPT_APIS = {
  // These APIs were already deprecated by Chrome and Firefox never
  // supported them. We do still issue deprecation warnings for them.
  'app.getDetails': 'DEPRECATED_CHROME_API',
  'extension.onRequest': 'DEPRECATED_CHROME_API',
  'extension.onRequestExternal': 'DEPRECATED_CHROME_API',
  'extension.sendRequest': 'DEPRECATED_CHROME_API',
  'tabs.getAllInWindow': 'DEPRECATED_CHROME_API',
  'tabs.getSelected': 'DEPRECATED_CHROME_API',
  'tabs.onActiveChanged': 'DEPRECATED_CHROME_API',
  'tabs.onSelectionChanged': 'DEPRECATED_CHROME_API',
  'tabs.sendRequest': 'DEPRECATED_CHROME_API',
  // https://github.com/mozilla/addons-linter/issues/2556
  'proxy.register': 'DEPRECATED_API',
  'proxy.unregister': 'DEPRECATED_API',
  'proxy.onProxyError': 'DEPRECATED_API',
  'proxy.registerProxyScript': 'DEPRECATED_API'
};

// A list of magic numbers that we won't allow.
const FLAGGED_FILE_MAGIC_NUMBERS = exports.FLAGGED_FILE_MAGIC_NUMBERS = [[0x4d, 0x5a],
// EXE or DLL,
[0x5a, 0x4d],
// Alternative EXE or DLL
[0x7f, 0x45, 0x4c, 0x46],
// UNIX elf
[0x23, 0x21],
// Shell script
[0xca, 0xfe, 0xba, 0xbe],
// Java + Mach-O (dylib)
[0xca, 0xfe, 0xd0, 0x0d],
// Java packed
[0x43, 0x57, 0x53] // Compressed SWF
];

// These are APIs that will cause problems when loaded temporarily
// in about:debugging.
// APIs listed here should be defined in https://mzl.la/31p4AMc
const TEMPORARY_APIS = exports.TEMPORARY_APIS = ['identity.getRedirectURL', 'storage.sync', 'storage.managed', 'runtime.onMessageExternal', 'runtime.onConnectExternal'];

// All valid CSP keywords that are options to keys like `default-src` and
// `script-src`. Used in manifest.json parser for validation.
// See https://mzl.la/2vwqbGU for more details and allowed options.
const CSP_KEYWORD_RE = exports.CSP_KEYWORD_RE = /^'(self|none|wasm-unsafe-eval)'$|^moz-extension:/;
const MESSAGES_JSON = exports.MESSAGES_JSON = 'messages.json';
const LOCALES_DIRECTORY = exports.LOCALES_DIRECTORY = '_locales';

// This is a string, since it has to be matched globally on a message string.
// This should match
// https://searchfox.org/mozilla-central/rev/3abf6fa7e2a6d9a7bfb88796141b0f012e68c2db/toolkit/components/extensions/ExtensionCommon.jsm#1711
const MESSAGE_PLACEHOLDER_REGEXP = exports.MESSAGE_PLACEHOLDER_REGEXP = '\\$([a-zA-Z0-9_@]+)\\$';

// yauzl should trow error with this message in case of corrupt zip file
const ZIP_LIB_CORRUPT_FILE_ERROR = exports.ZIP_LIB_CORRUPT_FILE_ERROR = 'end of central directory record signature not found';

// URLs in this array are restricted from being used in the manifest.json "homepage_url" prperty
const RESTRICTED_HOMEPAGE_URLS = exports.RESTRICTED_HOMEPAGE_URLS = ['addons-dev.allizom.org', 'addons.mozilla.org'];

// This map should contain entries with a permission name as key and a min
// Firefox version as value (both string values).
const RESTRICTED_PERMISSIONS = exports.RESTRICTED_PERMISSIONS = new Map([
// See: https://bugzilla.mozilla.org/show_bug.cgi?id=1733159
['proxy', '91.1.0']]);
const SCHEMA_KEYWORDS_CUSTOM = exports.SCHEMA_KEYWORDS_CUSTOM = {
  MIN_MANIFEST_VERSION: 'min_manifest_version',
  MAX_MANIFEST_VERSION: 'max_manifest_version',
  PRIVILEGED: 'privileged',
  // This custom keyword doesn't exist on the Firefox side, but it is injected into the
  // schema data as part of the schema data inmport and used by the linter to hook up
  // custom validation logic for privileged permissions.
  VALIDATE_PRIVILEGED_PERMISSIONS: 'validatePrivilegedPermissions'
};
const SCHEMA_KEYWORDS = exports.SCHEMA_KEYWORDS = {
  // Keywords defined in the JSON schema specs.
  ANY_OF: 'anyOf',
  DEPRECATED: 'deprecated',
  REQUIRED: 'required',
  TYPE: 'type',
  MIN_PROPERTIES: 'minProperties',
  // Non-standard JSONSchema keywords (defined and used by the Firefox and/or addons-linter).
  ...SCHEMA_KEYWORDS_CUSTOM
};

/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.UNADVISED_LIBRARIES = exports.BANNED_LIBRARIES = void 0;
const BANNED_LIBRARIES = exports.BANNED_LIBRARIES = ['angularjs.1.0.2.angular.js', 'angularjs.1.0.2.angular.min.js', 'angularjs.1.0.3.angular.js', 'angularjs.1.0.3.angular.min.js', 'angularjs.1.0.4.angular.js', 'angularjs.1.0.4.angular.min.js', 'angularjs.1.0.5.angular.js', 'angularjs.1.0.5.angular.min.js', 'angularjs.1.0.6.angular.js', 'angularjs.1.0.6.angular.min.js', 'angularjs.1.0.7.angular.js', 'angularjs.1.0.7.angular.min.js', 'angularjs.1.0.8.angular.js', 'angularjs.1.0.8.angular.min.js', 'angularjs.1.1.0.angular.js', 'angularjs.1.1.0.angular.min.js', 'angularjs.1.1.1.angular.js', 'angularjs.1.1.1.angular.min.js', 'angularjs.1.1.2.angular.js', 'angularjs.1.1.2.angular.min.js', 'angularjs.1.1.3.angular.js', 'angularjs.1.1.3.angular.min.js', 'angularjs.1.1.4.angular.js', 'angularjs.1.1.4.angular.min.js', 'angularjs.1.1.5.angular.js', 'angularjs.1.1.5.angular.min.js', 'angularjs.1.2.0.angular.js', 'angularjs.1.2.0.angular.min.js', 'angularjs.1.2.1.angular.js', 'angularjs.1.2.1.angular.min.js', 'angularjs.1.2.2.angular.js', 'angularjs.1.2.2.angular.min.js', 'angularjs.1.2.3.angular.js', 'angularjs.1.2.3.angular.min.js', 'angularjs.1.2.4.angular.js', 'angularjs.1.2.4.angular.min.js', 'angularjs.1.2.5.angular.js', 'angularjs.1.2.5.angular.min.js', 'angularjs.1.2.6.angular.js', 'angularjs.1.2.6.angular.min.js', 'angularjs.1.2.7.angular.js', 'angularjs.1.2.7.angular.min.js', 'angularjs.1.2.8.angular.js', 'angularjs.1.2.8.angular.min.js', 'angularjs.1.2.9.angular.js', 'angularjs.1.2.9.angular.min.js', 'angularjs.1.2.10.angular.js', 'angularjs.1.2.10.angular.min.js', 'angularjs.1.2.11.angular.js', 'angularjs.1.2.11.angular.min.js', 'angularjs.1.2.12.angular.js', 'angularjs.1.2.12.angular.min.js', 'angularjs.1.2.13.angular.js', 'angularjs.1.2.13.angular.min.js', 'angularjs.1.2.14.angular.js', 'angularjs.1.2.14.angular.min.js', 'angularjs.1.2.15.angular.js', 'angularjs.1.2.15.angular.min.js', 'angularjs.1.2.16.angular.js', 'angularjs.1.2.16.angular.min.js', 'angularjs.1.2.17.angular.js', 'angularjs.1.2.17.angular.min.js', 'angularjs.1.2.18.angular.js', 'angularjs.1.2.18.angular.min.js', 'angularjs.1.2.19.angular.js', 'angularjs.1.2.19.angular.min.js', 'angularjs.1.2.20.angular.js', 'angularjs.1.2.20.angular.min.js', 'angularjs.1.2.21.angular.js', 'angularjs.1.2.21.angular.min.js', 'angularjs.1.2.22.angular.js', 'angularjs.1.2.22.angular.min.js', 'angularjs.1.2.23.angular.js', 'angularjs.1.2.23.angular.min.js', 'angularjs.1.2.24.angular.js', 'angularjs.1.2.24.angular.min.js', 'angularjs.1.2.25.angular.js', 'angularjs.1.2.25.angular.min.js', 'angularjs.1.2.26.angular.js', 'angularjs.1.2.26.angular.min.js', 'angularjs.1.2.27.angular.js', 'angularjs.1.2.27.angular.min.js', 'angularjs.1.2.28.angular.js', 'angularjs.1.2.28.angular.min.js', 'angularjs.1.2.29.angular.js', 'angularjs.1.2.29.angular.min.js', 'angularjs.1.2.30.angular.js', 'angularjs.1.2.30.angular.min.js', 'angularjs.1.3.0.angular.js', 'angularjs.1.3.0.angular.min.js', 'angularjs.1.3.1.angular.js', 'angularjs.1.3.1.angular.min.js', 'angularjs.1.3.2.angular.js', 'angularjs.1.3.2.angular.min.js', 'angularjs.1.3.3.angular.js', 'angularjs.1.3.3.angular.min.js', 'angularjs.1.3.4.angular.js', 'angularjs.1.3.4.angular.min.js', 'angularjs.1.3.5.angular.js', 'angularjs.1.3.5.angular.min.js', 'angularjs.1.3.6.angular.js', 'angularjs.1.3.6.angular.min.js', 'angularjs.1.3.7.angular.js', 'angularjs.1.3.7.angular.min.js', 'angularjs.1.3.8.angular.js', 'angularjs.1.3.8.angular.min.js', 'angularjs.1.3.9.angular.js', 'angularjs.1.3.9.angular.min.js', 'angularjs.1.3.10.angular.js', 'angularjs.1.3.10.angular.min.js', 'angularjs.1.3.11.angular.js', 'angularjs.1.3.11.angular.min.js', 'angularjs.1.3.12.angular.js', 'angularjs.1.3.12.angular.min.js', 'angularjs.1.3.13.angular.js', 'angularjs.1.3.13.angular.min.js', 'angularjs.1.3.14.angular.js', 'angularjs.1.3.14.angular.min.js', 'angularjs.1.3.15.angular.js', 'angularjs.1.3.15.angular.min.js', 'angularjs.1.3.16.angular.js', 'angularjs.1.3.16.angular.min.js', 'angularjs.1.3.17.angular.js', 'angularjs.1.3.17.angular.min.js', 'angularjs.1.3.18.angular.js', 'angularjs.1.3.18.angular.min.js', 'angularjs.1.3.19.angular.js', 'angularjs.1.3.19.angular.min.js', 'angularjs.1.3.20.angular.js', 'angularjs.1.3.20.angular.min.js', 'angularjs.1.4.0.angular.js', 'angularjs.1.4.0.angular.min.js', 'angularjs.1.4.1.angular.js', 'angularjs.1.4.1.angular.min.js', 'angularjs.1.4.2.angular.js', 'angularjs.1.4.2.angular.min.js', 'angularjs.1.4.3.angular.js', 'angularjs.1.4.3.angular.min.js', 'angularjs.1.4.4.angular.js', 'angularjs.1.4.4.angular.min.js', 'angularjs.1.4.5.angular.js', 'angularjs.1.4.5.angular.min.js', 'angularjs.1.4.6.angular.js', 'angularjs.1.4.6.angular.min.js', 'angularjs.1.4.7.angular.js', 'angularjs.1.4.7.angular.min.js', 'angularjs.1.4.8.angular.js', 'angularjs.1.4.8.angular.min.js', 'angularjs.1.4.9.angular.js', 'angularjs.1.4.9.angular.min.js', 'angularjs.1.4.10.angular.js', 'angularjs.1.4.10.angular.min.js', 'angularjs.1.4.11.angular.js', 'angularjs.1.4.11.angular.min.js', 'angularjs.1.4.12.angular.js', 'angularjs.1.4.12.angular.min.js', 'angularjs.1.5.0.angular.js', 'angularjs.1.5.0.angular.min.js', 'angularjs.1.5.1.angular.js', 'angularjs.1.5.1.angular.min.js', 'angularjs.1.5.2.angular.js', 'angularjs.1.5.2.angular.min.js', 'angularjs.1.5.3.angular.js', 'angularjs.1.5.3.angular.min.js', 'angularjs.1.5.4.angular.js', 'angularjs.1.5.4.angular.min.js', 'angularjs.1.5.5.angular.js', 'angularjs.1.5.5.angular.min.js', 'angularjs.1.5.6.angular.js', 'angularjs.1.5.6.angular.min.js', 'angularjs.1.5.7.angular.js', 'angularjs.1.5.7.angular.min.js', 'angularjs.1.5.8.angular.js', 'angularjs.1.5.8.angular.min.js', 'angularjs.1.5.9.angular.js', 'angularjs.1.5.9.angular.min.js', 'angularjs.1.6.0.angular.js', 'angularjs.1.6.0.angular.min.js', 'angularjs.1.6.1.angular.js', 'angularjs.1.6.1.angular.min.js', 'angularjs.1.6.2.angular.js', 'angularjs.1.6.2.angular.min.js', 'angularjs.1.6.3.angular.js', 'angularjs.1.6.3.angular.min.js', 'angularjs.1.6.4.angular.js', 'angularjs.1.6.4.angular.min.js', 'angularjs.1.6.5.angular.js', 'angularjs.1.6.5.angular.min.js', 'angularjs.1.6.6.angular.js', 'angularjs.1.6.6.angular.min.js', 'angularjs.1.6.7.angular.js', 'angularjs.1.6.7.angular.min.js', 'angularjs.1.6.8.angular.js', 'angularjs.1.6.8.angular.min.js', 'angularjs.1.6.9.angular.js', 'angularjs.1.6.9.angular.min.js', 'angularjs.1.6.10.angular.js', 'angularjs.1.6.10.angular.min.js', 'angularjs.1.7.0.angular.js', 'angularjs.1.7.0.angular.min.js', 'angularjs.1.7.1.angular.js', 'angularjs.1.7.1.angular.min.js', 'angularjs.1.7.2.angular.js', 'angularjs.1.7.2.angular.min.js', 'angularjs.1.7.3.angular.js', 'angularjs.1.7.3.angular.min.js', 'angularjs.1.7.4.angular.js', 'angularjs.1.7.4.angular.min.js', 'angularjs.1.7.5.angular.js', 'angularjs.1.7.5.angular.min.js', 'angularjs.1.7.6.angular.js', 'angularjs.1.7.6.angular.min.js', 'angularjs.1.7.7.angular.js', 'angularjs.1.7.7.angular.min.js', 'angularjs.1.7.8.angular.js', 'angularjs.1.7.8.angular.min.js', 'angularjs.1.7.9.angular.js', 'angularjs.1.7.9.angular.min.js', 'angularjs.1.8.0.angular.js', 'angularjs.1.8.0.angular.min.js', 'angularjs.1.8.1.angular.js', 'angularjs.1.8.1.angular.min.js', 'dompurify.1.0.0.purify.js', 'dompurify.1.0.0.purify.min.js', 'dompurify.1.0.1.purify.js', 'dompurify.1.0.1.purify.min.js', 'dompurify.1.0.2.purify.js', 'dompurify.1.0.2.purify.min.js', 'dompurify.1.0.3.purify.js', 'dompurify.1.0.3.purify.min.js', 'dompurify.1.0.4.purify.js', 'dompurify.1.0.4.purify.min.js', 'dompurify.1.0.5.purify.js', 'dompurify.1.0.5.purify.min.js', 'dompurify.1.0.6.purify.js', 'dompurify.1.0.6.purify.min.js', 'dompurify.1.0.7.purify.js', 'dompurify.1.0.7.purify.min.js', 'dompurify.1.0.8.purify.js', 'dompurify.1.0.8.purify.min.js', 'dompurify.1.0.9.purify.js', 'dompurify.1.0.9.purify.min.js', 'dompurify.1.0.10.purify.js', 'dompurify.1.0.10.purify.min.js', 'dompurify.1.0.11.purify.js', 'dompurify.1.0.11.purify.min.js', 'dompurify.2.0.0.purify.js', 'dompurify.2.0.0.purify.min.js', 'dompurify.2.0.1.purify.js', 'dompurify.2.0.1.purify.min.js', 'dompurify.2.0.2.purify.js', 'dompurify.2.0.2.purify.min.js', 'dompurify.2.0.3.purify.js', 'dompurify.2.0.3.purify.min.js', 'dompurify.2.0.4.purify.js', 'dompurify.2.0.4.purify.min.js', 'dompurify.2.0.5.purify.js', 'dompurify.2.0.5.purify.min.js', 'dompurify.2.0.6.purify.js', 'dompurify.2.0.6.purify.min.js', 'dompurify.2.0.7.purify.js', 'dompurify.2.0.7.purify.min.js', 'dompurify.2.0.8.purify.js', 'dompurify.2.0.8.purify.min.js', 'dompurify.2.0.9.purify.js', 'dompurify.2.0.9.purify.min.js', 'dompurify.2.0.10.purify.js', 'dompurify.2.0.10.purify.min.js', 'dompurify.2.0.11.purify.js', 'dompurify.2.0.11.purify.min.js', 'dompurify.2.0.12.purify.js', 'dompurify.2.0.12.purify.min.js', 'dompurify.2.0.14.purify.js', 'dompurify.2.0.14.purify.min.js', 'dompurify.2.0.15.purify.js', 'dompurify.2.0.15.purify.min.js', 'dompurify.2.0.16.purify.js', 'dompurify.2.0.16.purify.min.js', 'dompurify.2.0.17.purify.js', 'dompurify.2.0.17.purify.min.js', 'dompurify.2.1.0.purify.js', 'dompurify.2.1.0.purify.min.js', 'dompurify.2.1.1.purify.js', 'dompurify.2.1.1.purify.min.js', 'dompurify.2.2.0.purify.js', 'dompurify.2.2.0.purify.min.js', 'dompurify.2.2.1.purify.js', 'dompurify.2.2.1.purify.min.js', 'dompurify.2.2.2.purify.js', 'dompurify.2.2.2.purify.min.js', 'dompurify.2.2.3.purify.js', 'dompurify.2.2.3.purify.min.js', 'dompurify.2.2.4.purify.js', 'dompurify.2.2.4.purify.min.js', 'jquery.1.2.1.jquery.js', 'jquery.1.2.1.jquery.min.js', 'jquery.1.2.2.jquery.js', 'jquery.1.2.2.jquery.min.js', 'jquery.1.2.3.jquery.js', 'jquery.1.2.3.jquery.min.js', 'jquery.1.2.4.jquery.js', 'jquery.1.2.4.jquery.min.js', 'jquery.1.2.5.jquery.js', 'jquery.1.2.5.jquery.min.js', 'jquery.1.2.6.jquery.js', 'jquery.1.2.6.jquery.min.js', 'jquery.1.2.jquery.js', 'jquery.1.2.jquery.min.js', 'jquery.1.3.1.jquery.js', 'jquery.1.3.1.jquery.min.js', 'jquery.1.3.2.jquery.js', 'jquery.1.3.2.jquery.min.js', 'jquery.1.3.jquery.js', 'jquery.1.3.jquery.min.js', 'jquery.1.4.1.jquery.js', 'jquery.1.4.1.jquery.min.js', 'jquery.1.4.2.jquery.js', 'jquery.1.4.2.jquery.min.js', 'jquery.1.4.3.jquery.js', 'jquery.1.4.3.jquery.min.js', 'jquery.1.4.4.jquery.js', 'jquery.1.4.4.jquery.min.js', 'jquery.1.4.jquery.js', 'jquery.1.4.jquery.min.js', 'jquery.1.5.1.jquery.js', 'jquery.1.5.1.jquery.min.js', 'jquery.1.5.2.jquery.js', 'jquery.1.5.2.jquery.min.js', 'jquery.1.5.jquery.js', 'jquery.1.5.jquery.min.js', 'jquery.1.6.1.jquery.js', 'jquery.1.6.1.jquery.min.js', 'jquery.1.6.2.jquery.js', 'jquery.1.6.2.jquery.min.js', 'jquery.1.6.3.jquery.js', 'jquery.1.6.3.jquery.min.js', 'jquery.1.6.4.jquery.js', 'jquery.1.6.4.jquery.min.js', 'jquery.1.6.jquery.js', 'jquery.1.6.jquery.min.js', 'jquery.1.7.0.jquery.js', 'jquery.1.7.0.jquery.min.js', 'jquery.1.7.1.jquery.js', 'jquery.1.7.1.jquery.min.js', 'jquery.1.7.2.jquery.js', 'jquery.1.7.2.jquery.min.js', 'jquery.1.8.0.jquery.js', 'jquery.1.8.0.jquery.min.js', 'jquery.1.8.1.jquery.js', 'jquery.1.8.1.jquery.min.js', 'jquery.1.8.2.jquery.js', 'jquery.1.8.2.jquery.min.js', 'jquery.1.8.3.jquery.js', 'jquery.1.8.3.jquery.min.js', 'jquery.1.9.0.jquery.js', 'jquery.1.9.0.jquery.min.js', 'jquery.1.9.1.jquery.js', 'jquery.1.9.1.jquery.min.js', 'jquery.1.10.0.jquery.js', 'jquery.1.10.0.jquery.min.js', 'jquery.1.10.1.jquery.js', 'jquery.1.10.1.jquery.min.js', 'jquery.1.10.2.jquery.js', 'jquery.1.10.2.jquery.min.js', 'jquery.1.11.0.jquery.js', 'jquery.1.11.0.jquery.min.js', 'jquery.1.11.1.jquery.js', 'jquery.1.11.1.jquery.min.js', 'jquery.1.11.2.jquery.js', 'jquery.1.11.2.jquery.min.js', 'jquery.1.11.3.jquery.js', 'jquery.1.11.3.jquery.min.js', 'jquery.1.12.0.jquery.js', 'jquery.1.12.0.jquery.min.js', 'jquery.1.12.1.jquery.js', 'jquery.1.12.1.jquery.min.js', 'jquery.1.12.2.jquery.js', 'jquery.1.12.2.jquery.min.js', 'jquery.1.12.3.jquery.js', 'jquery.1.12.3.jquery.min.js', 'jquery.1.12.4.jquery.js', 'jquery.1.12.4.jquery.min.js', 'jquery.2.0.0.jquery.js', 'jquery.2.0.0.jquery.min.js', 'jquery.2.0.1.jquery.js', 'jquery.2.0.1.jquery.min.js', 'jquery.2.0.2.jquery.js', 'jquery.2.0.2.jquery.min.js', 'jquery.2.0.3.jquery.js', 'jquery.2.0.3.jquery.min.js', 'jquery.2.1.0.jquery.js', 'jquery.2.1.0.jquery.min.js', 'jquery.2.1.1.jquery.js', 'jquery.2.1.1.jquery.min.js', 'jquery.2.1.2.jquery.js', 'jquery.2.1.2.jquery.min.js', 'jquery.2.1.3.jquery.js', 'jquery.2.1.3.jquery.min.js', 'jquery.2.1.4.jquery.js', 'jquery.2.1.4.jquery.min.js', 'jquery.2.2.0.jquery.js', 'jquery.2.2.0.jquery.min.js', 'jquery.2.2.1.jquery.js', 'jquery.2.2.1.jquery.min.js', 'jquery.2.2.2.jquery.js', 'jquery.2.2.2.jquery.min.js', 'jquery.2.2.3.jquery.js', 'jquery.2.2.3.jquery.min.js', 'jquery.2.2.4.jquery.js', 'jquery.2.2.4.jquery.min.js'];
const UNADVISED_LIBRARIES = exports.UNADVISED_LIBRARIES = [];

/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var _html = __webpack_require__(18);
Object.keys(_html).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _html[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _html[key];
    }
  });
});
var _javascript = __webpack_require__(23);
Object.keys(_javascript).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _javascript[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _javascript[key];
    }
  });
});
var _json = __webpack_require__(24);
Object.keys(_json).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _json[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _json[key];
    }
  });
});
var _layout = __webpack_require__(25);
Object.keys(_layout).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _layout[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _layout[key];
    }
  });
});
var _manifestjson = __webpack_require__(26);
Object.keys(_manifestjson).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _manifestjson[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _manifestjson[key];
    }
  });
});
var _fluent = __webpack_require__(27);
Object.keys(_fluent).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _fluent[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _fluent[key];
    }
  });
});
var _localeMessagesjson = __webpack_require__(28);
Object.keys(_localeMessagesjson).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _localeMessagesjson[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _localeMessagesjson[key];
    }
  });
});

/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.REMOTE_SCRIPT = exports.INLINE_SCRIPT = void 0;
var _utils = __webpack_require__(19);
const INLINE_SCRIPT = exports.INLINE_SCRIPT = {
  code: 'INLINE_SCRIPT',
  message: _utils.i18n._('Inline scripts blocked by default'),
  description: _utils.i18n._(`Default CSP rules prevent inline JavaScript
    from running (https://mzl.la/2pn32nd).`)
};
const REMOTE_SCRIPT = exports.REMOTE_SCRIPT = {
  code: 'REMOTE_SCRIPT',
  message: _utils.i18n._('Remote scripts are not allowed as per the Add-on Policies.'),
  description: _utils.i18n._(`Please include all scripts in the add-on.
    For more information, refer to https://mzl.la/2uEOkYp.`)
};

/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AddonsLinterUserError = void 0;
exports.androidStrictMinVersion = androidStrictMinVersion;
exports.apiToMessage = apiToMessage;
exports.basicCompatVersionComparison = basicCompatVersionComparison;
exports.checkMinNodeVersion = checkMinNodeVersion;
exports.couldBeMinifiedCode = couldBeMinifiedCode;
exports.createCompatibilityRule = createCompatibilityRule;
exports.ensureFilenameExists = ensureFilenameExists;
exports.errorParamsToUnsupportedVersionRange = errorParamsToUnsupportedVersionRange;
exports.firefoxStrictMinVersion = firefoxStrictMinVersion;
exports.firstStableVersion = firstStableVersion;
exports.getLineAndColumnFromMatch = getLineAndColumnFromMatch;
exports.getPackageTypeAsString = getPackageTypeAsString;
exports.getRootExpression = getRootExpression;
exports.getVariable = getVariable;
exports.i18n = void 0;
exports.ignorePrivateFunctions = ignorePrivateFunctions;
exports.isBrowserNamespace = isBrowserNamespace;
exports.isCompatible = isCompatible;
exports.isLocalUrl = isLocalUrl;
exports.isToolkitVersionString = isToolkitVersionString;
exports.isValidVersionString = isValidVersionString;
exports.normalizePath = normalizePath;
exports.parseCspPolicy = parseCspPolicy;
var _url = _interopRequireDefault(__webpack_require__(20));
var _upath = _interopRequireDefault(__webpack_require__(21));
var _semver = _interopRequireDefault(__webpack_require__(22));
var _commonTags = __webpack_require__(3);
var _const = __webpack_require__(15);
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const SOURCE_MAP_RE = /\/\/[#@]\s(source(?:Mapping)?URL)=\s*(\S+)/;
// For MV2 add-ons, Firefox's version format is laxer than Chrome's, it accepts:
// https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions/manifest.json/version/format
// We choose a slightly restricted version of that format (but still more
// permissive than Chrome) to allow Beta addons, per:
// https://extensionworkshop.com/documentation/publish/distribute-pre-release-versions/
const TOOLKIT_VERSION_REGEX = /^(\d+\.?){1,3}\.(\d+([A-z]+(-?\d+)?))$/;
// 1.2.3buildid5.6 is used in practice but not matched by TOOLKIT_VERSION_REGEX.
// Use this pattern to accept the used format without being too permissive.
// See https://github.com/mozilla/addons-linter/issues/3998
const TOOLKIT_WITH_BUILDID_REGEX = /^\d+(?:\.\d+){0,2}buildid\d{8}\.\d{6}$/;
function isToolkitVersionString(version) {
  // We should be starting with a string. Limit length, see bug 1393644
  if (typeof version !== 'string' || version.length > 100) {
    return false;
  }
  return TOOLKIT_VERSION_REGEX.test(version) || TOOLKIT_WITH_BUILDID_REGEX.test(version);
}
function isValidVersionString(version) {
  // We should be starting with a string. Limit length, see bug 1393644
  if (typeof version !== 'string' || version.length > 100) {
    return false;
  }
  const parts = version.split('.');
  if (parts.length > 4) {
    return false;
  }

  // Non-zero values cannot start with 0 and we allow numbers up to 9 digits.
  return !parts.some(part => !/^(0|[1-9][0-9]{0,8})$/.test(part));
}

// Represents an error condition related to a user error (e.g. an invalid
// configuration option passed to the linter class, usually through the
// command line arguments).
//
// In bin/addons-linter instances of this error are recognized through the
// error name property and by default they will be logged on stderr as
// plain error messages and the error stack trace omitted (unless explicitly
// requested by passing --stack as an additional CLI options, useful for
// debugging reasons).
class AddonsLinterUserError extends Error {
  get name() {
    return 'AddonsLinterUserError';
  }
}
exports.AddonsLinterUserError = AddonsLinterUserError;
function errorParamsToUnsupportedVersionRange(errorParams) {
  const {
    min_manifest_version,
    max_manifest_version
  } = errorParams || {};
  if (min_manifest_version != null || max_manifest_version != null) {
    return [min_manifest_version ? `< ${min_manifest_version}` : undefined, max_manifest_version ? `> ${max_manifest_version}` : undefined].filter(e => e !== undefined).join(', ');
  }
  return '';
}
function normalizePath(iconPath) {
  // Convert the icon path to a URL so we can strip any fragments and resolve
  // . and .. automatically. We need an absolute URL to use as a base so we're
  // using https://example.com/.
  const {
    pathname
  } = new URL(iconPath, 'https://example.com/');

  // Convert filename to unix path separator (as the ones stored
  // into the scanned files map).
  return _upath.default.toUnix(decodeURIComponent(pathname).slice(1));
}

/*
 * Takes an AST node and returns the root property.
 *
 * example: foo().bar.baz() will return the AST node for foo.
 */
function getRootExpression(node) {
  let root = node.callee;

  // If we encounter a member, grab the parent
  if (node.callee.type === 'MemberExpression') {
    let parent = node.callee.object;
    while (parent.type !== 'Identifier') {
      if (parent.callee.type === 'MemberExpression') {
        parent = parent.callee.object;
      } else {
        parent = parent.callee;
      }
    }
    root = parent;
  }
  return root;
}

/*
 * Get a variable from a eslint context object if it exists, otherwise
 * undefined.
 */
function getVariable(context, name) {
  const {
    variables
  } = context.getScope();
  let result;
  variables.forEach(variable => {
    if (variable.name === name && variable.defs && variable.defs[0] && variable.defs[0].name && variable.defs[0].name.parent) {
      result = variable.defs[0].name.parent.init;
    }
  });
  return result;
}

// Functionality based on oneLine from declandewet/common-tags, copied from
// mozilla/addons-frontend.
function oneLineTranslationString(translationKey) {
  if (translationKey && translationKey.replace && translationKey.trim) {
    return translationKey.replace(/(?:\n(?:\s*))+/g, ' ').trim();
  }
  return translationKey;
}

// This is a stub implementation of a i18n library, in case we want to
// re-enable localization of the project in the future.
const i18n = exports.i18n = Object.freeze({
  _: str => oneLineTranslationString(str),
  sprintf: (fmt, args) => {
    let str = fmt;
    // Replace every `%(key)s` or `%(key)d` placeholder with the actual value.
    for (const key of Object.keys(args)) {
      str = str.replace(new RegExp(`%\\(${key}\\)(d|s)`), args[key]);
    }
    return str;
  }
});

/*
 * Check the minimum node version is met
 */
async function checkMinNodeVersion(minVersion, _process = process) {
  // eslint-disable-next-line no-param-reassign
  minVersion = minVersion || '0.12.0';
  if (!_semver.default.gte(_process.version, minVersion)) {
    throw new Error((0, _commonTags.oneLine)`Node version must be ${minVersion} or
                    greater. You are using ${_process.version}.`);
  }
}
function getPackageTypeAsString(numericPackageType) {
  const packageKeys = Object.keys(_const.PACKAGE_TYPES);
  for (let i = 0; i < packageKeys.length; i++) {
    const packageType = packageKeys[i];
    if (parseInt(numericPackageType, 10) === _const.PACKAGE_TYPES[packageType]) {
      return packageType;
    }
  }
  throw new Error(`Invalid package type constant "${numericPackageType}"`);
}

/*
 * Looks through all exported functions and returns only
 * "public" *functions* that aren't prefixed with an _
 *
 * Used for ignoring private functions and constants in rules files.
 * Rules can have private functions we don't run; anything that
 * starts with an "_" shouldn't be returned.
 *
 * This exists because we export private functions in rule files
 * for testing.
 */
function ignorePrivateFunctions(list) {
  const filteredList = {};
  Object.keys(list).forEach(functionName => {
    if (functionName.startsWith('_') === false && typeof list[functionName] === 'function') {
      filteredList[functionName] = list[functionName];
    }
  });
  return filteredList;
}

/*
 * Check a filename to make sure it's valid; used by scanners so we never
 * accept new scanners that don't specify which file they're referencing.
 */
function ensureFilenameExists(filename) {
  if (typeof filename !== 'string' || filename.length < 1) {
    throw new Error('Filename is required');
  }
}
function isLocalUrl(urlInput) {
  const parsedUrl = _url.default.parse(urlInput);
  const {
    protocol,
    path
  } = parsedUrl;

  // Check protocol is chrome: or resource: if set.
  // Details on the chrome protocol are here: https://goo.gl/W52T0Q
  // Details on resource protocol are here: https://goo.gl/HHqeJA
  if (protocol && !_const.LOCAL_PROTOCOLS.includes(protocol)) {
    return false;
  }
  // Disallow protocol-free remote urls.
  if (path.startsWith('//')) {
    return false;
  }
  return true;
}
function apiToMessage(string) {
  return string.replace(/^extension/, 'ext').replace(/\./g, '_').toUpperCase().substr(0, 25);
}
function isBrowserNamespace(string) {
  return ['browser', 'chrome'].includes(string);
}
function parseCspPolicy(policy) {
  if (!policy) {
    return {};
  }

  // See https://www.w3.org/TR/CSP3/#parse-serialized-policy

  const parsedPolicy = {};
  const directives = policy.toLowerCase().split(';');
  directives.forEach(directive => {
    const tokens = directive.trim().split(/\s+/);
    const name = tokens[0];
    if (name && !parsedPolicy[name]) {
      parsedPolicy[name] = tokens.slice(1, tokens.length);
    }
  });
  return parsedPolicy;
}
function getLineAndColumnFromMatch(match) {
  const matchedLines = match.input.substr(0, match.index).split('\n');
  const matchedColumn = matchedLines.slice(-1)[0].length + 1;
  const matchedLine = matchedLines.length;
  return {
    matchedLine,
    matchedColumn
  };
}

/**
 * Determines if the source text is minified.
 * Using the percentage no. of the indented lines from a sample set of lines
 * to determine if the js file is minified.
 * Inspired by code for the Firefox Developer Toolbar.
 */
function couldBeMinifiedCode(code) {
  // Fast exit if `code` is empty. Could happen in tests, but also in real
  // files.
  if (!code) {
    return false;
  }

  // If there's a source map reference it's very certainly minified code.
  if (SOURCE_MAP_RE.test(code)) {
    return true;
  }

  // Number of lines to look at, taken from the head of the code.
  const sampleSize = 30;

  // Threshold in percent of indented lines to mark a file as not
  // minified.
  const indentCountThreshold = 20; // percentage

  // Length of a line that looks suspicious of being minified
  const hugeLinesLength = 500;

  // Number of huge lines to also mark a file as potentially minified
  // Hint: Minified AngularJS has 12 lines, jQuery 4
  const hugeLinesThreshold = 4;
  let lineEndIndex = 0;
  let lineStartIndex = 0;
  let lines = 1;
  let indentCount = 0;
  let hugeLinesCount = 0;

  // Strip comments.
  const normalizedCode = code.replace(/\/\*[\S\s]*?\*\/|\/\/.+/g, '');
  while (lines < sampleSize) {
    lineEndIndex = normalizedCode.indexOf('\n', lineStartIndex);
    if (lineEndIndex === -1) {
      break;
    }
    const currentLine = normalizedCode.slice(lineStartIndex, lineEndIndex);
    if (/^\s+/.test(currentLine)) {
      indentCount++;
    }
    if (currentLine.length >= hugeLinesLength) {
      hugeLinesCount++;
    }
    lineStartIndex = lineEndIndex + 1;
    lines++;
  }
  return indentCount / lines * 100 < indentCountThreshold || hugeLinesCount > hugeLinesThreshold;
}
function firefoxStrictMinVersion(manifestJson) {
  // Note: The _validate method of parsers/manifestjson.js copies
  // "browser_specific_settings" to "applications".
  if (manifestJson.applications && manifestJson.applications.gecko && manifestJson.applications.gecko.strict_min_version && typeof manifestJson.applications.gecko.strict_min_version === 'string') {
    return parseInt(manifestJson.applications.gecko.strict_min_version.split('.')[0], 10);
  }
  return null;
}
function androidStrictMinVersion(manifestJson) {
  // Note: The _validate method of parsers/manifestjson.js copies
  // "browser_specific_settings" to "applications".
  if (manifestJson.applications && manifestJson.applications.gecko_android && manifestJson.applications.gecko_android.strict_min_version && typeof manifestJson.applications.gecko_android.strict_min_version === 'string') {
    // Note: gecko_android is recognized since 113.
    return parseInt(manifestJson.applications.gecko_android.strict_min_version.split('.')[0], 10);
  }
  // Fall back on gecko.min_version if gecko_android.min_version isn't provided
  const version = firefoxStrictMinVersion(manifestJson);
  if (version >= 69 && version < 79) {
    // There has not been any Firefox for Android release after 68, until 79.
    // When the declared gecko.strict_min_version is in this version range,
    // treat the version as 79 to avoid useless warnings as seen in:
    // https://github.com/mozilla/addons-linter/pull/5090#issuecomment-1795770582
    return 79;
  }
  return version;
}

/**
 * @param {*} versionAdded
 * @param {number} minVersion
 * @returns {boolean} true if versionAdded has a strictly greater major version than minVersion
 */
function basicCompatVersionComparison(versionAdded, minVersion) {
  const asNumber = parseInt(versionAdded, 10);
  return !Number.isNaN(asNumber) && asNumber > minVersion;
}

/**
 * @param {*} supportInfo - bcd support info of a feature
 * @returns {string|boolean} The first version number to support the feature
 *          or a boolean indicating if the feature is supported at all. We do
 *          not consider any holes in the supported versions, only the first
 *          stable version is taken into account.
 *          May also return "preview", as defined at https://github.com/mdn/browser-compat-data/blob/main/docs/data-guidelines/index.md#choosing-preview-values
 */
function firstStableVersion(supportInfo) {
  let supportInfoArray = supportInfo;
  if (!Array.isArray(supportInfo)) {
    supportInfoArray = [supportInfo];
  }
  return supportInfoArray.reduce((versionAdded, supportEntry) => {
    if (!Object.prototype.hasOwnProperty.call(supportEntry, 'flags') && (!versionAdded || supportEntry.version_added && !basicCompatVersionComparison(supportEntry.version_added, parseInt(versionAdded, 10)))) {
      return supportEntry.version_added;
    }
    return versionAdded;
  }, false);
}
function isCompatible(bcd, path, minVersion, application) {
  const steps = path.split('.');
  let {
    api
  } = bcd.webextensions;
  for (const step of steps) {
    if (Object.prototype.hasOwnProperty.call(api, step)) {
      api = api[step];
    } else {
      break;
    }
  }
  // API namespace may be undocumented or not implemented, ignore in that case.
  if (api.__compat) {
    const supportInfo = api.__compat.support[application];
    const versionAdded = firstStableVersion(supportInfo);
    // Note: if versionAdded is false or not a number, this will return true.
    return !basicCompatVersionComparison(versionAdded, minVersion);
  }
  return true;
}
function createCompatibilityRule(application, message, context, bcd, hasBrowserApi) {
  const {
    addonMetadata
  } = context.settings;
  const minVersion = addonMetadata && firefoxStrictMinVersion({
    applications: {
      gecko: {
        strict_min_version: context.settings.addonMetadata.firefoxMinVersion
      }
    }
  });
  if (minVersion) {
    return {
      MemberExpression(node) {
        if (!node.computed && node.object.object && isBrowserNamespace(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;
          if (hasBrowserApi(namespace, property, addonMetadata) && !isCompatible(bcd, api, minVersion, application)) {
            context.report(node, message.messageFormat, {
              api,
              minVersion: addonMetadata.firefoxMinVersion
            });
          }
        }
      }
    };
  }
  return {};
}

/***/ }),
/* 20 */
/***/ ((module) => {

module.exports = require("url");

/***/ }),
/* 21 */
/***/ ((module) => {

module.exports = require("upath");

/***/ }),
/* 22 */
/***/ ((module) => {

module.exports = require("semver");

/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.UNSUPPORTED_API = exports.UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = exports.UNEXPECTED_GLOBAL_ARG = exports.UNADVISED_LIBRARY = exports.STORAGE_SYNC = exports.STORAGE_MANAGED = exports.RUNTIME_ONMESSAGEEXTERNAL = exports.RUNTIME_ONCONNECTEXTERNAL = exports.REMOVED_MV2_API = exports.OPENDIALOG_REMOTE_URI = exports.OPENDIALOG_NONLIT_URI = exports.NO_IMPLIED_EVAL = exports.NO_DOCUMENT_WRITE = exports.KNOWN_LIBRARY = exports.JS_SYNTAX_ERROR = exports.INCOMPATIBLE_API = exports.IDENTITY_GETREDIRECTURL = exports.ESLINT_OVERWRITE_MESSAGE = exports.DEPRECATED_CHROME_API = exports.DEPRECATED_API = exports.DANGEROUS_EVAL = exports.CONTENT_SCRIPT_NOT_FOUND = exports.CONTENT_SCRIPT_EMPTY = exports.BANNED_LIBRARY = exports.ANDROID_INCOMPATIBLE_API = void 0;
exports._methodPassedRemoteUri = _methodPassedRemoteUri;
exports._nonLiteralUri = _nonLiteralUri;
var _utils = __webpack_require__(19);
const JS_SYNTAX_ERROR = exports.JS_SYNTAX_ERROR = {
  code: 'JS_SYNTAX_ERROR',
  message: _utils.i18n._('JavaScript syntax error'),
  description: _utils.i18n._(`There is a JavaScript syntax error in your
    code, which might be related to some experimental JavaScript features that
    aren't an official part of the language specification and therefore not
    supported yet. The validation cannot continue on this file.`)
};
const CONTENT_SCRIPT_NOT_FOUND = exports.CONTENT_SCRIPT_NOT_FOUND = {
  code: 'CONTENT_SCRIPT_NOT_FOUND',
  legacyCode: null,
  message: _utils.i18n._('Content script file could not be found.'),
  description: _utils.i18n._('Content script file could not be found')
};
const CONTENT_SCRIPT_EMPTY = exports.CONTENT_SCRIPT_EMPTY = {
  code: 'CONTENT_SCRIPT_EMPTY',
  legacyCode: null,
  message: _utils.i18n._('Content script file name should not be empty.'),
  description: _utils.i18n._('Content script file name should not be empty')
};
function _nonLiteralUri(method) {
  return {
    code: `${method}_NONLIT_URI`.toUpperCase(),
    message: _utils.i18n.sprintf(_utils.i18n._(`"%(method)s" called with a non-literal uri`), {
      method
    }),
    description: _utils.i18n.sprintf(_utils.i18n._(`Calling "%(method)s" with variable parameters can result in
        potential security vulnerabilities if the variable contains a remote
        URI. Consider using 'window.open' with the 'chrome=no' flag.`), {
      method
    })
  };
}
function _methodPassedRemoteUri(method) {
  return {
    code: `${method}_REMOTE_URI`.toUpperCase(),
    message: _utils.i18n.sprintf(_utils.i18n._(`"%(method)s" called with non-local URI`), {
      method
    }),
    description: _utils.i18n.sprintf(_utils.i18n._(`Calling "%(method)s" with a non-local URI will result in the
        dialog being opened with chrome privileges.`), {
      method
    })
  };
}
const OPENDIALOG_REMOTE_URI = exports.OPENDIALOG_REMOTE_URI = _methodPassedRemoteUri('openDialog');
const OPENDIALOG_NONLIT_URI = exports.OPENDIALOG_NONLIT_URI = _nonLiteralUri('openDialog');
const DANGEROUS_EVAL = exports.DANGEROUS_EVAL = {
  code: 'DANGEROUS_EVAL',
  message: null,
  description: _utils.i18n._(`Evaluation of strings as code can lead to
    security vulnerabilities and performance issues, even in the
    most innocuous of circumstances. Please avoid using \`eval\` and the
    \`Function\` constructor when at all possible.`)
};
const NO_IMPLIED_EVAL = exports.NO_IMPLIED_EVAL = {
  code: 'NO_IMPLIED_EVAL',
  message: null,
  description: _utils.i18n._(`setTimeout, setInterval and execScript
    functions should be called only with function expressions as their
    first argument`)
};
const UNEXPECTED_GLOBAL_ARG = exports.UNEXPECTED_GLOBAL_ARG = {
  code: 'UNEXPECTED_GLOBAL_ARG',
  message: _utils.i18n._('Unexpected global passed as an argument'),
  description: _utils.i18n._(`Passing a global as an argument
    is not recommended. Please make this a var instead.`)
};
const NO_DOCUMENT_WRITE = exports.NO_DOCUMENT_WRITE = {
  code: 'NO_DOCUMENT_WRITE',
  message: _utils.i18n._('Use of document.write strongly discouraged.'),
  description: _utils.i18n._(`document.write will fail in many
    circumstances when used in extensions, and has potentially severe security
    repercussions when used improperly. Therefore, it should not be used.`)
};
const BANNED_LIBRARY = exports.BANNED_LIBRARY = {
  code: 'BANNED_LIBRARY',
  message: _utils.i18n._('Banned 3rd-party JS library'),
  description: _utils.i18n._(`Your add-on uses a JavaScript library we
    consider unsafe. Read more: https://bit.ly/1TRIyZY`)
};
const UNADVISED_LIBRARY = exports.UNADVISED_LIBRARY = {
  code: 'UNADVISED_LIBRARY',
  message: _utils.i18n._('Unadvised 3rd-party JS library'),
  description: _utils.i18n._(`Your add-on uses a JavaScript library we do
    not recommend. Read more: https://bit.ly/1TRIyZY`)
};
const KNOWN_LIBRARY = exports.KNOWN_LIBRARY = {
  code: 'KNOWN_LIBRARY',
  message: _utils.i18n._('Known JS library detected'),
  description: _utils.i18n._(`JavaScript libraries are discouraged for
    simple add-ons, but are generally accepted.`)
};
const UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = exports.UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT = {
  code: 'UNSAFE_VAR_ASSIGNMENT',
  // Uses original message from eslint
  message: null,
  description: _utils.i18n._(`Due to both security and performance
    concerns, this may not be set using dynamic values which have
    not been adequately sanitized. This can lead to security issues or fairly
    serious performance degradation.`)
};
const UNSUPPORTED_API = exports.UNSUPPORTED_API = {
  code: 'UNSUPPORTED_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported'),
  description: _utils.i18n._('This API has not been implemented by Firefox.')
};
const REMOVED_MV2_API = exports.REMOVED_MV2_API = {
  code: 'UNSUPPORTED_API',
  message: null,
  messageFormat: _utils.i18n._('"{{api}}" has been removed in Manifest Version 3 (`manifest_version` property)'),
  description: null
};
const DEPRECATED_API = exports.DEPRECATED_API = {
  code: 'DEPRECATED_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is deprecated'),
  description: _utils.i18n._('This API has been deprecated by Firefox.')
};
const DEPRECATED_CHROME_API = exports.DEPRECATED_CHROME_API = {
  // We are re-using the same code here for consistency and for technical
  // reasons. We aren't really able to issue different codes from the same
  // rule, so until we have to, we're going to re-use the `DEPRECATED_API`
  // code.
  // Because of that implementation detail ``description`` isn't being usable
  // too.
  code: 'DEPRECATED_API',
  message: null,
  messageFormat: _utils.i18n._('"{{api}}" is deprecated or unimplemented'),
  description: null
};
function temporaryAPI(api) {
  return {
    code: (0, _utils.apiToMessage)(api),
    message: _utils.i18n.sprintf(_utils.i18n._(`"%(api)s" can cause issues when loaded temporarily`), {
      api
    }),
    description: _utils.i18n._(`This API can cause issues when loaded
      temporarily using about:debugging in Firefox unless you specify
      "browser_specific_settings.gecko.id" in the manifest.
      Please see: https://mzl.la/2hizK4a for more.`)
  };
}
const STORAGE_SYNC = exports.STORAGE_SYNC = temporaryAPI('storage.sync');
const IDENTITY_GETREDIRECTURL = exports.IDENTITY_GETREDIRECTURL = temporaryAPI('identity.getRedirectURL');
const STORAGE_MANAGED = exports.STORAGE_MANAGED = temporaryAPI('storage.managed');
const RUNTIME_ONMESSAGEEXTERNAL = exports.RUNTIME_ONMESSAGEEXTERNAL = temporaryAPI('runtime.onMessageExternal');
const RUNTIME_ONCONNECTEXTERNAL = exports.RUNTIME_ONCONNECTEXTERNAL = temporaryAPI('runtime.onConnectExternal');
const INCOMPATIBLE_API = exports.INCOMPATIBLE_API = {
  code: 'INCOMPATIBLE_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported in Firefox version {{minVersion}}'),
  description: _utils.i18n._('This API is not implemented by the given minimum Firefox version')
};
const ANDROID_INCOMPATIBLE_API = exports.ANDROID_INCOMPATIBLE_API = {
  code: 'ANDROID_INCOMPATIBLE_API',
  message: null,
  messageFormat: _utils.i18n._('{{api}} is not supported in Firefox for Android version {{minVersion}}'),
  description: _utils.i18n._('This API is not implemented by the given minimum Firefox for Android version')
};
const ESLINT_OVERWRITE_MESSAGE = exports.ESLINT_OVERWRITE_MESSAGE = {
  'no-eval': DANGEROUS_EVAL,
  'no-implied-eval': NO_IMPLIED_EVAL,
  'no-new-func': DANGEROUS_EVAL,
  'no-unsanitized/property': UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT,
  'no-unsanitized/method': UNSAFE_DYNAMIC_VARIABLE_ASSIGNMENT,
  'webextension-unsupported-api': UNSUPPORTED_API,
  'webextension-deprecated-api': DEPRECATED_API,
  'webextension-api-compat': INCOMPATIBLE_API,
  'webextension-api-compat-android': ANDROID_INCOMPATIBLE_API
};

/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JSON_INVALID = exports.JSON_DUPLICATE_KEY = exports.JSON_BLOCK_COMMENTS = void 0;
var _utils = __webpack_require__(19);
const JSON_INVALID = exports.JSON_INVALID = {
  code: 'JSON_INVALID',
  message: _utils.i18n._('Your JSON is not valid.'),
  description: _utils.i18n._('Your JSON file could not be parsed.')
};
const JSON_BLOCK_COMMENTS = exports.JSON_BLOCK_COMMENTS = {
  code: 'JSON_BLOCK_COMMENTS',
  message: _utils.i18n._('Your JSON contains block comments.'),
  description: _utils.i18n._(`Only line comments (comments beginning with
    "//") are allowed in JSON files. Please remove block comments (comments
    beginning with "/*")`)
};
const JSON_DUPLICATE_KEY = exports.JSON_DUPLICATE_KEY = {
  code: 'JSON_DUPLICATE_KEY',
  message: _utils.i18n._('Duplicate keys are not allowed in JSON files.'),
  description: _utils.i18n._(`Duplicate key found in JSON file.`)
};

/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TYPE_NO_MANIFEST_JSON = exports.RESERVED_FILENAME = exports.INVALID_XPI_ENTRY = exports.HIDDEN_FILE = exports.FLAGGED_FILE_TYPE = exports.FLAGGED_FILE_EXTENSION = exports.FLAGGED_FILE = exports.FILE_TOO_LARGE = exports.DUPLICATE_XPI_ENTRY = exports.COINMINER_USAGE_DETECTED = exports.BAD_ZIPFILE = exports.ALREADY_SIGNED = void 0;
var _const = __webpack_require__(15);
var _utils = __webpack_require__(19);
const DUPLICATE_XPI_ENTRY = exports.DUPLICATE_XPI_ENTRY = {
  code: 'DUPLICATE_XPI_ENTRY',
  message: _utils.i18n._('Package contains duplicate entries'),
  description: _utils.i18n._(`The package contains multiple entries
    with the same name. This practice has been banned. Try unzipping
    and re-zipping your add-on package and try again.`)
};
const INVALID_XPI_ENTRY = exports.INVALID_XPI_ENTRY = {
  code: 'INVALID_XPI_ENTRY',
  // `message` will be replaced with the `InvalidZipFileError` message
  // got from the addons-scanner-utils dependency when we were reading
  // the zip file entries (in particular this would be triggered by
  // a zipfile entry using invalid characters, like '\' as a path
  // separator, and the underlying yauzl error message follows the
  // format:
  //   `invalid characters in fileName: nameOfTheInvalidZipFileEntry`
  message: 'Invalid ZIP file entry',
  description: _utils.i18n._(`The package is invalid. It may contain
    entries using invalid characters, as an example using '\\' as a
    path separator is not allowed in Firefox. Try to recreate your
    add-on package (ZIP) and make sure all entries are using '/' as the
    path separator.`)
};
const BAD_ZIPFILE = exports.BAD_ZIPFILE = {
  code: 'BAD_ZIPFILE',
  message: 'Corrupt ZIP file',
  description: _utils.i18n._('We were unable to decompress the zip file.')
};
const TYPE_NO_MANIFEST_JSON = exports.TYPE_NO_MANIFEST_JSON = {
  code: 'TYPE_NO_MANIFEST_JSON',
  message: _utils.i18n._('manifest.json was not found'),
  description: _utils.i18n._(`No manifest.json was found at the root of the extension.
    The package file must be a ZIP of the extension's files themselves, not of the
    containing directory. See: https://mzl.la/2r2McKv for more on packaging.`)
};
const FILE_TOO_LARGE = exports.FILE_TOO_LARGE = {
  code: 'FILE_TOO_LARGE',
  message: _utils.i18n._('File is too large to parse.'),
  description: _utils.i18n.sprintf(_utils.i18n._(`This file is not binary and is too large to parse. Files larger
      than %(maxFileSizeToParseMB)sMB will not be parsed. Consider moving
      large lists of data out of JavaScript files and into JSON files, or
      splitting very large files into smaller ones.`), {
    maxFileSizeToParseMB: _const.MAX_FILE_SIZE_TO_PARSE_MB
  })
};
const HIDDEN_FILE = exports.HIDDEN_FILE = {
  code: 'HIDDEN_FILE',
  message: _utils.i18n._('Hidden file flagged'),
  description: _utils.i18n._(`Hidden files complicate the
    review process and can contain sensitive information about the system that
    generated the add-on. Please modify the packaging process so that these
    files aren't included.`)
};
const FLAGGED_FILE = exports.FLAGGED_FILE = {
  code: 'FLAGGED_FILE',
  message: _utils.i18n._('Flagged filename found'),
  description: _utils.i18n._(`Files were found that are either unnecessary
    or have been included unintentionally. They should be removed.`)
};
const FLAGGED_FILE_EXTENSION = exports.FLAGGED_FILE_EXTENSION = {
  code: 'FLAGGED_FILE_EXTENSION',
  message: _utils.i18n._('Flagged file extensions found'),
  description: _utils.i18n._(`Files were found that are either unnecessary
    or have been included unintentionally. They should be removed.`)
};
const FLAGGED_FILE_TYPE = exports.FLAGGED_FILE_TYPE = {
  code: 'FLAGGED_FILE_TYPE',
  message: _utils.i18n._('Flagged file type found'),
  description: _utils.i18n._(`Files whose names end with flagged extensions
    have been found in the add-on. The extension of these files are flagged
    because they usually identify binary components. Please see
    https://bit.ly/review-policy for more information on the binary content
    review process.`)
};
const ALREADY_SIGNED = exports.ALREADY_SIGNED = {
  code: 'ALREADY_SIGNED',
  message: _utils.i18n._('Package already signed'),
  description: _utils.i18n._(`Add-ons which are already signed will be
    re-signed when published on AMO. This will replace any existing signatures
    on the add-on.`)
};
const COINMINER_USAGE_DETECTED = exports.COINMINER_USAGE_DETECTED = {
  code: 'COINMINER_USAGE_DETECTED',
  message: _utils.i18n._('Firefox add-ons are not allowed to run coin miners.'),
  description: _utils.i18n._(`We do not allow coinminer scripts to be run inside
    WebExtensions.
    See https://github.com/mozilla/addons-linter/issues/1643 for more
    details.`)
};
const RESERVED_FILENAME = exports.RESERVED_FILENAME = {
  code: 'RESERVED_FILENAME',
  message: _utils.i18n._('Reserved filename found.'),
  description: _utils.i18n._(`Files whose names are reserved have been found in
    the add-on. Please refrain from using them and rename your files.`)
};

/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WRONG_ICON_EXTENSION = exports.VERSION_FORMAT_INVALID = exports.VERSION_FORMAT_DEPRECATED = exports.STRICT_MAX_VERSION = exports.RESTRICTED_PERMISSION = exports.RESTRICTED_HOMEPAGE_URL = exports.PROP_NAME_MISSING = exports.PROP_NAME_INVALID = exports.PRIVILEGED_FEATURES_REQUIRED = exports.PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = exports.PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = exports.NO_MESSAGES_FILE_IN_LOCALES = exports.NO_MESSAGES_FILE = exports.NO_DEFAULT_LOCALE = exports.MOZILLA_ADDONS_PERMISSION_REQUIRED = exports.MANIFEST_VERSION_INVALID = exports.MANIFEST_UPDATE_URL = exports.MANIFEST_UNUSED_UPDATE = exports.MANIFEST_THEME_LWT_ALIAS = exports.MANIFEST_THEME_IMAGE_WRONG_MIME = exports.MANIFEST_THEME_IMAGE_WRONG_EXT = exports.MANIFEST_THEME_IMAGE_NOT_FOUND = exports.MANIFEST_THEME_IMAGE_MIME_MISMATCH = exports.MANIFEST_THEME_IMAGE_CORRUPTED = exports.MANIFEST_PERMISSION_UNSUPPORTED = exports.MANIFEST_PERMISSIONS_PRIVILEGED = exports.MANIFEST_PERMISSIONS = exports.MANIFEST_OPTIONAL_PERMISSIONS = exports.MANIFEST_MULTIPLE_DICTS = exports.MANIFEST_INVALID_CONTENT = exports.MANIFEST_INSTALL_ORIGINS = exports.MANIFEST_ICON_NOT_FOUND = exports.MANIFEST_HOST_PERMISSIONS = exports.MANIFEST_FIELD_UNSUPPORTED = exports.MANIFEST_FIELD_REQUIRED = exports.MANIFEST_FIELD_PRIVILEGEDONLY = exports.MANIFEST_FIELD_PRIVILEGED = exports.MANIFEST_FIELD_INVALID = exports.MANIFEST_FIELD_DEPRECATED = exports.MANIFEST_EMPTY_DICTS = exports.MANIFEST_DICT_NOT_FOUND = exports.MANIFEST_DICT_MISSING_ID = exports.MANIFEST_CSP_UNSAFE_EVAL = exports.MANIFEST_CSP = exports.MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND = exports.MANIFEST_BAD_PERMISSION = exports.MANIFEST_BAD_OPTIONAL_PERMISSION = exports.MANIFEST_BAD_HOST_PERMISSION = exports.MANIFEST_BACKGROUND_FILE_NOT_FOUND = exports.KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = exports.KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = exports.INCOGNITO_SPLIT_UNSUPPORTED = exports.IGNORED_APPLICATIONS_PROPERTY = exports.ICON_SIZE_INVALID = exports.ICON_NOT_SQUARE = exports.HIDDEN_NO_ACTION = exports.EXTENSION_ID_REQUIRED = exports.CORRUPT_ICON_FILE = exports.APPLICATIONS_INVALID = exports.APPLICATIONS_DEPRECATED = exports.ADMIN_INSTALL_ONLY_REQUIRED = exports.ADMIN_INSTALL_ONLY_PROP_RESERVED = void 0;
exports.corruptIconFile = corruptIconFile;
exports.iconIsNotSquare = iconIsNotSquare;
exports.iconSizeInvalid = iconSizeInvalid;
exports.keyFirefoxAndroidUnsupportedByMinVersion = keyFirefoxAndroidUnsupportedByMinVersion;
exports.keyFirefoxUnsupportedByMinVersion = keyFirefoxUnsupportedByMinVersion;
exports.makeRestrictedPermission = void 0;
exports.manifestBackgroundMissing = manifestBackgroundMissing;
exports.manifestContentScriptFileMissing = manifestContentScriptFileMissing;
exports.manifestCsp = manifestCsp;
exports.manifestCspUnsafeEval = manifestCspUnsafeEval;
exports.manifestDictionaryFileMissing = manifestDictionaryFileMissing;
exports.manifestFieldPrivileged = manifestFieldPrivileged;
exports.manifestFieldPrivilegedOnly = manifestFieldPrivilegedOnly;
exports.manifestFieldUnsupported = manifestFieldUnsupported;
exports.manifestIconMissing = manifestIconMissing;
exports.manifestPermissionUnsupported = manifestPermissionUnsupported;
exports.manifestPermissionsPrivileged = manifestPermissionsPrivileged;
exports.manifestPropMissing = manifestPropMissing;
exports.manifestThemeImageCorrupted = manifestThemeImageCorrupted;
exports.manifestThemeImageMimeMismatch = manifestThemeImageMimeMismatch;
exports.manifestThemeImageMissing = manifestThemeImageMissing;
exports.manifestThemeImageWrongExtension = manifestThemeImageWrongExtension;
exports.manifestThemeImageWrongMime = manifestThemeImageWrongMime;
exports.mozillaAddonsPermissionRequired = mozillaAddonsPermissionRequired;
exports.noMessagesFileInLocales = noMessagesFileInLocales;
exports.permissionFirefoxAndroidUnsupportedByMinVersion = permissionFirefoxAndroidUnsupportedByMinVersion;
exports.permissionFirefoxUnsupportedByMinVersion = permissionFirefoxUnsupportedByMinVersion;
exports.privilegedFeaturesRequired = privilegedFeaturesRequired;
var _utils = __webpack_require__(19);
var _const = __webpack_require__(15);
const PRIVILEGED_EXTENSION_SIGNING_DOCS = _utils.i18n._(`
  Please refer to https://github.com/mozilla-extensions/xpi-manifest to learn more about privileged extensions and signing.
`);
const MANIFEST_FIELD_REQUIRED = exports.MANIFEST_FIELD_REQUIRED = {
  code: 'MANIFEST_FIELD_REQUIRED',
  message: _utils.i18n._('The field is required.'),
  description: _utils.i18n._('See https://mzl.la/1ZOhoEN (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_FIELD_INVALID = exports.MANIFEST_FIELD_INVALID = {
  code: 'MANIFEST_FIELD_INVALID',
  message: _utils.i18n._('The field is invalid.'),
  description: _utils.i18n._('See https://mzl.la/1ZOhoEN (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_FIELD_PRIVILEGEDONLY = exports.MANIFEST_FIELD_PRIVILEGEDONLY = 'MANIFEST_FIELD_PRIVILEGEDONLY';
function manifestFieldPrivilegedOnly(fieldName) {
  return {
    code: MANIFEST_FIELD_PRIVILEGEDONLY,
    message: _utils.i18n.sprintf(_utils.i18n._(`"%(fieldName)s" is ignored for non-privileged add-ons.`), {
      fieldName
    }),
    description: _utils.i18n.sprintf(_utils.i18n._(`"%(fieldName)s" manifest field is only used for privileged and
        temporarily installed extensions.`), {
      fieldName
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_FIELD_UNSUPPORTED = exports.MANIFEST_FIELD_UNSUPPORTED = 'MANIFEST_FIELD_UNSUPPORTED';
function manifestFieldUnsupported(fieldName, error) {
  const versionRange = error ? (0, _utils.errorParamsToUnsupportedVersionRange)(error.params) : null;
  const messageTmpl = versionRange ? _utils.i18n._(`"%(fieldName)s" is not supported in manifest versions
        %(versionRange)s.`) : _utils.i18n._(`"%(fieldName)s" is not supported.`);
  const message = _utils.i18n.sprintf(messageTmpl, {
    fieldName,
    versionRange
  });
  return {
    code: MANIFEST_FIELD_UNSUPPORTED,
    message,
    description: message,
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_FIELD_PRIVILEGED = exports.MANIFEST_FIELD_PRIVILEGED = 'MANIFEST_FIELD_PRIVILEGED';
function manifestFieldPrivileged(error) {
  const messageTmpl = _utils.i18n._(`%(instancePath)s: privileged manifest fields
                     are only allowed in privileged extensions.`);
  const message = _utils.i18n.sprintf(messageTmpl, {
    instancePath: error.instancePath
  });
  return {
    code: MANIFEST_FIELD_PRIVILEGED,
    message,
    description: PRIVILEGED_EXTENSION_SIGNING_DOCS,
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_PERMISSION_UNSUPPORTED = exports.MANIFEST_PERMISSION_UNSUPPORTED = 'MANIFEST_PERMISSION_UNSUPPORTED';
function manifestPermissionUnsupported(permissionName, error) {
  const versionRange = (0, _utils.errorParamsToUnsupportedVersionRange)(error.params);
  const messageTmpl = versionRange ? _utils.i18n._(`/%(fieldName)s: "%(permissionName)s" is not supported in
                     manifest versions %(versionRange)s.`) : _utils.i18n._(`/%(fieldName)s: "%(permissionName)s" is not supported.`);
  const message = _utils.i18n.sprintf(messageTmpl, {
    permissionName,
    versionRange,
    fieldName: error.instancePath.match(_const.PERMS_DATAPATH_REGEX)[1]
  });
  return {
    code: MANIFEST_PERMISSION_UNSUPPORTED,
    message,
    description: message,
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_BAD_PERMISSION = exports.MANIFEST_BAD_PERMISSION = {
  code: 'MANIFEST_BAD_PERMISSION',
  message: _utils.i18n._('The permission type is unsupported.'),
  description: _utils.i18n._(`See https://mzl.la/1R1n1t0
    (MDN Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
const MANIFEST_BAD_OPTIONAL_PERMISSION = exports.MANIFEST_BAD_OPTIONAL_PERMISSION = {
  code: 'MANIFEST_BAD_OPTIONAL_PERMISSION',
  message: _utils.i18n._('The permission type is unsupported.'),
  description: _utils.i18n._(`See https://mzl.la/2Qn0fWC
    (MDN Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
const MANIFEST_BAD_HOST_PERMISSION = exports.MANIFEST_BAD_HOST_PERMISSION = {
  code: 'MANIFEST_BAD_HOST_PERMISSION',
  message: _utils.i18n._('The permission type is unsupported.'),
  description: _utils.i18n._('See https://mzl.la/3Woeqv4 (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_PERMISSIONS = exports.MANIFEST_PERMISSIONS = {
  code: 'MANIFEST_PERMISSIONS',
  message: _utils.i18n._('Unknown permission.'),
  description: _utils.i18n._('See https://mzl.la/1R1n1t0 (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_PERMISSIONS_PRIVILEGED = exports.MANIFEST_PERMISSIONS_PRIVILEGED = 'MANIFEST_PERMISSIONS_PRIVILEGED';
function manifestPermissionsPrivileged(error) {
  const messageTmpl = _utils.i18n._(`%(instancePath)s: the following privileged permissions
                     are only allowed in privileged extensions:
                     %(privilegedPermissions)s.`);
  const message = _utils.i18n.sprintf(messageTmpl, {
    instancePath: error.instancePath,
    privilegedPermissions: JSON.stringify(error.params.privilegedPermissions)
  });
  return {
    code: MANIFEST_PERMISSIONS_PRIVILEGED,
    message,
    description: PRIVILEGED_EXTENSION_SIGNING_DOCS,
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_OPTIONAL_PERMISSIONS = exports.MANIFEST_OPTIONAL_PERMISSIONS = {
  code: 'MANIFEST_OPTIONAL_PERMISSIONS',
  message: _utils.i18n._('Unknown permission.'),
  description: _utils.i18n._('See https://mzl.la/2Qn0fWC (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_HOST_PERMISSIONS = exports.MANIFEST_HOST_PERMISSIONS = {
  code: 'MANIFEST_HOST_PERMISSIONS',
  message: _utils.i18n._('Invalid host permission.'),
  description: _utils.i18n._('See https://mzl.la/3Woeqv4 (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_INSTALL_ORIGINS = exports.MANIFEST_INSTALL_ORIGINS = {
  code: 'MANIFEST_INSTALL_ORIGINS',
  message: _utils.i18n._('Invalid install origin.'),
  description: _utils.i18n._(`Invalid install origin. A valid origin has - only
    - a scheme, hostname and optional port. See https://mzl.la/3TEbqbE (MDN
    Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
const MANIFEST_VERSION_INVALID = exports.MANIFEST_VERSION_INVALID = {
  code: 'MANIFEST_VERSION_INVALID',
  message: _utils.i18n._('"manifest_version" in the manifest.json is not a valid value'),
  description: _utils.i18n._('See https://mzl.la/20PenXl (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_CSP = exports.MANIFEST_CSP = 'MANIFEST_CSP';
function manifestCsp(property) {
  return {
    // Note: don't change this 'code' without updating addons-server first, as
    // it depends on it to detect add-ons with a custom content security policy.
    code: MANIFEST_CSP,
    message: _utils.i18n.sprintf(_utils.i18n._(`"%(property)s" allows remote code execution in manifest.json`), {
      property
    }),
    description: _utils.i18n.sprintf(_utils.i18n._(`A custom "%(property)s" needs additional review.`), {
      property
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_CSP_UNSAFE_EVAL = exports.MANIFEST_CSP_UNSAFE_EVAL = 'MANIFEST_CSP_UNSAFE_EVAL';
function manifestCspUnsafeEval(property) {
  return {
    code: MANIFEST_CSP_UNSAFE_EVAL,
    message: _utils.i18n.sprintf(_utils.i18n._(`"%(property)s" allows 'eval', which has strong security and
        performance implications.`), {
      property
    }),
    description: _utils.i18n._(`In most cases the same result can be achieved
      differently, therefore it is generally prohibited`),
    file: _const.MANIFEST_JSON
  };
}
const PROP_NAME_INVALID = exports.PROP_NAME_INVALID = {
  code: 'PROP_NAME_INVALID',
  message: _utils.i18n._('The "name" property must be a string with no leading/trailing whitespaces.'),
  description: _utils.i18n._('See http://mzl.la/1STmr48 (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_UPDATE_URL = exports.MANIFEST_UPDATE_URL = {
  code: 'MANIFEST_UPDATE_URL',
  message: _utils.i18n._('"update_url" is not allowed.'),
  description: _utils.i18n._(`
    "applications.gecko.update_url" or
    "browser_specific_settings.gecko.update_url" are not allowed for
    Mozilla-hosted add-ons.`),
  file: _const.MANIFEST_JSON
};
const MANIFEST_UNUSED_UPDATE = exports.MANIFEST_UNUSED_UPDATE = {
  code: 'MANIFEST_UNUSED_UPDATE',
  message: _utils.i18n._('The "update_url" property is not used by Firefox.'),
  description: _utils.i18n._(`The "update_url" is not used by Firefox in
    the root of a manifest; your add-on will be updated via the Add-ons
    site and not your "update_url". See: https://mzl.la/25zqk4O`),
  file: _const.MANIFEST_JSON
};
const STRICT_MAX_VERSION = exports.STRICT_MAX_VERSION = {
  code: 'STRICT_MAX_VERSION',
  message: _utils.i18n._('"strict_max_version" not required.'),
  description: _utils.i18n._(`"strict_max_version" shouldn't be used unless
    the add-on is expected not to work with future versions of Firefox.`),
  file: _const.MANIFEST_JSON
};
function manifestPropMissing(property) {
  return {
    code: `PROP_${property.toUpperCase()}_MISSING`,
    message: _utils.i18n.sprintf(_utils.i18n._(`No "%(property)s" property found in manifest.json`), {
      property
    }),
    description: _utils.i18n.sprintf(_utils.i18n._(`"%(property)s" is required`), {
      property
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_ICON_NOT_FOUND = exports.MANIFEST_ICON_NOT_FOUND = 'MANIFEST_ICON_NOT_FOUND';
function manifestIconMissing(path) {
  return {
    code: MANIFEST_ICON_NOT_FOUND,
    message: _utils.i18n._('An icon defined in the manifest could not be found in the package.'),
    description: _utils.i18n.sprintf(_utils.i18n._('Icon could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_BACKGROUND_FILE_NOT_FOUND = exports.MANIFEST_BACKGROUND_FILE_NOT_FOUND = 'MANIFEST_BACKGROUND_FILE_NOT_FOUND';
function manifestBackgroundMissing(path, type) {
  return {
    code: MANIFEST_BACKGROUND_FILE_NOT_FOUND,
    legacyCode: null,
    message: type === 'script' ? _utils.i18n._('A background script defined in the manifest could not be found.') : _utils.i18n._('A background page defined in the manifest could not be found.'),
    description: _utils.i18n.sprintf(type === 'script' ? _utils.i18n._('Background script could not be found at "%(path)s".') : _utils.i18n._('Background page could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND = exports.MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND = 'MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND';
function manifestContentScriptFileMissing(path, type) {
  return {
    code: MANIFEST_CONTENT_SCRIPT_FILE_NOT_FOUND,
    legacyCode: null,
    message: type === 'script' ? _utils.i18n._('A content script defined in the manifest could not be found.') : _utils.i18n._('A content script css file defined in the manifest could not be found.'),
    description: _utils.i18n.sprintf(type === 'script' ? _utils.i18n._('Content script defined in the manifest could not be found at "%(path)s".') : _utils.i18n._('Content script css file defined in the manifest could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_DICT_NOT_FOUND = exports.MANIFEST_DICT_NOT_FOUND = 'MANIFEST_DICT_NOT_FOUND';
function manifestDictionaryFileMissing(path) {
  return {
    code: MANIFEST_DICT_NOT_FOUND,
    legacyCode: null,
    message: _utils.i18n._('A dictionary file defined in the manifest could not be found.'),
    description: _utils.i18n.sprintf(_utils.i18n._('Dictionary file defined in the manifest could not be found at "%(path)s".'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_MULTIPLE_DICTS = exports.MANIFEST_MULTIPLE_DICTS = {
  code: 'MANIFEST_MULTIPLE_DICTS',
  legacyCode: null,
  message: _utils.i18n._('The manifest contains multiple dictionaries.'),
  description: _utils.i18n._('Multiple dictionaries were defined in the manifest, which is unsupported.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_EMPTY_DICTS = exports.MANIFEST_EMPTY_DICTS = {
  code: 'MANIFEST_EMPTY_DICTS',
  legacyCode: null,
  message: _utils.i18n._('The manifest contains a dictionaries object, but it is empty.'),
  description: _utils.i18n._('A dictionaries object was defined in the manifest, but it was empty.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_DICT_MISSING_ID = exports.MANIFEST_DICT_MISSING_ID = {
  code: 'MANIFEST_DICT_MISSING_ID',
  legacyCode: null,
  message: _utils.i18n._('The manifest contains a dictionary but no id property.'),
  description: _utils.i18n._('A dictionary was found in the manifest, but there was no id set.'),
  file: _const.MANIFEST_JSON
};

// https://github.com/mozilla/addons-linter/issues/1650
// Potentially temporary
const MANIFEST_INVALID_CONTENT = exports.MANIFEST_INVALID_CONTENT = {
  code: 'MANIFEST_INVALID_CONTENT',
  message: _utils.i18n._('Forbidden content found in add-on.'),
  description: _utils.i18n._('This add-on contains forbidden content.'),
  file: _const.MANIFEST_JSON
};
const ICON_NOT_SQUARE = exports.ICON_NOT_SQUARE = 'ICON_NOT_SQUARE';
function iconIsNotSquare(path) {
  return {
    code: ICON_NOT_SQUARE,
    message: _utils.i18n._('Icons must be square.'),
    description: _utils.i18n.sprintf(_utils.i18n._('Icon at "%(path)s" must be square.'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const ICON_SIZE_INVALID = exports.ICON_SIZE_INVALID = 'ICON_SIZE_INVALID';
function iconSizeInvalid({
  path,
  expected,
  actual
}) {
  return {
    code: ICON_SIZE_INVALID,
    message: _utils.i18n._('The size of the icon does not match the manifest.'),
    description: _utils.i18n.sprintf(_utils.i18n._(`
      Expected icon at "%(path)s" to be %(expected)d pixels wide but was %(actual)d.
    `), {
      path,
      expected,
      actual
    }),
    file: _const.MANIFEST_JSON
  };
}
const CORRUPT_ICON_FILE = exports.CORRUPT_ICON_FILE = 'CORRUPT_ICON_FILE';
function corruptIconFile({
  path
}) {
  return {
    code: CORRUPT_ICON_FILE,
    message: _utils.i18n._('Corrupt image file'),
    description: _utils.i18n.sprintf(_utils.i18n._('Expected icon file at "%(path)s" is corrupted'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_FIELD_DEPRECATED = exports.MANIFEST_FIELD_DEPRECATED = {
  code: 'MANIFEST_FIELD_DEPRECATED',
  message: _utils.i18n._('This property has been deprecated.'),
  description: null,
  file: _const.MANIFEST_JSON
};
const MANIFEST_THEME_LWT_ALIAS = exports.MANIFEST_THEME_LWT_ALIAS = {
  code: 'MANIFEST_THEME_LWT_ALIAS',
  message: _utils.i18n._('This theme LWT alias has been removed in Firefox 70.'),
  description: _utils.i18n._('See https://mzl.la/2T11Lkc (MDN Docs) for more information.'),
  file: _const.MANIFEST_JSON
};
const MANIFEST_THEME_IMAGE_NOT_FOUND = exports.MANIFEST_THEME_IMAGE_NOT_FOUND = 'MANIFEST_THEME_IMAGE_NOT_FOUND';
function manifestThemeImageMissing(path, type) {
  return {
    code: MANIFEST_THEME_IMAGE_NOT_FOUND,
    message: _utils.i18n.sprintf('Theme image for "%(type)s" could not be found in the package', {
      type
    }),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image for "%(type)s" could not be found at "%(path)s"'), {
      path,
      type
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_THEME_IMAGE_CORRUPTED = exports.MANIFEST_THEME_IMAGE_CORRUPTED = 'MANIFEST_THEME_IMAGE_CORRUPTED';
function manifestThemeImageCorrupted({
  path
}) {
  return {
    code: MANIFEST_THEME_IMAGE_CORRUPTED,
    message: _utils.i18n._('Corrupted theme image file'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file at "%(path)s" is corrupted'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_THEME_IMAGE_WRONG_EXT = exports.MANIFEST_THEME_IMAGE_WRONG_EXT = 'MANIFEST_THEME_IMAGE_WRONG_EXT';
function manifestThemeImageWrongExtension({
  path
}) {
  return {
    code: MANIFEST_THEME_IMAGE_WRONG_EXT,
    message: _utils.i18n._('Theme image file has an unsupported file extension'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file at "%(path)s" has an unsupported file extension'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_THEME_IMAGE_WRONG_MIME = exports.MANIFEST_THEME_IMAGE_WRONG_MIME = 'MANIFEST_THEME_IMAGE_WRONG_MIME';
function manifestThemeImageWrongMime({
  path,
  mime
}) {
  return {
    code: MANIFEST_THEME_IMAGE_WRONG_MIME,
    message: _utils.i18n._('Theme image file has an unsupported mime type'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file at "%(path)s" has the unsupported mime type "%(mime)s"'), {
      path,
      mime
    }),
    file: _const.MANIFEST_JSON
  };
}
const MANIFEST_THEME_IMAGE_MIME_MISMATCH = exports.MANIFEST_THEME_IMAGE_MIME_MISMATCH = 'MANIFEST_THEME_IMAGE_MIME_MISMATCH';
function manifestThemeImageMimeMismatch({
  path,
  mime
}) {
  return {
    code: MANIFEST_THEME_IMAGE_MIME_MISMATCH,
    message: _utils.i18n._('Theme image file mime type does not match its file extension'),
    description: _utils.i18n.sprintf(_utils.i18n._('Theme image file extension at "%(path)s" does not match its actual mime type "%(mime)s"'), {
      path,
      mime
    }),
    file: _const.MANIFEST_JSON
  };
}
const PROP_NAME_MISSING = exports.PROP_NAME_MISSING = manifestPropMissing('name');
const NO_MESSAGES_FILE = exports.NO_MESSAGES_FILE = {
  code: 'NO_MESSAGES_FILE',
  message: _utils.i18n._('The "default_locale" is missing localizations.'),
  description: _utils.i18n._(`The "default_locale" value is specified in
    the manifest, but no matching "messages.json" in the "_locales" directory
    exists. See: https://mzl.la/2hjcaEE`),
  file: _const.MANIFEST_JSON
};
const NO_DEFAULT_LOCALE = exports.NO_DEFAULT_LOCALE = {
  code: 'NO_DEFAULT_LOCALE',
  message: _utils.i18n._('The "default_locale" is missing but "_locales" exist.'),
  description: _utils.i18n._(`The "default_locale" value is not specifed in
    the manifest, but a "_locales" directory exists.
    See: https://mzl.la/2hjcaEE`),
  file: _const.MANIFEST_JSON
};
const WRONG_ICON_EXTENSION = exports.WRONG_ICON_EXTENSION = {
  code: 'WRONG_ICON_EXTENSION',
  message: _utils.i18n._('Unsupported image extension'),
  description: _utils.i18n._('Icons should be one of JPG/JPEG, WebP, GIF, PNG or SVG.'),
  file: _const.MANIFEST_JSON
};
const IGNORED_APPLICATIONS_PROPERTY = exports.IGNORED_APPLICATIONS_PROPERTY = {
  code: 'IGNORED_APPLICATIONS_PROPERTY',
  message: _utils.i18n._('"applications" property overridden by "browser_specific_settings" property'),
  description: _utils.i18n._(`The "applications" property is being ignored because it is superseded by the "browser_specific_settings" property which is also defined in your manifest. Consider removing applications.`),
  file: _const.MANIFEST_JSON
};
const NO_MESSAGES_FILE_IN_LOCALES = exports.NO_MESSAGES_FILE_IN_LOCALES = 'NO_MESSAGES_FILE_IN_LOCALES';
function noMessagesFileInLocales(path) {
  return {
    code: NO_MESSAGES_FILE_IN_LOCALES,
    message: _utils.i18n._('Empty language directory'),
    description: _utils.i18n.sprintf(_utils.i18n._('messages.json file missing in "%(path)s"'), {
      path
    }),
    file: _const.MANIFEST_JSON
  };
}
const KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = exports.KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = 'KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION';
function keyFirefoxUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: KEY_FIREFOX_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Manifest key not supported by the specified minimum Firefox version'),
    description: _utils.i18n.sprintf(_utils.i18n._(`"strict_min_version" requires Firefox %(minVersion)s, which
        was released before version %(versionAdded)s introduced support for
        "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}
const PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = exports.PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION = 'PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION';
function permissionFirefoxUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: PERMISSION_FIREFOX_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Permission not supported by the specified minimum Firefox version'),
    description: _utils.i18n.sprintf(_utils.i18n._(`"strict_min_version" requires Firefox %(minVersion)s, which
        was released before version %(versionAdded)s introduced support for
        "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}
const KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = exports.KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = 'KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION';
function keyFirefoxAndroidUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: KEY_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Manifest key not supported by the specified minimum Firefox for Android version'),
    description: _utils.i18n.sprintf(_utils.i18n._(`"strict_min_version" requires Firefox for Android
        %(minVersion)s, which was released before version %(versionAdded)s
        introduced support for "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}
const PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = exports.PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION = 'PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION';
function permissionFirefoxAndroidUnsupportedByMinVersion(key, minVersion, versionAdded) {
  return {
    code: PERMISSION_FIREFOX_ANDROID_UNSUPPORTED_BY_MIN_VERSION,
    message: _utils.i18n._('Permission not supported by the specified minimum Firefox for Android version'),
    description: _utils.i18n.sprintf(_utils.i18n._(`"strict_min_version" requires Firefox for Android
        %(minVersion)s, which was released before version %(versionAdded)s
        introduced support for "%(key)s".`), {
      key,
      minVersion,
      versionAdded
    }),
    file: _const.MANIFEST_JSON
  };
}
const RESTRICTED_HOMEPAGE_URL = exports.RESTRICTED_HOMEPAGE_URL = {
  code: 'RESTRICTED_HOMEPAGE_URL',
  message: _utils.i18n._('Linking to "addons.mozilla.org" is not allowed'),
  description: _utils.i18n._('Links directing to "addons.mozilla.org" are not allowed to be used for homepage'),
  file: _const.MANIFEST_JSON
};
const RESTRICTED_PERMISSION = exports.RESTRICTED_PERMISSION = 'RESTRICTED_PERMISSION';
const makeRestrictedPermission = (permission, minFirefoxVersion) => {
  return {
    code: RESTRICTED_PERMISSION,
    message: _utils.i18n.sprintf(_utils.i18n._(`The "%(permission)s" permission requires
        "strict_min_version" to be set to "%(minFirefoxVersion)s" or above`), {
      permission,
      minFirefoxVersion
    }),
    description: _utils.i18n.sprintf(_utils.i18n._(`The "%(permission)s" permission requires
        "strict_min_version" to be set to "%(minFirefoxVersion)s" or above.
        Please update your manifest.json version to specify a minimum Firefox
        version.`), {
      permission,
      minFirefoxVersion
    }),
    file: _const.MANIFEST_JSON
  };
};
exports.makeRestrictedPermission = makeRestrictedPermission;
const EXTENSION_ID_REQUIRED = exports.EXTENSION_ID_REQUIRED = {
  code: 'EXTENSION_ID_REQUIRED',
  message: _utils.i18n._('The extension ID is required in Manifest Version 3 and above.'),
  description: _utils.i18n._('See https://mzl.la/3PLZYdo for more information.'),
  file: _const.MANIFEST_JSON
};
const PRIVILEGED_FEATURES_REQUIRED = exports.PRIVILEGED_FEATURES_REQUIRED = 'PRIVILEGED_FEATURES_REQUIRED';
function privilegedFeaturesRequired(error) {
  const messageTmpl = _utils.i18n._(`%(instancePath)s: Privileged extensions should declare privileged permissions.`);
  const message = _utils.i18n.sprintf(messageTmpl, {
    instancePath: error.instancePath
  });
  return {
    code: PRIVILEGED_FEATURES_REQUIRED,
    message,
    description: _utils.i18n._(`
      This extension does not declare any privileged permission. It does not need to be signed with the privileged certificate.
      Please upload it directly to https://addons.mozilla.org/.
    `),
    file: _const.MANIFEST_JSON
  };
}
const MOZILLA_ADDONS_PERMISSION_REQUIRED = exports.MOZILLA_ADDONS_PERMISSION_REQUIRED = 'MOZILLA_ADDONS_PERMISSION_REQUIRED';
function mozillaAddonsPermissionRequired(error) {
  const messageTmpl = error.instancePath === '/permissions' ? _utils.i18n._(`%(instancePath)s: The "mozillaAddons" permission is required for privileged extensions.`) : _utils.i18n._(`%(instancePath)s: The "mozillaAddons" permission is required for extensions that include privileged manifest fields.`);
  const message = _utils.i18n.sprintf(messageTmpl, {
    instancePath: error.instancePath
  });
  return {
    code: MOZILLA_ADDONS_PERMISSION_REQUIRED,
    message,
    description: error.instancePath === '/permissions' ? _utils.i18n._(`This extension does not include the "mozillaAddons" permission, which is required for privileged extensions.`) : message,
    file: _const.MANIFEST_JSON
  };
}
const HIDDEN_NO_ACTION = exports.HIDDEN_NO_ACTION = {
  code: 'HIDDEN_NO_ACTION',
  message: _utils.i18n._('Cannot use actions in hidden add-ons.'),
  description: _utils.i18n._(`The hidden and browser_action/page_action (or
    action in Manifest Version 3 and above) properties are mutually
    exclusive.`),
  file: _const.MANIFEST_JSON
};
const APPLICATIONS_DEPRECATED = exports.APPLICATIONS_DEPRECATED = {
  code: 'APPLICATIONS_DEPRECATED',
  message: _utils.i18n._('Use "browser_specific_settings" instead of "applications".'),
  description: _utils.i18n._(`The "applications" property in the manifest is
    deprecated and will no longer be accepted in Manifest Version 3 and
    above.`),
  file: _const.MANIFEST_JSON
};
const APPLICATIONS_INVALID = exports.APPLICATIONS_INVALID = {
  code: 'APPLICATIONS_INVALID',
  message: _utils.i18n._(`"applications" is no longer allowed in Manifest
    Version 3 and above.`),
  description: _utils.i18n._(`The "applications" property in the manifest is
    no longer allowed in Manifest Version 3 and above. Use
    "browser_specific_settings" instead.`),
  file: _const.MANIFEST_JSON
};
const VERSION_FORMAT_DEPRECATED = exports.VERSION_FORMAT_DEPRECATED = {
  code: 'VERSION_FORMAT_DEPRECATED',
  message: _utils.i18n._(`The version string should be simplified because it
    won't be compatible with Manifest Version 3 and above.`),
  description: _utils.i18n._(`The version should be a string with 1 to 4
    numbers separated with dots. Each number should have up to 9 digits and
    leading zeros will no longer be allowed. Letters will no longer be allowed
    either. See https://mzl.la/3h3mCRu (MDN Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
const VERSION_FORMAT_INVALID = exports.VERSION_FORMAT_INVALID = {
  code: 'VERSION_FORMAT_INVALID',
  message: _utils.i18n._('The version string should be simplified.'),
  description: _utils.i18n._(`The version should be a string with 1 to 4
    numbers separated with dots. Each number should have up to 9 digits and
    leading zeros are not allowed. Letters are no longer allowed. See
    https://mzl.la/3h3mCRu (MDN Docs) for more information.`),
  file: _const.MANIFEST_JSON
};
const INCOGNITO_SPLIT_UNSUPPORTED = exports.INCOGNITO_SPLIT_UNSUPPORTED = {
  code: 'INCOGNITO_SPLIT_UNSUPPORTED',
  message: _utils.i18n._('incognito "split" is unsupported.'),
  description: _utils.i18n._(`The incognito "split" value is unsupported and will be
    treated as "not_allowed" in Firefox. Remove the key from the manifest
    file, if your extension is compatible with Firefox's private browsing mode.`),
  file: _const.MANIFEST_JSON
};
const ADMIN_INSTALL_ONLY_PROP_RESERVED = exports.ADMIN_INSTALL_ONLY_PROP_RESERVED = {
  code: 'ADMIN_INSTALL_ONLY_PROP_RESERVED',
  message: _utils.i18n._('The "admin_install_only" property is reserved.'),
  description: _utils.i18n._(`The "admin_install_only" property is reserved and can
    only be used in enterprise add-ons.`),
  file: _const.MANIFEST_JSON
};
const ADMIN_INSTALL_ONLY_REQUIRED = exports.ADMIN_INSTALL_ONLY_REQUIRED = {
  code: 'ADMIN_INSTALL_ONLY_REQUIRED',
  message: _utils.i18n._(`"/browser_specific_settings/gecko/admin_install_only"
    property must be set to "true".`),
  description: _utils.i18n._(`The "admin_install_only" property must be set to "true"
    in an enterprise add-on.`),
  file: _const.MANIFEST_JSON
};

/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FLUENT_INVALID = void 0;
var _utils = __webpack_require__(19);
const FLUENT_INVALID = exports.FLUENT_INVALID = {
  code: 'FLUENT_INVALID',
  message: _utils.i18n._('Your FTL is not valid.'),
  description: _utils.i18n._('Your FTL file could not be parsed.')
};

/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PREDEFINED_MESSAGE_NAME = exports.NO_PLACEHOLDER_CONTENT = exports.NO_MESSAGE = exports.MISSING_PLACEHOLDER = exports.INVALID_PLACEHOLDER_NAME = exports.INVALID_MESSAGE_NAME = void 0;
var _utils = __webpack_require__(19);
const NO_MESSAGE = exports.NO_MESSAGE = {
  code: 'NO_MESSAGE',
  message: _utils.i18n._('Translation string is missing the message property'),
  description: _utils.i18n._('No "message" message property is set for a string (https://mzl.la/2DSBTjA).')
};
const PREDEFINED_MESSAGE_NAME = exports.PREDEFINED_MESSAGE_NAME = {
  code: 'PREDEFINED_MESSAGE_NAME',
  message: _utils.i18n._('String name is reserved for a predefined message'),
  description: _utils.i18n._(`String names starting with @@ get translated to built-in
    constants (https://mzl.la/2BL9ZjE).`)
};
const INVALID_MESSAGE_NAME = exports.INVALID_MESSAGE_NAME = {
  code: 'INVALID_MESSAGE_NAME',
  message: 'String name contains invalid characters',
  description: _utils.i18n._(`String name should only contain alpha-numeric
    characters, _ and @ (https://mzl.la/2Eztyi5).`)
};
const MISSING_PLACEHOLDER = exports.MISSING_PLACEHOLDER = {
  code: 'MISSING_PLACEHOLDER',
  message: _utils.i18n._('Placeholder for message is missing'),
  description: _utils.i18n._('A placeholder used in the message is not defined.')
};
const INVALID_PLACEHOLDER_NAME = exports.INVALID_PLACEHOLDER_NAME = {
  code: 'INVALID_PLACEHOLDER_NAME',
  message: _utils.i18n._('Placeholder name contains invalid characters'),
  description: _utils.i18n._(`Placeholder name should only contain alpha-numeric
    characters, _ and @ (https://mzl.la/2ExbYez).`)
};
const NO_PLACEHOLDER_CONTENT = exports.NO_PLACEHOLDER_CONTENT = {
  code: 'NO_PLACEHOLDER_CONTENT',
  message: _utils.i18n._('Placeholder is missing the content property'),
  description: _utils.i18n._(`A placeholder needs a content property defining the
    replacement of it (https://mzl.la/2DT1MQd)`)
};

/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _upath = _interopRequireDefault(__webpack_require__(21));
var _message = _interopRequireDefault(__webpack_require__(30));
var constants = _interopRequireWildcard(__webpack_require__(15));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// eslint-disable-next-line import/no-named-default

// "I have a display case ready and waiting for our newest acquisitions!"
// --Taneleer Tivan

class Collector {
  constructor(config = {}) {
    this.config = config;
    this.messagesByInstancePath = {};
    this.scannedFiles = {};
    constants.MESSAGE_TYPES.forEach(type => {
      this[`${type}s`] = [];
    });
  }
  get length() {
    let len = 0;
    constants.MESSAGE_TYPES.forEach(type => {
      len += this[`${type}s`].length;
    });
    return len;
  }
  _addMessage(type, opts, _Message = _message.default) {
    // Message will throw for incorrect types.
    // we have a test to ensure that is the case.
    const message = new _Message(type, opts);
    if (typeof this.messageList(type) === 'undefined') {
      throw new Error(`Message type "${type}" not currently collected`);
    }
    if (!this.isDuplicateMessage(message)) {
      this._recordMessage(message, type);
    }
  }
  messageList(type) {
    return this[`${type}s`];
  }
  messagesAtInstancePath(instancePath) {
    if (instancePath === undefined) {
      throw new Error('instancePath is required');
    }
    if (!this.messagesByInstancePath[instancePath]) {
      this.messagesByInstancePath[instancePath] = [];
    }
    return this.messagesByInstancePath[instancePath];
  }
  _recordMessage(message, type) {
    if (message.instancePath) {
      this.messagesAtInstancePath(message.instancePath).push(message);
    }
    this.messageList(type).push(message);
  }
  isDuplicateMessage(message) {
    if (message.instancePath) {
      const previousMessages = this.messagesAtInstancePath(message.instancePath);
      if (message.file === 'manifest.json') {
        return previousMessages.some(prevMessage => prevMessage.code === message.code);
      }
      return previousMessages.some(prevMessage => prevMessage.matches(message));
    }
    return false;
  }
  recordScannedFile(originalFilename, scanner) {
    // Convert filename to unix path separator before
    // storing it into the scanned files.
    const filename = _upath.default.toUnix(originalFilename);

    // TODO: Add some code that verifies and normalizes `filename`
    // to better avoid duplicates.
    // See https://github.com/mozilla/addons-linter/issues/1310
    if (filename in this.scannedFiles) {
      if (!this.scannedFiles[filename].includes(scanner)) {
        this.scannedFiles[filename].push(scanner);
      }
    } else {
      this.scannedFiles[filename] = [scanner];
    }
  }
  addError(opts) {
    this._addMessage(constants.VALIDATION_ERROR, opts);
  }
  addNotice(opts) {
    this._addMessage(constants.VALIDATION_NOTICE, opts);
  }
  addWarning(opts) {
    this._addMessage(constants.VALIDATION_WARNING, opts);
  }
}
exports["default"] = Collector;

/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.requiredProps = exports.props = exports["default"] = void 0;
var _commonTags = __webpack_require__(3);
var _const = __webpack_require__(15);
// These are the props we expect to pull out of
// the data object passed to the Message constructor.
const props = exports.props = ['code', 'message', 'description', 'column', 'file', 'line', 'instancePath'];
const requiredProps = exports.requiredProps = ['code', 'message', 'description'];
class Message {
  constructor(type, data = {}) {
    this.type = type;
    if (Object.prototype.hasOwnProperty.call(data, 'filename')) {
      throw new Error('The key for the file is "file" not "filename"');
    }
    props.forEach(prop => {
      this[prop] = data[prop];
    });
    const missingProps = [];
    requiredProps.forEach(prop => {
      if (typeof this[prop] === 'undefined') {
        missingProps.push(prop);
      }
    });
    if (missingProps.length) {
      throw new Error((0, _commonTags.oneLine)`Message data object is missing the
        following props: ${missingProps.join(', ')}`);
    }
  }
  get type() {
    return this._type;
  }
  set type(type) {
    if (!_const.MESSAGE_TYPES.includes(type)) {
      throw new Error((0, _commonTags.oneLine)`Message type "${type}"
        is not one of ${_const.MESSAGE_TYPES.join(', ')}`);
    }
    this._type = type;
  }
  matches(other) {
    return this.type === other.type && props.every(prop => {
      return this[prop] === other[prop];
    });
  }
}
exports["default"] = Message;

/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _path2 = _interopRequireDefault(__webpack_require__(9));
var _relaxedJson = _interopRequireDefault(__webpack_require__(32));
var _commonTags = __webpack_require__(3);
var _imageSize = _interopRequireDefault(__webpack_require__(33));
var _upath = _interopRequireDefault(__webpack_require__(21));
var _browserCompatData = _interopRequireDefault(__webpack_require__(34));
var _addonsMozCompare = __webpack_require__(35);
var _yargsOptions = __webpack_require__(6);
var _validator = __webpack_require__(36);
var _const = __webpack_require__(15);
var _logger = _interopRequireDefault(__webpack_require__(4));
var messages = _interopRequireWildcard(__webpack_require__(17));
var _json = _interopRequireDefault(__webpack_require__(110));
var _utils = __webpack_require__(19);
var _blocked_content_script_hosts = _interopRequireDefault(__webpack_require__(112));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/* eslint-disable import/namespace */

async function getStreamImageSize(stream) {
  const chunks = [];
  for await (const chunk of stream) {
    chunks.push(chunk);
    try {
      return (0, _imageSize.default)(Buffer.concat(chunks));
    } catch (error) {
      /* The size information isn't available yet */
    }
  }
  return (0, _imageSize.default)(Buffer.concat(chunks));
}
async function getImageMetadata(io, iconPath) {
  // Get a non-utf8 input stream by setting encoding to null.
  let encoding = null;
  if (iconPath.endsWith('.svg')) {
    encoding = 'utf-8';
  }
  const fileStream = await io.getFileAsStream(iconPath, {
    encoding
  });
  const data = await getStreamImageSize(fileStream);
  return {
    width: data.width,
    height: data.height,
    mime: _const.FILE_EXTENSIONS_TO_MIME[data.type]
  };
}
function getNormalizedExtension(_path) {
  return _path2.default.extname(_path).substring(1).toLowerCase();
}
class ManifestJSONParser extends _json.default {
  constructor(jsonString, collector, {
    filename = _const.MANIFEST_JSON,
    RelaxedJSON = _relaxedJson.default,
    selfHosted = (0, _yargsOptions.getDefaultConfigValue)('self-hosted'),
    schemaValidatorOptions,
    io = null,
    isAlreadySigned = false,
    isEnterprise = (0, _yargsOptions.getDefaultConfigValue)('enterprise'),
    restrictedPermissions = _const.RESTRICTED_PERMISSIONS
  } = {}) {
    super(jsonString, collector, {
      filename
    });
    this.parse(RelaxedJSON);

    // Set up some defaults in case parsing fails.
    if (typeof this.parsedJSON === 'undefined' || this.isValid === false) {
      this.parsedJSON = {
        manifest_version: null,
        name: null,
        type: _const.PACKAGE_EXTENSION,
        version: null
      };
    } else {
      // We've parsed the JSON; now we can validate the manifest.

      // --enterprise implies --self-hosted since we cannot host enterprise
      // add-ons on AMO.
      this.selfHosted = selfHosted || isEnterprise;
      this.schemaValidatorOptions = schemaValidatorOptions;
      const hasManifestKey = key => Object.prototype.hasOwnProperty.call(this.parsedJSON, key);
      this.isStaticTheme = false;
      this.isLanguagePack = false;
      this.isDictionary = false;

      // Keep the addon type detection in sync with the most updated logic
      // used on the Firefox side, as defined in ExtensionData parseManifest
      // method.
      if (hasManifestKey('theme')) {
        this.isStaticTheme = true;
      } else if (hasManifestKey('langpack_id')) {
        this.isLanguagePack = true;
      } else if (hasManifestKey('dictionaries')) {
        this.isDictionary = true;
      }
      this.io = io;
      this.isAlreadySigned = isAlreadySigned;
      this.isEnterpriseAddon = isEnterprise;
      this.isPrivilegedAddon = this.schemaValidatorOptions?.privileged ?? false;
      this.restrictedPermissions = restrictedPermissions;
      this._validate();
    }
  }
  checkKeySupport(support, minFirefoxVersion, minAndroidVersion, key, isPermission = false) {
    if (support.firefox && minFirefoxVersion) {
      // We don't have to support gaps in the `@mdn/browser-compat-data`
      // information for Firefox Desktop so far.
      const versionAdded = support.firefox.version_added;
      if ((0, _utils.basicCompatVersionComparison)(versionAdded, minFirefoxVersion)) {
        if (!isPermission) {
          this.collector.addWarning(messages.keyFirefoxUnsupportedByMinVersion(key, minFirefoxVersion, versionAdded));
        } else {
          this.collector.addNotice(messages.permissionFirefoxUnsupportedByMinVersion(key, minFirefoxVersion, versionAdded));
        }
      }
    }
    if (support.firefox_android && minAndroidVersion) {
      // `@mdn/browser-compat-data` sometimes provides data with gaps, e.g., a
      // feature was supported in Fennec (added in 56 and removed in 79) and
      // then re-added in Fenix (added in 85) and this is expressed with an
      // array of objects instead of a single object.
      //
      // This is the case of the `permissions.browsingData` on Android for
      // instance and we decided to only warn the developer if the minVersion
      // required by the extension is not greater or equal of the first version
      // where the feature was officially supported for the first time (and do
      // not warn if the minVersion is in one of the few version gaps).
      const versionAddedAndroid = (0, _utils.firstStableVersion)(support.firefox_android);
      if ((0, _utils.basicCompatVersionComparison)(versionAddedAndroid, minAndroidVersion)) {
        if (!isPermission) {
          this.collector.addWarning(messages.keyFirefoxAndroidUnsupportedByMinVersion(key, minAndroidVersion, versionAddedAndroid));
        } else {
          this.collector.addNotice(messages.permissionFirefoxAndroidUnsupportedByMinVersion(key, minAndroidVersion, versionAddedAndroid));
        }
      }
    }
  }
  checkCompatInfo(compatInfo, minFirefoxVersion, minAndroidVersion, key, manifestKeyValue) {
    for (const subkey in compatInfo) {
      if (Object.prototype.hasOwnProperty.call(compatInfo, subkey)) {
        const subkeyInfo = compatInfo[subkey];
        if (subkey === '__compat') {
          this.checkKeySupport(subkeyInfo.support, minFirefoxVersion, minAndroidVersion, key);
        } else if (typeof manifestKeyValue === 'object' && manifestKeyValue !== null && Object.prototype.hasOwnProperty.call(manifestKeyValue, subkey)) {
          this.checkCompatInfo(subkeyInfo, minFirefoxVersion, minAndroidVersion, `${key}.${subkey}`, manifestKeyValue[subkey]);
        } else if ((key === 'permissions' || key === 'optional_permissions') && manifestKeyValue.includes(subkey)) {
          this.checkKeySupport(subkeyInfo.__compat.support, minFirefoxVersion, minAndroidVersion, `${key}:${subkey}`, true);
        }
      }
    }
  }
  errorLookup(error) {
    // This is the default message.
    let baseObject = messages.JSON_INVALID;

    // This is the default from webextension-manifest-schema, but it's not a
    // super helpful error. We'll tidy it up a bit:
    if (error && error.message) {
      const lowerCaseMessage = error.message.toLowerCase();
      if (lowerCaseMessage === 'must match a schema in anyof') {
        // eslint-disable-next-line no-param-reassign
        error.message = 'is not a valid key or has invalid extra properties';
      }
    }
    const overrides = {
      message: `"${error.instancePath || '/'}" ${error.message}`,
      instancePath: error.instancePath
    };
    if (error.keyword === _const.SCHEMA_KEYWORDS.REQUIRED) {
      baseObject = messages.MANIFEST_FIELD_REQUIRED;
    } else if (error.keyword === _const.SCHEMA_KEYWORDS.DEPRECATED) {
      if (Object.prototype.hasOwnProperty.call(_const.DEPRECATED_MANIFEST_PROPERTIES, error.instancePath)) {
        baseObject = messages[_const.DEPRECATED_MANIFEST_PROPERTIES[error.instancePath]];
        if (baseObject === null) {
          baseObject = messages.MANIFEST_FIELD_DEPRECATED;
        }
        let errorDescription = baseObject.description;
        if (errorDescription === null) {
          errorDescription = error.message;
        }

        // Set the description to the actual message from the schema
        overrides.message = baseObject.message;
        overrides.description = errorDescription;
      }
      // TODO(#2462): add a messages.MANIFEST_FIELD_DEPRECATED and ensure that deprecated
      // properties are handled properly (e.g. we should also detect when the deprecated
      // keyword is actually used to warn the developer of additional properties not
      // explicitly defined in the schemas).
    } else if (error.keyword === _const.SCHEMA_KEYWORDS.MIN_MANIFEST_VERSION || error.keyword === _const.SCHEMA_KEYWORDS.MAX_MANIFEST_VERSION) {
      // Choose a different message for permissions unsupported with the
      // add-on manifest_version.
      if (_const.PERMS_DATAPATH_REGEX.test(error.instancePath)) {
        baseObject = messages.manifestPermissionUnsupported(error.data, error);
      } else if (error.instancePath === '/applications') {
        baseObject = messages.APPLICATIONS_INVALID;
      } else {
        baseObject = messages.manifestFieldUnsupported(error.instancePath, error);
      }

      // Set the message and description from the one generated by the
      // choosen message.
      overrides.message = baseObject.message;
      overrides.description = baseObject.description;
    } else if (error.instancePath.startsWith('/permissions') && error.keyword === _const.SCHEMA_KEYWORDS.VALIDATE_PRIVILEGED_PERMISSIONS && error.params.privilegedPermissions) {
      if (this.isPrivilegedAddon) {
        baseObject = error.params.privilegedPermissions.length ? messages.mozillaAddonsPermissionRequired(error) : messages.privilegedFeaturesRequired(error);
      } else {
        baseObject = messages.manifestPermissionsPrivileged(error);
      }
      overrides.message = baseObject.message;
      overrides.description = baseObject.description;
    } else if (error.instancePath.startsWith('/permissions') && typeof error.data !== 'undefined' && typeof error.data !== 'string') {
      baseObject = messages.MANIFEST_BAD_PERMISSION;
      overrides.message = `Permissions ${error.message}.`;
    } else if (error.instancePath.startsWith('/optional_permissions') && typeof error.data !== 'undefined' && typeof error.data !== 'string') {
      baseObject = messages.MANIFEST_BAD_OPTIONAL_PERMISSION;
      overrides.message = `Permissions ${error.message}.`;
    } else if (error.instancePath.startsWith('/host_permissions') && typeof error.data !== 'undefined' && typeof error.data !== 'string') {
      baseObject = messages.MANIFEST_BAD_HOST_PERMISSION;
      overrides.message = `Permissions ${error.message}.`;
    } else if (error.keyword === _const.SCHEMA_KEYWORDS.TYPE) {
      baseObject = messages.MANIFEST_FIELD_INVALID;
    } else if (error.keyword === _const.SCHEMA_KEYWORDS.PRIVILEGED) {
      baseObject = this.isPrivilegedAddon ? messages.mozillaAddonsPermissionRequired(error) : messages.manifestFieldPrivileged(error);
      overrides.message = baseObject.message;
      overrides.description = baseObject.description;
    }

    // Arrays can be extremely verbose, this tries to make them a little
    // more sane. Using a regex because there will likely be more as we
    // expand the schema.
    // Note that this works because the 2 regexps use similar patterns. We'll
    // want to adjust this if they start to differ.
    const match = error.instancePath.match(_const.PERMS_DATAPATH_REGEX) || error.instancePath.match(_const.INSTALL_ORIGINS_DATAPATH_REGEX);
    if (match && baseObject.code !== messages.MANIFEST_BAD_PERMISSION.code && baseObject.code !== messages.MANIFEST_BAD_OPTIONAL_PERMISSION.code && baseObject.code !== messages.MANIFEST_BAD_HOST_PERMISSION.code && baseObject.code !== messages.MANIFEST_PERMISSION_UNSUPPORTED) {
      baseObject = messages[`MANIFEST_${match[1].toUpperCase()}`];
      overrides.message = (0, _commonTags.oneLine)`/${match[1]}: Invalid ${match[1]}
          "${error.data}" at ${match[2]}.`;
    }

    // Make sure we filter out warnings and errors code that should never be reported
    // on manifest version 2 extensions.
    const ignoredOnMV2 = [messages.MANIFEST_HOST_PERMISSIONS.code, messages.MANIFEST_BAD_HOST_PERMISSION.code];
    if (this.parsedJSON.manifest_version === 2 && ignoredOnMV2.includes(baseObject.code)) {
      return null;
    }
    return {
      ...baseObject,
      ...overrides
    };
  }
  _validate() {
    // Not all messages returned by the schema are fatal to Firefox, messages
    // that are just warnings should be added to this array.
    const warnings = [messages.MANIFEST_PERMISSIONS.code, messages.MANIFEST_OPTIONAL_PERMISSIONS.code, messages.MANIFEST_HOST_PERMISSIONS.code, messages.MANIFEST_PERMISSION_UNSUPPORTED, messages.MANIFEST_FIELD_UNSUPPORTED];

    // Message with the following codes will be:
    //
    // - omitted if the add-on is being explicitly validated as privileged
    //   when the `--privileged` cli option was passed or `privileged` is
    //   set to true in the linter config. This is the case for privileged
    //   extensions in the https://github.com/mozilla-extensions/ org.
    //
    // - reported as warnings if the add-on is already signed
    //   (because it is expected for addons signed as privileged to be
    //   submitted to AMO to become listed, and so the warning is meant to
    //   be just informative and to let extension developers and reviewers
    //   to know that the extension is expected to be signed as privileged
    //   or it wouldn't work).
    //
    // - reported as errors if the add-on isn't signed, which should
    //   reject the submission of a privileged extension on AMO (and
    //   have it signed with a non privileged certificate by mistake).
    const privilegedManifestMessages = [messages.MANIFEST_PERMISSIONS_PRIVILEGED, messages.MANIFEST_FIELD_PRIVILEGED];
    if (this.isAlreadySigned) {
      warnings.push(...privilegedManifestMessages);
    }
    let validate = _validator.validateAddon;
    if (this.isStaticTheme) {
      validate = _validator.validateStaticTheme;
    } else if (this.isLanguagePack) {
      validate = _validator.validateLangPack;
    } else if (this.isDictionary) {
      validate = _validator.validateDictionary;
    }
    this.isValid = validate(this.parsedJSON, this.schemaValidatorOptions);
    if (!this.isValid) {
      _logger.default.debug('Schema Validation messages', JSON.stringify(validate.errors, null, 2));
      validate.errors.forEach(error => {
        const message = this.errorLookup(error);

        // errorLookup call returned a null or undefined message,
        // and so the error should be ignored.
        if (!message) {
          return;
        }
        if (warnings.includes(message.code)) {
          this.collector.addWarning(message);
        } else {
          this.collector.addError(message);
        }

        // Add-ons with bad permissions will fail to install in Firefox, so
        // we consider them invalid.
        if (message.code === messages.MANIFEST_BAD_PERMISSION.code) {
          this.isValid = false;
        }
      });
    }
    if (this.parsedJSON.applications?.gecko_android) {
      this.collector.addError(messages.manifestFieldUnsupported('/applications/gecko_android'));
      this.isValid = false;
    }
    if (this.parsedJSON.manifest_version < 3) {
      if (this.parsedJSON.browser_specific_settings?.gecko && this.parsedJSON.applications) {
        this.collector.addWarning(messages.IGNORED_APPLICATIONS_PROPERTY);
      } else if (this.parsedJSON.applications) {
        this.collector.addWarning(messages.APPLICATIONS_DEPRECATED);
      }
    }
    if (this.parsedJSON.browser_specific_settings && (this.parsedJSON.browser_specific_settings.gecko || this.parsedJSON.browser_specific_settings.gecko_android)) {
      this.parsedJSON.applications = {
        ...(this.parsedJSON.applications || {}),
        ...this.parsedJSON.browser_specific_settings
      };
    }

    // We only want `admin_install_only` to be set in `bss` when `--enterprise`
    // is set, otherwise we don't want the flag _at all_, which includes both
    // `bss` and `applications`.
    if (this.isEnterpriseAddon) {
      if (this.parsedJSON.browser_specific_settings?.gecko?.admin_install_only !== true) {
        this.collector.addError(messages.ADMIN_INSTALL_ONLY_REQUIRED);
        this.isValid = false;
      }
    } else if (typeof this.parsedJSON.applications?.gecko?.admin_install_only !== 'undefined') {
      this.collector.addError(messages.ADMIN_INSTALL_ONLY_PROP_RESERVED);
      this.isValid = false;
    }
    if (this.parsedJSON.content_security_policy != null) {
      this.validateCspPolicy(this.parsedJSON.content_security_policy);
    }
    if (this.parsedJSON.update_url) {
      this.collector.addNotice(messages.MANIFEST_UNUSED_UPDATE);
    }
    if (this.parsedJSON.granted_host_permissions) {
      this.collector.addWarning(messages.manifestFieldPrivilegedOnly('granted_host_permissions'));
    }
    if (this.parsedJSON.background) {
      const hasScripts = Array.isArray(this.parsedJSON.background.scripts);
      if (hasScripts) {
        this.parsedJSON.background.scripts.forEach(script => {
          this.validateFileExistsInPackage(script, 'script');
        });
      }
      const hasPage = !!this.parsedJSON.background.page;
      if (hasPage) {
        this.validateFileExistsInPackage(this.parsedJSON.background.page, 'page');
      }
      if (this.parsedJSON.background.service_worker) {
        if (!this.schemaValidatorOptions?.enableBackgroundServiceWorker) {
          // Report an error and mark the manifest as invalid if background
          // service worker support isn't enabled by the addons-linter feature
          // flag.
          if (hasScripts || hasPage) {
            this.collector.addWarning(messages.manifestFieldUnsupported('/background/service_worker'));
          } else {
            this.collector.addError(messages.manifestFieldUnsupported('/background/service_worker'));
            this.isValid = false;
          }
        } else if (this.parsedJSON.manifest_version >= 3) {
          this.validateFileExistsInPackage(this.parsedJSON.background.service_worker, 'script');
        }
      }
    }
    if (this.parsedJSON.content_scripts && this.parsedJSON.content_scripts.length) {
      this.parsedJSON.content_scripts.forEach(scriptRule => {
        if (scriptRule.matches && scriptRule.matches.length) {
          // Since `include_globs` only get's checked for patterns that are in
          // `matches` we only need to validate `matches`
          scriptRule.matches.forEach(matchPattern => {
            this.validateContentScriptMatchPattern(matchPattern);
          });
        }
        if (scriptRule.js && scriptRule.js.length) {
          scriptRule.js.forEach(script => {
            this.validateFileExistsInPackage(script, 'script', messages.manifestContentScriptFileMissing);
          });
        }
        if (scriptRule.css && scriptRule.css.length) {
          scriptRule.css.forEach(style => {
            this.validateFileExistsInPackage(style, 'css', messages.manifestContentScriptFileMissing);
          });
        }
      });
    }
    if (this.parsedJSON.dictionaries) {
      if (!this.getAddonId()) {
        this.collector.addError(messages.MANIFEST_DICT_MISSING_ID);
        this.isValid = false;
      }
      const numberOfDictionaries = Object.keys(this.parsedJSON.dictionaries).length;
      if (numberOfDictionaries < 1) {
        this.collector.addError(messages.MANIFEST_EMPTY_DICTS);
        this.isValid = false;
      } else if (numberOfDictionaries > 1) {
        this.collector.addError(messages.MANIFEST_MULTIPLE_DICTS);
        this.isValid = false;
      }
      Object.keys(this.parsedJSON.dictionaries).forEach(locale => {
        const filepath = this.parsedJSON.dictionaries[locale];
        this.validateFileExistsInPackage(filepath, 'binary', messages.manifestDictionaryFileMissing);
        // A corresponding .aff file should exist for every .dic.
        this.validateFileExistsInPackage(filepath.replace(/\.dic$/, '.aff'), 'binary', messages.manifestDictionaryFileMissing);
      });
    }
    if ((!this.selfHosted || this.isEnterpriseAddon) && this.parsedJSON.applications?.gecko?.update_url) {
      if (this.isPrivilegedAddon) {
        // We cannot know whether a privileged add-on will be listed or
        // unlisted so we only emit a warning for MANIFEST_UPDATE_URL (not an
        // error).
        this.collector.addWarning(messages.MANIFEST_UPDATE_URL);
      } else {
        this.collector.addError(messages.MANIFEST_UPDATE_URL);
        this.isValid = false;
      }
    }
    if (!this.isLanguagePack && (this.parsedJSON.applications?.gecko?.strict_max_version || this.parsedJSON.applications?.gecko_android?.strict_max_version)) {
      if (this.isDictionary) {
        // Dictionaries should not have a strict_max_version at all.
        this.isValid = false;
        this.collector.addError(messages.STRICT_MAX_VERSION);
      } else {
        // Rest of the extensions can, even though it's not recommended.
        this.collector.addNotice(messages.STRICT_MAX_VERSION);
      }
    }
    const minFirefoxVersion = (0, _utils.firefoxStrictMinVersion)(this.parsedJSON);
    const minAndroidVersion = (0, _utils.androidStrictMinVersion)(this.parsedJSON);
    if (!this.isLanguagePack && !this.isDictionary && (minFirefoxVersion || minAndroidVersion)) {
      for (const key in _browserCompatData.default.webextensions.manifest) {
        if (Object.prototype.hasOwnProperty.call(this.parsedJSON, key)) {
          const compatInfo = _browserCompatData.default.webextensions.manifest[key];
          this.checkCompatInfo(compatInfo, minFirefoxVersion, minAndroidVersion, key, this.parsedJSON[key]);
        }
      }
    }
    this.validateName();
    this.validateVersionString();
    if (this.parsedJSON.default_locale) {
      const msg = _path2.default.join(_const.LOCALES_DIRECTORY, this.parsedJSON.default_locale, 'messages.json');

      // Convert filename to unix path separator before
      // searching it into the scanned files map.
      if (!this.io.files[_upath.default.toUnix(msg)]) {
        this.collector.addError(messages.NO_MESSAGES_FILE);
        this.isValid = false;
      }
    }
    if (this?.io?.files) {
      const fileList = Object.keys(this.io.files);
      const localeDirRe = new RegExp(`^${_const.LOCALES_DIRECTORY}/(.*?)/`);
      const localeFileRe = new RegExp(`^${_const.LOCALES_DIRECTORY}/.*?/${_const.MESSAGES_JSON}$`);
      const locales = [];
      const localesWithMessagesJson = [];
      const errors = [];

      // Collect distinct locales (based on the content of `_locales/`) as
      // well as the locales for which we have a `messages.json` file.
      for (let i = 0; i < fileList.length; i++) {
        const matches = fileList[i].match(localeDirRe);
        if (matches && !locales.includes(matches[1])) {
          locales.push(matches[1]);
        }
        if (matches && fileList[i].match(localeFileRe)) {
          localesWithMessagesJson.push(matches[1]);
        }
      }

      // Emit an error for each locale without a `messages.json` file.
      for (let i = 0; i < locales.length; i++) {
        if (!localesWithMessagesJson.includes(locales[i])) {
          errors.push(messages.noMessagesFileInLocales(_path2.default.join(_const.LOCALES_DIRECTORY, locales[i])));
        }
      }

      // When there is no default locale, we do not want to emit errors for
      // missing locale files because we ignore those files.
      if (!this.parsedJSON.default_locale) {
        if (localesWithMessagesJson.length) {
          this.collector.addError(messages.NO_DEFAULT_LOCALE);
          this.isValid = false;
        }
      } else if (errors.length > 0) {
        for (const error of errors) {
          this.collector.addError(error);
        }
        this.isValid = false;
      }
    }
    if (this.parsedJSON.developer) {
      const {
        name,
        url
      } = this.parsedJSON.developer;
      if (name) {
        this.parsedJSON.author = name;
      }
      if (url) {
        this.parsedJSON.homepage_url = url;
      }
    }
    if (this.parsedJSON.homepage_url) {
      this.validateHomePageURL(this.parsedJSON.homepage_url);
    }
    this.validateRestrictedPermissions();
    this.validateExtensionID();
    this.validateHiddenAddon();
    this.validateDeprecatedBrowserStyle();
    this.validateIncognito();
  }

  /**
   * This method validates the manifest's name property in addition to the
   * basic json schema validation. The name should not contain unnecessary
   * whitespaces.
   */
  validateName() {
    const {
      name
    } = this.parsedJSON;
    // The JSON schema validation already emits an error for non-string values.
    if (typeof name !== 'string') {
      return;
    }

    // We are relying on the `trim` function to remove the whitespaces but it
    // doesn't cover all possible whitespace-like chars. See:
    // https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String/trim
    const trimmedName = name.trim();
    if (trimmedName !== name || trimmedName.length < 2) {
      this.collector.addError(messages.PROP_NAME_INVALID);
      this.isValid = false;
    }
  }

  /**
   * This method determines whether the value of the `version` manifest key is
   * valid for both AMO and Firefox, and strictness is a bit different depending
   * on the manifest version.
   *
   * For MV3+: we enforce the following format: the value must be a string that
   * has between 1 and 4 numbers, separated with dots. Each number must have up
   * to 9 digits and leading zeros are not allowed.
   *
   * For MV2 only: if the value matches the toolkit version, we emit a warning.
   * Otherwise, we enforce the same format as defined above for MV3 and above.
   */
  validateVersionString() {
    const {
      version
    } = this.parsedJSON;
    if ((0, _utils.isValidVersionString)(version)) {
      return;
    }
    if (this.parsedJSON.manifest_version < 3 && (0, _utils.isToolkitVersionString)(version)) {
      this.collector.addWarning(messages.VERSION_FORMAT_DEPRECATED);
    } else {
      this.collector.addError(messages.VERSION_FORMAT_INVALID);
      this.isValid = false;
    }
  }
  validateHiddenAddon() {
    // Only privileged add-ons can use the `hidden` manifest property.
    if (!this.isPrivilegedAddon) {
      return;
    }
    if (this.parsedJSON.hidden && ('action' in this.parsedJSON || 'browser_action' in this.parsedJSON ||
    // Note: When this was introduced, it was stricter than the Firefox
    // side because Firefox didn't restrict `page_action` in Bug 1781998.
    'page_action' in this.parsedJSON)) {
      this.collector.addError(messages.HIDDEN_NO_ACTION);
      this.isValid = false;
    }
  }
  validateDeprecatedBrowserStyle() {
    if (this.parsedJSON.manifest_version !== 3) {
      // The deprecation only affects MV2 -> MV3.
      return;
    }
    const checkBrowserStyleInManifestKey = manifestKey => {
      // Warn about `browser_style:true` because it is not compatible with
      // "future" Firefox versions (Firefox 118+). We don't warn about
      // `browser_style:false` because it is equivalent to not setting the
      // property. Furthermore, setting it to false ensures a consistent
      // appearance of MV3 extensions in Firefox 114 and earlier, because the
      // default of options_ui.browser_style and sidebar_action.browser_style
      // changed from true to false in Firefox 115.
      if (this.parsedJSON[manifestKey]?.browser_style) {
        const instancePath = `/${manifestKey}/browser_style`;
        // Minimal parameters to trigger manifest error.
        const errorParam = {
          params: {
            max_manifest_version: 2
          }
        };
        this.collector.addWarning({
          instancePath,
          ...messages.manifestFieldUnsupported(instancePath, errorParam)
        });
      }
    };
    checkBrowserStyleInManifestKey('action');
    checkBrowserStyleInManifestKey('options_ui');
    checkBrowserStyleInManifestKey('page_action');
    checkBrowserStyleInManifestKey('sidebar_action');
  }
  validateRestrictedPermissions() {
    const permissions = Array.isArray(this.parsedJSON.permissions) ? this.parsedJSON.permissions : [];
    const permissionsInManifest = permissions.map(permission => String(permission).toLowerCase());
    if (permissionsInManifest.length === 0) {
      return;
    }
    const minVersionSetInManifest = String(this.getMetadata().firefoxMinVersion);
    for (const permission of this.restrictedPermissions.keys()) {
      if (permissionsInManifest.includes(permission)) {
        const permMinVersion = this.restrictedPermissions.get(permission);
        if (!minVersionSetInManifest || (0, _addonsMozCompare.mozCompare)(minVersionSetInManifest, permMinVersion) === -1) {
          this.collector.addError(messages.makeRestrictedPermission(permission, permMinVersion));
          this.isValid = false;
        }
      }
    }
  }
  validateExtensionID() {
    if (this.parsedJSON.manifest_version < 3) {
      return;
    }
    if (!this.parsedJSON.applications?.gecko?.id) {
      this.collector.addError(messages.EXTENSION_ID_REQUIRED);
      this.isValid = false;
    }
  }
  async validateIcon(iconPath, expectedSize) {
    try {
      const info = await getImageMetadata(this.io, iconPath);
      if (info.width !== info.height) {
        if (info.mime !== 'image/svg+xml') {
          this.collector.addError(messages.iconIsNotSquare(iconPath));
          this.isValid = false;
        } else {
          this.collector.addWarning(messages.iconIsNotSquare(iconPath));
        }
      } else if (expectedSize !== null && info.mime !== 'image/svg+xml' && parseInt(info.width, 10) !== parseInt(expectedSize, 10)) {
        this.collector.addWarning(messages.iconSizeInvalid({
          path: iconPath,
          expected: parseInt(expectedSize, 10),
          actual: parseInt(info.width, 10)
        }));
      }
    } catch (err) {
      _logger.default.debug(`Unexpected error raised while validating icon "${iconPath}"`, err);
      this.collector.addWarning(messages.corruptIconFile({
        path: iconPath
      }));
    }
  }
  validateIcons() {
    const icons = [];
    if (this.parsedJSON.icons) {
      Object.keys(this.parsedJSON.icons).forEach(size => {
        icons.push([size, this.parsedJSON.icons[size]]);
      });
    }

    // Check for default_icon key at each of the action properties
    ['browser_action', 'page_action', 'sidebar_action'].forEach(key => {
      if (this.parsedJSON[key] && this.parsedJSON[key].default_icon) {
        if (typeof this.parsedJSON[key].default_icon === 'string') {
          icons.push([null, this.parsedJSON[key].default_icon]);
        } else {
          Object.keys(this.parsedJSON[key].default_icon).forEach(size => {
            icons.push([size, this.parsedJSON[key].default_icon[size]]);
          });
        }
      }
    });

    // Check for the theme_icons from the browser_action
    if (this.parsedJSON.browser_action && this.parsedJSON.browser_action.theme_icons) {
      this.parsedJSON.browser_action.theme_icons.forEach(icon => {
        ['dark', 'light'].forEach(theme => {
          if (icon[theme]) {
            icons.push([icon.size, icon[theme]]);
          }
        });
      });
    }
    const promises = [];
    const errorIcons = [];
    icons.forEach(([size, iconPath]) => {
      const _path = (0, _utils.normalizePath)(iconPath);
      if (!Object.prototype.hasOwnProperty.call(this.io.files, _path)) {
        if (!errorIcons.includes(_path)) {
          this.collector.addError(messages.manifestIconMissing(_path));
          this.isValid = false;
          errorIcons.push(_path);
        }
      } else if (!_const.IMAGE_FILE_EXTENSIONS.includes(getNormalizedExtension(_path))) {
        if (!errorIcons.includes(_path)) {
          this.collector.addWarning(messages.WRONG_ICON_EXTENSION);
        }
      } else {
        promises.push(this.validateIcon(_path, size));
      }
    });
    return Promise.all(promises);
  }
  async validateThemeImage(imagePath, manifestPropName) {
    const _path = (0, _utils.normalizePath)(imagePath);
    const ext = getNormalizedExtension(imagePath);
    const fileExists = this.validateFileExistsInPackage(_path, `theme.images.${manifestPropName}`, messages.manifestThemeImageMissing);

    // No need to validate the image format if the file doesn't exist
    // on disk.
    if (!fileExists) {
      return;
    }
    if (!_const.IMAGE_FILE_EXTENSIONS.includes(ext) || ext === 'webp') {
      this.collector.addError(messages.manifestThemeImageWrongExtension({
        path: _path
      }));
      this.isValid = false;
      return;
    }
    try {
      const info = await getImageMetadata(this.io, _path);
      if (!_const.STATIC_THEME_IMAGE_MIMES.includes(info.mime) || info.mime === 'image/webp') {
        this.collector.addError(messages.manifestThemeImageWrongMime({
          path: _path,
          mime: info.mime
        }));
        this.isValid = false;
      } else if (_const.FILE_EXTENSIONS_TO_MIME[ext] !== info.mime) {
        this.collector.addWarning(messages.manifestThemeImageMimeMismatch({
          path: _path,
          mime: info.mime
        }));
      }
    } catch (err) {
      _logger.default.debug(`Unexpected error raised while validating theme image "${_path}"`, err.message);
      this.collector.addError(messages.manifestThemeImageCorrupted({
        path: _path
      }));
      this.isValid = false;
    }
  }
  validateStaticThemeImages() {
    const promises = [];
    const themeImages = this.parsedJSON.theme && this.parsedJSON.theme.images;

    // The theme.images manifest property is mandatory on Firefox < 60, but optional
    // on Firefox >= 60.
    if (themeImages) {
      for (const prop of Object.keys(themeImages)) {
        if (Array.isArray(themeImages[prop])) {
          themeImages[prop].forEach(imagePath => {
            promises.push(this.validateThemeImage(imagePath, prop));
          });
        } else {
          promises.push(this.validateThemeImage(themeImages[prop], prop));
        }
      }
    }
    return Promise.all(promises);
  }
  validateFileExistsInPackage(filePath, type, messageFunc = messages.manifestBackgroundMissing) {
    const _path = (0, _utils.normalizePath)(filePath);
    if (!Object.prototype.hasOwnProperty.call(this.io.files, _path)) {
      this.collector.addError(messageFunc(_path, type));
      this.isValid = false;
      return false;
    }
    return true;
  }
  validateContentScriptMatchPattern(matchPattern) {
    _blocked_content_script_hosts.default.split('\n').forEach(value => {
      if (value && value.length > 0 && value.substr(0, 1) !== '#') {
        if (matchPattern.includes(value.trim())) {
          this.collector.addError(messages.MANIFEST_INVALID_CONTENT);
          this.isValid = false;
        }
      }
    });
  }
  validateCspPolicy(policy) {
    if (typeof policy === 'string') {
      this.validateCspPolicyString(policy, 'content_security_policy');
    } else if (policy != null) {
      const keys = Object.keys(policy);
      for (const key of keys) {
        this.validateCspPolicyString(policy[key], `content_security_policy.${key}`);
      }
    }
  }
  validateCspPolicyString(policy, manifestPropName) {
    if (typeof policy !== 'string') {
      return;
    }
    const directives = (0, _utils.parseCspPolicy)(policy);

    // The order is important here, 'default-src' needs to be before
    // 'script-src' to ensure it can overwrite default-src security policies
    const candidates = ['default-src', 'script-src', 'script-src-elem', 'script-src-attr', 'worker-src'];
    const isSecureCspValue = value => _const.CSP_KEYWORD_RE.test(value);

    // A missing default-src directive is very permissive, thus insecure:
    let insecureSrcDirective = !directives['default-src'];
    let warnInsecureCsp = insecureSrcDirective;
    let warnInsecureEval = false;
    for (let i = 0; i < candidates.length; i++) {
      /* eslint-disable no-continue */
      const candidate = candidates[i];
      if (Object.prototype.hasOwnProperty.call(directives, candidate)) {
        const values = directives[candidate];

        // If the 'default-src' is insecure, check whether the 'script-src'
        // makes it secure, ie 'script-src: self;'
        //
        // NOTE: this is not yet considering script-src-elem and script-src-attr,
        // and it can't be extended to them as is, each of them on their
        // own would not fully cover an insecure src directive and they would
        // need to be appropriately combined with other directives.
        if (insecureSrcDirective && candidate === 'script-src' && values.every(isSecureCspValue)) {
          insecureSrcDirective = false;
          warnInsecureCsp = false;
          continue;
        }
        for (const value of values) {
          // Add a more detailed message for unsafe-eval to avoid confusion
          // about why it's forbidden.
          if (value === "'unsafe-eval'") {
            warnInsecureEval = true;
            continue;
          }
          if (!isSecureCspValue(value)) {
            warnInsecureCsp = true;
            // everything else looks like something we don't understand
            // / support otherwise is invalid so let's warn about that.
            if (candidate === 'default-src') {
              // Remember insecure 'default-src' to check whether a later
              // 'script-src' makes it secure
              insecureSrcDirective = true;
            }
            continue;
          }
        }
      }
    }
    if (warnInsecureEval) {
      this.collector.addWarning(messages.manifestCspUnsafeEval(manifestPropName));
    }
    if (warnInsecureCsp) {
      this.collector.addWarning(messages.manifestCsp(manifestPropName));
    }
  }
  validateHomePageURL(url) {
    for (const restrictedUrl of _const.RESTRICTED_HOMEPAGE_URLS) {
      if (url.includes(restrictedUrl)) {
        this.collector.addError(messages.RESTRICTED_HOMEPAGE_URL);
        this.isValid = false;
        return;
      }
    }
  }
  validateIncognito() {
    if (this.parsedJSON.incognito === 'split') {
      this.collector.addWarning(messages.INCOGNITO_SPLIT_UNSUPPORTED);
    }
  }
  getAddonId() {
    try {
      const {
        id
      } = this.parsedJSON.applications.gecko;
      return typeof id === 'undefined' ? null : id;
    } catch (e) {
      _logger.default.error('Failed to get the id from the manifest.');
      return null;
    }
  }
  getExperimentApiPaths() {
    const apiPaths = new Set();
    const {
      experiment_apis
    } = this.parsedJSON;
    if (experiment_apis) {
      // We need to build a list of API "paths" for each registered experimental
      // API. The data in the `manifest.json` would look like this:
      //
      // "experiment_apis": {
      //   "some-name": {
      //     "schema": "experiments/some-name/schema.json",
      //     "parent": {
      //       "scopes": ["addon_parent"],
      //       "script": "experiments/some-name/api.js",
      //       "paths": [["some", "name"]]
      //     }
      //   }
      //
      // We are interested in the `paths` array (of array), which contains API
      // "paths". We need to get each entry for each experiment and we build API
      // "paths" like:
      //
      // Set(['some.name'])
      //
      // We could have either a "parent" or "child" property for each API, or
      // both although it is less common.
      //
      for (const key of Object.keys(experiment_apis)) {
        const {
          child,
          parent
        } = experiment_apis[key];
        const parentPaths = parent?.paths ?? [];
        const childPaths = child?.paths ?? [];
        [...parentPaths, ...childPaths].filter(p => Array.isArray(p) && p.length).forEach(p => apiPaths.add(p.join('.')));
      }
    }
    return apiPaths;
  }

  /**
   * @typedef {Object} Metadata
   * @property {string} id
   * @property {number} manifestVersion
   * @property {string} name
   * @property {number} type
   * @property {string} version
   * @property {string} firefoxMinVersion
   * @property {string} firefoxStrictMinVersion
   * @property {Set<string>} experimentApiPaths
   *
   * @returns {Metadata}
   */
  getMetadata() {
    return {
      id: this.getAddonId(),
      manifestVersion: this.parsedJSON.manifest_version,
      name: this.parsedJSON.name,
      type: _const.PACKAGE_EXTENSION,
      version: this.parsedJSON.version,
      // This is the `strict_min_version` value set in the `manifest.json` file
      // for Firefox for desktop.
      firefoxMinVersion: this.parsedJSON.applications && this.parsedJSON.applications.gecko && this.parsedJSON.applications.gecko.strict_min_version,
      // This is the strict min *major* version for Firefox for desktop.
      firefoxStrictMinVersion: (0, _utils.firefoxStrictMinVersion)(this.parsedJSON),
      experimentApiPaths: this.getExperimentApiPaths()
    };
  }
}
exports["default"] = ManifestJSONParser;

/***/ }),
/* 32 */
/***/ ((module) => {

module.exports = require("@fregante/relaxed-json");

/***/ }),
/* 33 */
/***/ ((module) => {

module.exports = require("image-size");

/***/ }),
/* 34 */
/***/ ((module) => {

module.exports = require("@mdn/browser-compat-data");

/***/ }),
/* 35 */
/***/ ((module) => {

module.exports = require("addons-moz-compare");

/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SchemaValidator = void 0;
exports.getValidator = getValidator;
exports.validateStaticTheme = exports.validateLocaleMessages = exports.validateLangPack = exports.validateDictionary = exports.validateAddon = void 0;
var _ajv = _interopRequireDefault(__webpack_require__(37));
var _ajvMergePatch = _interopRequireDefault(__webpack_require__(38));
var _yargsOptions = __webpack_require__(6);
var _deepmerge = __webpack_require__(44);
var _manifest = _interopRequireDefault(__webpack_require__(46));
var _theme = _interopRequireDefault(__webpack_require__(47));
var _i18n_messages = _interopRequireDefault(__webpack_require__(48));
var _const = __webpack_require__(15);
var _formats = __webpack_require__(49);
var _imported = _interopRequireDefault(__webpack_require__(50));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function isRelevantError({
  error,
  manifest_version,
  allowedManifestVersionsRange
}) {
  // The errors related to the manifest_version are always relevant,
  // if an error has been collected for it then it is because the
  // addon manifest_version is outside or the allowed range.
  if (error.instancePath === '/manifest_version') {
    return true;
  }
  const {
    minimum,
    maximum
  } = allowedManifestVersionsRange;
  let errorMinManifestVersion = error.params?.min_manifest_version ?? error.parentSchema?.min_manifest_version ?? minimum;
  const errorMaxManifestVersion = error.params?.max_manifest_version ?? error.parentSchema?.max_manifest_version ?? maximum;

  // Make sure the computed error max version is always >= to the computed min version.
  errorMinManifestVersion = Math.min(errorMinManifestVersion, errorMaxManifestVersion);
  const isTopLevelManifestKey = error.instancePath.split('/').filter(s => s.length).length === 1;
  const errorFromAnyOf = error.schemaPath.includes('/anyOf/');
  // Skip the error if it is not in range, only when the error is:
  //
  // - not related to a top level manifest key (e.g. we still want to have a linting error
  //   if "action" or "browser_action" is being used in the wrong manifest version)
  //
  // - or part of a group of anyOf schema definitions (e.g. we don't need the errors related to
  //   web_accessible_resources schema definition that is only valid on a certain manifest
  //   version).
  const skipIfNotInRange = !isTopLevelManifestKey || errorFromAnyOf;

  // Omit errors related to a schema fragment that are not relevant
  // for the given manifest version (and also if its parent schema
  // is not relevant for the given manifest version), but only if
  // the manifest key nesting level is > 1 (so that we still include
  // errors related to top level manifest keys that are only supported
  // in specific manifest versions)
  if (skipIfNotInRange && (manifest_version < errorMinManifestVersion || manifest_version > errorMaxManifestVersion)) {
    return false;
  }

  // An error collected by an `anyOf` schema entry is relevant only if its the schema
  // entries are relevant for the given addon manifest_version.
  if (error.keyword === 'anyOf') {
    const anyOfSchemaEntries = error.schema?.filter(schema => {
      const min = schema.min_manifest_version ?? minimum;
      const max = schema.max_manifest_version ?? maximum;
      return manifest_version >= min && manifest_version <= max;
    });

    // The error is irrelevant if:
    // - there is no anyOf entry that is relevant for the given addon manifest_version
    // - there is only one relevant entry (in that case an error for that entry would
    //   have been already collected and there is no need to report it again as part
    //   of the error collected by anyOf.
    if (anyOfSchemaEntries?.length <= 1) {
      return false;
    }
  }
  return true;
}
function filterErrors(errors, {
  manifest_version,
  allowedManifestVersionsRange
} = {}) {
  if (!errors) {
    return errors;
  }
  let filteredErrors = errors.filter(error => {
    return error.keyword !== '$merge';
  });

  // Filter out errors that are not relevant for the addon manifest_version,
  // this means that:
  //
  // - for mv2 addons, the errors related to schema only supported in mv3 will not be reported
  // - similarly for mv3 addons, errors related to schema only supported in mv2 will not be reported
  //
  // This should help to avoid to report too many validation errors and to ensure that the
  // validation errors reported are all relevant for the manifest_version actually set on
  // the extension.
  if (filteredErrors.length > 0 && typeof manifest_version === 'number' && allowedManifestVersionsRange) {
    filteredErrors = filteredErrors.filter(error => isRelevantError({
      error,
      manifest_version,
      allowedManifestVersionsRange
    }));
  }
  return filteredErrors;
}
function getManifestVersionsRange(validatorOptions) {
  const {
    minManifestVersion,
    maxManifestVersion
  } = validatorOptions;
  const minimum = minManifestVersion == null ? (0, _yargsOptions.getDefaultConfigValue)('min-manifest-version') : minManifestVersion;
  const maximum = maxManifestVersion == null ? (0, _yargsOptions.getDefaultConfigValue)('max-manifest-version') : maxManifestVersion;

  // Make sure the version range is valid, if it is not:
  // raise an explicit error.
  if (minimum > maximum) {
    throw new Error(`Invalid manifest version range requested: ${JSON.stringify({
      maximum,
      minimum
    })}`);
  }
  return {
    minimum,
    maximum
  };
}
class SchemaValidator {
  /**
   * Create a SchemaValidator instance, optionally customized by the given options.
   *
   * @param {object} validatorOptions
   * @param {number} [validatorOptions.minManifestVersion]
   *   An optional parameter to be set to customize the lowest value allowed in the
   *   manifest_version manifest property of the validated extensions.
   *   Default to `getDefaultConfigValue('min-manifest-version')`.
   * @param {number} [validatorOptions.maxManifestVersion]
   *   An optional parameter to be set to customize the highest value allowed in the
   *   manifest_version manifest property of the validated extensions.
   *   Default to `getDefaultConfigValue('max-manifest-version')`.
   * @param {object} [validatorOptions.schemas]
   *   An optional parameter with a set of custom schema data to use (used in unit tests).
   *   If not passed the SchemaValidator instance defaults to the schema data imported
   *   from Firefox.
   * @param {object} [validatorOptions.schemaObject]
   *   An optional parameter with a set of custom schema data for the base manifest types
   *   (used in unit tests).
   *   If not passed the SchemaValidator instance defaults to the schema data exported
   *   from `schema/imported/manifest`.
   * @param {object} [validatorOptions.themeSchemaObject]
   *   An optional parameter with a set of custom schema data for the theme manifest types
   *   (to be used in unit tests if necessary).
   *   If not passed the SchemaValidator instance defaults to the schema data exported
   *   from `schema/imported/theme`.
   * @param {object} [validatorOptions.messagesSchemaObject]
   *   An optional parameter with a set of custom schema data for the i18n messages json
   *   files (to be used in unit tests if necessary).
   *   If not passed the SchemaValidator instance defaults to the schema data exported
   *   from `schema/i18n_messages`.
   */
  constructor(validatorOptions) {
    this._options = validatorOptions;
    this.allowedManifestVersionsRange = getManifestVersionsRange(validatorOptions);
    const validator = new _ajv.default({
      strict: false,
      allErrors: true,
      // include schema and data properties in error objects.
      verbose: true
    });
    for (const schema of Object.values(this.schemas)) {
      validator.addSchema(schema);
    }
    (0, _ajvMergePatch.default)(validator);
    this._addCustomFormats(validator);
    this._addCustomKeywords(validator);
    this._validator = validator;
  }
  matchOptions(validatorOptions) {
    if (this._options === validatorOptions) {
      return true;
    }
    const currKeys = Object.keys(this._options || {});
    const newKeys = Object.keys(validatorOptions || {});
    if (currKeys.length !== newKeys.length) {
      return false;
    }
    // Does match if the option values are strictly equal (does not if the values
    // are "deep equal", but it is enough to let us optimize the real production
    // executions and the ones from testing).
    return currKeys.every(key => this._options[key] === validatorOptions[key]);
  }
  _lazyInit() {
    // Lazily compile the addon validator, its base manifest definitions
    // are also needed for the static theme, dictionary and langpack validators.
    if (!this._addonValidator) {
      const {
        _validator
      } = this;
      this._addonValidator = this._compileAddonValidator(_validator);
    }
    return this._addonValidator;
  }
  get addonManifestVersion() {
    // Fallback to the lower allowed manifest version if there isn't
    // a numeric manifest_version value in the manifest.
    if (typeof this._options?.addonManifestVersion !== 'number') {
      return this.allowedManifestVersionsRange.minimum;
    }
    return this._options.addonManifestVersion;
  }
  get isPrivilegedAddon() {
    return this._options?.privileged ?? false;
  }
  get schemas() {
    return this._options?.schemas ?? _imported.default;
  }
  get schemaObject() {
    return this._options?.schemaObject ?? _manifest.default;
  }
  get themeSchemaObject() {
    return this._options?.themeSchemaObject ?? _theme.default;
  }
  get messagesSchemaObject() {
    return this._options?.messagesSchemaObject ?? _i18n_messages.default;
  }
  get validateAddon() {
    this._lazyInit();
    return this._addonValidator;
  }
  get validateStaticTheme() {
    this._lazyInit();
    if (!this._staticThemeValidator) {
      // Create a new schema object that merges theme.json and the regular
      // manifest.json schema.
      // Then modify the result of that to set `additionalProperties = false`
      // so that additional properties are not allowed for themes.
      // We have to use deepmerge here to make sure we can overwrite the nested
      // structure and can use object-destructuring at the root level
      // because we only overwrite `id` and `$ref` in root of the resulting object.
      // Uses ``deepPatch`` (instead of deepmerge) because we're patching a
      // complicated schema instead of simply merging them together.
      this._staticThemeValidator = this._validator.compile({
        ...(0, _deepmerge.deepPatch)(this.schemaObject, (0, _deepmerge.deepPatch)(this.themeSchemaObject, {
          types: {
            ThemeManifest: {
              $merge: {
                with: {
                  additionalProperties: false
                }
              }
            }
          }
        })),
        $id: 'static-theme-manifest',
        $ref: '#/types/ThemeManifest'
      });
    }
    return this._staticThemeValidator;
  }
  get validateLangPack() {
    this._lazyInit();
    if (!this._langPackValidator) {
      // Like with static themes, we don't want additional properties in langpacks.
      // The only difference is, this time, there is no additional schema file, we
      // just need to reference WebExtensionLangpackManifest and merge it with the
      // object that has additionalProperties: false.
      // Uses ``deepPatch`` (instead of deepmerge) because we're patching a
      // complicated schema instead of simply merging them together.
      this._langPackValidator = this._validator.compile({
        ...(0, _deepmerge.deepPatch)(this.schemaObject, {
          types: {
            WebExtensionLangpackManifest: {
              $merge: {
                with: {
                  additionalProperties: false
                }
              }
            }
          }
        }),
        $id: 'langpack-manifest',
        $ref: '#/types/WebExtensionLangpackManifest'
      });
    }
    return this._langPackValidator;
  }
  get validateDictionary() {
    this._lazyInit();
    if (!this._dictionaryValidator) {
      // Like with langpacks, we don't want additional properties in dictionaries,
      // and there is no separate schema file.
      // Uses ``deepPatch`` (instead of deepmerge) because we're patching a
      // complicated schema instead of simply merging them together.
      this._dictionaryValidator = this._validator.compile({
        ...(0, _deepmerge.deepPatch)(this.schemaObject, {
          types: {
            WebExtensionDictionaryManifest: {
              $merge: {
                with: {
                  additionalProperties: false
                }
              }
            }
          }
        }),
        $id: 'dictionary-manifest',
        $ref: '#/types/WebExtensionDictionaryManifest'
      });
    }
    return this._dictionaryValidator;
  }
  get validateLocale() {
    if (!this._localeValidator) {
      this._localeValidator = this._validator.compile({
        ...this.messagesSchemaObject,
        $id: 'i18nMessages',
        $ref: '#/types/WebExtensionI18nMessages'
      });
    }
    return this._localeValidator;
  }
  _compileAddonValidator(validator) {
    const {
      minimum,
      maximum
    } = this.allowedManifestVersionsRange;
    const manifestVersion = this.addonManifestVersion;
    const replacer = (key, value) => {
      if (Array.isArray(value)) {
        const patchedValue = value.filter(item => {
          let includeItem = true;
          if (item?.min_manifest_version && minimum < item.min_manifest_version) {
            includeItem = item.min_manifest_version >= minimum && item.min_manifest_version <= maximum && item.min_manifest_version <= manifestVersion;
          }
          if (item?.max_manifest_version && maximum > item.max_manifest_version) {
            includeItem = item.max_manifest_version >= minimum && item.max_manifest_version <= maximum && item.max_manifest_version >= manifestVersion;
          }
          return includeItem;
        });
        return patchedValue;
      }
      return value;
    };

    // Omit from the manifest schema data all entries that include a
    // min/max_manifest_version which is outside of the minimum
    // and maximum manifest_version currently allowed per validator
    // config and if they do not apply to the addon manifest_version.
    //
    // NOTE: the rest of the schema data isn't filtered based on the
    // current manifest version.
    //
    // TODO(https://github.com/mozilla/addons-linter/issues/4512):
    // this shouldn't be necessary anymore if we do generate two sets
    // of schema data (one for MV2 and one for MV3) as part of
    // importing and normalizing the JSONSchema data from Firefox.
    const patchedSchemaObject = JSON.parse(JSON.stringify(this.schemaObject, replacer, 2));
    const schemaData = (0, _deepmerge.deepPatch)(patchedSchemaObject, {
      types: {
        ManifestBase: {
          properties: {
            manifest_version: {
              minimum,
              maximum
            }
          }
        }
      }
    });
    return validator.compile({
      ...schemaData,
      $id: 'manifest',
      $ref: '#/types/WebExtensionManifest'
    });
  }
  _addCustomFormats(validator) {
    // This check is implemented in the ManifestJSONParser.
    validator.addFormat('versionString', () => true);
    validator.addFormat('contentSecurityPolicy', () => true);
    validator.addFormat('ignore', () => true);
    validator.addFormat('manifestShortcutKey', _formats.manifestShortcutKey);

    // URL formats. The format names don't mean what you'd think, see bug 1354342.
    //
    // url -> MUST be absolute URL
    // relativeUrl -> CHOICE of absolute URL or relative URL (including protocol relative)
    // strictRelativeUrl -> MUST be relative, but not protocol relative (path only)
    validator.addFormat('url', _formats.isAbsoluteUrl);
    validator.addFormat('relativeUrl', _formats.isAnyUrl);
    // homepageUrl is the same as relativeUrl but Firefox will encode | characters.
    validator.addFormat('homepageUrl', _formats.isAnyUrl);
    validator.addFormat('strictRelativeUrl', _formats.isStrictRelativeUrl);
    validator.addFormat('unresolvedRelativeUrl', _formats.isUnresolvedRelativeUrl);
    validator.addFormat('secureUrl', _formats.isSecureUrl);
    validator.addFormat('origin', _formats.isOrigin);
    validator.addFormat('imageDataOrStrictRelativeUrl', _formats.imageDataOrStrictRelativeUrl);
  }
  _addCustomKeywords(validator) {
    validator.removeKeyword(_const.SCHEMA_KEYWORDS.DEPRECATED);
    validator.addKeyword({
      keyword: _const.SCHEMA_KEYWORDS.DEPRECATED,
      validate: function validateDeprecated(message, propValue, schema, {
        instancePath
      }) {
        if (!Object.prototype.hasOwnProperty.call(_const.DEPRECATED_MANIFEST_PROPERTIES, instancePath)) {
          // Do not emit errors for every deprecated property, as it may introduce
          // regressions due to unexpected new deprecation messages raised as errors,
          // better to deal with it separately.
          return true;
        }
        validateDeprecated.errors = [{
          keyword: _const.SCHEMA_KEYWORDS.DEPRECATED,
          message
        }];
        return false;
      },
      errors: true
    });
    function createManifestVersionValidateFn(keyword, condFn) {
      // function of type SchemaValidateFunction (see ajv typescript signatures).
      return function validate(keywordSchemaValue, propValue, schema, {
        rootData /* instancePath, parentData, parentDataProperty, */
      }) {
        const manifestVersion = rootData && rootData.manifest_version || _const.MANIFEST_VERSION_DEFAULT;
        const res = condFn(keywordSchemaValue, manifestVersion);

        // If the min/max_manifest_version is set on a schema entry of type array,
        // propagate the same keyword to the `items` schema, which is needed to
        // - be able to recognize that those schema entries are also only allowed on
        //   certain manifest versions (which becomes part of the linting messages)
        // - be able to filter out the validation errors related to future (not yet
        //   supported) manifest versions if they are related to those schema entries
        //   (which happens based on the current or parent schema in the `filterErrors`
        //   helper method).
        if (schema.type === 'array') {
          // TODO(#3774): move this at "import JSONSchema data" time, and remove it from here.
          // eslint-disable-next-line no-param-reassign
          schema.items[keyword] = schema[keyword];
        }
        if (!res) {
          // If the addon manifest is out of an enum values min/max manifest version range,
          // don't report an additional validation error for the min/max_manifest_version
          // keyword validation function.
          if (schema.enum) {
            return true;
          }
          validate.errors = [{
            keyword,
            params: {
              [keyword]: keywordSchemaValue
            }
          }];
        }
        return res;
      };
    }
    validator.addKeyword({
      keyword: _const.SCHEMA_KEYWORDS.MAX_MANIFEST_VERSION,
      // function of type SchemaValidateFunction (see ajv typescript signatures).
      validate: createManifestVersionValidateFn(_const.SCHEMA_KEYWORDS.MAX_MANIFEST_VERSION, (maxMV, manifestVersion) => maxMV >= manifestVersion),
      errors: true
    });
    validator.addKeyword({
      keyword: _const.SCHEMA_KEYWORDS.MIN_MANIFEST_VERSION,
      validate: createManifestVersionValidateFn(_const.SCHEMA_KEYWORDS.MIN_MANIFEST_VERSION, (minMV, manifestVersion) => minMV <= manifestVersion),
      errors: true
    });
    const validatePrivilegedPermissions = (keywordSchemaValue, propValue) => {
      const privilegedPermissions = this.getPrivilegedPermissionsSet(validator);
      const found = new Set();
      for (const permission of propValue) {
        if (privilegedPermissions.has(permission)) {
          found.add(permission);
        }
      }
      const hasMozillaAddonsPermission = found.has('mozillaAddons');

      // If the addon is expected to be privileged, we report a linting error if:
      // - there are no privileged permissions required
      // - and/or if the "mozillaAddons" permission isn't requested (which is going
      //   to be a mandatory requirement even if there are also other privileged
      //   permissions already required).
      if (this.isPrivilegedAddon) {
        if (found.size === 0 || !hasMozillaAddonsPermission) {
          validatePrivilegedPermissions.errors = [{
            keyword: _const.SCHEMA_KEYWORDS.VALIDATE_PRIVILEGED_PERMISSIONS,
            params: {
              postprocess: keywordSchemaValue,
              privilegedPermissions: Array.from(found),
              hasMozillaAddonsPermission
            }
          }];
          return false;
        }
        return true;
      }
      if (found.size > 0) {
        validatePrivilegedPermissions.errors = [{
          keyword: _const.SCHEMA_KEYWORDS.VALIDATE_PRIVILEGED_PERMISSIONS,
          params: {
            postprocess: keywordSchemaValue,
            privilegedPermissions: Array.from(found),
            hasMozillaAddonsPermission: found.has('mozillaAddons')
          }
        }];
        return false;
      }
      return true;
    };
    validator.addKeyword({
      keyword: _const.SCHEMA_KEYWORDS.VALIDATE_PRIVILEGED_PERMISSIONS,
      validate: validatePrivilegedPermissions
    });
    const validatePrivilegedManifestFields = (keywordSchemaValue, propValue, schema, {
      rootData /* instancePath, parentData, parentDataProperty, */
    }) => {
      const hasMozillaAddonsPermission = Array.isArray(rootData.permissions) && rootData.permissions.includes('mozillaAddons');
      if (this.isPrivilegedAddon) {
        if (!hasMozillaAddonsPermission) {
          validatePrivilegedManifestFields.errors = [{
            keyword: _const.SCHEMA_KEYWORDS.PRIVILEGED,
            params: {
              hasMozillaAddonsPermission
            }
          }];
          return false;
        }
        return true;
      }
      validatePrivilegedManifestFields.errors = [{
        keyword: _const.SCHEMA_KEYWORDS.PRIVILEGED,
        params: {
          hasMozillaAddonsPermission
        }
      }];
      return false;
    };
    validator.addKeyword({
      keyword: _const.SCHEMA_KEYWORDS.PRIVILEGED,
      validate: validatePrivilegedManifestFields
    });
  }
  getPrivilegedPermissionsSet(validator) {
    const schemaManifest = validator.getSchema('manifest').schema;
    const schemaPermissionPrivileged = schemaManifest.types.PermissionPrivileged.anyOf;
    const results = new Set();
    for (const schemaPermission of schemaPermissionPrivileged) {
      const {
        type,
        $ref
      } = schemaPermission;
      if (type === 'string' && schemaPermission.enum) {
        schemaPermission.enum.forEach(str => results.add(str));
      } else if ($ref) {
        const [namespace] = $ref.split('#');
        const schemaNamespace = validator.getSchema(namespace).schema;
        schemaNamespace.permissions.forEach(str => results.add(str));
      }
    }
    if (results.size === 0) {
      throw new Error('Unable to retrieve the Privileged Permissions set from the schema data');
    }
    return results;
  }
}
exports.SchemaValidator = SchemaValidator;
const schemaValidators = new Set();
function getValidator(validatorOptions) {
  // Compiling the schemas for the SchemaValidator instances is quite expensive,
  // while running in production the validatorOptions should be the same for the
  // entire addons-linter execution and so returning a cached instance will
  // make it less expensive.
  //
  // On test we may want to force usage of a non cached instance (e.g. because
  // the test case does pass custom schema data to unit test certain behavior
  // independently from what actually used in the Firefox schema files imported.
  if (validatorOptions?.forceNewValidatorInstance) {
    return new SchemaValidator(validatorOptions);
  }

  // Return an existing instance if the validator options match.
  for (const schemaValidator of schemaValidators) {
    if (schemaValidator && schemaValidator.matchOptions(validatorOptions)) {
      return schemaValidator;
    }
  }

  // Create a new SchemaValidator instance and cache it for the next calls
  // received for the same validatorOptions.
  const schemaValidator = new SchemaValidator(validatorOptions);
  schemaValidators.add(schemaValidator);
  return schemaValidator;
}
const validateAddon = (manifestData, validatorOptions = {}) => {
  const validator = validatorOptions.validator ?? getValidator({
    ...validatorOptions,
    addonManifestVersion: manifestData?.manifest_version
  });
  let isValid = validator.validateAddon(manifestData);
  const errors = filterErrors(validator.validateAddon.errors, {
    manifest_version: manifestData.manifest_version,
    allowedManifestVersionsRange: validator.allowedManifestVersionsRange
  });
  isValid = errors?.length > 0 ? isValid : true;
  validateAddon.errors = errors;
  return isValid;
};
exports.validateAddon = validateAddon;
const validateStaticTheme = (manifestData, validatorOptions = {}) => {
  const validator = getValidator(validatorOptions);
  let isValid = validator.validateStaticTheme(manifestData);
  const errors = filterErrors(validator.validateStaticTheme.errors);
  isValid = errors?.length > 0 ? isValid : true;
  validateStaticTheme.errors = errors;
  return isValid;
};
exports.validateStaticTheme = validateStaticTheme;
const validateLangPack = (manifestData, validatorOptions = {}) => {
  const validator = getValidator(validatorOptions);
  let isValid = validator.validateLangPack(manifestData);
  const errors = filterErrors(validator.validateLangPack.errors);
  isValid = errors?.length > 0 ? isValid : true;
  validateLangPack.errors = errors;
  return isValid;
};
exports.validateLangPack = validateLangPack;
const validateDictionary = (manifestData, validatorOptions = {}) => {
  const validator = getValidator(validatorOptions);
  let isValid = validator.validateDictionary(manifestData);
  const errors = filterErrors(validator.validateDictionary.errors);
  isValid = errors?.length > 0 ? isValid : true;
  validateDictionary.errors = errors;
  return isValid;
};
exports.validateDictionary = validateDictionary;
const validateLocaleMessages = (localeMessagesData, validatorOptions = {}) => {
  const validator = getValidator(validatorOptions);
  let isValid = validator.validateLocale(localeMessagesData);
  const errors = filterErrors(validator.validateLocale.errors);
  isValid = errors?.length > 0 ? isValid : true;
  validateLocaleMessages.errors = errors;
  return isValid;
};
exports.validateLocaleMessages = validateLocaleMessages;

/***/ }),
/* 37 */
/***/ ((module) => {

module.exports = require("ajv");

/***/ }),
/* 38 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var addMerge = __webpack_require__(39);
var addPatch = __webpack_require__(42);

/**
 * Defines keywords $merge and $patch in Ajv instance
 * @param  {Ajv} ajv validator instance
 */
module.exports = function addKeywords(ajv) {
  addMerge(ajv);
  addPatch(ajv);
};

/***/ }),
/* 39 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var addKeyword = __webpack_require__(40);
var jsonMergePatch = __webpack_require__(41);
module.exports = function (ajv) {
  addKeyword(ajv, '$merge', jsonMergePatch.apply, {
    "type": "object"
  });
};

/***/ }),
/* 40 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var url = __webpack_require__(20);
module.exports = function (ajv, keyword, jsonPatch, patchSchema) {
  ajv.addKeyword({
    keyword: keyword,
    macro: function (schema, parentSchema, it) {
      var source = schema.source;
      var patch = schema.with;
      if (source.$ref) source = JSON.parse(JSON.stringify(getSchema(source.$ref)));
      if (patch.$ref) patch = getSchema(patch.$ref);
      jsonPatch.call(null, source, patch, true);
      return source;
      function getSchema($ref) {
        var id = it.baseId && it.baseId != '#' ? url.resolve(it.baseId, $ref) : $ref;
        var validate = ajv.getSchema(id);
        if (validate) return validate.schema;
        throw new ajv.constructor.MissingRefError(it.baseId, $ref);
      }
    },
    metaSchema: {
      "type": "object",
      "required": ["source", "with"],
      "additionalProperties": false,
      "properties": {
        "source": {
          "anyOf": [{
            "type": "object",
            "required": ["$ref"],
            "additionalProperties": false,
            "properties": {
              "$ref": {
                "type": "string",
                "format": "uri"
              }
            }
          }, {
            "$ref": "http://json-schema.org/draft-07/schema#"
          }]
        },
        "with": patchSchema
      }
    }
  });
};

/***/ }),
/* 41 */
/***/ ((module) => {

module.exports = require("json-merge-patch");

/***/ }),
/* 42 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var addKeyword = __webpack_require__(40);
var jsonPatch = __webpack_require__(43);
module.exports = function (ajv) {
  addKeyword(ajv, '$patch', jsonPatch.applyPatch, {
    "type": "array",
    "items": {
      "type": "object",
      "required": ["op", "path"],
      "properties": {
        "op": {
          "type": "string"
        },
        "path": {
          "type": "string",
          "format": "json-pointer"
        }
      },
      "anyOf": [{
        "properties": {
          "op": {
            "enum": ["add", "replace", "test"]
          }
        },
        "required": ["value"]
      }, {
        "properties": {
          "op": {
            "enum": ["remove"]
          }
        }
      }, {
        "properties": {
          "op": {
            "enum": ["move", "copy"]
          },
          "from": {
            "type": "string",
            "format": "json-pointer"
          }
        },
        "required": ["from"]
      }]
    }
  });
};

/***/ }),
/* 43 */
/***/ ((module) => {

module.exports = require("fast-json-patch");

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.deepmerge = exports.deepPatch = void 0;
var _deepmerge = _interopRequireDefault(__webpack_require__(45));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * deepmerge 2.0 changed the way the array merge worked. This is the suggested
 * solution from their README for how to use the old version.
 *
 * https://github.com/KyleAMathews/deepmerge/blob/3ab89f2d2c938fc2e045c4ba822da0ffb81e4891/readme.md#arraymerge
 */

// eslint-disable-next-line import/no-extraneous-dependencies

const emptyTarget = value => Array.isArray(value) ? [] : {};
const clone = (value, options) => (0, _deepmerge.default)(emptyTarget(value), value, options);
function patchArrays(target, source, options) {
  const destination = target.slice();
  source.forEach((e, i) => {
    if (typeof destination[i] === 'undefined') {
      const cloneRequested = options.clone !== false;
      const shouldClone = cloneRequested && options.isMergeableObject(e);
      destination[i] = shouldClone ? clone(e, options) : e;
    } else if (options.isMergeableObject(e)) {
      destination[i] = (0, _deepmerge.default)(target[i], e, options);
    } else if (target.indexOf(e) === -1) {
      destination.push(e);
    }
  });
  return destination;
}
function concatArrays(target, source) {
  return [...target, ...source].filter((element, index, array) => array.indexOf(element) === index);
}
const deepmerge = (a, b) => {
  return (0, _deepmerge.default)(a, b, {
    arrayMerge: concatArrays
  });
};
exports.deepmerge = deepmerge;
const deepPatch = (a, b) => {
  return (0, _deepmerge.default)(a, b, {
    arrayMerge: patchArrays
  });
};
exports.deepPatch = deepPatch;

/***/ }),
/* 45 */
/***/ ((module) => {

module.exports = require("deepmerge");

/***/ }),
/* 46 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"manifest","permissions":[],"definitions":{},"refs":{},"types":{"ManifestBase":{"type":"object","description":"Common properties for all manifest.json files","properties":{"manifest_version":{"type":"integer","minimum":2,"maximum":3,"postprocess":"manifestVersionCheck"},"applications":{"allOf":[{"$ref":"#/types/DeprecatedApplications"},{"description":"The applications property is deprecated, please use \'browser_specific_settings\'","max_manifest_version":2}],"max_manifest_version":2},"browser_specific_settings":{"$ref":"#/types/BrowserSpecificSettings"},"name":{"type":"string","preprocess":"localize","maxLength":45,"minLength":2},"short_name":{"type":"string","preprocess":"localize"},"description":{"type":"string","preprocess":"localize"},"author":{"type":"string","preprocess":"localize","onError":"warn"},"version":{"type":"string","format":"versionString","description":"Version string must be a string comprising one to four dot-separated integers (0-65535). E.g: 1.2.3."},"homepage_url":{"type":"string","format":"ignore","preprocess":"localize","oneOf":[{"format":"url"},{"pattern":"^__MSG_.*?__$"}]},"install_origins":{"type":"array","items":{"type":"string","format":"origin"},"maxItems":5},"developer":{"type":"object","properties":{"name":{"type":"string","preprocess":"localize"},"url":{"type":"string","format":"url","preprocess":"localize","onError":"warn"}}}},"required":["manifest_version","name","version"]},"WebExtensionManifest":{"allOf":[{"$merge":{"source":{"$ref":"manifest#/types/ManifestBase"},"with":{"type":"object","description":"Represents a WebExtension manifest.json file","properties":{"minimum_chrome_version":{"type":"string"},"minimum_opera_version":{"type":"string"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ExtensionFileUrl"}},"additionalProperties":false},"incognito":{"type":"string","description":"The \'split\' value is not supported.","enum":["not_allowed","spanning","split"],"postprocess":"incognitoSplitUnsupportedAndFallback","default":"spanning"},"background":{"anyOf":[{"type":"object","properties":{"page":{"$ref":"manifest#/types/ExtensionURL"},"persistent":{"type":"boolean","max_manifest_version":2,"default":true}},"required":["page"]},{"type":"object","properties":{"scripts":{"type":"array","items":{"$ref":"manifest#/types/ExtensionURL"}},"type":{"type":"string","enum":["module","classic"]},"persistent":{"type":"boolean","max_manifest_version":2,"default":true}},"required":["scripts"]},{"type":"object","properties":{"service_worker":{"$ref":"manifest#/types/ExtensionURL"}},"postprocess":"requireBackgroundServiceWorkerEnabled","required":["service_worker"],"min_manifest_version":3}]},"options_page":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"description":"Alias property for options_ui.page, ignored when options_ui.page is set. When using this property the options page is always opened in a new tab."}]},"options_ui":{"type":"object","properties":{"page":{"$ref":"manifest#/types/ExtensionURL"},"browser_style":{"type":"boolean","description":"Defaults to true in Manifest V2; Deprecated in Manifest V3."},"chrome_style":{"type":"boolean","max_manifest_version":2,"description":"chrome_style is ignored in Firefox. Its replacement (browser_style) has been deprecated."},"open_in_tab":{"type":"boolean"}},"required":["page"]},"content_scripts":{"type":"array","items":{"$ref":"#/types/ContentScript"}},"content_security_policy":{"onError":"warn","anyOf":[{"max_manifest_version":2,"type":"string","format":"contentSecurityPolicy"},{"min_manifest_version":3,"type":"object","properties":{"extension_pages":{"type":"string","format":"contentSecurityPolicy","description":"The Content Security Policy used for extension pages."}}}]},"permissions":{"default":[],"anyOf":[{"max_manifest_version":2,"type":"array","items":{"allOf":[{"$ref":"#/types/PermissionOrOrigin"},{"onError":"warn"}]}},{"min_manifest_version":3,"type":"array","items":{"allOf":[{"$ref":"#/types/Permission"},{"onError":"warn"}]}}],"items":{"anyOf":[{},{"format":"deprecated"}]},"uniqueItems":true,"validatePrivilegedPermissions":true},"granted_host_permissions":{"type":"boolean","default":false},"host_permissions":{"min_manifest_version":3,"type":"array","items":{"allOf":[{"$ref":"#/types/MatchPattern"},{"onError":"warn"}]},"default":[]},"optional_host_permissions":{"min_manifest_version":3,"type":"array","items":{"allOf":[{"$ref":"#/types/MatchPattern"},{"onError":"warn"}]},"default":[]},"optional_permissions":{"type":"array","items":{"allOf":[{"$ref":"#/types/OptionalPermissionOrOrigin"},{"onError":"warn"}],"anyOf":[{},{"format":"deprecated"}]},"default":[],"uniqueItems":true},"web_accessible_resources":{"anyOf":[{"max_manifest_version":2,"type":"array","items":{"type":"string"}},{"min_manifest_version":3,"type":"array","postprocess":"webAccessibleMatching","items":{"type":"object","properties":{"resources":{"type":"array","items":{"type":"string"}},"matches":{"type":"array","items":{"$ref":"#/types/MatchPattern"}},"extension_ids":{"type":"array","items":{"anyOf":[{"$ref":"#/types/ExtensionID"},{"type":"string","enum":["*"]}]}}},"required":["resources"]}}]},"hidden":{"type":"boolean","default":false},"developer":{"properties":{"url":{"format":"ignore","oneOf":[{"format":"url"},{"pattern":"^__MSG_.*?__$"}]}}}}}}},{"$ref":"action#/definitions/WebExtensionManifest"},{"$ref":"browserAction#/definitions/WebExtensionManifest"},{"$ref":"chrome_settings_overrides#/definitions/WebExtensionManifest"},{"$ref":"commands#/definitions/WebExtensionManifest"},{"$ref":"declarativeNetRequest#/definitions/WebExtensionManifest"},{"$ref":"devtools#/definitions/WebExtensionManifest"},{"$ref":"experiments#/definitions/WebExtensionManifest"},{"$ref":"extension_protocol_handlers#/definitions/WebExtensionManifest"},{"$ref":"i18n#/definitions/WebExtensionManifest"},{"$ref":"omnibox#/definitions/WebExtensionManifest"},{"$ref":"pageAction#/definitions/WebExtensionManifest"},{"$ref":"sidebarAction#/definitions/WebExtensionManifest"},{"$ref":"theme#/definitions/WebExtensionManifest"},{"$ref":"url_overrides#/definitions/WebExtensionManifest"},{"$ref":"userScripts#/definitions/WebExtensionManifest"}]},"WebExtensionLangpackManifest":{"$merge":{"source":{"$ref":"manifest#/types/ManifestBase"},"with":{"type":"object","description":"Represents a WebExtension language pack manifest.json file","properties":{"langpack_id":{"type":"string","pattern":"^[a-zA-Z][a-zA-Z-]+$"},"languages":{"type":"object","patternProperties":{"^[a-z]{2}[a-zA-Z-]*$":{"type":"object","properties":{"chrome_resources":{"type":"object","patternProperties":{"^[a-zA-Z-.]+$":{"anyOf":[{"$ref":"manifest#/types/ExtensionURL"},{"type":"object","patternProperties":{"^[a-z]+$":{"$ref":"manifest#/types/ExtensionURL"}}}]}}},"version":{"type":"string"}},"required":["chrome_resources","version"]}}},"sources":{"type":"object","patternProperties":{"^[a-z]+$":{"type":"object","properties":{"base_path":{"$ref":"manifest#/types/ExtensionURL"},"paths":{"type":"array","items":{"type":"string","format":"strictRelativeUrl"}}},"required":["base_path"]}}}},"required":["langpack_id","languages"]}}},"WebExtensionDictionaryManifest":{"$merge":{"source":{"$ref":"manifest#/types/ManifestBase"},"with":{"type":"object","description":"Represents a WebExtension dictionary manifest.json file","properties":{"dictionaries":{"type":"object","patternProperties":{"^[a-z]{2}[a-zA-Z-]*$":{"type":"string","format":"strictRelativeUrl","pattern":"\\\\.dic$"}}}},"required":["dictionaries"]}}},"ThemeIcons":{"type":"object","properties":{"light":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"description":"A light icon to use for dark themes"}]},"dark":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"description":"The dark icon to use for light themes"}]},"size":{"type":"integer","description":"The size of the icons"}},"required":["light","dark","size"]},"OptionalOnlyPermission":{"anyOf":[{"type":"string","enum":["userScripts"]},{"$ref":"trial#/definitions/OptionalOnlyPermission"},{"$ref":"userScripts#/definitions/OptionalOnlyPermission"}]},"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["idle"]},{"$ref":"cookies#/definitions/OptionalPermissionNoPrompt"},{"$ref":"contextMenus#/definitions/OptionalPermissionNoPrompt"},{"$ref":"menus#/definitions/OptionalPermissionNoPrompt"},{"$ref":"scripting#/definitions/OptionalPermissionNoPrompt"},{"$ref":"search#/definitions/OptionalPermissionNoPrompt"},{"$ref":"tabs#/definitions/OptionalPermissionNoPrompt"},{"$ref":"webRequest#/definitions/OptionalPermissionNoPrompt"}]},"OptionalPermission":{"anyOf":[{"$ref":"#/types/OptionalPermissionNoPrompt"},{"type":"string","enum":["clipboardRead","clipboardWrite","geolocation","notifications"]},{"$ref":"bookmarks#/definitions/OptionalPermission"},{"$ref":"browserSettings#/definitions/OptionalPermission"},{"$ref":"browsingData#/definitions/OptionalPermission"},{"$ref":"declarativeNetRequest#/definitions/OptionalPermission"},{"$ref":"devtools#/definitions/OptionalPermission"},{"$ref":"downloads#/definitions/OptionalPermission"},{"$ref":"find#/definitions/OptionalPermission"},{"$ref":"history#/definitions/OptionalPermission"},{"$ref":"management#/definitions/OptionalPermission"},{"$ref":"pkcs11#/definitions/OptionalPermission"},{"$ref":"privacy#/definitions/OptionalPermission"},{"$ref":"proxy#/definitions/OptionalPermission"},{"$ref":"runtime#/definitions/OptionalPermission"},{"$ref":"sessions#/definitions/OptionalPermission"},{"$ref":"tabs#/definitions/OptionalPermission"},{"$ref":"topSites#/definitions/OptionalPermission"},{"$ref":"webNavigation#/definitions/OptionalPermission"}]},"OptionalPermissionOrOrigin":{"anyOf":[{"$ref":"#/types/OptionalPermission"},{"$ref":"#/types/OptionalOnlyPermission"},{"$ref":"#/types/MatchPattern"}]},"PermissionPrivileged":{"anyOf":[{"type":"string","enum":["mozillaAddons"]},{"$ref":"activityLog#/definitions/PermissionPrivileged"},{"$ref":"networkStatus#/definitions/PermissionPrivileged"},{"$ref":"normandyAddonStudy#/definitions/PermissionPrivileged"},{"$ref":"telemetry#/definitions/PermissionPrivileged"}]},"PermissionNoPrompt":{"anyOf":[{"$ref":"#/types/OptionalPermissionNoPrompt"},{"$ref":"#/types/PermissionPrivileged"},{"type":"string","enum":["alarms","storage","unlimitedStorage"]},{"$ref":"captivePortal#/definitions/PermissionNoPrompt"},{"$ref":"contextualIdentities#/definitions/PermissionNoPrompt"},{"$ref":"declarativeNetRequest#/definitions/PermissionNoPrompt"},{"$ref":"dns#/definitions/PermissionNoPrompt"},{"$ref":"geckoProfiler#/definitions/PermissionNoPrompt"},{"$ref":"identity#/definitions/PermissionNoPrompt"},{"$ref":"contextMenus#/definitions/PermissionNoPrompt"},{"$ref":"menus#/definitions/PermissionNoPrompt"},{"$ref":"theme#/definitions/PermissionNoPrompt"}]},"Permission":{"anyOf":[{"$ref":"#/types/PermissionNoPrompt"},{"$ref":"#/types/OptionalPermission"},{"$ref":"declarativeNetRequest#/definitions/Permission"},{"$ref":"experiments#/definitions/Permission"}]},"PermissionOrOrigin":{"anyOf":[{"$ref":"#/types/Permission"},{"$ref":"#/types/MatchPattern"}]},"HttpURL":{"type":"string","format":"url","pattern":"^https?://.*$"},"ExtensionURL":{"type":"string","format":"strictRelativeUrl"},"ExtensionFileUrl":{"type":"string","format":"strictRelativeUrl","pattern":"\\\\S","preprocess":"localize"},"ImageDataOrExtensionURL":{"type":"string","format":"imageDataOrStrictRelativeUrl"},"ExtensionID":{"anyOf":[{"type":"string","pattern":"^\\\\{[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\\\\}$"},{"type":"string","pattern":"^[a-zA-Z0-9-._]*@[a-zA-Z0-9-._]+$"}],"maxLength":80},"FirefoxSpecificProperties":{"type":"object","properties":{"id":{"$ref":"#/types/ExtensionID"},"update_url":{"type":"string","format":"secureUrl"},"strict_min_version":{"type":"string","default":"42a1","description":"Minimum version of Gecko to support. Defaults to \'42a1\'. (Requires Gecko 45)","pattern":"^[0-9]{1,3}(\\\\.[a-z0-9]+)+$"},"strict_max_version":{"type":"string","default":"*","description":"Maximum version of Gecko to support. Defaults to \'*\'. (Requires Gecko 45)","pattern":"^[0-9]{1,3}(\\\\.[a-z0-9*]+)+$"},"admin_install_only":{"type":"boolean"}}},"GeckoAndroidSpecificProperties":{"type":"object","properties":{"strict_min_version":{"type":"string","description":"Minimum version of Gecko to support.","pattern":"^[0-9]{1,3}(\\\\.[a-z0-9]+)+$"},"strict_max_version":{"type":"string","description":"Maximum version of Gecko to support.","pattern":"^[0-9]{1,3}(\\\\.[a-z0-9*]+)+$"}}},"DeprecatedApplications":{"type":"object","properties":{"gecko":{"$ref":"#/types/FirefoxSpecificProperties"},"gecko_android":{"allOf":[{"$ref":"#/types/GeckoAndroidSpecificProperties"},{"unsupported":true}]}},"additionalProperties":{}},"BrowserSpecificSettings":{"type":"object","properties":{"gecko":{"$ref":"#/types/FirefoxSpecificProperties"},"gecko_android":{"$ref":"#/types/GeckoAndroidSpecificProperties"}},"additionalProperties":{}},"MatchPattern":{"anyOf":[{"type":"string","enum":["<all_urls>"]},{"$ref":"#/types/MatchPatternRestricted"},{"$ref":"#/types/MatchPatternUnestricted"}]},"MatchPatternRestricted":{"description":"Same as MatchPattern above, but excludes <all_urls>","anyOf":[{"type":"string","pattern":"^(https?|wss?|file|ftp|\\\\*)://(\\\\*|\\\\*\\\\.[^*/]+|[^*/]+)/.*$"},{"type":"string","pattern":"^file:///.*$"}]},"MatchPatternUnestricted":{"description":"Mostly unrestricted match patterns for privileged add-ons. This should technically be rejected for unprivileged add-ons, but, reasons. The MatchPattern class will still refuse privileged schemes for those extensions.","anyOf":[{"type":"string","pattern":"^resource://(\\\\*|\\\\*\\\\.[^*/]+|[^*/]+)/.*$|^about:"}]},"ContentScript":{"type":"object","description":"Details of the script or CSS to inject. Either the code or the file property must be set, but both may not be set at the same time. Based on InjectDetails, but using underscore rather than camel case naming conventions.","properties":{"matches":{"type":"array","minItems":1,"items":{"$ref":"#/types/MatchPattern"}},"exclude_matches":{"type":"array","minItems":1,"items":{"$ref":"#/types/MatchPattern"}},"include_globs":{"type":"array","items":{"type":"string"}},"exclude_globs":{"type":"array","items":{"type":"string"}},"css":{"type":"array","description":"The list of CSS files to inject","items":{"$ref":"manifest#/types/ExtensionURL"}},"js":{"type":"array","description":"The list of JS files to inject","items":{"$ref":"manifest#/types/ExtensionURL"}},"all_frames":{"type":"boolean","description":"If allFrames is <code>true</code>, implies that the JavaScript or CSS should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"match_about_blank":{"type":"boolean","description":"If match_about_blank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Ignored if match_origin_as_fallback is specified. By default it is <code>false</code>."},"match_origin_as_fallback":{"type":"boolean","description":"If match_origin_as_fallback is true, then the code is also injected in about:, data:, blob: when their origin matches the pattern in \'matches\', even if the actual document origin is opaque (due to the use of CSP sandbox or iframe sandbox). Match patterns in \'matches\' must specify a wildcard path glob. By default it is <code>false</code>."},"run_at":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"default":"document_idle","description":"The soonest that the JavaScript or CSS will be injected into the tab. Defaults to \\"document_idle\\"."}]},"world":{"allOf":[{"$ref":"extensionTypes#/types/ExecutionWorld"},{"default":"ISOLATED","description":"The JavaScript world for a script to execute within. Defaults to \\"ISOLATED\\"."}]}},"required":["matches"]},"IconPath":{"anyOf":[{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ExtensionFileUrl"}},"additionalProperties":false},{"$ref":"#/types/ExtensionFileUrl"}]},"IconImageData":{"anyOf":[{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageData"}},"additionalProperties":false},{"$ref":"#/types/ImageData"}]},"ImageData":{"type":"object","isInstanceOf":"ImageData","postprocess":"convertImageDataToURL"},"UnrecognizedProperty":{"deprecated":"An unexpected property was found in the WebExtension manifest."}}}');

/***/ }),
/* 47 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"theme","description":"The theme API allows customizing of visual elements of the browser.","events":[{"name":"onUpdated","type":"function","description":"Fired when a new theme has been applied","parameters":[{"allOf":[{"$ref":"#/types/ThemeUpdateInfo"},{"name":"updateInfo","description":"Details of the theme update"}]}]}],"functions":[{"name":"getCurrent","type":"function","async":true,"description":"Returns the current theme for the specified window or the last focused window.","parameters":[{"type":"integer","name":"windowId","optional":true,"description":"The window for which we want the theme."}]},{"name":"update","type":"function","async":true,"description":"Make complete updates to the theme. Resolves when the update has completed.","permissions":["theme"],"parameters":[{"type":"integer","name":"windowId","optional":true,"description":"The id of the window to update. No id updates all windows."},{"allOf":[{"$ref":"manifest#/types/ThemeType"},{"name":"details","description":"The properties of the theme to update."}]}]},{"name":"reset","type":"function","async":true,"description":"Removes the updates made to the theme.","permissions":["theme"],"parameters":[{"type":"integer","name":"windowId","optional":true,"description":"The id of the window to reset. No id resets all windows."}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["theme"]}]},"WebExtensionManifest":{"properties":{"theme_experiment":{"$ref":"#/types/ThemeExperiment"}}}},"refs":{"theme#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"theme#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ThemeUpdateInfo":{"type":"object","description":"Info provided in the onUpdated listener.","properties":{"theme":{"type":"object","description":"The new theme after update"},"windowId":{"type":"integer","description":"The id of the window the theme has been applied to"}},"required":["theme"]},"ThemeColor":{"anyOf":[{"type":"string"},{"type":"array","minItems":3,"maxItems":3,"items":{"type":"integer","minimum":0,"maximum":255}},{"type":"array","minItems":4,"maxItems":4,"items":{"type":"number"}}]},"ThemeExperiment":{"type":"object","properties":{"stylesheet":{"$ref":"manifest#/types/ExtensionURL"},"images":{"type":"object","additionalProperties":{"type":"string"}},"colors":{"type":"object","additionalProperties":{"type":"string"}},"properties":{"type":"object","additionalProperties":{"type":"string"}}}},"ThemeType":{"type":"object","properties":{"images":{"type":"object","properties":{"additional_backgrounds":{"type":"array","items":{"$ref":"manifest#/types/ImageDataOrExtensionURL"},"maxItems":15},"headerURL":{"allOf":[{"$ref":"manifest#/types/ImageDataOrExtensionURL"},{"deprecated":"Unsupported images property, use \'theme.images.theme_frame\', this alias is ignored in Firefox >= 70."}]},"theme_frame":{"$ref":"manifest#/types/ImageDataOrExtensionURL"}},"additionalProperties":{"$ref":"manifest#/types/ImageDataOrExtensionURL"}},"colors":{"type":"object","properties":{"tab_selected":{"$ref":"#/types/ThemeColor"},"accentcolor":{"allOf":[{"$ref":"#/types/ThemeColor"},{"deprecated":"Unsupported colors property, use \'theme.colors.frame\', this alias is ignored in Firefox >= 70."}]},"frame":{"$ref":"#/types/ThemeColor"},"frame_inactive":{"$ref":"#/types/ThemeColor"},"textcolor":{"allOf":[{"$ref":"#/types/ThemeColor"},{"deprecated":"Unsupported color property, use \'theme.colors.tab_background_text\', this alias is ignored in Firefox >= 70."}]},"tab_background_text":{"$ref":"#/types/ThemeColor"},"tab_background_separator":{"$ref":"#/types/ThemeColor"},"tab_loading":{"$ref":"#/types/ThemeColor"},"tab_text":{"$ref":"#/types/ThemeColor"},"tab_line":{"$ref":"#/types/ThemeColor"},"toolbar":{"$ref":"#/types/ThemeColor"},"toolbar_text":{"allOf":[{"$ref":"#/types/ThemeColor"},{"description":"This color property is an alias of \'bookmark_text\'."}]},"bookmark_text":{"$ref":"#/types/ThemeColor"},"toolbar_field":{"$ref":"#/types/ThemeColor"},"toolbar_field_text":{"$ref":"#/types/ThemeColor"},"toolbar_field_border":{"$ref":"#/types/ThemeColor"},"toolbar_field_separator":{"allOf":[{"$ref":"#/types/ThemeColor"},{"deprecated":"This color property is ignored in Firefox >= 89."}]},"toolbar_top_separator":{"$ref":"#/types/ThemeColor"},"toolbar_bottom_separator":{"$ref":"#/types/ThemeColor"},"toolbar_vertical_separator":{"$ref":"#/types/ThemeColor"},"icons":{"$ref":"#/types/ThemeColor"},"icons_attention":{"$ref":"#/types/ThemeColor"},"button_background_hover":{"$ref":"#/types/ThemeColor"},"button_background_active":{"$ref":"#/types/ThemeColor"},"popup":{"$ref":"#/types/ThemeColor"},"popup_text":{"$ref":"#/types/ThemeColor"},"popup_border":{"$ref":"#/types/ThemeColor"},"toolbar_field_focus":{"$ref":"#/types/ThemeColor"},"toolbar_field_text_focus":{"$ref":"#/types/ThemeColor"},"toolbar_field_border_focus":{"$ref":"#/types/ThemeColor"},"popup_highlight":{"$ref":"#/types/ThemeColor"},"popup_highlight_text":{"$ref":"#/types/ThemeColor"},"ntp_background":{"$ref":"#/types/ThemeColor"},"ntp_card_background":{"$ref":"#/types/ThemeColor"},"ntp_text":{"$ref":"#/types/ThemeColor"},"sidebar":{"$ref":"#/types/ThemeColor"},"sidebar_border":{"$ref":"#/types/ThemeColor"},"sidebar_text":{"$ref":"#/types/ThemeColor"},"sidebar_highlight":{"$ref":"#/types/ThemeColor"},"sidebar_highlight_text":{"$ref":"#/types/ThemeColor"},"toolbar_field_highlight":{"$ref":"#/types/ThemeColor"},"toolbar_field_highlight_text":{"$ref":"#/types/ThemeColor"}},"additionalProperties":{"$ref":"#/types/ThemeColor"}},"properties":{"type":"object","properties":{"additional_backgrounds_alignment":{"type":"array","items":{"type":"string","enum":["bottom","center","left","right","top","center bottom","center center","center top","left bottom","left center","left top","right bottom","right center","right top"]},"maxItems":15},"additional_backgrounds_tiling":{"type":"array","items":{"type":"string","enum":["no-repeat","repeat","repeat-x","repeat-y"]},"maxItems":15},"color_scheme":{"type":"string","enum":["auto","light","dark","system"]},"content_color_scheme":{"type":"string","enum":["auto","light","dark","system"]}},"additionalProperties":{"type":"string"}}}},"ThemeManifest":{"$merge":{"source":{"$ref":"manifest#/types/ManifestBase"},"with":{"type":"object","description":"Contents of manifest.json for a static theme","properties":{"theme":{"$ref":"#/types/ThemeType"},"dark_theme":{"$ref":"#/types/ThemeType"},"default_locale":{"type":"string"},"theme_experiment":{"$ref":"#/types/ThemeExperiment"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}},"required":["theme"]}}}}}');

/***/ }),
/* 48 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"i18nMessages","types":{"i18nPlaceholder":{"type":"object","properties":{"content":{"type":"string"},"example":{"type":"string"}},"required":["content"]},"i18nMessage":{"type":"object","properties":{"message":{"type":"string"},"description":{"type":"string"},"placeholders":{"type":"object","patternProperties":{"^[A-Za-z0-9_@]+$":{"$ref":"#/types/i18nPlaceholder"}},"additionalProperties":false}},"required":["message"]},"WebExtensionI18nMessages":{"type":"object","patternProperties":{"^.*$":{"$ref":"#/types/i18nMessage"}},"additionalProperties":false}}}');

/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.imageDataOrStrictRelativeUrl = imageDataOrStrictRelativeUrl;
exports.isAbsoluteUrl = isAbsoluteUrl;
exports.isAnyUrl = isAnyUrl;
exports.isOrigin = isOrigin;
exports.isSecureUrl = isSecureUrl;
exports.isStrictRelativeUrl = isStrictRelativeUrl;
exports.isUnresolvedRelativeUrl = void 0;
exports.manifestShortcutKey = manifestShortcutKey;
function isAbsoluteUrl(value) {
  try {
    // eslint-disable-next-line no-new
    new URL(value);
  } catch (e) {
    // Couldn't parse, invalid.
    return false;
  }
  // Could parse without a base, it's absolute.
  return true;
}
function isRelativeUrl(value) {
  // A dummy protocol that shouldn't exist.
  const protocol = 'asdoiasjdpoaisjd:';
  let url;
  try {
    url = new URL(value, `${protocol}//foo`);
  } catch (e) {
    // URL is invalid.
    return false;
  }

  // If the URL is relative, then the protocol will stay the same, but host
  // could change due to protocol relative. Also check that the URL isn't
  // absolute, since then it is using the dummy protocol we defined.
  return url.protocol === protocol && !isAbsoluteUrl(value);
}
function isAnyUrl(value) {
  return isAbsoluteUrl(value) || isRelativeUrl(value);
}
function isStrictRelativeUrl(value) {
  return !value.startsWith('//') && isRelativeUrl(value);
}
function isSecureUrl(value) {
  let url;
  try {
    url = new URL(value);
  } catch (e) {
    // It's invalid or not absolute.
    return false;
  }
  // URL is absolute, check against secure protocols.
  return ['https:', 'wss:'].includes(url.protocol);
}
function isOrigin(value) {
  let url;
  try {
    url = new URL(value);
  } catch {
    return false;
  }
  if (!/^https?:/.test(url.protocol)) {
    return false;
  }
  if (value.includes('*')) {
    return false;
  }
  // url.origin is punycode so a direct check against string won't work.
  // url.href appends a slash even if not in the original string, so we
  // additionally check that the value does not end with slash.
  if (value.endsWith('/') || url.href !== new URL(url.origin).href) {
    return false;
  }
  return true;
}
function imageDataOrStrictRelativeUrl(value) {
  // Do not accept a string which resolves as an absolute URL, or any
  // protocol-relative URL, except PNG or JPG data URLs.
  return value.startsWith('data:image/png;base64,') || value.startsWith('data:image/jpeg;base64,') || isStrictRelativeUrl(value);
}
const isUnresolvedRelativeUrl = exports.isUnresolvedRelativeUrl = isStrictRelativeUrl;
function manifestShortcutKey(value) {
  // Partially taken from Firefox directly via
  // https://searchfox.org/mozilla-central/source/toolkit/components/extensions/Schemas.jsm#987
  // Please make sure to always update this function when doing a schema update
  // to pull in the most recent implementation to stay up-to-date with upstream.

  const MEDIA_KEYS = /^(MediaNextTrack|MediaPlayPause|MediaPrevTrack|MediaStop)$/;
  const BASIC_KEYS = /^([A-Z0-9]|Comma|Period|Home|End|PageUp|PageDown|Space|Insert|Delete|Up|Down|Left|Right)$/;
  const FUNCTION_KEYS = /^(F[1-9]|F1[0-2])$/;
  if (MEDIA_KEYS.test(value.trim())) {
    return true;
  }
  const modifiers = value.split('+').map(s => s.trim());
  const key = modifiers.pop();
  if (!BASIC_KEYS.test(key) && !FUNCTION_KEYS.test(key)) {
    return false;
  }
  const chromeModifierKeyMap = {
    Alt: 'alt',
    Command: 'accel',
    Ctrl: 'accel',
    MacCtrl: 'control',
    Shift: 'shift'
  };
  const chromeModifiers = modifiers.map(m => chromeModifierKeyMap[m]);

  // If the modifier wasn't found it will be undefined.
  if (chromeModifiers.some(modifier => !modifier)) {
    return false;
  }
  switch (modifiers.length) {
    case 0:
      // A lack of modifiers is only allowed with function keys.
      if (!FUNCTION_KEYS.test(key)) {
        return false;
      }
      break;
    case 1:
      // Shift is only allowed on its own with function keys.
      if (chromeModifiers[0] === 'shift' && !FUNCTION_KEYS.test(key)) {
        return false;
      }
      break;
    case 2:
      if (chromeModifiers[0] === chromeModifiers[1]) {
        return false;
      }
      break;
    default:
      return false;
  }
  return true;
}

/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _activity_log = _interopRequireDefault(__webpack_require__(51));
var _alarms = _interopRequireDefault(__webpack_require__(52));
var _bookmarks = _interopRequireDefault(__webpack_require__(53));
var _action = _interopRequireDefault(__webpack_require__(54));
var _browser_action = _interopRequireDefault(__webpack_require__(55));
var _browser_settings = _interopRequireDefault(__webpack_require__(56));
var _browsing_data = _interopRequireDefault(__webpack_require__(57));
var _captive_portal = _interopRequireDefault(__webpack_require__(58));
var _chrome_settings_overrides = _interopRequireDefault(__webpack_require__(59));
var _clipboard = _interopRequireDefault(__webpack_require__(60));
var _commands = _interopRequireDefault(__webpack_require__(61));
var _content_scripts = _interopRequireDefault(__webpack_require__(62));
var _contextual_identities = _interopRequireDefault(__webpack_require__(63));
var _cookies = _interopRequireDefault(__webpack_require__(64));
var _declarative_net_request = _interopRequireDefault(__webpack_require__(65));
var _devtools = _interopRequireDefault(__webpack_require__(66));
var _dns = _interopRequireDefault(__webpack_require__(67));
var _downloads = _interopRequireDefault(__webpack_require__(68));
var _events = _interopRequireDefault(__webpack_require__(69));
var _experiments = _interopRequireDefault(__webpack_require__(70));
var _extension = _interopRequireDefault(__webpack_require__(71));
var _extension_protocol_handlers = _interopRequireDefault(__webpack_require__(72));
var _extension_types = _interopRequireDefault(__webpack_require__(73));
var _find = _interopRequireDefault(__webpack_require__(74));
var _geckoProfiler = _interopRequireDefault(__webpack_require__(75));
var _history = _interopRequireDefault(__webpack_require__(76));
var _i18n = _interopRequireDefault(__webpack_require__(77));
var _identity = _interopRequireDefault(__webpack_require__(78));
var _idle = _interopRequireDefault(__webpack_require__(79));
var _management = _interopRequireDefault(__webpack_require__(80));
var _context_menus = _interopRequireDefault(__webpack_require__(81));
var _menus = _interopRequireDefault(__webpack_require__(82));
var _native_manifest = _interopRequireDefault(__webpack_require__(83));
var _network_status = _interopRequireDefault(__webpack_require__(84));
var _normandyAddonStudy = _interopRequireDefault(__webpack_require__(85));
var _notifications = _interopRequireDefault(__webpack_require__(86));
var _omnibox = _interopRequireDefault(__webpack_require__(87));
var _page_action = _interopRequireDefault(__webpack_require__(88));
var _permissions = _interopRequireDefault(__webpack_require__(89));
var _pkcs = _interopRequireDefault(__webpack_require__(90));
var _privacy = _interopRequireDefault(__webpack_require__(91));
var _proxy = _interopRequireDefault(__webpack_require__(92));
var _runtime = _interopRequireDefault(__webpack_require__(93));
var _scripting = _interopRequireDefault(__webpack_require__(94));
var _search = _interopRequireDefault(__webpack_require__(95));
var _sessions = _interopRequireDefault(__webpack_require__(96));
var _sidebar_action = _interopRequireDefault(__webpack_require__(97));
var _storage = _interopRequireDefault(__webpack_require__(98));
var _tabs = _interopRequireDefault(__webpack_require__(99));
var _telemetry = _interopRequireDefault(__webpack_require__(100));
var _test = _interopRequireDefault(__webpack_require__(101));
var _theme = _interopRequireDefault(__webpack_require__(47));
var _top_sites = _interopRequireDefault(__webpack_require__(102));
var _trial_ml = _interopRequireDefault(__webpack_require__(103));
var _types = _interopRequireDefault(__webpack_require__(104));
var _url_overrides = _interopRequireDefault(__webpack_require__(105));
var _userScripts = _interopRequireDefault(__webpack_require__(106));
var _web_navigation = _interopRequireDefault(__webpack_require__(107));
var _web_request = _interopRequireDefault(__webpack_require__(108));
var _windows = _interopRequireDefault(__webpack_require__(109));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This file is generated by the schema import script.
var _default = exports["default"] = [_activity_log.default, _alarms.default, _bookmarks.default, _action.default, _browser_action.default, _browser_settings.default, _browsing_data.default, _captive_portal.default, _chrome_settings_overrides.default, _clipboard.default, _commands.default, _content_scripts.default, _contextual_identities.default, _cookies.default, _declarative_net_request.default, _devtools.default, _dns.default, _downloads.default, _events.default, _experiments.default, _extension.default, _extension_protocol_handlers.default, _extension_types.default, _find.default, _geckoProfiler.default, _history.default, _i18n.default, _identity.default, _idle.default, _management.default, _context_menus.default, _menus.default, _native_manifest.default, _network_status.default, _normandyAddonStudy.default, _notifications.default, _omnibox.default, _page_action.default, _permissions.default, _pkcs.default, _privacy.default, _proxy.default, _runtime.default, _scripting.default, _search.default, _sessions.default, _sidebar_action.default, _storage.default, _tabs.default, _telemetry.default, _test.default, _theme.default, _top_sites.default, _trial_ml.default, _types.default, _url_overrides.default, _userScripts.default, _web_navigation.default, _web_request.default, _windows.default];

/***/ }),
/* 51 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"activityLog","description":"Monitor extension activity","permissions":["activityLog"],"events":[{"name":"onExtensionActivity","description":"Receives an activityItem for each logging event.","type":"function","parameters":[{"name":"details","type":"object","properties":{"timeStamp":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The date string when this call is triggered."}]},"type":{"type":"string","enum":["api_call","api_event","content_script","user_script"],"description":"The type of log entry.  api_call is a function call made by the extension and api_event is an event callback to the extension.  content_script is logged when a content script is injected."},"viewType":{"type":"string","enum":["background","popup","sidebar","tab","devtools_page","devtools_panel"],"description":"The type of view where the activity occurred.  Content scripts will not have a viewType."},"name":{"type":"string","description":"The name of the api call or event, or the script url if this is a content or user script event."},"data":{"type":"object","properties":{"args":{"type":"array","items":{},"description":"A list of arguments passed to the call."},"result":{"type":"object","description":"The result of the call."},"tabId":{"type":"integer","description":"The tab associated with this event if it is a tab or content script."},"url":{"type":"string","description":"If the type is content_script, this is the url of the script that was injected."}}}},"required":["timeStamp","type","name","data"]}],"extraParameters":[{"name":"id","type":"string"}]}],"definitions":{"PermissionPrivileged":{"anyOf":[{"type":"string","enum":["activityLog"]}]}},"refs":{"activityLog#/definitions/PermissionPrivileged":{"namespace":"manifest","type":"PermissionPrivileged"}},"types":{}}');

/***/ }),
/* 52 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"alarms","permissions":["alarms"],"functions":[{"name":"create","type":"function","description":"Creates an alarm. After the delay is expired, the onAlarm event is fired. If there is another alarm with the same name (or no name if none is specified), it will be cancelled and replaced by this alarm.","parameters":[{"type":"string","name":"name","optional":true,"description":"Optional name to identify this alarm. Defaults to the empty string."},{"type":"object","name":"alarmInfo","description":"Details about the alarm. The alarm first fires either at \'when\' milliseconds past the epoch (if \'when\' is provided), after \'delayInMinutes\' minutes from the current time (if \'delayInMinutes\' is provided instead), or after \'periodInMinutes\' minutes from the current time (if only \'periodInMinutes\' is provided). Users should never provide both \'when\' and \'delayInMinutes\'. If \'periodInMinutes\' is provided, then the alarm recurs repeatedly after that many minutes.","properties":{"when":{"type":"number","description":"Time when the alarm is scheduled to first fire, in milliseconds past the epoch."},"delayInMinutes":{"type":"number","description":"Number of minutes from the current time after which the alarm should first fire."},"periodInMinutes":{"type":"number","description":"Number of minutes after which the alarm should recur repeatedly."}}}]},{"name":"get","type":"function","description":"Retrieves details about the specified alarm.","async":"callback","parameters":[{"type":"string","name":"name","optional":true,"description":"The name of the alarm to get. Defaults to the empty string."},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Alarm"},{"name":"alarm","optional":true}]}]}]},{"name":"getAll","type":"function","description":"Gets an array of all the alarms.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"alarms","type":"array","items":{"$ref":"#/types/Alarm"}}]}]},{"name":"clear","type":"function","description":"Clears the alarm with the given name.","async":"callback","parameters":[{"type":"string","name":"name","optional":true,"description":"The name of the alarm to clear. Defaults to the empty string."},{"type":"function","name":"callback","parameters":[{"name":"wasCleared","type":"boolean","description":"Whether an alarm of the given name was found to clear."}]}]},{"name":"clearAll","type":"function","description":"Clears all alarms.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"wasCleared","type":"boolean","description":"Whether any alarm was found to clear."}]}]}],"events":[{"name":"onAlarm","type":"function","description":"Fired when an alarm has expired. Useful for transient background pages.","parameters":[{"allOf":[{"$ref":"#/types/Alarm"},{"name":"name","description":"The alarm that has expired."}]}]}],"definitions":{},"refs":{},"types":{"Alarm":{"type":"object","properties":{"name":{"type":"string","description":"Name of this alarm."},"scheduledTime":{"type":"number","description":"Time when the alarm is scheduled to fire, in milliseconds past the epoch."},"periodInMinutes":{"type":"number","description":"When present, signals that the alarm triggers periodically after so many minutes."}},"required":["name","scheduledTime"]}}}');

/***/ }),
/* 53 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"bookmarks","description":"Use the <code>browser.bookmarks</code> API to create, organize, and otherwise manipulate bookmarks. Also see $(topic:override)[Override Pages], which you can use to create a custom Bookmark Manager page.","permissions":["bookmarks"],"functions":[{"name":"get","type":"function","description":"Retrieves the specified BookmarkTreeNode(s).","async":"callback","parameters":[{"name":"idOrIdList","description":"A single string-valued id, or an array of string-valued ids","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"},"minItems":1}]},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getChildren","type":"function","description":"Retrieves the children of the specified BookmarkTreeNode id.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getRecent","type":"function","description":"Retrieves the recently added bookmarks.","async":"callback","parameters":[{"type":"integer","minimum":1,"name":"numberOfItems","description":"The maximum number of items to return."},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getTree","type":"function","description":"Retrieves the entire Bookmarks hierarchy.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"getSubTree","type":"function","description":"Retrieves part of the Bookmarks hierarchy, starting at the specified node.","async":"callback","parameters":[{"type":"string","name":"id","description":"The ID of the root of the subtree to retrieve."},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"search","type":"function","description":"Searches for BookmarkTreeNodes matching the given query. Queries specified with an object produce BookmarkTreeNodes matching all specified properties.","async":"callback","parameters":[{"name":"query","description":"Either a string of words that are matched against bookmark URLs and titles, or an object. If an object, the properties <code>query</code>, <code>url</code>, and <code>title</code> may be specified and bookmarks matching all specified properties will be produced.","anyOf":[{"type":"string","description":"A string of words that are matched against bookmark URLs and titles."},{"type":"object","description":"An object specifying properties and values to match when searching. Produces bookmarks matching all properties.","properties":{"query":{"type":"string","description":"A string of words that are matched against bookmark URLs and titles."},"url":{"type":"string","format":"url","description":"The URL of the bookmark; matches verbatim. Note that folders have no URL."},"title":{"type":"string","description":"The title of the bookmark; matches verbatim."}}}]},{"type":"function","name":"callback","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/BookmarkTreeNode"}}]}]},{"name":"create","type":"function","description":"Creates a bookmark or folder under the specified parentId.  If url is NULL or missing, it will be a folder.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/CreateDetails"},{"name":"bookmark"}]},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"result"}]}]}]},{"name":"move","type":"function","description":"Moves the specified BookmarkTreeNode to the provided location.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"object","name":"destination","properties":{"parentId":{"type":"string"},"index":{"type":"integer","minimum":0}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"result"}]}]}]},{"name":"update","type":"function","description":"Updates the properties of a bookmark or folder. Specify only the properties that you want to change; unspecified properties will be left unchanged.  <b>Note:</b> Currently, only \'title\' and \'url\' are supported.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"object","name":"changes","properties":{"title":{"type":"string"},"url":{"type":"string"}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"result"}]}]}]},{"name":"remove","type":"function","description":"Removes a bookmark or an empty bookmark folder.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"removeTree","type":"function","description":"Recursively removes a bookmark folder.","async":"callback","parameters":[{"type":"string","name":"id"},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"events":[{"name":"onCreated","type":"function","description":"Fired when a bookmark or folder is created.","parameters":[{"type":"string","name":"id"},{"allOf":[{"$ref":"#/types/BookmarkTreeNode"},{"name":"bookmark"}]}]},{"name":"onRemoved","type":"function","description":"Fired when a bookmark or folder is removed.  When a folder is removed recursively, a single notification is fired for the folder, and none for its contents.","parameters":[{"type":"string","name":"id"},{"type":"object","name":"removeInfo","properties":{"parentId":{"type":"string"},"index":{"type":"integer"},"node":{"$ref":"#/types/BookmarkTreeNode"}},"required":["parentId","index","node"]}]},{"name":"onChanged","type":"function","description":"Fired when a bookmark or folder changes.  <b>Note:</b> Currently, only title and url changes trigger this.","parameters":[{"type":"string","name":"id"},{"type":"object","name":"changeInfo","properties":{"title":{"type":"string"},"url":{"type":"string"}},"required":["title"]}]},{"name":"onMoved","type":"function","description":"Fired when a bookmark or folder is moved to a different parent folder.","parameters":[{"type":"string","name":"id"},{"type":"object","name":"moveInfo","properties":{"parentId":{"type":"string"},"index":{"type":"integer"},"oldParentId":{"type":"string"},"oldIndex":{"type":"integer"}},"required":["parentId","index","oldParentId","oldIndex"]}]},{"name":"onChildrenReordered","unsupported":true,"type":"function","description":"Fired when the children of a folder have changed their order due to the order being sorted in the UI.  This is not called as a result of a move().","parameters":[{"type":"string","name":"id"},{"type":"object","name":"reorderInfo","properties":{"childIds":{"type":"array","items":{"type":"string"}}},"required":["childIds"]}]},{"name":"onImportBegan","unsupported":true,"type":"function","description":"Fired when a bookmark import session is begun.  Expensive observers should ignore onCreated updates until onImportEnded is fired.  Observers should still handle other notifications immediately.","parameters":[]},{"name":"onImportEnded","unsupported":true,"type":"function","description":"Fired when a bookmark import session is ended.","parameters":[]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["bookmarks"]}]}},"refs":{"bookmarks#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"BookmarkTreeNodeUnmodifiable":{"type":"string","enum":["managed"],"description":"Indicates the reason why this node is unmodifiable. The <var>managed</var> value indicates that this node was configured by the system administrator or by the custodian of a supervised user. Omitted if the node can be modified by the user and the extension (default)."},"BookmarkTreeNodeType":{"type":"string","enum":["bookmark","folder","separator"],"description":"Indicates the type of a BookmarkTreeNode, which can be one of bookmark, folder or separator."},"BookmarkTreeNode":{"type":"object","description":"A node (either a bookmark or a folder) in the bookmark tree.  Child nodes are ordered within their parent folder.","properties":{"id":{"type":"string","description":"The unique identifier for the node. IDs are unique within the current profile, and they remain valid even after the browser is restarted."},"parentId":{"type":"string","description":"The <code>id</code> of the parent folder.  Omitted for the root node."},"index":{"type":"integer","description":"The 0-based position of this node within its parent folder."},"url":{"type":"string","description":"The URL navigated to when a user clicks the bookmark. Omitted for folders."},"title":{"type":"string","description":"The text displayed for the node."},"dateAdded":{"type":"number","description":"When this node was created, in milliseconds since the epoch (<code>new Date(dateAdded)</code>)."},"dateGroupModified":{"type":"number","description":"When the contents of this folder last changed, in milliseconds since the epoch."},"unmodifiable":{"allOf":[{"$ref":"#/types/BookmarkTreeNodeUnmodifiable"},{"description":"Indicates the reason why this node is unmodifiable. The <var>managed</var> value indicates that this node was configured by the system administrator or by the custodian of a supervised user. Omitted if the node can be modified by the user and the extension (default)."}]},"type":{"allOf":[{"$ref":"#/types/BookmarkTreeNodeType"},{"description":"Indicates the type of the BookmarkTreeNode, which can be one of bookmark, folder or separator."}]},"children":{"type":"array","items":{"$ref":"#/types/BookmarkTreeNode"},"description":"An ordered list of children of this node."}},"required":["id","title"]},"CreateDetails":{"description":"Object passed to the create() function.","type":"object","properties":{"parentId":{"type":"string","description":"Defaults to the Other Bookmarks folder."},"index":{"type":"integer","minimum":0},"title":{"type":"string"},"url":{"type":"string"},"type":{"allOf":[{"$ref":"#/types/BookmarkTreeNodeType"},{"description":"Indicates the type of BookmarkTreeNode to create, which can be one of bookmark, folder or separator."}]}}}}}');

/***/ }),
/* 54 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"action","description":"Use browser actions to put icons in the main browser toolbar, to the right of the address bar. In addition to its icon, a browser action can also have a tooltip, a badge, and a popup.","permissions":["manifest:action","manifest:browser_action"],"min_manifest_version":3,"functions":[{"name":"setTitle","type":"function","description":"Sets the title of the browser action. This shows up in the tooltip.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The string the browser action should display when moused over."}},"required":["title"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getTitle","type":"function","description":"Gets the title of the browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"getUserSettings","type":"function","description":"Returns the user-specified settings relating to an extension\'s action.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"userSettings","type":"object","properties":{"isOnToolbar":{"type":"boolean","description":"Whether the extension\'s action icon is visible on browser windows\' top-level toolbar (i.e., whether the extension has been \'pinned\' by the user)."}},"description":"The collection of user-specified settings relating to an extension\'s action."}]}]},{"name":"setIcon","type":"function","description":"Sets the icon for the browser action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <b>path</b> or the <b>imageData</b> property must be specified.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}}}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"}}}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"setPopup","type":"function","description":"Sets the html document to be opened as a popup when the user clicks on the browser action\'s icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"popup":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The html file to show in a popup.  If set to the empty string (\'\'), no popup is shown."}},"required":["popup"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getPopup","type":"function","description":"Gets the html document set as the popup for this browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeText","type":"function","description":"Sets the badge text for the browser action. The badge is displayed on top of the icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"text":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"Any number of characters can be passed, but only about four can fit in the space."}},"required":["text"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeText","type":"function","description":"Gets the badge text of the browser action. If no tab nor window is specified is specified, the global badge text is returned.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeBackgroundColor","type":"function","description":"Sets the background color for the badge.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeBackgroundColor","type":"function","description":"Gets the background color of the browser action badge.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/ColorArray"},{"name":"result"}]}]}]},{"name":"setBadgeTextColor","type":"function","description":"Sets the text color for the badge.","async":true,"parameters":[{"$merge":{"source":{"$ref":"action#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}}]},{"name":"getBadgeTextColor","type":"function","description":"Gets the text color of the browser action badge.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"enable","type":"function","description":"Enables the browser action for a tab. By default, browser actions are enabled.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"disable","type":"function","description":"Disables the browser action for a tab.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"isEnabled","type":"function","description":"Checks whether the browser action is enabled.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"openPopup","type":"function","description":"Opens the extension popup window in the specified window.","async":true,"parameters":[{"name":"options","optional":true,"type":"object","description":"An object with information about the popup to open.","properties":{"windowId":{"type":"integer","minimum":-2,"description":"Defaults to the $(topic:current-window)[current window]."}}}]}],"events":[{"name":"onClicked","type":"function","description":"Fired when a browser action icon is clicked.  This event will not fire if the browser action has a popup.","parameters":[{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab"}]},{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","optional":true}]}]}],"definitions":{"WebExtensionManifest":{"properties":{"action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"min_manifest_version":3}]},"browser_action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"max_manifest_version":2}]}}}},"refs":{"action#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"Details":{"type":"object","description":"Specifies to which tab or window the value should be set, or from which one it should be retrieved. If no tab nor window is specified, the global value is set or retrieved.","properties":{"tabId":{"type":"integer","minimum":0,"description":"When setting a value, it will be specific to the specified tab, and will automatically reset when the tab navigates. When getting, specifies the tab to get the value from; if there is no tab-specific value, the window one will be inherited."},"windowId":{"type":"integer","minimum":-2,"description":"When setting a value, it will be specific to the specified window. When getting, specifies the window to get the value from; if there is no window-specific value, the global one will be inherited."}}},"ColorArray":{"type":"array","items":{"type":"integer","minimum":0,"maximum":255},"minItems":4,"maxItems":4},"ImageDataType":{"type":"object","isInstanceOf":"ImageData","additionalProperties":{},"postprocess":"convertImageDataToURL","description":"Pixel data for an image. Must be an ImageData object (for example, from a <code>canvas</code> element)."},"ColorValue":{"description":"An array of four integers in the range [0,255] that make up the RGBA color of the badge. For example, opaque red is <code>[255, 0, 0, 255]</code>. Can also be a string with a CSS value, with opaque red being <code>#FF0000</code> or <code>#F00</code>.","anyOf":[{"type":"string"},{"$ref":"#/types/ColorArray"},{"type":"null"}]},"OnClickData":{"type":"object","description":"Information sent when a browser action is clicked.","properties":{"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."}},"required":["modifiers"]},"ActionManifest":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"theme_icons":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/ThemeIcons"},"description":"Specifies icons to use for dark and light themes"},"default_popup":{"type":"string","format":"relativeUrl","preprocess":"localize"},"browser_style":{"type":"boolean","description":"Deprecated in Manifest V3."},"default_area":{"description":"Defines the location the browserAction will appear by default.  The default location is navbar.","type":"string","enum":["navbar","menupanel","tabstrip","personaltoolbar"]}}}}}');

/***/ }),
/* 55 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"browserAction","description":"Use browser actions to put icons in the main browser toolbar, to the right of the address bar. In addition to its icon, a browser action can also have a tooltip, a badge, and a popup.","permissions":["manifest:action","manifest:browser_action"],"types":{"ActionManifest":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"theme_icons":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/ThemeIcons"},"description":"Specifies icons to use for dark and light themes"},"default_popup":{"type":"string","format":"relativeUrl","preprocess":"localize"},"browser_style":{"type":"boolean","description":"Deprecated in Manifest V3."},"default_area":{"description":"Defines the location the browserAction will appear by default.  The default location is navbar.","type":"string","enum":["navbar","menupanel","tabstrip","personaltoolbar"]}}}},"functions":[{"name":"setTitle","type":"function","description":"Sets the title of the browser action. This shows up in the tooltip.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The string the browser action should display when moused over."}},"required":["title"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getTitle","type":"function","description":"Gets the title of the browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"getUserSettings","type":"function","description":"Returns the user-specified settings relating to an extension\'s action.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"userSettings","type":"object","properties":{"isOnToolbar":{"type":"boolean","description":"Whether the extension\'s action icon is visible on browser windows\' top-level toolbar (i.e., whether the extension has been \'pinned\' by the user)."}},"description":"The collection of user-specified settings relating to an extension\'s action."}]}]},{"name":"setIcon","type":"function","description":"Sets the icon for the browser action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <b>path</b> or the <b>imageData</b> property must be specified.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}}}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"}}}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"setPopup","type":"function","description":"Sets the html document to be opened as a popup when the user clicks on the browser action\'s icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"popup":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The html file to show in a popup.  If set to the empty string (\'\'), no popup is shown."}},"required":["popup"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getPopup","type":"function","description":"Gets the html document set as the popup for this browser action.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeText","type":"function","description":"Sets the badge text for the browser action. The badge is displayed on top of the icon.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"text":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"Any number of characters can be passed, but only about four can fit in the space."}},"required":["text"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeText","type":"function","description":"Gets the badge text of the browser action. If no tab nor window is specified is specified, the global badge text is returned.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setBadgeBackgroundColor","type":"function","description":"Sets the background color for the badge.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"getBadgeBackgroundColor","type":"function","description":"Gets the background color of the browser action badge.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/ColorArray"},{"name":"result"}]}]}]},{"name":"setBadgeTextColor","type":"function","description":"Sets the text color for the badge.","async":true,"parameters":[{"$merge":{"source":{"$ref":"browserAction#/types/Details"},"with":{"name":"details","type":"object","properties":{"color":{"$ref":"#/types/ColorValue"}},"required":["color"]}}}]},{"name":"getBadgeTextColor","type":"function","description":"Gets the text color of the browser action badge.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"enable","type":"function","description":"Enables the browser action for a tab. By default, browser actions are enabled.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"disable","type":"function","description":"Disables the browser action for a tab.","async":"callback","parameters":[{"type":"integer","optional":true,"name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the browser action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"isEnabled","type":"function","description":"Checks whether the browser action is enabled.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Details"},{"name":"details"}]}]},{"name":"openPopup","type":"function","description":"Opens the extension popup window in the specified window.","async":true,"parameters":[{"name":"options","optional":true,"type":"object","description":"An object with information about the popup to open.","properties":{"windowId":{"type":"integer","minimum":-2,"description":"Defaults to the $(topic:current-window)[current window]."}}}]}],"events":[{"name":"onClicked","type":"function","description":"Fired when a browser action icon is clicked.  This event will not fire if the browser action has a popup.","parameters":[{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab"}]},{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","optional":true}]}]}],"max_manifest_version":2,"definitions":{"WebExtensionManifest":{"properties":{"action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"min_manifest_version":3}]},"browser_action":{"allOf":[{"$ref":"#/types/ActionManifest"},{"max_manifest_version":2}]}}}},"refs":{"browserAction#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}}}');

/***/ }),
/* 56 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"browserSettings","description":"Use the <code>browser.browserSettings</code> API to control global settings of the browser.","permissions":["browserSettings"],"properties":{"allowPopupsForUserEvents":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allows or disallows pop-up windows from opening in response to user events."}]},"cacheEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Enables or disables the browser cache."}]},"closeTabsByDoubleClick":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether the selected tab can be closed with a double click."}]},"contextMenuShowEvent":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Controls after which mouse event context menus popup. This setting\'s value is of type ContextMenuMouseEvent, which has possible values of <code>mouseup</code> and <code>mousedown</code>."}]},"ftpProtocolEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Returns whether the FTP protocol is enabled. Read-only.","deprecated":"FTP support was removed from Firefox in bug 1574475"}]},"homepageOverride":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Returns the value of the overridden home page. Read-only."}]},"imageAnimationBehavior":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Controls the behaviour of image animation in the browser. This setting\'s value is of type ImageAnimationBehavior, defaulting to <code>normal</code>."}]},"newTabPageOverride":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Returns the value of the overridden new tab page. Read-only."}]},"newTabPosition":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Controls where new tabs are opened. `afterCurrent` will open all new tabs next to the current tab, `relatedAfterCurrent` will open only related tabs next to the current tab, and `atEnd` will open all tabs at the end of the tab strip. The default is `relatedAfterCurrent`."}]},"openBookmarksInNewTabs":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether bookmarks are opened in the current tab or in a new tab."}]},"openSearchResultsInNewTabs":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether search results are opened in the current tab or in a new tab."}]},"openUrlbarResultsInNewTabs":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether urlbar results are opened in the current tab or in a new tab."}]},"webNotificationsDisabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Disables webAPI notifications."}]},"overrideDocumentColors":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls whether the user-chosen colors override the page\'s colors."}]},"overrideContentColorScheme":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls whether a light or dark color scheme overrides the page\'s preferred color scheme."}]},"useDocumentFonts":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls whether the document\'s fonts are used."}]},"zoomFullPage":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether zoom is applied to the full page or to text only."}]},"zoomSiteSpecific":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether zoom is applied on a per-site basis or to the current tab only. If privacy.resistFingerprinting is true, this setting has no effect and zoom is applied to the current tab only."}]},"colorManagement":{"description":"Use the <code>browserSettings.colorManagement</code> API to query and set items related to color management.","permissions":["browserSettings"],"properties":{"mode":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This setting controls the mode used for color management and must be a string from $(ref:browserSettings.ColorManagementMode)"}]},"useNativeSRGB":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether or not native sRGB color management is used."}]},"useWebRenderCompositor":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This boolean setting controls whether or not the WebRender compositor is used."}]}},"required":["mode","useNativeSRGB","useWebRenderCompositor"]}},"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["browserSettings"]}]}},"refs":{"browserSettings#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"ImageAnimationBehavior":{"type":"string","enum":["normal","none","once"],"description":"How images should be animated in the browser."},"ContextMenuMouseEvent":{"type":"string","enum":["mouseup","mousedown"],"description":"After which mouse event context menus should popup."},"ColorManagementMode":{"type":"string","enum":["off","full","tagged_only"],"description":"Color management mode."}}}');

/***/ }),
/* 57 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"browsingData","description":"Use the <code>chrome.browsingData</code> API to remove browsing data from a user\'s local profile.","permissions":["browsingData"],"functions":[{"name":"settings","description":"Reports which types of data are currently selected in the \'Clear browsing data\' settings UI.  Note: some of the data types included in this API are not available in the settings UI, and some UI settings control more than one data type listed here.","type":"function","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"result","type":"object","properties":{"options":{"$ref":"#/types/RemovalOptions"},"dataToRemove":{"allOf":[{"$ref":"#/types/DataTypeSet"},{"description":"All of the types will be present in the result, with values of <code>true</code> if they are both selected to be removed and permitted to be removed, otherwise <code>false</code>."}]},"dataRemovalPermitted":{"allOf":[{"$ref":"#/types/DataTypeSet"},{"description":"All of the types will be present in the result, with values of <code>true</code> if they are permitted to be removed (e.g., by enterprise policy) and <code>false</code> if not."}]}},"required":["options","dataToRemove","dataRemovalPermitted"]}]}]},{"name":"remove","description":"Clears various types of browsing data stored in a user\'s profile.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"allOf":[{"$ref":"#/types/DataTypeSet"},{"name":"dataToRemove","description":"The set of data types to remove."}]},{"name":"callback","type":"function","description":"Called when deletion has completed.","optional":true,"parameters":[]}]},{"name":"removeAppcache","description":"Clears websites\' appcache data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' appcache data has been cleared.","optional":true,"parameters":[]}]},{"name":"removeCache","description":"Clears the browser\'s cache.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s cache has been cleared.","optional":true,"parameters":[]}]},{"name":"removeCookies","description":"Clears the browser\'s cookies and server-bound certificates modified within a particular timeframe.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s cookies and server-bound certificates have been cleared.","optional":true,"parameters":[]}]},{"name":"removeDownloads","description":"Clears the browser\'s list of downloaded files (<em>not</em> the downloaded files themselves).","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s list of downloaded files has been cleared.","optional":true,"parameters":[]}]},{"name":"removeFileSystems","description":"Clears websites\' file system data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' file systems have been cleared.","optional":true,"parameters":[]}]},{"name":"removeFormData","description":"Clears the browser\'s stored form data (autofill).","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s form data has been cleared.","optional":true,"parameters":[]}]},{"name":"removeHistory","description":"Clears the browser\'s history.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s history has cleared.","optional":true,"parameters":[]}]},{"name":"removeIndexedDB","description":"Clears websites\' IndexedDB data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' IndexedDB data has been cleared.","optional":true,"parameters":[]}]},{"name":"removeLocalStorage","description":"Clears websites\' local storage data.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' local storage has been cleared.","optional":true,"parameters":[]}]},{"name":"removePluginData","description":"Clears plugins\' data.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when plugins\' data has been cleared.","optional":true,"parameters":[]}]},{"name":"removePasswords","description":"Clears the browser\'s stored passwords.","type":"function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when the browser\'s passwords have been cleared.","optional":true,"parameters":[]}]},{"name":"removeWebSQL","description":"Clears websites\' WebSQL data.","type":"function","async":"callback","unsupported":true,"parameters":[{"allOf":[{"$ref":"#/types/RemovalOptions"},{"name":"options"}]},{"name":"callback","type":"function","description":"Called when websites\' WebSQL databases have been cleared.","optional":true,"parameters":[]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["browsingData"]}]}},"refs":{"browsingData#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"RemovalOptions":{"type":"object","description":"Options that determine exactly what data will be removed.","properties":{"since":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Remove data accumulated on or after this date, represented in milliseconds since the epoch (accessible via the <code>getTime</code> method of the JavaScript <code>Date</code> object). If absent, defaults to 0 (which would remove all browsing data)."}]},"hostnames":{"type":"array","items":{"type":"string","format":"hostname"},"description":"Only remove data associated with these hostnames (only applies to cookies and localStorage)."},"cookieStoreId":{"type":"string","description":"Only remove data associated with this specific cookieStoreId."},"originTypes":{"type":"object","description":"An object whose properties specify which origin types ought to be cleared. If this object isn\'t specified, it defaults to clearing only \\"unprotected\\" origins. Please ensure that you <em>really</em> want to remove application data before adding \'protectedWeb\' or \'extensions\'.","properties":{"unprotectedWeb":{"type":"boolean","description":"Normal websites."},"protectedWeb":{"type":"boolean","description":"Websites that have been installed as hosted applications (be careful!)."},"extension":{"type":"boolean","description":"Extensions and packaged applications a user has installed (be _really_ careful!)."}}}}},"DataTypeSet":{"type":"object","description":"A set of data types. Missing data types are interpreted as <code>false</code>.","properties":{"cache":{"type":"boolean","description":"The browser\'s cache. Note: when removing data, this clears the <em>entire</em> cache: it is not limited to the range you specify."},"cookies":{"type":"boolean","description":"The browser\'s cookies."},"downloads":{"type":"boolean","description":"The browser\'s download list."},"formData":{"type":"boolean","description":"The browser\'s stored form data."},"history":{"type":"boolean","description":"The browser\'s history."},"indexedDB":{"type":"boolean","description":"Websites\' IndexedDB data."},"localStorage":{"type":"boolean","description":"Websites\' local storage data."},"serverBoundCertificates":{"type":"boolean","description":"Server-bound certificates."},"passwords":{"type":"boolean","description":"Stored passwords."},"pluginData":{"type":"boolean","description":"Plugins\' data."},"serviceWorkers":{"type":"boolean","description":"Service Workers."}}}}}');

/***/ }),
/* 58 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"captivePortal","description":"This API provides the ability detect the captive portal state of the users connection.","permissions":["captivePortal"],"properties":{"canonicalURL":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Return the canonical captive-portal detection URL. Read-only."}]}},"functions":[{"name":"getState","type":"function","description":"Returns the current portal state, one of `unknown`, `not_captive`, `unlocked_portal`, `locked_portal`.","async":true,"parameters":[]},{"name":"getLastChecked","type":"function","description":"Returns the time difference between NOW and the last time a request was completed in milliseconds.","async":true,"parameters":[]}],"events":[{"name":"onStateChanged","type":"function","description":"Fired when the captive portal state changes.","parameters":[{"type":"object","name":"details","properties":{"state":{"type":"string","enum":["unknown","not_captive","unlocked_portal","locked_portal"],"description":"The current captive portal state."}},"required":["state"]}]},{"name":"onConnectivityAvailable","type":"function","description":"This notification will be emitted when the captive portal service has determined that we can connect to the internet. The service will pass either `captive` if there is an unlocked captive portal present, or `clear` if no captive portal was detected.","parameters":[{"name":"status","enum":["captive","clear"],"type":"string"}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["captivePortal"]}]}},"refs":{"captivePortal#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{}}');

/***/ }),
/* 59 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"chrome_settings_overrides","definitions":{"WebExtensionManifest":{"properties":{"chrome_settings_overrides":{"type":"object","properties":{"homepage":{"type":"string","format":"homepageUrl","preprocess":"localize"},"search_provider":{"type":"object","properties":{"name":{"type":"string","preprocess":"localize"},"keyword":{"anyOf":[{"type":"string","preprocess":"localize"},{"type":"array","items":{"type":"string","preprocess":"localize"},"minItems":1}]},"search_url":{"type":"string","format":"url","pattern":"^(https://|http://(localhost|127\\\\.0\\\\.0\\\\.1|\\\\[::1\\\\])(:\\\\d*)?(/|$)).*$","preprocess":"localize"},"favicon_url":{"anyOf":[{"type":"string","format":"relativeUrl","max_manifest_version":2},{"type":"string","format":"strictRelativeUrl"}],"preprocess":"localize"},"suggest_url":{"type":"string","pattern":"^$|^(https://|http://(localhost|127\\\\.0\\\\.0\\\\.1|\\\\[::1\\\\])(:\\\\d*)?(/|$)).*$","preprocess":"localize"},"instant_url":{"type":"string","format":"url","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"image_url":{"type":"string","format":"url","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"search_url_get_params":{"type":"string","preprocess":"localize","description":"GET parameters to the search_url as a query string."},"search_url_post_params":{"type":"string","preprocess":"localize","description":"POST parameters to the search_url as a query string."},"suggest_url_get_params":{"type":"string","preprocess":"localize","description":"GET parameters to the suggest_url as a query string."},"suggest_url_post_params":{"type":"string","preprocess":"localize","description":"POST parameters to the suggest_url as a query string."},"instant_url_post_params":{"type":"string","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"image_url_post_params":{"type":"string","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"search_form":{"type":"string","format":"url","pattern":"^(https://|http://(localhost|127\\\\.0\\\\.0\\\\.1|\\\\[::1\\\\])(:\\\\d*)?(/|$)).*$","preprocess":"localize","deprecated":"Unsupported on Firefox at this time."},"alternate_urls":{"type":"array","items":{"type":"string","format":"url","preprocess":"localize"},"deprecated":"Unsupported on Firefox at this time."},"prepopulated_id":{"type":"integer","deprecated":"Unsupported on Firefox."},"encoding":{"type":"string","description":"Encoding of the search term."},"is_default":{"type":"boolean","description":"Sets the default engine to a built-in engine only."}},"required":["name","search_url"]}}}}}},"refs":{"chrome_settings_overrides#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{}}');

/***/ }),
/* 60 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"clipboard","description":"Offers the ability to write to the clipboard. Reading is not supported because the clipboard can already be read through the standard web platform APIs.","permissions":["clipboardWrite"],"functions":[{"name":"setImageData","type":"function","description":"Copy an image to the clipboard. The image is re-encoded before it is written to the clipboard. If the image is invalid, the clipboard is not modified.","async":true,"parameters":[{"type":"object","isInstanceOf":"ArrayBuffer","additionalProperties":true,"name":"imageData","description":"The image data to be copied."},{"type":"string","name":"imageType","enum":["jpeg","png"],"description":"The type of imageData."}]}],"definitions":{},"refs":{},"types":{}}');

/***/ }),
/* 61 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"commands","description":"Use the commands API to add keyboard shortcuts that trigger actions in your extension, for example, an action to open the browser action or send a command to the xtension.","permissions":["manifest:commands"],"events":[{"name":"onCommand","description":"Fired when a registered command is activated using a keyboard shortcut.","type":"function","parameters":[{"name":"command","type":"string"},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","optional":true,"description":"Details of the $(ref:tabs.Tab) where the command was activated."}]}]},{"name":"onChanged","description":"Fired when a registered command\'s shortcut is changed.","type":"function","parameters":[{"type":"object","name":"changeInfo","properties":{"name":{"type":"string","description":"The name of the shortcut."},"newShortcut":{"type":"string","description":"The new shortcut active for this command, or blank if not active."},"oldShortcut":{"type":"string","description":"The old shortcut which is no longer active for this command, or blank if the shortcut was previously inactive."}},"required":["name","newShortcut","oldShortcut"]}]}],"functions":[{"name":"update","type":"function","async":true,"description":"Update the details of an already defined command.","parameters":[{"type":"object","name":"detail","description":"The new description for the command.","properties":{"name":{"type":"string","description":"The name of the command."},"description":{"type":"string","description":"The new description for the command."},"shortcut":{"type":"string","format":"manifestShortcutKeyOrEmpty"}},"required":["name"]}]},{"name":"reset","type":"function","async":true,"description":"Reset a command\'s details to what is specified in the manifest.","parameters":[{"type":"string","name":"name","description":"The name of the command."}]},{"name":"getAll","type":"function","async":"callback","description":"Returns all the registered extension commands for this extension and their shortcut (if active).","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[{"name":"commands","type":"array","items":{"$ref":"#/types/Command"}}],"description":"Called to return the registered commands."}]}],"definitions":{"WebExtensionManifest":{"properties":{"commands":{"type":"object","additionalProperties":{"type":"object","properties":{"suggested_key":{"type":"object","properties":{"default":{"$ref":"#/types/KeyName"},"mac":{"$ref":"#/types/KeyName"},"linux":{"$ref":"#/types/KeyName"},"windows":{"$ref":"#/types/KeyName"},"chromeos":{"type":"string"},"android":{"type":"string"},"ios":{"type":"string"},"additionalProperties":{"type":"string","deprecated":"Unknown platform name"}}},"description":{"type":"string","preprocess":"localize"}}}}}}},"refs":{"commands#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"Command":{"type":"object","properties":{"name":{"type":"string","description":"The name of the Extension Command"},"description":{"type":"string","description":"The Extension Command description"},"shortcut":{"type":"string","description":"The shortcut active for this command, or blank if not active."}}},"KeyName":{"type":"string","format":"manifestShortcutKey"}}}');

/***/ }),
/* 62 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"contentScripts","max_manifest_version":2,"functions":[{"name":"register","type":"function","description":"Register a content script programmatically","async":true,"parameters":[{"allOf":[{"$ref":"#/types/RegisteredContentScriptOptions"},{"name":"contentScriptOptions"}]}]}],"definitions":{},"refs":{},"types":{"RegisteredContentScriptOptions":{"type":"object","description":"Details of a content script registered programmatically","properties":{"matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"excludeMatches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"includeGlobs":{"type":"array","items":{"type":"string"}},"excludeGlobs":{"type":"array","items":{"type":"string"}},"css":{"type":"array","description":"The list of CSS files to inject","items":{"$ref":"extensionTypes#/types/ExtensionFileOrCode"}},"js":{"type":"array","description":"The list of JS files to inject","items":{"$ref":"extensionTypes#/types/ExtensionFileOrCode"}},"allFrames":{"type":"boolean","description":"If allFrames is <code>true</code>, implies that the JavaScript or CSS should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"matchAboutBlank":{"type":"boolean","description":"If matchAboutBlank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Ignored if matchOriginAsFallback is specified. By default it is <code>false</code>."},"matchOriginAsFallback":{"type":"boolean","description":"If matchOriginAsFallback is true, then the code is also injected in about:, data:, blob: when their origin matches the pattern in \'matches\', even if the actual document origin is opaque (due to the use of CSP sandbox or iframe sandbox). Match patterns in \'matches\' must specify a wildcard path glob. By default it is <code>false</code>."},"runAt":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"description":"The soonest that the JavaScript or CSS will be injected into the tab. Defaults to \\"document_idle\\"."}]},"world":{"allOf":[{"$ref":"extensionTypes#/types/ExecutionWorld"},{"description":"The JavaScript world for a script to execute within. Defaults to \\"ISOLATED\\"."}]},"cookieStoreId":{"anyOf":[{"type":"array","minItems":1,"items":{"type":"string"}},{"type":"string"}],"description":"limit the set of matched tabs to those that belong to the given cookie store id"}},"required":["matches"]},"RegisteredContentScript":{"type":"object","description":"An object that represents a content script registered programmatically","functions":[{"name":"unregister","type":"function","description":"Unregister a content script registered programmatically","async":true,"parameters":[]}]}}}');

/***/ }),
/* 63 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"contextualIdentities","description":"Use the <code>browser.contextualIdentities</code> API to query and modify contextual identity, also called as containers.","permissions":["contextualIdentities"],"functions":[{"name":"get","type":"function","description":"Retrieves information about a single contextual identity.","async":true,"parameters":[{"type":"string","name":"cookieStoreId","description":"The ID of the contextual identity cookie store. "}]},{"name":"query","type":"function","description":"Retrieves all contextual identities","async":true,"parameters":[{"type":"object","name":"details","description":"Information to filter the contextual identities being retrieved.","properties":{"name":{"type":"string","description":"Filters the contextual identity by name."}}}]},{"name":"create","type":"function","description":"Creates a contextual identity with the given data.","async":true,"parameters":[{"type":"object","name":"details","description":"Details about the contextual identity being created.","properties":{"name":{"type":"string","description":"The name of the contextual identity."},"color":{"type":"string","description":"The color of the contextual identity."},"icon":{"type":"string","description":"The icon of the contextual identity."}},"required":["name","color","icon"]}]},{"name":"update","type":"function","description":"Updates a contextual identity with the given data.","async":true,"parameters":[{"type":"string","name":"cookieStoreId","description":"The ID of the contextual identity cookie store. "},{"type":"object","name":"details","description":"Details about the contextual identity being created.","properties":{"name":{"type":"string","description":"The name of the contextual identity."},"color":{"type":"string","description":"The color of the contextual identity."},"icon":{"type":"string","description":"The icon of the contextual identity."}}}]},{"name":"move","type":"function","description":"Reorder one or more contextual identities by their cookieStoreIDs to a given position.","async":true,"parameters":[{"name":"cookieStoreIds","description":"The ID or list of IDs of the contextual identity cookie stores. ","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},{"type":"integer","name":"position","description":"The position the contextual identity should move to."}]},{"name":"remove","type":"function","description":"Deletes a contextual identity by its cookie Store ID.","async":true,"parameters":[{"type":"string","name":"cookieStoreId","description":"The ID of the contextual identity cookie store. "}]}],"events":[{"name":"onUpdated","type":"function","description":"Fired when a container is updated.","parameters":[{"type":"object","name":"changeInfo","properties":{"contextualIdentity":{"allOf":[{"$ref":"#/types/ContextualIdentity"},{"description":"Contextual identity that has been updated"}]}},"required":["contextualIdentity"]}]},{"name":"onCreated","type":"function","description":"Fired when a new container is created.","parameters":[{"type":"object","name":"changeInfo","properties":{"contextualIdentity":{"allOf":[{"$ref":"#/types/ContextualIdentity"},{"description":"Contextual identity that has been created"}]}},"required":["contextualIdentity"]}]},{"name":"onRemoved","type":"function","description":"Fired when a container is removed.","parameters":[{"type":"object","name":"changeInfo","properties":{"contextualIdentity":{"allOf":[{"$ref":"#/types/ContextualIdentity"},{"description":"Contextual identity that has been removed"}]}},"required":["contextualIdentity"]}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["contextualIdentities"]}]}},"refs":{"contextualIdentities#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"ContextualIdentity":{"type":"object","description":"Represents information about a contextual identity.","properties":{"name":{"type":"string","description":"The name of the contextual identity."},"icon":{"type":"string","description":"The icon name of the contextual identity."},"iconUrl":{"type":"string","description":"The icon url of the contextual identity."},"color":{"type":"string","description":"The color name of the contextual identity."},"colorCode":{"type":"string","description":"The color hash of the contextual identity."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."}},"required":["name","icon","iconUrl","color","colorCode","cookieStoreId"]}}}');

/***/ }),
/* 64 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"cookies","description":"Use the <code>browser.cookies</code> API to query and modify cookies, and to be notified when they change.","permissions":["cookies"],"functions":[{"name":"get","type":"function","description":"Retrieves information about a single cookie. If more than one cookie of the same name exists for the given URL, the one with the longest path will be returned. For cookies with the same path length, the cookie with the earliest creation time will be returned.","async":"callback","parameters":[{"type":"object","name":"details","description":"Details to identify the cookie being retrieved.","properties":{"url":{"type":"string","description":"The URL with which the cookie to retrieve is associated. This argument may be a full URL, in which case any data following the URL path (e.g. the query string) is simply ignored. If host permissions for this URL are not specified in the manifest file, the API call will fail."},"name":{"type":"string","description":"The name of the cookie to retrieve."},"storeId":{"type":"string","description":"The ID of the cookie store in which to look for the cookie. By default, the current execution context\'s cookie store will be used."},"firstPartyDomain":{"type":"string","description":"The first-party domain which the cookie to retrieve is associated. This attribute is required if First-Party Isolation is enabled."},"partitionKey":{"allOf":[{"$ref":"#/types/PartitionKey"},{"description":"The storage partition, if the cookie is part of partitioned storage. By default, only non-partitioned cookies are returned."}]}},"required":["url","name"]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Cookie"},{"name":"cookie","optional":true,"description":"Contains details about the cookie. This parameter is null if no such cookie was found."}]}]}]},{"name":"getAll","type":"function","description":"Retrieves all cookies from a single cookie store that match the given information.  The cookies returned will be sorted, with those with the longest path first.  If multiple cookies have the same path length, those with the earliest creation time will be first.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information to filter the cookies being retrieved.","properties":{"url":{"type":"string","description":"Restricts the retrieved cookies to those that would match the given URL."},"name":{"type":"string","description":"Filters the cookies by name."},"domain":{"type":"string","description":"Restricts the retrieved cookies to those whose domains match or are subdomains of this one."},"path":{"type":"string","description":"Restricts the retrieved cookies to those whose path exactly matches this string."},"secure":{"type":"boolean","description":"Filters the cookies by their Secure property."},"session":{"type":"boolean","description":"Filters out session vs. persistent cookies."},"storeId":{"type":"string","description":"The cookie store to retrieve cookies from. If omitted, the current execution context\'s cookie store will be used."},"firstPartyDomain":{"type":"string","description":"Restricts the retrieved cookies to those whose first-party domains match this one. This attribute is required if First-Party Isolation is enabled. To not filter by a specific first-party domain, use `null` or `undefined`."},"partitionKey":{"allOf":[{"$ref":"#/types/PartitionKey"},{"description":"Selects a specific storage partition to look up cookies. Defaults to null, in which case only non-partitioned cookies are retrieved. If an object iis passed, partitioned cookies are also included, and filtered based on the keys present in the given PartitionKey description. An empty object ({}) returns all cookies (partitioned + unpartitioned), a non-empty object (e.g. {topLevelSite: \'...\'}) only returns cookies whose partition match all given attributes."}]}}},{"type":"function","name":"callback","parameters":[{"name":"cookies","type":"array","items":{"$ref":"#/types/Cookie"},"description":"All the existing, unexpired cookies that match the given cookie info."}]}]},{"name":"set","type":"function","description":"Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist.","async":"callback","parameters":[{"type":"object","name":"details","description":"Details about the cookie being set.","properties":{"url":{"type":"string","description":"The request-URI to associate with the setting of the cookie. This value can affect the default domain and path values of the created cookie. If host permissions for this URL are not specified in the manifest file, the API call will fail."},"name":{"type":"string","description":"The name of the cookie. Empty by default if omitted."},"value":{"type":"string","description":"The value of the cookie. Empty by default if omitted."},"domain":{"type":"string","description":"The domain of the cookie. If omitted, the cookie becomes a host-only cookie."},"path":{"type":"string","description":"The path of the cookie. Defaults to the path portion of the url parameter."},"secure":{"type":"boolean","description":"Whether the cookie should be marked as Secure. Defaults to false."},"httpOnly":{"type":"boolean","description":"Whether the cookie should be marked as HttpOnly. Defaults to false."},"sameSite":{"allOf":[{"$ref":"#/types/SameSiteStatus"},{"description":"The cookie\'s same-site status.","default":"no_restriction"}]},"expirationDate":{"type":"number","description":"The expiration date of the cookie as the number of seconds since the UNIX epoch. If omitted, the cookie becomes a session cookie."},"storeId":{"type":"string","description":"The ID of the cookie store in which to set the cookie. By default, the cookie is set in the current execution context\'s cookie store."},"firstPartyDomain":{"type":"string","description":"The first-party domain of the cookie. This attribute is required if First-Party Isolation is enabled."},"partitionKey":{"allOf":[{"$ref":"#/types/PartitionKey"},{"description":"The storage partition, if the cookie is part of partitioned storage. By default, non-partitioned storage is used."}]}},"required":["url"]},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Cookie"},{"name":"cookie","optional":true,"description":"Contains details about the cookie that\'s been set.  If setting failed for any reason, this will be \\"null\\", and $(ref:runtime.lastError) will be set."}]}]}]},{"name":"remove","type":"function","description":"Deletes a cookie by name.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information to identify the cookie to remove.","properties":{"url":{"type":"string","description":"The URL associated with the cookie. If host permissions for this URL are not specified in the manifest file, the API call will fail."},"name":{"type":"string","description":"The name of the cookie to remove."},"storeId":{"type":"string","description":"The ID of the cookie store to look in for the cookie. If unspecified, the cookie is looked for by default in the current execution context\'s cookie store."},"firstPartyDomain":{"type":"string","description":"The first-party domain associated with the cookie. This attribute is required if First-Party Isolation is enabled."},"partitionKey":{"allOf":[{"$ref":"#/types/PartitionKey"},{"description":"The storage partition, if the cookie is part of partitioned storage. By default, non-partitioned storage is used."}]}},"required":["url","name"]},{"type":"function","name":"callback","optional":true,"parameters":[{"name":"details","type":"object","description":"Contains details about the cookie that\'s been removed.  If removal failed for any reason, this will be \\"null\\", and $(ref:runtime.lastError) will be set.","optional":true,"properties":{"url":{"type":"string","description":"The URL associated with the cookie that\'s been removed."},"name":{"type":"string","description":"The name of the cookie that\'s been removed."},"storeId":{"type":"string","description":"The ID of the cookie store from which the cookie was removed."},"firstPartyDomain":{"type":"string","description":"The first-party domain associated with the cookie that\'s been removed."},"partitionKey":{"allOf":[{"$ref":"#/types/PartitionKey"},{"description":"The storage partition, if the cookie is part of partitioned storage. null if not partitioned."}]}},"required":["url","name","storeId","firstPartyDomain"]}]}]},{"name":"getAllCookieStores","type":"function","description":"Lists all existing cookie stores.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"cookieStores","type":"array","items":{"$ref":"#/types/CookieStore"},"description":"All the existing cookie stores."}]}]}],"events":[{"name":"onChanged","type":"function","description":"Fired when a cookie is set or removed. As a special case, note that updating a cookie\'s properties is implemented as a two step process: the cookie to be updated is first removed entirely, generating a notification with \\"cause\\" of \\"overwrite\\" .  Afterwards, a new cookie is written with the updated values, generating a second notification with \\"cause\\" \\"explicit\\".","parameters":[{"type":"object","name":"changeInfo","properties":{"removed":{"type":"boolean","description":"True if a cookie was removed."},"cookie":{"allOf":[{"$ref":"#/types/Cookie"},{"description":"Information about the cookie that was set or removed."}]},"cause":{"allOf":[{"$ref":"#/types/OnChangedCause"},{"description":"The underlying reason behind the cookie\'s change."}]}},"required":["removed","cookie","cause"]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["cookies"]}]}},"refs":{"cookies#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"SameSiteStatus":{"type":"string","enum":["no_restriction","lax","strict"],"description":"A cookie\'s \'SameSite\' state (https://tools.ietf.org/html/draft-west-first-party-cookies). \'no_restriction\' corresponds to a cookie set without a \'SameSite\' attribute, \'lax\' to \'SameSite=Lax\', and \'strict\' to \'SameSite=Strict\'."},"PartitionKey":{"type":"object","description":"The description of the storage partition of a cookie. This object may be omitted (null) if a cookie is not partitioned.","properties":{"topLevelSite":{"type":"string","description":"The first-party URL of the cookie, if the cookie is in storage partitioned by the top-level site."},"hasCrossSiteAncestor":{"type":"boolean","description":"Whether or not the cookie is in a third-party context, respecting ancestor chains."}}},"Cookie":{"type":"object","description":"Represents information about an HTTP cookie.","properties":{"name":{"type":"string","description":"The name of the cookie."},"value":{"type":"string","description":"The value of the cookie."},"domain":{"type":"string","description":"The domain of the cookie (e.g. \\"www.google.com\\", \\"example.com\\")."},"hostOnly":{"type":"boolean","description":"True if the cookie is a host-only cookie (i.e. a request\'s host must exactly match the domain of the cookie)."},"path":{"type":"string","description":"The path of the cookie."},"secure":{"type":"boolean","description":"True if the cookie is marked as Secure (i.e. its scope is limited to secure channels, typically HTTPS)."},"httpOnly":{"type":"boolean","description":"True if the cookie is marked as HttpOnly (i.e. the cookie is inaccessible to client-side scripts)."},"sameSite":{"allOf":[{"$ref":"#/types/SameSiteStatus"},{"description":"The cookie\'s same-site status (i.e. whether the cookie is sent with cross-site requests)."}]},"session":{"type":"boolean","description":"True if the cookie is a session cookie, as opposed to a persistent cookie with an expiration date."},"expirationDate":{"type":"number","description":"The expiration date of the cookie as the number of seconds since the UNIX epoch. Not provided for session cookies."},"storeId":{"type":"string","description":"The ID of the cookie store containing this cookie, as provided in getAllCookieStores()."},"firstPartyDomain":{"type":"string","description":"The first-party domain of the cookie."},"partitionKey":{"allOf":[{"$ref":"#/types/PartitionKey"},{"description":"The cookie\'s storage partition, if any. null if not partitioned."}]}},"required":["name","value","domain","hostOnly","path","secure","httpOnly","sameSite","session","storeId","firstPartyDomain"]},"CookieStore":{"type":"object","description":"Represents a cookie store in the browser. An incognito mode window, for instance, uses a separate cookie store from a non-incognito window.","properties":{"id":{"type":"string","description":"The unique identifier for the cookie store."},"tabIds":{"type":"array","items":{"type":"integer"},"description":"Identifiers of all the browser tabs that share this cookie store."},"incognito":{"type":"boolean","description":"Indicates if this is an incognito cookie store"}},"required":["id","tabIds","incognito"]},"OnChangedCause":{"type":"string","enum":["evicted","expired","explicit","expired_overwrite","overwrite"],"description":"The underlying reason behind the cookie\'s change. If a cookie was inserted, or removed via an explicit call to $(ref:cookies.remove), \\"cause\\" will be \\"explicit\\". If a cookie was automatically removed due to expiry, \\"cause\\" will be \\"expired\\". If a cookie was removed due to being overwritten with an already-expired expiration date, \\"cause\\" will be set to \\"expired_overwrite\\".  If a cookie was automatically removed due to garbage collection, \\"cause\\" will be \\"evicted\\".  If a cookie was automatically removed due to a \\"set\\" call that overwrote it, \\"cause\\" will be \\"overwrite\\". Plan your response accordingly."}}}');

/***/ }),
/* 65 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"declarativeNetRequest","description":"Use the declarativeNetRequest API to block or modify network requests by specifying declarative rules.","permissions":["declarativeNetRequest","declarativeNetRequestWithHostAccess"],"functions":[{"name":"updateDynamicRules","type":"function","description":"Modifies the current set of dynamic rules for the extension. The rules with IDs listed in options.removeRuleIds are first removed, and then the rules given in options.addRules are added. These rules are persisted across browser sessions and extension updates.","async":"callback","parameters":[{"name":"options","type":"object","properties":{"removeRuleIds":{"type":"array","description":"IDs of the rules to remove. Any invalid IDs will be ignored.","items":{"type":"integer"}},"addRules":{"type":"array","description":"Rules to add.","items":{"$ref":"#/types/Rule"}}}},{"name":"callback","type":"function","description":"Called when the dynamic rules have been updated","parameters":[]}]},{"name":"updateSessionRules","type":"function","description":"Modifies the current set of session scoped rules for the extension. The rules with IDs listed in options.removeRuleIds are first removed, and then the rules given in options.addRules are added. These rules are not persisted across sessions and are backed in memory.","async":"callback","parameters":[{"name":"options","type":"object","properties":{"removeRuleIds":{"type":"array","description":"IDs of the rules to remove. Any invalid IDs will be ignored.","items":{"type":"integer"}},"addRules":{"type":"array","description":"Rules to add.","items":{"$ref":"#/types/Rule"}}}},{"name":"callback","type":"function","description":"Called when the session rules have been updated","parameters":[]}]},{"name":"getEnabledRulesets","type":"function","description":"Returns the ids for the current set of enabled static rulesets.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"type":"array","name":"rulesetIds","items":{"type":"string"}}]}]},{"name":"updateEnabledRulesets","type":"function","description":"Modifies the static rulesets enabled/disabled state.","async":"callback","parameters":[{"name":"updateRulesetOptions","type":"object","properties":{"disableRulesetIds":{"type":"array","items":{"type":"string"},"default":[]},"enableRulesetIds":{"type":"array","items":{"type":"string"},"default":[]}}},{"name":"callback","type":"function","parameters":[]}]},{"name":"updateStaticRules","type":"function","description":"Modified individual static rules enabled/disabled state. Changes to rules belonging to a disabled ruleset will take effect when the ruleset becomes enabled.","async":"callback","parameters":[{"name":"options","type":"object","properties":{"rulesetId":{"type":"string"},"disableRuleIds":{"type":"array","items":{"type":"integer"},"default":[]},"enableRuleIds":{"type":"array","items":{"type":"integer"},"default":[]}},"required":["rulesetId"]},{"name":"callback","type":"function","parameters":[]}]},{"name":"getAvailableStaticRuleCount","type":"function","description":"Returns the remaining number of static rules an extension can enable","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"count","type":"integer"}]}]},{"name":"getDisabledRuleIds","type":"function","description":"Returns the list of individual disabled static rules from a given static ruleset id.","async":"callback","parameters":[{"name":"options","type":"object","properties":{"rulesetId":{"type":"string"}},"required":["rulesetId"]},{"name":"callback","type":"function","parameters":[{"name":"disabledRuleIds","type":"array","items":{"type":"integer"}}]}]},{"name":"getDynamicRules","type":"function","description":"Returns the current set of dynamic rules for the extension.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/GetRulesFilter"},{"name":"filter","optional":true,"description":"An object to filter the set of dynamic rules for the extension."}]},{"name":"callback","type":"function","parameters":[{"name":"dynamicRules","type":"array","items":{"$ref":"#/types/Rule"}}]}]},{"name":"getSessionRules","type":"function","description":"Returns the current set of session scoped rules for the extension.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/GetRulesFilter"},{"name":"filter","optional":true,"description":"An object to filter the set of session scoped rules for the extension."}]},{"name":"callback","type":"function","parameters":[{"name":"sessionRules","type":"array","items":{"$ref":"#/types/Rule"}}]}]},{"name":"isRegexSupported","type":"function","description":"Checks if the given regular expression will be supported as a \'regexFilter\' rule condition.","async":"callback","parameters":[{"name":"regexOptions","type":"object","properties":{"regex":{"type":"string","description":"The regular expresson to check."},"isCaseSensitive":{"type":"boolean","description":"Whether the \'regex\' specified is case sensitive.","default":false},"requireCapturing":{"type":"boolean","description":"Whether the \'regex\' specified requires capturing. Capturing is only required for redirect rules which specify a \'regexSubstition\' action.","default":false}},"required":["regex"]},{"name":"callback","type":"function","parameters":[{"name":"result","type":"object","properties":{"isSupported":{"type":"boolean","description":"Whether the given regex is supported"},"reason":{"allOf":[{"$ref":"#/types/UnsupportedRegexReason"},{"description":"Specifies the reason why the regular expression is not supported. Only provided if \'isSupported\' is false."}]}},"required":["isSupported"]}]}]},{"name":"testMatchOutcome","type":"function","description":"Checks if any of the extension\'s declarativeNetRequest rules would match a hypothetical request.","permissions":["declarativeNetRequestFeedback"],"async":"callback","parameters":[{"name":"request","type":"object","description":"The details of the request to test.","properties":{"url":{"type":"string","description":"The URL of the hypothetical request."},"initiator":{"type":"string","description":"The initiator URL (if any) for the hypothetical request."},"method":{"type":"string","description":"Standard HTTP method of the hypothetical request.","default":"get"},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"The resource type of the hypothetical request."}]},"tabId":{"type":"integer","description":"The ID of the tab in which the hypothetical request takes place. Does not need to correspond to a real tab ID. Default is -1, meaning that the request isn\'t related to a tab.","default":-1}},"required":["url","type"]},{"name":"options","type":"object","optional":true,"properties":{"includeOtherExtensions":{"type":"boolean","description":"Whether to account for rules from other installed extensions during rule evaluation."}}},{"name":"callback","type":"function","description":"Called with the details of matched rules.","parameters":[{"name":"result","type":"object","properties":{"matchedRules":{"type":"array","description":"The rules (if any) that match the hypothetical request.","items":{"$ref":"#/types/MatchedRule"}}},"required":["matchedRules"]}]}]}],"properties":{"DYNAMIC_RULESET_ID":{"type":"string","value":"_dynamic","description":"Ruleset ID for the dynamic rules added by the extension."},"GUARANTEED_MINIMUM_STATIC_RULES":{"type":"number","description":"The minimum number of static rules guaranteed to an extension across its enabled static rulesets. Any rules above this limit will count towards the global static rule limit."},"MAX_NUMBER_OF_STATIC_RULESETS":{"type":"number","description":"The maximum number of static Rulesets an extension can specify as part of the rule_resources manifest key."},"MAX_NUMBER_OF_DISABLED_STATIC_RULES":{"type":"number","description":"The maximum number of static rules that can be disabled on each static ruleset."},"MAX_NUMBER_OF_ENABLED_STATIC_RULESETS":{"type":"number","description":"The maximum number of static Rulesets an extension can enable at any one time."},"MAX_NUMBER_OF_DYNAMIC_AND_SESSION_RULES":{"type":"number","description":"Deprecated property returning the maximum number of dynamic and session rules an extension can add, replaced by MAX_NUMBER_OF_DYNAMIC_RULES/MAX_NUMBER_OF_SESSION_RULES."},"MAX_NUMBER_OF_DYNAMIC_RULES":{"type":"number","description":"The maximum number of dynamic session rules an extension can add."},"MAX_NUMBER_OF_SESSION_RULES":{"type":"number","description":"The maximum number of dynamic session rules an extension can add."},"MAX_NUMBER_OF_REGEX_RULES":{"type":"number","description":"The maximum number of regular expression rules that an extension can add. This limit is evaluated separately for the set of session rules, dynamic rules and those specified in the rule_resources file."},"SESSION_RULESET_ID":{"type":"string","value":"_session","description":"Ruleset ID for the session-scoped rules added by the extension."}},"definitions":{"Permission":{"anyOf":[{"type":"string","enum":["declarativeNetRequest"]}]},"OptionalPermission":{"anyOf":[{"type":"string","enum":["declarativeNetRequestFeedback"]}]},"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["declarativeNetRequestWithHostAccess"]}]},"WebExtensionManifest":{"properties":{"declarative_net_request":{"type":"object","properties":{"rule_resources":{"type":"array","minItems":1,"items":{"type":"object","properties":{"id":{"type":"string","pattern":"^[^_]","description":"A non-empty string uniquely identifying the ruleset. IDs beginning with \'_\' are reserved for internal use."},"enabled":{"type":"boolean","description":"Whether the ruleset is enabled by default."},"path":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"description":"The path of the JSON ruleset relative to the extension directory."}]}},"required":["id","enabled","path"]}}},"required":["rule_resources"]}}}},"refs":{"declarativeNetRequest#/definitions/Permission":{"namespace":"manifest","type":"Permission"},"declarativeNetRequest#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"},"declarativeNetRequest#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"declarativeNetRequest#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ResourceType":{"type":"string","description":"How the requested resource will be used. Comparable to the webRequest.ResourceType type.","enum":["main_frame","sub_frame","stylesheet","script","image","object","object_subrequest","xmlhttprequest","xslt","ping","beacon","xml_dtd","font","media","websocket","csp_report","imageset","web_manifest","speculative","json","other"]},"UnsupportedRegexReason":{"type":"string","description":"Describes the reason why a given regular expression isn\'t supported.","enum":["syntaxError","memoryLimitExceeded"]},"MatchedRule":{"type":"object","properties":{"ruleId":{"type":"integer","description":"A matching rule\'s ID."},"rulesetId":{"type":"string","description":"ID of the Ruleset this rule belongs to."},"extensionId":{"type":"string","description":"ID of the extension, if this rule belongs to a different extension."}},"required":["ruleId","rulesetId"]},"URLTransform":{"type":"object","description":"Describes the type of the Rule.action.redirect.transform property.","properties":{"scheme":{"type":"string","description":"The new scheme for the request.","enum":["http","https","moz-extension"]},"username":{"type":"string","description":"The new username for the request."},"password":{"type":"string","description":"The new password for the request."},"host":{"type":"string","description":"The new host name for the request."},"port":{"type":"string","description":"The new port for the request. If empty, the existing port is cleared."},"path":{"type":"string","description":"The new path for the request. If empty, the existing path is cleared."},"query":{"type":"string","description":"The new query for the request. Should be either empty, in which case the existing query is cleared; or should begin with \'?\'. Cannot be specified if \'queryTransform\' is specified."},"queryTransform":{"type":"object","description":"Add, remove or replace query key-value pairs. Cannot be specified if \'query\' is specified.","properties":{"removeParams":{"type":"array","description":"The list of query keys to be removed.","items":{"type":"string"}},"addOrReplaceParams":{"type":"array","description":"The list of query key-value pairs to be added or replaced.","items":{"type":"object","properties":{"key":{"type":"string"},"value":{"type":"string"},"replaceOnly":{"type":"boolean","description":"If true, the query key is replaced only if it\'s already present. Otherwise, the key is also added if it\'s missing.","default":false}},"required":["key","value"]}}}},"fragment":{"type":"string","description":"The new fragment for the request. Should be either empty, in which case the existing fragment is cleared; or should begin with \'#\'."}}},"Rule":{"type":"object","properties":{"id":{"type":"integer","description":"An id which uniquely identifies a rule. Mandatory and should be >= 1.","minimum":1},"priority":{"type":"integer","description":"Rule priority. Defaults to 1. When specified, should be >= 1","minimum":1,"default":1},"condition":{"type":"object","description":"The condition under which this rule is triggered.","properties":{"urlFilter":{"type":"string","description":"TODO: link to doc explaining supported pattern. The pattern which is matched against the network request url. Only one of \'urlFilter\' or \'regexFilter\' can be specified."},"regexFilter":{"type":"string","description":"Regular expression to match against the network request url. Only one of \'urlFilter\' or \'regexFilter\' can be specified."},"isUrlFilterCaseSensitive":{"type":"boolean","description":"Whether \'urlFilter\' or \'regexFilter\' is case-sensitive."},"initiatorDomains":{"type":"array","description":"The rule will only match network requests originating from the list of \'initiatorDomains\'. If the list is omitted, the rule is applied to requests from all domains.","minItems":1,"items":{"type":"string","format":"canonicalDomain"}},"excludedInitiatorDomains":{"type":"array","description":"The rule will not match network requests originating from the list of \'initiatorDomains\'. If the list is empty or omitted, no domains are excluded. This takes precedence over \'initiatorDomains\'.","items":{"type":"string","format":"canonicalDomain"}},"requestDomains":{"type":"array","description":"The rule will only match network requests when the domain matches one from the list of \'requestDomains\'. If the list is omitted, the rule is applied to requests from all domains.","minItems":1,"items":{"type":"string","format":"canonicalDomain"}},"excludedRequestDomains":{"type":"array","description":"The rule will not match network requests when the domains matches one from the list of \'excludedRequestDomains\'. If the list is empty or omitted, no domains are excluded. This takes precedence over \'requestDomains\'.","items":{"type":"string","format":"canonicalDomain"}},"resourceTypes":{"type":"array","description":"List of resource types which the rule can match. When the rule action is \'allowAllRequests\', this must be specified and may only contain \'main_frame\' or \'sub_frame\'. Cannot be specified if \'excludedResourceTypes\' is specified. If neither of them is specified, all resource types except \'main_frame\' are matched.","minItems":1,"items":{"$ref":"#/types/ResourceType"}},"excludedResourceTypes":{"type":"array","description":"List of resource types which the rule won\'t match. Cannot be specified if \'resourceTypes\' is specified. If neither of them is specified, all resource types except \'main_frame\' are matched.","items":{"$ref":"#/types/ResourceType"}},"requestMethods":{"type":"array","description":"List of HTTP request methods which the rule can match. Should be a lower-case method such as \'connect\', \'delete\', \'get\', \'head\', \'options\', \'patch\', \'post\', \'put\'.\'","minItems":1,"items":{"type":"string"}},"excludedRequestMethods":{"type":"array","description":"List of request methods which the rule won\'t match. Cannot be specified if \'requestMethods\' is specified. If neither of them is specified, all request methods are matched.","items":{"type":"string"}},"domainType":{"type":"string","description":"Specifies whether the network request is first-party or third-party to the domain from which it originated. If omitted, all requests are matched.","enum":["firstParty","thirdParty"]},"tabIds":{"type":"array","description":"List of tabIds which the rule should match. An ID of -1 matches requests which don\'t originate from a tab. Only supported for session-scoped rules.","minItems":1,"items":{"type":"integer"}},"excludedTabIds":{"type":"array","description":"List of tabIds which the rule should not match. An ID of -1 excludes requests which don\'t originate from a tab. Only supported for session-scoped rules.","items":{"type":"integer"}}}},"action":{"type":"object","description":"The action to take if this rule is matched.","properties":{"type":{"type":"string","enum":["block","redirect","allow","upgradeScheme","modifyHeaders","allowAllRequests"]},"redirect":{"type":"object","description":"Describes how the redirect should be performed. Only valid when type is \'redirect\'.","properties":{"extensionPath":{"type":"string","description":"Path relative to the extension directory. Should start with \'/\'."},"transform":{"allOf":[{"$ref":"#/types/URLTransform"},{"description":"Url transformations to perform."}]},"url":{"type":"string","format":"url","description":"The redirect url. Redirects to JavaScript urls are not allowed."},"regexSubstitution":{"type":"string","description":"Substitution pattern for rules which specify a \'regexFilter\'. The first match of regexFilter within the url will be replaced with this pattern. Within regexSubstitution, backslash-escaped digits (\\\\1 to \\\\9) can be used to insert the corresponding capture groups. \\\\0 refers to the entire matching text."}}},"requestHeaders":{"type":"array","description":"The request headers to modify for the request. Only valid when type is \'modifyHeaders\'.","minItems":1,"items":{"type":"object","properties":{"header":{"type":"string","description":"The name of the request header to be modified."},"operation":{"type":"string","description":"The operation to be performed on a header.","enum":["append","set","remove"]},"value":{"type":"string","description":"The new value for the header. Must be specified for the \'append\' and \'set\' operations."}},"required":["header","operation"]}},"responseHeaders":{"type":"array","description":"The response headers to modify for the request. Only valid when type is \'modifyHeaders\'.","minItems":1,"items":{"type":"object","properties":{"header":{"type":"string","description":"The name of the response header to be modified."},"operation":{"type":"string","description":"The operation to be performed on a header.","enum":["append","set","remove"]},"value":{"type":"string","description":"The new value for the header. Must be specified for the \'append\' and \'set\' operations."}},"required":["header","operation"]}}},"required":["type"]}},"required":["id","condition","action"]},"GetRulesFilter":{"type":"object","properties":{"ruleIds":{"type":"array","description":"If specified, only rules with matching IDs are included.","items":{"type":"integer"}}}}}}');

/***/ }),
/* 66 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"devtools","permissions":["manifest:devtools_page"],"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"definitions":{"WebExtensionManifest":{"properties":{"devtools_page":{"$ref":"manifest#/types/ExtensionURL"}}},"OptionalPermission":{"anyOf":[{"type":"string","enum":["devtools"]}]}},"refs":{"devtools#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"},"devtools#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"Resource":{"type":"object","description":"A resource within the inspected page, such as a document, a script, or an image.","properties":{"url":{"type":"string","description":"The URL of the resource."}},"functions":[{"name":"getContent","unsupported":true,"type":"function","async":"callback","description":"Gets the content of the resource.","parameters":[{"name":"callback","type":"function","description":"A function that receives resource content when the request completes.","parameters":[{"name":"content","type":"string","description":"Content of the resource (potentially encoded)."},{"name":"encoding","type":"string","description":"Empty if content is not encoded, encoding name otherwise. Currently, only base64 is supported."}]}]},{"name":"setContent","unsupported":true,"type":"function","async":"callback","description":"Sets the content of the resource.","parameters":[{"name":"content","type":"string","description":"New content of the resource. Only resources with the text type are currently supported."},{"name":"commit","type":"boolean","description":"True if the user has finished editing the resource, and the new content of the resource should be persisted; false if this is a minor change sent in progress of the user editing the resource."},{"name":"callback","type":"function","description":"A function called upon request completion.","optional":true,"parameters":[{"name":"error","type":"object","additionalProperties":{},"optional":true,"description":"Set to undefined if the resource content was set successfully; describes error otherwise."}]}]}],"required":["url"]},"Request":{"type":"object","description":"Represents a network request for a document resource (script, image and so on). See HAR Specification for reference.","functions":[{"name":"getContent","type":"function","description":"Returns content of the response body.","async":"callback","parameters":[{"name":"callback","type":"function","description":"A function that receives the response body when the request completes.","parameters":[{"name":"content","type":"string","description":"Content of the response body (potentially encoded)."},{"name":"encoding","type":"string","description":"Empty if content is not encoded, encoding name otherwise. Currently, only base64 is supported."}]}]}]},"ElementsPanel":{"type":"object","description":"Represents the Elements panel.","events":[{"name":"onSelectionChanged","type":"function","description":"Fired when an object is selected in the panel."}],"functions":[{"name":"createSidebarPane","async":"callback","type":"function","description":"Creates a pane within panel\'s sidebar.","parameters":[{"name":"title","type":"string","description":"Text that is displayed in sidebar caption."},{"name":"callback","type":"function","description":"A callback invoked when the sidebar is created.","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionSidebarPane"},{"name":"result","description":"An ExtensionSidebarPane object for created sidebar pane."}]}]}]}]},"SourcesPanel":{"type":"object","description":"Represents the Sources panel.","events":[{"name":"onSelectionChanged","unsupported":true,"description":"Fired when an object is selected in the panel."}],"functions":[{"name":"createSidebarPane","unsupported":true,"type":"function","description":"Creates a pane within panel\'s sidebar.","parameters":[{"name":"title","type":"string","description":"Text that is displayed in sidebar caption."},{"name":"callback","type":"function","description":"A callback invoked when the sidebar is created.","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionSidebarPane"},{"name":"result","description":"An ExtensionSidebarPane object for created sidebar pane."}]}]}]}]},"ExtensionPanel":{"type":"object","description":"Represents a panel created by extension.","functions":[{"name":"createStatusBarButton","unsupported":true,"description":"Appends a button to the status bar of the panel.","type":"function","parameters":[{"name":"iconPath","type":"string","description":"Path to the icon of the button. The file should contain a 64x24-pixel image composed of two 32x24 icons. The left icon is used when the button is inactive; the right icon is displayed when the button is pressed."},{"name":"tooltipText","type":"string","description":"Text shown as a tooltip when user hovers the mouse over the button."},{"name":"disabled","type":"boolean","description":"Whether the button is disabled."}],"returns":{"$ref":"#/types/Button"}}],"events":[{"name":"onSearch","unsupported":true,"description":"Fired upon a search action (start of a new search, search result navigation, or search being canceled).","parameters":[{"name":"action","type":"string","description":"Type of search action being performed."},{"name":"queryString","type":"string","optional":true,"description":"Query string (only for \'performSearch\')."}]},{"name":"onShown","type":"function","description":"Fired when the user switches to the panel.","parameters":[{"name":"window","type":"object","isInstanceOf":"global","additionalProperties":{},"description":"The JavaScript <code>window</code> object of panel\'s page."}]},{"name":"onHidden","type":"function","description":"Fired when the user switches away from the panel."}]},"ExtensionSidebarPane":{"type":"object","description":"A sidebar created by the extension.","functions":[{"name":"setHeight","unsupported":true,"type":"function","description":"Sets the height of the sidebar.","parameters":[{"name":"height","type":"string","description":"A CSS-like size specification, such as <code>\'100px\'</code> or <code>\'12ex\'</code>."}]},{"name":"setExpression","async":"callback","type":"function","description":"Sets an expression that is evaluated within the inspected page. The result is displayed in the sidebar pane.","parameters":[{"name":"expression","type":"string","description":"An expression to be evaluated in context of the inspected page. JavaScript objects and DOM nodes are displayed in an expandable tree similar to the console/watch."},{"name":"rootTitle","type":"string","optional":true,"description":"An optional title for the root of the expression tree."},{"name":"callback","type":"function","optional":true,"description":"A callback invoked after the sidebar pane is updated with the expression evaluation results."}]},{"name":"setObject","async":"callback","type":"function","description":"Sets a JSON-compliant object to be displayed in the sidebar pane.","parameters":[{"name":"jsonObject","type":"string","description":"An object to be displayed in context of the inspected page. Evaluated in the context of the caller (API client)."},{"name":"rootTitle","type":"string","optional":true,"description":"An optional title for the root of the expression tree."},{"name":"callback","type":"function","optional":true,"description":"A callback invoked after the sidebar is updated with the object."}]},{"name":"setPage","type":"function","async":true,"description":"Sets an HTML page to be displayed in the sidebar pane.","parameters":[{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"name":"path","description":"Relative path of an extension page to display within the sidebar."}]}]}],"events":[{"name":"onShown","type":"function","description":"Fired when the sidebar pane becomes visible as a result of user switching to the panel that hosts it.","parameters":[{"name":"window","type":"object","isInstanceOf":"global","additionalProperties":{},"description":"The JavaScript <code>window</code> object of the sidebar page, if one was set with the <code>setPage()</code> method."}]},{"name":"onHidden","type":"function","description":"Fired when the sidebar pane becomes hidden as a result of the user switching away from the panel that hosts the sidebar pane."}]},"Button":{"type":"object","description":"A button created by the extension.","functions":[{"name":"update","unsupported":true,"type":"function","description":"Updates the attributes of the button. If some of the arguments are omitted or <code>null</code>, the corresponding attributes are not updated.","parameters":[{"name":"iconPath","type":"string","optional":true,"description":"Path to the new icon of the button."},{"name":"tooltipText","type":"string","optional":true,"description":"Text shown as a tooltip when user hovers the mouse over the button."},{"name":"disabled","type":"boolean","optional":true,"description":"Whether the button is disabled."}]}],"events":[{"name":"onClicked","unsupported":true,"type":"function","description":"Fired when the button is clicked."}]}},"properties":{"inspectedWindow":{"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"description":"Use the <code>chrome.devtools.inspectedWindow</code> API to interact with the inspected window: obtain the tab ID for the inspected page, evaluate the code in the context of the inspected window, reload the page, or obtain the list of resources within the page.","nocompile":true,"properties":{"tabId":{"description":"The ID of the tab being inspected. This ID may be used with chrome.tabs.* API.","type":"integer"}},"functions":[{"name":"eval","type":"function","description":"Evaluates a JavaScript expression in the context of the main frame of the inspected page. The expression must evaluate to a JSON-compliant object, otherwise an exception is thrown. The eval function can report either a DevTools-side error or a JavaScript exception that occurs during evaluation. In either case, the <code>result</code> parameter of the callback is <code>undefined</code>. In the case of a DevTools-side error, the <code>isException</code> parameter is non-null and has <code>isError</code> set to true and <code>code</code> set to an error code. In the case of a JavaScript error, <code>isException</code> is set to true and <code>value</code> is set to the string value of thrown object.","async":"callback","parameters":[{"name":"expression","type":"string","description":"An expression to evaluate."},{"name":"options","type":"object","optional":true,"description":"The options parameter can contain one or more options.","properties":{"frameURL":{"type":"string","unsupported":true,"description":"If specified, the expression is evaluated on the iframe whose URL matches the one specified. By default, the expression is evaluated in the top frame of the inspected page."},"useContentScriptContext":{"type":"boolean","unsupported":true,"description":"Evaluate the expression in the context of the content script of the calling extension, provided that the content script is already injected into the inspected page. If not, the expression is not evaluated and the callback is invoked with the exception parameter set to an object that has the <code>isError</code> field set to true and the <code>code</code> field set to <code>E_NOTFOUND</code>."},"contextSecurityOrigin":{"type":"string","unsupported":true,"description":"Evaluate the expression in the context of a content script of an extension that matches the specified origin. If given, contextSecurityOrigin overrides the \'true\' setting on userContentScriptContext."}}},{"name":"callback","type":"function","description":"A function called when evaluation completes.","optional":true,"parameters":[{"name":"result","description":"The result of evaluation."},{"name":"exceptionInfo","type":"object","optional":true,"description":"An object providing details if an exception occurred while evaluating the expression.","properties":{"isError":{"type":"boolean","description":"Set if the error occurred on the DevTools side before the expression is evaluated."},"code":{"type":"string","description":"Set if the error occurred on the DevTools side before the expression is evaluated."},"description":{"type":"string","description":"Set if the error occurred on the DevTools side before the expression is evaluated."},"details":{"type":"array","items":{},"description":"Set if the error occurred on the DevTools side before the expression is evaluated, contains the array of the values that may be substituted into the description string to provide more information about the cause of the error."},"isException":{"type":"boolean","description":"Set if the evaluated code produces an unhandled exception."},"value":{"type":"string","description":"Set if the evaluated code produces an unhandled exception."}},"required":["isError","code","description","details","isException","value"]}]}]},{"name":"reload","type":"function","description":"Reloads the inspected page.","parameters":[{"type":"object","name":"reloadOptions","optional":true,"properties":{"ignoreCache":{"type":"boolean","description":"When true, the loader will bypass the cache for all inspected page resources loaded before the <code>load</code> event is fired. The effect is similar to pressing Ctrl+Shift+R in the inspected window or within the Developer Tools window."},"userAgent":{"type":"string","description":"If specified, the string will override the value of the <code>User-Agent</code> HTTP header that\'s sent while loading the resources of the inspected page. The string will also override the value of the <code>navigator.userAgent</code> property that\'s returned to any scripts that are running within the inspected page."},"injectedScript":{"type":"string","description":"If specified, the script will be injected into every frame of the inspected page immediately upon load, before any of the frame\'s scripts. The script will not be injected after subsequent reloads&mdash;for example, if the user presses Ctrl+R."},"preprocessorScript":{"unsupported":true,"type":"string","deprecated":"Please avoid using this parameter, it will be removed soon.","description":"If specified, this script evaluates into a function that accepts three string arguments: the source to preprocess, the URL of the source, and a function name if the source is an DOM event handler. The preprocessorerScript function should return a string to be compiled by Chrome in place of the input source. In the case that the source is a DOM event handler, the returned source must compile to a single JS function."}}}]},{"name":"getResources","unsupported":true,"type":"function","description":"Retrieves the list of resources from the inspected page.","async":"callback","parameters":[{"name":"callback","type":"function","description":"A function that receives the list of resources when the request completes.","parameters":[{"name":"resources","type":"array","items":{"$ref":"#/types/Resource"},"description":"The resources within the page."}]}]}],"events":[{"name":"onResourceAdded","unsupported":true,"type":"function","description":"Fired when a new resource is added to the inspected page.","parameters":[{"allOf":[{"$ref":"#/types/Resource"},{"name":"resource"}]}]},{"name":"onResourceContentCommitted","unsupported":true,"type":"function","description":"Fired when a new revision of the resource is committed (e.g. user saves an edited version of the resource in the Developer Tools).","parameters":[{"allOf":[{"$ref":"#/types/Resource"},{"name":"resource"}]},{"name":"content","type":"string","description":"New content of the resource."}]}],"required":["tabId"]},"network":{"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"description":"Use the <code>chrome.devtools.network</code> API to retrieve the information about network requests displayed by the Developer Tools in the Network panel.","functions":[{"name":"getHAR","type":"function","description":"Returns HAR log that contains all known network requests.","async":"callback","parameters":[{"name":"callback","type":"function","description":"A function that receives the HAR log when the request completes.","parameters":[{"name":"harLog","type":"object","additionalProperties":{},"description":"A HAR log. See HAR specification for details."}]}]}],"events":[{"name":"onRequestFinished","type":"function","description":"Fired when a network request is finished and all request data are available.","parameters":[{"allOf":[{"$ref":"#/types/Request"},{"name":"request","description":"Description of a network request in the form of a HAR entry. See HAR specification for details."}]}]},{"name":"onNavigated","type":"function","description":"Fired when the inspected window navigates to a new page.","parameters":[{"name":"url","type":"string","description":"URL of the new page."}]}]},"panels":{"allowedContexts":["devtools","devtools_only"],"defaultContexts":["devtools","devtools_only"],"description":"Use the <code>chrome.devtools.panels</code> API to integrate your extension into Developer Tools window UI: create your own panels, access existing panels, and add sidebars.","nocompile":true,"properties":{"elements":{"allOf":[{"$ref":"#/types/ElementsPanel"},{"description":"Elements panel."}]},"sources":{"allOf":[{"$ref":"#/types/SourcesPanel"},{"description":"Sources panel."}]},"themeName":{"type":"string","description":"The name of the current devtools theme."}},"functions":[{"name":"create","type":"function","description":"Creates an extension panel.","async":"callback","parameters":[{"name":"title","type":"string","description":"Title that is displayed next to the extension icon in the Developer Tools toolbar."},{"name":"iconPath","description":"Path of the panel\'s icon relative to the extension directory, or an empty string to use the default extension icon as the panel icon.","anyOf":[{"type":"string","enum":[""]},{"$ref":"manifest#/types/ExtensionURL"}]},{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"name":"pagePath","description":"Path of the panel\'s HTML page relative to the extension directory."}]},{"name":"callback","type":"function","optional":true,"description":"A function that is called when the panel is created.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionPanel"},{"name":"panel","description":"An ExtensionPanel object representing the created panel."}]}]}]},{"name":"setOpenResourceHandler","unsupported":true,"type":"function","description":"Specifies the function to be called when the user clicks a resource link in the Developer Tools window. To unset the handler, either call the method with no parameters or pass null as the parameter.","async":"callback","parameters":[{"name":"callback","type":"function","optional":true,"description":"A function that is called when the user clicks on a valid resource link in Developer Tools window. Note that if the user clicks an invalid URL or an XHR, this function is not called.","parameters":[{"allOf":[{"$ref":"devtools#/types/inspectedWindow"},{"name":"resource","description":"A $(ref:devtools.inspectedWindow.Resource) object for the resource that was clicked."}]}]}]},{"name":"openResource","unsupported":true,"type":"function","description":"Requests DevTools to open a URL in a Developer Tools panel.","async":"callback","parameters":[{"name":"url","type":"string","description":"The URL of the resource to open."},{"name":"lineNumber","type":"integer","description":"Specifies the line number to scroll to when the resource is loaded."},{"name":"callback","type":"function","optional":true,"description":"A function that is called when the resource has been successfully loaded."}]}],"events":[{"name":"onThemeChanged","type":"function","description":"Fired when the devtools theme changes.","parameters":[{"name":"themeName","type":"string","description":"The name of the current devtools theme."}]}],"required":["elements","sources","themeName"]}}}');

/***/ }),
/* 67 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"dns","description":"Asynchronous DNS API","permissions":["dns"],"functions":[{"name":"resolve","type":"function","description":"Resolves a hostname to a DNS record.","async":true,"parameters":[{"name":"hostname","type":"string"},{"allOf":[{"$ref":"#/types/ResolveFlags"},{"name":"flags","optional":true,"default":[]}]}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["dns"]}]}},"refs":{"dns#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"DNSRecord":{"type":"object","description":"An object encapsulating a DNS Record.","properties":{"canonicalName":{"type":"string","description":"The canonical hostname for this record.  this value is empty if the record was not fetched with the \'canonical_name\' flag."},"isTRR":{"type":"string","description":"Record retreived with TRR."},"addresses":{"type":"array","items":{"type":"string"}}},"required":["isTRR","addresses"]},"ResolveFlags":{"type":"array","items":{"type":"string","enum":["allow_name_collisions","bypass_cache","canonical_name","disable_ipv4","disable_ipv6","disable_trr","offline","priority_low","priority_medium","speculate"]}}}}');

/***/ }),
/* 68 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"downloads","permissions":["downloads"],"functions":[{"name":"download","type":"function","async":"callback","description":"Download a URL. If the URL uses the HTTP[S] protocol, then the request will include all cookies currently set for its hostname. If both <code>filename</code> and <code>saveAs</code> are specified, then the Save As dialog will be displayed, pre-populated with the specified <code>filename</code>. If the download started successfully, <code>callback</code> will be called with the new <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>downloadId</code>. If there was an error starting the download, then <code>callback</code> will be called with <code>downloadId=undefined</code> and <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> will contain a descriptive string. The error strings are not guaranteed to remain backwards compatible between releases. You must not parse it.","parameters":[{"description":"What to download and how.","name":"options","type":"object","properties":{"url":{"description":"The URL to download.","type":"string","format":"url"},"filename":{"description":"A file path relative to the Downloads directory to contain the downloaded file.","type":"string"},"incognito":{"description":"Whether to associate the download with a private browsing session.","default":false,"type":"boolean"},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity; requires \\"cookies\\" permission."},"conflictAction":{"$ref":"#/types/FilenameConflictAction"},"saveAs":{"description":"Use a file-chooser to allow the user to select a filename. If the option is not specified, the file chooser will be shown only if the Firefox \\"Always ask you where to save files\\" option is enabled (i.e. the pref <code>browser.download.useDownloadDir</code> is set to <code>false</code>).","type":"boolean"},"method":{"description":"The HTTP method to use if the URL uses the HTTP[S] protocol.","enum":["GET","POST"],"type":"string"},"headers":{"type":"array","description":"Extra HTTP headers to send with the request if the URL uses the HTTP[s] protocol. Each header is represented as a dictionary containing the keys <code>name</code> and either <code>value</code> or <code>binaryValue</code>, restricted to those allowed by XMLHttpRequest.","items":{"type":"object","properties":{"name":{"description":"Name of the HTTP header.","type":"string"},"value":{"description":"Value of the HTTP header.","type":"string"}},"required":["name","value"]}},"body":{"description":"Post body.","type":"string"},"allowHttpErrors":{"description":"When this flag is set to <code>true</code>, then the browser will allow downloads to proceed after encountering HTTP errors such as <code>404 Not Found</code>.","default":false,"type":"boolean"}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[{"name":"downloadId","type":"integer"}]}]},{"name":"search","type":"function","async":"callback","description":"Find <a href=\'#type-DownloadItem\'>DownloadItems</a>. Set <code>query</code> to the empty object to get all <a href=\'#type-DownloadItem\'>DownloadItems</a>. To get a specific <a href=\'#type-DownloadItem\'>DownloadItem</a>, set only the <code>id</code> field.","parameters":[{"allOf":[{"$ref":"#/types/DownloadQuery"},{"name":"query"}]},{"name":"callback","type":"function","parameters":[{"items":{"$ref":"#/types/DownloadItem"},"name":"results","type":"array"}]}]},{"name":"pause","type":"function","async":"callback","description":"Pause the download. If the request was successful the download is in a paused state. Otherwise <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> contains an error message. The request will fail if the download is not active.","parameters":[{"description":"The id of the download to pause.","name":"downloadId","type":"integer"},{"name":"callback","optional":true,"parameters":[],"type":"function"}]},{"name":"resume","type":"function","async":"callback","description":"Resume a paused download. If the request was successful the download is in progress and unpaused. Otherwise <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> contains an error message. The request will fail if the download is not active.","parameters":[{"description":"The id of the download to resume.","name":"downloadId","type":"integer"},{"name":"callback","optional":true,"parameters":[],"type":"function"}]},{"name":"cancel","type":"function","async":"callback","description":"Cancel a download. When <code>callback</code> is run, the download is cancelled, completed, interrupted or doesn\'t exist anymore.","parameters":[{"description":"The id of the download to cancel.","name":"downloadId","type":"integer"},{"name":"callback","optional":true,"parameters":[],"type":"function"}]},{"name":"getFileIcon","type":"function","async":"callback","description":"Retrieve an icon for the specified download. For new downloads, file icons are available after the <a href=\'#event-onCreated\'>onCreated</a> event has been received. The image returned by this function while a download is in progress may be different from the image returned after the download is complete. Icon retrieval is done by querying the underlying operating system or toolkit depending on the platform. The icon that is returned will therefore depend on a number of factors including state of the download, platform, registered file types and visual theme. If a file icon cannot be determined, <a href=\'extension.html#property-lastError\'>chrome.extension.lastError</a> will contain an error message.","parameters":[{"description":"The identifier for the download.","name":"downloadId","type":"integer"},{"name":"options","optional":true,"properties":{"size":{"description":"The size of the icon.  The returned icon will be square with dimensions size * size pixels.  The default size for the icon is 32x32 pixels.","minimum":1,"maximum":127,"type":"integer"}},"type":"object"},{"name":"callback","parameters":[{"name":"iconURL","optional":true,"type":"string"}],"type":"function"}]},{"name":"open","type":"function","async":"callback","requireUserInput":true,"description":"Open the downloaded file.","permissions":["downloads.open"],"parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"show","type":"function","description":"Show the downloaded file in its folder in a file manager.","async":"callback","parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[{"name":"success","type":"boolean"}]}]},{"name":"showDefaultFolder","type":"function","parameters":[]},{"name":"erase","type":"function","async":"callback","description":"Erase matching <a href=\'#type-DownloadItem\'>DownloadItems</a> from history","parameters":[{"allOf":[{"$ref":"#/types/DownloadQuery"},{"name":"query"}]},{"name":"callback","type":"function","optional":true,"parameters":[{"items":{"type":"integer"},"name":"erasedIds","type":"array"}]}]},{"name":"removeFile","async":"callback","type":"function","parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"description":"Prompt the user to either accept or cancel a dangerous download. <code>acceptDanger()</code> does not automatically accept dangerous downloads.","name":"acceptDanger","unsupported":true,"parameters":[{"name":"downloadId","type":"integer"},{"name":"callback","type":"function","optional":true,"parameters":[]}],"type":"function"},{"description":"Initiate dragging the file to another application.","name":"drag","unsupported":true,"parameters":[{"name":"downloadId","type":"integer"}],"type":"function"},{"name":"setShelfEnabled","type":"function","unsupported":true,"parameters":[{"name":"enabled","type":"boolean"}]}],"events":[{"description":"This event fires with the <a href=\'#type-DownloadItem\'>DownloadItem</a> object when a download begins.","name":"onCreated","parameters":[{"allOf":[{"$ref":"#/types/DownloadItem"},{"name":"downloadItem"}]}],"type":"function"},{"description":"Fires with the <code>downloadId</code> when a download is erased from history.","name":"onErased","parameters":[{"name":"downloadId","description":"The <code>id</code> of the <a href=\'#type-DownloadItem\'>DownloadItem</a> that was erased.","type":"integer"}],"type":"function"},{"name":"onChanged","description":"When any of a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s properties except <code>bytesReceived</code> changes, this event fires with the <code>downloadId</code> and an object containing the properties that changed.","parameters":[{"name":"downloadDelta","type":"object","properties":{"id":{"description":"The <code>id</code> of the <a href=\'#type-DownloadItem\'>DownloadItem</a> that changed.","type":"integer"},"url":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>url</code>."}]},"filename":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>filename</code>."}]},"danger":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>danger</code>."}]},"mime":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>mime</code>."}]},"startTime":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>startTime</code>."}]},"endTime":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>endTime</code>."}]},"state":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>state</code>."}]},"canResume":{"$ref":"#/types/BooleanDelta"},"paused":{"allOf":[{"$ref":"#/types/BooleanDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>paused</code>."}]},"error":{"allOf":[{"$ref":"#/types/StringDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>error</code>."}]},"totalBytes":{"allOf":[{"$ref":"#/types/DoubleDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>totalBytes</code>."}]},"fileSize":{"allOf":[{"$ref":"#/types/DoubleDelta"},{"description":"Describes a change in a <a href=\'#type-DownloadItem\'>DownloadItem</a>\'s <code>fileSize</code>."}]},"exists":{"$ref":"#/types/BooleanDelta"}},"required":["id"]}],"type":"function"}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["downloads","downloads.open"]}]}},"refs":{"downloads#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"FilenameConflictAction":{"type":"string","enum":["uniquify","overwrite","prompt"]},"InterruptReason":{"type":"string","enum":["FILE_FAILED","FILE_ACCESS_DENIED","FILE_NO_SPACE","FILE_NAME_TOO_LONG","FILE_TOO_LARGE","FILE_VIRUS_INFECTED","FILE_TRANSIENT_ERROR","FILE_BLOCKED","FILE_SECURITY_CHECK_FAILED","FILE_TOO_SHORT","NETWORK_FAILED","NETWORK_TIMEOUT","NETWORK_DISCONNECTED","NETWORK_SERVER_DOWN","NETWORK_INVALID_REQUEST","SERVER_FAILED","SERVER_NO_RANGE","SERVER_BAD_CONTENT","SERVER_UNAUTHORIZED","SERVER_CERT_PROBLEM","SERVER_FORBIDDEN","USER_CANCELED","USER_SHUTDOWN","CRASH"]},"DangerType":{"type":"string","enum":["file","url","content","uncommon","host","unwanted","safe","accepted"],"description":"<dl><dt>file</dt><dd>The download\'s filename is suspicious.</dd><dt>url</dt><dd>The download\'s URL is known to be malicious.</dd><dt>content</dt><dd>The downloaded file is known to be malicious.</dd><dt>uncommon</dt><dd>The download\'s URL is not commonly downloaded and could be dangerous.</dd><dt>safe</dt><dd>The download presents no known danger to the user\'s computer.</dd></dl>These string constants will never change, however the set of DangerTypes may change."},"State":{"type":"string","enum":["in_progress","interrupted","complete"],"description":"<dl><dt>in_progress</dt><dd>The download is currently receiving data from the server.</dd><dt>interrupted</dt><dd>An error broke the connection with the file host.</dd><dt>complete</dt><dd>The download completed successfully.</dd></dl>These string constants will never change, however the set of States may change."},"DownloadItem":{"type":"object","properties":{"id":{"description":"An identifier that is persistent across browser sessions.","type":"integer"},"url":{"description":"Absolute URL.","type":"string"},"referrer":{"type":"string"},"filename":{"description":"Absolute local path.","type":"string"},"incognito":{"description":"False if this download is recorded in the history, true if it is not recorded.","type":"boolean"},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"danger":{"allOf":[{"$ref":"#/types/DangerType"},{"description":"Indication of whether this download is thought to be safe or known to be suspicious."}]},"mime":{"description":"The file\'s MIME type.","type":"string"},"startTime":{"description":"Number of milliseconds between the unix epoch and when this download began.","type":"string"},"endTime":{"description":"Number of milliseconds between the unix epoch and when this download ended.","type":"string"},"estimatedEndTime":{"type":"string"},"state":{"allOf":[{"$ref":"#/types/State"},{"description":"Indicates whether the download is progressing, interrupted, or complete."}]},"paused":{"description":"True if the download has stopped reading data from the host, but kept the connection open.","type":"boolean"},"canResume":{"type":"boolean"},"error":{"allOf":[{"$ref":"#/types/InterruptReason"},{"description":"Number indicating why a download was interrupted."}]},"bytesReceived":{"description":"Number of bytes received so far from the host, without considering file compression.","type":"number"},"totalBytes":{"description":"Number of bytes in the whole file, without considering file compression, or -1 if unknown.","type":"number"},"fileSize":{"description":"Number of bytes in the whole file post-decompression, or -1 if unknown.","type":"number"},"exists":{"type":"boolean"},"byExtensionId":{"type":"string"},"byExtensionName":{"type":"string"}},"required":["id","url","filename","incognito","danger","startTime","state","paused","canResume","bytesReceived","totalBytes","fileSize","exists"]},"StringDelta":{"type":"object","properties":{"current":{"type":"string"},"previous":{"type":"string"}}},"DoubleDelta":{"type":"object","properties":{"current":{"type":"number"},"previous":{"type":"number"}}},"BooleanDelta":{"type":"object","properties":{"current":{"type":"boolean"},"previous":{"type":"boolean"}}},"DownloadTime":{"description":"A time specified as a Date object, a number or string representing milliseconds since the epoch, or an ISO 8601 string","anyOf":[{"type":"string","pattern":"^[1-9]\\\\d*$"},{"$ref":"extensionTypes#/types/Date"}]},"DownloadQuery":{"description":"Parameters that combine to specify a predicate that can be used to select a set of downloads.  Used for example in search() and erase()","type":"object","properties":{"query":{"description":"This array of search terms limits results to <a href=\'#type-DownloadItem\'>DownloadItems</a> whose <code>filename</code> or <code>url</code> contain all of the search terms that do not begin with a dash \'-\' and none of the search terms that do begin with a dash.","type":"array","items":{"type":"string"}},"startedBefore":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that started before the given ms since the epoch."}]},"startedAfter":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that started after the given ms since the epoch."}]},"endedBefore":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that ended before the given ms since the epoch."}]},"endedAfter":{"allOf":[{"$ref":"#/types/DownloadTime"},{"description":"Limits results to downloads that ended after the given ms since the epoch."}]},"totalBytesGreater":{"description":"Limits results to downloads whose totalBytes is greater than the given integer.","type":"number"},"totalBytesLess":{"description":"Limits results to downloads whose totalBytes is less than the given integer.","type":"number"},"filenameRegex":{"description":"Limits results to <a href=\'#type-DownloadItem\'>DownloadItems</a> whose <code>filename</code> matches the given regular expression.","type":"string"},"urlRegex":{"description":"Limits results to <a href=\'#type-DownloadItem\'>DownloadItems</a> whose <code>url</code> matches the given regular expression.","type":"string"},"limit":{"description":"Setting this integer limits the number of results. Otherwise, all matching <a href=\'#type-DownloadItem\'>DownloadItems</a> will be returned.","type":"integer"},"orderBy":{"description":"Setting elements of this array to <a href=\'#type-DownloadItem\'>DownloadItem</a> properties in order to sort the search results. For example, setting <code>orderBy=\'startTime\'</code> sorts the <a href=\'#type-DownloadItem\'>DownloadItems</a> by their start time in ascending order. To specify descending order, prefix <code>orderBy</code> with a hyphen: \'-startTime\'.","type":"array","items":{"type":"string"}},"id":{"type":"integer"},"url":{"description":"Absolute URL.","type":"string"},"filename":{"description":"Absolute local path.","type":"string"},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"danger":{"allOf":[{"$ref":"#/types/DangerType"},{"description":"Indication of whether this download is thought to be safe or known to be suspicious."}]},"mime":{"description":"The file\'s MIME type.","type":"string"},"startTime":{"type":"string"},"endTime":{"type":"string"},"state":{"allOf":[{"$ref":"#/types/State"},{"description":"Indicates whether the download is progressing, interrupted, or complete."}]},"paused":{"description":"True if the download has stopped reading data from the host, but kept the connection open.","type":"boolean"},"error":{"allOf":[{"$ref":"#/types/InterruptReason"},{"description":"Why a download was interrupted."}]},"bytesReceived":{"description":"Number of bytes received so far from the host, without considering file compression.","type":"number"},"totalBytes":{"description":"Number of bytes in the whole file, without considering file compression, or -1 if unknown.","type":"number"},"fileSize":{"description":"Number of bytes in the whole file post-decompression, or -1 if unknown.","type":"number"},"exists":{"type":"boolean"}}}}}');

/***/ }),
/* 69 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"events","description":"The <code>chrome.events</code> namespace contains common types used by APIs dispatching events to notify you when something interesting happens.","definitions":{},"refs":{},"types":{"Rule":{"type":"object","description":"Description of a declarative rule for handling events.","properties":{"id":{"type":"string","description":"Optional identifier that allows referencing this rule."},"tags":{"type":"array","items":{"type":"string"},"description":"Tags can be used to annotate rules and perform operations on sets of rules."},"conditions":{"type":"array","items":{},"description":"List of conditions that can trigger the actions."},"actions":{"type":"array","items":{},"description":"List of actions that are triggered if one of the condtions is fulfilled."},"priority":{"type":"integer","description":"Optional priority of this rule. Defaults to 100."}},"required":["conditions","actions"]},"Event":{"type":"object","description":"An object which allows the addition and removal of listeners for a Chrome event.","functions":[{"name":"addListener","type":"function","description":"Registers an event listener <em>callback</em> to an event.","parameters":[{"name":"callback","type":"function","description":"Called when an event occurs. The parameters of this function depend on the type of event."}]},{"name":"removeListener","type":"function","description":"Deregisters an event listener <em>callback</em> from an event.","parameters":[{"name":"callback","type":"function","description":"Listener that shall be unregistered."}]},{"name":"hasListener","type":"function","parameters":[{"name":"callback","type":"function","description":"Listener whose registration status shall be tested."}],"returns":{"type":"boolean","description":"True if <em>callback</em> is registered to the event."}},{"name":"hasListeners","type":"function","parameters":[],"returns":{"type":"boolean","description":"True if any event listeners are registered to the event."}},{"name":"addRules","unsupported":true,"type":"function","description":"Registers rules to handle events.","parameters":[{"name":"eventName","type":"string","description":"Name of the event this function affects."},{"name":"webViewInstanceId","type":"integer","description":"If provided, this is an integer that uniquely identfies the <webview> associated with this function call."},{"name":"rules","type":"array","items":{"$ref":"#/types/Rule"},"description":"Rules to be registered. These do not replace previously registered rules."},{"name":"callback","optional":true,"type":"function","parameters":[{"name":"rules","type":"array","items":{"$ref":"#/types/Rule"},"description":"Rules that were registered, the optional parameters are filled with values."}],"description":"Called with registered rules."}]},{"name":"getRules","unsupported":true,"type":"function","description":"Returns currently registered rules.","parameters":[{"name":"eventName","type":"string","description":"Name of the event this function affects."},{"name":"webViewInstanceId","type":"integer","description":"If provided, this is an integer that uniquely identfies the <webview> associated with this function call."},{"name":"ruleIdentifiers","optional":true,"type":"array","items":{"type":"string"},"description":"If an array is passed, only rules with identifiers contained in this array are returned."},{"name":"callback","type":"function","parameters":[{"name":"rules","type":"array","items":{"$ref":"#/types/Rule"},"description":"Rules that were registered, the optional parameters are filled with values."}],"description":"Called with registered rules."}]},{"name":"removeRules","unsupported":true,"type":"function","description":"Unregisters currently registered rules.","parameters":[{"name":"eventName","type":"string","description":"Name of the event this function affects."},{"name":"webViewInstanceId","type":"integer","description":"If provided, this is an integer that uniquely identfies the <webview> associated with this function call."},{"name":"ruleIdentifiers","optional":true,"type":"array","items":{"type":"string"},"description":"If an array is passed, only rules with identifiers contained in this array are unregistered."},{"name":"callback","optional":true,"type":"function","parameters":[],"description":"Called when rules were unregistered."}]}]},"UrlFilter":{"type":"object","description":"Filters URLs for various criteria. See <a href=\'events#filtered\'>event filtering</a>. All criteria are case sensitive.","properties":{"hostContains":{"type":"string","description":"Matches if the host name of the URL contains a specified string. To test whether a host name component has a prefix \'foo\', use hostContains: \'.foo\'. This matches \'www.foobar.com\' and \'foo.com\', because an implicit dot is added at the beginning of the host name. Similarly, hostContains can be used to match against component suffix (\'foo.\') and to exactly match against components (\'.foo.\'). Suffix- and exact-matching for the last components need to be done separately using hostSuffix, because no implicit dot is added at the end of the host name."},"hostEquals":{"type":"string","description":"Matches if the host name of the URL is equal to a specified string."},"hostPrefix":{"type":"string","description":"Matches if the host name of the URL starts with a specified string."},"hostSuffix":{"type":"string","description":"Matches if the host name of the URL ends with a specified string."},"pathContains":{"type":"string","description":"Matches if the path segment of the URL contains a specified string."},"pathEquals":{"type":"string","description":"Matches if the path segment of the URL is equal to a specified string."},"pathPrefix":{"type":"string","description":"Matches if the path segment of the URL starts with a specified string."},"pathSuffix":{"type":"string","description":"Matches if the path segment of the URL ends with a specified string."},"queryContains":{"type":"string","description":"Matches if the query segment of the URL contains a specified string."},"queryEquals":{"type":"string","description":"Matches if the query segment of the URL is equal to a specified string."},"queryPrefix":{"type":"string","description":"Matches if the query segment of the URL starts with a specified string."},"querySuffix":{"type":"string","description":"Matches if the query segment of the URL ends with a specified string."},"urlContains":{"type":"string","description":"Matches if the URL (without fragment identifier) contains a specified string. Port numbers are stripped from the URL if they match the default port number."},"urlEquals":{"type":"string","description":"Matches if the URL (without fragment identifier) is equal to a specified string. Port numbers are stripped from the URL if they match the default port number."},"urlMatches":{"type":"string","description":"Matches if the URL (without fragment identifier) matches a specified regular expression. Port numbers are stripped from the URL if they match the default port number. The regular expressions use the <a href=\\"https://github.com/google/re2/blob/master/doc/syntax.txt\\">RE2 syntax</a>."},"originAndPathMatches":{"type":"string","description":"Matches if the URL without query segment and fragment identifier matches a specified regular expression. Port numbers are stripped from the URL if they match the default port number. The regular expressions use the <a href=\\"https://github.com/google/re2/blob/master/doc/syntax.txt\\">RE2 syntax</a>."},"urlPrefix":{"type":"string","description":"Matches if the URL (without fragment identifier) starts with a specified string. Port numbers are stripped from the URL if they match the default port number."},"urlSuffix":{"type":"string","description":"Matches if the URL (without fragment identifier) ends with a specified string. Port numbers are stripped from the URL if they match the default port number."},"schemes":{"type":"array","description":"Matches if the scheme of the URL is equal to any of the schemes specified in the array.","items":{"type":"string"}},"ports":{"type":"array","description":"Matches if the port of the URL is contained in any of the specified port lists. For example <code>[80, 443, [1000, 1200]]</code> matches all requests on port 80, 443 and in the range 1000-1200.","items":{"anyOf":[{"type":"integer","description":"A specific port."},{"type":"array","minItems":2,"maxItems":2,"items":{"type":"integer"},"description":"A pair of integers identiying the start and end (both inclusive) of a port range."}]}}}}}}');

/***/ }),
/* 70 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"experiments","definitions":{"Permission":{"anyOf":[{"type":"string","pattern":"^experiments(\\\\.\\\\w+)+$"}]},"WebExtensionManifest":{"properties":{"experiment_apis":{"type":"object","additionalProperties":{"$ref":"experiments#/types/ExperimentAPI"},"privileged":true,"minProperties":1}}}},"refs":{"experiments#/definitions/Permission":{"namespace":"manifest","type":"Permission"},"experiments#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ExperimentAPI":{"type":"object","properties":{"schema":{"$ref":"#/types/ExperimentURL"},"parent":{"type":"object","properties":{"events":{"allOf":[{"$ref":"#/types/APIEvents"},{"default":[]}]},"paths":{"allOf":[{"$ref":"#/types/APIPaths"},{"default":[]}]},"script":{"$ref":"#/types/ExperimentURL"},"scopes":{"type":"array","items":{"allOf":[{"$ref":"#/types/APIParentScope"},{"onError":"warn"}]},"default":[]}},"required":["script"]},"child":{"type":"object","properties":{"paths":{"$ref":"#/types/APIPaths"},"script":{"$ref":"#/types/ExperimentURL"},"scopes":{"type":"array","minItems":1,"items":{"allOf":[{"$ref":"#/types/APIChildScope"},{"onError":"warn"}]}}},"required":["paths","script","scopes"]}},"required":["schema"]},"ExperimentURL":{"type":"string","format":"unresolvedRelativeUrl"},"APIPaths":{"type":"array","items":{"$ref":"#/types/APIPath"},"minItems":1},"APIPath":{"type":"array","items":{"type":"string"},"minItems":1},"APIEvents":{"type":"array","items":{"allOf":[{"$ref":"#/types/APIEvent"},{"onError":"warn"}]}},"APIEvent":{"type":"string","enum":["startup"]},"APIParentScope":{"type":"string","enum":["addon_parent","content_parent","devtools_parent"]},"APIChildScope":{"type":"string","enum":["addon_child","content_child","devtools_child"]}}}');

/***/ }),
/* 71 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"extension","allowedContexts":["content","devtools"],"description":"The <code>browser.extension</code> API has utilities that can be used by any extension page. It includes support for exchanging messages between an extension and its content scripts or between extensions, as described in detail in $(topic:messaging)[Message Passing].","properties":{"lastError":{"type":"object","optional":true,"max_manifest_version":2,"deprecated":"Please use $(ref:runtime.lastError).","allowedContexts":["content","devtools"],"description":"Set for the lifetime of a callback if an ansychronous extension api has resulted in an error. If no error has occured lastError will be <var>undefined</var>.","properties":{"message":{"type":"string","description":"Description of the error that has taken place."}},"additionalProperties":{},"required":["message"]},"inIncognitoContext":{"type":"boolean","optional":true,"allowedContexts":["content","devtools"],"description":"True for content scripts running inside incognito tabs, and for extension pages running inside an incognito process. The latter only applies to extensions with \'split\' incognito_behavior."}},"functions":[{"name":"getURL","type":"function","deprecated":"Please use $(ref:runtime.getURL).","max_manifest_version":2,"allowedContexts":["content","devtools"],"description":"Converts a relative path within an extension install directory to a fully-qualified URL.","parameters":[{"type":"string","name":"path","description":"A path to a resource within an extension expressed relative to its install directory."}],"returns":{"type":"string","description":"The fully-qualified URL to the resource."}},{"name":"getViews","type":"function","description":"Returns an array of the JavaScript \'window\' objects for each of the pages running inside the current extension.","parameters":[{"type":"object","name":"fetchProperties","optional":true,"properties":{"type":{"allOf":[{"$ref":"#/types/ViewType"},{"description":"The type of view to get. If omitted, returns all views (including background pages and tabs). Valid values: \'tab\', \'popup\', \'sidebar\'."}]},"windowId":{"type":"integer","description":"The window to restrict the search to. If omitted, returns all views."},"tabId":{"type":"integer","description":"Find a view according to a tab id. If this field is omitted, returns all views."}}}],"returns":{"type":"array","description":"Array of global objects","items":{"type":"object","isInstanceOf":"Window","additionalProperties":{}}}},{"name":"getBackgroundPage","type":"function","description":"Returns the JavaScript \'window\' object for the background page running inside the current extension. Returns null if the extension has no background page.","parameters":[],"returns":{"type":"object","optional":true,"isInstanceOf":"Window","additionalProperties":{}}},{"name":"isAllowedIncognitoAccess","type":"function","description":"Retrieves the state of the extension\'s access to Incognito-mode (as determined by the user-controlled \'Allowed in Incognito\' checkbox.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"isAllowedAccess","type":"boolean","description":"True if the extension has access to Incognito mode, false otherwise."}]}]},{"name":"isAllowedFileSchemeAccess","type":"function","description":"Retrieves the state of the extension\'s access to the \'file://\' scheme (as determined by the user-controlled \'Allow access to File URLs\' checkbox.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"isAllowedAccess","type":"boolean","description":"True if the extension can access the \'file://\' scheme, false otherwise."}]}]},{"name":"setUpdateUrlData","unsupported":true,"type":"function","description":"Sets the value of the ap CGI parameter used in the extension\'s update URL.  This value is ignored for extensions that are hosted in the browser vendor\'s store.","parameters":[{"type":"string","name":"data","maxLength":1024}]}],"events":[{"name":"onRequest","unsupported":true,"deprecated":"Please use $(ref:runtime.onMessage).","type":"function","description":"Fired when a request is sent from either an extension process or a content script.","parameters":[{"name":"request","optional":true,"description":"The request sent by the calling script."},{"allOf":[{"$ref":"runtime#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object, or undefined if there is no response. If you have more than one <code>onRequest</code> listener in the same document, then only one may send a response."}]},{"name":"onRequestExternal","unsupported":true,"deprecated":"Please use $(ref:runtime.onMessageExternal).","type":"function","description":"Fired when a request is sent from another extension.","parameters":[{"name":"request","optional":true,"description":"The request sent by the calling script."},{"allOf":[{"$ref":"runtime#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call when you have a response. The argument should be any JSON-ifiable object, or undefined if there is no response."}]}],"definitions":{},"refs":{},"types":{"ViewType":{"type":"string","enum":["tab","popup","sidebar"],"description":"The type of extension view."}}}');

/***/ }),
/* 72 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"extension_protocol_handlers","definitions":{"WebExtensionManifest":{"properties":{"protocol_handlers":{"description":"A list of protocol handler definitions.","type":"array","items":{"$ref":"#/types/ProtocolHandler"}}}}},"refs":{"extension_protocol_handlers#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ProtocolHandler":{"type":"object","description":"Represents a protocol handler definition.","properties":{"name":{"description":"A user-readable title string for the protocol handler. This will be displayed to the user in interface objects as needed.","type":"string"},"protocol":{"description":"The protocol the site wishes to handle, specified as a string. For example, you can register to handle SMS text message links by registering to handle the \\"sms\\" scheme.","anyOf":[{"type":"string","enum":["bitcoin","dat","dweb","ftp","geo","gopher","im","ipfs","ipns","irc","ircs","magnet","mailto","matrix","mms","news","nntp","sip","sms","smsto","ssb","ssh","tel","urn","webcal","wtai","xmpp"]},{"type":"string","pattern":"^(ext|web)\\\\+[a-z0-9.+-]+$"}]},"uriTemplate":{"description":"The URL of the handler, as a string. This string should include \\"%s\\" as a placeholder which will be replaced with the escaped URL of the document to be handled. This URL might be a true URL, or it could be a phone number, email address, or so forth.","preprocess":"localize","anyOf":[{"$ref":"manifest#/types/ExtensionURL"},{"$ref":"manifest#/types/HttpURL"}]}},"required":["name","protocol","uriTemplate"]}}}');

/***/ }),
/* 73 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"extensionTypes","description":"The <code>browser.extensionTypes</code> API contains type declarations for WebExtensions.","definitions":{},"refs":{},"types":{"ImageFormat":{"type":"string","enum":["jpeg","png"],"description":"The format of an image."},"ImageDetails":{"type":"object","description":"Details about the format, quality, area and scale of the capture.","properties":{"format":{"allOf":[{"$ref":"#/types/ImageFormat"},{"description":"The format of the resulting image.  Default is <code>\\"jpeg\\"</code>."}]},"quality":{"type":"integer","minimum":0,"maximum":100,"description":"When format is <code>\\"jpeg\\"</code>, controls the quality of the resulting image.  This value is ignored for PNG images.  As quality is decreased, the resulting image will have more visual artifacts, and the number of bytes needed to store it will decrease."},"rect":{"type":"object","description":"The area of the document to capture, in CSS pixels, relative to the page.  If omitted, capture the visible viewport.","properties":{"x":{"type":"number"},"y":{"type":"number"},"width":{"type":"number"},"height":{"type":"number"}},"required":["x","y","width","height"]},"scale":{"type":"number","description":"The scale of the resulting image.  Defaults to <code>devicePixelRatio</code>."},"resetScrollPosition":{"type":"boolean","description":"If true, temporarily resets the scroll position of the document to 0. Only takes effect if rect is also specified."}}},"RunAt":{"type":"string","enum":["document_start","document_end","document_idle"],"description":"The soonest that the JavaScript or CSS will be injected into the tab."},"ExecutionWorld":{"type":"string","enum":["ISOLATED","MAIN"],"description":"The JavaScript world for a script to execute within. <code>ISOLATED</code> is the default execution environment of content scripts, <code>MAIN</code> is the web page\'s execution environment."},"CSSOrigin":{"type":"string","enum":["user","author"],"description":"The origin of the CSS to inject, this affects the cascading order (priority) of the stylesheet."},"InjectDetails":{"type":"object","description":"Details of the script or CSS to inject. Either the code or the file property must be set, but both may not be set at the same time.","properties":{"code":{"type":"string","description":"JavaScript or CSS code to inject.<br><br><b>Warning:</b><br>Be careful using the <code>code</code> parameter. Incorrect use of it may open your extension to <a href=\\"https://en.wikipedia.org/wiki/Cross-site_scripting\\">cross site scripting</a> attacks."},"file":{"type":"string","description":"JavaScript or CSS file to inject."},"allFrames":{"type":"boolean","description":"If allFrames is <code>true</code>, implies that the JavaScript or CSS should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"matchAboutBlank":{"type":"boolean","description":"If matchAboutBlank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Code cannot be inserted in top-level about:-frames. By default it is <code>false</code>."},"frameId":{"type":"integer","minimum":0,"description":"The ID of the frame to inject the script into. This may not be used in combination with <code>allFrames</code>."},"runAt":{"allOf":[{"$ref":"#/types/RunAt"},{"default":"document_idle","description":"The soonest that the JavaScript or CSS will be injected into the tab. Defaults to \\"document_idle\\"."}]},"cssOrigin":{"allOf":[{"$ref":"#/types/CSSOrigin"},{"description":"The css origin of the stylesheet to inject. Defaults to \\"author\\"."}]}}},"Date":{"anyOf":[{"type":"string","format":"date"},{"type":"integer","minimum":0},{"type":"object","isInstanceOf":"Date","additionalProperties":{}}]},"ExtensionFileOrCode":{"anyOf":[{"type":"object","properties":{"file":{"$ref":"manifest#/types/ExtensionURL"}},"required":["file"]},{"type":"object","properties":{"code":{"type":"string"}},"required":["code"]}]},"PlainJSONValue":{"description":"A plain JSON value","anyOf":[{"type":"null"},{"type":"number"},{"type":"string"},{"type":"boolean"},{"type":"array","items":{"$ref":"#/types/PlainJSONValue"}},{"type":"object","additionalProperties":{"$ref":"#/types/PlainJSONValue"}}]}}}');

/***/ }),
/* 74 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"find","description":"Use the <code>browser.find</code> API to interact with the browser\'s <code>Find</code> interface.","permissions":["find"],"functions":[{"name":"find","type":"function","async":true,"description":"Search for text in document and store found ranges in array, in document order.","parameters":[{"name":"queryphrase","type":"string","description":"The string to search for."},{"name":"params","type":"object","description":"Search parameters.","optional":true,"properties":{"tabId":{"type":"integer","description":"Tab to query. Defaults to the active tab.","minimum":0},"caseSensitive":{"type":"boolean","description":"Find only ranges with case sensitive match."},"matchDiacritics":{"type":"boolean","description":"Find only ranges with diacritic sensitive match."},"entireWord":{"type":"boolean","description":"Find only ranges that match entire word."},"includeRectData":{"description":"Return rectangle data which describes visual position of search results.","type":"boolean"},"includeRangeData":{"description":"Return range data which provides range data in a serializable form.","type":"boolean"}}}]},{"name":"highlightResults","type":"function","async":true,"description":"Highlight a range","parameters":[{"name":"params","type":"object","description":"highlightResults parameters","optional":true,"properties":{"rangeIndex":{"type":"integer","description":"Found range to be highlighted. Default highlights all ranges.","minimum":0},"tabId":{"type":"integer","description":"Tab to highlight. Defaults to the active tab.","minimum":0},"noScroll":{"type":"boolean","description":"Don\'t scroll to highlighted item."}}}]},{"name":"removeHighlighting","type":"function","async":true,"description":"Remove all highlighting from previous searches.","parameters":[{"name":"tabId","type":"integer","description":"Tab to highlight. Defaults to the active tab.","optional":true}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["find"]}]}},"refs":{"find#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{}}');

/***/ }),
/* 75 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"geckoProfiler","description":"Exposes the browser\'s profiler.","permissions":["geckoProfiler"],"functions":[{"name":"start","type":"function","description":"Starts the profiler with the specified settings.","async":true,"parameters":[{"name":"settings","type":"object","properties":{"bufferSize":{"type":"integer","minimum":0,"description":"The maximum size in bytes of the buffer used to store profiling data. A larger value allows capturing a profile that covers a greater amount of time."},"windowLength":{"type":"number","description":"The length of the window of time that\'s kept in the buffer. Any collected samples are discarded as soon as they are older than the number of seconds specified in this setting. Zero means no duration restriction."},"interval":{"type":"number","description":"Interval in milliseconds between samples of profiling data. A smaller value will increase the detail of the profiles captured."},"features":{"type":"array","description":"A list of active features for the profiler.","items":{"$ref":"#/types/ProfilerFeature"}},"threads":{"type":"array","description":"A list of thread names for which to capture profiles.","items":{"type":"string"}}},"required":["bufferSize","interval","features"]}]},{"name":"stop","type":"function","description":"Stops the profiler and discards any captured profile data.","async":true,"parameters":[]},{"name":"pause","type":"function","description":"Pauses the profiler, keeping any profile data that is already written.","async":true,"parameters":[]},{"name":"resume","type":"function","description":"Resumes the profiler with the settings that were initially used to start it.","async":true,"parameters":[]},{"name":"dumpProfileToFile","type":"function","description":"Gathers the profile data from the current profiling session, and writes it to disk. The returned promise resolves to a path that locates the created file.","async":true,"parameters":[{"type":"string","name":"fileName","description":"The name of the file inside the profile/profiler directory"}]},{"name":"getProfile","type":"function","description":"Gathers the profile data from the current profiling session.","async":true,"parameters":[]},{"name":"getProfileAsArrayBuffer","type":"function","description":"Gathers the profile data from the current profiling session. The returned promise resolves to an array buffer that contains a JSON string.","async":true,"parameters":[]},{"name":"getProfileAsGzippedArrayBuffer","type":"function","description":"Gathers the profile data from the current profiling session. The returned promise resolves to an array buffer that contains a gzipped JSON string.","async":true,"parameters":[]},{"name":"getSymbols","type":"function","description":"Gets the debug symbols for a particular library.","async":true,"parameters":[{"type":"string","name":"debugName","description":"The name of the library\'s debug file. For example, \'xul.pdb"},{"type":"string","name":"breakpadId","description":"The Breakpad ID of the library"}]}],"events":[{"name":"onRunning","type":"function","description":"Fires when the profiler starts/stops running.","parameters":[{"name":"isRunning","type":"boolean","description":"Whether the profiler is running or not. Pausing the profiler will not affect this value."}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["geckoProfiler"]}]}},"refs":{"geckoProfiler#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"ProfilerFeature":{"type":"string","enum":["java","js","mainthreadio","fileio","fileioall","nomarkerstacks","screenshots","seqstyle","stackwalk","jsallocations","nostacksampling","nativeallocations","ipcmessages","audiocallbacktracing","cpu","notimerresolutionchange","cpuallthreads","samplingallthreads","markersallthreads","unregisteredthreads","processcpu","power","responsiveness","cpufreq","bandwidth","memory","tracing","sandbox","flows"]},"supports":{"type":"string","enum":["windowLength"]}}}');

/***/ }),
/* 76 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"history","description":"Use the <code>browser.history</code> API to interact with the browser\'s record of visited pages. You can add, remove, and query for URLs in the browser\'s history. To override the history page with your own version, see $(topic:override)[Override Pages].","permissions":["history"],"functions":[{"name":"search","type":"function","description":"Searches the history for the last visit time of each page matching the query.","async":"callback","parameters":[{"name":"query","type":"object","properties":{"text":{"type":"string","description":"A free-text query to the history service.  Leave empty to retrieve all pages."},"startTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Limit results to those visited after this date. If not specified, this defaults to 24 hours in the past."}]},"endTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Limit results to those visited before this date."}]},"maxResults":{"type":"integer","minimum":1,"description":"The maximum number of results to retrieve.  Defaults to 100."}},"required":["text"]},{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/HistoryItem"}}]}]},{"name":"getVisits","type":"function","description":"Retrieves information about visits to a URL.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"type":"string","description":"The URL for which to retrieve visit information.  It must be in the format as returned from a call to history.search."}},"required":["url"]},{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/VisitItem"}}]}]},{"name":"addUrl","type":"function","description":"Adds a URL to the history with a default visitTime of the current time and a default $(topic:transition-types)[transition type] of \\"link\\".","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"type":"string","description":"The URL to add. Must be a valid URL that can be added to history."},"title":{"type":"string","description":"The title of the page."},"transition":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"The $(topic:transition-types)[transition type] for this visit from its referrer."}]},"visitTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The date when this visit occurred."}]}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"deleteUrl","type":"function","description":"Removes all occurrences of the given URL from the history.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"type":"string","description":"The URL to remove."}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"deleteRange","type":"function","description":"Removes all items within the specified date range from the history.  Pages will not be removed from the history unless all visits fall within the range.","async":"callback","parameters":[{"name":"range","type":"object","properties":{"startTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Items added to history after this date."}]},"endTime":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"Items added to history before this date."}]}},"required":["startTime","endTime"]},{"name":"callback","type":"function","parameters":[]}]},{"name":"deleteAll","type":"function","description":"Deletes all items from the history.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[]}]}],"events":[{"name":"onVisited","type":"function","description":"Fired when a URL is visited, providing the HistoryItem data for that URL.  This event fires before the page has loaded.","parameters":[{"allOf":[{"$ref":"#/types/HistoryItem"},{"name":"result"}]}]},{"name":"onVisitRemoved","type":"function","description":"Fired when one or more URLs are removed from the history service.  When all visits have been removed the URL is purged from history.","parameters":[{"name":"removed","type":"object","properties":{"allHistory":{"type":"boolean","description":"True if all history was removed.  If true, then urls will be empty."},"urls":{"type":"array","items":{"type":"string"}}},"required":["allHistory","urls"]}]},{"name":"onTitleChanged","type":"function","description":"Fired when the title of a URL is changed in the browser history.","parameters":[{"name":"changed","type":"object","properties":{"url":{"type":"string","description":"The URL for which the title has changed"},"title":{"type":"string","description":"The new title for the URL."}},"required":["url","title"]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["history"]}]}},"refs":{"history#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"TransitionType":{"type":"string","enum":["link","typed","auto_bookmark","auto_subframe","manual_subframe","generated","auto_toplevel","form_submit","reload","keyword","keyword_generated"],"description":"The $(topic:transition-types)[transition type] for this visit from its referrer."},"HistoryItem":{"type":"object","description":"An object encapsulating one result of a history query.","properties":{"id":{"type":"string","description":"The unique identifier for the item."},"url":{"type":"string","description":"The URL navigated to by a user."},"title":{"type":"string","description":"The title of the page when it was last loaded."},"lastVisitTime":{"type":"number","description":"When this page was last loaded, represented in milliseconds since the epoch."},"visitCount":{"type":"integer","description":"The number of times the user has navigated to this page."},"typedCount":{"type":"integer","description":"The number of times the user has navigated to this page by typing in the address."}},"required":["id"]},"VisitItem":{"type":"object","description":"An object encapsulating one visit to a URL.","properties":{"id":{"type":"string","description":"The unique identifier for the item."},"visitId":{"type":"string","description":"The unique identifier for this visit."},"visitTime":{"type":"number","description":"When this visit occurred, represented in milliseconds since the epoch."},"referringVisitId":{"type":"string","description":"The visit ID of the referrer."},"transition":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"The $(topic:transition-types)[transition type] for this visit from its referrer."}]}},"required":["id","visitId","referringVisitId","transition"]}}}');

/***/ }),
/* 77 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"i18n","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"description":"Use the <code>browser.i18n</code> infrastructure to implement internationalization across your whole app or extension.","functions":[{"name":"getAcceptLanguages","type":"function","description":"Gets the accept-languages of the browser. This is different from the locale used by the browser; to get the locale, use $(ref:i18n.getUILanguage).","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"languages","type":"array","items":{"$ref":"#/types/LanguageCode"},"description":"Array of LanguageCode"}]}]},{"name":"getMessage","type":"function","description":"Gets the localized string for the specified message. If the message is missing, this method returns an empty string (\'\'). If the format of the <code>getMessage()</code> call is wrong &mdash; for example, <em>messageName</em> is not a string or the <em>substitutions</em> array has more than 9 elements &mdash; this method returns <code>undefined</code>.","parameters":[{"type":"string","name":"messageName","description":"The name of the message, as specified in the <code>$(topic:i18n-messages)[messages.json]</code> file."},{"name":"substitutions","optional":true,"description":"Substitution strings, if the message requires any."}],"returns":{"type":"string","description":"Message localized for current locale."}},{"name":"getUILanguage","type":"function","description":"Gets the browser UI language of the browser. This is different from $(ref:i18n.getAcceptLanguages) which returns the preferred user languages.","parameters":[],"returns":{"type":"string","description":"The browser UI language code such as en-US or fr-FR."}},{"name":"detectLanguage","type":"function","description":"Detects the language of the provided text using CLD.","async":"callback","parameters":[{"type":"string","name":"text","description":"User input string to be translated."},{"type":"function","name":"callback","parameters":[{"type":"object","name":"result","description":"LanguageDetectionResult object that holds detected langugae reliability and array of DetectedLanguage","properties":{"isReliable":{"type":"boolean","description":"CLD detected language reliability"},"languages":{"type":"array","description":"array of detectedLanguage","items":{"type":"object","description":"DetectedLanguage object that holds detected ISO language code and its percentage in the input string","properties":{"language":{"$ref":"#/types/LanguageCode"},"percentage":{"type":"integer","description":"The percentage of the detected language"}},"required":["language","percentage"]}}},"required":["isReliable","languages"]}]}]}],"events":[],"definitions":{"WebExtensionManifest":{"properties":{"default_locale":{"type":"string"},"l10n_resources":{"type":"array","items":{"type":"string"},"privileged":true}}}},"refs":{"i18n#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"LanguageCode":{"type":"string","description":"An ISO language code such as <code>en</code> or <code>fr</code>. For a complete list of languages supported by this method, see <a href=\'http://src.chromium.org/viewvc/chrome/trunk/src/third_party/cld/languages/internal/languages.cc\'>kLanguageInfoTable</a>. For an unknown language, <code>und</code> will be returned, which means that [percentage] of the text is unknown to CLD"}}}');

/***/ }),
/* 78 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"identity","description":"Use the chrome.identity API to get OAuth2 access tokens. ","permissions":["identity"],"functions":[{"name":"getAccounts","type":"function","unsupported":true,"description":"Retrieves a list of AccountInfo objects describing the accounts present on the profile.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/AccountInfo"}}]}]},{"name":"getAuthToken","type":"function","unsupported":true,"description":"Gets an OAuth2 access token using the client ID and scopes specified in the oauth2 section of manifest.json.","async":"callback","parameters":[{"name":"details","optional":true,"type":"object","properties":{"interactive":{"type":"boolean"},"account":{"$ref":"#/types/AccountInfo"},"scopes":{"type":"array","items":{"type":"string"}}}},{"name":"callback","optional":true,"type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/AccountInfo"}}]}]},{"name":"getProfileUserInfo","type":"function","unsupported":true,"description":"Retrieves email address and obfuscated gaia id of the user signed into a profile.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"userinfo","type":"object","properties":{"email":{"type":"string"},"id":{"type":"string"}},"required":["email","id"]}]}]},{"name":"removeCachedAuthToken","type":"function","unsupported":true,"description":"Removes an OAuth2 access token from the Identity API\'s token cache.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"token":{"type":"string"}},"required":["token"]},{"name":"callback","optional":true,"type":"function","parameters":[{"name":"userinfo","type":"object","properties":{"email":{"type":"string"},"id":{"type":"string"}},"required":["email","id"]}]}]},{"name":"launchWebAuthFlow","type":"function","description":"Starts an auth flow at the specified URL.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"url":{"$ref":"manifest#/types/HttpURL"},"interactive":{"type":"boolean"}},"required":["url"]},{"name":"callback","type":"function","parameters":[{"name":" responseUrl","type":"string","optional":true}]}]},{"name":"getRedirectURL","type":"function","description":"Generates a redirect URL to be used in |launchWebAuthFlow|.","parameters":[{"name":"path","type":"string","default":"","optional":true,"description":"The path appended to the end of the generated URL. "}],"returns":{"type":"string"}}],"events":[{"name":"onSignInChanged","unsupported":true,"type":"function","description":"Fired when signin state changes for an account on the user\'s profile.","parameters":[{"allOf":[{"$ref":"#/types/AccountInfo"},{"name":"account"}]},{"name":"signedIn","type":"boolean"}]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["identity"]}]}},"refs":{"identity#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"}},"types":{"AccountInfo":{"type":"object","description":"An object encapsulating an OAuth account id.","properties":{"id":{"type":"string","description":"A unique identifier for the account. This ID will not change for the lifetime of the account. "}},"required":["id"]}}}');

/***/ }),
/* 79 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"idle","description":"Use the <code>browser.idle</code> API to detect when the machine\'s idle state changes.","permissions":["idle"],"functions":[{"name":"queryState","type":"function","description":"Returns \\"idle\\" if the user has not generated any input for a specified number of seconds, or \\"active\\" otherwise.","async":"callback","parameters":[{"name":"detectionIntervalInSeconds","type":"integer","minimum":15,"description":"The system is considered idle if detectionIntervalInSeconds seconds have elapsed since the last user input detected."},{"name":"callback","type":"function","parameters":[{"allOf":[{"$ref":"#/types/IdleState"},{"name":"newState"}]}]}]},{"name":"setDetectionInterval","type":"function","description":"Sets the interval, in seconds, used to determine when the system is in an idle state for onStateChanged events. The default interval is 60 seconds.","parameters":[{"name":"intervalInSeconds","type":"integer","minimum":15,"description":"Threshold, in seconds, used to determine when the system is in an idle state."}]}],"events":[{"name":"onStateChanged","type":"function","description":"Fired when the system changes to an active or idle state. The event fires with \\"idle\\" if the the user has not generated any input for a specified number of seconds, and \\"active\\" when the user generates input on an idle system.","parameters":[{"allOf":[{"$ref":"#/types/IdleState"},{"name":"newState"}]}]}],"definitions":{},"refs":{},"types":{"IdleState":{"type":"string","enum":["active","idle"]}}}');

/***/ }),
/* 80 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"management","description":"The <code>browser.management</code> API provides ways to manage the list of extensions that are installed and running.","functions":[{"name":"getAll","type":"function","permissions":["management"],"description":"Returns a list of information about installed extensions.","async":"callback","parameters":[{"name":"callback","type":"function","optional":true,"parameters":[{"type":"array","name":"result","items":{"$ref":"#/types/ExtensionInfo"}}]}]},{"name":"get","type":"function","permissions":["management"],"description":"Returns information about the installed extension that has the given ID.","async":"callback","parameters":[{"allOf":[{"$ref":"manifest#/types/ExtensionID"},{"name":"id","description":"The ID from an item of $(ref:management.ExtensionInfo)."}]},{"name":"callback","type":"function","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"result"}]}]}]},{"name":"install","type":"function","requireUserInput":true,"permissions":["management"],"description":"Installs and enables a theme extension from the given url.","async":"callback","parameters":[{"name":"options","type":"object","properties":{"url":{"allOf":[{"$ref":"manifest#/types/HttpURL"},{"description":"URL pointing to the XPI file on addons.mozilla.org or similar."}]},"hash":{"type":"string","pattern":"^(sha256|sha512):[0-9a-fA-F]{64,128}$","description":"A hash of the XPI file, using sha256 or stronger."}},"required":["url"]},{"name":"callback","type":"function","optional":true,"parameters":[{"name":"result","type":"object","properties":{"id":{"$ref":"manifest#/types/ExtensionID"}},"required":["id"]}]}]},{"name":"getSelf","type":"function","description":"Returns information about the calling extension. Note: This function can be used without requesting the \'management\' permission in the manifest.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"result"}]}]}]},{"name":"uninstallSelf","type":"function","description":"Uninstalls the calling extension. Note: This function can be used without requesting the \'management\' permission in the manifest.","async":"callback","parameters":[{"type":"object","name":"options","optional":true,"properties":{"showConfirmDialog":{"type":"boolean","description":"Whether or not a confirm-uninstall dialog should prompt the user. Defaults to false."},"dialogMessage":{"type":"string","description":"The message to display to a user when being asked to confirm removal of the extension."}}},{"name":"callback","type":"function","optional":true,"parameters":[]}]},{"name":"setEnabled","type":"function","permissions":["management"],"description":"Enables or disables the given add-on.","async":"callback","parameters":[{"name":"id","type":"string","description":"ID of the add-on to enable/disable."},{"name":"enabled","type":"boolean","description":"Whether to enable or disable the add-on."},{"name":"callback","type":"function","optional":true,"parameters":[]}]}],"events":[{"name":"onDisabled","type":"function","permissions":["management"],"description":"Fired when an addon has been disabled.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]},{"name":"onEnabled","type":"function","permissions":["management"],"description":"Fired when an addon has been enabled.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]},{"name":"onInstalled","type":"function","permissions":["management"],"description":"Fired when an addon has been installed.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]},{"name":"onUninstalled","type":"function","permissions":["management"],"description":"Fired when an addon has been uninstalled.","parameters":[{"allOf":[{"$ref":"#/types/ExtensionInfo"},{"name":"info"}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["management"]}]}},"refs":{"management#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"IconInfo":{"description":"Information about an icon belonging to an extension.","type":"object","properties":{"size":{"type":"integer","description":"A number representing the width and height of the icon. Likely values include (but are not limited to) 128, 48, 24, and 16."},"url":{"type":"string","description":"The URL for this icon image. To display a grayscale version of the icon (to indicate that an extension is disabled, for example), append <code>?grayscale=true</code> to the URL."}},"required":["size","url"]},"ExtensionDisabledReason":{"description":"A reason the item is disabled.","type":"string","enum":["unknown","permissions_increase"]},"ExtensionType":{"description":"The type of this extension, \'extension\' or \'theme\'.","type":"string","enum":["extension","theme"]},"ExtensionInstallType":{"description":"How the extension was installed. One of<br><var>development</var>: The extension was loaded unpacked in developer mode,<br><var>normal</var>: The extension was installed normally via an .xpi file,<br><var>sideload</var>: The extension was installed by other software on the machine,<br><var>admin</var>: The extension was installed by policy,<br><var>other</var>: The extension was installed by other means.","type":"string","enum":["development","normal","sideload","admin","other"]},"ExtensionInfo":{"description":"Information about an installed extension.","type":"object","properties":{"id":{"description":"The extension\'s unique identifier.","type":"string"},"name":{"description":"The name of this extension.","type":"string"},"shortName":{"description":"A short version of the name of this extension.","type":"string"},"description":{"description":"The description of this extension.","type":"string"},"version":{"description":"The <a href=\'manifest/version\'>version</a> of this extension.","type":"string"},"versionName":{"description":"The <a href=\'manifest/version#version_name\'>version name</a> of this extension if the manifest specified one.","type":"string"},"mayDisable":{"description":"Whether this extension can be disabled or uninstalled by the user.","type":"boolean"},"enabled":{"description":"Whether it is currently enabled or disabled.","type":"boolean"},"disabledReason":{"allOf":[{"$ref":"#/types/ExtensionDisabledReason"},{"description":"A reason the item is disabled."}]},"type":{"allOf":[{"$ref":"#/types/ExtensionType"},{"description":"The type of this extension, \'extension\' or \'theme\'."}]},"homepageUrl":{"description":"The URL of the homepage of this extension.","type":"string"},"updateUrl":{"description":"The update URL of this extension.","type":"string"},"optionsUrl":{"description":"The url for the item\'s options page, if it has one.","type":"string"},"icons":{"description":"A list of icon information. Note that this just reflects what was declared in the manifest, and the actual image at that url may be larger or smaller than what was declared, so you might consider using explicit width and height attributes on img tags referencing these images. See the <a href=\'manifest/icons\'>manifest documentation on icons</a> for more details.","type":"array","items":{"$ref":"#/types/IconInfo"}},"permissions":{"description":"Returns a list of API based permissions.","type":"array","items":{"type":"string"}},"hostPermissions":{"description":"Returns a list of host based permissions.","type":"array","items":{"type":"string"}},"installType":{"allOf":[{"$ref":"#/types/ExtensionInstallType"},{"description":"How the extension was installed."}]}},"required":["id","name","description","version","mayDisable","enabled","type","optionsUrl","installType"]}}}');

/***/ }),
/* 81 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"contextMenus","permissions":["menus","contextMenus"],"description":"Use the browser.contextMenus API to add items to the browser\'s context menu. You can choose what types of objects your context menu additions apply to, such as images, hyperlinks, and pages.","properties":{"ACTION_MENU_TOP_LEVEL_LIMIT":{"value":6,"description":"The maximum number of top level extension items that can be added to an extension action context menu. Any items beyond this limit will be ignored."}},"functions":[{"name":"create","type":"function","description":"Creates a new context menu item. Note that if an error occurs during creation, you may not find out until the creation callback fires (the details will be in $(ref:runtime.lastError)).","returns":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the newly created item."},"parameters":[{"type":"object","name":"createProperties","properties":{"type":{"allOf":[{"$ref":"#/types/ItemType"},{"description":"The type of menu item. Defaults to \'normal\' if not specified."}]},"id":{"type":"string","description":"The unique ID to assign to this item. Mandatory for event pages. Cannot be the same as another ID for this extension."},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string","description":"The text to be displayed in the item; this is <em>required</em> unless <code>type</code> is \'separator\'. When the context is \'selection\', you can use <code>%s</code> within the string to show the selected text. For example, if this parameter\'s value is \\"Translate \'%s\' to Pig Latin\\" and the user selects the word \\"cool\\", the context menu item for the selection is \\"Translate \'cool\' to Pig Latin\\"."},"checked":{"type":"boolean","description":"The initial state of a checkbox or radio item: true for selected and false for unselected. Only one radio item can be selected at a time in a given group of radio items."},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1,"description":"List of contexts this menu item will appear in. Defaults to [\'page\'] if not specified."},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1,"description":"List of view types where the menu item will be shown. Defaults to any view, including those without a viewType."},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","max_manifest_version":2,"description":"A function that will be called back when the menu item is clicked. Event pages cannot use this; instead, they should register a listener for $(ref:contextMenus.onClicked).","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of a parent menu item; this makes the item a child of a previously added item."},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Lets you restrict the item to apply only to documents whose URL matches one of the given patterns. (This applies to frames as well.) For details on the format of a pattern, see $(topic:match_patterns)[Match Patterns]."},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Similar to documentUrlPatterns, but lets you filter based on the src attribute of img/audio/video tags and the href of anchor tags."},"enabled":{"type":"boolean","description":"Whether this context menu item is enabled or disabled. Defaults to true."},"command":{"anyOf":[{"type":"string"},{"type":"string","enum":["_execute_browser_action","_execute_page_action","_execute_sidebar_action"],"max_manifest_version":2,"description":"Manifest V2 supports internal commands _execute_page_action, _execute_browser_action and _execute_sidebar_action."},{"type":"string","enum":["_execute_action","_execute_page_action","_execute_sidebar_action"],"min_manifest_version":3,"description":"Manifest V3 supports internal commands _execute_page_action, _execute_action and _execute_sidebar_action."}],"description":"Specifies a command to issue for the context click."}}},{"type":"function","name":"callback","optional":true,"description":"Called when the item has been created in the browser. If there were any problems creating the item, details will be available in $(ref:runtime.lastError).","parameters":[]}]},{"name":"update","type":"function","description":"Updates a previously created context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"id","description":"The ID of the item to update."},{"type":"object","name":"updateProperties","description":"The properties to update. Accepts the same values as the create function.","properties":{"type":{"$ref":"#/types/ItemType"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string"},"checked":{"type":"boolean"},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","max_manifest_version":2,"parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info"}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"Note: You cannot change an item to be a child of one of its own descendants."},"documentUrlPatterns":{"type":"array","items":{"type":"string"}},"targetUrlPatterns":{"type":"array","items":{"type":"string"}},"enabled":{"type":"boolean"}}},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been updated."}]},{"name":"remove","type":"function","description":"Removes a context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"menuItemId","description":"The ID of the context menu item to remove."},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been removed."}]},{"name":"removeAll","type":"function","description":"Removes all context menu items added by this extension.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when removal is complete."}]},{"name":"overrideContext","permissions":["menus.overrideContext"],"type":"function","description":"Show the matching menu items from this extension instead of the default menu. This should be called during a \'contextmenu\' DOM event handler, and only applies to the menu that opens after this event.","parameters":[{"name":"contextOptions","type":"object","properties":{"showDefaults":{"type":"boolean","default":false,"description":"Whether to also include default menu items in the menu."},"context":{"type":"string","enum":["bookmark","tab"],"description":"ContextType to override, to allow menu items from other extensions in the menu. Currently only \'bookmark\' and \'tab\' are supported. showDefaults cannot be used with this option."},"bookmarkId":{"type":"string","minLength":1,"description":"Required when context is \'bookmark\'. Requires \'bookmark\' permission."},"tabId":{"type":"integer","minimum":0,"description":"Required when context is \'tab\'. Requires \'tabs\' permission."}}}]},{"name":"refresh","type":"function","description":"Updates the extension items in the shown menu, including changes that have been made since the menu was shown. Has no effect if the menu is hidden. Rebuilding a shown menu is an expensive operation, only invoke this method when necessary.","async":true,"parameters":[]},{"name":"getTargetElement","type":"function","allowedContexts":["content","devtools"],"description":"Retrieve the element that was associated with a recent contextmenu event.","parameters":[{"type":"integer","description":"The identifier of the clicked element, available as info.targetElementId in the menus.onShown, onClicked or onclick event.","name":"targetElementId"}],"returns":{"type":"object","optional":true,"isInstanceOf":"Element","additionalProperties":{}}}],"events":[{"name":"onClicked","type":"function","description":"Fired when a context menu item is clicked.","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. If the click did not take place in a tab, this parameter will be missing.","optional":true}]}]},{"name":"onShown","type":"function","description":"Fired when a menu is shown. The extension can add, modify or remove menu items and call menus.refresh() to update the menu.","parameters":[{"name":"info","type":"object","description":"Information about the context of the menu action and the created menu items. For more information about each property, see OnClickData. The following properties are only set if the extension has host permissions for the given context: linkUrl, linkText, srcUrl, pageUrl, frameUrl, selectionText.","properties":{"menuIds":{"description":"A list of IDs of the menu items that were shown.","type":"array","items":{"anyOf":[{"type":"integer"},{"type":"string"}]}},"contexts":{"description":"A list of all contexts that apply to the menu.","type":"array","items":{"$ref":"#/types/ContextType"}},"viewType":{"$ref":"extension#/types/ViewType"},"editable":{"type":"boolean"},"mediaType":{"type":"string"},"linkUrl":{"type":"string"},"linkText":{"type":"string"},"srcUrl":{"type":"string"},"pageUrl":{"type":"string"},"frameUrl":{"type":"string"},"selectionText":{"type":"string"},"targetElementId":{"type":"integer"}},"required":["menuIds","contexts","editable"]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the menu was opened."}]}]},{"name":"onHidden","type":"function","description":"Fired when a menu is hidden. This event is only fired if onShown has fired before.","parameters":[]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus","contextMenus"]}]},"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus.overrideContext"]}]}},"refs":{"menus#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"menus#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ContextType":{"description":"The different contexts a menu can appear in. Specifying \'all\' is equivalent to the combination of all other contexts except for \'tab\' and \'tools_menu\'.","anyOf":[{"type":"string","enum":["all","page","frame","selection","link","editable","password","image","video","audio","launcher","bookmark","tab","tools_menu"]},{"type":"string","enum":["browser_action","page_action"],"max_manifest_version":2},{"type":"string","enum":["action"],"min_manifest_version":3}]},"ItemType":{"type":"string","enum":["normal","checkbox","radio","separator"],"description":"The type of menu item."},"OnClickData":{"type":"object","description":"Information sent when a context menu item is clicked.","properties":{"menuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the menu item that was clicked."},"parentMenuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The parent ID, if any, for the item clicked."},"viewType":{"allOf":[{"$ref":"extension#/types/ViewType"},{"description":"The type of view where the menu is clicked. May be unset if the menu is not associated with a view."}]},"mediaType":{"type":"string","description":"One of \'image\', \'video\', or \'audio\' if the context menu was activated on one of these types of elements."},"linkText":{"type":"string","description":"If the element is a link, the text of that link."},"linkUrl":{"type":"string","description":"If the element is a link, the URL it points to."},"srcUrl":{"type":"string","description":"Will be present for elements with a \'src\' URL."},"pageUrl":{"type":"string","description":"The URL of the page where the menu item was clicked. This property is not set if the click occured in a context where there is no current page, such as in a launcher context menu."},"frameId":{"type":"integer","minimum":0,"description":"The id of the frame of the element where the context menu was clicked."},"frameUrl":{"type":"string","description":" The URL of the frame of the element where the context menu was clicked, if it was in a frame."},"selectionText":{"type":"string","description":"The text for the context selection, if any."},"editable":{"type":"boolean","description":"A flag indicating whether the element is editable (text input, textarea, etc.)."},"wasChecked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item before it was clicked."},"checked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item after it is clicked."},"bookmarkId":{"type":"string","description":"The id of the bookmark where the context menu was clicked, if it was on a bookmark."},"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."},"targetElementId":{"type":"integer","description":"An identifier of the clicked element, if any. Use menus.getTargetElement in the page to find the corresponding element."}},"required":["menuItemId","editable","modifiers"]}},"allowedContexts":["content","devtools"]}');

/***/ }),
/* 82 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"menus","permissions":["menus"],"description":"The part of the menus API that is available in all extension contexts, including content scripts.","properties":{"ACTION_MENU_TOP_LEVEL_LIMIT":{"value":6,"description":"The maximum number of top level extension items that can be added to an extension action context menu. Any items beyond this limit will be ignored."}},"functions":[{"name":"create","type":"function","description":"Creates a new context menu item. Note that if an error occurs during creation, you may not find out until the creation callback fires (the details will be in $(ref:runtime.lastError)).","returns":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the newly created item."},"parameters":[{"type":"object","name":"createProperties","properties":{"type":{"allOf":[{"$ref":"#/types/ItemType"},{"description":"The type of menu item. Defaults to \'normal\' if not specified."}]},"id":{"type":"string","description":"The unique ID to assign to this item. Mandatory for event pages. Cannot be the same as another ID for this extension."},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string","description":"The text to be displayed in the item; this is <em>required</em> unless <code>type</code> is \'separator\'. When the context is \'selection\', you can use <code>%s</code> within the string to show the selected text. For example, if this parameter\'s value is \\"Translate \'%s\' to Pig Latin\\" and the user selects the word \\"cool\\", the context menu item for the selection is \\"Translate \'cool\' to Pig Latin\\"."},"checked":{"type":"boolean","description":"The initial state of a checkbox or radio item: true for selected and false for unselected. Only one radio item can be selected at a time in a given group of radio items."},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1,"description":"List of contexts this menu item will appear in. Defaults to [\'page\'] if not specified."},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1,"description":"List of view types where the menu item will be shown. Defaults to any view, including those without a viewType."},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","max_manifest_version":2,"description":"A function that will be called back when the menu item is clicked. Event pages cannot use this; instead, they should register a listener for $(ref:contextMenus.onClicked).","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of a parent menu item; this makes the item a child of a previously added item."},"documentUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Lets you restrict the item to apply only to documents whose URL matches one of the given patterns. (This applies to frames as well.) For details on the format of a pattern, see $(topic:match_patterns)[Match Patterns]."},"targetUrlPatterns":{"type":"array","items":{"type":"string"},"description":"Similar to documentUrlPatterns, but lets you filter based on the src attribute of img/audio/video tags and the href of anchor tags."},"enabled":{"type":"boolean","description":"Whether this context menu item is enabled or disabled. Defaults to true."},"command":{"anyOf":[{"type":"string"},{"type":"string","enum":["_execute_browser_action","_execute_page_action","_execute_sidebar_action"],"max_manifest_version":2,"description":"Manifest V2 supports internal commands _execute_page_action, _execute_browser_action and _execute_sidebar_action."},{"type":"string","enum":["_execute_action","_execute_page_action","_execute_sidebar_action"],"min_manifest_version":3,"description":"Manifest V3 supports internal commands _execute_page_action, _execute_action and _execute_sidebar_action."}],"description":"Specifies a command to issue for the context click."}}},{"type":"function","name":"callback","optional":true,"description":"Called when the item has been created in the browser. If there were any problems creating the item, details will be available in $(ref:runtime.lastError).","parameters":[]}]},{"name":"update","type":"function","description":"Updates a previously created context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"id","description":"The ID of the item to update."},{"type":"object","name":"updateProperties","description":"The properties to update. Accepts the same values as the create function.","properties":{"type":{"$ref":"#/types/ItemType"},"icons":{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}},"title":{"type":"string"},"checked":{"type":"boolean"},"contexts":{"type":"array","items":{"$ref":"#/types/ContextType"},"minItems":1},"viewTypes":{"type":"array","items":{"$ref":"extension#/types/ViewType"},"minItems":1},"visible":{"type":"boolean","description":"Whether the item is visible in the menu."},"onclick":{"type":"function","max_manifest_version":2,"parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info"}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. Note: this parameter only present for extensions."}]}]},"parentId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"Note: You cannot change an item to be a child of one of its own descendants."},"documentUrlPatterns":{"type":"array","items":{"type":"string"}},"targetUrlPatterns":{"type":"array","items":{"type":"string"}},"enabled":{"type":"boolean"}}},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been updated."}]},{"name":"remove","type":"function","description":"Removes a context menu item.","async":"callback","parameters":[{"anyOf":[{"type":"integer"},{"type":"string"}],"name":"menuItemId","description":"The ID of the context menu item to remove."},{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when the context menu has been removed."}]},{"name":"removeAll","type":"function","description":"Removes all context menu items added by this extension.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[],"description":"Called when removal is complete."}]},{"name":"overrideContext","permissions":["menus.overrideContext"],"type":"function","description":"Show the matching menu items from this extension instead of the default menu. This should be called during a \'contextmenu\' DOM event handler, and only applies to the menu that opens after this event.","parameters":[{"name":"contextOptions","type":"object","properties":{"showDefaults":{"type":"boolean","default":false,"description":"Whether to also include default menu items in the menu."},"context":{"type":"string","enum":["bookmark","tab"],"description":"ContextType to override, to allow menu items from other extensions in the menu. Currently only \'bookmark\' and \'tab\' are supported. showDefaults cannot be used with this option."},"bookmarkId":{"type":"string","minLength":1,"description":"Required when context is \'bookmark\'. Requires \'bookmark\' permission."},"tabId":{"type":"integer","minimum":0,"description":"Required when context is \'tab\'. Requires \'tabs\' permission."}}}]},{"name":"refresh","type":"function","description":"Updates the extension items in the shown menu, including changes that have been made since the menu was shown. Has no effect if the menu is hidden. Rebuilding a shown menu is an expensive operation, only invoke this method when necessary.","async":true,"parameters":[]},{"name":"getTargetElement","type":"function","allowedContexts":["content","devtools"],"description":"Retrieve the element that was associated with a recent contextmenu event.","parameters":[{"type":"integer","description":"The identifier of the clicked element, available as info.targetElementId in the menus.onShown, onClicked or onclick event.","name":"targetElementId"}],"returns":{"type":"object","optional":true,"isInstanceOf":"Element","additionalProperties":{}}}],"events":[{"name":"onClicked","type":"function","description":"Fired when a context menu item is clicked.","parameters":[{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","description":"Information about the item clicked and the context where the click happened."}]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the click took place. If the click did not take place in a tab, this parameter will be missing.","optional":true}]}]},{"name":"onShown","type":"function","description":"Fired when a menu is shown. The extension can add, modify or remove menu items and call menus.refresh() to update the menu.","parameters":[{"name":"info","type":"object","description":"Information about the context of the menu action and the created menu items. For more information about each property, see OnClickData. The following properties are only set if the extension has host permissions for the given context: linkUrl, linkText, srcUrl, pageUrl, frameUrl, selectionText.","properties":{"menuIds":{"description":"A list of IDs of the menu items that were shown.","type":"array","items":{"anyOf":[{"type":"integer"},{"type":"string"}]}},"contexts":{"description":"A list of all contexts that apply to the menu.","type":"array","items":{"$ref":"#/types/ContextType"}},"viewType":{"$ref":"extension#/types/ViewType"},"editable":{"type":"boolean"},"mediaType":{"type":"string"},"linkUrl":{"type":"string"},"linkText":{"type":"string"},"srcUrl":{"type":"string"},"pageUrl":{"type":"string"},"frameUrl":{"type":"string"},"selectionText":{"type":"string"},"targetElementId":{"type":"integer"}},"required":["menuIds","contexts","editable"]},{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab","description":"The details of the tab where the menu was opened."}]}]},{"name":"onHidden","type":"function","description":"Fired when a menu is hidden. This event is only fired if onShown has fired before.","parameters":[]}],"definitions":{"PermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus","contextMenus"]}]},"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["menus.overrideContext"]}]}},"refs":{"menus#/definitions/PermissionNoPrompt":{"namespace":"manifest","type":"PermissionNoPrompt"},"menus#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ContextType":{"description":"The different contexts a menu can appear in. Specifying \'all\' is equivalent to the combination of all other contexts except for \'tab\' and \'tools_menu\'.","anyOf":[{"type":"string","enum":["all","page","frame","selection","link","editable","password","image","video","audio","launcher","bookmark","tab","tools_menu"]},{"type":"string","enum":["browser_action","page_action"],"max_manifest_version":2},{"type":"string","enum":["action"],"min_manifest_version":3}]},"ItemType":{"type":"string","enum":["normal","checkbox","radio","separator"],"description":"The type of menu item."},"OnClickData":{"type":"object","description":"Information sent when a context menu item is clicked.","properties":{"menuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The ID of the menu item that was clicked."},"parentMenuItemId":{"anyOf":[{"type":"integer"},{"type":"string"}],"description":"The parent ID, if any, for the item clicked."},"viewType":{"allOf":[{"$ref":"extension#/types/ViewType"},{"description":"The type of view where the menu is clicked. May be unset if the menu is not associated with a view."}]},"mediaType":{"type":"string","description":"One of \'image\', \'video\', or \'audio\' if the context menu was activated on one of these types of elements."},"linkText":{"type":"string","description":"If the element is a link, the text of that link."},"linkUrl":{"type":"string","description":"If the element is a link, the URL it points to."},"srcUrl":{"type":"string","description":"Will be present for elements with a \'src\' URL."},"pageUrl":{"type":"string","description":"The URL of the page where the menu item was clicked. This property is not set if the click occured in a context where there is no current page, such as in a launcher context menu."},"frameId":{"type":"integer","minimum":0,"description":"The id of the frame of the element where the context menu was clicked."},"frameUrl":{"type":"string","description":" The URL of the frame of the element where the context menu was clicked, if it was in a frame."},"selectionText":{"type":"string","description":"The text for the context selection, if any."},"editable":{"type":"boolean","description":"A flag indicating whether the element is editable (text input, textarea, etc.)."},"wasChecked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item before it was clicked."},"checked":{"type":"boolean","description":"A flag indicating the state of a checkbox or radio item after it is clicked."},"bookmarkId":{"type":"string","description":"The id of the bookmark where the context menu was clicked, if it was on a bookmark."},"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."},"targetElementId":{"type":"integer","description":"An identifier of the clicked element, if any. Use menus.getTargetElement in the page to find the corresponding element."}},"required":["menuItemId","editable","modifiers"]}},"allowedContexts":["content","devtools"]}');

/***/ }),
/* 83 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"native_manifest","definitions":{},"refs":{},"types":{"NativeManifest":{"description":"Represents a native manifest file","anyOf":[{"type":"object","properties":{"name":{"type":"string","pattern":"^\\\\w+(\\\\.\\\\w+)*$"},"description":{"type":"string"},"path":{"type":"string"},"type":{"type":"string","enum":["pkcs11","stdio"]},"allowed_extensions":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/ExtensionID"}}},"required":["name","description","path","type","allowed_extensions"]},{"type":"object","properties":{"name":{"$ref":"manifest#/types/ExtensionID"},"description":{"type":"string"},"data":{"type":"object","additionalProperties":{}},"type":{"type":"string","enum":["storage"]}},"required":["name","description","data","type"]}]}}}');

/***/ }),
/* 84 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"networkStatus","description":"This API provides the ability to determine the status of and detect changes in the network connection. This API can only be used in privileged extensions.","permissions":["networkStatus"],"functions":[{"name":"getLinkInfo","type":"function","description":"Returns the $(ref:NetworkLinkInfo) of the current network connection.","async":true,"parameters":[]}],"events":[{"name":"onConnectionChanged","type":"function","description":"Fired when the network connection state changes.","parameters":[{"allOf":[{"$ref":"#/types/NetworkLinkInfo"},{"name":"details"}]}]}],"definitions":{"PermissionPrivileged":{"anyOf":[{"type":"string","enum":["networkStatus"]}]}},"refs":{"networkStatus#/definitions/PermissionPrivileged":{"namespace":"manifest","type":"PermissionPrivileged"}},"types":{"NetworkLinkInfo":{"type":"object","properties":{"status":{"type":"string","enum":["unknown","up","down"],"description":"Status of the network link, if \\"unknown\\" then link is usually assumed to be \\"up\\""},"type":{"type":"string","enum":["unknown","ethernet","usb","wifi","wimax","mobile"],"description":"If known, the type of network connection that is avialable."},"id":{"type":"string","description":"If known, the network id or name."}},"required":["status","type"]}}}');

/***/ }),
/* 85 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"normandyAddonStudy","description":"Normandy Study API","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"permissions":["normandyAddonStudy"],"functions":[{"name":"getStudy","type":"function","description":"Returns a study object for the current study.","async":true,"parameters":[]},{"name":"endStudy","type":"function","description":"Marks the study as ended and then uninstalls the addon.","async":true,"parameters":[{"type":"string","name":"reason","description":"The reason why the study is ending."}]},{"name":"getClientMetadata","type":"function","description":"Returns an object with metadata about the client which may be required for constructing survey URLs.","async":true,"parameters":[]}],"events":[{"name":"onUnenroll","type":"function","description":"Fired when a user unenrolls from a study but before the addon is uninstalled.","parameters":[{"type":"string","name":"reason","description":"The reason why the study is ending."}]}],"definitions":{"PermissionPrivileged":{"anyOf":[{"type":"string","enum":["normandyAddonStudy"]}]}},"refs":{"normandyAddonStudy#/definitions/PermissionPrivileged":{"namespace":"manifest","type":"PermissionPrivileged"}},"types":{"Study":{"type":"object","properties":{"recipeId":{"type":"integer","description":"The ID of the recipe for the study."},"slug":{"type":"string","description":"A slug to identify the study."},"userFacingName":{"type":"string","description":"The name presented on about:studies."},"userFacingDescription":{"type":"string","description":"The description presented on about:studies."},"branch":{"type":"string","description":"The study branch in which the user is enrolled."},"active":{"type":"boolean","description":"The state of the study."},"addonId":{"type":"string","description":"The ID of the extension installed by the study."},"addonUrl":{"type":"string","description":"The URL of the XPI that was downloaded and installed by the study."},"addonVersion":{"type":"string","description":"The version of the extension installed by the study."},"studyStartDate":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The start date for the study."}]},"studyEndDate":{"allOf":[{"$ref":"extensionTypes#/types/Date"},{"description":"The end date for the study."}]},"extensionApiId":{"type":"integer","description":"The record ID for the extension in Normandy server\'s database."},"extensionHash":{"type":"string","description":"A hash of the extension XPI file."},"extensionHashAlgorithm":{"type":"string","description":"The algorithm used to hash the extension XPI file."}},"required":["recipeId","slug","userFacingName","userFacingDescription","branch","active","addonId","addonUrl","addonVersion","studyStartDate","studyEndDate","extensionApiId","extensionHash","extensionHashAlgorithm"]}}}');

/***/ }),
/* 86 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"notifications","permissions":["notifications"],"functions":[{"name":"create","type":"function","description":"Creates and displays a notification.","async":"callback","parameters":[{"optional":true,"type":"string","name":"notificationId","description":"Identifier of the notification. If it is empty, this method generates an id. If it matches an existing notification, this method first clears that notification before proceeding with the create operation."},{"allOf":[{"$ref":"#/types/CreateNotificationOptions"},{"name":"options","description":"Contents of the notification."}]},{"optional":true,"type":"function","name":"callback","parameters":[{"name":"notificationId","type":"string","description":"The notification id (either supplied or generated) that represents the created notification."}]}]},{"name":"update","unsupported":true,"type":"function","description":"Updates an existing notification.","async":"callback","parameters":[{"type":"string","name":"notificationId","description":"The id of the notification to be updated."},{"allOf":[{"$ref":"#/types/UpdateNotificationOptions"},{"name":"options","description":"Contents of the notification to update to."}]},{"optional":true,"type":"function","name":"callback","parameters":[{"name":"wasUpdated","type":"boolean","description":"Indicates whether a matching notification existed."}]}]},{"name":"clear","type":"function","description":"Clears an existing notification.","async":"callback","parameters":[{"type":"string","name":"notificationId","description":"The id of the notification to be updated."},{"optional":true,"type":"function","name":"callback","parameters":[{"name":"wasCleared","type":"boolean","description":"Indicates whether a matching notification existed."}]}]},{"name":"getAll","type":"function","description":"Retrieves all the notifications.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"notifications","type":"object","additionalProperties":{"$ref":"#/types/CreateNotificationOptions"},"description":"The set of notifications currently in the system."}]}]},{"name":"getPermissionLevel","unsupported":true,"type":"function","description":"Retrieves whether the user has enabled notifications from this app or extension.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/PermissionLevel"},{"name":"level","description":"The current permission level."}]}]}]}],"events":[{"name":"onClosed","type":"function","description":"Fired when the notification closed, either by the system or by user action.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the closed notification."},{"type":"boolean","name":"byUser","description":"True if the notification was closed by the user."}]},{"name":"onClicked","type":"function","description":"Fired when the user clicked in a non-button area of the notification.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the clicked notification."}]},{"name":"onButtonClicked","type":"function","description":"Fired when the  user pressed a button in the notification.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the clicked notification."},{"type":"number","name":"buttonIndex","description":"The index of the button clicked by the user."}]},{"name":"onPermissionLevelChanged","unsupported":true,"type":"function","description":"Fired when the user changes the permission level.","parameters":[{"allOf":[{"$ref":"#/types/PermissionLevel"},{"name":"level","description":"The new permission level."}]}]},{"name":"onShowSettings","unsupported":true,"type":"function","description":"Fired when the user clicked on a link for the app\'s notification settings.","parameters":[]},{"name":"onShown","type":"function","description":"Fired when the notification is shown.","parameters":[{"type":"string","name":"notificationId","description":"The notificationId of the shown notification."}]}],"definitions":{},"refs":{},"types":{"TemplateType":{"type":"string","enum":["basic","image","list","progress"]},"PermissionLevel":{"type":"string","enum":["granted","denied"]},"NotificationItem":{"type":"object","properties":{"title":{"description":"Title of one item of a list notification.","type":"string"},"message":{"description":"Additional details about this item.","type":"string"}},"required":["title","message"]},"CreateNotificationOptions":{"type":"object","properties":{"type":{"allOf":[{"$ref":"#/types/TemplateType"},{"description":"Which type of notification to display."}]},"iconUrl":{"description":"A URL to the sender\'s avatar, app icon, or a thumbnail for image notifications.","type":"string"},"appIconMaskUrl":{"description":"A URL to the app icon mask.","type":"string"},"title":{"description":"Title of the notification (e.g. sender name for email).","type":"string"},"message":{"description":"Main notification content.","type":"string"},"contextMessage":{"description":"Alternate notification content with a lower-weight font.","type":"string"},"priority":{"description":"Priority ranges from -2 to 2. -2 is lowest priority. 2 is highest. Zero is default.","type":"integer","minimum":-2,"maximum":2},"eventTime":{"description":"A timestamp associated with the notification, in milliseconds past the epoch.","type":"number"},"buttons":{"unsupported":true,"description":"Text and icons for up to two notification action buttons.","type":"array","items":{"type":"object","properties":{"title":{"type":"string"},"iconUrl":{"type":"string"}},"required":["title"]}},"imageUrl":{"description":"A URL to the image thumbnail for image-type notifications.","type":"string"},"items":{"description":"Items for multi-item notifications.","type":"array","items":{"$ref":"#/types/NotificationItem"}},"progress":{"description":"Current progress ranges from 0 to 100.","type":"integer","minimum":0,"maximum":100},"isClickable":{"description":"Whether to show UI indicating that the app will visibly respond to clicks on the body of a notification.","type":"boolean"}},"required":["type","title","message"]},"UpdateNotificationOptions":{"type":"object","properties":{"type":{"allOf":[{"$ref":"#/types/TemplateType"},{"description":"Which type of notification to display."}]},"iconUrl":{"description":"A URL to the sender\'s avatar, app icon, or a thumbnail for image notifications.","type":"string"},"appIconMaskUrl":{"description":"A URL to the app icon mask.","type":"string"},"title":{"description":"Title of the notification (e.g. sender name for email).","type":"string"},"message":{"description":"Main notification content.","type":"string"},"contextMessage":{"description":"Alternate notification content with a lower-weight font.","type":"string"},"priority":{"description":"Priority ranges from -2 to 2. -2 is lowest priority. 2 is highest. Zero is default.","type":"integer","minimum":-2,"maximum":2},"eventTime":{"description":"A timestamp associated with the notification, in milliseconds past the epoch.","type":"number"},"buttons":{"unsupported":true,"description":"Text and icons for up to two notification action buttons.","type":"array","items":{"type":"object","properties":{"title":{"type":"string"},"iconUrl":{"type":"string"}},"required":["title"]}},"imageUrl":{"description":"A URL to the image thumbnail for image-type notifications.","type":"string"},"items":{"description":"Items for multi-item notifications.","type":"array","items":{"$ref":"#/types/NotificationItem"}},"progress":{"description":"Current progress ranges from 0 to 100.","type":"integer","minimum":0,"maximum":100},"isClickable":{"description":"Whether to show UI indicating that the app will visibly respond to clicks on the body of a notification.","type":"boolean"}}}}}');

/***/ }),
/* 87 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"omnibox","description":"The omnibox API allows you to register a keyword with Firefox\'s address bar.","permissions":["manifest:omnibox"],"functions":[{"name":"setDefaultSuggestion","type":"function","description":"Sets the description and styling for the default suggestion. The default suggestion is the text that is displayed in the first suggestion row underneath the URL bar.","parameters":[{"allOf":[{"$ref":"#/types/DefaultSuggestResult"},{"name":"suggestion","description":"A partial SuggestResult object, without the \'content\' parameter."}]}]}],"events":[{"name":"onInputStarted","type":"function","description":"User has started a keyword input session by typing the extension\'s keyword. This is guaranteed to be sent exactly once per input session, and before any onInputChanged events.","parameters":[]},{"name":"onInputChanged","type":"function","description":"User has changed what is typed into the omnibox.","parameters":[{"type":"string","name":"text"},{"name":"suggest","type":"function","description":"A callback passed to the onInputChanged event used for sending suggestions back to the browser.","parameters":[{"name":"suggestResults","type":"array","description":"Array of suggest results","items":{"$ref":"#/types/SuggestResult"}}]}]},{"name":"onInputEntered","type":"function","description":"User has accepted what is typed into the omnibox.","parameters":[{"type":"string","name":"text"},{"allOf":[{"$ref":"#/types/OnInputEnteredDisposition"},{"name":"disposition"}]}]},{"name":"onInputCancelled","type":"function","description":"User has ended the keyword input session without accepting the input.","parameters":[]},{"name":"onDeleteSuggestion","type":"function","description":"User has deleted a suggested result.","parameters":[{"type":"string","name":"text"}]}],"definitions":{"WebExtensionManifest":{"properties":{"omnibox":{"type":"object","properties":{"keyword":{"type":"string","pattern":"^[^?\\\\s:][^\\\\s:]*$"}},"required":["keyword"]}}}},"refs":{"omnibox#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"DescriptionStyleType":{"type":"string","description":"The style type.","enum":["url","match","dim"]},"OnInputEnteredDisposition":{"type":"string","enum":["currentTab","newForegroundTab","newBackgroundTab"],"description":"The window disposition for the omnibox query. This is the recommended context to display results. For example, if the omnibox command is to navigate to a certain URL, a disposition of \'newForegroundTab\' means the navigation should take place in a new selected tab."},"SuggestResult":{"type":"object","description":"A suggest result.","properties":{"content":{"type":"string","minLength":1,"description":"The text that is put into the URL bar, and that is sent to the extension when the user chooses this entry."},"description":{"type":"string","minLength":1,"description":"The text that is displayed in the URL dropdown. Can contain XML-style markup for styling. The supported tags are \'url\' (for a literal URL), \'match\' (for highlighting text that matched what the user\'s query), and \'dim\' (for dim helper text). The styles can be nested, eg. <dim><match>dimmed match</match></dim>. You must escape the five predefined entities to display them as text: stackoverflow.com/a/1091953/89484 "},"deletable":{"type":"boolean","description":"Whether the suggest result can be deleted by the user."},"descriptionStyles":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by the extension.","items":{"type":"object","description":"The style ranges for the description, as provided by the extension.","properties":{"offset":{"type":"integer"},"type":{"allOf":[{"$ref":"#/types/DescriptionStyleType"},{"description":"The style type"}]},"length":{"type":"integer"}},"required":["offset","type"]}},"descriptionStylesRaw":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by ToValue().","items":{"type":"object","description":"The style ranges for the description, as provided by ToValue().","properties":{"offset":{"type":"integer"},"type":{"type":"integer"}},"required":["offset","type"]}}},"required":["content","description"]},"DefaultSuggestResult":{"type":"object","description":"A suggest result.","properties":{"description":{"type":"string","minLength":1,"description":"The text that is displayed in the URL dropdown."},"descriptionStyles":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by the extension.","items":{"type":"object","description":"The style ranges for the description, as provided by the extension.","properties":{"offset":{"type":"integer"},"type":{"allOf":[{"$ref":"#/types/DescriptionStyleType"},{"description":"The style type"}]},"length":{"type":"integer"}},"required":["offset","type"]}},"descriptionStylesRaw":{"unsupported":true,"type":"array","description":"An array of style ranges for the description, as provided by ToValue().","items":{"type":"object","description":"The style ranges for the description, as provided by ToValue().","properties":{"offset":{"type":"integer"},"type":{"type":"integer"}},"required":["offset","type"]}}},"required":["description"]}}}');

/***/ }),
/* 88 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"pageAction","description":"Use the <code>browser.pageAction</code> API to put icons inside the address bar. Page actions represent actions that can be taken on the current page, but that aren\'t applicable to all pages.","permissions":["manifest:page_action"],"functions":[{"name":"show","type":"function","async":"callback","description":"Shows the page action. The page action is shown whenever the tab is selected.","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the page action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"hide","type":"function","async":"callback","description":"Hides the page action.","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The id of the tab for which you want to modify the page action."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"isShown","type":"function","description":"Checks whether the page action is shown.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the shownness from."}},"required":["tabId"]}]},{"name":"setTitle","type":"function","description":"Sets the title of the page action. This is displayed in a tooltip over the page action.","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to modify the page action."},"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The tooltip string."}},"required":["tabId","title"]}]},{"name":"getTitle","type":"function","description":"Gets the title of the page action.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the title from."}},"required":["tabId"]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"setIcon","type":"function","description":"Sets the icon for the page action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <b>path</b> or the <b>imageData</b> property must be specified.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to modify the page action."},"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}}}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"type":"string"}}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"}},"required":["tabId"]},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"setPopup","type":"function","async":true,"description":"Sets the html document to be opened as a popup when the user clicks on the page action\'s icon.","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to modify the page action."},"popup":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The html file to show in a popup.  If set to the empty string (\'\'), no popup is shown."}},"required":["tabId","popup"]}]},{"name":"getPopup","type":"function","description":"Gets the html document set as the popup for this page action.","async":"callback","parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the popup from."}},"required":["tabId"]},{"type":"function","name":"callback","parameters":[{"name":"result","type":"string"}]}]},{"name":"openPopup","type":"function","requireUserInput":true,"description":"Opens the extension page action in the active window.","async":true,"parameters":[]}],"events":[{"name":"onClicked","type":"function","description":"Fired when a page action icon is clicked.  This event will not fire if the page action has a popup.","parameters":[{"allOf":[{"$ref":"tabs#/types/Tab"},{"name":"tab"}]},{"allOf":[{"$ref":"#/types/OnClickData"},{"name":"info","optional":true}]}]}],"definitions":{"WebExtensionManifest":{"properties":{"page_action":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"default_popup":{"type":"string","format":"relativeUrl","preprocess":"localize"},"browser_style":{"type":"boolean","description":"Deprecated in Manifest V3."},"show_matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"hide_matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPatternRestricted"}},"pinned":{"type":"boolean","default":true}}}}}},"refs":{"pageAction#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ImageDataType":{"type":"object","isInstanceOf":"ImageData","additionalProperties":{},"postprocess":"convertImageDataToURL","description":"Pixel data for an image. Must be an ImageData object (for example, from a <code>canvas</code> element)."},"OnClickData":{"type":"object","description":"Information sent when a page action is clicked.","properties":{"modifiers":{"type":"array","items":{"type":"string","enum":["Shift","Alt","Command","Ctrl","MacCtrl"]},"description":"An array of keyboard modifiers that were held while the menu item was clicked."},"button":{"type":"integer","description":"An integer value of button by which menu item was clicked."}},"required":["modifiers"]}}}');

/***/ }),
/* 89 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"permissions","functions":[{"name":"getAll","type":"function","async":"callback","description":"Get a list of all the extension\'s permissions.","parameters":[{"name":"callback","type":"function","parameters":[{"allOf":[{"$ref":"#/types/AnyPermissions"},{"name":"permissions"}]}]}]},{"name":"contains","type":"function","async":"callback","description":"Check if the extension has the given permissions.","parameters":[{"allOf":[{"$ref":"#/types/AnyPermissions"},{"name":"permissions"}]},{"name":"callback","type":"function","parameters":[{"name":"result","type":"boolean"}]}]},{"name":"request","type":"function","allowedContexts":["content"],"async":"callback","requireUserInput":true,"description":"Request the given permissions.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]},{"name":"callback","type":"function","parameters":[{"name":"granted","type":"boolean"}]}]},{"name":"remove","type":"function","async":"callback","description":"Relinquish the given permissions.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]},{"name":"callback","type":"function","parameters":[]}]}],"events":[{"name":"onAdded","type":"function","description":"Fired when the extension acquires new permissions.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]}]},{"name":"onRemoved","type":"function","description":"Fired when permissions are removed from the extension.","parameters":[{"allOf":[{"$ref":"#/types/Permissions"},{"name":"permissions"}]}]}],"definitions":{},"refs":{},"types":{"Permissions":{"type":"object","properties":{"permissions":{"type":"array","items":{"anyOf":[{"$ref":"manifest#/types/OptionalPermission"},{"$ref":"manifest#/types/OptionalOnlyPermission"}]},"default":[]},"origins":{"type":"array","items":{"$ref":"manifest#/types/MatchPattern"},"default":[]}}},"AnyPermissions":{"type":"object","properties":{"permissions":{"type":"array","items":{"anyOf":[{"$ref":"manifest#/types/Permission"},{"$ref":"manifest#/types/OptionalOnlyPermission"}]},"default":[]},"origins":{"type":"array","items":{"$ref":"manifest#/types/MatchPattern"},"default":[]}}}}}');

/***/ }),
/* 90 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"pkcs11","description":"PKCS#11 module management API","permissions":["pkcs11"],"functions":[{"name":"isModuleInstalled","type":"function","description":"checks whether a PKCS#11 module, given by name, is installed","async":true,"parameters":[{"name":"name","type":"string"}]},{"name":"installModule","type":"function","description":"Install a PKCS#11 module with a given name","async":true,"parameters":[{"name":"name","type":"string"},{"name":"flags","type":"integer","optional":true}]},{"name":"uninstallModule","type":"function","description":"Remove an installed PKCS#11 module from firefox","async":true,"parameters":[{"name":"name","type":"string"}]},{"name":"getModuleSlots","type":"function","description":"Enumerate a module\'s slots, each with their name and whether a token is present","async":true,"parameters":[{"name":"name","type":"string"}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["pkcs11"]}]}},"refs":{"pkcs11#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{}}');

/***/ }),
/* 91 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"privacy","permissions":["privacy"],"properties":{"network":{"description":"Use the <code>browser.privacy</code> API to control usage of the features in the browser that can affect a user\'s privacy.","permissions":["privacy"],"properties":{"networkPredictionEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser attempts to speed up your web browsing experience by pre-resolving DNS entries, prerendering sites (<code>&lt;link rel=\'prefetch\' ...&gt;</code>), and preemptively opening TCP and SSL connections to servers.  This preference\'s value is a boolean, defaulting to <code>true</code>."}]},"peerConnectionEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to enable and disable RTCPeerConnections (aka WebRTC)."}]},"webRTCIPHandlingPolicy":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to specify the media performance/privacy tradeoffs which impacts how WebRTC traffic will be routed and how much local address information is exposed. This preference\'s value is of type IPHandlingPolicy, defaulting to <code>default</code>."}]},"tlsVersionRestriction":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"This property controls the minimum and maximum TLS versions. This setting\'s value is an object of $(ref:tlsVersionRestrictionConfig)."}]},"httpsOnlyMode":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to query the mode for \'HTTPS-Only Mode\'. This setting\'s value is of type HTTPSOnlyModeOption, defaulting to <code>never</code>."}]},"globalPrivacyControl":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to query the status of \'Global Privacy Control\'. This setting\'s value is of type boolean, defaulting to <code>false</code>."}]}},"required":["networkPredictionEnabled","peerConnectionEnabled","webRTCIPHandlingPolicy","tlsVersionRestriction","httpsOnlyMode","globalPrivacyControl"]},"services":{"description":"Use the <code>browser.privacy</code> API to control usage of the features in the browser that can affect a user\'s privacy.","permissions":["privacy"],"properties":{"passwordSavingEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the password manager will ask if you want to save passwords. This preference\'s value is a boolean, defaulting to <code>true</code>."}]}},"required":["passwordSavingEnabled"]},"websites":{"description":"Use the <code>browser.privacy</code> API to control usage of the features in the browser that can affect a user\'s privacy.","permissions":["privacy"],"properties":{"thirdPartyCookiesAllowed":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If disabled, the browser blocks third-party sites from setting cookies. The value of this preference is of type boolean, and the default value is <code>true</code>.","unsupported":true}]},"hyperlinkAuditingEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser sends auditing pings when requested by a website (<code>&lt;a ping&gt;</code>). The value of this preference is of type boolean, and the default value is <code>true</code>."}]},"referrersEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser sends <code>referer</code> headers with your requests. Yes, the name of this preference doesn\'t match the misspelled header. No, we\'re not going to change it. The value of this preference is of type boolean, and the default value is <code>true</code>."}]},"resistFingerprinting":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser attempts to appear similar to other users by reporting generic information to websites. This can prevent websites from uniquely identifying users. Examples of data that is spoofed include number of CPU cores, precision of JavaScript timers, the local timezone, and disabling features such as GamePad support, and the WebSpeech and Navigator APIs. The value of this preference is of type boolean, and the default value is <code>false</code>."}]},"firstPartyIsolate":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"If enabled, the browser will associate all data (including cookies, HSTS data, cached images, and more) for any third party domains with the domain in the address bar. This prevents third party trackers from using directly stored information to identify you across different websites, but may break websites where you login with a third party account (such as a Facebook or Google login.) The value of this preference is of type boolean, and the default value is <code>false</code>."}]},"protectedContentEnabled":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"<strong>Available on Windows and ChromeOS only</strong>: If enabled, the browser provides a unique ID to plugins in order to run protected content. The value of this preference is of type boolean, and the default value is <code>true</code>.","unsupported":true}]},"trackingProtectionMode":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to specify the mode for tracking protection. This setting\'s value is of type TrackingProtectionModeOption, defaulting to <code>private_browsing_only</code>."}]},"cookieConfig":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Allow users to specify the default settings for allowing cookies, as well as whether all cookies should be created as non-persistent cookies. This setting\'s value is of type CookieConfig."}]}},"required":["thirdPartyCookiesAllowed","hyperlinkAuditingEnabled","referrersEnabled","resistFingerprinting","firstPartyIsolate","protectedContentEnabled","trackingProtectionMode","cookieConfig"]}},"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["privacy"]}]}},"refs":{"privacy#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"IPHandlingPolicy":{"type":"string","enum":["default","default_public_and_private_interfaces","default_public_interface_only","disable_non_proxied_udp","proxy_only"],"description":"The IP handling policy of WebRTC."},"tlsVersionRestrictionConfig":{"type":"object","description":"An object which describes TLS minimum and maximum versions.","properties":{"minimum":{"type":"string","enum":["TLSv1","TLSv1.1","TLSv1.2","TLSv1.3","unknown"],"description":"The minimum TLS version supported."},"maximum":{"type":"string","enum":["TLSv1","TLSv1.1","TLSv1.2","TLSv1.3","unknown"],"description":"The maximum TLS version supported."}}},"HTTPSOnlyModeOption":{"type":"string","enum":["always","private_browsing","never"],"description":"The mode for https-only mode."},"TrackingProtectionModeOption":{"type":"string","enum":["always","never","private_browsing"],"description":"The mode for tracking protection."},"CookieConfig":{"type":"object","description":"The settings for cookies.","properties":{"behavior":{"type":"string","enum":["allow_all","reject_all","reject_third_party","allow_visited","reject_trackers","reject_trackers_and_partition_foreign"],"description":"The type of cookies to allow."},"nonPersistentCookies":{"type":"boolean","default":false,"description":"Whether to create all cookies as nonPersistent (i.e., session) cookies.","deprecated":"This property has no effect anymore and its value is always <code>false<code>."}}}}}');

/***/ }),
/* 92 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"proxy","description":"Provides access to global proxy settings for Firefox and proxy event listeners to handle dynamic proxy implementations.","permissions":["proxy"],"properties":{"settings":{"allOf":[{"$ref":"types#/types/Setting"},{"description":"Configures proxy settings. This setting\'s value is an object of type ProxyConfig."}]}},"events":[{"name":"onRequest","type":"function","description":"Fired when proxy data is needed for a request.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"webRequest#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"requestHeaders":{"allOf":[{"$ref":"webRequest#/types/HttpHeaders"},{"description":"The HTTP request headers that are going to be sent out with this request."}]},"urlClassification":{"allOf":[{"$ref":"webRequest#/types/UrlClassification"},{"description":"Url classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","urlClassification","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"webRequest#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"type":"string","enum":["requestHeaders"]}}]},{"name":"onError","type":"function","description":"Notifies about errors caused by the invalid use of the proxy API.","parameters":[{"name":"error","type":"object"}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["proxy"]}]}},"refs":{"proxy#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"ProxyConfig":{"type":"object","description":"An object which describes proxy settings.","properties":{"proxyType":{"type":"string","enum":["none","autoDetect","system","manual","autoConfig"],"description":"The type of proxy to use."},"http":{"type":"string","description":"The address of the http proxy, can include a port."},"httpProxyAll":{"type":"boolean","description":"Use the http proxy server for all protocols."},"ftp":{"type":"string","deprecated":true,"description":"The address of the ftp proxy, can include a port.  Deprecated since Firefox 88."},"ssl":{"type":"string","description":"The address of the ssl proxy, can include a port."},"socks":{"type":"string","description":"The address of the socks proxy, can include a port."},"socksVersion":{"type":"integer","description":"The version of the socks proxy.","minimum":4,"maximum":5},"passthrough":{"type":"string","description":"A list of hosts which should not be proxied."},"autoConfigUrl":{"type":"string","description":"A URL to use to configure the proxy."},"autoLogin":{"type":"boolean","description":"Do not prompt for authentication if password is saved."},"proxyDNS":{"type":"boolean","description":"Proxy DNS when using SOCKS. DNS queries get leaked to the network when set to false. True by default for SOCKS v5. False by default for SOCKS v4."},"respectBeConservative":{"type":"boolean","default":true,"description":" If true (the default value), do not use newer TLS protocol features that might have interoperability problems on the Internet. This is intended only for use with critical infrastructure like the updates, and is only available to privileged addons."}}}}}');

/***/ }),
/* 93 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"runtime","allowedContexts":["content","devtools"],"description":"Use the <code>browser.runtime</code> API to retrieve the background page, return details about the manifest, and listen for and respond to events in the app or extension lifecycle. You can also use this API to convert the relative path of URLs to fully-qualified URLs.","properties":{"lastError":{"type":"object","optional":true,"allowedContexts":["content","devtools"],"description":"This will be defined during an API method callback if there was an error","properties":{"message":{"type":"string","description":"Details about the error which occurred."}},"additionalProperties":{}},"id":{"type":"string","allowedContexts":["content","devtools"],"description":"The ID of the extension/app."}},"functions":[{"name":"getBackgroundPage","type":"function","description":"Retrieves the JavaScript \'window\' object for the background page running inside the current extension/app. If the background page is an event page, the system will ensure it is loaded before calling the callback. If there is no background page, an error is set.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"backgroundPage","optional":true,"type":"object","isInstanceOf":"Window","additionalProperties":{},"description":"The JavaScript \'window\' object for the background page."}]}]},{"name":"getContexts","type":"function","description":"Fetches information about active contexts associated with this extension","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/ContextFilter"},{"name":"filter","description":"A filter to find matching context."}]},{"type":"function","name":"callback","parameters":[{"name":"contexts","type":"array","items":{"$ref":"#/types/ExtensionContext"},"description":"The matching contexts, if any."}]}]},{"name":"openOptionsPage","type":"function","description":"<p>Open your Extension\'s options page, if possible.</p><p>The precise behavior may depend on your manifest\'s <code>$(topic:optionsV2)[options_ui]</code> or <code>$(topic:options)[options_page]</code> key, or what the browser happens to support at the time.</p><p>If your Extension does not declare an options page, or the browser failed to create one for some other reason, the callback will set $(ref:lastError).</p>","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[],"optional":true}]},{"name":"getManifest","allowedContexts":["content","devtools"],"description":"Returns details about the app or extension from the manifest. The object returned is a serialization of the full $(topic:manifest)[manifest file].","type":"function","parameters":[],"returns":{"type":"object","properties":{},"additionalProperties":{},"description":"The manifest details."}},{"name":"getURL","type":"function","allowedContexts":["content","devtools"],"description":"Converts a relative path within an app/extension install directory to a fully-qualified URL.","parameters":[{"type":"string","name":"path","description":"A path to a resource within an app/extension expressed relative to its install directory."}],"returns":{"type":"string","description":"The fully-qualified URL to the resource."}},{"name":"getFrameId","type":"function","allowedContexts":["content","devtools"],"description":"Get the frameId of any window global or frame element.","parameters":[{"name":"target","description":"A WindowProxy or a Browsing Context container element (IFrame, Frame, Embed, Object) for the target frame."}],"allowCrossOriginArguments":true,"returns":{"type":"number","description":"The frameId of the target frame, or -1 if it doesn\'t exist."}},{"name":"setUninstallURL","type":"function","description":"Sets the URL to be visited upon uninstallation. This may be used to clean up server-side data, do analytics, and implement surveys. Maximum 1023 characters.","async":"callback","parameters":[{"type":"string","name":"url","optional":true,"maxLength":1023,"description":"URL to be opened after the extension is uninstalled. This URL must have an http: or https: scheme. Set an empty string to not open a new tab upon uninstallation."},{"type":"function","name":"callback","optional":true,"description":"Called when the uninstall URL is set. If the given URL is invalid, $(ref:runtime.lastError) will be set.","parameters":[]}]},{"name":"reload","description":"Reloads the app or extension.","type":"function","parameters":[]},{"name":"requestUpdateCheck","unsupported":true,"type":"function","description":"Requests an update check for this app/extension.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/RequestUpdateCheckStatus"},{"name":"status","description":"Result of the update check."}]},{"name":"details","type":"object","optional":true,"properties":{"version":{"type":"string","description":"The version of the available update."}},"description":"If an update is available, this contains more information about the available update.","required":["version"]}]}]},{"name":"restart","unsupported":true,"description":"Restart the device when the app runs in kiosk mode. Otherwise, it\'s no-op.","type":"function","parameters":[]},{"name":"connect","type":"function","allowedContexts":["content","devtools"],"description":"Attempts to connect to connect listeners within an extension/app (such as the background page), or other extensions/apps. This is useful for content scripts connecting to their extension processes, inter-app/extension communication, and $(topic:manifest/externally_connectable)[web messaging]. Note that this does not connect to any listeners in a content script. Extensions may connect to content scripts embedded in tabs via $(ref:tabs.connect).","parameters":[{"type":"string","name":"extensionId","optional":true,"description":"The ID of the extension or app to connect to. If omitted, a connection will be attempted with your own extension. Required if sending messages from a web page for $(topic:manifest/externally_connectable)[web messaging]."},{"type":"object","name":"connectInfo","properties":{"name":{"type":"string","description":"Will be passed into onConnect for processes that are listening for the connection event."},"includeTlsChannelId":{"type":"boolean","description":"Whether the TLS channel ID will be passed into onConnectExternal for processes that are listening for the connection event."}},"optional":true}],"returns":{"allOf":[{"$ref":"#/types/Port"},{"description":"Port through which messages can be sent and received. The port\'s $(ref:runtime.Port onDisconnect) event is fired if the extension/app does not exist. "}]}},{"name":"connectNative","type":"function","description":"Connects to a native application in the host machine.","allowedContexts":["content"],"permissions":["nativeMessaging"],"parameters":[{"type":"string","pattern":"^\\\\w+(\\\\.\\\\w+)*$","name":"application","description":"The name of the registered application to connect to."}],"returns":{"allOf":[{"$ref":"#/types/Port"},{"description":"Port through which messages can be sent and received with the application"}]}},{"name":"sendMessage","type":"function","allowAmbiguousOptionalArguments":true,"allowedContexts":["content","devtools"],"description":"Sends a single message to event listeners within your extension/app or a different extension/app. Similar to $(ref:runtime.connect) but only sends a single message, with an optional response. If sending to your extension, the $(ref:runtime.onMessage) event will be fired in each page, or $(ref:runtime.onMessageExternal), if a different extension. Note that extensions cannot send messages to content scripts using this method. To send messages to content scripts, use $(ref:tabs.sendMessage).","async":"responseCallback","parameters":[{"type":"string","name":"extensionId","optional":true,"description":"The ID of the extension/app to send the message to. If omitted, the message will be sent to your own extension/app. Required if sending messages from a web page for $(topic:manifest/externally_connectable)[web messaging]."},{"name":"message"},{"type":"object","name":"options","properties":{"includeTlsChannelId":{"type":"boolean","unsupported":true,"description":"Whether the TLS channel ID will be passed into onMessageExternal for processes that are listening for the connection event."}},"optional":true},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The JSON response object sent by the handler of the message. If an error occurs while connecting to the extension, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"sendNativeMessage","type":"function","description":"Send a single message to a native application.","allowedContexts":["content"],"permissions":["nativeMessaging"],"async":"responseCallback","parameters":[{"name":"application","description":"The name of the native messaging host.","type":"string","pattern":"^\\\\w+(\\\\.\\\\w+)*$"},{"name":"message","description":"The message that will be passed to the native messaging host."},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The response message sent by the native messaging host. If an error occurs while connecting to the native messaging host, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"getBrowserInfo","type":"function","description":"Returns information about the current browser.","async":"callback","parameters":[{"type":"function","name":"callback","description":"Called with results","parameters":[{"allOf":[{"$ref":"#/types/BrowserInfo"},{"name":"browserInfo"}]}]}]},{"name":"getPlatformInfo","type":"function","description":"Returns information about the current platform.","async":"callback","parameters":[{"type":"function","name":"callback","description":"Called with results","parameters":[{"allOf":[{"$ref":"#/types/PlatformInfo"},{"name":"platformInfo"}]}]}]},{"name":"getPackageDirectoryEntry","unsupported":true,"type":"function","description":"Returns a DirectoryEntry for the package directory.","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"name":"directoryEntry","type":"object","additionalProperties":{},"isInstanceOf":"DirectoryEntry"}]}]}],"events":[{"name":"onStartup","type":"function","description":"Fired when a profile that has this extension installed first starts up. This event is not fired for incognito profiles."},{"name":"onInstalled","type":"function","description":"Fired when the extension is first installed, when the extension is updated to a new version, and when the browser is updated to a new version.","parameters":[{"type":"object","name":"details","properties":{"reason":{"allOf":[{"$ref":"#/types/OnInstalledReason"},{"description":"The reason that this event is being dispatched."}]},"previousVersion":{"type":"string","description":"Indicates the previous version of the extension, which has just been updated. This is present only if \'reason\' is \'update\'."},"temporary":{"type":"boolean","description":"Indicates whether the addon is installed as a temporary extension."},"id":{"type":"string","unsupported":true,"description":"Indicates the ID of the imported shared module extension which updated. This is present only if \'reason\' is \'shared_module_update\'."}},"required":["reason","temporary"]}]},{"name":"onSuspend","type":"function","description":"Sent to the event page just before it is unloaded. This gives the extension opportunity to do some clean up. Note that since the page is unloading, any asynchronous operations started while handling this event are not guaranteed to complete. If more activity for the event page occurs before it gets unloaded the onSuspendCanceled event will be sent and the page won\'t be unloaded. "},{"name":"onSuspendCanceled","type":"function","description":"Sent after onSuspend to indicate that the app won\'t be unloaded after all."},{"name":"onUpdateAvailable","type":"function","description":"Fired when an update is available, but isn\'t installed immediately because the app is currently running. If you do nothing, the update will be installed the next time the background page gets unloaded, if you want it to be installed sooner you can explicitly call $(ref:runtime.reload). If your extension is using a persistent background page, the background page of course never gets unloaded, so unless you call $(ref:runtime.reload) manually in response to this event the update will not get installed until the next time the browser itself restarts. If no handlers are listening for this event, and your extension has a persistent background page, it behaves as if $(ref:runtime.reload) is called in response to this event.","parameters":[{"type":"object","name":"details","properties":{"version":{"type":"string","description":"The version number of the available update."}},"additionalProperties":{},"description":"The manifest details of the available update.","required":["version"]}]},{"name":"onBrowserUpdateAvailable","unsupported":true,"type":"function","description":"Fired when an update for the browser is available, but isn\'t installed immediately because a browser restart is required.","deprecated":"Please use $(ref:runtime.onRestartRequired).","parameters":[]},{"name":"onConnect","type":"function","allowedContexts":["content","devtools"],"description":"Fired when a connection is made from either an extension process or a content script.","parameters":[{"allOf":[{"$ref":"#/types/Port"},{"name":"port"}]}]},{"name":"onUserScriptConnect","type":"function","description":"Fired when a connection is made from a USER_SCRIPT world registered through the userScripts API.","permissions":["userScripts"],"parameters":[{"allOf":[{"$ref":"#/types/Port"},{"name":"port"}]}]},{"name":"onConnectExternal","type":"function","description":"Fired when a connection is made from another extension.","parameters":[{"allOf":[{"$ref":"#/types/Port"},{"name":"port"}]}]},{"name":"onMessage","type":"function","allowedContexts":["content","devtools"],"description":"Fired when a message is sent from either an extension process or a content script.","parameters":[{"name":"message","optional":true,"description":"The message sent by the calling script."},{"allOf":[{"$ref":"#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object. If you have more than one <code>onMessage</code> listener in the same document, then only one may send a response. This function becomes invalid when the event listener returns, unless you return true from the event listener to indicate you wish to send a response asynchronously (this will keep the message channel open to the other end until <code>sendResponse</code> is called)."}],"returns":{"type":"boolean","optional":true,"description":"Return true from the event listener if you wish to call <code>sendResponse</code> after the event listener returns."}},{"name":"onMessageExternal","type":"function","description":"Fired when a message is sent from another extension/app. Cannot be used in a content script.","parameters":[{"name":"message","optional":true,"description":"The message sent by the calling script."},{"allOf":[{"$ref":"#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object. If you have more than one <code>onMessage</code> listener in the same document, then only one may send a response. This function becomes invalid when the event listener returns, unless you return true from the event listener to indicate you wish to send a response asynchronously (this will keep the message channel open to the other end until <code>sendResponse</code> is called)."}],"returns":{"type":"boolean","optional":true,"description":"Return true from the event listener if you wish to call <code>sendResponse</code> after the event listener returns."}},{"name":"onUserScriptMessage","type":"function","description":"Fired when a message is sent from a USER_SCRIPT world registered through the userScripts API.","permissions":["userScripts"],"parameters":[{"name":"message","optional":true,"description":"The message sent by the calling script."},{"allOf":[{"$ref":"#/types/MessageSender"},{"name":"sender"}]},{"name":"sendResponse","type":"function","description":"Function to call (at most once) when you have a response. The argument should be any JSON-ifiable object. If you have more than one <code>onMessage</code> listener in the same document, then only one may send a response. This function becomes invalid when the event listener returns, unless you return true from the event listener to indicate you wish to send a response asynchronously (this will keep the message channel open to the other end until <code>sendResponse</code> is called)."}],"returns":{"type":"boolean","optional":true,"description":"Return true from the event listener if you wish to call <code>sendResponse</code> after the event listener returns."}},{"name":"onRestartRequired","unsupported":true,"type":"function","description":"Fired when an app or the device that it runs on needs to be restarted. The app should close all its windows at its earliest convenient time to let the restart to happen. If the app does nothing, a restart will be enforced after a 24-hour grace period has passed. Currently, this event is only fired for Chrome OS kiosk apps.","parameters":[{"allOf":[{"$ref":"#/types/OnRestartRequiredReason"},{"name":"reason","description":"The reason that the event is being dispatched."}]}]},{"name":"onPerformanceWarning","type":"function","description":"Fired when a runtime performance issue is detected with the extension. Observe this event to be proactively notified of runtime performance problems with the extension.","parameters":[{"type":"object","name":"details","properties":{"category":{"allOf":[{"$ref":"#/types/OnPerformanceWarningCategory"},{"description":"The performance warning event category, e.g. \'content_script\'."}]},"severity":{"allOf":[{"$ref":"#/types/OnPerformanceWarningSeverity"},{"description":"The performance warning event severity, e.g. \'high\'."}]},"tabId":{"type":"integer","description":"The $(ref:tabs.Tab) that the performance warning relates to, if any."},"description":{"type":"string","description":"An explanation of what the warning means, and hopefully how to address it."}},"required":["category","severity","description"]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["nativeMessaging"]}]}},"refs":{"runtime#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"ContextFilter":{"min_manifest_version":3,"type":"object","description":"A filter to match against existing extension context. Matching contexts must match all specified filters.","properties":{"contextIds":{"type":"array","items":{"type":"string"}},"contextTypes":{"type":"array","items":{"$ref":"#/types/ContextType"}},"documentIds":{"type":"array","items":{"type":"string"}},"documentOrigins":{"type":"array","items":{"type":"string"}},"documentUrls":{"type":"array","items":{"type":"string"}},"frameIds":{"type":"array","items":{"type":"integer"}},"tabIds":{"type":"array","items":{"type":"integer"}},"windowIds":{"type":"array","items":{"type":"integer"}},"incognito":{"type":"boolean"}}},"ContextType":{"type":"string","enum":["BACKGROUND","POPUP","SIDE_PANEL","TAB"],"description":"The type of extension view."},"ExtensionContext":{"type":"object","description":"A context hosting extension content","properties":{"contextId":{"type":"string","description":"An unique identifier associated to this context"},"contextType":{"allOf":[{"$ref":"#/types/ContextType"},{"description":"The type of the context"}]},"documentId":{"type":"string","unsupported":true,"description":"An UUID for the document associated with this context, or undefined if it is not hosted in a document"},"documentOrigin":{"type":"string","description":"The origin of the document associated with this context, or undefined if it is not hosted in a document"},"documentUrl":{"type":"string","description":"The URL of the document associated with this context, or undefined if it is not hosted in a document"},"incognito":{"type":"boolean","description":"Whether the context is associated with an private browsing context."},"frameId":{"type":"integer","description":"The frame ID for this context, or -1 if it is not hosted in a frame."},"tabId":{"type":"integer","description":"The tab ID for this context, or -1 if it is not hosted in a tab."},"windowId":{"type":"integer","description":"The window ID for this context, or -1 if it is not hosted in a window."}},"required":["contextId","contextType","incognito","frameId","tabId","windowId"]},"Port":{"type":"object","allowedContexts":["content","devtools"],"description":"An object which allows two way communication with other pages.","properties":{"name":{"type":"string"},"disconnect":{"type":"function"},"onDisconnect":{"$ref":"events#/types/Event"},"onMessage":{"$ref":"events#/types/Event"},"postMessage":{"type":"function"},"sender":{"allOf":[{"$ref":"#/types/MessageSender"},{"description":"This property will <b>only</b> be present on ports passed to onConnect/onConnectExternal listeners."}]}},"additionalProperties":{},"required":["name","disconnect","onDisconnect","onMessage","postMessage"]},"MessageSender":{"type":"object","allowedContexts":["content","devtools"],"description":"An object containing information about the script context that sent a message or request.","properties":{"tab":{"allOf":[{"$ref":"tabs#/types/Tab"},{"description":"The $(ref:tabs.Tab) which opened the connection, if any. This property will <strong>only</strong> be present when the connection was opened from a tab (including content scripts), and <strong>only</strong> if the receiver is an extension, not an app."}]},"frameId":{"type":"integer","description":"The $(topic:frame_ids)[frame] that opened the connection. 0 for top-level frames, positive for child frames. This will only be set when <code>tab</code> is set."},"id":{"type":"string","description":"The ID of the extension or app that opened the connection, if any."},"url":{"type":"string","description":"The URL of the page or frame that opened the connection. If the sender is in an iframe, it will be iframe\'s URL not the URL of the page which hosts it."},"tlsChannelId":{"unsupported":true,"type":"string","description":"The TLS channel ID of the page or frame that opened the connection, if requested by the extension or app, and if available."},"userScriptWorldId":{"type":"string","description":"The worldId of the USER_SCRIPT world that sent the message. Only present on onUserScriptMessage and onUserScriptConnect (in port.sender) events."}}},"PlatformOs":{"type":"string","allowedContexts":["content","devtools"],"description":"The operating system the browser is running on.","enum":["mac","win","android","cros","linux","openbsd"]},"PlatformArch":{"type":"string","enum":["aarch64","arm","ppc64","s390x","sparc64","x86-32","x86-64","noarch"],"allowedContexts":["content","devtools"],"description":"The machine\'s processor architecture."},"PlatformInfo":{"type":"object","allowedContexts":["content","devtools"],"description":"An object containing information about the current platform.","properties":{"os":{"allOf":[{"$ref":"#/types/PlatformOs"},{"description":"The operating system the browser is running on."}]},"arch":{"allOf":[{"$ref":"#/types/PlatformArch"},{"description":"The machine\'s processor architecture."}]},"nacl_arch":{"allOf":[{"$ref":"#/types/PlatformNaclArch"},{"unsupported":true,"description":"The native client architecture. This may be different from arch on some platforms."}]}},"required":["os","arch","nacl_arch"]},"BrowserInfo":{"type":"object","description":"An object containing information about the current browser.","properties":{"name":{"type":"string","description":"The name of the browser, for example \'Firefox\'."},"vendor":{"type":"string","description":"The name of the browser vendor, for example \'Mozilla\'."},"version":{"type":"string","description":"The browser\'s version, for example \'42.0.0\' or \'0.8.1pre\'."},"buildID":{"type":"string","description":"The browser\'s build ID/date, for example \'20160101\'."}},"required":["name","vendor","version","buildID"]},"RequestUpdateCheckStatus":{"type":"string","enum":["throttled","no_update","update_available"],"allowedContexts":["content","devtools"],"description":"Result of the update check."},"OnInstalledReason":{"type":"string","enum":["install","update","browser_update"],"allowedContexts":["content","devtools"],"description":"The reason that this event is being dispatched."},"OnRestartRequiredReason":{"type":"string","allowedContexts":["content","devtools"],"description":"The reason that the event is being dispatched. \'app_update\' is used when the restart is needed because the application is updated to a newer version. \'os_update\' is used when the restart is needed because the browser/OS is updated to a newer version. \'periodic\' is used when the system runs for more than the permitted uptime set in the enterprise policy.","enum":["app_update","os_update","periodic"]},"OnPerformanceWarningCategory":{"type":"string","enum":["content_script"],"description":"The performance warning event category, e.g. \'content_script\'."},"OnPerformanceWarningSeverity":{"type":"string","enum":["low","medium","high"],"description":"The performance warning event severity. Will be \'high\' for serious and user-visible issues."}}}');

/***/ }),
/* 94 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"scripting","description":"Use the scripting API to execute script in different contexts.","permissions":["scripting"],"functions":[{"name":"executeScript","type":"function","description":"Injects a script into a target context. The script will be run at <code>document_idle</code>.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/ScriptInjection"},{"name":"injection","description":"The details of the script which to inject."}]},{"name":"callback","type":"function","description":"Invoked upon completion of the injection. The resulting array contains the result of execution for each frame where the injection succeeded.","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/InjectionResult"}}]}]},{"name":"insertCSS","type":"function","description":"Inserts a CSS stylesheet into a target context. If multiple frames are specified, unsuccessful injections are ignored.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/CSSInjection"},{"name":"injection","description":"The details of the styles to insert."}]},{"name":"callback","type":"function","description":"Invoked upon completion of the injection.","parameters":[]}]},{"name":"removeCSS","type":"function","description":"Removes a CSS stylesheet that was previously inserted by this extension from a target context.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/CSSInjection"},{"name":"injection","description":"The details of the styles to remove. Note that the <code>css</code>, <code>files</code>, and <code>origin</code> properties must exactly match the stylesheet inserted through <code>insertCSS</code>. Attempting to remove a non-existent stylesheet is a no-op."}]},{"name":"callback","type":"function","description":"Invoked upon completion of the injection.","parameters":[]}]},{"name":"registerContentScripts","type":"function","description":"Registers one or more content scripts for this extension.","async":"callback","parameters":[{"name":"scripts","type":"array","description":"Contains a list of scripts to be registered. If there are errors during script parsing/file validation, or if the IDs specified already exist, then no scripts are registered.","items":{"$ref":"#/types/RegisteredContentScript"}},{"name":"callback","type":"function","description":"Invoked upon completion of the registration.","parameters":[]}]},{"name":"getRegisteredContentScripts","type":"function","description":"Returns all dynamically registered content scripts for this extension that match the given filter.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/ContentScriptFilter"},{"name":"filter","optional":true,"description":"An object to filter the extension\'s dynamically registered scripts."}]},{"name":"callback","type":"function","description":"The resulting array contains the registered content scripts.","parameters":[{"name":"scripts","type":"array","items":{"$ref":"#/types/RegisteredContentScript"}}]}]},{"name":"unregisterContentScripts","type":"function","description":"Unregisters one or more content scripts for this extension.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/ContentScriptFilter"},{"name":"filter","optional":true,"description":"If specified, only unregisters dynamic content scripts which match the filter. Otherwise, all of the extension\'s dynamic content scripts are unregistered."}]},{"name":"callback","type":"function","description":"Invoked upon completion of the unregistration.","parameters":[]}]},{"name":"updateContentScripts","type":"function","description":"Updates one or more content scripts for this extension.","async":"callback","parameters":[{"name":"scripts","type":"array","description":"Contains a list of scripts to be updated. If there are errors during script parsing/file validation, or if the IDs specified do not already exist, then no scripts are updated.","items":{"$merge":{"source":{"$ref":"scripting#/types/RegisteredContentScript"},"with":{"type":"object","properties":{"persistAcrossSessions":{"type":"boolean","description":"Specifies if this content script will persist into future sessions."}}}}}},{"name":"callback","type":"function","description":"Invoked when scripts have been updated.","parameters":[]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["scripting"]}]}},"refs":{"scripting#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ScriptInjection":{"type":"object","description":"Details of a script injection","properties":{"args":{"type":"array","description":"The arguments to curry into a provided function. This is only valid if the <code>func</code> parameter is specified. These arguments must be JSON-serializable.","items":{}},"files":{"type":"array","description":"The path of the JS files to inject, relative to the extension\'s root directory. Exactly one of <code>files</code> and <code>func</code> must be specified.","minItems":1,"items":{"type":"string"}},"func":{"type":"function","description":"A JavaScript function to inject. This function will be serialized, and then deserialized for injection. This means that any bound parameters and execution context will be lost. Exactly one of <code>files</code> and <code>func</code> must be specified."},"target":{"allOf":[{"$ref":"#/types/InjectionTarget"},{"description":"Details specifying the target into which to inject the script."}]},"world":{"$ref":"#/types/ExecutionWorld"},"injectImmediately":{"type":"boolean","description":"Whether the injection should be triggered in the target as soon as possible (but not necessarily prior to page load)."}},"required":["target"]},"InjectionResult":{"type":"object","description":"Result of a script injection.","properties":{"frameId":{"type":"integer","description":"The frame ID associated with the injection."},"result":{"description":"The result of the script execution."},"error":{"description":"The error property is set when the script execution failed. The value is typically an (Error) object with a message property, but could be any value (including primitives and undefined) if the script threw or rejected with such a value."}},"required":["frameId"]},"InjectionTarget":{"type":"object","properties":{"frameIds":{"type":"array","description":"The IDs of specific frames to inject into.","items":{"type":"number"}},"allFrames":{"type":"boolean","description":"Whether the script should inject into all frames within the tab. Defaults to false. This must not be true if <code>frameIds</code> is specified."},"tabId":{"type":"number","description":"The ID of the tab into which to inject."}},"required":["tabId"]},"CSSInjection":{"type":"object","properties":{"css":{"type":"string","description":"A string containing the CSS to inject. Exactly one of <code>files</code> and <code>css</code> must be specified."},"files":{"type":"array","description":"The path of the CSS files to inject, relative to the extension\'s root directory. Exactly one of <code>files</code> and <code>css</code> must be specified.","minItems":1,"items":{"type":"string"}},"origin":{"type":"string","enum":["USER","AUTHOR"],"default":"AUTHOR","description":"The style origin for the injection. Defaults to <code>\'AUTHOR\'</code>."},"target":{"allOf":[{"$ref":"#/types/InjectionTarget"},{"description":"Details specifying the target into which to inject the CSS."}]}},"required":["target"]},"ContentScriptFilter":{"type":"object","properties":{"ids":{"type":"array","description":"The IDs of specific scripts to retrieve with <code>getRegisteredContentScripts()</code> or to unregister with <code>unregisterContentScripts()</code>.","items":{"type":"string"}}}},"ExecutionWorld":{"type":"string","enum":["ISOLATED","MAIN"],"description":"The JavaScript world for a script to execute within. <code>ISOLATED</code> is the default execution environment of content scripts, <code>MAIN</code> is the web page\'s execution environment."},"RegisteredContentScript":{"type":"object","properties":{"allFrames":{"type":"boolean","description":"If specified true, it will inject into all frames, even if the frame is not the top-most frame in the tab. Each frame is checked independently for URL requirements; it will not inject into child frames if the URL requirements are not met. Defaults to false, meaning that only the top frame is matched."},"excludeMatches":{"type":"array","description":"Excludes pages that this content script would otherwise be injected into.","items":{"type":"string"}},"id":{"type":"string","description":"The id of the content script, specified in the API call."},"js":{"type":"array","description":"The list of JavaScript files to be injected into matching pages. These are injected in the order they appear in this array.","items":{"$ref":"manifest#/types/ExtensionURL"}},"matches":{"type":"array","description":"Specifies which pages this content script will be injected into. Must be specified for <code>registerContentScripts()</code>.","items":{"type":"string"}},"matchOriginAsFallback":{"type":"boolean","description":"If matchOriginAsFallback is true, then the code is also injected in about:, data:, blob: when their origin matches the pattern in \'matches\', even if the actual document origin is opaque (due to the use of CSP sandbox or iframe sandbox). Match patterns in \'matches\' must specify a wildcard path glob. By default it is <code>false</code>."},"runAt":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"description":"Specifies when JavaScript files are injected into the web page. The preferred and default value is <code>document_idle</code>."}]},"world":{"allOf":[{"$ref":"#/types/ExecutionWorld"},{"description":"The JavaScript world for a script to execute within. Defaults to \\"ISOLATED\\"."}]},"persistAcrossSessions":{"type":"boolean","default":true,"description":"Specifies if this content script will persist into future sessions. Defaults to true."},"css":{"type":"array","description":"The list of CSS files to be injected into matching pages. These are injected in the order they appear in this array.","items":{"$ref":"manifest#/types/ExtensionURL"}}},"required":["id"]}}}');

/***/ }),
/* 95 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"search","description":"Use browser.search to interact with search engines.","permissions":["search"],"functions":[{"name":"get","type":"function","description":"Gets a list of search engines.","async":true,"parameters":[]},{"name":"search","type":"function","description":"Perform a search.","async":true,"parameters":[{"type":"object","name":"searchProperties","properties":{"query":{"type":"string","description":"Terms to search for."},"engine":{"type":"string","description":"Search engine to use. Uses the default if not specified."},"disposition":{"allOf":[{"$ref":"#/types/Disposition"},{"description":"Location where search results should be displayed. NEW_TAB is the default."}]},"tabId":{"type":"integer","description":"The ID of the tab for the search results. If not specified, a new tab is created, unless disposition is set. tabId cannot be used with disposition."}},"required":["query"]}]},{"name":"query","type":"function","async":"callback","description":"Use the chrome.search API to search via the default provider.","parameters":[{"type":"object","name":"queryInfo","properties":{"text":{"type":"string","description":"String to query with the default search provider."},"disposition":{"allOf":[{"$ref":"#/types/Disposition"},{"description":"Location where search results should be displayed. CURRENT_TAB is the default."}]},"tabId":{"type":"integer","description":"Location where search results should be displayed. tabId cannot be used with disposition."}},"required":["text"]},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["search"]}]}},"refs":{"search#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"SearchEngine":{"type":"object","description":"An object encapsulating a search engine","properties":{"name":{"type":"string"},"isDefault":{"type":"boolean"},"alias":{"type":"string"},"favIconUrl":{"type":"string","format":"url"}},"required":["name","isDefault"]},"Disposition":{"type":"string","description":"Location where search results should be displayed.","enum":["CURRENT_TAB","NEW_TAB","NEW_WINDOW"]}}}');

/***/ }),
/* 96 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"sessions","description":"Use the <code>chrome.sessions</code> API to query and restore tabs and windows from a browsing session.","permissions":["sessions"],"functions":[{"name":"forgetClosedTab","type":"function","description":"Forget a recently closed tab.","async":true,"parameters":[{"name":"windowId","type":"integer","description":"The windowId of the window to which the recently closed tab to be forgotten belongs."},{"name":"sessionId","type":"string","description":"The sessionId (closedId) of the recently closed tab to be forgotten."}]},{"name":"forgetClosedWindow","type":"function","description":"Forget a recently closed window.","async":true,"parameters":[{"name":"sessionId","type":"string","description":"The sessionId (closedId) of the recently closed window to be forgotten."}]},{"name":"getRecentlyClosed","type":"function","description":"Gets the list of recently closed tabs and/or windows.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Filter"},{"name":"filter","optional":true,"default":{}}]},{"type":"function","name":"callback","parameters":[{"name":"sessions","type":"array","items":{"$ref":"#/types/Session"},"description":"The list of closed entries in reverse order that they were closed (the most recently closed tab or window will be at index <code>0</code>). The entries may contain either tabs or windows."}]}]},{"name":"getDevices","unsupported":true,"type":"function","description":"Retrieves all devices with synced sessions.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/Filter"},{"name":"filter","optional":true}]},{"type":"function","name":"callback","parameters":[{"name":"devices","type":"array","items":{"$ref":"#/types/Device"},"description":"The list of $(ref:sessions.Device) objects for each synced session, sorted in order from device with most recently modified session to device with least recently modified session. $(ref:tabs.Tab) objects are sorted by recency in the $(ref:windows.Window) of the $(ref:sessions.Session) objects."}]}]},{"name":"restore","type":"function","description":"Reopens a $(ref:windows.Window) or $(ref:tabs.Tab), with an optional callback to run when the entry has been restored.","async":"callback","parameters":[{"type":"string","name":"sessionId","optional":true,"description":"The $(ref:windows.Window.sessionId), or $(ref:tabs.Tab.sessionId) to restore. If this parameter is not specified, the most recently closed session is restored."},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Session"},{"name":"restoredSession","description":"A $(ref:sessions.Session) containing the restored $(ref:windows.Window) or $(ref:tabs.Tab) object."}]}]}]},{"name":"setTabValue","type":"function","description":"Set a key/value pair on a given tab.","async":true,"parameters":[{"type":"integer","minimum":0,"name":"tabId","description":"The id of the tab that the key/value pair is being set on."},{"type":"string","name":"key","description":"The key which corresponds to the value being set."},{"name":"value","description":"The value being set."}]},{"name":"getTabValue","type":"function","description":"Retrieve a value that was set for a given key on a given tab.","async":true,"parameters":[{"type":"integer","minimum":0,"name":"tabId","description":"The id of the tab whose value is being retrieved from."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]},{"name":"removeTabValue","type":"function","description":"Remove a key/value pair that was set on a given tab.","async":true,"parameters":[{"type":"integer","minimum":0,"name":"tabId","description":"The id of the tab whose key/value pair is being removed."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]},{"name":"setWindowValue","type":"function","description":"Set a key/value pair on a given window.","async":true,"parameters":[{"type":"integer","minimum":-2,"name":"windowId","description":"The id of the window that the key/value pair is being set on."},{"type":"string","name":"key","description":"The key which corresponds to the value being set."},{"name":"value","description":"The value being set."}]},{"name":"getWindowValue","type":"function","description":"Retrieve a value that was set for a given key on a given window.","async":true,"parameters":[{"type":"integer","minimum":-2,"name":"windowId","description":"The id of the window whose value is being retrieved from."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]},{"name":"removeWindowValue","type":"function","description":"Remove a key/value pair that was set on a given window.","async":true,"parameters":[{"type":"integer","minimum":-2,"name":"windowId","description":"The id of the window whose key/value pair is being removed."},{"type":"string","name":"key","description":"The key which corresponds to the value."}]}],"events":[{"name":"onChanged","description":"Fired when recently closed tabs and/or windows are changed. This event does not monitor synced sessions changes.","type":"function"}],"properties":{"MAX_SESSION_RESULTS":{"value":25,"description":"The maximum number of $(ref:sessions.Session) that will be included in a requested list."}},"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["sessions"]}]}},"refs":{"sessions#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"Filter":{"type":"object","properties":{"maxResults":{"type":"integer","minimum":0,"maximum":25,"description":"The maximum number of entries to be fetched in the requested list. Omit this parameter to fetch the maximum number of entries ($(ref:sessions.MAX_SESSION_RESULTS))."}}},"Session":{"type":"object","properties":{"lastModified":{"type":"integer","description":"The time when the window or tab was closed or modified, represented in milliseconds since the epoch."},"tab":{"allOf":[{"$ref":"tabs#/types/Tab"},{"description":"The $(ref:tabs.Tab), if this entry describes a tab. Either this or $(ref:sessions.Session.window) will be set."}]},"window":{"allOf":[{"$ref":"windows#/types/Window"},{"description":"The $(ref:windows.Window), if this entry describes a window. Either this or $(ref:sessions.Session.tab) will be set."}]}},"required":["lastModified"]},"Device":{"type":"object","properties":{"info":{"type":"string"},"deviceName":{"type":"string","description":"The name of the foreign device."},"sessions":{"type":"array","items":{"$ref":"#/types/Session"},"description":"A list of open window sessions for the foreign device, sorted from most recently to least recently modified session."}},"required":["info","deviceName","sessions"]}}}');

/***/ }),
/* 97 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"sidebarAction","description":"Use sidebar actions to add a sidebar to Firefox.","permissions":["manifest:sidebar_action"],"functions":[{"name":"setTitle","type":"function","description":"Sets the title of the sidebar action. This shows up in the tooltip.","async":true,"parameters":[{"name":"details","type":"object","properties":{"title":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The string the sidebar action should display when moused over."},"tabId":{"type":"integer","description":"Sets the sidebar title for the tab specified by tabId. Automatically resets when the tab is closed."},"windowId":{"type":"integer","minimum":-2,"description":"Sets the sidebar title for the window specified by windowId."}},"required":["title"]}]},{"name":"getTitle","type":"function","description":"Gets the title of the sidebar action.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the title from. If no tab nor window is specified, the global title is returned."},"windowId":{"type":"integer","minimum":-2,"description":"Specify the window to get the title from. If no tab nor window is specified, the global title is returned."}}}]},{"name":"setIcon","type":"function","description":"Sets the icon for the sidebar action. The icon can be specified either as the path to an image file or as the pixel data from a canvas element, or as dictionary of either one of those. Either the <strong>path</strong> or the <strong>imageData</strong> property must be specified.","async":true,"parameters":[{"name":"details","type":"object","properties":{"imageData":{"anyOf":[{"$ref":"#/types/ImageDataType"},{"type":"object","patternProperties":{"^[1-9]\\\\d*$":{"$ref":"#/types/ImageDataType"}},"additionalProperties":false}],"description":"Either an ImageData object or a dictionary {size -> ImageData} representing icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.imageData = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"path":{"anyOf":[{"type":"string"},{"type":"object","additionalProperties":{"type":"string"}}],"description":"Either a relative image path or a dictionary {size -> relative image path} pointing to icon to be set. If the icon is specified as a dictionary, the actual image to be used is chosen depending on screen\'s pixel density. If the number of image pixels that fit into one screen space unit equals <code>scale</code>, then image with size <code>scale</code> * 19 will be selected. Initially only scales 1 and 2 will be supported. At least one image must be specified. Note that \'details.path = foo\' is equivalent to \'details.imageData = {\'19\': foo}\'"},"tabId":{"type":"integer","description":"Sets the sidebar icon for the tab specified by tabId. Automatically resets when the tab is closed."},"windowId":{"type":"integer","minimum":-2,"description":"Sets the sidebar icon for the window specified by windowId."}}}]},{"name":"setPanel","type":"function","description":"Sets the url to the html document to be opened in the sidebar when the user clicks on the sidebar action\'s icon.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","minimum":0,"description":"Sets the sidebar url for the tab specified by tabId. Automatically resets when the tab is closed."},"windowId":{"type":"integer","minimum":-2,"description":"Sets the sidebar url for the window specified by windowId."},"panel":{"anyOf":[{"type":"string"},{"type":"null"}],"description":"The url to the html file to show in a sidebar.  If set to the empty string (\'\'), no sidebar is shown."}},"required":["panel"]}]},{"name":"getPanel","type":"function","description":"Gets the url to the html document set as the panel for this sidebar action.","async":true,"parameters":[{"name":"details","type":"object","properties":{"tabId":{"type":"integer","description":"Specify the tab to get the panel from. If no tab nor window is specified, the global panel is returned."},"windowId":{"type":"integer","minimum":-2,"description":"Specify the window to get the panel from. If no tab nor window is specified, the global panel is returned."}}}]},{"name":"open","type":"function","requireUserInput":true,"description":"Opens the extension sidebar in the active window.","async":true,"parameters":[]},{"name":"close","type":"function","requireUserInput":true,"description":"Closes the extension sidebar in the active window if the sidebar belongs to the extension.","async":true,"parameters":[]},{"name":"toggle","type":"function","requireUserInput":true,"description":"Toggles the extension sidebar in the active window.","async":true,"parameters":[]},{"name":"isOpen","type":"function","description":"Checks whether the sidebar action is open.","async":true,"parameters":[{"name":"details","type":"object","properties":{"windowId":{"type":"integer","minimum":-2,"description":"Specify the window to get the openness from."}}}]}],"definitions":{"WebExtensionManifest":{"properties":{"sidebar_action":{"type":"object","properties":{"default_title":{"type":"string","preprocess":"localize"},"default_icon":{"$ref":"manifest#/types/IconPath"},"browser_style":{"type":"boolean","description":"Defaults to true in Manifest V2; Deprecated in Manifest V3."},"default_panel":{"type":"string","format":"strictRelativeUrl","preprocess":"localize"},"open_at_install":{"type":"boolean","default":true,"description":"Whether or not the sidebar is opened at install. Default is <code>true</code>."}},"required":["default_panel"]}}}},"refs":{"sidebarAction#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"ImageDataType":{"type":"object","isInstanceOf":"ImageData","additionalProperties":{},"postprocess":"convertImageDataToURL","description":"Pixel data for an image. Must be an ImageData object (for example, from a <code>canvas</code> element)."}}}');

/***/ }),
/* 98 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"storage","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"description":"Use the <code>browser.storage</code> API to store, retrieve, and track changes to user data.","permissions":["storage"],"events":[{"name":"onChanged","type":"function","description":"Fired when one or more items change.","parameters":[{"name":"changes","type":"object","additionalProperties":{"$ref":"#/types/StorageChange"},"description":"Object mapping each key that changed to its corresponding $(ref:storage.StorageChange) for that item."},{"name":"areaName","type":"string","description":"The name of the storage area (<code>\\"sync\\"</code>, <code>\\"local\\"</code> or <code>\\"managed\\"</code>) the changes are for."}]}],"properties":{"sync":{"allOf":[{"$ref":"#/types/StorageAreaWithUsage"},{"description":"Items in the <code>sync</code> storage area are synced by the browser.","properties":{"QUOTA_BYTES":{"value":102400,"description":"The maximum total amount (in bytes) of data that can be stored in sync storage, as measured by the JSON stringification of every value plus every key\'s length. Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError)."},"QUOTA_BYTES_PER_ITEM":{"value":8192,"description":"The maximum size (in bytes) of each individual item in sync storage, as measured by the JSON stringification of its value plus its key length. Updates containing items larger than this limit will fail immediately and set $(ref:runtime.lastError)."},"MAX_ITEMS":{"value":512,"description":"The maximum number of items that can be stored in sync storage. Updates that would cause this limit to be exceeded will fail immediately and set $(ref:runtime.lastError)."},"MAX_WRITE_OPERATIONS_PER_HOUR":{"value":1800,"description":"<p>The maximum number of <code>set</code>, <code>remove</code>, or <code>clear</code> operations that can be performed each hour. This is 1 every 2 seconds, a lower ceiling than the short term higher writes-per-minute limit.</p><p>Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError).</p>"},"MAX_WRITE_OPERATIONS_PER_MINUTE":{"value":120,"description":"<p>The maximum number of <code>set</code>, <code>remove</code>, or <code>clear</code> operations that can be performed each minute. This is 2 per second, providing higher throughput than writes-per-hour over a shorter period of time.</p><p>Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError).</p>"},"MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE":{"value":1000000,"deprecated":"The storage.sync API no longer has a sustained write operation quota.","description":""}},"required":["QUOTA_BYTES","QUOTA_BYTES_PER_ITEM","MAX_ITEMS","MAX_WRITE_OPERATIONS_PER_HOUR","MAX_WRITE_OPERATIONS_PER_MINUTE","MAX_SUSTAINED_WRITE_OPERATIONS_PER_MINUTE"]}]},"local":{"allOf":[{"$ref":"#/types/StorageArea"},{"description":"Items in the <code>local</code> storage area are local to each machine.","properties":{"QUOTA_BYTES":{"value":5242880,"description":"The maximum amount (in bytes) of data that can be stored in local storage, as measured by the JSON stringification of every value plus every key\'s length. This value will be ignored if the extension has the <code>unlimitedStorage</code> permission. Updates that would cause this limit to be exceeded fail immediately and set $(ref:runtime.lastError)."}},"required":["QUOTA_BYTES"]}]},"managed":{"allOf":[{"$ref":"#/types/StorageArea"},{"description":"Items in the <code>managed</code> storage area are set by administrators or native applications, and are read-only for the extension; trying to modify this namespace results in an error.","properties":{"QUOTA_BYTES":{"value":5242880,"description":"The maximum size (in bytes) of the managed storage JSON manifest file. Files larger than this limit will fail to load."}},"required":["QUOTA_BYTES"]}]},"session":{"allOf":[{"$ref":"#/types/StorageAreaWithUsage"},{"allowedContexts":["devtools"],"description":"Items in the <code>session</code> storage area are kept in memory, and only until the either browser or extension is closed or reloaded.","properties":{"QUOTA_BYTES":{"description":"The maximum amount of data (in bytes, currently at 10MB) that can be stored in session storage, as measured by the StructuredCloneHolder of every value plus every key\'s length."}},"required":["QUOTA_BYTES"]}]}},"definitions":{},"refs":{},"types":{"StorageChange":{"type":"object","properties":{"oldValue":{"description":"The old value of the item, if there was an old value."},"newValue":{"description":"The new value of the item, if there is a new value."}}},"StorageArea":{"type":"object","functions":[{"name":"get","type":"function","description":"Gets one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"type":"object","description":"Storage items to return in the callback, where the values are replaced with those from storage if they exist.","additionalProperties":{}}],"description":"A single key to get, list of keys to get, or a dictionary specifying default values (see description of the object).  An empty list or object will return an empty result object.  Pass in <code>null</code> to get the entire contents of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with storage items, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"Object with items in their key-value mappings."}]}]},{"name":"getBytesInUse","unsupported":true,"type":"function","description":"Gets the amount of space (in bytes) being used by one or more items.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or list of keys to get the total usage for. An empty list will return 0. Pass in <code>null</code> to get the total usage of all of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with the amount of space being used by storage, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"bytesInUse","type":"integer","description":"Amount of space being used in storage, in bytes."}]}]},{"name":"set","type":"function","description":"Sets multiple items.","async":"callback","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"<p>An object which gives each key/value pair to update storage with. Any other key/value pairs in storage will not be affected.</p><p>Primitive values such as numbers will serialize as expected. Values with a <code>typeof</code> <code>\\"object\\"</code> and <code>\\"function\\"</code> will typically serialize to <code>{}</code>, with the exception of <code>Array</code> (serializes as expected), <code>Date</code>, and <code>Regex</code> (serialize using their <code>String</code> representation).</p>"},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"remove","type":"function","description":"Removes one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or a list of keys for items to remove."},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"clear","type":"function","description":"Removes all items from storage.","async":"callback","parameters":[{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]}],"events":[{"name":"onChanged","type":"function","description":"Fired when one or more items change.","parameters":[{"name":"changes","type":"object","additionalProperties":{"$ref":"#/types/StorageChange"},"description":"Object mapping each key that changed to its corresponding $(ref:storage.StorageChange) for that item."}]}]},"StorageAreaWithUsage":{"type":"object","functions":[{"name":"get","type":"function","description":"Gets one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}},{"type":"object","description":"Storage items to return in the callback, where the values are replaced with those from storage if they exist.","additionalProperties":{}}],"description":"A single key to get, list of keys to get, or a dictionary specifying default values (see description of the object).  An empty list or object will return an empty result object.  Pass in <code>null</code> to get the entire contents of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with storage items, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"Object with items in their key-value mappings."}]}]},{"name":"getBytesInUse","type":"function","description":"Gets the amount of space (in bytes) being used by one or more items.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or list of keys to get the total usage for. An empty list will return 0. Pass in <code>null</code> to get the total usage of all of storage.","optional":true},{"name":"callback","type":"function","description":"Callback with the amount of space being used by storage, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[{"name":"bytesInUse","type":"integer","description":"Amount of space being used in storage, in bytes."}]}]},{"name":"set","type":"function","description":"Sets multiple items.","async":"callback","parameters":[{"name":"items","type":"object","additionalProperties":{},"description":"<p>An object which gives each key/value pair to update storage with. Any other key/value pairs in storage will not be affected.</p><p>Primitive values such as numbers will serialize as expected. Values with a <code>typeof</code> <code>\\"object\\"</code> and <code>\\"function\\"</code> will typically serialize to <code>{}</code>, with the exception of <code>Array</code> (serializes as expected), <code>Date</code>, and <code>Regex</code> (serialize using their <code>String</code> representation).</p>"},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"remove","type":"function","description":"Removes one or more items from storage.","async":"callback","parameters":[{"name":"keys","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"A single key or a list of keys for items to remove."},{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]},{"name":"clear","type":"function","description":"Removes all items from storage.","async":"callback","parameters":[{"name":"callback","type":"function","description":"Callback on success, or on failure (in which case $(ref:runtime.lastError) will be set).","parameters":[],"optional":true}]}],"events":[{"name":"onChanged","type":"function","description":"Fired when one or more items change.","parameters":[{"name":"changes","type":"object","additionalProperties":{"$ref":"#/types/StorageChange"},"description":"Object mapping each key that changed to its corresponding $(ref:storage.StorageChange) for that item."}]}]}}}');

/***/ }),
/* 99 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"tabs","description":"Use the <code>browser.tabs</code> API to interact with the browser\'s tab system. You can use this API to create, modify, and rearrange tabs in the browser.","properties":{"TAB_ID_NONE":{"value":-1,"description":"An ID which represents the absence of a browser tab."}},"functions":[{"name":"get","type":"function","description":"Retrieves details about the specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab"}]}]}]},{"name":"getCurrent","type":"function","description":"Gets the tab that this script call is being made from. May be undefined if called from a non-tab context (for example: a background page or popup view).","async":"callback","parameters":[{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true}]}]}]},{"name":"connect","type":"function","description":"Connects to the content script(s) in the specified tab. The $(ref:runtime.onConnect) event is fired in each content script running in the specified tab for the current extension. For more details, see $(topic:messaging)[Content Script Messaging].","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"connectInfo","properties":{"name":{"type":"string","description":"Will be passed into onConnect for content scripts that are listening for the connection event."},"frameId":{"type":"integer","minimum":0,"description":"Open a port to a specific $(topic:frame_ids)[frame] identified by <code>frameId</code> instead of all frames in the tab."}},"optional":true}],"returns":{"allOf":[{"$ref":"runtime#/types/Port"},{"description":"A port that can be used to communicate with the content scripts running in the specified tab. The port\'s $(ref:runtime.Port) event is fired if the tab closes or does not exist. "}]}},{"name":"sendMessage","type":"function","description":"Sends a single message to the content script(s) in the specified tab, with an optional callback to run when a response is sent back.  The $(ref:runtime.onMessage) event is fired in each content script running in the specified tab for the current extension.","async":"responseCallback","parameters":[{"type":"integer","name":"tabId","minimum":0},{"name":"message"},{"type":"object","name":"options","properties":{"frameId":{"type":"integer","minimum":0,"description":"Send a message to a specific $(topic:frame_ids)[frame] identified by <code>frameId</code> instead of all frames in the tab."}},"optional":true},{"type":"function","name":"responseCallback","optional":true,"parameters":[{"name":"response","description":"The JSON response object sent by the handler of the message. If an error occurs while connecting to the specified tab, the callback will be called with no arguments and $(ref:runtime.lastError) will be set to the error message."}]}]},{"name":"create","type":"function","description":"Creates a new tab.","async":"callback","parameters":[{"type":"object","name":"createProperties","properties":{"windowId":{"type":"integer","minimum":-2,"description":"The window to create the new tab in. Defaults to the $(topic:current-window)[current window]."},"index":{"type":"integer","minimum":0,"description":"The position the tab should take in the window. The provided value will be clamped to between zero and the number of tabs in the window."},"url":{"type":"string","description":"The URL to navigate the tab to initially. Fully-qualified URLs must include a scheme (i.e. \'http://www.google.com\', not \'www.google.com\'). Relative URLs will be relative to the current page within the extension. Defaults to the New Tab Page."},"active":{"type":"boolean","description":"Whether the tab should become the active tab in the window. Does not affect whether the window is focused (see $(ref:windows.update)). Defaults to <var>true</var>."},"pinned":{"type":"boolean","description":"Whether the tab should be pinned. Defaults to <var>false</var>"},"openerTabId":{"type":"integer","minimum":-1,"description":"The ID of the tab that opened this tab. If specified, the opener tab must be in the same window as the newly created tab."},"cookieStoreId":{"type":"string","description":"The CookieStoreId for the tab that opened this tab."},"openInReaderMode":{"type":"boolean","description":"Whether the document in the tab should be opened in reader mode."},"discarded":{"type":"boolean","description":"Whether the tab is marked as \'discarded\' when created."},"title":{"type":"string","description":"The title used for display if the tab is created in discarded mode."},"muted":{"type":"boolean","description":"Whether the tab should be muted when created."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true,"description":"Details about the created tab. Will contain the ID of the new tab."}]}]}]},{"name":"duplicate","type":"function","description":"Duplicates a tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"description":"The ID of the tab which is to be duplicated."},{"type":"object","name":"duplicateProperties","optional":true,"properties":{"index":{"type":"integer","description":"The position the new tab should take in the window. The provided value will be clamped to between zero and the number of tabs in the window."},"active":{"type":"boolean","description":"Whether the tab should become the active tab in the window. Does not affect whether the window is focused (see $(ref:windows.update)). Defaults to <var>true</var>."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true,"description":"Details about the duplicated tab. The $(ref:tabs.Tab) object doesn\'t contain <code>url</code>, <code>title</code> and <code>favIconUrl</code> if the <code>\\"tabs\\"</code> permission has not been requested."}]}]}]},{"name":"query","type":"function","description":"Gets all tabs that have the specified properties, or all tabs if no properties are specified.","async":"callback","parameters":[{"type":"object","name":"queryInfo","properties":{"active":{"type":"boolean","description":"Whether the tabs are active in their windows."},"attention":{"type":"boolean","description":"Whether the tabs are drawing attention."},"pinned":{"type":"boolean","description":"Whether the tabs are pinned."},"audible":{"type":"boolean","description":"Whether the tabs are audible."},"autoDiscardable":{"type":"boolean","description":"Whether the tab can be discarded automatically by the browser when resources are low."},"muted":{"type":"boolean","description":"Whether the tabs are muted."},"highlighted":{"type":"boolean","description":"Whether the tabs are highlighted.  Works as an alias of active."},"currentWindow":{"type":"boolean","description":"Whether the tabs are in the $(topic:current-window)[current window]."},"lastFocusedWindow":{"type":"boolean","description":"Whether the tabs are in the last focused window."},"status":{"allOf":[{"$ref":"#/types/TabStatus"},{"description":"Whether the tabs have completed loading."}]},"discarded":{"type":"boolean","description":"True while the tabs are not loaded with content."},"hidden":{"type":"boolean","description":"True while the tabs are hidden."},"title":{"type":"string","description":"Match page titles against a pattern."},"url":{"anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}],"description":"Match tabs against one or more $(topic:match_patterns)[URL patterns]. Note that fragment identifiers are not matched."},"windowId":{"type":"integer","minimum":-2,"description":"The ID of the parent window, or $(ref:windows.WINDOW_ID_CURRENT) for the $(topic:current-window)[current window]."},"windowType":{"allOf":[{"$ref":"#/types/WindowType"},{"description":"The type of window the tabs are in."}]},"index":{"type":"integer","minimum":0,"description":"The position of the tabs within their windows."},"cookieStoreId":{"anyOf":[{"type":"array","items":{"type":"string"}},{"type":"string"}],"description":"The CookieStoreId used for the tab."},"openerTabId":{"type":"integer","minimum":-1,"description":"The ID of the tab that opened this tab. If specified, the opener tab must be in the same window as this tab."},"screen":{"anyOf":[{"type":"string","enum":["Screen","Window","Application"]},{"type":"boolean"}],"description":"True for any screen sharing, or a string to specify type of screen sharing."},"camera":{"type":"boolean","description":"True if the tab is using the camera."},"microphone":{"type":"boolean","description":"True if the tab is using the microphone."}}},{"type":"function","name":"callback","parameters":[{"name":"result","type":"array","items":{"$ref":"#/types/Tab"}}]}]},{"name":"highlight","type":"function","description":"Highlights the given tabs.","async":"callback","parameters":[{"type":"object","name":"highlightInfo","properties":{"windowId":{"type":"integer","description":"The window that contains the tabs.","minimum":-2},"populate":{"type":"boolean","default":true,"description":"If true, the $(ref:windows.Window) returned will have a <var>tabs</var> property that contains a list of the $(ref:tabs.Tab) objects. The <code>Tab</code> objects only contain the <code>url</code>, <code>title</code> and <code>favIconUrl</code> properties if the extension\'s manifest file includes the <code>\\"tabs\\"</code> permission. If false, the $(ref:windows.Window) won\'t have the <var>tabs</var> property."},"tabs":{"description":"One or more tab indices to highlight.","anyOf":[{"type":"array","items":{"type":"integer","minimum":0}},{"type":"integer"}]}},"required":["tabs"]},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"windows#/types/Window"},{"name":"window","description":"Contains details about the window whose tabs were highlighted."}]}]}]},{"name":"update","type":"function","description":"Modifies the properties of a tab. Properties that are not specified in <var>updateProperties</var> are not modified.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"Defaults to the selected tab of the $(topic:current-window)[current window]."},{"type":"object","name":"updateProperties","properties":{"url":{"type":"string","description":"A URL to navigate the tab to."},"active":{"type":"boolean","description":"Whether the tab should be active. Does not affect whether the window is focused (see $(ref:windows.update))."},"autoDiscardable":{"type":"boolean","description":"Whether the tab can be discarded automatically by the browser when resources are low."},"highlighted":{"type":"boolean","description":"Adds or removes the tab from the current selection."},"pinned":{"type":"boolean","description":"Whether the tab should be pinned."},"muted":{"type":"boolean","description":"Whether the tab should be muted."},"openerTabId":{"type":"integer","minimum":-1,"description":"The ID of the tab that opened this tab. If specified, the opener tab must be in the same window as this tab."},"loadReplace":{"type":"boolean","description":"Whether the load should replace the current history entry for the tab."},"successorTabId":{"type":"integer","minimum":-1,"description":"The ID of this tab\'s successor. If specified, the successor tab must be in the same window as this tab."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","optional":true,"description":"Details about the updated tab. The $(ref:tabs.Tab) object doesn\'t contain <code>url</code>, <code>title</code> and <code>favIconUrl</code> if the <code>\\"tabs\\"</code> permission has not been requested."}]}]}]},{"name":"move","type":"function","description":"Moves one or more tabs to a new position within its window, or to a new window. Note that tabs can only be moved to and from normal (window.type === \\"normal\\") windows.","async":"callback","parameters":[{"name":"tabIds","description":"The tab or list of tabs to move.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]},{"type":"object","name":"moveProperties","properties":{"windowId":{"type":"integer","minimum":-2,"description":"Defaults to the window the tab is currently in."},"index":{"type":"integer","minimum":-1,"description":"The position to move the window to. -1 will place the tab at the end of the window."}},"required":["index"]},{"type":"function","name":"callback","optional":true,"parameters":[{"name":"tabs","description":"Details about the moved tabs.","anyOf":[{"$ref":"#/types/Tab"},{"type":"array","items":{"$ref":"#/types/Tab"}}]}]}]},{"name":"reload","type":"function","description":"Reload a tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to reload; defaults to the selected tab of the current window."},{"type":"object","name":"reloadProperties","optional":true,"properties":{"bypassCache":{"type":"boolean","description":"Whether using any local cache. Default is false."}}},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"warmup","type":"function","description":"Warm up a tab","async":true,"parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":false,"description":"The ID of the tab to warm up."}]},{"name":"remove","type":"function","description":"Closes one or more tabs.","async":"callback","parameters":[{"name":"tabIds","description":"The tab or list of tabs to close.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"discard","type":"function","description":"discards one or more tabs.","async":true,"parameters":[{"name":"tabIds","description":"The tab or list of tabs to discard.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}]},{"name":"detectLanguage","type":"function","description":"Detects the primary language of the content in a tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"Defaults to the active tab of the $(topic:current-window)[current window]."},{"type":"function","name":"callback","parameters":[{"type":"string","name":"language","description":"An ISO language code such as <code>en</code> or <code>fr</code>. For a complete list of languages supported by this method, see <a href=\'http://src.chromium.org/viewvc/chrome/trunk/src/third_party/cld/languages/internal/languages.cc\'>kLanguageInfoTable</a>. The 2nd to 4th columns will be checked and the first non-NULL value will be returned except for Simplified Chinese for which zh-CN will be returned. For an unknown language, <code>und</code> will be returned."}]}]},{"name":"toggleReaderMode","type":"function","description":"Toggles reader mode for the document in the tab.","async":true,"parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"Defaults to the active tab of the $(topic:current-window)[current window]."}]},{"name":"captureTab","type":"function","description":"Captures an area of a specified tab. You must have $(topic:declare_permissions)[&lt;all_urls&gt;] permission to use this method.","permissions":["<all_urls>"],"async":true,"parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The tab to capture. Defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/ImageDetails"},{"name":"options","optional":true}]}]},{"name":"captureVisibleTab","type":"function","description":"Captures an area of the currently active tab in the specified window. You must have &lt;all_urls&gt; or activeTab permission to use this method.","permissions":["<all_urls>","activeTab"],"async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2,"optional":true,"description":"The target window. Defaults to the $(topic:current-window)[current window]."},{"allOf":[{"$ref":"extensionTypes#/types/ImageDetails"},{"name":"options","optional":true}]},{"type":"function","name":"callback","parameters":[{"type":"string","name":"dataUrl","description":"A data URL which encodes an image of the visible area of the captured tab. May be assigned to the \'src\' property of an HTML Image element for display."}]}]},{"name":"executeScript","type":"function","max_manifest_version":2,"description":"Injects JavaScript code into a page. For details, see the $(topic:content_scripts)[programmatic injection] section of the content scripts doc.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab in which to run the script; defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/InjectDetails"},{"name":"details","description":"Details of the script to run."}]},{"type":"function","name":"callback","optional":true,"description":"Called after all the JavaScript has been executed.","parameters":[{"name":"result","optional":true,"type":"array","items":{},"description":"The result of the script in every injected frame."}]}]},{"name":"insertCSS","type":"function","max_manifest_version":2,"description":"Injects CSS into a page. For details, see the $(topic:content_scripts)[programmatic injection] section of the content scripts doc.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab in which to insert the CSS; defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/InjectDetails"},{"name":"details","description":"Details of the CSS text to insert."}]},{"type":"function","name":"callback","optional":true,"description":"Called when all the CSS has been inserted.","parameters":[]}]},{"name":"removeCSS","type":"function","max_manifest_version":2,"description":"Removes injected CSS from a page. For details, see the $(topic:content_scripts)[programmatic injection] section of the content scripts doc.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab from which to remove the injected CSS; defaults to the active tab of the current window."},{"allOf":[{"$ref":"extensionTypes#/types/InjectDetails"},{"name":"details","description":"Details of the CSS text to remove."}]},{"type":"function","name":"callback","optional":true,"description":"Called when all the CSS has been removed.","parameters":[]}]},{"name":"setZoom","type":"function","description":"Zooms a specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to zoom; defaults to the active tab of the current window."},{"type":"number","name":"zoomFactor","description":"The new zoom factor. Use a value of 0 here to set the tab to its current default zoom factor. Values greater than zero specify a (possibly non-default) zoom factor for the tab."},{"type":"function","name":"callback","optional":true,"description":"Called after the zoom factor has been changed.","parameters":[]}]},{"name":"getZoom","type":"function","description":"Gets the current zoom factor of a specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to get the current zoom factor from; defaults to the active tab of the current window."},{"type":"function","name":"callback","description":"Called with the tab\'s current zoom factor after it has been fetched.","parameters":[{"type":"number","name":"zoomFactor","description":"The tab\'s current zoom factor."}]}]},{"name":"setZoomSettings","type":"function","description":"Sets the zoom settings for a specified tab, which define how zoom changes are handled. These settings are reset to defaults upon navigating the tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0,"description":"The ID of the tab to change the zoom settings for; defaults to the active tab of the current window."},{"allOf":[{"$ref":"#/types/ZoomSettings"},{"name":"zoomSettings","description":"Defines how zoom changes are handled and at what scope."}]},{"type":"function","name":"callback","optional":true,"description":"Called after the zoom settings have been changed.","parameters":[]}]},{"name":"getZoomSettings","type":"function","description":"Gets the current zoom settings of a specified tab.","async":"callback","parameters":[{"type":"integer","name":"tabId","optional":true,"minimum":0,"description":"The ID of the tab to get the current zoom settings from; defaults to the active tab of the current window."},{"type":"function","name":"callback","description":"Called with the tab\'s current zoom settings.","parameters":[{"allOf":[{"$ref":"#/types/ZoomSettings"},{"name":"zoomSettings","description":"The tab\'s current zoom settings."}]}]}]},{"name":"print","type":"function","description":"Prints page in active tab.","parameters":[]},{"name":"printPreview","type":"function","description":"Shows print preview for page in active tab.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"description":"Called after print preview entered.","parameters":[]}]},{"name":"saveAsPDF","type":"function","description":"Saves page in active tab as a PDF file.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/PageSettings"},{"name":"pageSettings","description":"The page settings used to save the PDF file."}]},{"type":"function","name":"callback","optional":true,"description":"Called after save as dialog closed.","parameters":[{"type":"string","name":"status","description":"Save status: saved, replaced, canceled, not_saved, not_replaced."}]}]},{"name":"show","type":"function","description":"Shows one or more tabs.","permissions":["tabHide"],"async":true,"parameters":[{"name":"tabIds","description":"The TAB ID or list of TAB IDs to show.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}]},{"name":"hide","type":"function","description":"Hides one or more tabs. The <code>\\"tabHide\\"</code> permission is required to hide tabs.  Not all tabs are hidable.  Returns an array of hidden tabs.","permissions":["tabHide"],"async":true,"parameters":[{"name":"tabIds","description":"The TAB ID or list of TAB IDs to hide.","anyOf":[{"type":"integer","minimum":0},{"type":"array","items":{"type":"integer","minimum":0}}]}]},{"name":"moveInSuccession","type":"function","async":true,"description":"Removes an array of tabs from their lines of succession and prepends or appends them in a chain to another tab.","parameters":[{"name":"tabIds","type":"array","items":{"type":"integer","minimum":0},"minItems":1,"description":"An array of tab IDs to move in the line of succession. For each tab in the array, the tab\'s current predecessors will have their successor set to the tab\'s current successor, and each tab will then be set to be the successor of the previous tab in the array. Any tabs not in the same window as the tab indicated by the second argument (or the first tab in the array, if no second argument) will be skipped."},{"name":"tabId","type":"integer","optional":true,"default":-1,"minimum":-1,"description":"The ID of a tab to set as the successor of the last tab in the array, or $(ref:tabs.TAB_ID_NONE) to leave the last tab without a successor. If options.append is true, then this tab is made the predecessor of the first tab in the array instead."},{"name":"options","type":"object","optional":true,"properties":{"append":{"type":"boolean","default":false,"description":"Whether to move the tabs before (false) or after (true) tabId in the succession. Defaults to false."},"insert":{"type":"boolean","default":false,"description":"Whether to link up the current predecessors or successor (depending on options.append) of tabId to the other side of the chain after it is prepended or appended. If true, one of the following happens: if options.append is false, the first tab in the array is set as the successor of any current predecessors of tabId; if options.append is true, the current successor of tabId is set as the successor of the last tab in the array. Defaults to false."}}}]},{"name":"goForward","type":"function","description":"Navigate to next page in tab\'s history, if available","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to navigate forward."},{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"goBack","type":"function","description":"Navigate to previous page in tab\'s history, if available.","async":"callback","parameters":[{"type":"integer","name":"tabId","minimum":0,"optional":true,"description":"The ID of the tab to navigate backward."},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"events":[{"name":"onCreated","type":"function","description":"Fired when a tab is created. Note that the tab\'s URL may not be set at the time this event fired, but you can listen to onUpdated events to be notified when a URL is set.","parameters":[{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","description":"Details of the tab that was created."}]}]},{"name":"onUpdated","type":"function","description":"Fired when a tab is updated.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"changeInfo","description":"Lists the changes to the state of the tab that was updated.","properties":{"attention":{"type":"boolean","description":"The tab\'s new attention state."},"audible":{"type":"boolean","description":"The tab\'s new audible state."},"autoDiscardable":{"type":"boolean","description":"The tab\'s new autoDiscardable state."},"discarded":{"type":"boolean","description":"True while the tab is not loaded with content."},"favIconUrl":{"type":"string","permissions":["tabs"],"description":"The tab\'s new favicon URL. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"hidden":{"type":"boolean","description":"The tab\'s new hidden state."},"isArticle":{"type":"boolean","description":"Whether the document in the tab can be rendered in reader mode."},"mutedInfo":{"allOf":[{"$ref":"#/types/MutedInfo"},{"description":"The tab\'s new muted state and the reason for the change."}]},"pinned":{"type":"boolean","description":"The tab\'s new pinned state."},"sharingState":{"allOf":[{"$ref":"#/types/SharingState"},{"description":"The tab\'s new sharing state for screen, microphone and camera."}]},"status":{"type":"string","description":"The status of the tab. Can be either <em>loading</em> or <em>complete</em>."},"title":{"type":"string","permissions":["tabs"],"description":"The title of the tab if it has changed. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"url":{"type":"string","permissions":["tabs"],"description":"The tab\'s URL if it has changed. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."}}},{"allOf":[{"$ref":"#/types/Tab"},{"name":"tab","description":"Gives the state of the tab that was updated."}]}],"extraParameters":[{"allOf":[{"$ref":"#/types/UpdateFilter"},{"name":"filter","optional":true,"description":"A set of filters that restricts the events that will be sent to this listener."}]}]},{"name":"onMoved","type":"function","description":"Fired when a tab is moved within a window. Only one move event is fired, representing the tab the user directly moved. Move events are not fired for the other tabs that must move in response. This event is not fired when a tab is moved between windows. For that, see $(ref:tabs.onDetached).","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"moveInfo","properties":{"windowId":{"type":"integer","minimum":0},"fromIndex":{"type":"integer","minimum":0},"toIndex":{"type":"integer","minimum":0}},"required":["windowId","fromIndex","toIndex"]}]},{"name":"onActivated","type":"function","description":"Fires when the active tab in a window changes. Note that the tab\'s URL may not be set at the time this event fired, but you can listen to onUpdated events to be notified when a URL is set.","parameters":[{"type":"object","name":"activeInfo","properties":{"tabId":{"type":"integer","minimum":0,"description":"The ID of the tab that has become active."},"previousTabId":{"type":"integer","minimum":0,"description":"The ID of the tab that was previously active, if that tab is still open."},"windowId":{"type":"integer","minimum":0,"description":"The ID of the window the active tab changed inside of."}},"required":["tabId","windowId"]}]},{"name":"onHighlighted","type":"function","description":"Fired when the highlighted or selected tabs in a window changes.","parameters":[{"type":"object","name":"highlightInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The window whose tabs changed."},"tabIds":{"type":"array","items":{"type":"integer","minimum":0},"description":"All highlighted tabs in the window."}},"required":["windowId","tabIds"]}]},{"name":"onDetached","type":"function","description":"Fired when a tab is detached from a window, for example because it is being moved between windows.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"detachInfo","properties":{"oldWindowId":{"type":"integer","minimum":0},"oldPosition":{"type":"integer","minimum":0}},"required":["oldWindowId","oldPosition"]}]},{"name":"onAttached","type":"function","description":"Fired when a tab is attached to a window, for example because it was moved between windows.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"attachInfo","properties":{"newWindowId":{"type":"integer","minimum":0},"newPosition":{"type":"integer","minimum":0}},"required":["newWindowId","newPosition"]}]},{"name":"onRemoved","type":"function","description":"Fired when a tab is closed.","parameters":[{"type":"integer","name":"tabId","minimum":0},{"type":"object","name":"removeInfo","properties":{"windowId":{"type":"integer","minimum":0,"description":"The window whose tab is closed."},"isWindowClosing":{"type":"boolean","description":"True when the tab is being closed because its window is being closed."}},"required":["windowId","isWindowClosing"]}]},{"name":"onReplaced","type":"function","description":"Fired when a tab is replaced with another tab due to prerendering or instant.","parameters":[{"type":"integer","name":"addedTabId","minimum":0},{"type":"integer","name":"removedTabId","minimum":0}]},{"name":"onZoomChange","type":"function","description":"Fired when a tab is zoomed.","parameters":[{"type":"object","name":"ZoomChangeInfo","properties":{"tabId":{"type":"integer","minimum":0},"oldZoomFactor":{"type":"number"},"newZoomFactor":{"type":"number"},"zoomSettings":{"$ref":"#/types/ZoomSettings"}},"required":["tabId","oldZoomFactor","newZoomFactor","zoomSettings"]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["activeTab"]}]},"OptionalPermission":{"anyOf":[{"type":"string","enum":["tabs","tabHide"]}]}},"refs":{"tabs#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"},"tabs#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"MutedInfoReason":{"type":"string","description":"An event that caused a muted state change.","enum":[{"name":"user","description":"A user input action has set/overridden the muted state."},{"name":"capture","description":"Tab capture started, forcing a muted state change."},{"name":"extension","description":"An extension, identified by the extensionId field, set the muted state."}]},"MutedInfo":{"type":"object","description":"Tab muted state and the reason for the last state change.","properties":{"muted":{"type":"boolean","description":"Whether the tab is prevented from playing sound (but hasn\'t necessarily recently produced sound). Equivalent to whether the muted audio indicator is showing."},"reason":{"allOf":[{"$ref":"#/types/MutedInfoReason"},{"description":"The reason the tab was muted or unmuted. Not set if the tab\'s mute state has never been changed."}]},"extensionId":{"type":"string","description":"The ID of the extension that changed the muted state. Not set if an extension was not the reason the muted state last changed."}},"required":["muted"]},"SharingState":{"type":"object","description":"Tab sharing state for screen, microphone and camera.","properties":{"screen":{"type":"string","description":"If the tab is sharing the screen the value will be one of \\"Screen\\", \\"Window\\", or \\"Application\\", or undefined if not screen sharing."},"camera":{"type":"boolean","description":"True if the tab is using the camera."},"microphone":{"type":"boolean","description":"True if the tab is using the microphone."}},"required":["camera","microphone"]},"Tab":{"type":"object","properties":{"id":{"type":"integer","minimum":-1,"description":"The ID of the tab. Tab IDs are unique within a browser session. Under some circumstances a Tab may not be assigned an ID, for example when querying foreign tabs using the $(ref:sessions) API, in which case a session ID may be present. Tab ID can also be set to $(ref:tabs.TAB_ID_NONE) for apps and devtools windows."},"index":{"type":"integer","minimum":-1,"description":"The zero-based index of the tab within its window."},"windowId":{"type":"integer","minimum":0,"description":"The ID of the window the tab is contained within."},"openerTabId":{"type":"integer","minimum":-1,"description":"The ID of the tab that opened this tab, if any. This property is only present if the opener tab still exists."},"highlighted":{"type":"boolean","description":"Whether the tab is highlighted. Works as an alias of active"},"active":{"type":"boolean","description":"Whether the tab is active in its window. (Does not necessarily mean the window is focused.)"},"pinned":{"type":"boolean","description":"Whether the tab is pinned."},"lastAccessed":{"type":"integer","description":"The last time the tab was accessed as the number of milliseconds since epoch."},"audible":{"type":"boolean","description":"Whether the tab has produced sound over the past couple of seconds (but it might not be heard if also muted). Equivalent to whether the speaker audio indicator is showing."},"autoDiscardable":{"type":"boolean","description":"Whether the tab can be discarded automatically by the browser when resources are low."},"mutedInfo":{"allOf":[{"$ref":"#/types/MutedInfo"},{"description":"Current tab muted state and the reason for the last state change."}]},"url":{"type":"string","permissions":["tabs"],"description":"The URL the tab is displaying. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"title":{"type":"string","permissions":["tabs"],"description":"The title of the tab. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission."},"favIconUrl":{"type":"string","permissions":["tabs"],"description":"The URL of the tab\'s favicon. This property is only present if the extension\'s manifest includes the <code>\\"tabs\\"</code> permission. It may also be an empty string if the tab is loading."},"status":{"type":"string","description":"Either <em>loading</em> or <em>complete</em>."},"discarded":{"type":"boolean","description":"True while the tab is not loaded with content."},"incognito":{"type":"boolean","description":"Whether the tab is in an incognito window."},"width":{"type":"integer","description":"The width of the tab in pixels."},"height":{"type":"integer","description":"The height of the tab in pixels."},"hidden":{"type":"boolean","description":"True if the tab is hidden."},"sessionId":{"type":"string","description":"The session ID used to uniquely identify a Tab obtained from the $(ref:sessions) API."},"cookieStoreId":{"type":"string","description":"The CookieStoreId used for the tab."},"isArticle":{"type":"boolean","description":"Whether the document in the tab can be rendered in reader mode."},"isInReaderMode":{"type":"boolean","description":"Whether the document in the tab is being rendered in reader mode."},"sharingState":{"allOf":[{"$ref":"#/types/SharingState"},{"description":"Current tab sharing state for screen, microphone and camera."}]},"attention":{"type":"boolean","description":"Whether the tab is drawing attention."},"successorTabId":{"type":"integer","minimum":-1,"description":"The ID of this tab\'s successor, if any; $(ref:tabs.TAB_ID_NONE) otherwise."}},"required":["index","highlighted","active","pinned","incognito"]},"ZoomSettingsMode":{"type":"string","description":"Defines how zoom changes are handled, i.e. which entity is responsible for the actual scaling of the page; defaults to <code>automatic</code>.","enum":[{"name":"automatic","description":"Zoom changes are handled automatically by the browser."},{"name":"manual","description":"Overrides the automatic handling of zoom changes. The <code>onZoomChange</code> event will still be dispatched, and it is the responsibility of the extension to listen for this event and manually scale the page. This mode does not support <code>per-origin</code> zooming, and will thus ignore the <code>scope</code> zoom setting and assume <code>per-tab</code>."},{"name":"disabled","description":"Disables all zooming in the tab. The tab will revert to the default zoom level, and all attempted zoom changes will be ignored."}]},"ZoomSettingsScope":{"type":"string","description":"Defines whether zoom changes will persist for the page\'s origin, or only take effect in this tab; defaults to <code>per-origin</code> when in <code>automatic</code> mode, and <code>per-tab</code> otherwise.","enum":[{"name":"per-origin","description":"Zoom changes will persist in the zoomed page\'s origin, i.e. all other tabs navigated to that same origin will be zoomed as well. Moreover, <code>per-origin</code> zoom changes are saved with the origin, meaning that when navigating to other pages in the same origin, they will all be zoomed to the same zoom factor. The <code>per-origin</code> scope is only available in the <code>automatic</code> mode."},{"name":"per-tab","description":"Zoom changes only take effect in this tab, and zoom changes in other tabs will not affect the zooming of this tab. Also, <code>per-tab</code> zoom changes are reset on navigation; navigating a tab will always load pages with their <code>per-origin</code> zoom factors."}]},"ZoomSettings":{"type":"object","description":"Defines how zoom changes in a tab are handled and at what scope.","properties":{"mode":{"allOf":[{"$ref":"#/types/ZoomSettingsMode"},{"description":"Defines how zoom changes are handled, i.e. which entity is responsible for the actual scaling of the page; defaults to <code>automatic</code>."}]},"scope":{"allOf":[{"$ref":"#/types/ZoomSettingsScope"},{"description":"Defines whether zoom changes will persist for the page\'s origin, or only take effect in this tab; defaults to <code>per-origin</code> when in <code>automatic</code> mode, and <code>per-tab</code> otherwise."}]},"defaultZoomFactor":{"type":"number","description":"Used to return the default zoom level for the current tab in calls to tabs.getZoomSettings."}}},"PageSettings":{"type":"object","description":"Defines the page settings to be used when saving a page as a pdf file.","properties":{"toFileName":{"type":"string","description":"The name of the file. May include optional .pdf extension."},"paperSizeUnit":{"type":"integer","description":"The page size unit: 0 = inches, 1 = millimeters. Default: 0."},"paperWidth":{"type":"number","description":"The paper width in paper size units. Default: 8.5."},"paperHeight":{"type":"number","description":"The paper height in paper size units. Default: 11.0."},"orientation":{"type":"integer","description":"The page content orientation: 0 = portrait, 1 = landscape. Default: 0."},"scaling":{"type":"number","description":"The page content scaling factor: 1.0 = 100% = normal size. Default: 1.0."},"shrinkToFit":{"type":"boolean","description":"Whether the page content should shrink to fit the page width (overrides scaling). Default: true."},"showBackgroundColors":{"type":"boolean","description":"Whether the page background colors should be shown. Default: false."},"showBackgroundImages":{"type":"boolean","description":"Whether the page background images should be shown. Default: false."},"edgeLeft":{"type":"number","description":"The spacing between the left header/footer and the left edge of the paper (inches). Default: 0."},"edgeRight":{"type":"number","description":"The spacing between the right header/footer and the right edge of the paper (inches). Default: 0."},"edgeTop":{"type":"number","description":"The spacing between the top of the headers and the top edge of the paper (inches). Default: 0"},"edgeBottom":{"type":"number","description":"The spacing between the bottom of the footers and the bottom edge of the paper (inches). Default: 0."},"marginLeft":{"type":"number","description":"The margin between the page content and the left edge of the paper (inches). Default: 0.5."},"marginRight":{"type":"number","description":"The margin between the page content and the right edge of the paper (inches). Default: 0.5."},"marginTop":{"type":"number","description":"The margin between the page content and the top edge of the paper (inches). Default: 0.5."},"marginBottom":{"type":"number","description":"The margin between the page content and the bottom edge of the paper (inches). Default: 0.5."},"headerLeft":{"type":"string","description":"The text for the page\'s left header. Default: \'&T\'."},"headerCenter":{"type":"string","description":"The text for the page\'s center header. Default: \'\'."},"headerRight":{"type":"string","description":"The text for the page\'s right header. Default: \'&U\'."},"footerLeft":{"type":"string","description":"The text for the page\'s left footer. Default: \'&PT\'."},"footerCenter":{"type":"string","description":"The text for the page\'s center footer. Default: \'\'."},"footerRight":{"type":"string","description":"The text for the page\'s right footer. Default: \'&D\'."}}},"TabStatus":{"type":"string","enum":["loading","complete"],"description":"Whether the tabs have completed loading."},"WindowType":{"type":"string","enum":["normal","popup","panel","app","devtools"],"description":"The type of window."},"UpdatePropertyName":{"type":"string","enum":["attention","audible","autoDiscardable","discarded","favIconUrl","hidden","isArticle","mutedInfo","pinned","sharingState","status","title","url"],"description":"Event names supported in onUpdated."},"UpdateFilter":{"type":"object","description":"An object describing filters to apply to tabs.onUpdated events.","properties":{"urls":{"type":"array","description":"A list of URLs or URL patterns. Events that cannot match any of the URLs will be filtered out.  Filtering with urls requires the <code>\\"tabs\\"</code> or  <code>\\"activeTab\\"</code> permission.","items":{"type":"string"},"minItems":1},"properties":{"type":"array","description":"A list of property names. Events that do not match any of the names will be filtered out.","items":{"$ref":"#/types/UpdatePropertyName"},"minItems":1},"tabId":{"type":"integer"},"windowId":{"type":"integer"}}}}}');

/***/ }),
/* 100 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"telemetry","description":"Use the <code>browser.telemetry</code> API to send telemetry data to the Mozilla Telemetry service. Restricted to Mozilla privileged webextensions.","permissions":["telemetry"],"functions":[{"name":"submitPing","type":"function","description":"Submits a custom ping to the Telemetry back-end. See <code>submitExternalPing</code> inside TelemetryController.sys.mjs for more details.","async":true,"parameters":[{"name":"type","type":"string","pattern":"^[a-z0-9][a-z0-9-]+[a-z0-9]$","description":"The type of the ping."},{"name":"message","type":"object","additionalProperties":{},"description":"The data payload for the ping."},{"description":"Options object.","name":"options","type":"object","properties":{"addClientId":{"type":"boolean","default":false,"description":"True if the ping should contain the client id."},"addEnvironment":{"type":"boolean","default":false,"description":"True if the ping should contain the environment data."},"overrideEnvironment":{"type":"object","additionalProperties":{},"default":false,"description":"Set to override the environment data."},"usePingSender":{"type":"boolean","default":false,"description":"If true, send the ping using the PingSender."}}}]},{"name":"canUpload","type":"function","description":"Checks if Telemetry upload is enabled.","parameters":[],"async":true},{"name":"scalarAdd","deprecated":"`scalarAdd` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Adds the value to the given scalar.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"value","type":"integer","minimum":1,"description":"The numeric value to add to the scalar. Only unsigned integers supported."}]},{"name":"scalarSet","deprecated":"`scalarSet` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Sets the named scalar to the given value. Throws if the value type doesn\'t match the scalar type.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name"},{"name":"value","description":"The value to set the scalar to","anyOf":[{"type":"string"},{"type":"boolean"},{"type":"integer"},{"type":"object","additionalProperties":{}}]}]},{"name":"scalarSetMaximum","deprecated":"`scalarSetMaximum` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Sets the scalar to the maximum of the current and the passed value","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"value","type":"integer","minimum":0,"description":"The numeric value to set the scalar to. Only unsigned integers supported."}]},{"name":"keyedScalarAdd","deprecated":"`keyedScalarAdd` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Adds the value to the given keyed scalar.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name"},{"name":"key","type":"string","description":"The key name"},{"name":"value","type":"integer","minimum":1,"description":"The numeric value to add to the scalar. Only unsigned integers supported."}]},{"name":"keyedScalarSet","deprecated":"`keyedScalarSet` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Sets the keyed scalar to the given value. Throws if the value type doesn\'t match the scalar type.","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"key","type":"string","description":"The key name."},{"name":"value","description":"The value to set the scalar to.","anyOf":[{"type":"string"},{"type":"boolean"},{"type":"integer"},{"type":"object","additionalProperties":{}}]}]},{"name":"keyedScalarSetMaximum","deprecated":"`keyedScalarSetMaximum` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Sets the keyed scalar to the maximum of the current and the passed value","async":true,"parameters":[{"name":"name","type":"string","description":"The scalar name."},{"name":"key","type":"string","description":"The key name."},{"name":"value","type":"integer","minimum":0,"description":"The numeric value to set the scalar to. Only unsigned integers supported."}]},{"name":"recordEvent","deprecated":"`recordEvent` is a no-op since Firefox 132 (see bug 1894533)","type":"function","description":"Record an event in Telemetry. Throws when trying to record an unknown event.","async":true,"parameters":[{"name":"category","type":"string","description":"The category name."},{"name":"method","type":"string","description":"The method name."},{"name":"object","type":"string","description":"The object name."},{"name":"value","type":"string","optional":true,"description":"An optional string value to record."},{"name":"extra","type":"object","optional":true,"description":"An optional object of the form (string -> string). It should only contain registered extra keys.","additionalProperties":{"type":"string"}}]},{"name":"registerScalars","deprecated":"`registerScalars` is a no-op since Firefox 134 (see bug 1930196)","type":"function","description":"Register new scalars to record them from addons. See nsITelemetry.idl for more details.","async":true,"parameters":[{"name":"category","type":"string","description":"The unique category the scalars are registered in."},{"name":"data","type":"object","additionalProperties":{"$ref":"#/types/ScalarData"},"description":"An object that contains registration data for multiple scalars. Each property name is the scalar name, and the corresponding property value is an object of ScalarData type."}]},{"name":"registerEvents","deprecated":"`registerEvents` is a no-op since Firefox 132 (see bug 1894533)","type":"function","description":"Register new events to record them from addons. See nsITelemetry.idl for more details.","async":true,"parameters":[{"name":"category","type":"string","description":"The unique category the events are registered in."},{"name":"data","type":"object","additionalProperties":{"$ref":"#/types/EventData"},"description":"An object that contains registration data for 1+ events. Each property name is the category name, and the corresponding property value is an object of EventData type."}]},{"name":"setEventRecordingEnabled","deprecated":"`setEventRecordingEnabled` is a no-op since Firefox 133 (see bug 1920562)","type":"function","description":"Enable recording of events in a category. Events default to recording enabled. This allows to toggle recording for all events in the specified category.","async":true,"parameters":[{"name":"category","type":"string","description":"The category name."},{"name":"enabled","type":"boolean","description":"Whether recording is enabled for events in that category."}]}],"definitions":{"PermissionPrivileged":{"anyOf":[{"type":"string","enum":["telemetry"]}]}},"refs":{"telemetry#/definitions/PermissionPrivileged":{"namespace":"manifest","type":"PermissionPrivileged"}},"types":{"ScalarType":{"type":"string","enum":["count","string","boolean"],"description":"Type of scalar: \'count\' for numeric values, \'string\' for string values, \'boolean\' for boolean values. Maps to <code>nsITelemetry.SCALAR_TYPE_*</code>."},"ScalarData":{"type":"object","description":"Represents registration data for a Telemetry scalar.","properties":{"kind":{"$ref":"#/types/ScalarType"},"keyed":{"type":"boolean","default":false,"description":"True if this is a keyed scalar."},"record_on_release":{"type":"boolean","default":false,"description":"True if this data should be recorded on release."},"expired":{"type":"boolean","default":false,"description":"True if this scalar entry is expired. This allows recording it without error, but it will be discarded."}},"required":["kind"]},"EventData":{"type":"object","description":"Represents registration data for a Telemetry event.","properties":{"methods":{"type":"array","items":{"type":"string"},"description":"List of methods for this event entry."},"objects":{"type":"array","items":{"type":"string"},"description":"List of objects for this event entry."},"extra_keys":{"type":"array","items":{"type":"string"},"description":"List of allowed extra keys for this event entry."},"record_on_release":{"type":"boolean","default":false,"description":"True if this data should be recorded on release."},"expired":{"type":"boolean","default":false,"description":"True if this event entry is expired. This allows recording it without error, but it will be discarded."}},"required":["methods","objects","extra_keys"]}}}');

/***/ }),
/* 101 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"test","allowedContexts":["content","devtools"],"defaultContexts":["content","devtools"],"description":"none","functions":[{"name":"withHandlingUserInput","type":"function","description":"Calls the callback function wrapped with user input set.  This is only used for internal unit testing.","parameters":[{"type":"function","name":"callback"}]},{"name":"notifyFail","type":"function","description":"Notifies the browser process that test code running in the extension failed.  This is only used for internal unit testing.","parameters":[{"type":"string","name":"message"}]},{"name":"notifyPass","type":"function","description":"Notifies the browser process that test code running in the extension passed.  This is only used for internal unit testing.","parameters":[{"type":"string","name":"message","optional":true}]},{"name":"log","type":"function","description":"Logs a message during internal unit testing.","parameters":[{"type":"string","name":"message"}]},{"name":"sendMessage","type":"function","description":"Sends a string message to the browser process, generating a Notification that C++ test code can wait for.","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"arg1","optional":true},{"name":"arg2","optional":true}]},{"name":"fail","type":"function","parameters":[{"name":"message","optional":true}]},{"name":"succeed","type":"function","parameters":[{"name":"message","optional":true}]},{"name":"assertTrue","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"test","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertFalse","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"test","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertBool","type":"function","unsupported":true,"parameters":[{"name":"test","anyOf":[{"type":"string"},{"type":"boolean"}]},{"type":"boolean","name":"expected"},{"type":"string","name":"message","optional":true}]},{"name":"assertDeepEq","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"expected"},{"name":"actual"},{"type":"string","name":"message","optional":true}]},{"name":"assertEq","type":"function","allowAmbiguousOptionalArguments":true,"parameters":[{"name":"expected","optional":true},{"name":"actual","optional":true},{"type":"string","name":"message","optional":true}]},{"name":"assertNoLastError","type":"function","unsupported":true,"parameters":[]},{"name":"assertLastError","type":"function","unsupported":true,"parameters":[{"type":"string","name":"expectedError"}]},{"name":"assertRejects","type":"function","async":true,"parameters":[{"allOf":[{"$ref":"#/types/Promise"},{"name":"promise"}]},{"allOf":[{"$ref":"#/types/ExpectedError"},{"name":"expectedError"}]},{"name":"message","type":"string","optional":true}]},{"name":"assertThrows","type":"function","parameters":[{"name":"func","type":"function"},{"allOf":[{"$ref":"#/types/ExpectedError"},{"name":"expectedError"}]},{"name":"message","type":"string","optional":true}]}],"events":[{"name":"onMessage","type":"function","description":"Used to test sending messages to extensions.","parameters":[{"type":"string","name":"message"},{"name":"argument"}]}],"definitions":{},"refs":{},"types":{"ExpectedError":{"anyOf":[{"type":"string"},{"type":"object","isInstanceOf":"RegExp","additionalProperties":true},{"type":"function"}]},"Promise":{"anyOf":[{"type":"object","properties":{"then":{"type":"function"}},"additionalProperties":true,"required":["then"]},{"type":"object","isInstanceOf":"Promise","additionalProperties":true}]}}}');

/***/ }),
/* 102 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"topSites","description":"Use the chrome.topSites API to access the top sites that are displayed on the new tab page. ","permissions":["topSites"],"functions":[{"name":"get","type":"function","description":"Gets a list of top sites.","async":"callback","parameters":[{"type":"object","name":"options","properties":{"providers":{"type":"array","items":{"type":"string"},"deprecated":"Please use the other options to tune the results received from topSites.","default":[]},"limit":{"type":"integer","default":12,"maximum":100,"minimum":1,"description":"The number of top sites to return, defaults to the value used by Firefox"},"onePerDomain":{"type":"boolean","default":true,"description":"Limit the result to a single top site link per domain"},"includeBlocked":{"type":"boolean","default":false,"description":"Include sites that the user has blocked from appearing on the Firefox new tab."},"includeFavicon":{"type":"boolean","default":false,"description":"Include sites favicon if available."},"includePinned":{"type":"boolean","default":false,"description":"Include sites that the user has pinned on the Firefox new tab."},"includeSearchShortcuts":{"type":"boolean","default":false,"description":"Include search shortcuts appearing on the Firefox new tab."},"newtab":{"type":"boolean","default":false,"description":"Return the sites that exactly appear on the user\'s new-tab page. When true, all other options are ignored except limit and includeFavicon. If the user disabled newtab Top Sites, the newtab parameter will be ignored."}},"default":{},"optional":true},{"name":"callback","type":"function","parameters":[{"name":"results","type":"array","items":{"$ref":"#/types/MostVisitedURL"}}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["topSites"]}]}},"refs":{"topSites#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"MostVisitedURL":{"type":"object","description":"An object encapsulating a most visited URL, such as the URLs on the new tab page.","properties":{"url":{"type":"string","description":"The most visited URL."},"title":{"type":"string","description":"The title of the page."},"favicon":{"type":"string","description":"Data URL for the favicon, if available."},"type":{"type":"string","enum":["url","search"],"default":"url","description":"The entry type, either <code>url</code> for a normal page link, or <code>search</code> for a search shortcut."}},"required":["url"]}}}');

/***/ }),
/* 103 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"trial","allowedContexts":["content"],"permissions":["trialML"],"properties":{"ml":{"description":"Use the trial ML API to run Machine Learning models requests from extensions pages or content scripts.","allowedContexts":["content"],"permissions":["trialML"],"events":[{"name":"onProgress","type":"function","allowedContexts":["content"],"description":"Events from the inference engine.","parameters":[{"name":"progressData","description":"Object containing the data, see https://firefox-source-docs.mozilla.org/toolkit/components/ml/notifications.html","type":"object"}]}],"functions":[{"name":"createEngine","type":"function","description":"Prepare the inference engine","async":true,"parameters":[{"allOf":[{"$ref":"#/types/CreateEngineRequest"},{"name":"CreateEngineRequest"}]}]},{"name":"runEngine","type":"function","allowedContexts":["content"],"description":"Call the inference engine","async":true,"parameters":[{"allOf":[{"$ref":"#/types/RunEngineRequest"},{"name":"RunEngineRequest"}]}]},{"name":"deleteCachedModels","type":"function","allowedContexts":["content"],"description":"Delete the models the extension downloaded.","async":true}]}},"definitions":{"OptionalOnlyPermission":{"anyOf":[{"type":"string","enum":["trialML"]}]}},"refs":{"trial#/definitions/OptionalOnlyPermission":{"namespace":"manifest","type":"OptionalOnlyPermission"}},"types":{"CreateEngineRequest":{"type":"object","additionalProperties":true},"RunEngineRequest":{"type":"object","additionalProperties":true}}}');

/***/ }),
/* 104 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"types","description":"Contains types used by other schemas.","definitions":{},"refs":{},"types":{"SettingScope":{"type":"string","enum":["regular","regular_only","incognito_persistent","incognito_session_only"],"description":"The scope of the Setting. One of<ul><li><var>regular</var>: setting for the regular profile (which is inherited by the incognito profile if not overridden elsewhere),</li><li><var>regular_only</var>: setting for the regular profile only (not inherited by the incognito profile),</li><li><var>incognito_persistent</var>: setting for the incognito profile that survives browser restarts (overrides regular preferences),</li><li><var>incognito_session_only</var>: setting for the incognito profile that can only be set during an incognito session and is deleted when the incognito session ends (overrides regular and incognito_persistent preferences).</li></ul> Only <var>regular</var> is supported by Firefox at this time."},"LevelOfControl":{"type":"string","enum":["not_controllable","controlled_by_other_extensions","controllable_by_this_extension","controlled_by_this_extension"],"description":"One of<ul><li><var>not_controllable</var>: cannot be controlled by any extension</li><li><var>controlled_by_other_extensions</var>: controlled by extensions with higher precedence</li><li><var>controllable_by_this_extension</var>: can be controlled by this extension</li><li><var>controlled_by_this_extension</var>: controlled by this extension</li></ul>"},"Setting":{"type":"object","functions":[{"name":"get","type":"function","description":"Gets the value of a setting.","async":"callback","parameters":[{"name":"details","type":"object","description":"Which setting to consider.","properties":{"incognito":{"type":"boolean","description":"Whether to return the value that applies to the incognito session (default false)."}}},{"name":"callback","type":"function","parameters":[{"name":"details","type":"object","description":"Details of the currently effective value.","properties":{"value":{"description":"The value of the setting."},"levelOfControl":{"allOf":[{"$ref":"types#/types/LevelOfControl"},{"description":"The level of control of the setting."}]},"incognitoSpecific":{"description":"Whether the effective value is specific to the incognito session.<br/>This property will <em>only</em> be present if the <var>incognito</var> property in the <var>details</var> parameter of <code>get()</code> was true.","type":"boolean"}},"required":["value","levelOfControl"]}]}]},{"name":"set","type":"function","description":"Sets the value of a setting.","async":"callback","parameters":[{"name":"details","type":"object","description":"Which setting to change.","properties":{"value":{"description":"The value of the setting. <br/>Note that every setting has a specific value type, which is described together with the setting. An extension should <em>not</em> set a value of a different type."},"scope":{"allOf":[{"$ref":"types#/types/SettingScope"},{"description":"Where to set the setting (default: regular)."}]}},"required":["value"]},{"name":"callback","type":"function","description":"Called at the completion of the set operation.","optional":true,"parameters":[]}]},{"name":"clear","type":"function","description":"Clears the setting, restoring any default value.","async":"callback","parameters":[{"name":"details","type":"object","description":"Which setting to clear.","properties":{"scope":{"allOf":[{"$ref":"types#/types/SettingScope"},{"description":"Where to clear the setting (default: regular)."}]}}},{"name":"callback","type":"function","description":"Called at the completion of the clear operation.","optional":true,"parameters":[]}]}],"events":[{"name":"onChange","type":"function","description":"Fired after the setting changes.","parameters":[{"type":"object","name":"details","properties":{"value":{"description":"The value of the setting after the change."},"levelOfControl":{"allOf":[{"$ref":"types#/types/LevelOfControl"},{"description":"The level of control of the setting."}]},"incognitoSpecific":{"description":"Whether the value that has changed is specific to the incognito session.<br/>This property will <em>only</em> be present if the user has enabled the extension in incognito mode.","type":"boolean"}},"required":["value","levelOfControl"]}]}]}}}');

/***/ }),
/* 105 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"url_overrides","definitions":{"WebExtensionManifest":{"properties":{"chrome_url_overrides":{"type":"object","properties":{"newtab":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"preprocess":"localize"}]},"bookmarks":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"unsupported":true,"preprocess":"localize"}]},"history":{"allOf":[{"$ref":"manifest#/types/ExtensionURL"},{"unsupported":true,"preprocess":"localize"}]}}}}}},"refs":{"url_overrides#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{}}');

/***/ }),
/* 106 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"userScripts","permissions":["manifest:user_scripts","userScripts"],"functions":[{"name":"register","max_manifest_version":2,"type":"function","description":"Register a user script programmatically given its $(ref:userScripts.UserScriptOptions), and resolves to an object with the unregister() function","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/UserScriptOptions"},{"name":"userScriptOptions"}]},{"name":"callback","type":"function","parameters":[{"name":"legacyRegisteredUserScript","type":"object","description":"An object that represents a user script registered programmatically","properties":{"unregister":{"type":"function","description":"Unregister a user script registered programmatically","async":true,"parameters":[]}},"required":["unregister"]}]}]},{"name":"register","min_manifest_version":3,"type":"function","description":"Registers one or more user scripts for this extension.","async":true,"parameters":[{"name":"scripts","type":"array","items":{"$ref":"#/types/RegisteredUserScript"},"description":"List of user scripts to be registered."}]},{"name":"update","min_manifest_version":3,"type":"function","description":"Updates one or more user scripts for this extension.","async":true,"parameters":[{"name":"scripts","type":"array","items":{"$merge":{"source":{"$ref":"userScripts#/types/RegisteredUserScript"},"with":{"type":"object","properties":{"js":{"type":"array","items":{"$ref":"#/types/ScriptSource"}}}}}},"description":"List of user scripts to be updated."}]},{"name":"unregister","min_manifest_version":3,"type":"function","description":"Unregisters all dynamically-registered user scripts for this extension.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/UserScriptFilter"},{"name":"filter","optional":true,"description":"If specified, this method unregisters only the user scripts that match it."}]}]},{"name":"getScripts","min_manifest_version":3,"type":"function","description":"Returns all dynamically-registered user scripts for this extension.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/UserScriptFilter"},{"name":"filter","optional":true,"description":"If specified, this method returns only the user scripts that match it."}]},{"name":"callback","type":"function","parameters":[{"name":"scripts","type":"array","items":{"$ref":"#/types/RegisteredUserScript"},"description":"List of registered user scripts."}]}]},{"name":"configureWorld","min_manifest_version":3,"type":"function","description":"Configures the environment for scripts running in a USER_SCRIPT world.","async":true,"parameters":[{"allOf":[{"$ref":"#/types/WorldProperties"},{"name":"properties","description":"The desired configuration for a USER_SCRIPT world."}]}]},{"name":"resetWorldConfiguration","min_manifest_version":3,"type":"function","description":"Resets the configuration for a given world. That world will fall back to the default world\'s configuration.","async":true,"parameters":[{"name":"worldId","type":"string","optional":true,"default":"","description":"The ID of the USER_SCRIPT world to reset. If omitted or empty, resets the default world\'s configuration."}]},{"name":"getWorldConfigurations","min_manifest_version":3,"type":"function","description":"Returns all registered USER_SCRIPT world configurations.","async":"callback","parameters":[{"name":"callback","type":"function","parameters":[{"name":"configurations","type":"array","items":{"$ref":"#/types/WorldProperties"},"description":"All configurations registered with configureWorld()."}]}]}],"definitions":{"OptionalOnlyPermission":{"anyOf":[{"type":"string","enum":["userScripts"]}]},"WebExtensionManifest":{"properties":{"user_scripts":{"type":"object","max_manifest_version":2,"properties":{"api_script":{"$ref":"manifest#/types/ExtensionURL"}}}}}},"refs":{"userScripts#/definitions/OptionalOnlyPermission":{"namespace":"manifest","type":"OptionalOnlyPermission"},"userScripts#/definitions/WebExtensionManifest":{"namespace":"manifest","type":"WebExtensionManifest"}},"types":{"UserScriptOptions":{"max_manifest_version":2,"type":"object","description":"Details of a user script","properties":{"js":{"type":"array","description":"The list of JS files to inject","minItems":1,"items":{"$ref":"extensionTypes#/types/ExtensionFileOrCode"}},"scriptMetadata":{"allOf":[{"$ref":"extensionTypes#/types/PlainJSONValue"},{"description":"An opaque user script metadata value"}]},"matches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"excludeMatches":{"type":"array","minItems":1,"items":{"$ref":"manifest#/types/MatchPattern"}},"includeGlobs":{"type":"array","items":{"type":"string"}},"excludeGlobs":{"type":"array","items":{"type":"string"}},"allFrames":{"type":"boolean","default":false,"description":"If allFrames is <code>true</code>, implies that the JavaScript should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"matchAboutBlank":{"type":"boolean","default":false,"description":"If matchAboutBlank is true, then the code is also injected in about:blank and about:srcdoc frames if your extension has access to its parent document. Code cannot be inserted in top-level about:-frames. By default it is <code>false</code>."},"runAt":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"default":"document_idle","description":"The soonest that the JavaScript will be injected into the tab. Defaults to \\"document_idle\\"."}]},"cookieStoreId":{"anyOf":[{"type":"array","minItems":1,"items":{"type":"string"}},{"type":"string"}],"description":"limit the set of matched tabs to those that belong to the given cookie store id"}},"required":["js","matches"]},"RegisteredUserScript":{"min_manifest_version":3,"type":"object","description":"An object that represents a user script registered programmatically","properties":{"id":{"type":"string","description":"The ID of the user script specified in the API call. This property must not start with a \'_\' as it\'s reserved as a prefix for generated script IDs."},"allFrames":{"type":"boolean","description":"If allFrames is <code>true</code>, implies that the JavaScript should be injected into all frames of current page. By default, it\'s <code>false</code> and is only injected into the top frame."},"js":{"type":"array","description":"The list of ScriptSource objects defining sources of scripts to be injected into matching pages.","items":{"$ref":"#/types/ScriptSource"}},"matches":{"type":"array","description":"At least one of matches or includeGlobs should be non-empty. The script runs in documents whose URL match either pattern.","items":{"$ref":"manifest#/types/MatchPattern"}},"excludeMatches":{"type":"array","items":{"$ref":"manifest#/types/MatchPattern"}},"includeGlobs":{"type":"array","description":"At least one of matches or includeGlobs should be non-empty. The script runs in documents whose URL match either pattern.","items":{"type":"string"}},"excludeGlobs":{"type":"array","items":{"type":"string"}},"runAt":{"allOf":[{"$ref":"extensionTypes#/types/RunAt"},{"description":"The soonest that the JavaScript will be injected into the tab. Defaults to \\"document_idle\\"."}]},"world":{"allOf":[{"$ref":"#/types/ExecutionWorld"},{"description":"The JavaScript script for a script to execute within. Defaults to \\"USER_SCRIPT\\"."}]},"worldId":{"type":"string","description":"If specified, specifies a specific user script world ID to execute in. Only valid if `world` is omitted or is `USER_SCRIPT`. If `worldId` is omitted, the script will execute in the default user script world (\\"\\"). Values with leading underscores (`_`) are reserved. The maximum length is 256."}},"required":["id","js"]},"ExecutionWorld":{"min_manifest_version":3,"type":"string","enum":["MAIN","USER_SCRIPT"],"description":"The JavaScript world for a script to execute within. <code>USER_SCRIPT</code> is the default execution environment of user scripts, <code>MAIN</code> is the web page\'s execution environment."},"UserScriptFilter":{"min_manifest_version":3,"type":"object","description":"Optional filter to use with getScripts() and unregister().","properties":{"ids":{"type":"array","items":{"type":"string"}}}},"ScriptSource":{"min_manifest_version":3,"description":"Object with file xor code property. Equivalent to the ExtensionFileOrCode, except the file remains a relative URL.","anyOf":[{"type":"object","properties":{"file":{"type":"string","description":"The path of the JavaScript file to inject relative to the extension\'s root directory.","format":"unresolvedRelativeUrl"}},"required":["file"]},{"type":"object","properties":{"code":{"type":"string"}},"required":["code"]}]},"WorldProperties":{"min_manifest_version":3,"type":"object","description":"The configuration of a USER_SCRIPT world.","properties":{"worldId":{"type":"string","default":"","description":"The identifier of the world. Values with leading underscores (`_`) are reserved. The maximum length is 256. Defaults to the default USER_SCRIPT world (\\"\\")."},"csp":{"type":"string","description":"The world\'s Content Security Policy. Defaults to the CSP of regular content scripts, which prohibits dynamic code execution such as eval."},"messaging":{"type":"boolean","default":false,"description":"Whether the runtime.sendMessage and runtime.connect methods are exposed. Defaults to not exposing these messaging APIs."}}}},"allowedContexts":["content"],"events":[{"name":"onBeforeScript","max_manifest_version":2,"permissions":["manifest:user_scripts.api_script"],"allowedContexts":["content","content_only"],"type":"function","description":"Event called when a new userScript global has been created","parameters":[{"type":"object","name":"userScript","properties":{"metadata":{"description":"The userScript metadata (as set in userScripts.register)"},"global":{"description":"The userScript global"},"defineGlobals":{"type":"function","description":"Exports all the properties of a given plain object as userScript globals","parameters":[{"type":"object","name":"sourceObject","description":"A plain object whose properties are exported as userScript globals"}]},"export":{"type":"function","description":"Convert a given value to make it accessible to the userScript code","parameters":[{"name":"value","description":"A value to convert into an object accessible to the userScript"}],"returns":{}}},"required":["metadata","global","defineGlobals","export"]}]}]}');

/***/ }),
/* 107 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"webNavigation","description":"Use the <code>browser.webNavigation</code> API to receive notifications about the status of navigation requests in-flight.","permissions":["webNavigation"],"functions":[{"name":"getFrame","type":"function","description":"Retrieves information about the given frame. A frame refers to an &lt;iframe&gt; or a &lt;frame&gt; of a web page and is identified by a tab ID and a frame ID.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information about the frame to retrieve information about.","properties":{"tabId":{"type":"integer","minimum":0,"description":"The ID of the tab in which the frame is."},"processId":{"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","minimum":0,"description":"The ID of the frame in the given tab."}},"required":["tabId","frameId"]},{"type":"function","name":"callback","parameters":[{"type":"object","name":"details","optional":true,"description":"Information about the requested frame, null if the specified frame ID and/or tab ID are invalid.","properties":{"errorOccurred":{"type":"boolean","description":"True if the last navigation in this frame was interrupted by an error, i.e. the onErrorOccurred event fired."},"url":{"type":"string","description":"The URL currently associated with this frame, if the frame identified by the frameId existed at one point in the given tab. The fact that an URL is associated with a given frameId does not imply that the corresponding frame still exists."},"tabId":{"type":"integer","description":"The ID of the tab in which the frame is."},"frameId":{"type":"integer","description":"The ID of the frame. 0 indicates that this is the main frame; a positive value indicates the ID of a subframe."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame. Set to -1 of no parent frame exists."}},"required":["url","tabId","frameId","parentFrameId"]}]}]},{"name":"getAllFrames","type":"function","description":"Retrieves information about all frames of a given tab.","async":"callback","parameters":[{"type":"object","name":"details","description":"Information about the tab to retrieve all frames from.","properties":{"tabId":{"type":"integer","minimum":0,"description":"The ID of the tab."}},"required":["tabId"]},{"type":"function","name":"callback","parameters":[{"name":"details","type":"array","description":"A list of frames in the given tab, null if the specified tab ID is invalid.","optional":true,"items":{"type":"object","properties":{"errorOccurred":{"type":"boolean","description":"True if the last navigation in this frame was interrupted by an error, i.e. the onErrorOccurred event fired."},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"tabId":{"type":"integer","description":"The ID of the tab in which the frame is."},"frameId":{"type":"integer","description":"The ID of the frame. 0 indicates that this is the main frame; a positive value indicates the ID of a subframe."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame. Set to -1 of no parent frame exists."},"url":{"type":"string","description":"The URL currently associated with this frame."}},"required":["processId","tabId","frameId","parentFrameId","url"]}}]}]}],"events":[{"name":"onBeforeNavigate","type":"function","description":"Fired when a navigation is about to occur.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation is about to occur."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique for a given tab and process."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame. Set to -1 of no parent frame exists."},"timeStamp":{"type":"number","description":"The time when the browser was about to start the navigation, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","parentFrameId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onCommitted","type":"function","description":"Fired when a navigation is committed. The document (and the resources it refers to, such as images and subframes) might still be downloading, but at least part of the document has been received from the server and the browser has decided to switch to the new document.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"transitionType":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"Cause of the navigation."}]},"transitionQualifiers":{"type":"array","description":"A list of transition qualifiers.","items":{"$ref":"#/types/TransitionQualifier"}},"timeStamp":{"type":"number","description":"The time when the navigation was committed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","transitionType","transitionQualifiers","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onDOMContentLoaded","type":"function","description":"Fired when the page\'s DOM is fully constructed, but the referenced resources may not finish loading.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"timeStamp":{"type":"number","description":"The time when the page\'s DOM was fully constructed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onCompleted","type":"function","description":"Fired when a document, including the resources it refers to, is completely loaded and initialized.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"timeStamp":{"type":"number","description":"The time when the document finished loading, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onErrorOccurred","type":"function","description":"Fired when an error occurs and the navigation is aborted. This can happen if either a network error occurred, or the user aborted the navigation.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"error":{"unsupported":true,"type":"string","description":"The error description."},"timeStamp":{"type":"number","description":"The time when the error occurred, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","error","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onCreatedNavigationTarget","type":"function","description":"Fired when a new window, or a new tab in an existing window, is created to host a navigation.","parameters":[{"type":"object","name":"details","properties":{"sourceTabId":{"type":"integer","description":"The ID of the tab in which the navigation is triggered."},"sourceProcessId":{"type":"integer","description":"The ID of the process runs the renderer for the source tab."},"sourceFrameId":{"type":"integer","description":"The ID of the frame with sourceTabId in which the navigation is triggered. 0 indicates the main frame."},"url":{"type":"string","description":"The URL to be opened in the new window."},"tabId":{"type":"integer","description":"The ID of the tab in which the url is opened"},"timeStamp":{"type":"number","description":"The time when the browser was about to create a new view, in milliseconds since the epoch."}},"required":["sourceTabId","sourceProcessId","sourceFrameId","url","tabId","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onReferenceFragmentUpdated","type":"function","description":"Fired when the reference fragment of a frame was updated. All future events for that frame will use the updated URL.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"transitionType":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"Cause of the navigation."}]},"transitionQualifiers":{"type":"array","description":"A list of transition qualifiers.","items":{"$ref":"#/types/TransitionQualifier"}},"timeStamp":{"type":"number","description":"The time when the navigation was committed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","transitionType","transitionQualifiers","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]},{"name":"onTabReplaced","type":"function","description":"Fired when the contents of the tab is replaced by a different (usually previously pre-rendered) tab.","parameters":[{"type":"object","name":"details","properties":{"replacedTabId":{"type":"integer","description":"The ID of the tab that was replaced."},"tabId":{"type":"integer","description":"The ID of the tab that replaced the old tab."},"timeStamp":{"type":"number","description":"The time when the replacement happened, in milliseconds since the epoch."}},"required":["replacedTabId","tabId","timeStamp"]}]},{"name":"onHistoryStateUpdated","type":"function","description":"Fired when the frame\'s history was updated to a new URL. All future events for that frame will use the updated URL.","parameters":[{"type":"object","name":"details","properties":{"tabId":{"type":"integer","description":"The ID of the tab in which the navigation occurs."},"url":{"type":"string"},"processId":{"unsupported":true,"type":"integer","description":"The ID of the process runs the renderer for this tab."},"frameId":{"type":"integer","description":"0 indicates the navigation happens in the tab content window; a positive value indicates navigation in a subframe. Frame IDs are unique within a tab."},"transitionType":{"allOf":[{"$ref":"#/types/TransitionType"},{"description":"Cause of the navigation."}]},"transitionQualifiers":{"type":"array","description":"A list of transition qualifiers.","items":{"$ref":"#/types/TransitionQualifier"}},"timeStamp":{"type":"number","description":"The time when the navigation was committed, in milliseconds since the epoch."}},"required":["tabId","url","processId","frameId","transitionType","transitionQualifiers","timeStamp"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/EventUrlFilters"},{"name":"filters","optional":true,"description":"Conditions that the URL being navigated to must satisfy. The \'schemes\' and \'ports\' fields of UrlFilter are ignored for this event."}]}]}],"definitions":{"OptionalPermission":{"anyOf":[{"type":"string","enum":["webNavigation"]}]}},"refs":{"webNavigation#/definitions/OptionalPermission":{"namespace":"manifest","type":"OptionalPermission"}},"types":{"TransitionType":{"type":"string","enum":["link","typed","auto_bookmark","auto_subframe","manual_subframe","generated","start_page","form_submit","reload","keyword","keyword_generated"],"description":"Cause of the navigation. The same transition types as defined in the history API are used. These are the same transition types as defined in the $(topic:transition_types)[history API] except with <code>\\"start_page\\"</code> in place of <code>\\"auto_toplevel\\"</code> (for backwards compatibility)."},"TransitionQualifier":{"type":"string","enum":["client_redirect","server_redirect","forward_back","from_address_bar"]},"EventUrlFilters":{"type":"object","properties":{"url":{"type":"array","minItems":1,"items":{"$ref":"events#/types/UrlFilter"}}},"required":["url"]}}}');

/***/ }),
/* 108 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"webRequest","description":"Use the <code>browser.webRequest</code> API to observe and analyze traffic and to intercept, block, or modify requests in-flight.","permissions":["webRequest"],"properties":{"MAX_HANDLER_BEHAVIOR_CHANGED_CALLS_PER_10_MINUTES":{"value":20,"description":"The maximum number of times that <code>handlerBehaviorChanged</code> can be called per 10 minute sustained interval. <code>handlerBehaviorChanged</code> is an expensive function call that shouldn\'t be called often."}},"functions":[{"name":"handlerBehaviorChanged","type":"function","description":"Needs to be called when the behavior of the webRequest handlers has changed to prevent incorrect handling due to caching. This function call is expensive. Don\'t call it often.","async":"callback","parameters":[{"type":"function","name":"callback","optional":true,"parameters":[]}]},{"name":"filterResponseData","permissions":["webRequestBlocking"],"type":"function","description":"...","parameters":[{"name":"requestId","type":"string"}],"returns":{"type":"object","additionalProperties":{},"isInstanceOf":"StreamFilter"}},{"name":"getSecurityInfo","type":"function","async":true,"description":"Retrieves the security information for the request.  Returns a promise that will resolve to a SecurityInfo object.","parameters":[{"name":"requestId","type":"string"},{"name":"options","optional":true,"type":"object","properties":{"certificateChain":{"type":"boolean","description":"Include the entire certificate chain."},"rawDER":{"type":"boolean","description":"Include raw certificate data for processing by the extension."}}}]}],"events":[{"name":"onBeforeRequest","type":"function","description":"Fired when a request is about to occur.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"requestBody":{"type":"object","description":"Contains the HTTP request body data. Only provided if extraInfoSpec contains \'requestBody\'.","properties":{"error":{"type":"string","description":"Errors when obtaining request body data."},"formData":{"type":"object","description":"If the request method is POST and the body is a sequence of key-value pairs encoded in UTF8, encoded as either multipart/form-data, or application/x-www-form-urlencoded, this dictionary is present and for each key contains the list of all values for that key. If the data is of another media type, or if it is malformed, the dictionary is not present. An example value of this dictionary is {\'key\': [\'value1\', \'value2\']}.","properties":{},"additionalProperties":{"type":"array","items":{"type":"string"}}},"raw":{"type":"array","items":{"$ref":"#/types/UploadData"},"description":"If the request method is PUT or POST, and the body is not already parsed in formData, then the unparsed request body elements are contained in this array."}}},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnBeforeRequestOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onBeforeSendHeaders","type":"function","description":"Fired before sending an HTTP request, once the request headers are available. This may occur after a TCP connection is made to the server, but before any HTTP data is sent. ","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"requestHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP request headers that are going to be sent out with this request."}]},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnBeforeSendHeadersOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onSendHeaders","type":"function","description":"Fired just before a request is going to be sent to the server (modifications of previous onBeforeSendHeaders callbacks are visible by the time onSendHeaders is fired).","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"requestHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP request headers that have been sent out with this request."}]},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnSendHeadersOptions"}}]},{"name":"onHeadersReceived","type":"function","description":"Fired when HTTP response headers of a request have been received.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line)."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that have been received with this response."}]},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","statusLine","statusCode","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnHeadersReceivedOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onAuthRequired","type":"function","description":"Fired when an authentication failure is received. The listener has three options: it can provide authentication credentials, it can cancel the request and display the error page, or it can take no action on the challenge. If bad user credentials are provided, this may be called multiple times for the same request.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"scheme":{"type":"string","description":"The authentication scheme, e.g. Basic or Digest."},"realm":{"type":"string","description":"The authentication realm provided by the server, if there is one."},"challenger":{"type":"object","description":"The server requesting authentication.","properties":{"host":{"type":"string"},"port":{"type":"integer"}},"required":["host","port"]},"isProxy":{"type":"boolean","description":"True for Proxy-Authenticate, false for WWW-Authenticate."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this response."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","scheme","challenger","isProxy","statusLine","statusCode","thirdParty"]},{"type":"function","optional":true,"name":"asyncCallback","parameters":[{"allOf":[{"$ref":"#/types/BlockingResponse"},{"name":"response"}]}]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","postprocess":"mutuallyExclusiveBlockingOrAsyncBlocking","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnAuthRequiredOptions"}}],"returns":{"allOf":[{"$ref":"#/types/BlockingResponse"},{"description":"If \\"blocking\\" is specified in the \\"extraInfoSpec\\" parameter, the event listener should return an object of this type.","optional":true}]}},{"name":"onResponseStarted","type":"function","description":"Fired when the first byte of the response body is received. For HTTP requests, this means that the status line and response headers are available.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this response."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","statusCode","statusLine","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnResponseStartedOptions"}}]},{"name":"onBeforeRedirect","type":"function","description":"Fired when a server-initiated redirect is about to occur.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"redirectUrl":{"type":"string","description":"The new URL."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this redirect."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","statusCode","redirectUrl","statusLine","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnBeforeRedirectOptions"}}]},{"name":"onCompleted","type":"function","description":"Fired when a request is completed.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"statusCode":{"type":"integer","description":"Standard HTTP status code returned by the server."},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"The HTTP response headers that were received along with this response."}]},"statusLine":{"type":"string","description":"HTTP status line of the response or the \'HTTP/0.9 200 OK\' string for HTTP/0.9 responses (i.e., responses that lack a status line) or an empty string if there are no headers."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."},"requestSize":{"type":"integer","description":"For http requests, the bytes transferred in the request. Only available in onCompleted."},"responseSize":{"type":"integer","description":"For http requests, the bytes received in the request. Only available in onCompleted."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","statusCode","statusLine","urlClassification","thirdParty","requestSize","responseSize"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]},{"type":"array","optional":true,"name":"extraInfoSpec","description":"Array of extra information that should be passed to the listener function.","items":{"$ref":"#/types/OnCompletedOptions"}}]},{"name":"onErrorOccurred","type":"function","description":"Fired when an error occurs.","parameters":[{"type":"object","name":"details","properties":{"requestId":{"type":"string","description":"The ID of the request. Request IDs are unique within a browser session. As a result, they could be used to relate different events of the same request."},"url":{"type":"string"},"method":{"type":"string","description":"Standard HTTP method."},"frameId":{"type":"integer","description":"The value 0 indicates that the request happens in the main frame; a positive value indicates the ID of a subframe in which the request happens. If the document of a (sub-)frame is loaded (<code>type</code> is <code>main_frame</code> or <code>sub_frame</code>), <code>frameId</code> indicates the ID of this frame, not the ID of the outer frame. Frame IDs are unique within a tab."},"parentFrameId":{"type":"integer","description":"ID of frame that wraps the frame which sent the request. Set to -1 if no parent frame exists."},"incognito":{"type":"boolean","description":"True for private browsing requests."},"cookieStoreId":{"type":"string","description":"The cookie store ID of the contextual identity."},"originUrl":{"type":"string","description":"URL of the resource that triggered this request."},"documentUrl":{"type":"string","description":"URL of the page into which the requested resource will be loaded."},"tabId":{"type":"integer","description":"The ID of the tab in which the request takes place. Set to -1 if the request isn\'t related to a tab."},"type":{"allOf":[{"$ref":"#/types/ResourceType"},{"description":"How the requested resource will be used."}]},"timeStamp":{"type":"number","description":"The time when this signal is triggered, in milliseconds since the epoch."},"ip":{"type":"string","description":"The server IP address that the request was actually sent to. Note that it may be a literal IPv6 address."},"fromCache":{"type":"boolean","description":"Indicates if this response was fetched from disk cache."},"error":{"type":"string","description":"The error description. This string is <em>not</em> guaranteed to remain backwards compatible between releases. You must not parse and act based upon its content."},"urlClassification":{"allOf":[{"$ref":"#/types/UrlClassification"},{"description":"Tracking classification if the request has been classified."}]},"thirdParty":{"type":"boolean","description":"Indicates if this request and its content window hierarchy is third party."}},"required":["requestId","url","method","frameId","parentFrameId","tabId","type","timeStamp","fromCache","error","thirdParty"]}],"extraParameters":[{"allOf":[{"$ref":"#/types/RequestFilter"},{"name":"filter","description":"A set of filters that restricts the events that will be sent to this listener."}]}]}],"definitions":{"OptionalPermissionNoPrompt":{"anyOf":[{"type":"string","enum":["webRequest","webRequestAuthProvider","webRequestBlocking","webRequestFilterResponse","webRequestFilterResponse.serviceWorkerScript"]}]}},"refs":{"webRequest#/definitions/OptionalPermissionNoPrompt":{"namespace":"manifest","type":"OptionalPermissionNoPrompt"}},"types":{"ResourceType":{"type":"string","enum":["main_frame","sub_frame","stylesheet","script","image","object","object_subrequest","xmlhttprequest","xslt","ping","beacon","xml_dtd","font","media","websocket","csp_report","imageset","web_manifest","speculative","json","other"]},"OnBeforeRequestOptions":{"type":"string","enum":["blocking","requestBody"],"postprocess":"webRequestBlockingPermissionRequired"},"OnBeforeSendHeadersOptions":{"type":"string","enum":["requestHeaders","blocking"],"postprocess":"webRequestBlockingPermissionRequired"},"OnSendHeadersOptions":{"type":"string","enum":["requestHeaders"]},"OnHeadersReceivedOptions":{"type":"string","enum":["blocking","responseHeaders"],"postprocess":"webRequestBlockingPermissionRequired"},"OnAuthRequiredOptions":{"type":"string","enum":["responseHeaders","blocking","asyncBlocking"],"postprocess":"webRequestBlockingOrAuthProviderPermissionRequired"},"OnResponseStartedOptions":{"type":"string","enum":["responseHeaders"]},"OnBeforeRedirectOptions":{"type":"string","enum":["responseHeaders"]},"OnCompletedOptions":{"type":"string","enum":["responseHeaders"]},"RequestFilter":{"type":"object","description":"An object describing filters to apply to webRequest events.","properties":{"urls":{"type":"array","description":"A list of URLs or URL patterns. Requests that cannot match any of the URLs will be filtered out.","items":{"type":"string"},"minItems":1},"types":{"type":"array","description":"A list of request types. Requests that cannot match any of the types will be filtered out.","items":{"allOf":[{"$ref":"#/types/ResourceType"},{"onError":"warn"}]},"minItems":1},"tabId":{"type":"integer"},"windowId":{"type":"integer"},"incognito":{"type":"boolean","description":"If provided, requests that do not match the incognito state will be filtered out."}},"required":["urls"]},"HttpHeaders":{"type":"array","description":"An array of HTTP headers. Each header is represented as a dictionary containing the keys <code>name</code> and either <code>value</code> or <code>binaryValue</code>.","items":{"type":"object","properties":{"name":{"type":"string","description":"Name of the HTTP header."},"value":{"type":"string","description":"Value of the HTTP header if it can be represented by UTF-8."},"binaryValue":{"type":"array","description":"Value of the HTTP header if it cannot be represented by UTF-8, stored as individual byte values (0..255).","items":{"type":"integer"}}},"required":["name"]}},"BlockingResponse":{"type":"object","description":"Returns value for event handlers that have the \'blocking\' extraInfoSpec applied. Allows the event handler to modify network requests.","properties":{"cancel":{"type":"boolean","description":"If true, the request is cancelled. Used in onBeforeRequest, this prevents the request from being sent."},"redirectUrl":{"type":"string","description":"Only used as a response to the onBeforeRequest and onHeadersReceived events. If set, the original request is prevented from being sent/completed and is instead redirected to the given URL. Redirections to non-HTTP schemes such as data: are allowed. Redirects initiated by a redirect action use the original request method for the redirect, with one exception: If the redirect is initiated at the onHeadersReceived stage, then the redirect will be issued using the GET method."},"upgradeToSecure":{"type":"boolean","description":"Only used as a response to the onBeforeRequest event. If set, the original request is prevented from being sent/completed and is instead upgraded to a secure request.  If any extension returns <code>redirectUrl</code> during onBeforeRequest, <code>upgradeToSecure</code> will have no affect."},"requestHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"Only used as a response to the onBeforeSendHeaders event. If set, the request is made with these request headers instead."}]},"responseHeaders":{"allOf":[{"$ref":"#/types/HttpHeaders"},{"description":"Only used as a response to the onHeadersReceived event. If set, the server is assumed to have responded with these response headers instead. Only return <code>responseHeaders</code> if you really want to modify the headers in order to limit the number of conflicts (only one extension may modify <code>responseHeaders</code> for each request)."}]},"authCredentials":{"type":"object","description":"Only used as a response to the onAuthRequired event. If set, the request is made using the supplied credentials.","properties":{"username":{"type":"string"},"password":{"type":"string"}},"required":["username","password"]}}},"CertificateInfo":{"type":"object","description":"Contains the certificate properties of the request if it is a secure request.","properties":{"subject":{"type":"string"},"issuer":{"type":"string"},"validity":{"type":"object","description":"Contains start and end timestamps.","properties":{"start":{"type":"integer"},"end":{"type":"integer"}},"required":["start","end"]},"fingerprint":{"type":"object","properties":{"sha1":{"type":"string"},"sha256":{"type":"string"}},"required":["sha1","sha256"]},"serialNumber":{"type":"string"},"isBuiltInRoot":{"type":"boolean"},"subjectPublicKeyInfoDigest":{"type":"object","properties":{"sha256":{"type":"string"}},"required":["sha256"]},"rawDER":{"type":"array","items":{"type":"integer"}}},"required":["subject","issuer","validity","fingerprint","serialNumber","isBuiltInRoot","subjectPublicKeyInfoDigest"]},"CertificateTransparencyStatus":{"type":"string","enum":["not_applicable","policy_compliant","policy_not_enough_scts","policy_not_diverse_scts"]},"TransportWeaknessReasons":{"type":"string","enum":["cipher"]},"SecurityInfo":{"type":"object","description":"Contains the security properties of the request (ie. SSL/TLS information).","properties":{"state":{"type":"string","enum":["insecure","weak","broken","secure"]},"errorMessage":{"type":"string","description":"Error message if state is \\"broken\\""},"protocolVersion":{"type":"string","description":"Protocol version if state is \\"secure\\"","enum":["TLSv1","TLSv1.1","TLSv1.2","TLSv1.3","unknown"]},"cipherSuite":{"type":"string","description":"The cipher suite used in this request if state is \\"secure\\"."},"keaGroupName":{"type":"string","description":"The key exchange algorithm used in this request if state is \\"secure\\"."},"secretKeyLength":{"type":"number","description":"The length (in bits) of the secret key."},"signatureSchemeName":{"type":"string","description":"The signature scheme used in this request if state is \\"secure\\"."},"certificates":{"description":"Certificate data if state is \\"secure\\".  Will only contain one entry unless <code>certificateChain</code> is passed as an option.","type":"array","items":{"$ref":"#/types/CertificateInfo"}},"overridableErrorCategory":{"description":"The type of certificate error that was overridden for this connection, if any.","type":"string","enum":["trust_error","domain_mismatch","expired_or_not_yet_valid"]},"isDomainMismatch":{"description":"The domain name does not match the certificate domain.","type":"boolean","deprecated":"Please use $(ref:SecurityInfo.overridableErrorCategory)."},"isNotValidAtThisTime":{"description":"The certificate is either expired or is not yet valid.  See <code>CertificateInfo.validity</code> for start and end dates.","type":"boolean","deprecated":"Please use $(ref:SecurityInfo.overridableErrorCategory)."},"isUntrusted":{"type":"boolean","deprecated":"Please use $(ref:SecurityInfo.overridableErrorCategory)."},"isExtendedValidation":{"type":"boolean"},"certificateTransparencyStatus":{"allOf":[{"$ref":"#/types/CertificateTransparencyStatus"},{"description":"Certificate transparency compliance per RFC 6962.  See <code>https://www.certificate-transparency.org/what-is-ct</code> for more information."}]},"hsts":{"type":"boolean","description":"True if host uses Strict Transport Security and state is \\"secure\\"."},"hpkp":{"type":"string","description":"True if host uses Public Key Pinning and state is \\"secure\\"."},"weaknessReasons":{"type":"array","items":{"$ref":"#/types/TransportWeaknessReasons"},"description":"list of reasons that cause the request to be considered weak, if state is \\"weak\\""},"usedEch":{"type":"boolean","description":"True if the TLS connection used Encrypted Client Hello."},"usedDelegatedCredentials":{"type":"boolean","description":"True if the TLS connection used Delegated Credentials."},"usedOcsp":{"type":"boolean","description":"True if the TLS connection made OCSP requests."},"usedPrivateDns":{"type":"boolean","description":"True if the TLS connection used a privacy-preserving DNS transport like DNS-over-HTTPS."}},"required":["state","certificates"]},"UploadData":{"type":"object","properties":{"bytes":{"description":"An ArrayBuffer with a copy of the data."},"file":{"type":"string","description":"A string with the file\'s path and name."}},"description":"Contains data uploaded in a URL request."},"UrlClassificationFlags":{"type":"string","enum":["fingerprinting","fingerprinting_content","cryptomining","cryptomining_content","emailtracking","emailtracking_content","tracking","tracking_ad","tracking_analytics","tracking_social","tracking_content","any_basic_tracking","any_strict_tracking","any_social_tracking"],"description":"Tracking flags that match our internal tracking classification"},"UrlClassificationParty":{"type":"array","items":{"$ref":"#/types/UrlClassificationFlags"},"description":"If the request has been classified this is an array of $(ref:UrlClassificationFlags)."},"UrlClassification":{"type":"object","properties":{"firstParty":{"allOf":[{"$ref":"#/types/UrlClassificationParty"},{"description":"Classification flags if the request has been classified and it is first party."}]},"thirdParty":{"allOf":[{"$ref":"#/types/UrlClassificationParty"},{"description":"Classification flags if the request has been classified and it or its window hierarchy is third party."}]}},"required":["firstParty","thirdParty"]}}}');

/***/ }),
/* 109 */
/***/ ((module) => {

module.exports = /*#__PURE__*/JSON.parse('{"$id":"windows","description":"Use the <code>browser.windows</code> API to interact with browser windows. You can use this API to create, modify, and rearrange windows in the browser.","properties":{"WINDOW_ID_NONE":{"value":-1,"description":"The windowId value that represents the absence of a browser window."},"WINDOW_ID_CURRENT":{"value":-2,"description":"The windowId value that represents the $(topic:current-window)[current window]."}},"functions":[{"name":"get","type":"function","description":"Gets details about a window.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"allOf":[{"$ref":"#/types/GetInfo"},{"name":"getInfo","optional":true}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"getCurrent","type":"function","description":"Gets the $(topic:current-window)[current window].","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/GetInfo"},{"name":"getInfo","optional":true}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"getLastFocused","type":"function","description":"Gets the window that was most recently focused &mdash; typically the window \'on top\'.","async":"callback","parameters":[{"allOf":[{"$ref":"#/types/GetInfo"},{"name":"getInfo","optional":true}]},{"type":"function","name":"callback","parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"getAll","type":"function","description":"Gets all windows.","async":"callback","parameters":[{"$merge":{"source":{"$ref":"windows#/types/GetInfo"},"with":{"type":"object","name":"getInfo","optional":true,"description":"Specifies properties used to filter the $(ref:windows.Window) returned and to determine whether they should contain a list of the $(ref:tabs.Tab) objects.","properties":{"windowTypes":{"type":"array","items":{"$ref":"#/types/WindowType"},"description":"If set, the $(ref:windows.Window) returned will be filtered based on its type. If unset the default filter is set to <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}}}}},{"type":"function","name":"callback","parameters":[{"name":"windows","type":"array","items":{"$ref":"#/types/Window"}}]}]},{"name":"create","type":"function","description":"Creates (opens) a new browser with any optional sizing, position or default URL provided.","async":"callback","parameters":[{"type":"object","name":"createData","optional":true,"default":{},"properties":{"url":{"description":"A URL or array of URLs to open as tabs in the window. Fully-qualified URLs must include a scheme (i.e. \'http://www.google.com\', not \'www.google.com\'). Relative URLs will be relative to the current page within the extension. Defaults to the New Tab Page.","anyOf":[{"type":"string"},{"type":"array","items":{"type":"string"}}]},"tabId":{"type":"integer","minimum":0,"description":"The id of the tab for which you want to adopt to the new window."},"left":{"type":"integer","description":"The number of pixels to position the new window from the left edge of the screen. If not specified, the new window is offset naturally from the last focused window. This value is ignored for panels."},"top":{"type":"integer","description":"The number of pixels to position the new window from the top edge of the screen. If not specified, the new window is offset naturally from the last focused window. This value is ignored for panels."},"width":{"type":"integer","minimum":0,"description":"The width in pixels of the new window, including the frame. If not specified defaults to a natural width."},"height":{"type":"integer","minimum":0,"description":"The height in pixels of the new window, including the frame. If not specified defaults to a natural height."},"focused":{"anyOf":[{"type":"boolean","enum":[true]},{"type":"boolean","enum":[false],"deprecated":"Opening inactive windows is not supported."}],"description":"If true, opens an active window. If false, opens an inactive window."},"incognito":{"type":"boolean","description":"Whether the new window should be an incognito window."},"type":{"allOf":[{"$ref":"#/types/CreateType"},{"description":"Specifies what type of browser window to create. The \'panel\' and \'detached_panel\' types create a popup unless the \'--enable-panels\' flag is set."}]},"state":{"allOf":[{"$ref":"#/types/WindowState"},{"description":"The initial state of the window. The \'minimized\', \'maximized\' and \'fullscreen\' states cannot be combined with \'left\', \'top\', \'width\' or \'height\'."}]},"allowScriptsToClose":{"type":"boolean","description":"Allow scripts to close the window."},"cookieStoreId":{"type":"string","description":"The CookieStoreId to use for all tabs that were created when the window is opened."},"titlePreface":{"type":"string","description":"A string to add to the beginning of the window title."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window","description":"Contains details about the created window.","optional":true}]}]}]},{"name":"update","type":"function","description":"Updates the properties of a window. Specify only the properties that you want to change; unspecified properties will be left unchanged.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"type":"object","name":"updateInfo","properties":{"left":{"type":"integer","description":"The offset from the left edge of the screen to move the window to in pixels. This value is ignored for panels."},"top":{"type":"integer","description":"The offset from the top edge of the screen to move the window to in pixels. This value is ignored for panels."},"width":{"type":"integer","minimum":0,"description":"The width to resize the window to in pixels. This value is ignored for panels."},"height":{"type":"integer","minimum":0,"description":"The height to resize the window to in pixels. This value is ignored for panels."},"focused":{"type":"boolean","description":"If true, brings the window to the front. If false, brings the next window in the z-order to the front."},"drawAttention":{"type":"boolean","description":"If true, causes the window to be displayed in a manner that draws the user\'s attention to the window, without changing the focused window. The effect lasts until the user changes focus to the window. This option has no effect if the window already has focus. Set to false to cancel a previous draw attention request."},"state":{"allOf":[{"$ref":"#/types/WindowState"},{"description":"The new state of the window. The \'minimized\', \'maximized\' and \'fullscreen\' states cannot be combined with \'left\', \'top\', \'width\' or \'height\'."}]},"titlePreface":{"type":"string","description":"A string to add to the beginning of the window title."}}},{"type":"function","name":"callback","optional":true,"parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window"}]}]}]},{"name":"remove","type":"function","description":"Removes (closes) a window, and all the tabs inside it.","async":"callback","parameters":[{"type":"integer","name":"windowId","minimum":-2},{"type":"function","name":"callback","optional":true,"parameters":[]}]}],"events":[{"name":"onCreated","type":"function","description":"Fired when a window is created.","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"#/types/WindowType"},"description":"Conditions that the window\'s type being created must satisfy. By default it will satisfy <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}],"parameters":[{"allOf":[{"$ref":"#/types/Window"},{"name":"window","description":"Details of the window that was created."}]}]},{"name":"onRemoved","type":"function","description":"Fired when a window is removed (closed).","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"#/types/WindowType"},"description":"Conditions that the window\'s type being removed must satisfy. By default it will satisfy <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}],"parameters":[{"type":"integer","name":"windowId","minimum":0,"description":"ID of the removed window."}]},{"name":"onFocusChanged","type":"function","description":"Fired when the currently focused window changes. Will be $(ref:windows.WINDOW_ID_NONE) if all browser windows have lost focus. Note: On some Linux window managers, WINDOW_ID_NONE will always be sent immediately preceding a switch from one browser window to another.","filters":[{"name":"windowTypes","type":"array","items":{"$ref":"#/types/WindowType"},"description":"Conditions that the window\'s type being removed must satisfy. By default it will satisfy <code>[\'app\', \'normal\', \'panel\', \'popup\']</code>, with <code>\'app\'</code> and <code>\'panel\'</code> window types limited to the extension\'s own windows."}],"parameters":[{"type":"integer","name":"windowId","minimum":-1,"description":"ID of the newly focused window."}]}],"definitions":{},"refs":{},"types":{"WindowType":{"type":"string","description":"The type of browser window this is. Under some circumstances a Window may not be assigned type property, for example when querying closed windows from the $(ref:sessions) API.","enum":["normal","popup","panel","app","devtools"]},"WindowState":{"type":"string","description":"The state of this browser window. Under some circumstances a Window may not be assigned state property, for example when querying closed windows from the $(ref:sessions) API.","enum":["normal","minimized","maximized","fullscreen","docked"]},"Window":{"type":"object","properties":{"id":{"type":"integer","minimum":0,"description":"The ID of the window. Window IDs are unique within a browser session. Under some circumstances a Window may not be assigned an ID, for example when querying windows using the $(ref:sessions) API, in which case a session ID may be present."},"focused":{"type":"boolean","description":"Whether the window is currently the focused window."},"top":{"type":"integer","description":"The offset of the window from the top edge of the screen in pixels. Under some circumstances a Window may not be assigned top property, for example when querying closed windows from the $(ref:sessions) API."},"left":{"type":"integer","description":"The offset of the window from the left edge of the screen in pixels. Under some circumstances a Window may not be assigned left property, for example when querying closed windows from the $(ref:sessions) API."},"width":{"type":"integer","description":"The width of the window, including the frame, in pixels. Under some circumstances a Window may not be assigned width property, for example when querying closed windows from the $(ref:sessions) API."},"height":{"type":"integer","description":"The height of the window, including the frame, in pixels. Under some circumstances a Window may not be assigned height property, for example when querying closed windows from the $(ref:sessions) API."},"tabs":{"type":"array","items":{"$ref":"tabs#/types/Tab"},"description":"Array of $(ref:tabs.Tab) objects representing the current tabs in the window."},"incognito":{"type":"boolean","description":"Whether the window is incognito."},"type":{"allOf":[{"$ref":"#/types/WindowType"},{"description":"The type of browser window this is."}]},"state":{"allOf":[{"$ref":"#/types/WindowState"},{"description":"The state of this browser window."}]},"alwaysOnTop":{"type":"boolean","description":"Whether the window is set to be always on top."},"sessionId":{"type":"string","description":"The session ID used to uniquely identify a Window obtained from the $(ref:sessions) API."},"title":{"type":"string","description":"The title of the window. Read-only."}},"required":["focused","incognito","alwaysOnTop"]},"CreateType":{"type":"string","description":"Specifies what type of browser window to create. The \'panel\' and \'detached_panel\' types create a popup unless the \'--enable-panels\' flag is set.","enum":["normal","popup","panel","detached_panel"]},"GetInfo":{"type":"object","description":"Specifies whether the $(ref:windows.Window) returned should contain a list of the $(ref:tabs.Tab) objects.","properties":{"populate":{"type":"boolean","description":"If true, the $(ref:windows.Window) returned will have a <var>tabs</var> property that contains a list of the $(ref:tabs.Tab) objects. The <code>Tab</code> objects only contain the <code>url</code>, <code>title</code> and <code>favIconUrl</code> properties if the extension\'s manifest file includes the <code>\\"tabs\\"</code> permission."},"windowTypes":{"type":"array","items":{"$ref":"#/types/WindowType"},"deprecated":true,"description":"<code>windowTypes</code> is deprecated and ignored on Firefox."}}}}}');

/***/ }),
/* 110 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var esprima = _interopRequireWildcard(__webpack_require__(111));
var _relaxedJson = _interopRequireDefault(__webpack_require__(32));
var messages = _interopRequireWildcard(__webpack_require__(17));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class JSONParser {
  constructor(jsonString, collector, addonMetadata, {
    filename = null
  } = {}) {
    // Add the JSON string to the object; we'll use this for testing.
    this._jsonString = jsonString;

    // Provides ability to directly add messages to
    // the collector.
    this.collector = collector;

    // Set the filename for this file
    this.filename = filename;

    // This marks whether a JSON file is valid; in the case of the base JSON
    // parser, that's just whether it can be parsed and has duplicate keys.
    this.isValid = null;

    // Provides access to addon information from scanners
    this.addonMetadata = addonMetadata;
  }
  parse(RelaxedJSON = _relaxedJson.default) {
    try {
      this.parsedJSON = JSON.parse(this._jsonString);
    } catch (originalError) {
      // First we'll try to remove comments with esprima;
      // WebExtension manifests can contain comments, so we'll strip
      // them out and see if we can parse the JSON.
      // If not it's just garbage JSON and we error.
      //
      // Originally from https://github.com/abarreir/crx2ff/blob/d2b882056f902d751ad05e329efda7eddcb9d268/libs/ext-converter.js#L19-L37
      const manifestString = `var o = ${this._jsonString}`;
      try {
        // This converts the JSON into a real JS object, and removes any
        // comments from the JS code.
        // This has some drawbacks because JSON and JS are not _100%_
        // compatible. This is largely to do with Unicode characters we
        // wouldn't expect to see in manifests anyway, and it should simply be
        // a JSON parse error anyway.
        // See:
        // http://stackoverflow.com/questions/23752156/are-all-json-objects-also-valid-javascript-objects/23753148#23753148
        // https://github.com/judofyr/timeless/issues/57#issuecomment-31872462
        const tokens = esprima.tokenize(manifestString, {
          comment: true
        }).slice(3);
        this._jsonString = tokens.reduce((json, token) => {
          // Ignore line comments (`// comments`) and just return the existing
          // json we've built.
          if (token.type === 'LineComment') {
            return json;
          }

          // Block comments are not allowed, so this is an error.
          if (token.type === 'BlockComment') {
            this.collector.addError(messages.JSON_BLOCK_COMMENTS);
            this.isValid = false;
          }
          return `${json}${token.value}`;
        }, '');

        // We found block-level comments, so this manifest is not valid.
        // Don't bother parsing it again.
        if (this.isValid === false) {
          return;
        }
        this.parsedJSON = JSON.parse(this._jsonString);
      } catch (error) {
        // There was still an error, so looks like this manifest is actually
        // invalid.
        const errorData = {
          ...messages.JSON_INVALID,
          file: this.filename,
          description: error.message
        };
        this.collector.addError(errorData);
        this.isValid = false;
        return;
      }
    }

    // Check for duplicate keys, which renders the manifest invalid.
    this._checkForDuplicateKeys(RelaxedJSON);

    // If never marked as invalid, this is a valid JSON file.
    if (this.isValid !== false) {
      this.isValid = true;
    }
  }
  _checkForDuplicateKeys(RelaxedJSON = _relaxedJson.default) {
    try {
      RelaxedJSON.parse(this._jsonString, {
        duplicate: true,
        tolerant: true
      });
    } catch (err) {
      if (err.warnings && err.warnings.length > 0) {
        err.warnings.forEach(error => {
          if (error.message.startsWith('Duplicate key:')) {
            const message = {
              ...messages.JSON_DUPLICATE_KEY,
              file: this.filename,
              line: error.line,
              description: `${error.message} found in JSON`
            };
            this.collector.addError(message);
            this.isValid = false;
          }
        });
      }
    }
  }
}
exports["default"] = JSONParser;

/***/ }),
/* 111 */
/***/ ((module) => {

module.exports = require("esprima");

/***/ }),
/* 112 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("wbgdrb.applythrunet.co.in\n");

/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _base = _interopRequireDefault(__webpack_require__(114));
var messages = _interopRequireWildcard(__webpack_require__(17));
var constants = _interopRequireWildcard(__webpack_require__(15));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class BinaryScanner extends _base.default {
  static get fileResultType() {
    return 'chunk';
  }
  static get scannerName() {
    return 'binary';
  }
  check(buffer, values) {
    if (Object.keys(values).some(v => values[v] !== buffer[v])) {
      return;
    }
    this.linterMessages.push({
      ...messages.FLAGGED_FILE_TYPE,
      type: constants.VALIDATION_NOTICE,
      file: this.filename
    });
  }
  async scan() {
    const buffer = this.contents;
    constants.FLAGGED_FILE_MAGIC_NUMBERS.forEach(entry => {
      this.check(buffer, entry);
    });
    return {
      linterMessages: this.linterMessages,
      scannedFiles: this.scannedFiles
    };
  }
}
exports["default"] = BinaryScanner;

/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _utils = __webpack_require__(19);
class BaseScanner {
  static get fileResultType() {
    /*
    Because each scanner expects a certain kind of data from the
    io libraries, a string or stream for example, we'll let the
    scanner define the type of data it expects. Most default to
    string.
     This can be overridden on the class.
     Because contents is passed to the constructor, we need to be
    able to access this before the constructor.
    */
    return 'string';
  }
  static get scannerName() {
    /*
    Each scanner has a unique name that identifies it. This value is currently
    being used to organize scanned files and report them.
     This must be overriden on the class.
    */

    throw new Error('scannerName is not implemented');
  }

  /**
   * @typedef {Object} ScannerOptions
   * @property {import('../parsers/manifestjson').Metadata} addonMetadata
   * @property {import('../collector').default} collector
   * @property {string[]} disabledRules
   * @property {boolean} enterprise
   * @property {string[]} existingFiles
   * @property {boolean} privileged
   *
   * @param {string|Buffer|import('stream').Readable} contents
   * @param {string} filename
   * @param {ScannerOptions} options
   */
  constructor(contents, filename, options = {}) {
    this.contents = contents;
    this.filename = filename;
    this.options = options;
    this.linterMessages = [];
    this.scannedFiles = [];
    this._defaultRules = [];
    this._parsedContent = null;
    this._rulesProcessed = 0;
    (0, _utils.ensureFilenameExists)(this.filename);
  }
  async scan(_rules = this._defaultRules) {
    const contents = await this.getContents();
    // Ignore private functions exported in rule files.
    //
    // (These are exported for testing purposes, but we don't want
    // to include them in our linter's rules.)
    const rules = (0, _utils.ignorePrivateFunctions)(_rules);
    const ruleResults = await Promise.all(Object.keys(rules).map(rule => {
      this._rulesProcessed++;
      return rules[rule](contents, this.filename, this.options);
    }));
    ruleResults.forEach(messages => {
      this.linterMessages = this.linterMessages.concat(messages);
    });
    return {
      linterMessages: this.linterMessages,
      scannedFiles: [this.filename]
    };
  }
  async getContents() {
    if (this._parsedContent !== null) {
      return this._parsedContent;
    }
    this._parsedContent = await this._getContents();
    return this._parsedContent;
  }
  async _getContents() {
    throw new Error('_getContents is not implemented');
  }
}
exports["default"] = BaseScanner;

/***/ }),
/* 115 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _path = __webpack_require__(9);
var _base = _interopRequireDefault(__webpack_require__(114));
var messages = _interopRequireWildcard(__webpack_require__(17));
var constants = _interopRequireWildcard(__webpack_require__(15));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class FilenameScanner extends _base.default {
  static get scannerName() {
    return 'filename';
  }
  async scan() {
    const extension = (0, _path.extname)(this.filename);
    const filenameWithoutPath = (0, _path.basename)(this.filename);
    if (constants.ALREADY_SIGNED_REGEX.test(this.filename)) {
      this.linterMessages.push({
        ...messages.ALREADY_SIGNED,
        type: constants.VALIDATION_WARNING,
        file: this.filename
      });
    } else if (constants.HIDDEN_FILE_REGEX.test(this.filename)) {
      this.linterMessages.push({
        ...messages.HIDDEN_FILE,
        type: constants.VALIDATION_WARNING,
        file: this.filename
      });
    } else if (constants.FLAGGED_FILE_REGEX.test(this.filename)) {
      this.linterMessages.push({
        ...messages.FLAGGED_FILE,
        type: constants.VALIDATION_WARNING,
        file: this.filename
      });
    } else if (constants.FLAGGED_FILE_EXTENSIONS.includes(extension)) {
      this.linterMessages.push({
        ...messages.FLAGGED_FILE_EXTENSION,
        type: constants.VALIDATION_WARNING,
        file: this.filename
      });
    } else if (constants.RESERVED_FILENAMES.includes(filenameWithoutPath)) {
      this.linterMessages.push({
        ...messages.RESERVED_FILENAME,
        type: constants.VALIDATION_ERROR,
        file: this.filename
      });
    } else {
      throw new Error(`Filename didn't match a regex: ${this.filename}.`);
    }
    return {
      linterMessages: this.linterMessages,
      scannedFiles: this.scannedFiles
    };
  }
}
exports["default"] = FilenameScanner;

/***/ }),
/* 116 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _cheerio = _interopRequireDefault(__webpack_require__(117));
var _base = _interopRequireDefault(__webpack_require__(114));
var rules = _interopRequireWildcard(__webpack_require__(118));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class HTMLScanner extends _base.default {
  _defaultRules = rules;
  static get scannerName() {
    return 'html';
  }
  async _getContents() {
    const htmlDoc = _cheerio.default.load(this.contents);
    return htmlDoc;
  }
}
exports["default"] = HTMLScanner;

/***/ }),
/* 117 */
/***/ ((module) => {

module.exports = require("cheerio");

/***/ }),
/* 118 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var _warnOnInline = __webpack_require__(119);
Object.keys(_warnOnInline).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _warnOnInline[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _warnOnInline[key];
    }
  });
});
var _warnOnRemoteScript = __webpack_require__(120);
Object.keys(_warnOnRemoteScript).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (key in exports && exports[key] === _warnOnRemoteScript[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _warnOnRemoteScript[key];
    }
  });
});

/***/ }),
/* 119 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.warnOnInline = warnOnInline;
var _const = __webpack_require__(15);
var messages = _interopRequireWildcard(__webpack_require__(17));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
async function warnOnInline($, filename) {
  const linterMessages = [];
  $('script').each((i, element) => {
    if ($(element).attr('src') === undefined && ($(element).attr('type') === undefined || $(element).attr('type') === 'text/javascript')) {
      linterMessages.push({
        ...messages.INLINE_SCRIPT,
        /* This could occur in any HTML file, so let's make it
         * a warning in case they've included any other file. */
        type: _const.VALIDATION_WARNING,
        file: filename
      });
    }
  });
  return linterMessages;
}

/***/ }),
/* 120 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.warnOnRemoteScript = warnOnRemoteScript;
var _const = __webpack_require__(15);
var _formats = __webpack_require__(49);
var messages = _interopRequireWildcard(__webpack_require__(17));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
async function warnOnRemoteScript($, filename) {
  const linterMessages = [];
  $('script').each((i, element) => {
    const src = $(element).attr('src');
    if (src !== undefined && !(0, _formats.isStrictRelativeUrl)(src)) {
      linterMessages.push({
        ...messages.REMOTE_SCRIPT,
        type: _const.VALIDATION_WARNING,
        file: filename
      });
    }
  });
  return linterMessages;
}

/***/ }),
/* 121 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _eslint = _interopRequireDefault(__webpack_require__(122));
var _eslintPluginNoUnsanitized = _interopRequireDefault(__webpack_require__(123));
var _commonTags = __webpack_require__(3);
var espree = _interopRequireWildcard(__webpack_require__(124));
var vk = _interopRequireWildcard(__webpack_require__(125));
var _const = __webpack_require__(126);
var _const2 = __webpack_require__(15);
var messages = _interopRequireWildcard(__webpack_require__(17));
var _utils = __webpack_require__(19);
var _javascript = _interopRequireDefault(__webpack_require__(127));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class JavaScriptScanner {
  disabledRules = [];
  constructor(code, filename, options = {}) {
    this.code = code;
    this.filename = filename;
    this.options = options;
    this.linterMessages = [];
    this.scannedFiles = [];
    this._rulesProcessed = 0;
    this.disabledRules = typeof options.disabledRules === 'string' ? options.disabledRules.split(',').map(rule => rule.trim()).filter(notEmptyRule => notEmptyRule) : [];
    (0, _utils.ensureFilenameExists)(this.filename);
  }
  static get fileResultType() {
    return 'string';
  }
  static get scannerName() {
    return 'javascript';
  }
  async scan({
    _ESLint = _eslint.default,
    _messages = messages,
    _ruleMapping = _const2.ESLINT_RULE_MAPPING,
    // This property is used to inject additional custom eslint rules
    // as part of tests.
    _rules = undefined
  } = {}) {
    const detectedSourceType = this.detectSourceType(this.filename);
    this.sourceType = detectedSourceType.sourceType;
    const rules = {};
    Object.keys(_ruleMapping).forEach(ruleName => {
      if (!this.disabledRules.includes(ruleName)) {
        rules[ruleName] = _ruleMapping[ruleName];
        this._rulesProcessed++;
      }
    });
    const linter = new _ESLint.Linter();

    // Load additional rules injected by unit tests.
    if (_rules) {
      for (const ruleName of Object.keys(_rules)) {
        linter.defineRule(ruleName, _rules[ruleName]);
      }
    }

    // Load custom eslint rules embedded into addons-linter bundle.
    for (const key of Object.keys(_javascript.default)) {
      linter.defineRule(key, _javascript.default[key]);
    }

    // Load plugins rules.
    const pluginRules = _eslintPluginNoUnsanitized.default.rules;
    for (const key of Object.keys(pluginRules)) {
      linter.defineRule(`no-unsanitized/${key}`, pluginRules[key]);
    }
    linter.defineParser('addons-linter-espree', espree);
    const eslintConfig = {
      env: {
        browser: true,
        es6: true,
        webextensions: true
      },
      // Ensure we use the same parser and parserOptions used to detect
      // the sourceType.
      parser: 'addons-linter-espree',
      parserOptions: {
        ecmaVersion: _const.ECMA_VERSION,
        sourceType: this.sourceType
      },
      rules,
      plugins: ['no-unsanitized'],
      // Scan files in `node_modules/` as well as dotfiles. As of ESLInt 7.0,
      // bower files are scanned.
      // See: https://github.com/mozilla/addons-linter/issues/1288
      // See: https://eslint.org/docs/user-guide/migrating-to-7.0.0#default-ignore-patterns-have-changed
      ignorePatterns: ['!node_modules/*', '!.*'],
      settings: {
        addonMetadata: this.options.addonMetadata,
        existingFiles: this.options.existingFiles,
        privileged: this.options.privileged
      }
    };
    const results = linter.verify(this.code, eslintConfig, {
      allowInlineConfig: false,
      filename: this.filename
    });

    // eslint prepends the filename with the current working directory,
    // strip that out.
    this.scannedFiles.push(this.filename);
    results.forEach(message => {
      let extraShortDescription = '';

      // Fatal error messages (like SyntaxErrors) are a bit different, we
      // need to handle them specially. Messages related to parsing errors do
      // not have a `ruleId`, which is why we check that, too.
      if (message.fatal === true && message.ruleId === null) {
        // If there was a parsing error during the sourceType detection, we
        // want to add it to the short description. We start by adding it to
        // a temporary variable in case there are other messages we want to
        // append to the final short description (which will be the `message`
        // in the final output).
        if (detectedSourceType.parsingError !== null) {
          const {
            type,
            error
          } = detectedSourceType.parsingError;
          extraShortDescription = `(Parsing as ${type} error: ${error})`;
        }

        // If there was another error, we want to append it to the short
        // description as well. `message.message` will contain the full
        // exception message, which likely includes a prefix that we don't
        // want to keep.
        const formattedError = message.message.replace('Parsing error: ', '');
        extraShortDescription = [extraShortDescription, (0, _commonTags.oneLine)`(Parsing as ${this.sourceType} error: ${formattedError} at
            line: ${message.line} and column: ${message.column})`].join(' ');
        // eslint-disable-next-line no-param-reassign
        message.message = _messages.JS_SYNTAX_ERROR.code;
      }
      if (typeof message.message === 'undefined') {
        throw new Error((0, _commonTags.oneLine)`JS rules must pass a valid message as
          the second argument to context.report()`);
      }

      // Fallback to looking up the message object by the message
      let code = message.message;
      let shortDescription;
      let description;

      // Support 3rd party eslint rules that don't have our internal
      // message structure and allow us to optionally overwrite
      // their `message` and `description`.
      if (Object.prototype.hasOwnProperty.call(_messages, code)) {
        ({
          message: shortDescription,
          description
        } = _messages[code]);
      } else if (Object.prototype.hasOwnProperty.call(messages.ESLINT_OVERWRITE_MESSAGE, message.ruleId)) {
        const overwrites = messages.ESLINT_OVERWRITE_MESSAGE[message.ruleId];
        shortDescription = overwrites.message || message.message;
        description = overwrites.description || message.description;
        if (overwrites.code) {
          code = overwrites.code;
        }
      } else {
        shortDescription = code;
        description = null;
      }
      if (extraShortDescription.length) {
        shortDescription += ` ${extraShortDescription}`;
      }
      this.linterMessages.push({
        code,
        column: message.column,
        description,
        file: this.filename,
        line: message.line,
        message: shortDescription,
        sourceCode: message.source,
        type: _const2.ESLINT_TYPES[message.severity]
      });
    });
    return {
      linterMessages: this.linterMessages,
      scannedFiles: this.scannedFiles
    };
  }
  _getSourceType(node, topLevel) {
    const possibleImportExportTypes = ['ExportAllDeclaration', 'ExportDefaultDeclaration', 'ExportNamedDeclaration', 'ExportSpecifier', 'ImportDeclaration', 'ImportDefaultSpecifier', 'ImportNamespaceSpecifier', 'ImportSpecifier'];
    const functionTypes = ['ArrowFunctionExpression', 'FunctionDeclaration', 'FunctionExpression'];
    if (possibleImportExportTypes.includes(node.type) || topLevel && node.type === 'AwaitExpression') {
      return 'module';
    }
    const stayTopLevel = topLevel && !functionTypes.includes(node.type);
    const keys = vk.KEYS[node.type];
    if (keys.length >= 1) {
      for (let i = 0; i < keys.length; ++i) {
        const child = node[keys[i]];
        if (Array.isArray(child)) {
          for (let j = 0; j < child.length; ++j) {
            if (child[j] && this._getSourceType(child[j], stayTopLevel) === 'module') {
              return 'module';
            }
          }
        } else if (child && this._getSourceType(child, stayTopLevel) === 'module') {
          return 'module';
        }
      }
    }
    return 'script';
  }
  detectSourceType() {
    /*
     * Analyze the source-code by naively parsing the source code manually and
     * checking for module syntax errors and/or some features in the source code
     * in order to determine the source type of the file.
        * This function returns an object with the source type (`script` or
     * `module`) and a non-null parsing error object when parsing has failed with
     * the default source type. The parsing error object contains the `error`
     * message and the source `type`.
    */
    // Default options taken from eslint/lib/linter:parse
    const parserOptions = {
      filePath: this.filename,
      sourceType: 'module',
      ecmaVersion: _const.ECMA_VERSION
    };
    const detected = {
      sourceType: 'module',
      parsingError: null
    };
    try {
      const ast = espree.parse(this.code, parserOptions);
      detected.sourceType = this.filename.endsWith('.mjs') || this.code.includes('import.meta') ? 'module' : this._getSourceType(ast, true);
    } catch (exc) {
      const line = exc.lineNumber || '(unknown)';
      const column = exc.column || '(unknown)';
      let error = `${exc.message} at line: ${line} and column: ${column}`;

      // When there is no line/column, it likely means something went wrong in
      // our code (`_getSourceType()`) and we should know about it so we append
      // a comment to hopefully get new bug reports.
      if (!exc.lineNumber || !exc.column) {
        error = (0, _commonTags.oneLine)`${error}. This looks like a bug in addons-linter,
          please open a new issue:
          https://github.com/mozilla/addons-linter/issues`;
      }
      detected.sourceType = 'script';
      detected.parsingError = {
        type: parserOptions.sourceType,
        error
      };
    }
    return detected;
  }
}
exports["default"] = JavaScriptScanner;

/***/ }),
/* 122 */
/***/ ((module) => {

module.exports = require("eslint");

/***/ }),
/* 123 */
/***/ ((module) => {

module.exports = require("eslint-plugin-no-unsanitized");

/***/ }),
/* 124 */
/***/ ((module) => {

module.exports = require("espree");

/***/ }),
/* 125 */
/***/ ((module) => {

module.exports = require("eslint-visitor-keys");

/***/ }),
/* 126 */
/***/ ((module) => {

module.exports = require("addons-scanner-utils/dist/const");

/***/ }),
/* 127 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _contentScriptsFileAbsent = _interopRequireDefault(__webpack_require__(128));
var _globalRequireArg = _interopRequireDefault(__webpack_require__(129));
var _noDocumentWrite = _interopRequireDefault(__webpack_require__(130));
var _opendialogNonlitUri = _interopRequireDefault(__webpack_require__(131));
var _opendialogRemoteUri = _interopRequireDefault(__webpack_require__(132));
var _webextensionApi = _interopRequireDefault(__webpack_require__(133));
var _webextensionApiCompat = _interopRequireDefault(__webpack_require__(135));
var _webextensionApiCompatAndroid = _interopRequireDefault(__webpack_require__(136));
var _webextensionDeprecatedApi = _interopRequireDefault(__webpack_require__(137));
var _webextensionUnsupportedApi = _interopRequireDefault(__webpack_require__(138));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
var _default = exports["default"] = {
  'content-scripts-file-absent': _contentScriptsFileAbsent.default,
  'global-require-arg': _globalRequireArg.default,
  'no-document-write': _noDocumentWrite.default,
  'opendialog-nonlit-uri': _opendialogNonlitUri.default,
  'opendialog-remote-uri': _opendialogRemoteUri.default,
  'webextension-api': _webextensionApi.default,
  'webextension-api-compat': _webextensionApiCompat.default,
  'webextension-api-compat-android': _webextensionApiCompatAndroid.default,
  'webextension-deprecated-api': _webextensionDeprecatedApi.default,
  'webextension-unsupported-api': _webextensionUnsupportedApi.default
};

/***/ }),
/* 128 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var path = _interopRequireWildcard(__webpack_require__(9));
var _utils = __webpack_require__(19);
var _javascript = __webpack_require__(23);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rule = {
  create(context) {
    const existingFiles = Object.keys(context.settings.existingFiles || {}).map(fileName => {
      return path.resolve('/', fileName);
    });
    return {
      MemberExpression(node) {
        if (!node.object.object || !(0, _utils.isBrowserNamespace)(node.object.object.name)) {
          // Early return when it's not our case.
          return;
        }
        const namespace = node.object.property.name;
        const property = node.property.name;
        // Namespace should be tabs function should be executeScript and it should be a call.
        // I.E. browser.tabs.executeScript().
        if (namespace !== 'tabs' || property !== 'executeScript' || node.parent.type !== 'CallExpression') {
          return;
        }
        node.parent.arguments.forEach(arg => {
          // Skipping the argument if it's not an object.
          if (arg.type !== 'ObjectExpression') {
            return;
          }
          const fileProperty = arg.properties.find(prop => prop.key && prop.key.name === 'file');
          const fileValue = fileProperty && fileProperty.value && fileProperty.value.value;
          // Skipping the argument if there is no file property, or value is not a static string.
          if (!fileProperty || fileProperty.value.type !== 'Literal' || typeof fileValue !== 'string') {
            return;
          }
          // If filename is empty, report an issue.
          if (fileValue === '') {
            context.report({
              loc: fileProperty.value.loc,
              message: _javascript.CONTENT_SCRIPT_EMPTY.code
            });
            return;
          }

          // We can't reliably validate relative file names because they
          // are resolved as relative to the current page url on Firefox
          // and the rule itself doesn't know the path of the html file (or
          // files) where the js file is going to be loaded, and so we chose
          // to validate only the absolute file paths to avoid false positive.
          // (Also note that Firefox and Chrome behave differently when
          // resolving relative content script paths used in a tabs.executeScript API call).
          if (!path.isAbsolute(fileValue)) {
            return;
          }
          const normalizedName = path.resolve('/', path.normalize(fileValue));

          // If file exists then we are good.
          if (existingFiles.includes(normalizedName)) {
            return;
          }

          // File not exists report an issue.
          context.report({
            loc: fileProperty.value.loc,
            message: _javascript.CONTENT_SCRIPT_NOT_FOUND.code
          });
        });
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 129 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _messages = __webpack_require__(17);
var _utils = __webpack_require__(19);
/*
 * This rule will detect a global passed to `require()` as the first argument.
 */
const rule = {
  create(context) {
    return {
      // eslint-disable-next-line consistent-return
      CallExpression(node) {
        if (node.callee.name === 'require' && node.arguments && node.arguments.length) {
          const firstArg = node.arguments[0];
          if (firstArg.type === 'Identifier') {
            const pathVar = (0, _utils.getVariable)(context, firstArg.name);
            if (typeof pathVar === 'undefined') {
              // We infer this is probably a global.
              return context.report(node, _messages.UNEXPECTED_GLOBAL_ARG.code);
            }
          }
        }
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 130 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _messages = __webpack_require__(17);
const rule = {
  create(context) {
    return {
      CallExpression(node) {
        if (node.callee?.type !== 'MemberExpression') {
          return;
        }
        const {
          object
        } = node.callee;
        if (object?.type !== 'Identifier' || object?.name !== 'document') {
          return;
        }
        const {
          property
        } = node.callee;
        if (property?.type !== 'Identifier' || property?.name !== 'write') {
          return;
        }
        context.report(node, _messages.NO_DOCUMENT_WRITE.code);
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 131 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _messages = __webpack_require__(17);
const rule = {
  create(context) {
    return {
      // eslint-disable-next-line consistent-return
      CallExpression(node) {
        if (node.callee.type === 'MemberExpression' && node.callee.property.type === 'Identifier' && node.callee.property.name === 'openDialog') {
          if (node.arguments.length) {
            const uri = node.arguments[0];
            if (uri.type !== 'Literal') {
              return context.report(node, _messages.OPENDIALOG_NONLIT_URI.code);
            }
          }
        }
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 132 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _utils = __webpack_require__(19);
var _messages = __webpack_require__(17);
const rule = {
  create(context) {
    return {
      // eslint-disable-next-line consistent-return
      CallExpression(node) {
        if (node.callee.type === 'MemberExpression' && node.callee.property.type === 'Identifier' && node.callee.property.name === 'openDialog') {
          if (node.arguments.length) {
            const uri = node.arguments[0];
            if (uri.type === 'Literal' && (
            // The first argument should be of type `string` but, if it is
            // not for some reasons, report a warning to be extra-safe.
            typeof uri.value !== 'string' || (0, _utils.isLocalUrl)(uri.value) === false)) {
              return context.report(node, _messages.OPENDIALOG_REMOTE_URI.code);
            }
          }
        }
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 133 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _browserApis = __webpack_require__(134);
var _utils = __webpack_require__(19);
const rule = {
  create(context) {
    return {
      // eslint-disable-next-line consistent-return
      MemberExpression(node) {
        if (node.object.object && (0, _utils.isBrowserNamespace)(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;
          if (!context.settings.addonMetadata.id && (0, _browserApis.isTemporaryApi)(namespace, property)) {
            return context.report(node, (0, _utils.apiToMessage)(api));
          }
        }
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 134 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getManifestVersion = getManifestVersion;
exports.getMaxManifestVersion = getMaxManifestVersion;
exports.getMinManifestVersion = getMinManifestVersion;
exports.hasBrowserApi = hasBrowserApi;
exports.isDeprecatedApi = isDeprecatedApi;
exports.isInSupportedManifestVersionRange = isInSupportedManifestVersionRange;
exports.isMV2RemovedApi = isMV2RemovedApi;
exports.isTemporaryApi = isTemporaryApi;
var _const = __webpack_require__(15);
var _imported = _interopRequireDefault(__webpack_require__(50));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const schemaArrayNames = ['functions', 'events'];
const schemaObjectNames = ['types', 'properties'];
const schemas = _imported.default.reduce((all, current) => ({
  ...all,
  [current.$id]: current
}), {});
function getObjectProperty(schema, property) {
  for (const schemaProperty of schemaObjectNames) {
    if (schema && schema[schemaProperty] && property in schema[schemaProperty]) {
      return schema[schemaProperty][property];
    }
  }
  return null;
}
function getArrayProperty(schema, property) {
  for (const schemaProperty of schemaArrayNames) {
    if (schema && schemaProperty in schema) {
      const namespaceProperties = schema[schemaProperty];
      if (Array.isArray(namespaceProperties)) {
        for (const schemaItem of namespaceProperties) {
          if (schemaItem.name === property) {
            return schemaItem;
          }
        }
      }
    }
  }
  return null;
}
function getManifestVersion(addonMetadata) {
  const {
    manifestVersion
  } = addonMetadata || {
    manifestVersion: _const.MANIFEST_VERSION_DEFAULT
  };
  return manifestVersion;
}
function getMaxManifestVersion(namespace, property, addonMetadata, apiSchemas = schemas) {
  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  let ns_max_mv = schema && schema.max_manifest_version;
  ns_max_mv = ns_max_mv == null ? _const.MANIFEST_VERSION_MAX : ns_max_mv;
  let prop_max_mv = schemaItem && schemaItem.max_manifest_version;
  prop_max_mv = prop_max_mv == null ? _const.MANIFEST_VERSION_MAX : prop_max_mv;

  // Return the lowest max_manifest_version value between the one set at
  // API namespace level and the one set on the particular property.
  return Math.min(ns_max_mv, prop_max_mv);
}
function getMinManifestVersion(namespace, property, addonMetadata, apiSchemas = schemas) {
  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  let ns_min_mv = schema && schema.min_manifest_version;
  ns_min_mv = ns_min_mv == null ? _const.MANIFEST_VERSION_MIN : ns_min_mv;
  let prop_min_mv = schemaItem && schemaItem.min_manifest_version;
  prop_min_mv = prop_min_mv == null ? _const.MANIFEST_VERSION_MIN : prop_min_mv;

  // Return the highest min_manifest_version value between the one set at
  // API namespace level and the one set on the particular property.
  return Math.max(ns_min_mv, prop_min_mv);
}
function isTemporaryApi(namespace, property) {
  return _const.TEMPORARY_APIS.includes(`${namespace}.${property}`);
}
function isMV2RemovedApi(namespace, property, addonMetadata, apiSchemas = schemas) {
  // The message for API deprecated in manifest_version 3 should not be
  // used if the currently validated addon has manifest_version 2.
  if (addonMetadata.manifestVersion === 2) {
    return false;
  }
  return getMaxManifestVersion(namespace, property, addonMetadata, apiSchemas) === 2;
}
function isInSupportedManifestVersionRange(namespace, property, addonMetadata, apiSchemas = schemas) {
  const manifestVersion = getManifestVersion(addonMetadata);
  const min_manifest_version = getMinManifestVersion(namespace, property, addonMetadata, apiSchemas);
  const max_manifest_version = getMaxManifestVersion(namespace, property, addonMetadata, apiSchemas);

  // The API isn't in a supported manifest version range if its schema entry has a
  // min_manifest_version greater than the extension manifest version or a
  // max_manifest_version lower than the extension manifest version.
  if (manifestVersion < min_manifest_version || manifestVersion > max_manifest_version) {
    return false;
  }
  return true;
}
function isDeprecatedApi(namespace, property, addonMetadata, apiSchemas = schemas) {
  // If the API has been removed in a certain manifest version, or only
  // available starting from a manifest version, then it is unsupported
  // and not deprecated.
  if (!isInSupportedManifestVersionRange(namespace, property, addonMetadata, apiSchemas)) {
    return false;
  }
  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  return schemaItem !== null && schemaItem.deprecated !== undefined || Object.prototype.hasOwnProperty.call(_const.DEPRECATED_JAVASCRIPT_APIS, `${namespace}.${property}`);
}
function hasBrowserApi(namespace, property, addonMetadata, apiSchemas = schemas) {
  // We "have" the API if it's deprecated or temporary so we don't double warn.
  if (isTemporaryApi(namespace, property) || isDeprecatedApi(namespace, property, addonMetadata, apiSchemas)) {
    return true;
  }

  // We don't have the API if the extension manifest_version is outside of the
  // manifest_version range where the API is actually supported for.
  if (!isInSupportedManifestVersionRange(namespace, property, addonMetadata, apiSchemas)) {
    return false;
  }

  // Or the schema entry for the API has an unsupported property set to true.
  const schema = apiSchemas[namespace];
  const schemaItem = getObjectProperty(schema, property) || getArrayProperty(schema, property);
  return schemaItem && !schemaItem.unsupported;
}

/***/ }),
/* 135 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _browserCompatData = _interopRequireDefault(__webpack_require__(34));
var _javascript = __webpack_require__(23);
var _utils = __webpack_require__(19);
var _browserApis = __webpack_require__(134);
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const rule = {
  create(context) {
    return (0, _utils.createCompatibilityRule)('firefox', _javascript.INCOMPATIBLE_API, context, _browserCompatData.default, _browserApis.hasBrowserApi);
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 136 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _browserCompatData = _interopRequireDefault(__webpack_require__(34));
var _javascript = __webpack_require__(23);
var _utils = __webpack_require__(19);
var _browserApis = __webpack_require__(134);
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const rule = {
  create(context) {
    return (0, _utils.createCompatibilityRule)('firefox_android', _javascript.ANDROID_INCOMPATIBLE_API, context, _browserCompatData.default, _browserApis.hasBrowserApi);
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 137 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var messages = _interopRequireWildcard(__webpack_require__(17));
var _const = __webpack_require__(15);
var _browserApis = __webpack_require__(134);
var _utils = __webpack_require__(19);
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rule = {
  create(context) {
    return {
      MemberExpression(node) {
        if (!node.computed && node.object.object && (0, _utils.isBrowserNamespace)(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;
          const {
            addonMetadata
          } = context.settings;
          if ((0, _browserApis.hasBrowserApi)(namespace, property, addonMetadata) && (0, _browserApis.isDeprecatedApi)(namespace, property, addonMetadata)) {
            const msgId = _const.DEPRECATED_JAVASCRIPT_APIS[api];
            const messageObject =
            // eslint-disable-next-line import/namespace
            msgId && messages[msgId] || messages.DEPRECATED_API;
            context.report({
              node,
              message: messageObject.messageFormat,
              data: {
                api
              }
            });
          }
        }
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 138 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.create = void 0;
var _javascript = __webpack_require__(23);
var _browserApis = __webpack_require__(134);
var _utils = __webpack_require__(19);
const rule = {
  create(context) {
    return {
      MemberExpression(node) {
        if (!node.computed && node.object.object && (0, _utils.isBrowserNamespace)(node.object.object.name)) {
          const namespace = node.object.property.name;
          const property = node.property.name;
          const api = `${namespace}.${property}`;
          const {
            addonMetadata,
            privileged
          } = context.settings;
          if ((0, _browserApis.hasBrowserApi)(namespace, property, addonMetadata)) {
            return;
          }
          if ((0, _browserApis.isMV2RemovedApi)(namespace, property, addonMetadata)) {
            context.report({
              node,
              message: _javascript.REMOVED_MV2_API.messageFormat,
              data: {
                api
              }
            });
            return;
          }
          if (privileged && (
          // We should not have to test with `api` but with do because we
          // don't support nested namespaces yet, which seems common in
          // existing privileged extensions.
          //
          // See: https://github.com/mozilla/addons-linter/issues/4364
          addonMetadata?.experimentApiPaths?.has(namespace) || addonMetadata?.experimentApiPaths?.has(api))) {
            return;
          }
          context.report(node, _javascript.UNSUPPORTED_API.messageFormat, {
            api
          });
        }
      }
    };
  }
};
var _default = exports["default"] = rule;
const {
  create
} = rule;
exports.create = create;

/***/ }),
/* 139 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _json = _interopRequireDefault(__webpack_require__(110));
var _localeMessagesjson = _interopRequireDefault(__webpack_require__(140));
var _base = _interopRequireDefault(__webpack_require__(114));
var _const = __webpack_require__(15);
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class JSONScanner extends _base.default {
  static get scannerName() {
    return 'json';
  }
  async _getContents() {
    return this.contents;
  }
  async scan() {
    const json = await this.getContents();
    if (this.filename.endsWith(_const.MESSAGES_JSON) && this.filename.startsWith(_const.LOCALES_DIRECTORY)) {
      const localeMessagesJSONParser = new _localeMessagesjson.default(json, this.options.collector, this.options.addonMetadata, {
        filename: this.filename
      });
      localeMessagesJSONParser.parse();
    } else {
      const jsonParser = new _json.default(json, this.options.collector, this.options.addonMetadata, {
        filename: this.filename
      });
      jsonParser.parse();
    }
    return {
      linterMessages: [],
      scannedFiles: [this.filename]
    };
  }
}
exports["default"] = JSONScanner;

/***/ }),
/* 140 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _relaxedJson = _interopRequireDefault(__webpack_require__(32));
var messages = _interopRequireWildcard(__webpack_require__(17));
var _json = _interopRequireDefault(__webpack_require__(110));
var _const = __webpack_require__(15);
var _validator = __webpack_require__(36);
var _logger = _interopRequireDefault(__webpack_require__(4));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class LocaleMessagesJSONParser extends _json.default {
  constructor(jsonString, collector, addonMetadata, {
    filename = _const.MESSAGES_JSON,
    RelaxedJSON = _relaxedJson.default
  } = {}) {
    super(jsonString, collector, addonMetadata, {
      filename
    });
    this.relaxedJSON = RelaxedJSON;
  }
  parse() {
    super.parse(this.relaxedJSON);
    this.lowercasePlaceholders = {};

    // Set up some defaults in case parsing fails.
    if (typeof this.parsedJSON === 'undefined' || this.isValid === false) {
      this.parsedJSON = {};
    } else {
      // We've parsed the JSON; now we can validate the manifest.
      this._validate();
    }
  }
  errorLookup(error) {
    // This is the default message.
    let baseObject = messages.JSON_INVALID;
    const overrides = {
      instancePath: error.instancePath,
      line: error.line,
      file: this.filename
    };

    // Missing the message property.
    if (error.keyword === 'required') {
      if (error.params.missingProperty === 'message') {
        baseObject = messages.NO_MESSAGE;
      } else if (error.params.missingProperty === 'content') {
        baseObject = messages.NO_PLACEHOLDER_CONTENT;
      }
    } else if (error.keyword === 'additionalProperties') {
      if (error.schemaPath === '#/properties/placeholders/additionalProperties') {
        baseObject = messages.INVALID_PLACEHOLDER_NAME;
      }
    }
    return {
      ...baseObject,
      ...overrides
    };
  }
  getLowercasePlaceholders(message) {
    const messageObj = this.parsedJSON[message];
    if (!Object.prototype.hasOwnProperty.call(messageObj, 'placeholders')) {
      return undefined;
    }
    if (!Object.prototype.hasOwnProperty.call(this.lowercasePlaceholders, message)) {
      this.lowercasePlaceholders[message] = Object.keys(messageObj.placeholders).map(placeholder => placeholder.toLowerCase());
    }
    return this.lowercasePlaceholders[message];
  }
  hasPlaceholder(message, placeholder) {
    const messageObj = this.parsedJSON[message];
    return Object.prototype.hasOwnProperty.call(messageObj, 'placeholders') && this.getLowercasePlaceholders(message).includes(placeholder.toLowerCase());
  }
  _validate() {
    this.isValid = (0, _validator.validateLocaleMessages)(this.parsedJSON);
    if (!this.isValid) {
      _logger.default.debug('Schema Validation messages', _validator.validateLocaleMessages.errors);
      _validator.validateLocaleMessages.errors.forEach(error => {
        const message = this.errorLookup(error);
        this.collector.addError(message);
      });
    }
    const regexp = new RegExp(_const.MESSAGE_PLACEHOLDER_REGEXP, 'ig');
    const visitedLowercaseMessages = [];
    Object.keys(this.parsedJSON).forEach(message => {
      if (!visitedLowercaseMessages.includes(message.toLowerCase())) {
        visitedLowercaseMessages.push(message.toLowerCase());
      } else {
        this.collector.addError({
          ...messages.JSON_DUPLICATE_KEY,
          file: this.filename,
          description: `Case-insensitive duplicate message name: ${message} found in JSON`,
          instancePath: `/${message}`
        });
        this.isValid = false;
      }
      if (message.startsWith('@@')) {
        this.collector.addWarning({
          file: this.filename,
          instancePath: `/${message}`,
          ...messages.PREDEFINED_MESSAGE_NAME
        });
      }
      const messageContent = this.parsedJSON[message].message;
      let matches = regexp.exec(messageContent);
      while (matches !== null) {
        if (!this.hasPlaceholder(message, matches[1])) {
          this.collector.addWarning({
            file: this.filename,
            instancePath: `/${message}/placeholders/${matches[1]}`,
            ...messages.MISSING_PLACEHOLDER
          });
        }
        matches = regexp.exec(messageContent);
      }
      if (Object.prototype.hasOwnProperty.call(this.parsedJSON[message], 'placeholders')) {
        const visitedLowercasePlaceholders = [];
        Object.keys(this.parsedJSON[message].placeholders).forEach(placeholder => {
          if (!visitedLowercasePlaceholders.includes(placeholder.toLowerCase())) {
            visitedLowercasePlaceholders.push(placeholder.toLowerCase());
          } else {
            this.collector.addError({
              ...messages.JSON_DUPLICATE_KEY,
              file: this.filename,
              description: `Case-insensitive duplicate placeholder name: ${placeholder} found in JSON`,
              instancePath: `/${message}/placeholders/${placeholder}`
            });
            this.isValid = false;
          }
        });
      }

      // Reset the regexp
      regexp.lastIndex = 0;
    });
  }
}
exports["default"] = LocaleMessagesJSONParser;

/***/ }),
/* 141 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _path = __webpack_require__(9);
var _fluent = _interopRequireDefault(__webpack_require__(142));
var _properties = _interopRequireDefault(__webpack_require__(144));
var _doctype = _interopRequireDefault(__webpack_require__(145));
var _base = _interopRequireDefault(__webpack_require__(114));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class LangpackScanner extends _base.default {
  static get scannerName() {
    return 'langpack';
  }
  async _getContents() {
    return this.contents;
  }
  async scan() {
    const data = await this.getContents();
    const ext = (0, _path.extname)(this.filename);
    let ParserClass = null;
    if (ext === '.properties') {
      ParserClass = _properties.default;
    } else if (ext === '.ftl') {
      ParserClass = _fluent.default;
    } else if (ext === '.dtd') {
      ParserClass = _doctype.default;
    } else {
      throw new Error('Unsupported file type');
    }
    const parser = new ParserClass(data, this.options.collector, {
      filename: this.filename
    });
    parser.parse();

    // The parsers report directly to the collector so we don't have to
    // forward them anymore.
    return {
      linterMessages: [],
      scannedFiles: [this.filename]
    };
  }
}
exports["default"] = LangpackScanner;

/***/ }),
/* 142 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _syntax = __webpack_require__(143);
var messages = _interopRequireWildcard(__webpack_require__(17));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FluentParser {
  /*
   * Parse FTL files (https://projectfluent.io)
   * We are using FTL files in our language packs to specify translations.
   *
   */

  constructor(source, collector, {
    filename = null
  } = {}) {
    this._sourceString = source;
    this.collector = collector;
    this.filename = filename;
    this.isValid = null;
  }
  parse() {
    const resource = (0, _syntax.parse)(this._sourceString);
    this.parsedData = {};
    resource.body.forEach(entry => {
      if (entry.type === 'Junk') {
        this.isValid = false;

        // There is always just one annotation for a junk entry
        const annotation = entry.annotations[0];
        const matchedLine = (0, _syntax.lineOffset)(this._sourceString, annotation.span.end) + 1;
        const matchedColumn = (0, _syntax.columnOffset)(this._sourceString, annotation.span.end);
        const warningData = {
          ...messages.FLUENT_INVALID,
          file: this.filename,
          description: entry.annotations[0].message,
          column: matchedColumn,
          line: matchedLine
        };
        this.collector.addWarning(warningData);
      } else if (entry.id !== undefined) {
        this.parsedData[entry.id.name] = entry;
      }
    });
    if (this.isValid !== false) {
      this.isValid = true;
    }
  }
}
exports["default"] = FluentParser;

/***/ }),
/* 143 */
/***/ ((module) => {

module.exports = require("@fluent/syntax");

/***/ }),
/* 144 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
class PropertiesParser {
  /*
   * Parser for .properties files.
   * We are using .properties files in our language packs to specify
   * translations.
   *
   * See http://bit.ly/2xTdYgY (Properties File Format Specification) for
   * more details.
   */

  constructor(propertiesString, collector, {
    filename = null
  } = {}) {
    this._propertiesString = propertiesString;
    this.collector = collector;
    this.filename = filename;
    this.isValid = null;
  }
  parse() {
    this.parsedData = {};
    const lines = this._propertiesString.split('\n');
    let lineBuffer = null;
    lines.forEach(line => {
      const cleanedLine = line.trim();

      // Skip empty lines and comments
      if (!cleanedLine) {
        return;
      }
      if (cleanedLine.startsWith('#')) {
        return;
      }

      // Line wraps multiple lines
      if (cleanedLine.indexOf('=') === -1) {
        if (lineBuffer) {
          lineBuffer[1] += cleanedLine;
        }
      } else {
        if (lineBuffer) {
          // This line terminates a wrapped line
          this.parsedData[lineBuffer[0].trim()] = lineBuffer[1].trim();
        }
        lineBuffer = cleanedLine.split('=', 2);
      }
    });

    // Handle any left-over wrapped line data
    if (lineBuffer) {
      this.parsedData[lineBuffer[0].trim()] = lineBuffer[1].trim();
    }
    this.isValid = true;
  }
}
exports["default"] = PropertiesParser;

/***/ }),
/* 145 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
const ENTITY_RE = /<!ENTITY\s+([\w.]*)\s+("[^"]*"|'[^']*')\s*>/;
class DoctypeParser {
  /*
   * Minimalistic parser for DTD files.
   * We are using DTD files in our language packs to specify translations.
   *
   * It doesn't do any proper XML parsing because our DTD files are only
   * using a very small subset of what's needed so a simple regular expression
   * works just fine.
   *
   * The parsing code is largely inspired by scattered code from mozilla-central.
   */

  constructor(dtdString, collector, {
    filename = null
  } = {}) {
    this._dtdString = dtdString;
    this.collector = collector;
    this.filename = filename;
    this.isValid = null;
  }
  parse() {
    const entities = this._dtdString.match(new RegExp(ENTITY_RE, 'gi'));
    this.parsedData = {};
    if (!entities) {
      // Some files have no entities defined. Mark this as valid since we
      // expect this unfortunately...
      this.isValid = true;
      return;
    }
    entities.forEach(entity => {
      const [, key, value] = entity.match(new RegExp(ENTITY_RE, 'i'));

      // strip enclosing quotation marks
      const normalizedValue = value.slice(1, -1);
      this.parsedData[key] = normalizedValue;
    });
    this.isValid = true;
  }
}
exports["default"] = DoctypeParser;

/***/ }),
/* 146 */
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MINER_BLOCKLIST = void 0;
const MINER_BLOCKLIST = exports.MINER_BLOCKLIST = {
  code: [
  // CoinHive
  /window.CoinHive=window.CoinHive/, /CoinHive\.CONFIG/, /\bcryptonight_hash\b/, /CryptonightWASMWrapper/],
  filenames: [/coinhive(\.min)?\.js/, /cryptonight(\.min)\.js/]
};

/***/ }),
/* 147 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _hashes = _interopRequireDefault(__webpack_require__(148));
var _hasher = _interopRequireDefault(__webpack_require__(149));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// The entire content of hashes.txt will be part of the addons-linter.js
// bundle.

class Dispensary {
  constructor() {
    this._cachedHashes = null;
  }

  // Matches only against cached hashes; this is the API external apps and
  // libraries would use.
  match(contents) {
    if (this._cachedHashes === null) {
      this._cachedHashes = {};
      this._getCachedHashes().forEach(hashEntry => {
        const [hash, library] = hashEntry.split(/\s+/);
        this._cachedHashes[hash] = library;
      });
    }
    const contentsHash = (0, _hasher.default)(contents);
    if (Object.prototype.hasOwnProperty.call(this._cachedHashes, contentsHash)) {
      return this._cachedHashes[contentsHash];
    }
    return false;
  }
  _getCachedHashes() {
    return _hashes.default.split('\n').filter(value => {
      return value && value.length > 0 && value.substr(0, 1) !== '#';
    });
  }
}
exports["default"] = Dispensary;

/***/ }),
/* 148 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("1c4dfa5076f108dbd4c561fe07586ee37450f89128fe7cc0bd328927dc54d3fc angularjs.1.0.2.angular.js\n644bcfe95749001ad4cc0d10e5cf446842969638041c453088d60f3136ef834b angularjs.1.0.2.angular.min.js\n39e1643f57e8e29313d0e5405866df3d8d4b8c16184e241f8e0e718fec675bf5 angularjs.1.0.3.angular.js\nc58c98134e9e3b67d4b871c3d0218b6f1c37dbdd3b9dea90be10fbef6b75c374 angularjs.1.0.3.angular.min.js\neb3e8e28be36eeb36394c0b77a113e7990d49af459ea0ac18e657b6df9dc7e29 angularjs.1.0.4.angular.js\n8123237aae185702c679d9f8fa67465b04c4ba01d01f9206375e4f1898e0411e angularjs.1.0.4.angular.min.js\nffa5e9692e229b4d41f1660d953b384c305b1237719be83d49b5aeb83f4ceafe angularjs.1.0.5.angular.js\n73e5eb3851aaaea03a1a373fc887f21ca18ff42593f318254c6dd6b3c813bae3 angularjs.1.0.5.angular.min.js\n12b49ae5773e5fc1b10aa8d2e51f0004b3bb8e671f24b50002f52a70b224586f angularjs.1.0.6.angular.js\n8f0374fb53b974272d022df745cc19619d03b1bcab8e07ed91459bb95044d8f3 angularjs.1.0.6.angular.min.js\n958df2b88cf1b9f6f06f4c2fc3d3844157250fb08b13a9f7ec6d524c14ee8cdd angularjs.1.0.7.angular.js\n99cc22c729793ca6600e4ffa7edafea998d8c959e7337acd844ad6a9cc1a43d7 angularjs.1.0.7.angular.min.js\ne53bc33b8690d0fa497a0db1551a9b7bb80e4f18ad28fa2b3fe39978c8bf9fcc angularjs.1.0.8.angular.js\nff93f32fa1c814b898f9234893efc7391fcad58056b2cbab7015292ad08649bd angularjs.1.0.8.angular.min.js\n731de4615beb482eb3e99b98dfbeb8ea4574ed341996ac4e02f9f01e71513ee4 angularjs.1.1.0.angular.js\n90749d1013a9ab0af74b53e29a713beb8c8d0c109da95ab705c4a9e370080159 angularjs.1.1.0.angular.min.js\nec69f8e19f224ee7a253a434aa1f1c09e266c1d734fdc790752a6d50220085c9 angularjs.1.1.1.angular.js\nab22098d621f57c887cebc898553c34e1d62647f1d187429e39d8954418c03e9 angularjs.1.1.1.angular.min.js\n8c54d910d93499b0d7b9eb76f11212463823d407838f60f04031a7219a02c716 angularjs.1.1.2.angular.js\n3ab3439b056ed137e9821ebe747d72f25e53dc17287587ad4d944472e866c60e angularjs.1.1.2.angular.min.js\nb578fbbe34948ef9cf0ae8891b735dfb1fff65f56aa02880f80faedbe76fb4f6 angularjs.1.1.3.angular.js\n61eaa67d9a17e0a0d607bb9dc4de1b88a5122630b4169fb94704c18cbde00015 angularjs.1.1.3.angular.min.js\ne821957d72f971d8ac3fcc859b4d9f26d5597ad72da3e0c926221fa93918e625 angularjs.1.1.4.angular.js\n9542987c1e1886ca242f3f8be9737d66b1d9c671a9afc489210ac7e1339d87fc angularjs.1.1.4.angular.min.js\n65062bc72835829bf9702b845f854ba1e6bd9275dabff463ff08289555b838ca angularjs.1.1.5.angular.js\n98488c70d12681ff4931b7f0028d0598294da2b8a4cd0e267905310b8850df8a angularjs.1.1.5.angular.min.js\naf5fd91220e601ac246ab6e2d7920ebfb9e049f6e716f139e2b28a20a8795152 angularjs.1.2.0.angular.js\nddf013826e1550a7b8cf72713e3ee65627d70fca407f714c5992480b698be053 angularjs.1.2.0.angular.min.js\nc0692df50b38abac96a78c01b2fb8199210467e9c7c7355f8f904b3741a8b9b2 angularjs.1.2.1.angular.js\nc01036a9a405d180bd2b7771ab570c64e359d5ab99226c14a02e085b5c83f112 angularjs.1.2.1.angular.min.js\n47d27347356c91566166e91189f70084375f73d165bfd6ccef0a45f19f4aef8a angularjs.1.2.2.angular.js\nb626fd6bc8871983b78f6916096ffe6858969cc24cf1ef0007f69ca973cd5f13 angularjs.1.2.2.angular.min.js\n6b370d1a9dd481be4f25bedbf25fba802d7268e02907b73381d089d6dd97c30b angularjs.1.2.3.angular.js\n7e2028a47b96510f591a5e6385ef15106bb6e79b8bb01c8d5157254c2624d064 angularjs.1.2.3.angular.min.js\n2c680f4d487efed0abe2935099176a1eccb2f0b8a0ff2d59923aa2e30c2885e9 angularjs.1.2.4.angular.js\nad2c6c2c96f9e08a468398c049badea58fe321fd7330d854f4f09b2b3aae47fe angularjs.1.2.4.angular.min.js\n71c84eaeded5df25231043123481eb0627632639c1e5697c57383393d8ed4264 angularjs.1.2.5.angular.js\naaa9fa9f931de7a809b9aa3beb57a0b1c97bd956e88f8a2f2432bf256a6e3a18 angularjs.1.2.5.angular.min.js\n837d5bcea557f6528b9f2661b09b970934446ab0092e80edb95f8cbae450e09a angularjs.1.2.6.angular.js\n6bab69bd228a857526d5fd429896d1cadbba117e5ebb10025839697c3e6ba77f angularjs.1.2.6.angular.min.js\nf8e011b297f40b6f8d32613ba753759522d399bad90fab4cca2f448e60a647cd angularjs.1.2.7.angular.js\n8e2e81ab79ea31107f08048b882f93b596a299137697a837327d58d73e29bc66 angularjs.1.2.7.angular.min.js\nd616b3e0530d863eea99aa1cf544c91aa78aa19cd3ca7e6745a8be2185693ee1 angularjs.1.2.8.angular.js\n0857b07b84f4228d7df0d28bf3d2e588917138791d938f4898cb1cdfbd5cbda8 angularjs.1.2.8.angular.min.js\nc4efc2204d3af45f6e47faed35188933a8e0285bb8d6642c9baebf8ef8fb166c angularjs.1.2.9.angular.js\n715c0469f9068c039cfb0e0358d674f600de98d78f62349b817a7c65eceeb455 angularjs.1.2.9.angular.min.js\nef7559a31bcd6387b200ac69cd53385a24b74df9d73b8f8066e179cc45a2b5a2 angularjs.1.2.10.angular.js\nc93b316b55289018029e03198bc13ff075f75b6a58505be39cbda240cf5c909b angularjs.1.2.10.angular.min.js\naed2764d9eeb4ba2ee9e210f906dffbf63e99e7f36298b431e3d6a0b9285082a angularjs.1.2.11.angular.js\n2c3f3ea1c85f18a315b3fcf7f17e9ca8a87405a49674695b5d7106cffb539108 angularjs.1.2.11.angular.min.js\ncd861720441f6bf15871567d282972f32a58fa7132c3827872f9e680a059ac1b angularjs.1.2.12.angular.js\n03d766a04528cd9e08ef483bfb5172a15f111018b491ae7fef276d94759b5464 angularjs.1.2.12.angular.min.js\n1d47d32da6bebc70c9234771a77ea4369a09e2dd727298b9750ade82a0b35c86 angularjs.1.2.13.angular.js\n194d5fa83530ef8c86d554192d66068ea3629d02174b24cf3d08210a2a71c441 angularjs.1.2.13.angular.min.js\n922f29742d1717ee8b2225192022a7e266b5410c5ca05a1dd0f98500b9daabd2 angularjs.1.2.14.angular.js\ndca07ef6c9de1bca4f088b7376fef0d6007038999095098586de79f0f7381390 angularjs.1.2.14.angular.min.js\ne38aee34f640432306fcb95f70b654f4ad2e9e30ab9dc666fe0a4258b45684cb angularjs.1.2.15.angular.js\nb00e59b5f540672a114fba9de7c4eaf89c598abf33ea56ea83f9d9d74221080d angularjs.1.2.15.angular.min.js\nb9d767f0ab86489d55b0a822656a34dd633eda13ddf28e92254f2b7bace29889 angularjs.1.2.16.angular.js\n30dbf2946d9d5e066b027284a63d44d3a36d2f089327bef60fb864d0404f5918 angularjs.1.2.16.angular.min.js\ndf73fc31397807bf31d1dd924b00ee4b1320d9b1e84b7895d2b9a8567fa81f2f angularjs.1.2.17.angular.js\n922372c5addefd21416afa5f97076398cabe042f56f1f53c8f00c9bac43904d7 angularjs.1.2.17.angular.min.js\n477626d37dbe2ade0ef23e1cf01ffe64d7ce838c24eb70dd9ab5e88487fe53a0 angularjs.1.2.18.angular.js\nae92a9098b01f484afcec5679b7a7ac2fc9441b53b26936a598876191cbc1324 angularjs.1.2.18.angular.min.js\n4449a48eddedb11fae17db4e4d2b0ad88a51c8559a781ffb6c84dcbe9db99acf angularjs.1.2.19.angular.js\n16f837baf5b3c7a8d26ca7b141088172c5d49decfdd20a1530c8db23d65bd55c angularjs.1.2.19.angular.min.js\n25bc96ed5dc34d90eb368ea895bc8d5e48c50e782f4fca84d3079f53eb739229 angularjs.1.2.20.angular.js\n39f362579776a93870bff1e8ce894618a4fc582e2cbac0f41bdd8f0833bbfe50 angularjs.1.2.20.angular.min.js\n307578d21718f75ae5b0b97dacc6571e1ff5126174d5c7f909451465c4e935b3 angularjs.1.2.21.angular.js\n530af18d973951040a7c1d95e81d342527b0792abc1a1576add703b81de7cb7b angularjs.1.2.21.angular.min.js\nbbe38a911d708bb75033afa21bffb0778c50567bf141b73b74487adcf9463794 angularjs.1.2.22.angular.js\n647a35402d4cbeb872a5f7e15d13fd6544360094dca70e1de2b356ba3252ca21 angularjs.1.2.22.angular.min.js\n4beac51340a2ccf4a042e71238eedaf223af8d3dd98b39a2253aefe5f51e7a97 angularjs.1.2.23.angular.js\n85a4a1600e1f2ae678ec04ae59d41f0a1778f8322ccbc3ecaf143ba03c19c2f0 angularjs.1.2.23.angular.min.js\nbdbfaeab5f28f110c2f885e54fac443e2e6c75e3a90967c012724d6f8abd6634 angularjs.1.2.24.angular.js\n9165ba8fc918dbf05fd01ac6795edde8c032482e5f643b4e21493dfea5a8faff angularjs.1.2.24.angular.min.js\n70f2491bd66b9d3d32ced23cd608a68c3ee840d10937769f5203d282e575b030 angularjs.1.2.25.angular.js\n618acb62e25056e11858594d4dc20d9d1c357553afbf72152dcf185a7d321354 angularjs.1.2.25.angular.min.js\nbbafdf8f65e9d05e5cad38ed8421d59cdd34954164dbac4dbd17fd3544de5c79 angularjs.1.2.26.angular.js\nf8ea0e980b8bdca260f9f81d0e98360c3080fdc7fd3992cf611e05701e2e8a36 angularjs.1.2.26.angular.min.js\n31f2347b0abc1febb6c0807b4450a585640eb0241921b7dedcc8d45ef0ec165a angularjs.1.2.27.angular.js\n2d9a04bff97945a4f454da1a3e59470148688c698348bac4030d13bbe9d4d2ac angularjs.1.2.27.angular.min.js\n7da4f37d996a21b099791bceee32f61e6f80d268bc5ecba2e1b6cc8791be64f4 angularjs.1.2.28.angular.js\nd795f9a40db19debc303add76585e1d9297d9615725aaa033000694d1b26607c angularjs.1.2.28.angular.min.js\n7a100c1500ede0f16320cccc782a329b1ccc492a83da22c38bf98e3d36621078 angularjs.1.2.29.angular.js\n98126704568532e8b3fb771ce6f5f44ae6a24fbf53d61cd7792e23a75971abc6 angularjs.1.2.29.angular.min.js\n65caa19d7d9c8923bf8c16a6a4d2b9b7fd01ceb750e024bf3448f60de1e8ca62 angularjs.1.2.30.angular.js\nd49f913c9fc506b29edbfba4b470485cebfd274c27f0331d43c358d8a51ec4fb angularjs.1.2.30.angular.min.js\nda7d1c29404c145667caa0d1a075e6d259c062e7a089b341568a1655467fb624 angularjs.1.3.0.angular.js\n3c8b7fd2b45efc67951cbe89e6990c2df48c208c51d95f41e178c33d7c6afe9c angularjs.1.3.0.angular.min.js\nd5c7eca313eca609505600b335a5ea4bbb050e092f42c35769ffc11f5a113ecf angularjs.1.3.1.angular.js\n3cb2859090930390424084547fed12733d1140edf9de4d832c909c2bb9943b8c angularjs.1.3.1.angular.min.js\ne9c63d2a71346a707130bbeca417a9b0dac8f37fc2ede3e7c3cd8b5cf949535c angularjs.1.3.2.angular.js\ne8c1dd81bba8fdaf2fd1541f21eead115d8c9d974164822d3f2ca95ab6a3c2f8 angularjs.1.3.2.angular.min.js\nf6d50975765a076216c1215cca6455585420fdb5cbb4d9ae9e77980cc112619b angularjs.1.3.3.angular.js\n0fa8b536437f20687e5d58f289dd7b65dc0622f6e618a4f7c6a35fdcd54b5ccc angularjs.1.3.3.angular.min.js\n681f4f6e0ae5fb36231b6b7ea8a5dc43cceb4643ade4d968f9f10971fb85a901 angularjs.1.3.4.angular.js\n366446867ed5f1102b1877e4883442cefe3c506ca9266fbf7402491ed0e4ee41 angularjs.1.3.4.angular.min.js\n7d453547bb6dd0a6c2e35e54a18c91cb1171d778addcc044d26c0cb2b9417355 angularjs.1.3.5.angular.js\n0a40f65f98afca870dde5b30d534271277cee1885fcea5ced2849c8be244dedd angularjs.1.3.5.angular.min.js\n62fb4359e511651f4ebbcc712eb5c68db1111dba23fafcf4464f7f265c6618f6 angularjs.1.3.6.angular.js\n56a8a6147ededed9052109c5a261160ef3434cea0ae10d47a06c9def8fa580b1 angularjs.1.3.6.angular.min.js\n0f45cd33d548f29b8c5673fa62476650618e59a4ba7826172122bd70ef1cea49 angularjs.1.3.7.angular.js\n751e6533e07112f002ee4153a2089ed3f85d84294c24e6efa69ccb320192dbb2 angularjs.1.3.7.angular.min.js\n8163401b1b9b297045820602e89e735affb0f6b3d3ca44b2688238adaa9bf7c5 angularjs.1.3.8.angular.js\nb98c8ab1ee618b69140b9bdea1309a40620af8082cb4c5df626ef3306a3a2033 angularjs.1.3.8.angular.min.js\n855e9cae98bd1d99a5e4980a683809f548d2ce529e36824db1426bfe37410b05 angularjs.1.3.9.angular.js\ne770eab8d2f6e4906d7333180c8776a2c0bb8167c0ea1970e34c1e981e52bae8 angularjs.1.3.9.angular.min.js\nb6923afc990cf13bb2be81d4ce6a39f1f1c99759a3852372aa3c74c39645662c angularjs.1.3.10.angular.js\n16961f84d3b36f5409903e81c9f54d12e136f8a2d0a3be3af92cc6ba03c46dd9 angularjs.1.3.10.angular.min.js\n58bb58752bec57afca6910073822cdf4f2e4d689223bce0f4baf1656a7df8ae0 angularjs.1.3.11.angular.js\n32468373f578ac8da53e09f9b8014c1ab482cc55e7a36c5242654869868d0a9a angularjs.1.3.11.angular.min.js\nf240a217f6bd6921bd6c109f55c799ef1f5befac30fc268985851b0cb6b8c9ee angularjs.1.3.12.angular.js\n1dd753f9f396da4ec12db337568b563da43aceafd40c0c56a9045c754215fd14 angularjs.1.3.12.angular.min.js\n25efc681c673246655e588a69b3fcbcc9b5ce235070065f80c7551d5bc7ec840 angularjs.1.3.13.angular.js\n770efbc70ee48d6a88f06b868c9a619e87312259188cd7832fb5641e633e738f angularjs.1.3.13.angular.min.js\nee57461f52670de29598b7f16402ad01de6b43a5d9fc01dcb19d5ecbe96c105a angularjs.1.3.14.angular.js\n40d9636194d6fb5c16a6cc0f5a063dc26dab7b4003f6d2ff7131c5ec1611539b angularjs.1.3.14.angular.min.js\nf00562981c0735f8b22c4d8ba0c412b530525a894c64ab1abb0aa57ccde460d9 angularjs.1.3.15.angular.js\nc42fad6c7b9d9427296d497f78aa7cefb7145cc9ac459292e54a85bb3096d6c5 angularjs.1.3.15.angular.min.js\n8c8451b7154892c8e166abc7fe8355a79dacdd28e0e9e75cd781ff95366ca92d angularjs.1.3.16.angular.js\n37b41bd7b4970ed97c2d13799e9569c75392a5f6b2c33f009e2ba9a000f14982 angularjs.1.3.16.angular.min.js\nb7fcb34969e948de07617249b8d73c2cd2a6062dcc6268b781fafe6287cec321 angularjs.1.3.17.angular.js\ndec9aa7fcac09c4ab57a567adf17f8d0d56f396922e0f3de73a9d91009a4273d angularjs.1.3.17.angular.min.js\nf04d89afe95d0be3397cd61af0755017aea4849925f0adb4a7fa913d9186cb1d angularjs.1.3.18.angular.js\n97e5def9707525279c884c1349ffe70926fcaac735d85cedcd1fd06ac3c82ad9 angularjs.1.3.18.angular.min.js\nfc4ed6b3ae20e49408fa4e50e2c72a52e8fcb8a671f19e628a75f45e9050d4c3 angularjs.1.3.19.angular.js\nab5fd9afc69e8503c83084534c2ccf37768cb0343b896b7d28ada1c2036da7a5 angularjs.1.3.19.angular.min.js\nf00181f6ad75c328d851cb895939b2a64455e8c09b3810016e6d2ec8b7292908 angularjs.1.3.20.angular.js\nb55d7f54ac8adf8babaa190c9103cc2112e6a9f29131b3c7c2775dc32dd48630 angularjs.1.3.20.angular.min.js\n66cffa555f803b857a179525e59e05ea2de5ecb6b944ebee5b375a451759a114 angularjs.1.4.0.angular.js\n5249fb03d81c810a80e1ef2528013275f0c7d76aa35a32dc35c74a9a697c671f angularjs.1.4.0.angular.min.js\nfb50115e8f13e1aff515cb01b9201efa88ba6e6e05229e25afaa24d9c69e6514 angularjs.1.4.1.angular.js\n7e7d66f989fb2cceab74994313116a5b5dd01d48259573115b2334d5b6ce6dd0 angularjs.1.4.1.angular.min.js\nb20e6605541036f5a57964d7654e74cdb878534488d118999933d7a8d8c4f3b5 angularjs.1.4.2.angular.js\n2cc694d405c3ba49fae4f002518eef7daa8283b452c566573c4f3fb1bccb0118 angularjs.1.4.2.angular.min.js\n609a9ad718b76bb27c07e6e0265e0fc176420330629a838a4cf4e14a53470dce angularjs.1.4.3.angular.js\n475100ac60eb5888d8eef21478f44be68a8f9b8de929df04ec124d1ba1a99a4f angularjs.1.4.3.angular.min.js\n66a0d3f9fbfd3aae6a2444e42f8ce0756907d74272e1ff1c450c0aed47888215 angularjs.1.4.4.angular.js\n6e7b04565d26e03469157b5f89d657289f7228071e0c74486cdcefcb9f659491 angularjs.1.4.4.angular.min.js\naa8bba7f4d03441c958cb1b638eece01ac2651d878906ade4d53e828e4fb422c angularjs.1.4.5.angular.js\n942a690ecae47fb2058ca7ba621ff462d95ca56a0538da07a042c22c558fee4e angularjs.1.4.5.angular.min.js\n1e0def47508c4d7d8a9dd74ea29755b65bba2a46a782dd75d40a38877be54ac5 angularjs.1.4.6.angular.js\n6ef82bfa3ccf5eddbcf08a4117d6af932aac88b3b2c93b2afcc43f4b11deb967 angularjs.1.4.6.angular.min.js\nc4ec487016d13a10f320d75404cc88d27a82d67a4fd5ec4b7650f266cef62540 angularjs.1.4.7.angular.js\n6e284c84999f89ed354a16190617bc6ab19351bd5d563d9d5ad95be291e566a3 angularjs.1.4.7.angular.min.js\n337053cddc3d41046771d30d1a3c28f6165864155f9429ebb2f3e4bde37e49fc angularjs.1.4.8.angular.js\n961901624b685981c72ee207a2a204694ea62690fda03a6e9715dce2b2546e5a angularjs.1.4.8.angular.min.js\nf8d021bbab11503688051926d4846565501015830509297c799388bd9f385849 angularjs.1.4.9.angular.js\nadabbed018e578bca961126c42dcda5fa78d819ca6b1753be6c2333d7b4c56c5 angularjs.1.4.9.angular.min.js\nc328a7b05c7d10f81b35bab1293b9f123e88e1e9e2a325537bce557f02c5ff13 angularjs.1.4.10.angular.js\n67b41d45b622d42f169e6a92e218cd871c34b0d78f7bea3170dec3b5f76cf0dd angularjs.1.4.10.angular.min.js\n5b5f7950716eb47e6960e06b94d9a35af469156370739b780f095cd33acba542 angularjs.1.4.11.angular.js\n957c6fd006d9f004dc286da8e9818bab8162ed4f2c4070cae5db054bdd40b22e angularjs.1.4.11.angular.min.js\n8caf0d42dcf99093e69b1668cc06ef64f3dd25ed58fb648254634eee03e17826 angularjs.1.4.12.angular.js\ndf456c19d12961cabb62b9a7c1badf100ec035403c5586cab72bae18616b162f angularjs.1.4.12.angular.min.js\nd9bd3369cdc3d29b111841243413973ac9dd5785a7003a0af25ac9c0255389c2 angularjs.1.5.0.angular.js\nf01699a0c767f80d19875d6b5e818444a76b11d6c505215954ce937c55a024b7 angularjs.1.5.0.angular.min.js\n66eb46bbdbc6b7fa9a777c34ea0555671039754bd8c5287508bb45954bdc3f67 angularjs.1.5.1.angular.js\n2c3037317ef9dd5c15117184081b609c36e8c08eed72a225e08c1e4b2664a7cb angularjs.1.5.1.angular.min.js\n631ab93a5d27f1025abba4fae873ed4d679b39ef8bf1aceada901fc0e9f975f3 angularjs.1.5.2.angular.js\na537e544850f0bc675337e1f82dc34a12e6678211336b0a43771f5326c0cacf8 angularjs.1.5.2.angular.min.js\n1dee53ff55816e00159ef004761cee16cb746e2a20c39f5eeeb86bb8fbb53c35 angularjs.1.5.3.angular.js\n334cc68901b5cffa52871475a64176c815680a81dc3aa05534c329b3ca8c8368 angularjs.1.5.3.angular.min.js\nf8cb6fc9125e3e5276a069ee1985fe48a7fbc35dec1ea11d03fbd016ceabfea2 angularjs.1.5.4.angular.js\ncda12d541eb03e01007b8226d193ec7735ca5e762cf7b9e98807614f5b0c3ec0 angularjs.1.5.4.angular.min.js\n6e467d69740efddc25e7303b5d7eb48483242a832889737893cde20c4cd1fdc1 angularjs.1.5.5.angular.js\n81e452718cdf5563b520957cf6fcef7cbb612da5d11014dc34117a086b201e48 angularjs.1.5.5.angular.min.js\n8fcd91a3c757cb48640375503bdfd51a910511f47374ec8627528936b7776c6d angularjs.1.5.6.angular.js\n16706af65e828c2a74e084b08b0e98c87716cc9d1a1fe9cd59af3f02e15e7f6d angularjs.1.5.6.angular.min.js\n2f77efd4f092dc2f72060cf2e4b7b59854c12e9e268f2d59edd729b9d943461c angularjs.1.5.7.angular.js\nf360b725bf7c7760538ab07edb0ff04bd63ab25a1f337557e176c7a4959402a7 angularjs.1.5.7.angular.min.js\n21c32330ac3b47132afb75660f7a33d9f0db48fbe9c158d5d8183e4fb76fc3b0 angularjs.1.5.8.angular.js\n259b3428fc066be91e876511a51586979170847e0a272cb0cd38f5c8ead52867 angularjs.1.5.8.angular.min.js\n58a2b846718e440f436fced6359f2c017d842c3adeea49b2c3a96d4174976657 angularjs.1.5.9.angular.js\nd3a234b8a1c7b4facdcfa6eb9fcdfc79eef17cbe02ded7682c7bffc4e01f4264 angularjs.1.5.9.angular.min.js\nafab7ecba6ba82478ec8ac0e85db313a7d9ae502024f3c5edfd8923d320c7fed angularjs.1.6.0.angular.js\ne66bba8045f20c193818e0c219509c15b2b824155d21b265667e8f4d9fa5045e angularjs.1.6.0.angular.min.js\nc0734864f90ee81e16fc01fa8a8d2401a5743416270172ce45b6b4339ce13cdf angularjs.1.6.1.angular.js\n31f4c90ceee79c2c94ec2bee2310cb6a2e33d718fe3b131f51d7f38e4efbe847 angularjs.1.6.1.angular.min.js\n22e573f3c72dd9c4493083fc3d563dadc59371dd9e5f3cefcf771d9267e85f69 angularjs.1.6.2.angular.js\n2fe14bc751b550c840d5648659d339454396e1528d27e35bce704757892899a3 angularjs.1.6.2.angular.min.js\n245d702e5398f0c3ce125f653c649a682a2683f26046df04ce5fcf6886f37d4a angularjs.1.6.3.angular.js\n17f913d3f84223eee4267c50b3381d9ef266318ef1d4b5477d061fce71880083 angularjs.1.6.3.angular.min.js\nc657f1e3cec60437b6f13e5cfbd6bb392fa492e58f7b9ec30d89fd48b5acb4d2 angularjs.1.6.4.angular.js\n64e327b8fae7a4714dd9b5205e2e665f513baa4ea29d642d1864e78ecf9745da angularjs.1.6.4.angular.min.js\n12fe126cde305d13d131965c1d32a1f963d11668d9c7d11c59128afc15a7ebde angularjs.1.6.5.angular.js\n3cc43764b004039911fa7c7fc5288e86db00e7e600df7556d4b718b9c8c69378 angularjs.1.6.5.angular.min.js\n141860ecc363cd79f904aee13140c0a29dcc09b79afb27024ae15cdb5916f869 angularjs.1.6.6.angular.js\n813be17639d6c165847252e52aae08edf36c78dce3208675cfbf06635d448e1a angularjs.1.6.6.angular.min.js\n687c68ab0ce1f3be9dc6544a45bd09fe3c7ca3a1dcbb7f6285d31e8dc7ca523e angularjs.1.6.7.angular.js\n4cd4e981120915be09dacbad2e051f7e1c497308d7c4ca3c082beb24eb2ceec2 angularjs.1.6.7.angular.min.js\n64981915ffe2613fe041f6ee94b19214f3de34117059b073e5478e2324e15550 angularjs.1.6.8.angular.js\n76bc5f4a2616f78a80e42cb1e70aecf13f2a579181e39bc44bce2bf97e33352d angularjs.1.6.8.angular.min.js\nb9b2c4430af9dc58ef13f84c06f3d35629d104f51697d1562a7d8c5b9f4288ce angularjs.1.6.9.angular.js\nee78011a13dcb541325cb0fa85ae774c551aaa10429d714e8bbd766aa06ad3de angularjs.1.6.9.angular.min.js\n593da46ed8890edf70f2e97e82a629c931da3c72302b32a8663942c9b5c307d3 angularjs.1.6.10.angular.js\nb24f4e645db81ea79bb26791e2c282c5e31ab68900ecab482b88473bad2a9b9e angularjs.1.6.10.angular.min.js\n970ce734707a862daf71e25a61a2c6e6df4a9767b4769345e887bf809c887cb4 angularjs.1.7.0.angular.js\nc1db5ba2b270248abbe7b208fddc49a668abbc1c8e2dc5fc4f915db5368c47e0 angularjs.1.7.0.angular.min.js\n7a4677a73010ee5311f7d60f42b9f9c1ba2fbca5bcb857d43de13fdd6f933717 angularjs.1.7.1.angular.js\n8d270a4706d3f1b424c14379a8db850f2d0ded76deae4e3a0e969383b47f2528 angularjs.1.7.1.angular.min.js\ne7b2df78ad81bcea1b6105f65c8d5c9ba1fe6ea04f28482bd4a815ff3772712b angularjs.1.7.2.angular.js\naee3f6faea2b51b9527a0ed3a3393be6ef1369250a442655bcd574cd11b19114 angularjs.1.7.2.angular.min.js\nb343dd9c91367e97c962f9d7f6698d5625d6ebf24d4d9dc2cf7ac539ff777444 angularjs.1.7.3.angular.js\nb3725dabbcfdde7b0de94088512f8ac87e93547b6d92f91907d37fc997769572 angularjs.1.7.3.angular.min.js\n774e11c72da9659ea4ee4efc3f406344caf198c393e852d2ab071b759eaeaec2 angularjs.1.7.4.angular.js\n9282be770602ae121c8e1cbe5119476804919d245d229552622d24223659369c angularjs.1.7.4.angular.min.js\n45f953181413c96b911dc8e38114c1ae42cb9ed516acd326a8c055eaf07bf8bc angularjs.1.7.5.angular.js\n411273ddbd3f6590b88a52a60514636343209d5850f91475b6958b61a4518d2a angularjs.1.7.5.angular.min.js\n48d6cc7339629d6a8b731c6c17e7fc1ec31c4dc41371dbcd6c0c374fb442f62d angularjs.1.7.6.angular.js\n7cbac274ba47c6470b9fd5fd40de09db58f1ce1d8917b6aa5609f43f8f66ca17 angularjs.1.7.6.angular.min.js\nae296a6ada62035643bba9b604ada179ff6479e25758ff9ab1dd17e6e95f3e67 angularjs.1.7.7.angular.js\n1be42e2e6ae93c2ab4edd6c517588a2e39779cbe8cbefd6a5683332d5c87a69d angularjs.1.7.7.angular.min.js\ne3b0100b35fa76ace389c29ee0f69b68126d2e759f7e5df82d4f56254ba53688 angularjs.1.7.8.angular.js\ndb7862d0083ae74b5c94005d18274c3528f1be2932b72438e2f606a3d1f23ab5 angularjs.1.7.8.angular.min.js\n2420c59374dcdc1ca9721c334a32afee92f0610280cae0d1b3952b1279bc2b24 angularjs.1.7.9.angular.js\n6f936f9af51ccabd30a4138b9cd6da587e73290022be18fcc8c6217d712e9900 angularjs.1.7.9.angular.min.js\nc7df41bc00628bec220b0378dc1f2f5041980758403b6f24b9774ac43a9186d8 angularjs.1.8.0.angular.js\n566f18cb8bc23558701c2cc4f934fe50bcc85629d1aaf5d589f835f2b3e57a9f angularjs.1.8.0.angular.min.js\n6ba77ee7e5e8b1ddbfa601bcae30ec7d0daecba6d0993796ad52994bc8631f0d angularjs.1.8.1.angular.js\n24c3e060c87c2dd10f79b2be96ee58ad6b90a383d9217dc9ac2c8ce33d628d91 angularjs.1.8.1.angular.min.js\n237656fae6e39d02cd71cbcfbf91b7964eba5796aafca1bfcfff3b054ce3fed6 angularjs.1.8.2.angular.js\n24103af48b9ee0409c9178cd92eba5dc3cdf0c76827b7c265c4f6f681b4dc176 angularjs.1.8.2.angular.min.js\n2ebbacdc8393dac4ce1d4cfbb8eb1957ba7bd7811fa7bed67c94a4a1193a78f3 backbone.1.0.0.backbone.js\n918b67113f134ec866265fb26365dc1497c88af997f75bbd70ef8450ca7658e6 backbone.1.0.0.backbone-min.js\n5a36cd2b29bc952610f3d8689348056a9a0658014552d77eb47b23bc0f3350a8 backbone.1.1.0.backbone.js\n453ec40e1cf3ecc3309a6a5bbf0ae555ee2f5f80075e48e86ce37dc247dc135c backbone.1.1.0.backbone-min.js\nf5f741e7991113473236eb4da601cd50b44bdaea52f3b792a481c588bcd901a4 backbone.1.1.1.backbone.js\n06fac5a66f26137240f94bef2fc0d15f75fa2effe8aec8929b04eb60e6017436 backbone.1.1.1.backbone-min.js\n0977290d5e68ce40d516cd4dc3965586680024e51399f0ee54ee8ed3a99b1506 backbone.1.1.2.backbone.js\n75d28344b1b83b5fb153fc5939bdc10b404a754d93f78f7c1c8a8b81de376825 backbone.1.1.2.backbone-min.js\n4ac1c9ebee6ebcd1614a8f92d41cb270e61e0b8f61c804c0d1b26fda4b889824 backbone.1.2.0.backbone.js\ne2880d9b382972780cbd99f9873c4fdf06618b36a8a3666bdb9d895845816f40 backbone.1.2.0.backbone-min.js\nc27c8ad6ec8e148ed22a32035d67582e6affcdfa234e2cb2fac6611dbfd1781a backbone.1.2.1.backbone.js\na593ba9f6e85ce030c59fd367c88b624d267b2a8d895fc7b3dcec52cc5137084 backbone.1.2.1.backbone-min.js\n0b505a72e89152018c40056b6dd713668f96dbf508c0930e6ce7302cb7acfd88 backbone.1.2.2.backbone.js\na7a6e47c5aa6c6d79baca392fb0c868be41fdddd75d5e59440febb91ec9727a4 backbone.1.2.2.backbone-min.js\n3dd6732dfa24d1d79279ab81672b2092604b543489af42c7eba281f990c0cc43 backbone.1.2.3.backbone.js\nc3ca23012efd03572816f91fb7addce549b1c9a327703f47735d153db22365fe backbone.1.2.3.backbone-min.js\nb432f5da40a1a53b029f51a42aa99ac21bc602d9af942836f8c7b70d3d74da74 backbone.1.3.1.backbone.js\n1d9d21d7b55593465f76af4bd0572f414cec6f1e9acbe0a3e1780361b8243daf backbone.1.3.1.backbone-min.js\ndd893e9ef2073ac02297b00afecd74dd4ddd65e489dfe01a66911dd6bbf9e2e6 backbone.1.3.2.backbone.js\n3e18e2b46e90b8a8b428a68192fea849a52216c6d2c00ed0d25bb90b57520f99 backbone.1.3.2.backbone-min.js\n24dd2eef4f35014e126628a40f528a1d248193f04d54589313de6a2bef9a07a6 backbone.1.3.3.backbone.js\nd1ab688fac5538952804cf15a793c5cb0c0b2c4f9a365dacbe2e10f54599f9d4 backbone.1.3.3.backbone-min.js\nc64229c09c371f5a3251a94d009042a33e5ae232e2a694f1df5cb881838f4d5d backbone.1.4.0.backbone.js\n38ef8a0ff6cc1b70ebe7b2cedbb66160bdb36212cfd422489025d45039c536e7 backbone.1.4.0.backbone-min.js\na9d250db6b377dcc698f55167295d617b6eee4d5936121ff91eca5e7e140c361 bootstrap.3.1.1.bootstrap.js\n898d05a17f2cfc5120ddcdba47a885c378c0b466f30f0700e502757e24b403a1 bootstrap.3.1.1.bootstrap.min.js\n7970f31907d91bf0f19efe8aefee74d6f0a2d8c72b2f8f20a5e297d3c414a78f bootstrap.3.2.0.bootstrap.js\n24cc29533598f962823c4229bc280487646a27a42a95257c31de1b9b18f3710f bootstrap.3.2.0.bootstrap.min.js\n8e5884d1be3041eafbab27d898b8e401e0263c5bebaba17c97d82240064a362c bootstrap.3.3.0.bootstrap.js\n484081bfe6c76d77610eb71a6e71206fe5304d62c037f058b403592192069306 bootstrap.3.3.0.bootstrap.min.js\nc68fd9f7f7c8165a37c795ebfa68f958fc5e03cdefc2a586ad682199065c3330 bootstrap.3.3.1.bootstrap.js\nf971b901aeb9e55b07d472afee09bd5ae05159e1119dbd16d993e473565e7fc0 bootstrap.3.3.1.bootstrap.min.js\n47bf6b2e0bb21849f205a4f2d90c8e40b2773f3fdf4c764471cd050ef0a87378 bootstrap.3.3.2.bootstrap.js\nc8eeec83fe8bf655eeeda291466d268770436dde4e3e40416a85d05d3893e892 bootstrap.3.3.2.bootstrap.min.js\n41af969ee00e8132a0040094db2b1a79a15b4d9b7e2bb485012970fdf7b5c455 bootstrap.3.3.4.bootstrap.js\nd5fd173d00d9733900834e0e1083de86b532e048b15c0420ba5c2db0623644b8 bootstrap.3.3.4.bootstrap.min.js\nef43a4d502ffb688656851d788c42869d47e8840d007b4f4b66f62530171acd4 bootstrap.3.3.5.bootstrap.js\n4a4de7903ea62d330e17410ea4db6c22bcbeb350ac6aa402d6b54b4c0cbed327 bootstrap.3.3.5.bootstrap.min.js\ndefc39740ac1859d8e2785ed473208409627e87addd5f78f2deaacb93a12d51d bootstrap.3.3.6.bootstrap.js\n2979f9a6e32fc42c3e7406339ee9fe76b31d1b52059776a02b4a7fa6a4fd280a bootstrap.3.3.6.bootstrap.min.js\n0abe8deb334de1ba743b04d0399e99eba336afed9da72fc4c0a302c99f9238c8 bootstrap.3.3.7.bootstrap.js\n53964478a7c634e8dad34ecc303dd8048d00dce4993906de1bacf67f663486ef bootstrap.3.3.7.bootstrap.min.js\nada59556faf3292b672cf3df851c09d17c0a431b4ba9ee581dfdaa04dd7b986e bootstrap.3.4.0.bootstrap.js\n909ae563eb34f7e4285a3a643ab5d7c21c5e6a80f3f455b949ac45f08d0389b4 bootstrap.3.4.0.bootstrap.min.js\ndbd2a35e72edc7d6bde483481a912f1c38aa57fab2747d9b071d317339ee03a2 bootstrap.3.4.1.bootstrap.js\n9ee2fcff6709e4d0d24b09ca0fc56aade12b4961ed9c43fd13b03248bfb57afe bootstrap.3.4.1.bootstrap.min.js\n71577fb46a22fa031506bab9c5ddb4640e38ef10a1b4959a11288b41ce4b0757 bootstrap.4.0.0.bootstrap.js\ne7ed36ceee5450b4243bbc35188afabdfb4280c7c57597001de0ed167299b01b bootstrap.4.0.0.bootstrap.min.js\nea6899758b3058f66178c5693b6c661445fd2e007719a03f39c3054e299fc854 bootstrap.4.1.0.bootstrap.js\n0bca10549df770ab6790046799e5a9e920c286453ebbb2afb0d3055339245339 bootstrap.4.1.0.bootstrap.min.js\na4831a4b67fc1bebf996bbf08711e8404bc155a7e581aa42e74991b4cfec5993 bootstrap.4.1.1.bootstrap.js\nc5a17d46976d471cf060c5a0e25749a323d6ab20cf0910f40afed81047ba21ef bootstrap.4.1.1.bootstrap.min.js\n2c7d02cf21adcacc946e3bc44929aa780918fbb3faa15ba4d54f37d92c9876cd bootstrap.4.1.2.bootstrap.js\n21e2349686b7e697ee0f1a996c68505226660f60b2c2fd7f6ddaa2ca9196e3aa bootstrap.4.1.2.bootstrap.min.js\nf364953a3675a8b76babc5549808ac15aa424aad5ba606afb5741a0c62cf0008 bootstrap.4.1.3.bootstrap.js\n56c12a125b021d21a69e61d7190cefa168d6c28ce715265cea1b3b0112d169c4 bootstrap.4.1.3.bootstrap.min.js\na75de48568ac742de71e95205361b29e8a6b8a6e36c8f9ed7de842460347aa28 bootstrap.4.2.0.bootstrap.js\n366630ca775bc5b20830a9ed4139931a3515bae12e91a9ef3ceb5fb0e44fe57f bootstrap.4.2.0.bootstrap.min.js\n2b42a46918757ecfd461f29c9f304af46fd7ec7833b9a7952358493d2f12c6ce bootstrap.4.2.1.bootstrap.js\neb795deda8983fa5310627c9584cf3f3b95d272567113500059018b3941cb267 bootstrap.4.2.1.bootstrap.min.js\nf9bc57ec9968e9c41924d35474bc30e8c7c75de336d18c6449a244653fc915c9 bootstrap.4.3.0.bootstrap.js\n0b86e93ae07e8c3ee975204e6dbd53cbbce457b8f5e9c2397c4312285d488991 bootstrap.4.3.0.bootstrap.min.js\na65d5b4abb65aad37f302c96f1751362e2422a8869f7f889112556d77e384813 bootstrap.4.3.1.bootstrap.js\n0a34a87842c539c1f4feec56bba982fd596b73500046a6e6fe38a22260c6577b bootstrap.4.3.1.bootstrap.min.js\n0674025e35459cae7395a213d1cbeb38e21366b80b7dc87e4f6131cf8b542121 bootstrap.4.4.0.bootstrap.js\na0aa40883eeabb76d7ad6455c675cb57587b165355fa9e5824122bf0b382158c bootstrap.4.4.0.bootstrap.min.js\neba7fab904d092f1c5f23a6788b5898e7b5e11f990682fed01315ec3f9d3040f bootstrap.4.4.1.bootstrap.js\n5aa53525abc5c5200c70b3f6588388f86076cd699284c23cda64e92c372a1548 bootstrap.4.4.1.bootstrap.min.js\n8bf26ae9373c49b3cc06b9efabfb0e4df1fcd615b97a655ae0ecd93ea85cc2d2 bootstrap.4.5.0.bootstrap.js\n38544024da1a0fc2f706be6582557b5722d17f48ad9a8073594a0cf928e2e3ff bootstrap.4.5.0.bootstrap.min.js\n2d79a994d80f0c995818c022b6de3b41710ed6019e10b0ccc777f0d8a9fa9e04 bootstrap.4.5.1.bootstrap.js\nd0889aa19088fbef68000be609be58d2bf775e4ba1bc9a516a564b7df4172e89 bootstrap.4.5.1.bootstrap.min.js\ndd94aa9fafad4addd6cefb49809b9752132d5e9fe2afa116805440c733ebc22f bootstrap.4.5.2.bootstrap.js\n79c599dd760cec0c1621a1af49d9a2a49da5d45e1b37d4575bace0a5e0226582 bootstrap.4.5.2.bootstrap.min.js\n59d2f6b56cdd23a833a551671736b1130223f16b190f92f54e51d3290d833b58 bootstrap.4.5.3.bootstrap.js\nd8968086f7509df34c3278563dab87399da4f9dcdfb419818e3a309eedc70b88 bootstrap.4.5.3.bootstrap.min.js\nb5de8fd50518000158e7e3fae41b48cfe58582ecfccb1b53b9ade9e7224c2237 bootstrap.4.6.0.bootstrap.js\nedd03b96ae4ff7886406c59d7dfeeaa1b624a7da297bf2f92d0cb6b7f9633cba bootstrap.4.6.0.bootstrap.min.js\n82b25efd5ffc8cc0dce4ec01b6fe92723a35fcbda5d6062b86c36736773f0f4f dojo.1.7.0.dojo.js\n853a6ee8d4d6773eda5170d936aaea7ac918ebba684394ab567cc7875a13a5b0 dojo.1.7.0.dojo.js.uncompressed.js\nbc903d22eedea75897cd5d4de0fa06ebd9f01df6868d63fed7a38caccf59e928 dojo.1.7.1.dojo.js\n3b47a88144e5f65a2f30d2ca07738aaaafd51010a961e734456cdec17357e470 dojo.1.7.1.dojo.js.uncompressed.js\ne9935efdc7ab5a19a4dd9372f81685ede79ef190793518c5d48a580a12055466 dojo.1.7.2.dojo.js\n089f42418eac6783fdbb1269be4523044bfd400fc8d56f5ecfa8b5b503b9fb27 dojo.1.7.2.dojo.js.uncompressed.js\n81f50b5a0a825dcc82f3634d822916bbae20e900fc96296e337661b8c75b48d0 dojo.1.7.3.dojo.js\nb4f24349dbc6b032c8ba8ee6d7e2dcef73bf56776493128cfdd17fda910055ed dojo.1.7.3.dojo.js.uncompressed.js\n9620461b575c27a1a461dc309beb5b00f39df0e44e6c9dfdae440c9a18af2d14 dojo.1.7.4.dojo.js\n36427c25b3c225b8bdcb91ea6cf4fd8cc0a3dad76953171f0f107fddf0c827bf dojo.1.7.4.dojo.js.uncompressed.js\n921ff96ec824a99f700d3cd0f959036ad0cc95cfe79c9a025811773a59286dbf dojo.1.7.5.dojo.js\nc222a60b1bb9cd7c454e18c58902fb7f8d006f94f4e3b7806fb51ff012fcb325 dojo.1.7.5.dojo.js.uncompressed.js\n4dabb241e0245a6a5db287f86c5e63c706bfe50e3200d131ba6f661f71b11364 dojo.1.7.6.dojo.js\nc0777311b758aec8ac15c92956fb9ba6dc0468d399974c2dad97e72b1c83cde3 dojo.1.7.6.dojo.js.uncompressed.js\n76302f1340a29823ba1631cbc2bca2cd4748bbe472311db356fb6ae404269271 dojo.1.7.7.dojo.js\n7e9c72d4300654e49f847e15c6b5a84a83b1e03fd3263ea6b7c2e1e69f8ac561 dojo.1.7.7.dojo.js.uncompressed.js\n207e41b222b10451ca25f59b0ae657d97db68ac1778bc31b39cd358dd20d703e dojo.1.7.8.dojo.js\nae580ae46808ce3cd9ae2220cb58c35156120f90af748473111eeca4e8cdc1ec dojo.1.7.8.dojo.js.uncompressed.js\nd860a425d8465dea9833853068545e31627d6c6058a3c6eb7d848b25e85bd787 dojo.1.7.9.dojo.js\n0eb7a9f18ac88aa3806674065673ccd6c4fcc69ac61fa78e7adc9f390549c4f5 dojo.1.7.9.dojo.js.uncompressed.js\n757e8914ae1b2848913e386d106eea39de0f98def22ad34d408356c739287d97 dojo.1.7.10.dojo.js\n0c423eeb2933eda1b33a6dde00e63047d411327101aace02554ecdce39d53fc0 dojo.1.7.10.dojo.js.uncompressed.js\nf1ace739d95ff70954a18fac5721d214513d1acb4c09b3b1f21fe85f38c40258 dojo.1.7.11.dojo.js\nb11edb2be97e0067c316dbf99c284c3b83a059de15285bb208fb00ccfb629919 dojo.1.7.11.dojo.js.uncompressed.js\n432123910047231a7916a052c11339ecb918267ea7c7ce4f3fcaec7c2461e87d dojo.1.7.12.dojo.js\n22b6f1ea8f20deb9a5877f155e7e485fd137538e847614a759657283f2965b58 dojo.1.7.12.dojo.js.uncompressed.js\n28b62e60259062a9375d374b582af5fecabf6c00d2a2a34e50afa583d0a47daa dojo.1.8.0.dojo.js\nfae9906842eac7db78de2335ab9daf2158215d23b4235ef53085cd28585404c9 dojo.1.8.0.dojo.js.uncompressed.js\n3753e626cd4db25db80d9fedec158c9f6454424f57bd9787952c3bb4183ee0c9 dojo.1.8.1.dojo.js\nd53cbd16f9fa5c9eeed75a83a655a758c3e4027e52a624adfa5d28b8a303c8e5 dojo.1.8.1.dojo.js.uncompressed.js\ne06968c5eb518123341e410c88081b3f8a2a18719fb201471c893f399a6350ab dojo.1.8.2.dojo.js\n933c4cab82f9e2fb7495db9f24be40899e4037ae997e4cc579dcf03f992bf447 dojo.1.8.2.dojo.js.uncompressed.js\nc324a45299405cda450ecb362d53398b86b79c30ccaab90456c3f0f0fcd76045 dojo.1.8.3.dojo.js\n66be580131965a1b9a74fb518e4673691955af614cda78942be4322088d80c03 dojo.1.8.3.dojo.js.uncompressed.js\ne7ce66c0834b844b1dc89adce1af52911ee055692196a4548bd13ebb993a9637 dojo.1.8.4.dojo.js\n12e9d4fb5dcb8bb0929fb435f8cc55e4a0b0f45d66a881138a7436a7c168dc52 dojo.1.8.4.dojo.js.uncompressed.js\n3934461e3d6ccc0548ce3a52ee3e511c7cf3b84de67c06742591a63cc8b2f02f dojo.1.8.5.dojo.js\n702a41091c4231fbee091298b866a70ed0939ddd8fbe7f3ba2fbb34b90cddbfc dojo.1.8.5.dojo.js.uncompressed.js\n34054a67a42f1f2d35df887eb9c52cf8accf0e28c7c5f0f298ba0ab3767b8511 dojo.1.8.6.dojo.js\ndc4e6ecc0fee78073b40b715b3c40ba698deb37c491e44216f6ebbb27dbc0309 dojo.1.8.6.dojo.js.uncompressed.js\n9eab886b0161f46d83d27efde96fde81f1f40fc57f40d7fd9030d76c6ad5395f dojo.1.8.7.dojo.js\nfd4036eb00e17cbbf5bdb6a6e9f153f1f9b4b1c25ec61295a4f6ef69098c441d dojo.1.8.7.dojo.js.uncompressed.js\ne61158ab4f9f1698ea86685a14e1d75b4986876ccc1747c6a00352876ee2bc88 dojo.1.8.8.dojo.js\nc0a9ae1ee01da06af72b24f1e835b0235d2b27074a6525b29239defc94f98472 dojo.1.8.8.dojo.js.uncompressed.js\n23f2601f7274287d70c4527105cb4ae466388737308d0759c505c45a9ba7bc79 dojo.1.8.9.dojo.js\n4cc5715c8de5a21d1050a5222ea0a22a5cfc82d87dd24d91cd3a18807f016f74 dojo.1.8.9.dojo.js.uncompressed.js\n81cc970ca1381d0201f9c5f0135cb6f570cd371db735c7d681baf088462bd10f dojo.1.8.10.dojo.js\ncbecd1343563cc20f4e467a228f7d3fae08e0558d9262f9041f358751bec92fb dojo.1.8.10.dojo.js.uncompressed.js\n373096436904ddec22abcca59843552af9b31aa9f0a2cf25746bb805ef3050b2 dojo.1.8.11.dojo.js\n455b563b30134847ad68dbf5a0be07041b7ddbec0da97e1d2df48c4c51ef059d dojo.1.8.11.dojo.js.uncompressed.js\na4ef47998ea869b3c463a742297ee3af223ac25adefd890ac32d97f07c3e8909 dojo.1.8.12.dojo.js\n53dd16b03b575dbd94464eed202918038f111a5e1e25df17c202442f28bdfa60 dojo.1.8.12.dojo.js.uncompressed.js\nd56c7e6de9c4dfeeca86478f3b4b647314e3c16a8d1331bcf3b5a8be56a89539 dojo.1.8.13.dojo.js\nd53c953c6c3d8e70ae6c2e37c19ff17f8f1a98820f106afa427d86afc910ef9c dojo.1.8.13.dojo.js.uncompressed.js\n483c39b37c53c7d5f21f5e613cd4ddfdb8e6bcb822615b48957f7401ecb208d8 dojo.1.8.14.dojo.js\n7c0060f11c54d097be9b00092793e5b9c8589eb752cfe5a51e7ac8e75b37671d dojo.1.8.14.dojo.js.uncompressed.js\nb8e1583a893c3460644687f9696184489fd2953980e0e359d8a61b39fb0e8304 dojo.1.9.0.dojo.js\nb1c62acc36dfb3d22f6dd079739cd53c6de29b80ce2c1908b5d0926adc81b939 dojo.1.9.0.dojo.js.uncompressed.js\n72c898fd98bf672ca1d699e66019091016e30f699d8136477d1bfe365ab349b5 dojo.1.9.1.dojo.js\n77983bfe25f2697c520d8813949ab70bb99954ecdd620839f9374277506f1183 dojo.1.9.1.dojo.js.uncompressed.js\ncbf7d88069d17ff002caf14b19f735379d4bb5ead693879afc0435c048b87182 dojo.1.9.2.dojo.js\n45b40fd2a5528e8ab2865ca8bd859b47e1bf682950f313ad87eebb056fd19d3d dojo.1.9.2.dojo.js.uncompressed.js\ned6ef0779b933238714a18ba091b650faf2f3dadf27e36f2be52001acdcf1c64 dojo.1.9.3.dojo.js\nf95ac4c903e125119efa04dcf0c920a265503cb3a208fafa9a964c35bc8f7d9e dojo.1.9.3.dojo.js.uncompressed.js\n2a31b84e45a01f9a5d50e8cc37470e83b00dbfe108ef97f593aec61f8b7c5103 dojo.1.9.4.dojo.js\n8f2a523d2ad27b790d338e222ded9a5ba2b59d30e332247ceba37aaf18ae517f dojo.1.9.4.dojo.js.uncompressed.js\n367c36b15443e7186696a53428eee27fda12801c868223fe966e75543d5c704b dojo.1.9.5.dojo.js\nba9dbc8a6ae846536ce9c3cf3c41c3deb62685d6d778b32a4aa11a5c98903200 dojo.1.9.5.dojo.js.uncompressed.js\nee32334742434dbbf82c4537651ce1f507dd6df7b93daa002bad2b1551536e8a dojo.1.9.6.dojo.js\ne29720f3758289a539385d5e833158e726f6218f0c57eb7c0055b8a539fe3dcb dojo.1.9.6.dojo.js.uncompressed.js\n07b93382728bcad402764768ea621cf38934e24112118a7ef85d940f7fd4ace9 dojo.1.9.7.dojo.js\n1d24c6b8cf92474ea62aaefab9ddf4855a2c43c2ccaa1851f7c8402e589fcd72 dojo.1.9.7.dojo.js.uncompressed.js\n97c7fa366c8f8f9c9b16e2dafaa1178d399a85c217a73a32fa6f76588f58b57f dojo.1.9.8.dojo.js\n049bf422aa804e91e16d38921db5408a6e8f60253e7e7b876da17139fb7ffb9b dojo.1.9.8.dojo.js.uncompressed.js\nf7dced86cb81108ca8312a6c049f91d9cef2bc3f331a55179e11729c0b5e8f14 dojo.1.9.9.dojo.js\ncf07ff8ad6b598024ca8ad3535bfb0d5c443d203d160771ce4c37150708457f4 dojo.1.9.9.dojo.js.uncompressed.js\ncd89e930ff2ef317a364f836c3cfd93157d628cac99d9388a426c3cc454f8b07 dojo.1.9.10.dojo.js\nd7f05eb4d58a1a366434210c713085cc0c00934bb5d5ed7839ef45b85bb73632 dojo.1.9.10.dojo.js.uncompressed.js\n45c88c18b1df4076ad7396d24d8ce04bf364f980a40774d3030169bedb32405b dojo.1.9.11.dojo.js\n485011dab94383e00e492af4a89b33a224cb97abc23c01a6819e9db10acaa7be dojo.1.9.11.dojo.js.uncompressed.js\nf8abf1c4141a3004bc332cec4b2228efe1536e32291e530db03c2b2620fc14f5 dojo.1.10.0.dojo.js\n411631f62e05e5d28e30dd4edbdb8195c328d50e27b1b3b3fc10831c8800c930 dojo.1.10.0.dojo.js.uncompressed.js\n499519872f2b6c98d9dba90a3846396302e9f42ec8f7bb8531242005c3cf8ef6 dojo.1.10.1.dojo.js\n2529198478abb5b7650003770b66ac2392bb565f1a3de8f314c1c88c121f4db7 dojo.1.10.1.dojo.js.uncompressed.js\n14885e214fe38643fa8fe227bfd63fb4331c8aa561bec846a258083e21e5c386 dojo.1.10.2.dojo.js\ne5527a13931093956cc100571e0ea6f20d323fdf0d4c71dab5c0b4a4ad1d6f85 dojo.1.10.2.dojo.js.uncompressed.js\n3f09fbe9d81acca276c4ef51c8a753b3d26df1ff5a0b37701d60d7baecae08b8 dojo.1.10.3.dojo.js\n038deb9b19e0deb763ca49a6c49db587d965d112c4bdf95fb66d92b607f0cfbc dojo.1.10.3.dojo.js.uncompressed.js\nba977ebaa1707642301082453cee325428013c9aeabc6d01927bf944742d188d dojo.1.10.4.dojo.js\n251c223d77b90bc0d44c04eb83ee326ea70d82a6821bfb857b5fff542d977f14 dojo.1.10.4.dojo.js.uncompressed.js\n242beaef19cc0f321660a9bba8266a455b9bcddcde1383c6078f815e160f4e7c dojo.1.10.5.dojo.js\n17fca1777f24a41483a0da3a64b6ae931539cea9164ea94f2734a1ba8045a834 dojo.1.10.5.dojo.js.uncompressed.js\nec27a9d274c26fa94ab46e3ec3b21534105402e874b2364256bfbd6803cb2236 dojo.1.10.6.dojo.js\n5f729f24b0bba50dea247f208e20304f611722ead78f5ef68e54d7b4a973e0e2 dojo.1.10.6.dojo.js.uncompressed.js\n3ab5d486e64b065f9c2347b3b9dfeed091f9dbceb0c5a18e1a574300a37f9f69 dojo.1.10.7.dojo.js\ne7797a10d32905f5f0377961e2d2d54f95935a1ca89e8644dafdfccc75acb713 dojo.1.10.7.dojo.js.uncompressed.js\n1c39d21b38ac0929bfe92049011cf9535a1cfec86ca1447788c0627ef58d4586 dojo.1.10.8.dojo.js\n9a7c88e00563a3788216a593f9295d703ee26aa5a61c9056ee6064abb0f4da5b dojo.1.10.8.dojo.js.uncompressed.js\n6a0d306b23820747a5bcd05d8bb7330b48fdd6a2de6945e834a090103cad446c dojo.1.10.9.dojo.js\n27ae6c13aa7ea76663930df3319ce6a9d300990ac14502e708bff288d99df4d3 dojo.1.10.9.dojo.js.uncompressed.js\nf6903b9eb8b45ccf7b945b3178e3d42a9ccb1155eeb3346183bd96d1dcd08433 dojo.1.10.10.dojo.js\n6a975b993d151d42bcbdbe78d1b0387a3f00c6c10db4ec9bda87f93c32ac2d54 dojo.1.10.10.dojo.js.uncompressed.js\n919b9789ba3edd91fa841530ee04bfb9c15b131ffcff667167738819e34c7657 dojo.1.11.0.dojo.js\n485bf6e25d984747e9e31d1191e736e6087d1463b9c7e97eb0120a7170ec180e dojo.1.11.0.dojo.js.uncompressed.js\n79b5abf49beeece93805aaf2530a76f36e6fca246c15593dac9efc89ecd13f54 dojo.1.11.1.dojo.js\n74ad36cb5ecc18415b48df6cac4d844d348cf01dab0d762d6225eaf34ac1773a dojo.1.11.1.dojo.js.uncompressed.js\nef627db229af4d8f7171915b70d188edaaf9452b671f36744744138cb3052233 dojo.1.11.2.dojo.js\n73237cc8e1e49f42f84fd1f2f22d9a7cb01a4c02d1f2ab1d462955e768f19a99 dojo.1.11.2.dojo.js.uncompressed.js\nfd7d2224091238fa3377bcba9e3719c433c6c99f4904b11bebb3c6b1a761943d dojo.1.11.3.dojo.js\n85b282c5385d83046bae37eb0e9b57772d3e39e14054dd3b352dfd9e7642b430 dojo.1.11.3.dojo.js.uncompressed.js\n6921b42838b6cdb44db624b5bef72fb48150c510a7a6a4db21b77b79f8c9271f dojo.1.11.4.dojo.js\n03114ea550cf40aead0c8689c2595172456e6b10deb1046bb38efba40b39ddfd dojo.1.11.4.dojo.js.uncompressed.js\n887a824f71cc4d00664885e05be355a356a4966d26a086e0b09464f28802455e dojo.1.11.5.dojo.js\n1a9b935f65570177675ff930eaac702ca0e37cc811cec2553194a2aed4f839a8 dojo.1.11.5.dojo.js.uncompressed.js\nf6e08d6aa9b40a3cebe1c3a918e0f46ba7e67f48dafcbea934ff6a1c19031e5c dojo.1.11.6.dojo.js\na91ac1f661a428e53fdf045367af380fc5e9c901248e3f132fa82da2af7abacd dojo.1.11.6.dojo.js.uncompressed.js\n81e4f1683ff4ec19d6459093e48d090c89c4fae867f03c50b45fa04cec8cf39a dojo.1.11.7.dojo.js\n818bf0dbe31b8427c35144004af39822bccb47b67a43361112cbeac8b8c6f5c8 dojo.1.11.7.dojo.js.uncompressed.js\na49659bcfba19940bf300fd8f4fcedcfe16a73fcba884a5f6696fcb72a7b4aed dojo.1.11.8.dojo.js\n77e477b88f06c5e1ebfb9f175c3c1b289d57d6912ff0f83f109d48929c1ac79c dojo.1.11.8.dojo.js.uncompressed.js\n66e5cfb0beff698ed9b18c7d194b142d2e9df60cf4fcb841816c41ae62e762d8 dojo.1.11.9.dojo.js\nf0ab11fd568593f1095de23b7224c2a128158c23811ab3acfbaa6e32ee12dfc8 dojo.1.11.9.dojo.js.uncompressed.js\nca13190405c71c52471163927a0b699ed7d19745af97482a63b97e0bf3968ad4 dojo.1.11.10.dojo.js\n3d851d2c2b65513aaf062ecf5ce6896458788d5a1b4f499f2c79171e45e05237 dojo.1.11.10.dojo.js.uncompressed.js\n10bdd5faca8cf08fcc614c3888dfceaf96a5a89a20120ecd1b4a308a9c4eefe1 dojo.1.11.11.dojo.js\nbae83eeb257e56f7f0e664ec992dc4ed3d665aff6a64bab9ad4f5dd695439a80 dojo.1.11.11.dojo.js.uncompressed.js\n7de94e012d6c672ea693dc31718dd268e48f4c84d191d48d51584c56dd5e3ff3 dojo.1.12.1.dojo.js\nf6f3d579099f5e4162993b74e90b32f83dd119e2d6786a00eabdb323cdaf0184 dojo.1.12.1.dojo.js.uncompressed.js\n61c97a067f2d2302c333ddff7f03428c89acfa0a65e82fb5236a2ba85faa7474 dojo.1.12.2.dojo.js\nbaf6f5ee117ebb0822db977ed294f6d269f0703f6060b1e29798b1f72af0d17e dojo.1.12.2.dojo.js.uncompressed.js\n2d728e2e8880c3d26a8050907360e1f64fc6b92afbd7bc4cced90a8b33235849 dojo.1.12.3.dojo.js\nadf62db17d79368f0da18865195569f6bda723a97c08130f4ee2cf51be639981 dojo.1.12.3.dojo.js.uncompressed.js\nfb5559b017f8ef68d44b6941dc80e494bd41ff51c0306e8d2dcbe80a6f1c91c8 dojo.1.12.4.dojo.js\nf23f84ed6f10c725716e8eb93844953b722a6fa23f3212cc52038fc03f3f2b06 dojo.1.12.4.dojo.js.uncompressed.js\nf3366d531fa81d76a77b0d51c6a6ca8b22f4e04f863b196474753084602450be dojo.1.12.5.dojo.js\n5771aaae714ac7442f1828125b6bdeeebe3bc77f9823c9d28c5338006994afdd dojo.1.12.5.dojo.js.uncompressed.js\n9fb5ae16135b891df769843e5dba762dd12b0aec769e44fba8031410521d7bd2 dojo.1.12.6.dojo.js\n418e073889721a58174becde0e2f064a6db3ee69021f912590d4b9d936b6b689 dojo.1.12.6.dojo.js.uncompressed.js\n84acdb1366331869224a20b301934d86ca94918ae79e3c0c440b11681a020ad5 dojo.1.12.7.dojo.js\n7ef9ebea64ee69c70cebb220dfb3707dca3da7ba202b43ef657ffcf62da2f520 dojo.1.12.7.dojo.js.uncompressed.js\n7bfa2bc57ef2d8f892f9dc39f6fcdad80158563abad045903b461134a2491a10 dojo.1.12.8.dojo.js\ncd5960e6e560bfd4d3eb9b901108cf65fbf26565f712bef0f74bae9c37079240 dojo.1.12.8.dojo.js.uncompressed.js\n8eb585d45db2f4e74ed68595a17f53aeef8fec081f4f2bdc33ad980ead71bd56 dojo.1.12.9.dojo.js\n192b03f462146d55e81e62161602937b9297ca985ecbe3a71d4c72c7e9269ce0 dojo.1.12.9.dojo.js.uncompressed.js\n290c9d104f746a149b91e0bafca3026e235845ebff77ed857a9c3373a1c2820e dojo.1.13.0.dojo.js\n9d3b7434011411f6bfd0ae888745e29fcca2307b412e2065e051aa49376366e8 dojo.1.13.0.dojo.js.uncompressed.js\nb4e1bd6da4a94e59b0c01f7a42cfb94c27b337914d271f50086684eab3cba921 dojo.1.13.1.dojo.js\nb8777ec9dfedc1c85b41409e543d3bede80ba649c922fc82a92be35c13b7563a dojo.1.13.1.dojo.js.uncompressed.js\n78541163d2aeca9d6a7585d580d21ff30dd43308f2f51ca04f42edcc2477b4a1 dojo.1.13.2.dojo.js\n7615faef90d3e8e8638f5d1fc9bdd4615bb470c8546aed9fc6b95398eaf32990 dojo.1.13.2.dojo.js.uncompressed.js\n7ab6f9991edd5716a7aae0b34dd9e45ab64637296b8cee776065eacd0d2ab735 dojo.1.13.3.dojo.js\n2c169e8eb71ee1f5cc7152140088d6cff0a5756689e385c9714979eeedb947bc dojo.1.13.3.dojo.js.uncompressed.js\n03ac68c24bc96d5d9f4bd04fd473ccf299994adf061140a11657deeb64e1552b dojo.1.13.4.dojo.js\n8dde38b6795511aa88445cc0c1f404181fc707a4906f778358526bccb6f75046 dojo.1.13.4.dojo.js.uncompressed.js\nf3eff2897d84b6674e7ca24b2eb6cc48b285e4216abbf501ef107fa603c60866 dojo.1.13.5.dojo.js\n088d571191d8b76866931523eaa08518826447b4f24e8f828508e47f54c5f238 dojo.1.13.5.dojo.js.uncompressed.js\nb1b3347c1c6f52bd3fddd036562332b0f5abda9f3993b14b43ac9c91d59a9fdf dojo.1.13.6.dojo.js\n4e22602b4061d3ec429980899074a23ef89413ebfe66750b86857be9d6ace42d dojo.1.13.6.dojo.js.uncompressed.js\nc7a2c7065ba8b023d9f934ff8c8e7567cd2a712e4e3ebb1685c90583b74acf63 dojo.1.13.7.dojo.js\n9f4a189cd8aa1f5a32eb0be94f18673d725f03448bd5450fd5766dfd35aaf63c dojo.1.13.7.dojo.js.uncompressed.js\n06bb08a106662bc5a84e562b3d9e4b241832fea99bae4e227a39bb6d842d0d91 dojo.1.13.8.dojo.js\nf6c61e23fb219c056083a824666a79258c0c8dc3434dad79d2f591ecb5b2b7e5 dojo.1.13.8.dojo.js.uncompressed.js\n5f0a72cb8836660dc26028e02e742e2a00fcfae1373d10648b98a5c59b9d232a dojo.1.14.0.dojo.js\n95b57921614c772f851b2241f026600cb1067ceacd6411ed9ac22b9c4069a271 dojo.1.14.0.dojo.js.uncompressed.js\ncd4ffd0774b9c25f62e5e06f725a45df68b51be6b9771cbe0c535a6626ea194f dojo.1.14.1.dojo.js\n7468a8323006f5d6081dff2ebf2030493bfd3904ca5422f47d85df793213c20d dojo.1.14.1.dojo.js.uncompressed.js\n440eb3d983599bae49ca7662c180268e449c55f728625991a9499026c4f9261b dojo.1.14.2.dojo.js\naa3aad7aef5d66478d494fc9e2ef183347912c8ec1b125a4c4ba0f2769d27e74 dojo.1.14.2.dojo.js.uncompressed.js\nd98243e97dce8eeb8df67523c63636c6a7f6cae1fda9130145c33f90ef7213ae dojo.1.14.3.dojo.js\nae0b072488700cc5cfa780a11e05595cd4ad2a9654f416591ef5f5f7fd7138a5 dojo.1.14.3.dojo.js.uncompressed.js\nb1015f11b408bb8aeace6f45f74e220b1b6822b255e66d94d85684601236ee05 dojo.1.14.4.dojo.js\n6393f0ce24d6ad24e079d14d828f2d7d6ee972622ee6ba9b42d9eb220a339ac8 dojo.1.14.4.dojo.js.uncompressed.js\n18b68906b1fd78107c8010918ad624b29e493d2585392042a49a9add2fac84df dojo.1.14.5.dojo.js\n06d047044fc6f58934751ebcf01c6a9d12837eccb2458a778526968be88a9ed8 dojo.1.14.5.dojo.js.uncompressed.js\n71c3a7bc2748ea55337f083449ea96c94c331e3e6b44bf184ea64c2ff1a9aeb3 dojo.1.14.6.dojo.js\n929b5c25b7e029923f5dab3a92238e1d5b6aa63ca78a894d25e9016d855c5c2c dojo.1.14.6.dojo.js.uncompressed.js\n1eac6afd7f251bb175b2e1c803ea01d6d52c64bf142fc2f3a2a98021b53bb201 dojo.1.14.7.dojo.js\n40d0c8d020c40f7a19a797e4241679dd6450b2c4ccfdedd46bce3d1092fe93e8 dojo.1.14.7.dojo.js.uncompressed.js\nfb2637af528a6d6a2ca29da30edea909571e146c9b1b8ce423dbb2e80aa24ed6 dojo.1.15.0.dojo.js\n5b27271ee932e54f0c0cf564e679d9f7fdaa870147829147a2cc00dc9f851820 dojo.1.15.0.dojo.js.uncompressed.js\n0aa8d2f1d87e1ac64b6eb6f46af4dbb2daae72c53694a6b96c7affbbd2dbc15c dojo.1.15.1.dojo.js\n5fc1ef5485a6226a642f120b18980b97c6d1ba2b657ae1fb55fef0af08f2140a dojo.1.15.1.dojo.js.uncompressed.js\n6e10c114fda06a1e9e0ee759137eb711855b8b5b79d9b0690430cd8c78d70004 dojo.1.15.2.dojo.js\ndab527d5501d2f3c8e89640e6b8381a12daf947ca2dda18e9385f0b651f3307e dojo.1.15.2.dojo.js.uncompressed.js\n65bd2e3f530f58e008a0a50a3f5a81c298d79f58d5ff3a77e152ed3317cc03f9 dojo.1.15.3.dojo.js\n0dbe737caf362617f384fa4d37f1a337ea576cfea2bb85f9db95d779391cd143 dojo.1.15.3.dojo.js.uncompressed.js\nc7e92157e3e4bda8c0c4138f81731612c79f11ddf0baffc0cd0d491b0fff3e04 dojo.1.15.4.dojo.js\n40311807d6f14185634231910b316fcd75352adb860c73d5098933cf7a5c40d6 dojo.1.15.4.dojo.js.uncompressed.js\n8a91dba00b6f453b628ed694a783626962e169fc1568f240a21703ee06b9ce63 dojo.1.16.0.dojo.js\ne9be7d3e1fba080bac6510082443f1f6bc25c6b062682fa4d2ff309fe0606b9d dojo.1.16.0.dojo.js.uncompressed.js\n3e54cf69ec33b0e1396f6e91c6c847b8fc1f9d8e345b2eacd779da2cfb5c12da dojo.1.16.1.dojo.js\n17f5e510b2e1e03883c4b9b06cefe94c3fcdb84712ff52da384f1e437fb2112b dojo.1.16.1.dojo.js.uncompressed.js\n567589dd936f041b84ce30445a4dfa595c47a1876d4395fb3af22724e7789216 dojo.1.16.2.dojo.js\n3a97313175d735ad1e731198fdeb912ad29f5fba78693e30b890a5c64fd69ced dojo.1.16.2.dojo.js.uncompressed.js\n88989aa948130d6575be8818c323668ff31b60b4d6cbf59cc1e408f50e2c730e dojo.1.16.3.dojo.js\n685b76a900d3d1a762e87531640bcfe7bf92c6edae0cba88b48f9a9614d3d69d dojo.1.16.3.dojo.js.uncompressed.js\n6d25a56340a6af1f462ccc83ea43764a648baeca6f6fb87845ae3443c15fb856 dompurify.1.0.0.purify.js\na0a1e9bbc45a925a2defca10de8268de0bf54bb1894823be6f6f85823f381bd8 dompurify.1.0.0.purify.min.js\n9d8f3248df827a5a0bf6abc251154f75ddc0c3350b32a3734d0bdd0d71743348 dompurify.1.0.1.purify.js\nce372d4399f7650e1d5fcec5f969cb09cd6f9b2cec3c78f09ab3e22b7fde4af9 dompurify.1.0.1.purify.min.js\n044e3443079204c88f74b06900f7c51d9c7859cb04e1b5bae1d79d9180599b59 dompurify.1.0.2.purify.js\nb86ce1bb00f864da1cd6e2fb3ad75734644a6fe66a83786b8194194cdf3ca7fb dompurify.1.0.2.purify.min.js\n38e9ef1fec96c0e5acadfd03b6c0b84b625b353268f92e3d846574e408026dbd dompurify.1.0.3.purify.js\nada8b6bbb10707e45411d20c0a9a1ace2a43902b6107f745d2262ca7ae6b0267 dompurify.1.0.3.purify.min.js\na9e477c9c97a7f373ed79e9096b259483391235e55ac1691034ecca01143a5c4 dompurify.1.0.4.purify.js\n4e54f070828643c10d92940dfe27c7849c27bd65e206396e7254efc20f6adb59 dompurify.1.0.4.purify.min.js\n13c8d3ca836a2f7037ccab36a6effdc0019b21ec37287990d4a2ef8f622fc0c9 dompurify.1.0.5.purify.js\na0230e727b1ba3e4af9c6ef3e8ae2386807bea562cc5611c1b45432383e8d988 dompurify.1.0.5.purify.min.js\n998cb432a7e3621c2dd50c9838b1cc8f29b2dc680862942f80e0f26e1c889f2f dompurify.1.0.6.purify.js\nf68a8f8f3cb305be15d9ca0248cd5e1281e2c235854bc46c6957549e285b20ed dompurify.1.0.6.purify.min.js\n7fcd7b15d54d911f9b1e44bd5141c46b316e288a0dd33bfad231644d3ac31ce4 dompurify.1.0.7.purify.js\n79abb6ff0f9d7daf43856dcd330a023bd6c827501a6f6a0cc97f3140abd68bb9 dompurify.1.0.7.purify.min.js\nc7db7a6239a64f5dd64bf8f5391188944f9b288897bd57b6d3ced6965bcdc232 dompurify.1.0.8.purify.js\n586a54cd9d23e4a56f7fbb9f1b22a9a15a16c5ae01e5da68305628661dbe9dd9 dompurify.1.0.8.purify.min.js\n7dbca61353f727151bef8064d4902b1551486226425312b80f17902bc3233f36 dompurify.1.0.9.purify.js\n3b031921537bbd0b6ccbc040b36fe3d0a744df464a8662221642100e150173d2 dompurify.1.0.9.purify.min.js\n30afbfa33407ae4db24f430f64011260d7c0ac83ef20cc6fb7179faa5278ad02 dompurify.1.0.10.purify.js\nb14c88d7af5bc5842b044d1e4cb119343f2ee39f2074230f0981f216f4420565 dompurify.1.0.10.purify.min.js\nfe8854a979a5b59028f6f0b91f26ae64eb87e1a7eae34f47a197ccba19f0d1bd dompurify.1.0.11.purify.js\nf349f97667abbc2b862128a8c4696cba6af080c73c2c9293d306726e42ed90b3 dompurify.1.0.11.purify.min.js\n4983cd15c44b381fad566f6bda92031983edaa5c671ada19cbb43e3c444b76fd dompurify.2.0.0.purify.js\nb38628f0e95348aeecc2ef1bd125eb48546c387bbd9dbe4e5faffa407bad7565 dompurify.2.0.0.purify.min.js\n94091ede55b9d142964ccdead04fa7660273968d411c7b3240faa2af520fcb32 dompurify.2.0.1.purify.js\n5e05f3f02c115b14e5f0139459da0e1ac0d674b773bf0883ada98b6acc6c8ae2 dompurify.2.0.1.purify.min.js\n37f796be136fe0c8631b5bbc22fbaecccd5674434e289dd14b38f6983e0be893 dompurify.2.0.2.purify.js\n819e427372870fa2b73ff0161e1478661523b3db75789640608ba5e3f30925ce dompurify.2.0.2.purify.min.js\n3fe7608c96e9f05da5451e6be581bd43196e009fbc9af8b339671bdcb881c29d dompurify.2.0.3.purify.js\ne7c786296e92ba76de018d513fd5846e0de756207da35a839f1578c82213ab1e dompurify.2.0.3.purify.min.js\n8dc4b249eb0f14078c96383d6681fc82bc36e9662532691535ea8a0974df2a95 dompurify.2.0.4.purify.js\nf1c32f61347e827a00489c63848ec6950001fefb5fc934f96a628ec24fcd367c dompurify.2.0.4.purify.min.js\n891b6ba2c07db761d36aba2bed67d9ce45f26dfef002adeeab8a008c64597d41 dompurify.2.0.5.purify.js\ndcfdfc269945d5435faa6e67b1f159aeb6f37b007dd2af3f3e1816e710b2c8bb dompurify.2.0.5.purify.min.js\n6ade1534904fbedddbd763a2c8f7b0387520cfeb3d4115babbeadc9c6c73d5cd dompurify.2.0.6.purify.js\ncf46a58940cbff1c979d60fbbbd8abbcb60e7d214f822cd727360feb7a73114c dompurify.2.0.6.purify.min.js\n6f4c7b42d55275ff4fdaa709128c146f6ced066a7be04cd30b8a930fc77821f8 dompurify.2.0.7.purify.js\n88ef723b5232d0fda124d51e02f51047689e952b06278acebcaf844145f16fa1 dompurify.2.0.7.purify.min.js\ne68cada00150e1f08661aacef0f903f22b18a5206a83dd50fc17e8e297707230 dompurify.2.0.8.purify.js\n5cddb7bacf0052039f87b20417b93ac0ecc98f901a71bca67f52261c96932bde dompurify.2.0.8.purify.min.js\nf5d28f3d96807f40aa197afc0a9dd4fcca22de2701913e87c2e3f1568a35bb58 dompurify.2.0.9.purify.js\n1100cf1aba841be905d91425e88c9c5fcf4f6e1d2d1d3e95ff4f2ff4c95ba014 dompurify.2.0.9.purify.min.js\n9c91d5185163dae21188df3956dcd5f786feaaa5d24a58b4e1dfbd2419b17521 dompurify.2.0.10.purify.js\n4b7c291d2fca80c2af1661989378da69d3a9ab4493080f9ccc6305cdd2c0e467 dompurify.2.0.10.purify.min.js\ne5217d574ffeb340961e27ec212d7af28c5a666c49ae147cbea66669d7c05a0b dompurify.2.0.11.purify.js\n0adb53069defa9cc39e4ef97aa6acf8de035ef0882d56c519e320e797c07bbfb dompurify.2.0.11.purify.min.js\n72e76a53a5fdb864c459717cf537437e733055482d3c1b1e84ce15a6339fd14c dompurify.2.0.12.purify.js\n86de16006ba08da66e6022594d4dac5e599d41340b48ca043c703e6c7539f463 dompurify.2.0.12.purify.min.js\n778a388102f5027ecbdd0c65613ccc1e759cefd2fdfeea56b489e789f22f3cf9 dompurify.2.0.14.purify.js\nbfc18096983031cfbea2347aa42bd3032ced8d4ebe7a3f23297da9c3a0a4ba3d dompurify.2.0.14.purify.min.js\n4f02af9d27c22147a6636fbb64b661ee2ef718ac8dec94f33e129bc030d31579 dompurify.2.0.15.purify.js\n0ac3c18e066168c9bbd935067548cd1e08a8423af0c38ba7c201df9883794b78 dompurify.2.0.15.purify.min.js\n0f55ac5cef4bac5493f2d4e06f618a5ec8dac1b44f38467a128876a7e7a32b35 dompurify.2.0.16.purify.js\nd4f6422e71e4d62d22322e9b58286464448f059cce736a2284205b1635b80f22 dompurify.2.0.16.purify.min.js\ndd8b08ec1fdc4c3a3a48433456bc76ff5911af3a0a3cfc2a3db49f967cbcdc63 dompurify.2.0.17.purify.js\n3bf34509f478b702a496f92e6ed8cb474a3fe01e2ef254d4f9c9acdc01d5298c dompurify.2.0.17.purify.min.js\n2c8f21421d698b01d280cd91556f3ded5d43a89b5acbe781e7e5828bb42097e8 dompurify.2.1.0.purify.js\n379fa4423eb48e625e6fd758fda550483b6bcb92f48945a7e48fda0e4c8854af dompurify.2.1.0.purify.min.js\n7e9c13baae4b945b9fcdc7243e2aad69cbb0aba0a5aa028fcad660d7825bb049 dompurify.2.1.1.purify.js\n798336ca0d7ace4d0ac48bb75e224ddf038debffca9bf010042ff41b4bbc933d dompurify.2.1.1.purify.min.js\nb7674627c3067bf02f37fa4619ab68d4ec87b9421e9f35eb59db425f0de62516 dompurify.2.2.0.purify.js\n95aef2107dc53899ffe801966bf4ef14e530db8fe904486c13834a22274f8791 dompurify.2.2.0.purify.min.js\nb93754dc2b4ef79faa4cd7052b1c93d2a4d23ec50df89581168478895cdc53f8 dompurify.2.2.1.purify.js\nc5749875a3ffb71ebb58d9abc13407de0f80a808ff2e8b76e334685d6c570de4 dompurify.2.2.1.purify.min.js\n2e0a4335f02d6e96c1e2c676ce2059d670ac69538ad3b575e3e8271847db56ce dompurify.2.2.2.purify.js\n9d0b1e3e9f16aa76488369f57f26d4570d4530ec14a95cf263718d305dd31dd4 dompurify.2.2.2.purify.min.js\na418e0b2d2afe4f79d16afef5165d16f1e95fb28836510903bfbe5d25e873b64 dompurify.2.2.3.purify.js\nb2dbc35080e4625180d7acf8fdb111d1fe5b6500998b14e46876b0ffafdb372b dompurify.2.2.3.purify.min.js\nf5a1f4de463323b0fb99c9cb89fe4e676a3711a9885875e394afbf82d604785f dompurify.2.2.4.purify.js\n38547299d548b570022cc44960a50d482d3460e9c546211dc562f6ed4bc2de64 dompurify.2.2.4.purify.min.js\n7f358f05dc4fc3d1b7d635e7fbb2ab8797b63c014c7586344eccf09d22ce2961 dompurify.2.2.6.purify.js\nf9bdbd8a4417ea7211fcb7f6cd01e153b9db4ddbc8e5735f4b47e000b4f363db dompurify.2.2.6.purify.min.js\n4ba1a3f3f54cb6e858e2fcd3437cffed4afe3902b236fd9257e08306c86457c3 dompurify.2.2.7.purify.js\n7c9deae1b91a39d302bd975b4f781f052295eef64b39171ae1ce60e681d31847 dompurify.2.2.7.purify.min.js\ne3b32b8ee1d5516e932569a6f59a8daffd079a2f23ae2157e6178b832145c2ea dompurify.2.2.8.purify.js\ne9a693b3589bd3f621b1da84eaa858a2a101196d91d49f60f8f8ce417840df63 dompurify.2.2.8.purify.min.js\nf7b3814c26771769b2c6ea94f5c91dd9a44891e05773e44039cf7fee3b623ec0 dompurify.2.2.9.purify.js\n9d5c1ac97a08ad0c4f4acbdfff27d60db607c1b6ff6e1c7e74511a3272a70faf dompurify.2.2.9.purify.min.js\nd2b2d33d7aed439664132361ad183f8ba8b98009882b328aa58f2346a1a8705b dompurify.2.3.0.purify.js\n051d9e08d38b4108d44aa85c1a0529246d74946dbc7a1d70f32332dc864ffb31 dompurify.2.3.0.purify.min.js\n5822c64e570d2c0a84f7f76d47f158fc0a9e880c5d02912f5eae945905be41fe dompurify.2.3.1.purify.js\n29dbd11db52419f340862bca1b4ed04d56143cccdae26a5830f0140673b4e19a dompurify.2.3.1.purify.min.js\n7d5a73829443266244b62d707e9da17cd72f822bd4d20d5a639e57139bd6b3e7 dompurify.2.3.2.purify.js\n1fe225462460847b3c6d66da5d88ba38b3c5e970d0ad284de61aac072d173013 dompurify.2.3.2.purify.min.js\n0963dcee513b600870b59fd5b75c6809b0035980e67e57b48128c2ac38d83830 dompurify.2.3.3.purify.js\n93b5fd64e221e705f75add7c68603529e777c505714633bbbb2446d4ca52c2cf dompurify.2.3.3.purify.min.js\nb3330310a942a2f7cc212700cbc917c5da09b811b091384e3658ab09e6640490 dompurify.2.3.4.purify.js\nd2ccff1f1ef51cdca903584593c1f5baf923de449a951eb1499438582fa01a54 dompurify.2.3.4.purify.min.js\n65829a9a6768e96ca7db1fc692720900cc3790cf6b3958dc5b073bd3e3ca9901 dompurify.2.3.5.purify.js\n14b56169341b3498aecac8efb87ed84ad5370d2040dc35aa8cff26b313355bfd dompurify.2.3.5.purify.min.js\n43b98f6d029d12c6a1623302b2d03b70799099641200965c006582d82d341b85 jquery.1.2.1.jquery.js\n18ab106814b6251057c7b739d818b43887b443c42b8f488a052aeeaa4cea6b1f jquery.1.2.1.jquery.min.js\n717d8d9b9802ac9fd75cc287c0624f37f9306c470c5a6da05abe9659d790e7cc jquery.1.2.2.jquery.js\nd3d0ff1c55ef3ac8aa1fbea3e61d550f3950a6729e03fcbfc1c3ef15241ba84e jquery.1.2.2.jquery.min.js\nd977fc32dd4bdb0479604abf078f1045b0e922666313f2f42cd71ce7835e0061 jquery.1.2.3.jquery.js\nf1c4a0a7b5dead231fc9b42f06965a036ab7a2a788768847eb81e1528d6402ad jquery.1.2.3.jquery.min.js\n94624d40721f1c352b2fecc802295da4d3083192fb2d7a1049b3aee26d8fdb7c jquery.1.2.4.jquery.js\n99f3c010ca75e5169317a43115178e9f96b1e4ac31470e5508437d4e7b46747a jquery.1.2.4.jquery.min.js\n7b038f185fdf7611317c5714ff7ccfe83e768d2c5e6e80df8659210160321c37 jquery.1.2.5.jquery.js\ndba3ed2e85be82c9109419d15f948eaf3832fffce09376d8665e29105c28e9c6 jquery.1.2.5.jquery.min.js\n3cc5c121471323b25de45fcab48631d4a09c78e76af21c10d747352682605587 jquery.1.2.6.jquery.js\nd548530775a6286f49ba66e0715876b4ec5985966b0291c21568fecfc4178e8d jquery.1.2.6.jquery.min.js\ne95be8c2affede53b586a32b2863aaa01870f120981367b2cf958951df2fdc67 jquery.1.2.jquery.js\n100e1a173a6113218ffb49e13a14778fa3b91ff7fcd9fac5c523baedb0f1b7fb jquery.1.2.jquery.min.js\n04175a2929f4d72b7cfc63be13103632e200ddb741c999cab76bed7775fd547d jquery.1.3.1.jquery.js\n17ec1f16efac893b9bd89bba5f13cb1e0bf938bdc9cece6cae3ed77f18fa6fd7 jquery.1.3.1.jquery.min.js\n233a5d16bee5a64bf3bc19abe3cc812a1e0619435f01c163f628773a469ff719 jquery.1.3.2.jquery.js\nc8370a2d050359e9d505acc411e6f457a49b21360a21e6cbc9229bad3a767899 jquery.1.3.2.jquery.min.js\n5c44ebfc4b86e80fad397c5fb99fc35a0a97bbf6793dd295b224e46ea9bf2393 jquery.1.3.jquery.js\n900191a443115d8b48a9d68d3062e8b3d7129727951b8617465b485baf253006 jquery.1.3.jquery.min.js\n9edc9f813781eca2aad6de78ef85cdbe92ee32bb0a56791be4da0fa7b472c1d8 jquery.1.4.1.jquery.js\n2cec78f739fbddfed852cd7934d2530e7cc4c8f14b38673b03ba5fb880ad4cc7 jquery.1.4.1.jquery.min.js\n95c023c80dfe0d30304c58244878995061f87801a66daa5d6bf4f2512be0e6f9 jquery.1.4.2.jquery.js\ne23a2a4e2d7c2b41ebcdd8ffc0679df7140eb7f52e1eebabf827a88182643c59 jquery.1.4.2.jquery.min.js\n0e3303a3a0cec95ebc8c3cc3e19fc71c99487faa286b05d01a3eb8cca4d90bc7 jquery.1.4.3.jquery.js\nf800b399e5c7a5254fc66bb407117fe38dbde0528780e68c9f7c87d299f8486a jquery.1.4.3.jquery.min.js\nb31cd094af7950b3a461dc78161fd2faf01faa9d0ed8c1c072790f83ab26d482 jquery.1.4.4.jquery.js\n517364f2d45162fb5037437b5b6cb953d00d9b2b3b79ba87d9fe57ea6ee6070c jquery.1.4.4.jquery.min.js\n882927b9aadb2504b5c6a823bd8c8c516f21dec6e441fe2c8fa228e35951bcc8 jquery.1.4.jquery.js\n89abaf1e2471b00525b0694048e179c0f39a2674e3bcb34460ea6bc4801882be jquery.1.4.jquery.min.js\ne2ea0a6ca6b984a9405a759d24cf3c51eb3164e5c43e95c3e9a59b316be7b3b9 jquery.1.5.1.jquery.js\n764b9e9f3ad386aaa5cdeae9368353994de61c0bede087c8f7e3579cb443de3b jquery.1.5.1.jquery.min.js\ne2107c8ecdb479c36d822d82bda2a8caf4429ab2d2cf9f20d5c931f75275403c jquery.1.5.2.jquery.js\n8f0a19ee8c606b35a10904951e0a27da1896eafe33c6e88cb7bcbe455f05a24a jquery.1.5.2.jquery.min.js\n3613c89747be4a2d5dc17f442d0a482da665784e2e5a3931fb9a1fc38fa0fa8d jquery.1.5.jquery.js\n229278f6a9c1c27fc55bec50f06548fe64c2629f59f462d50cac28e65bb93a83 jquery.1.5.jquery.min.js\n0eef76a9583a6c7a1eb764d33fe376bfe1861df79fab82c2c3f5d16183e82016 jquery.1.6.1.jquery.js\nc784376960f3163dc760bc019e72e5fed78203745a5510c69992a39d1d8fe776 jquery.1.6.1.jquery.min.js\na57292619d14eb8cbd923bde9f28cf994ac66abc48f7c975b769328ff33bddc9 jquery.1.6.2.jquery.js\nd16d07a0353405fcec95f7efc50a2621bc7425f9a5e8895078396fb0dc460c4f jquery.1.6.2.jquery.min.js\n9baa10e1c5630c3dcd9bb46bf00913cc94b3855d58c9459ae9848339c566e97b jquery.1.6.3.jquery.js\nd3f3779f5113da6da957c4d81481146a272c31aefe0d3e4b64414fd686fd9744 jquery.1.6.3.jquery.min.js\n54964f8b580ad795a962fb27066715d3281ae1ad13a28bf8aedd5d8859ebae37 jquery.1.6.4.jquery.js\n951d6bae39eb172f57a88bd686f7a921cf060fd21f59648f0d20b6a8f98fc5a5 jquery.1.6.4.jquery.min.js\na7c98da2a0260a5c8ac615cad956b8b220b7a2d73d85364dcf77b63f92e907b3 jquery.1.6.jquery.js\ne58da58b314ccdeefa3c4865b4b8aa3153e890d7904e04483481d8fff2c27eaa jquery.1.6.jquery.min.js\n7c1885ec8620f40a10d045948d3f9f7b8f9c4f7bd2ff1ddfb486a9f27e95e3e3 jquery.1.7.0.jquery.js\nff4e4975ef403004f8fe8e59008db7ad47f54b10d84c72eb90e728d1ec9157ce jquery.1.7.0.jquery.min.js\n9fcc241093405946885039df428cfa7f0051a1f2bdbcc5a313a177a9e35f8806 jquery.1.7.1.jquery.js\n88171413fc76dda23ab32baa17b11e4fff89141c633ece737852445f1ba6c1bd jquery.1.7.1.jquery.min.js\n1717ea1fde8ceb7584341a24efc85c853083c660a1185968fbf94520f7193de2 jquery.1.7.2.jquery.js\n47b68dce8cb6805ad5b3ea4d27af92a241f4e29a5c12a274c852e4346a0500b4 jquery.1.7.2.jquery.min.js\nd34161f2d90f01ef849956871690fe1e8bf15a4edbf7bab0a958bb9cbbe3760b jquery.1.8.0.jquery.js\n8c574e0a06396dfa7064b8b460e0e4a8d5d0748c4aa66eb2e4efdfcb46da4b31 jquery.1.8.0.jquery.min.js\n7baae7dee44c0f5fc953e15dfce6027f639215c50e5c74259022f4ad847f2543 jquery.1.8.1.jquery.js\nfc184f96dd18794e204c41075a00923be7e8e568744231d74f2fdf8921f78d29 jquery.1.8.1.jquery.min.js\ncfa69516375e27e56519cae71f28818e0e52515b70e705a600d1db459998335a jquery.1.8.2.jquery.js\nf554d2f09272c6f71447ebfe4532d3b1dd1959bce669f9a5ccc99e64ef511729 jquery.1.8.2.jquery.min.js\n756d7dfac4a35bb57543f677283d6c682e8d704e5350884b27325badd2b3c4a7 jquery.1.8.3.jquery.js\n61c6caebd23921741fb5ffe6603f16634fca9840c2bf56ac8201e9264d6daccf jquery.1.8.3.jquery.min.js\n4d7b01c2f6043bcee83a33d0f627dc6fbc27dc8aeb5bdd5d863e84304b512ef3 jquery.1.9.0.jquery.js\n7fa0d5c3f538c76f878e012ac390597faecaabfe6fb9d459b919258e76c5df8e jquery.1.9.0.jquery.min.js\n7bd80d06c01c0340c1b9159b9b4a197db882ca18cbac8e9b9aa025e68f998d40 jquery.1.9.1.jquery.js\nc12f6098e641aaca96c60215800f18f5671039aecf812217fab3c0d152f6adb4 jquery.1.9.1.jquery.min.js\n8aa0f84b5331efcc3cb72c7d504c2bc6ebd861da003d72c33df99ce650d4531d jquery.1.10.0.jquery.js\ndbe2f39d679680bec02757226881b9ac53fb18a7a6cf397e2bbe6d4724c1c8e1 jquery.1.10.0.jquery.min.js\nebaded49db62a60060caa2577f2a4ec1ff68726bc40861bc65d977abeb64fa7d jquery.1.10.1.jquery.js\n4837f7e1f1565ff667528cd75c41f401e07e229de1bd1b232f0a7a40d4c46f79 jquery.1.10.1.jquery.min.js\n8ade6740a1d3cfedf81e28d9250929341207b23a55f1be90ccc26cf6d98e052a jquery.1.10.2.jquery.js\n0ba081f546084bd5097aa8a73c75931d5aa1fc4d6e846e53c21f98e6a1509988 jquery.1.10.2.jquery.min.js\nce0343e1d6f489768eeefe022c12181c6a0822e756239851310acf076d23d10c jquery.1.11.0.jquery.js\nb294e973896f8f874e90a8eb1a8908ac790980d034c4c4bdf0fc3d37b8abf682 jquery.1.11.0.jquery.min.js\n3029834a820c79c154c377f52e2719fc3ff2a27600a07ae089ea7fde9087f6bc jquery.1.11.1.jquery.js\n540bc6dec1dd4b92ea4d3fb903f69eabf6d919afd48f4e312b163c28cff0f441 jquery.1.11.1.jquery.min.js\n58c27035b7a2e589df397e5d7e05424b90b8c1aaaf73eff47d5ed6daecb70f25 jquery.1.11.2.jquery.js\n2ecd295d295bec062cedebe177e54b9d6b19fc0a841dc5c178c654c9ccff09c0 jquery.1.11.2.jquery.min.js\n2065aecca0fb9b0567358d352ed5f1ab72fce139bf449b4d09805f5d9c3725ed jquery.1.11.3.jquery.js\necb916133a9376911f10bc5c659952eb0031e457f5df367cde560edbfba38fb8 jquery.1.11.3.jquery.min.js\nc85537acad72f0d7d409dfc1e2d2daa59032f71d29642a8b64b9852f70166fbb jquery.1.12.0.jquery.js\n5f1ab65fe2ad6b381a1ae036716475bf78c9b2e309528cf22170c1ddeefddcbf jquery.1.12.0.jquery.min.js\n56e843a66b2bf7188ac2f4c81df61608843ce144bd5aa66c2df4783fba85e8ef jquery.1.12.1.jquery.js\n2359d383bf2d4ab65ebf7923bdf74ce40e4093f6e58251b395a64034b3c39772 jquery.1.12.1.jquery.min.js\n5540b2af46570795610626e8d8391356176ca639b1520c4319a2d0c7ba9bef16 jquery.1.12.2.jquery.js\n95914789b5f3307a3718679e867d61b9d4c03f749cd2e2970570331d7d6c8ed9 jquery.1.12.2.jquery.min.js\nd5732912d03878a5cd3695dc275a6630fb3c255fa7c0b744ab08897824049327 jquery.1.12.3.jquery.js\n69a3831c082fc105b56c53865cc797fa90b83d920fb2f9f6875b00ad83a18174 jquery.1.12.3.jquery.min.js\n430f36f9b5f21aae8cc9dca6a81c4d3d84da5175eaedcf2fdc2c226302cb3575 jquery.1.12.4.jquery.js\n668b046d12db350ccba6728890476b3efee53b2f42dbb84743e5e9f1ae0cc404 jquery.1.12.4.jquery.min.js\n896e379d334cf0b16c78d9962a1579147156d4a72355032fce0de5f673d4e287 jquery.2.0.0.jquery.js\nd482871a5e948cb4884fa0972ea98a81abca057b6bd3f8c995a18c12487e761c jquery.2.0.0.jquery.min.js\n820fb338fe8c7478a1b820e2708b4fd306a68825de1194803e7a93fbc2177a16 jquery.2.0.1.jquery.js\n243f6ee513637db6d897f01b89862f54f29c2cd94a35edaead432e1b334421c9 jquery.2.0.1.jquery.min.js\nd2ed0720108a75db0d53248ba8e36332658064c4189714d16c0f117efb42016d jquery.2.0.2.jquery.js\n4d9586a075f082a04fd40178499c472012b351db4c1a4d210907a0891f7d8ad9 jquery.2.0.2.jquery.min.js\n9427fe2df51f7d4c6bf35f96d19169714d0b432b99dc18f41760d0342c538122 jquery.2.0.3.jquery.js\nb13cb5989e08fcb02314209d101e1102f3d299109bdc253b62aa1da21c9e38ba jquery.2.0.3.jquery.min.js\n0fa7752926a95e3ab6b5f67a21ef40628ce4447c81ddf4f6cacf663b6fb85af7 jquery.2.1.0.jquery.js\nf284353a7cc4d97f6fe20a5155131bd43587a0f1c98a56eeaf52cff72910f47d jquery.2.1.0.jquery.min.js\n140ff438eaaede046f1ceba27579d16dc980595709391873fa9bf74d7dbe53ac jquery.2.1.1.jquery.js\n874706b2b1311a0719b5267f7d1cf803057e367e94ae1ff7bf78c5450d30f5d4 jquery.2.1.1.jquery.min.js\n07cb07bdfba40ceff869b329eb48eeede41740ba6ce833dd3830bd0af49e4898 jquery.2.1.2.jquery.js\n604ec12a7d5e6bd8e2ac21cfaff11a5b93719a465919be76f99683d942a87576 jquery.2.1.2.jquery.min.js\n828cbbcacb430f9c5b5d27fe9302f8795eb338f2421010f5141882125226f94f jquery.2.1.3.jquery.js\n8af93bd675e1cfd9ecc850e862819fdac6e3ad1f5d761f970e409c7d9c63bdc3 jquery.2.1.3.jquery.min.js\nb2215cce5830e2350b9d420271d9bd82340f664c3f60f0ea850f7e9c0392704e jquery.2.1.4.jquery.js\nf16ab224bb962910558715c82f58c10c3ed20f153ddfaa199029f141b5b0255c jquery.2.1.4.jquery.min.js\na18aa92dea997bd71eb540d5f931620591e9dee27e5f817978bb385bab924d21 jquery.2.2.0.jquery.js\n8a102873a33f24f7eb22221e6b23c4f718e29f85168ecc769a35bfaed9b12cce jquery.2.2.0.jquery.min.js\n78d714ccede3b2fd179492ef7851246c1f1b03bfc2ae83693559375e99a7c077 jquery.2.2.1.jquery.js\n82f420005cd31fab6b4ab016a07d623e8f5773de90c526777de5ba91e9be3b4d jquery.2.2.1.jquery.min.js\ne3fcd40aa8aad24ab1859232a781b41a4f803ad089b18d53034d24e4296c6581 jquery.2.2.2.jquery.js\ndfa729d82a3effadab1000181cb99108f232721e3b0af74cfae4c12704b35a32 jquery.2.2.2.jquery.min.js\n95a5d6b46c9da70a89f0903e5fdc769a2c266a22a19fcb5598e5448a044db4fe jquery.2.2.3.jquery.js\n6b6de0d4db7876d1183a3edb47ebd3bbbf93f153f5de1ba6645049348628109a jquery.2.2.3.jquery.min.js\n893e90f6230962e42231635df650f20544ad22affc3ee396df768eaa6bc5a6a2 jquery.2.2.4.jquery.js\n05b85d96f41fff14d8f608dad03ab71e2c1017c2da0914d7c59291bad7a54f8e jquery.2.2.4.jquery.min.js\n8eb3cb67ef2f0f1b76167135cef6570a409c79b23f0bc0ede71c9a4018f1408a jquery.3.0.0.jquery.js\n266bcea0bb58b26aa5b16c5aee60d22ccc1ae9d67daeb21db6bad56119c3447d jquery.3.0.0.jquery.min.js\nb25a2092f0752b754e933008f10213c55dd5ce93a791e355b0abed9182cc8df9 jquery.3.1.0.jquery.js\n702b9e051e82b32038ffdb33a4f7eb5f7b38f4cf6f514e4182d8898f4eb0b7fb jquery.3.1.0.jquery.min.js\nd7a71d3dd740e95755227ba6446a3a21b8af6c4444f29ec2411dc7cd306e10b0 jquery.3.1.1.jquery.js\n85556761a8800d14ced8fcd41a6b8b26bf012d44a318866c0d81a62092efd9bf jquery.3.1.1.jquery.min.js\nc0f149348165558e3d07e0ae008ac3afddf65d26fa264dc9d4cdb6337136ca54 jquery.3.2.0.jquery.js\n2405bdf4c255a4904671bcc4b97938033d39b3f5f20dd068985a8d94cde273e2 jquery.3.2.0.jquery.min.js\n0d9027289ffa5d9f6c8b4e0782bb31bbff2cef5ee3708ccbcb7a22df9128bb21 jquery.3.2.1.jquery.js\n87083882cc6015984eb0411a99d3981817f5dc5c90ba24f0940420c5548d82de jquery.3.2.1.jquery.min.js\n4c5592b8326dea44be86e57ebd59725758ccdddc0675e356a9ece14f15c1fd7f jquery.3.3.0.jquery.js\n453432f153a63654fa6f63c846eaf7ee9e8910165413ba3cc0f80cbeed7c302e jquery.3.3.0.jquery.min.js\nd8aa24ecc6cecb1a60515bc093f1c9da38a0392612d9ab8ae0f7f36e6eee1fad jquery.3.3.1.jquery.js\n160a426ff2894252cd7cebbdd6d6b7da8fcd319c65b70468f10b6690c45d02ef jquery.3.3.1.jquery.min.js\n0d864c082f074c2f900ebe5035a21c7d1ed548fb5c212ca477ee9e4a6056e6aa jquery.3.4.0.jquery.js\n0497a8d2a9bde7db8c0466fae73e347a3258192811ed1108e3e096d5f34ac0e8 jquery.3.4.0.jquery.min.js\n5a93a88493aa32aab228bf4571c01207d3b42b0002409a454d404b4d8395bd55 jquery.3.4.1.jquery.js\n0925e8ad7bd971391a8b1e98be8e87a6971919eb5b60c196485941c3c1df089a jquery.3.4.1.jquery.min.js\naff01a147aeccc9b70a5efad1f2362fd709f3316296ec460d94aa7d31decdb37 jquery.3.5.0.jquery.js\nc4dccdd9ae25b64078e0c73f273de94f8894d5c99e4741645ece29aeefc9c5a4 jquery.3.5.0.jquery.min.js\n416a3b2c3bf16d64f6b5b6d0f7b079df2267614dd6847fc2f3271b4409233c37 jquery.3.5.1.jquery.js\nf7f6a5894f1d19ddad6fa392b2ece2c5e578cbf7da4ea805b6885eb6985b6e3d jquery.3.5.1.jquery.min.js\n1fe2bb5390a75e5d61e72c107cab528fc3c29a837d69aab7d200e1dbb5dcd239 jquery.3.6.0.jquery.js\nff1523fb7389539c84c65aba19260648793bb4f5e29329d2ee8804bc37a3fe6e jquery.3.6.0.jquery.min.js\n1a9ea1a741fe03b6b1835b44ac2b9c59e39cdfc8abb64556a546c16528fc2828 jquery-slim.3.0.0.jquery.slim.js\n45fe0169d7f20adb2f1e63bcf4151971b62f34dbd9bce4f4f002df133bc2b03d jquery-slim.3.0.0.jquery.slim.min.js\n2faa690232fa8e0b5199f8ae8a0784139030348da91ff5fd2016cfc9a9c9799c jquery-slim.3.1.0.jquery.slim.js\n711a568e848ec3929cc8839a64da388ba7d9f6d28f85861bea2e53f51495246f jquery-slim.3.1.0.jquery.slim.min.js\ne62fe6437d3433befd3763950eb975ea56e88705cd51dccbfd1d9a5545f25d60 jquery-slim.3.1.1.jquery.slim.js\nfd222b36abfc87a406283b8da0b180e22adeb7e9327ac0a41c6cd5514574b217 jquery-slim.3.1.1.jquery.slim.min.js\nf18ac10930e84233b80814f5595bcc1f6ffad74047d038d997114e08880aec03 jquery-slim.3.2.0.jquery.slim.js\na8b02fd240408a170764b2377efdd621329e46c517dbb85deaea4105ad0c4a8c jquery-slim.3.2.0.jquery.slim.min.js\nb40f32d17aa2c27a7098e225dd218070597646fc478c0f2aa74fb5b821a64668 jquery-slim.3.2.1.jquery.slim.js\n9365920887b11b33a3dc4ba28a0f93951f200341263e3b9cefd384798e4be398 jquery-slim.3.2.1.jquery.slim.min.js\nec89a3d1f2cab57e4d144092d6e9a8429ecd0b594482be270536ac366ee004b6 jquery-slim.3.3.0.jquery.slim.js\n00c83723bc9aefa38b3c3f4cf8c93b92aac0dbd1d49ff16e1817d3ffd51ff65b jquery-slim.3.3.0.jquery.slim.min.js\n7cd5c914895c6b4e4120ed98e73875c6b4a12b7304fbf9586748fe0a1c57d830 jquery-slim.3.3.1.jquery.slim.js\ndde76b9b2b90d30eb97fc81f06caa8c338c97b688cea7d2729c88f529f32fbb1 jquery-slim.3.3.1.jquery.slim.min.js\n9a295ecf1e656a4ad9bb438ff5bd90585cb57edfd41142ba347d49ab3f215214 jquery-slim.3.4.0.jquery.slim.js\n65a5e76241c6a8886a4db27a301e25f45aecfebed4e23971ee2afc3c9601a9b2 jquery-slim.3.4.0.jquery.slim.min.js\n0539537503bdfdf6ac701d5dade92b0d591a29df4f93007298c9473a21bea8b2 jquery-slim.3.4.1.jquery.slim.js\na5ab2a00a0439854f8787a0dda775dea5377ef4905886505c938941d6854ee4f jquery-slim.3.4.1.jquery.slim.min.js\nb027b185a2a901fbaaba52a3b5263b57d1fb413d1308df741fe6393659aa3941 jquery-slim.3.5.0.jquery.slim.js\n325bac0cb2483f519180bace7e5510b6c8723f44f04ff4475ec235c161a7421b jquery-slim.3.5.0.jquery.slim.min.js\n0eb4f935fc5f6c7bcc1eec77d4b921c60e362d8ea87fc4da6322b9d239f14673 jquery-slim.3.5.1.jquery.slim.js\ne3e5f35d586c0e6a9a9d7187687be087580c40a5f8d0e52f0c4053bbc25c98db jquery-slim.3.5.1.jquery.slim.min.js\n324b0783a50c21c9b2a105b39b7cd1767e8d44f288f08be5f6e2267d5ad83920 jquery-ui.1.10.0.jquery-ui.js\n853a5b7955e180299f3bb9c6716a7d77590898a6f363a80dd15a39bb9c0bbacb jquery-ui.1.10.0.jquery-ui.min.js\n76bbcc0a2f087f63a426cd3047494a9636d23d8b8880131f8fb477df150ca457 jquery-ui.1.10.1.jquery-ui.js\n3679277f52d43f71877718d642081af762cc75a536fbf824ce82143be81fcb63 jquery-ui.1.10.1.jquery-ui.min.js\n1203ee412fb623c6e6daeddbdebd5d2541223b9e9aff17991978939cd4ef6193 jquery-ui.1.10.2.jquery-ui.js\n16089a42741acc5fd00ab17da92be9458e8f0029fd645f159e582a7ea0f52ec1 jquery-ui.1.10.2.jquery-ui.min.js\nba0103f765802f299bc7dca5c35d9a00359a0abb10cac136f43caf9c0bf98b7c jquery-ui.1.10.3.jquery-ui.js\n9671f8be70ad94a5362e60f4656d5d53ba214d32ab70a3f9d1603d7dadf9d1c1 jquery-ui.1.10.3.jquery-ui.min.js\nb69f1567863d760ef4dabec3eb29f349abca4b007dce36ab8926784a7babbe6c jquery-ui.1.10.4.jquery-ui.js\na13c96acd88fe907edbb8becda0d113c22abde0d5ae904e5213360a1e6f145ce jquery-ui.1.10.4.jquery-ui.min.js\ncfcb2af9fc17cbac57d472c1259e5da32ad698506143d946de9fc02a88a928ab jquery-ui.1.11.0.jquery-ui.js\n94217ee7990c505fb77ceff70625ee8b87a250a7109adafb79c29278b543c484 jquery-ui.1.11.0.jquery-ui.min.js\nff6b70d8459332e298276d8616be97e6f3c5d64925e666fbe67a667cce0950f5 jquery-ui.1.11.1.jquery-ui.js\ne09639315704980552b92eaae21f66af00a6e8a371f757f76b0b12420c2ed2a7 jquery-ui.1.11.1.jquery-ui.min.js\n26e1b509ca17a756db87864840e31a1a7caa2ce9164aa2fff2c61284c582c0c2 jquery-ui.1.11.2.jquery-ui.js\n7ab17d7c830048456601619d3a6422eb5e419b1d0bfef58d8b1c533435d2e054 jquery-ui.1.11.2.jquery-ui.min.js\nd2f0522008bff05c6434e48ac8f11f7464331436a4d5d96a14a058a81a75c82e jquery-ui.1.11.3.jquery-ui.js\nc48feaca5f6fa70585397cfbfb1ffd5a41b98ff4959d2c36d6f8b2f1f5b06de1 jquery-ui.1.11.3.jquery-ui.min.js\n0c8e8d7408611519ceda4e759ae9987834a17addc8f0028241ffed7fb0113612 jquery-ui.1.11.4.jquery-ui.js\nc4d8dbe77feb63e5a61bee0bead4e5f66e8fa6a927599bd1b74aced52467273c jquery-ui.1.11.4.jquery-ui.min.js\nd183ca03064fecca7700b311541da2f065de12776f0aadde4a5fd6b009754729 jquery-ui.1.12.0.jquery-ui.js\n78613a6e5bab939b078feae691fb0661e2b2671dcce1b1be66517203b2a7b3b1 jquery-ui.1.12.0.jquery-ui.min.js\n4f455eb2ddf2094ee969f470f6bfac7adb4c057e8990a374e9da819e943c777d jquery-ui.1.12.1.jquery-ui.js\n55accff7b642c2d7a402cbe03c1494c0f14a76bc03dee9d47d219562b6a152a5 jquery-ui.1.12.1.jquery-ui.min.js\na8d3beec46708cdc16efbb0f680dad8084c375367b5482dcc4d880cb8b2bba36 moment.2.11.2.moment.js\n2942f35cd9347557c5ad6a468803878b7f4e4e3a954906421e8282ec286dec42 moment.2.11.2.moment.min.js\nb126c081d67afa97e41083f3e9231706b9efb26387a164dd8d8ee2d0c920d608 moment.2.12.0.moment.js\n41315b08c2b332c2a675a817bac8ca1cc648c33109b699c6609feffc0ac79254 moment.2.12.0.moment.min.js\n2b4b2181df3354ebd90f04ad95742fe254fd437307e34c529b1ea55bf760a759 moment.2.13.0.moment.js\n4e411c99fe4a486db34e801a53392ae86f8659eccc438944b5a062c9aaba25be moment.2.13.0.moment.min.js\nd3ebb66e6a733c26fba22678ca45ce8b40abfe125597f19c5c9c6d38adf942d1 moment.2.14.0.moment.js\n155a727a9d767586b67721895c3f2818b63becd3fda565178c848e12f8196fb9 moment.2.14.0.moment.min.js\naf468ce37d4183f46555f58f39645543f1c5bf1643615fcb33d39c50a14b77e4 moment.2.14.1.moment.js\n0defdc819a00920beaa312fdc89a49ccf1f2a335044c59d2bfb11019f416438a moment.2.14.1.moment.min.js\n6ce7ac6e541bca5a7de37652b81b7e1d662436e8a89ca036e783a20498aeaede moment.2.14.2.moment.js\n7379567bdd96aca5f9bd48d112fdc03e69ce9d5fd7d9a2bb485fec6635111e13 moment.2.14.2.moment.min.js\ncca7276f91e302df6c51dd44e7dd979c23d3e1be00d017edebb7886fe616fc4a moment.2.15.0.moment.js\na35c834202320159cf5357245d552508e04c5fe34824b9da424ffd7414d26989 moment.2.15.0.moment.min.js\n9eddbcbe2e9d227859ae6fd3b7774ce2de738ea1d88f32edc8cbef708f2d5396 moment.2.15.1.moment.js\ne0f22f979f0bf6aee2c234fae784d024cf82fda704ca81bbdfc88bf01f278578 moment.2.15.1.moment.min.js\n7269d7bafd46fe3f6a59fb5f34ca0e84ff0a1f85f581bce77ac9b853be327c0b moment.2.15.2.moment.js\n943714f708b5f3bb6f983d83d80bdf46f86e56d859e54c483fb3a1f91937c8dc moment.2.15.2.moment.min.js\n3fa7eb4761580c927db5cfbff29573d31f436a7f20064c672f7643de993dcc22 moment.2.16.0.moment.js\n70f575f269ca7979b7e3dfcb27e7dc639d53b36ca0b7e716a590b373763312eb moment.2.16.0.moment.min.js\nef3ae0785122b9b528cfc16c6b44e76d65833d84eeeec669ec125e7f66b27962 moment.2.17.0.moment.js\n43588db3c3efe5a0c142a072c54338a5099dcdb3c5c8da280c524aa236275698 moment.2.17.0.moment.min.js\n34da66f0997d145341cfb3fc71c794ea32b4c6affa3ff5d9e7e5107170125d1c moment.2.17.1.moment.js\n1a7ecc510a27a3c2d4c537d1034599cc9813b9ae7651d9b521fae4e78db5ce40 moment.2.17.1.moment.min.js\naf990ddd9d7a114589dcec4ed472203dbd947c7687579739857ae85e2fa910b1 moment.2.18.0.moment.js\n33079ee6df9b0f7e7387017d9c615feecce8d2432520b74115d48ae713d06932 moment.2.18.0.moment.min.js\n19245ee5c1e69930f70e00714627f390d2da5b58b03d3cedf6427ceab19af2d8 moment.2.18.1.moment.js\nd618d4869738e0dc22360f0ec0cbb6433257843f24723fac240dda0906685238 moment.2.18.1.moment.min.js\n57d9b1d773712e39327ee287eec97e8671955ab10492d1656f4ed18a69d9f4bd moment.2.19.0.moment.js\n32e2361a2eb98ff62232420cccbc5d7781cc5f5ae56e826a1181959e1c127f59 moment.2.19.0.moment.min.js\nd678bbdedfc5bb85a9767408e4ecdf2f92854d8f1598fe9f9edc0aab1c7d5bca moment.2.19.1.moment.js\ncc6f2ff8d5a26719a3362f82bd46276702ad1f316d74ef1c00a508741f3e53d2 moment.2.19.1.moment.min.js\naa56a82b98173bfcbc67e0148dd1c325c57c4ec63e487c504f17045e6dc91c6f moment.2.19.2.moment.js\n0d8c96a19f350240e93c025c66aa0a1648539ede4457be0c960162f3212bd257 moment.2.19.2.moment.min.js\nabb1e3869d7c4b972c050c0fb07165fb3ab9ca2e2613d4644d92c29e54c24122 moment.2.20.0.moment.js\nc170863f33aa34b056107b8f7e80b2b385d29c81b26c9858c351cc2e6025db0f moment.2.20.0.moment.min.js\ndbfdfe43590c611f0c0daa853cd06098b822a96263c92920d70a8bc7f884e59a moment.2.20.1.moment.js\n001564a706fd2bd3f1b9bbd1ac732493ac2659c207504f5e0713592d7610f389 moment.2.20.1.moment.min.js\nf7033648fb1b669f1a434287cd27a0f8ab00606b5cec6453a266ea8615ef2d28 moment.2.21.0.moment.js\nf5802e076567159349fa529fa5a43774a413f7f0b48f755495aefa8476e2545f moment.2.21.0.moment.min.js\n12a31b1da9bfc75275cba085ff794853dcedbfe3a8842ef58dbe83370ebfab42 moment.2.22.0.moment.js\n0c42c23a0a15b19aa34fbf250c2ef3717f98169f8f123875936de604ca03070a moment.2.22.0.moment.min.js\n6757799d7ebe2301a38e491883e7d67bf8f3bc969ee0d61e8d3cfb3dc22e9b11 moment.2.22.1.moment.js\n2f74b7103124df51dc2c0e42e93da8bc7bce703f34f9f82a6820edd81022f76a moment.2.22.1.moment.min.js\ne7d219e5d6cbc81c99812b111376744e30ee5fb7b5022a96e5b67c060e7476c5 moment.2.22.2.moment.js\n0aeb4ecf1091b9c52c9fa0ba4dc118b1abafbd88a51278935e574f6baff0bb49 moment.2.22.2.moment.min.js\n97a494fab552964c8870cb2a8f2d266fa9defea3e9628b5d55215df6f2e65750 moment.2.23.0.moment.js\n5412e2bde4cac9464c13325deb3da685fc48ab3dd90130ae54c6b03d91b321f0 moment.2.23.0.moment.min.js\n1fd8c0cfffd02e40cecbf9f313d1b86988a342d90bb7d16f1a67544f0064ea0b moment.2.24.0.moment.js\ne22419e8154be2a34a950dbb4c4c448413751c53ef02f00c6c56af28aa2c4964 moment.2.24.0.moment.min.js\nda6a8c6f031b8a11d589acd192d721dc61c6ba9bf0cdb8e277d8a8ad2f7c0f41 moment.2.25.0.moment.js\n8a607fa0c68d03462f2240e41799883515a9b853c4195084907cbaae6da50330 moment.2.25.0.moment.min.js\nffc2b719ce8fe4130764aafe3bbe498f35503d71f53c44589b1244b1fbacd880 moment.2.25.1.moment.js\n7a92e16d47fca6cc3c7141eed2127979a6e4e823dec4d26909bb1cd2ae28ba02 moment.2.25.1.moment.min.js\n45decdf18708bcfd22cd14a9845cc68fc7cdf76c9b14999976fec15c68a5fd4a moment.2.25.2.moment.js\n589ce332a7a1a16553e5cf0bb3f021879461610738fb85f0f6495904e6ed9f4c moment.2.25.2.moment.min.js\n1e870d1eb2d3bb0c0da4692b252ea82b224ba11cd808a8974df0e3d7faa14361 moment.2.25.3.moment.js\n0bae82680226b5e10a64f62f82783d8f5d09ff8e5ef6c02e6727cf602c29e201 moment.2.25.3.moment.min.js\n1888b77da6ad99724a6ce40f98b8143c31d7298997052b3370ef44b9fd0140f9 moment.2.26.0.moment.js\ne6802973fc0c75ad67b4810ae2aa16278608b675787c11ccc32c2e9e3f203ea7 moment.2.26.0.moment.min.js\n413ae2c042b55d350974aa774a8eed30352f6524cb38fa54bfc17f27e53027c3 moment.2.27.0.moment.js\n66c58fd2f4fe6a45a6bc4324358819acf1ca53d29ef276013c2ddda8e369d666 moment.2.27.0.moment.min.js\n7527dbddbd58dad64ffb21d979f8432623b59f6382a06e67c3af55ef5a99eaad moment.2.28.0.moment.js\n64743285d7079781229a571c92f036584f83a9d5da5fa1c2cbe2edbc75d2abb0 moment.2.28.0.moment.min.js\nbb6bba02ece098c9ffea29ef8ca45c3fd24a6ab0a30e825da84ae71199c43070 moment.2.29.0.moment.js\n7ea48127fc922eccbf80b25ae88b941a692e00ca266ed3c6631514f517669bef moment.2.29.0.moment.min.js\nf0075677245792b113c801a56bd36682461596ac3830e1d1eac2499ad1460184 moment.2.29.1.moment.js\n73de4254959530e4d1d9bec586379184f96b4953dacf9cd5e5e2bdd7bfeceef7 moment.2.29.1.moment.min.js\nc4f55654b6450ad0c626213f096b923aad3fdb8de869e48499f4e749d60ef720 mootools.1.5.1.mootools-core.js\n62abd718d09e3a6f0409a0a742677a8a15fe64c8d405b4c84b2089219fa779bc mootools.1.5.1.mootools-core.min.js\nb06804fb8c30b5c452d169ed9d6a05022930160059db32293a1a660b860cbf5f mootools.1.5.2.mootools-core.js\n45b817284298204560c33eced8b2a48cb2b666a5f654a91423635a41e7bfa590 mootools.1.5.2.mootools-core.min.js\na4e2f33bec07345195a048fb2dc6b666f2db3706ef00eae219eb181286ffe437 mootools.1.6.0.mootools-core.js\n6f4a2858fdab530825170c9a789e0a74797f2cf08dc168dc4bca987ae66e7564 mootools.1.6.0.mootools-core.min.js\ndedea3aa22a087b3745c9635e7a3d65e772d57ce590b541a6a32069a0b1d60b9 prototype.1.7.0.0.prototype.js\n48a4fd51466ac55d081ff932371021b328f118f74ee6ba93c0ec8fd163e34a30 prototype.1.7.1.0.prototype.js\na6b4f5343dd13746d73c87e9f2e6187768e92fdfd1334fb4613dd23c6cd3e819 prototype.1.7.2.0.prototype.js\n46bc7c7b853bf69ab0b165153453f7c1e84bf6982fe8adb6245088a5f3de8360 prototype.1.7.3.0.prototype.js\n9af190f92d737321bb4ad6f901f74c22d32b151ed65766065e865fc58f978995 react.0.14.0.react.js\n151c7f52c9f9d88a6dfc23bfe35207fd9bdbf880d1186479b04603ac41ab0218 react.0.14.0.react.min.js\n5cc12a184b0b5fa1ff3fc444435315f4fce7acb5da542fcdea11de8fd4ca377f react.0.14.1.react.js\n6ae91bbebb9d27cd5cb056f19f6aac6a7afaab4337e3e0faa45ece91e2fbb6f6 react.0.14.1.react.min.js\na3436abca0afd8979d2968c29187df4ce8d530597797db3b06cf1a26dee61b33 react.0.14.2.react.js\n7604487749ce3fc8018ce264f9199f2e876cf106eb49abbca8cfb5a07e9a5165 react.0.14.2.react.min.js\n8c48fac3d4abdd48c038eea615652b54f1835ed9a9367e2265d90c53243eda3d react.0.14.3.react.js\n508b865e03be00a579620397ccaf64eb623dac1fe7907713e065ee13e7abe763 react.0.14.3.react.min.js\n3b13f9ab0baa78c62c3c2c0c045ec211d129c05558ab374a3c107f64555f2ddc react.0.14.4.react.js\ndedd6c7382f3540dd31f6f6d8b3e35df483622b7985c9c05e7ec6708cd9d850a react.0.14.4.react.min.js\nd3154f2c9c28e9994b93a5a70fe349486de90f03c436efb9a3ec5a34cf736873 react.0.14.5.react.js\nfbe968490a229124995a933f03a64fc45811232ed8334ae74d67356156287190 react.0.14.5.react.min.js\n1cc3dd5cca32492ece67bb3b161e918a1017af2d2111a5fb001fa92344ec1cad react.0.14.6.react.js\nf7d7684d7b4944f6cf98dd49063e2cb7947a842bb842fc4d76b28b3d80f58f80 react.0.14.6.react.min.js\ne366ee32d7de3bce5282cd417bd9b2227a7355abffec9a29808cd5f6465353c5 react.0.14.7.react.js\nae03d8890063908433694a9b85535a200fa77711701e29c31e272509e2b5121c react.0.14.7.react.min.js\nc58b7d143215b617e3cf153349d5f2ae7a016be52bc829061380bf01c61e9654 react.0.14.8.react.js\n5bf97429fb6dffef4958c4c95b5056a54d503123d8332725f3feafd2dae94536 react.0.14.8.react.min.js\nf36da7c5775c1a75ccb3d0f944b9b07f80edc5571f73cf62ff08f77180e5b688 react.15.0.0.react.js\n99c7418bc3e68e50ec16d0b5f088a843bfae4f9b541a177dd4baef51318e7727 react.15.0.0.react.min.js\n1bb6de2c15ae78b145dd3a5135817ea47b178d92816174676ebd7f3d664cb99b react.15.0.1.react.js\n5f1aa40e3881f0e1d650e93b5d57ebb781730cf7efc47c6d790db97cd7405b42 react.15.0.1.react.min.js\ne0ae7d995a4e260550614d0d0b715ff6444836304965e28a37c05a7b31247bde react.15.0.2.react.js\na23deadaddd03efb5d8e8e0ce6065fac05f21c47d37ef61d7d12f68c0d997ce6 react.15.0.2.react.min.js\n674f2402937af89e985ea3d0d34d6391da23287c4b826b9ae725d6cd4ee77dcb react.15.1.0.react.js\nf5ff639cdabd1eae5a075a886e2212c01323bff530a0304096926123aaeefcf5 react.15.1.0.react.min.js\n2d4b9437155e88937f0e4ce9018a6339af63453bb615daf1d8c1a6b5a7e3bb72 react.15.2.0.react.js\nc269d453475deae9889e2948ba51a7cb15a4d264151222006112ffa26fed61c9 react.15.2.0.react.min.js\nd9bd21df34b0f2df150d4ba53e544b1c7ccc98fcbdbeb4c671100e2b421c992f react.15.2.1.react.js\ne3580771b2445336c6552e65d8503df8a550d57759a8636b05c5362caf4efed1 react.15.2.1.react.min.js\n61f4e5c2a8312b6e3b5bc79f0b9f90d03a0dab8f00e2a6d08ab3c99eb71dea07 react.15.3.0.react.js\ncb6b5e7be4a73938b11172f39fc4aed2fba5dace1d2d9c2f29ce30c0f82b30aa react.15.3.0.react.min.js\n7c907a052c23d4d2f5a91a85694ef43e76a0b4e42d155c7091dd51ae800000c3 react.15.3.1.react.js\naa657685fe11ef6b640949187aaede2744ff59cd091a1a7f5153f8954ff50d0a react.15.3.1.react.min.js\n4b7e4d258ad6df8b2ed7cdca0667d40db39f03098ad21ddf16a7697434bff29a react.15.3.2.react.js\n70b5acf4bf9c8d983c0a318732926a52028aa2e3e59a830fff4c0874fb5a3c6b react.15.3.2.react.min.js\n00f82cb52b38e9cd76802037e7ec129fbdb3f263d49e3d8d70378d852eaf68a7 react.15.4.0.react.js\n40028c1058e3d88521822cf779380de52fd5b5ba731c6df48af700c26b8fae96 react.15.4.0.react.min.js\n4ecfee81126c2524cda04a3b988e11367365a120b0f9cb66e1fb7c574c7f4948 react.15.4.1.react.js\n40dffdbcb186f54b0fdb6c1d84149e96cf041bab8b2f891e181afa2d29335643 react.15.4.1.react.min.js\n887271ada97774a796b8803efbaa9f681fc639b73fc7fe2028daae4ab495b360 react.15.4.2.react.js\n46d9df8b53156408f7bfe7837858e1fe2017a3cfff0f4cd52aa97c7e354b0a23 react.15.4.2.react.min.js\nf9ad54de578ea105aefb02e1a73baaf86cf4f1f7a09752199841acf714db9233 react.15.5.4.react.js\n94b4d7554e4d1cb975d355600f72ecc15e99808d8f8d28d9e5d57384172ae769 react.15.5.4.react.min.js\n84890c75b3b3c6b32963d467c62afcae58b1361e1c7f8f67fcd70ec4652ced3f react.15.6.0.react.js\n98c9ea0533d600e631a76be3f11604ab1df8be1313e0f1afc319b935d979cadf react.15.6.0.react.min.js\nd6e93f01789858325042058bd743f7573e6a848b320719f0a387709b0e1c6077 react.15.6.1.react.js\n8af74f027e61e94ebbcfa38f8307e22ccf6e83a95ebf199816a58dc4d095d181 react.15.6.1.react.min.js\nadd847d26d5d8fbb178d1f71e983b78ae37efad890c6becb146ab649345cf16e react.15.6.2.react.js\n73fd7bb5eed4a40062efec1c20700088830eacd315713233a31b514c3a18078b react.15.6.2.react.min.js\n97ce79a0a6c8510d61dd4436130c7375ea66734d98c72a84c0ddd36b1c60c02f react.15.7.0.react.js\n1c8857ef6aea6cd7223b685480742cadd68bf5f69af8ee5f39b3370d6652faf7 react.15.7.0.react.min.js\n41ea89287f31b51b3fbfc1e1b669a4219ec4e5843fd396f222c96484ff72e7cf react-dom.0.14.0.react-dom.js\n58017697b5c3f3b6315ca22886afbd6546d746321c013d1a632e61c7f0723805 react-dom.0.14.0.react-dom.min.js\nfd2f9a60bdb40ea48429d32c3f96cbc982ce550f061844bd36caad35430e385c react-dom.0.14.1.react-dom.js\naabbba780bc8574e09953972e4a7480e79323ce93d005ce5e5508ff98195e042 react-dom.0.14.1.react-dom.min.js\ne9857ea97c8635d79d3bb34c1053e9efc9b3c3e163b22bc59a759a9d364f9c85 react-dom.0.14.2.react-dom.js\n9ee04db431ef7f0b3584a9995c40724bbc1ad6ccdcc25be6a79b6d778a5f4c2c react-dom.0.14.2.react-dom.min.js\n1ecafae953c64e6dd84396988013e981911c32f3fe49d4718e7d05f9e5d506ff react-dom.0.14.3.react-dom.js\ne287ba1bbdc66d5084477d496d873a37a15693acd58dbcc64de3f54277070c6c react-dom.0.14.3.react-dom.min.js\n03fbf07db4e188437d821ead993cd25aca24ece1432024421d7613325babb8ae react-dom.0.14.4.react-dom.js\n9025e91020b17ab4dc22340430cb8f127223dcb73281b1670ac0892c483a1309 react-dom.0.14.4.react-dom.min.js\n8c10f7ed99035925d8b482ddb78be313764d49df07a5923dcfaf1438ecdf063e react-dom.0.14.5.react-dom.js\n45a31b9a36de63061c287b8f785554485b11a54374e559c5a455c15ac3fc8e89 react-dom.0.14.5.react-dom.min.js\ne93015b967cfec3b03d35692c9124abde7eb495f66b5b1bb11b618d67f195660 react-dom.0.14.6.react-dom.js\na92e7367c27b5e33f18a0cf389129254460fd83182ba898fff7120ae10ba2a90 react-dom.0.14.6.react-dom.min.js\n82a5bcc63c21d0c9fbc9d59f4333bc52e9a52b4c53fdeda6c17d3a5827fabca6 react-dom.0.14.7.react-dom.js\n2b4670650b0db71b6e434c3d549ab2f076b9f113a75f74412ad0e672ef75233e react-dom.0.14.7.react-dom.min.js\ncbeb120fb0d2cf735be17dd249be7fe96c4d2032eb87387c50a66fd31b8e4fb0 react-dom.0.14.8.react-dom.js\ne14a7d68be513ba4f813d708fee574fb40712bf4fecfa1b4e85131e76de634c4 react-dom.0.14.8.react-dom.min.js\nbba0fc0b2f5c68d691888d36858ecc9f627b1d9dacc3c43555651e29b7096027 react-dom.15.0.0.react-dom.js\n0fa28cfefff46b851099ca3015da7b8ab91ae14d9ea25ebfc9c378c694bd1f5b react-dom.15.0.0.react-dom.min.js\n0479009cafe10252f608ad9fcd8c975eccb2fcc3fd349f77e5b5a0856024557f react-dom.15.0.1.react-dom.js\n6f7bab960f38ff91b790afc6e3cdb1ee719e180af5d0b166f49bf3ffafae829c react-dom.15.0.1.react-dom.min.js\nd6af9481c2577d81d689fc20104ef05ea7f7220b32175ce1781b6958ea1f8255 react-dom.15.0.2.react-dom.js\nb2a80c2199064e1ec1fed1769d2c9773eb460580ac7d6893976208d7aee3ace4 react-dom.15.0.2.react-dom.min.js\nb1306efbd60b934120e5822b14e24d11d2134ea3e3ca36d4ce30ab9f6be7b91e react-dom.15.1.0.react-dom.js\n58970bbf80d8d75eb1002a5f50a9a5e0a2237831b85757bf4d37f8491c5a4b1e react-dom.15.1.0.react-dom.min.js\n481bad761e99d5300900c842a3211aeb750f57e25c1020a2179fed2e47aa0956 react-dom.15.2.0.react-dom.js\n1e1372ceaee16a0ae9e4d2a8d852c78a2d93ac6c136a7bb94fd9b283a4e9b555 react-dom.15.2.0.react-dom.min.js\nfeeafdc4ed848c3432a045e7c7ca1f6917663fc06b65089a5fa3f2d8892c6876 react-dom.15.2.1.react-dom.js\nb52a0abe9683c44d9f032c002cba606e4d65d1200b3da576d9170735a86bf67e react-dom.15.2.1.react-dom.min.js\n5297112dac46eb93b3e3771f34388f6da91865d174dfd4ce56b800523bd437b5 react-dom.15.3.0.react-dom.js\na86dfa9a3466b123a6bf51abb6b2c3d946085a9950d148e38a844aefdf9e233f react-dom.15.3.0.react-dom.min.js\nb21954c27bd30a43b46d2ba5500011333d63c2502d336f1678318610ac7edc60 react-dom.15.3.1.react-dom.js\naa311b05f2df53bcec91391dc820d65bc88ef515b11791bf2caf475dfd72e70a react-dom.15.3.1.react-dom.min.js\n33995cd72521a57966d956631a4e1aa05c2a47d1f5389d29e4c479c698a9ba59 react-dom.15.3.2.react-dom.js\n2485bc94da8dd84b6a0ba82035962701d28c2574507e43ccbdd46df9bd3f2717 react-dom.15.3.2.react-dom.min.js\nf8417149f900f4fba762ae5980c33a2b7fe381b5c449f6927170ca007bc4b884 react-dom.15.4.0.react-dom.js\n268339ec0dcc57c98762e34670535ad95312d7bafc21da38fbbbf6c60d4c0752 react-dom.15.4.0.react-dom.min.js\nc0e5ec99cdff1749a777c9eb15ff518f2788994f0ef6e85a875bcb7588543dee react-dom.15.4.1.react-dom.js\nc482ea9c68e5f4f9cdaf947daaac6b93cf7887f458e47fb892993a74d124cfa4 react-dom.15.4.1.react-dom.min.js\ne05bdc91756f087849131a429efd807380487711579c0f71cd63a0c3c29c2299 react-dom.15.4.2.react-dom.js\nbb32b062e1f9d031f30d8af787f067a6fec2e5024d5231c4a55993dd7baadf0c react-dom.15.4.2.react-dom.min.js\n2633da16f1cb9b548de481f3d8fe09d3eac68fc6a3973bac946d37c992c40e85 react-dom.15.5.4.react-dom.js\ne0344d7415feaaea3b7d1205b91f7286bd79ee1abff45700b074433501176523 react-dom.15.5.4.react-dom.min.js\n684c5f39a13d70547acbe43b7b6964224548ee544e63a799a2169349da7ede96 react-dom.15.6.0.react-dom.js\n786f96fe63b71d9bb0b98263293f5a61b642fcc54dd669a96e3c908460628611 react-dom.15.6.0.react-dom.min.js\n0e07aea15ce86b6497c54f3999f15254af055f797b1710a8067e6e3b7bf58d82 react-dom.15.6.1.react-dom.js\n504aa7e7eb72cdecc3e80e4704c35395ce665e49adfa88537c204fb5731a19bd react-dom.15.6.1.react-dom.min.js\n2cf49421691b9dbf1916f970e1532a724f39c10b36b3becc794114559f6e352b react-dom16.16.0.0.react-dom.development.js\n0dcb93a5c7859e1fa909ffe239b591ec329bfea81bf5e059ecb1b6f7e1ca7058 react-dom16.16.0.0.react-dom.production.min.js\nebd05654eeaf475d33179ed1cfc5d9e25561cdd3a18ded2f827244fd797486b2 react-dom16.16.1.0.react-dom.development.js\n4b589e536a85f6707a1f2e4018c1425ed6fe73e8ed4346452ee24949f28f86b9 react-dom16.16.1.0.react-dom.production.min.js\n7507e0152c67d20544c914cb1b49fabbb5b4255d008d12dc7c9619f88fc5daa7 react-dom16.16.1.1.react-dom.development.js\n77485f185036d3da0d6449c427c64928b97df99305788ac80221736924916395 react-dom16.16.1.1.react-dom.production.min.js\n3043646fb93e5f471d41abbc10fda410245f7340382eaf6ea3a4064a75a02b4a react-dom16.16.2.0.react-dom.development.js\nf61ac9c43e0842c58774da732e424a606898fd211914925252ac9e64f34a77c8 react-dom16.16.2.0.react-dom.production.min.js\nc0c163a7aafcd9bba456dea5cd54c8c2b5fbf3a80764780f4a0c4785d553ae78 react-dom16.16.3.0.react-dom.development.js\na15dd3609e69da9d2a5c0dae4f731ea6eec529ad191f4a4b5b6840e5d9beed5e react-dom16.16.3.0.react-dom.production.min.js\n0532cb4f6e5db64848cb554e07a9d95b00dbb2bcc0a3e602dcbf60f6ed0c694e react-dom16.16.4.0.react-dom.development.js\naaceabb9d1a1c4f32fd95ab6432621fc34e7d3955ef31527e9698171abf5e998 react-dom16.16.4.0.react-dom.production.min.js\n4a26b9a3b54b125ae0e91f549e5e099106e59c1caa84193103ac555ab36fc6aa react-dom16.16.4.1.react-dom.development.js\ncbba3f6f7e49ca36f5f7027ffc65239bce1b2e5f989660c69a7c29819bf337ee react-dom16.16.4.1.react-dom.production.min.js\n51efbd27f5eb982df9d25a1a0371843b90d9bbfce1beffce45c9a9844888ea6c react-dom16.16.4.2.react-dom.development.js\ndcd354ff2a04d11ed5c716a92a2c3f864810cdc48ccedc9c95be51a5e56557b6 react-dom16.16.4.2.react-dom.production.min.js\nc320ede7e93de981d1401cb723c0a8310b50d2cc8d929de91ade520152c6d5df react-dom16.16.5.0.react-dom.development.js\n286239f3471dbde029c3f115f67725fcf16a9fbbd561ddea3c184766f92a5e29 react-dom16.16.5.0.react-dom.production.min.js\n4695e7373968b1190f86f4dc3a7f0f2c518d70d6ebe9b4e381fd9a347035f8ad react-dom16.16.5.1.react-dom.development.js\n6a1c1aea7c35cb2bb609f41fd4a6a0911534c7535f1c844e5d3fac9e45fd138f react-dom16.16.5.1.react-dom.production.min.js\nf307763f6623e30903efc5dfcf15630e31052981164778e064a80d086516f6b2 react-dom16.16.5.2.react-dom.development.js\ncf12ee84c417cbb401083f27253d0541a64dd8605c7442f8ce8a22fe3026bbad react-dom16.16.5.2.react-dom.production.min.js\n078c80bf556d876a6bd9d972227ce1e23f2f85ff100c0921433bf23c1bc49079 react-dom16.16.6.0.react-dom.development.js\n91758fd769bfe8c936505615fbf5a07f1d2c2eddfac7b6f2433f4b7fd8d972d6 react-dom16.16.6.0.react-dom.production.min.js\n81a69b296eba5b9563aafcbd237079ad685ce0725f79d423d33f8dd4000efe94 react-dom16.16.6.1.react-dom.development.js\n5c3e3502e1bec53b0da5afc287c5b30ccea20ad97b30c252c7a37dbf7ccf457f react-dom16.16.6.1.react-dom.production.min.js\n086fc21c97fd1b006b9544dbaa3a478cad2a1c1f188eb1ab26ea2cfe6c867b75 react-dom16.16.6.3.react-dom.development.js\naf70bb4ed742cb5f93ae37027d1b7c2588708c7df36981f11e1bd2063f167eb1 react-dom16.16.6.3.react-dom.production.min.js\nf233d35475ece9bbd20c919b444c3629bf9e82c927b3ed74c0ebfbe9a79a5e08 react-dom16.16.7.0.react-dom.development.js\nc62c658243dff42ccf37f11452d1a01818c8e35d6ab3276bae00d32b066f237b react-dom16.16.7.0.react-dom.production.min.js\nfe695519da162a1ad766e7566f567d4f67ffeaca17375d672354d342934ab70b react-dom16.16.8.0.react-dom.development.js\n96d4cef22541fa9d98222885a20a30133ced4ee396f69675aac711730e9a3d80 react-dom16.16.8.0.react-dom.production.min.js\n5b463a5c5b27728187b8d12d9da72bc74d93dd466cba2a1a1d135e22b2751d10 react-dom16.16.8.1.react-dom.development.js\nb45b7f77871a78d00ac134ff65d209c08361703853e57eacfd46c5a0b6bf26ee react-dom16.16.8.1.react-dom.production.min.js\n66544a5d6063071c36bb872b4b7119bbb49287c190a46c0dbf01ab667af32c64 react-dom16.16.8.2.react-dom.development.js\n2488ca4f62cc4b36345d0f6a94daae3fd0ba41cff5c37988dd0edbf9b0e10930 react-dom16.16.8.2.react-dom.production.min.js\nc5c7d5a81675a1c9115083c1cae5b22615613769d73558c4033f3c9332d635f8 react-dom16.16.8.3.react-dom.development.js\n07fee28413513b371da11925d4d94acc6be36694299784ad51ba8af2c519c5b1 react-dom16.16.8.3.react-dom.production.min.js\ncda0486ba92ec04b29cce214e53781e5b0139f19af2459a1b7db268b98cb1ff4 react-dom16.16.8.4.react-dom.development.js\nf2e5961bfec2077392f3d0b0ebbf81fbeb7ac3410c19f404f42e8e1a9b3e59df react-dom16.16.8.4.react-dom.production.min.js\n4005833d3620f55239dca4b64e4f041a5c3fe67183d1d150d5101c2042ac3184 react-dom16.16.8.5.react-dom.development.js\nf6174c7284a4dde6adb6db64e8f588e26b92201118fe6b154eced6baf5d02cdd react-dom16.16.8.5.react-dom.production.min.js\n23f0a5ad8cb395811090c523aabec6de6ffcdf39e5c9c0c2788db1b8166c431d react-dom16.16.8.6.react-dom.development.js\na95b05d5fb4bdef52af1114e2f03e72a299738ba3bdb182e0e5888c5e7df1d17 react-dom16.16.8.6.react-dom.production.min.js\nb4e8d85c2931a9b9967a3e5ed09429e2f6808b86b89eaec17bbfd21d6f3293f5 react-dom16.16.9.0.react-dom.development.js\n5903b1bee475a683a2d2ac0869fbbdb16609e2b8dede8027d2fee274122d9003 react-dom16.16.9.0.react-dom.production.min.js\n6c844c2ba9a96fceff7b6256a0d0ba3ed080fe163b5ce42accd27d8e0a9e516a react-dom16.16.10.0.react-dom.development.js\n1e84fe8938d0b1cabc9518479b33e9691392223227ec640d3dc55246e326ba43 react-dom16.16.10.0.react-dom.production.min.js\n5011742024f7c702d15e5fadbd56a22153e15fa7c54cc599f55f52c6a0af0b9a react-dom16.16.10.1.react-dom.development.js\n410b7a3294dd003d0388f2e1aa1cd5c8fb357e521db2d478fd1ef1e06a82bd9e react-dom16.16.10.1.react-dom.production.min.js\n64c077aefc66df2afe94dd7635c34025bc3a2505856a1dd0c77b375c7d59d0ff react-dom16.16.10.2.react-dom.development.js\n876142635927d6ac177cc6f01d7b83375e688a077ca58733e0a527978700741d react-dom16.16.10.2.react-dom.production.min.js\nf04cd937cde17c6eb97d84bb7a7473218957266e1eb868c0e135cda7ca888365 react-dom16.16.11.0.react-dom.development.js\ncee483bc83e180f0af0c5c371dd6c0e7c41438e1b13dbb3896552f04e3f1be36 react-dom16.16.11.0.react-dom.production.min.js\n4892ccf86902c4f3f4954a190acbdcc076d7acaa2976296749856d1ded99af9a react-dom16.16.12.0.react-dom.development.js\na76cae15d13c84d66c437d5093eb3c37e31ed9f2f971ce8d297382d14f6e1b0c react-dom16.16.12.0.react-dom.production.min.js\nec735a49be61970ffb934d84867857769b421e9a23fc28c33cfff016c1a31be8 react-dom16.16.13.0.react-dom.development.js\n6e3438d9a73710dd06a8ae34a42f601a2fd88b1bcac99db8a8c3fff478865bbc react-dom16.16.13.0.react-dom.production.min.js\nff3f41bae0831b9ad0687401416b739377413938d300eae7f925124460e3478d react-dom16.16.13.1.react-dom.development.js\nbc5b7797e8a595e365c1385b0d47683d3a85f3533c58d499659b771c48ec6d25 react-dom16.16.13.1.react-dom.production.min.js\n493ecfdc30046522c71c19c2f80c913460d115b4872bb1223c2de10639153990 react16.16.0.0.react.development.js\nde59b0d4504aa0350c13775fec9b78859f3eda83dea21d60dded98bb7866d54a react16.16.0.0.react.production.min.js\n370c93b477bfa29f564fcab84891a68a39357030362a9f4d6c356b0189dfb0ca react16.16.1.0.react.development.js\n6b71aa877d6ccd3724598cdd2596dbb4c608af93abb61cbad2eb8f53238175a1 react16.16.1.0.react.production.min.js\n1523dc5b4e65428e350cf1d42fd7b071d531e042e1318ce7aa757c5a04357341 react16.16.1.1.react.development.js\n68e3a3542f7949982ea16b02691b242e191b545b1a60aa182689b855d1e5384a react16.16.1.1.react.production.min.js\na0aef2c420716ef07a7f4937d2c1d010deeb20c925c5e8859333bfc4ea80d39e react16.16.2.0.react.development.js\nc28b91922bca297037cba02ec85c1c0dc179d1a942355f0b6e085f6021fa67df react16.16.2.0.react.production.min.js\nc7414cc10de6685d485a934079dec57d1ec3cb71c2e0a9a160e4a478eb3db5b5 react16.16.3.0.react.development.js\n41453f0f5c2c744e2aa4aa8417a043c48ed236bf900910e9ba9c155d831c142e react16.16.3.0.react.production.min.js\n0818421c60224d55c3f8b87545f863d84f788dc172444e4ab4ed7c5e70b8ee27 react16.16.4.0.react.development.js\nb287740775c94d155b01eae2778b3c8585e3a71a9898bb693fabb504f899dfd8 react16.16.4.0.react.production.min.js\n2b6bd04fc1e36839d9bf1d5b8c39fc71414c4ad7b38657daa16036c4a221d076 react16.16.4.1.react.development.js\nafa728c8dd03125fefc8a322881f7e023a9228ef174dd18e1639408529ecab13 react16.16.4.1.react.production.min.js\ndd74941e5985bd465c06bef5f3a39cf688d84093ae9b1a40e8d807de5f9b417f react16.16.4.2.react.development.js\nd84431e49d6ec77b2380f2ed0debe5a38e3d5cd5dfbc4a65711616205eae8bcc react16.16.4.2.react.production.min.js\n513077c0947bfafdd8c826c76f97dd9249c95bedaeeb136b4756f4413e291f27 react16.16.5.0.react.development.js\n7155c56fdcb1d2df29d622ac50eb8ed773652a133ec7a281acee5740fa957377 react16.16.5.0.react.production.min.js\n2e5d2abc5db387826656282d79c747caa72adb54073854fd14a4ade865938735 react16.16.5.1.react.development.js\n8778d55851d41bf1bb1673bba10f51cb39901172df322ab52ef5f99db2229fcd react16.16.5.1.react.production.min.js\n562b45de786dc12e28c7275dca9108341132552df1ca4d0d82693475a12789c9 react16.16.5.2.react.development.js\n6a526700a518d11ba17f9e4afc2fac0b2cfacda8a91a1975931bb30d6de3b479 react16.16.5.2.react.production.min.js\n13967667b11791930cc0201a41a0e553659cbcf108e75d421a2f6aa1d47df76b react16.16.6.0.react.development.js\n678b4387249a82fb7012cb5bdbd0142f2a758c1e7ad817913485b4c94b674239 react16.16.6.0.react.production.min.js\n3269d86229925fc87139d6d8280d5277b68c6723dadc64531f7d5ec6943ba105 react16.16.6.1.react.development.js\n455cc7baa767ae55c69fce387718ee7dcafdfc86d0ba9c84b5f3684d857546c1 react16.16.6.1.react.production.min.js\nbe7183c620e487e8e567e79d02265c48ea7b9a83f7586f33d06d2d06e0c6e9ab react16.16.6.3.react.development.js\n24144b413eda2789953b41f61d1846821bff2bbe9ce56cc4e7bc16d0595ce996 react16.16.6.3.react.production.min.js\nbb02cc75dc83b7bcc6f4e20f3db81365b235718dc7796193fb267aced322d724 react16.16.7.0.react.development.js\n2a9e6614914b203b2c94326ae9a17088c8c89c43d8bc6188bfdbc90b83950ca5 react16.16.7.0.react.production.min.js\n63221ba4466013ea025e552fcc57ed2eb2214ba7e4dc4ed6feaa3e6150ada567 react16.16.8.0.react.development.js\n9acb31ff635081719ea0afc0bdbff6e64b27b4dced0b92fd60584d770a6b71f5 react16.16.8.0.react.production.min.js\ne5a017f69e7de3759f65a45c516c2fcc72ad5dc59f3ee767501a19efc919a13d react16.16.8.1.react.development.js\nccbaba07cffaaf2a8346e3f5868e54af3c274d5332cd0bcd2a28fc9f54827749 react16.16.8.1.react.production.min.js\nadbb82b4460e4b0302bc2373ec9aecb8ca6fbf8069c16050d277e9068090146a react16.16.8.2.react.development.js\n293143b258a4986ea976533fb1689f2ca52864ee8d00a721c4e0dd297cebae49 react16.16.8.2.react.production.min.js\n3d12c8d4a8c4061e81e56ac981a11c4604dab8480fbc4d4a7c8aad9a0a6a2c83 react16.16.8.3.react.development.js\n6f527dde8b4edc9d347102fcb41e17d26cf00aff727693ea9140f7fc2a298842 react16.16.8.3.react.production.min.js\ne6a5f34e90a67b6825a6320c0fcd8df42bc7ce8b7b0ec363f89f35c0d0580acf react16.16.8.4.react.development.js\n72d51a9ae220482420d70b21f08c3441b0d749c9b25e18c9ea5c5852c702dc50 react16.16.8.4.react.production.min.js\na345a56837a698a1bc3a41f6c3bb0ff2461ba9e2631fbacc872142b9f71a81f8 react16.16.8.5.react.development.js\n74b8f1479e8c99187ff30a8ed80835c4cd1811ec7d19cdb954ff06f7f3db5c22 react16.16.8.5.react.production.min.js\nf47d3978251ae71e06dbc772b58070a005e44775e03c4dec0a88325e1ac8370a react16.16.8.6.react.development.js\ndefa3ae595e7e697ec09f18ce47e795fe4a6c091c19723473f04665803e02673 react16.16.8.6.react.production.min.js\n5b12f0a8284718c118f9ad867e73b3c115fa0f536c7f8d8844f8b8395ec184fc react16.16.9.0.react.development.js\nd797bb58f111874a36c0ee0b3504b5e7a6b42d9e84a581d8f70cc0a72aa27b4f react16.16.9.0.react.production.min.js\nbeb2b96bb6d38743d1974de1901e966e627efe8a5d8ca5d5d312e2c5e6cf12ce react16.16.10.0.react.development.js\nfa89f2d28b097f1c3033734ef788ab5b048fc1c6ffcb2ffbd89ade55ebafc408 react16.16.10.0.react.production.min.js\nb6ae0e176d0de2d88768ca48ba20fafc1bc22f3dc1fe9fe881ec1ceead27ea0b react16.16.10.1.react.development.js\nbcc123a1e4a5ce95afadeb399839719922b1c7a8c0983358e330adef5d98088d react16.16.10.1.react.production.min.js\n172d3ea21efabbe76287d8a6373af429ad511db54a57ca389d1fa9f2ceb04d71 react16.16.10.2.react.development.js\n907cf0358ac2162896663aa646ea4153c2d829662dd4bae9a288cdf0a9aff387 react16.16.10.2.react.production.min.js\n74ce07b0dd1caed0d07ee368be8da46bee877043c9232da712a408f9ba22c41c react16.16.11.0.react.development.js\n2338398eb2166994ba3818d17def4037f92288855815381c2ae909b1f2bc3abd react16.16.11.0.react.production.min.js\n19a9fdf196457780a6067a1ca037f9a1d1140ee8b4146c50038eb07790e50166 react16.16.12.0.react.development.js\n11fd2f39b756a643009f1a77f536122d54bfbd552890313c083167c7bb6363a5 react16.16.12.0.react.production.min.js\n1fa59029f64c9f5cdca7b6fed94c41f57c4b8222644dd0c943049ff0acb4f0f3 react16.16.13.0.react.development.js\ndf61a6c39ac10d7c8c8e0ffbdc5829ba4a1365d32bc6e616eed8fc69d6cdf33e react16.16.13.0.react.production.min.js\ne20246131ff35c0c687e42cf197894d88247a923a6615df746ed33c344de277d react16.16.13.1.react.development.js\nc9486f126615859fc61ac84840a02b2efc920d287a71d99d708c74b2947750fe react16.16.13.1.react.production.min.js\n75bf60f3ea0e3cbcdbdecc902eeb842b6cbe39db8e62f1fa7f91a755d51d020c react16.16.14.0.react.development.js\n5cef9367d2bcaba25b74d20e0e139d2cf900e9123e5fde26101aee7f40f6b5cf react16.16.14.0.react.production.min.js\n6547a35f65d7a56cb1d5343446256ed3bdcda69bf41bbf2141066dd8b40f81ad react16.17.0.0.react.development.js\n3f32b648ad12f1995268a05121f01af6c8fb4f978cce86c528e79763502ea800 react16.17.0.0.react.production.min.js\nbe07a2db4a3f489eae996de2beac89868dde87326d434ffb4574ba675eee0bd0 react16.17.0.1.react.development.js\n020d164dcf3116ccc2268d6a6e44caa77c0131d8e98e882c6430219d281eef8e react16.17.0.1.react.production.min.js\n420e5861e1bc03a5a93660256af02d3c7de7fbce2fa5f07183521a5d22231117 underscore.1.2.0.underscore.js\n0e9fe368d777cd4bc5580a1e570128c5f1564c09ae8b6ae0ef7fa7c8d6106a40 underscore.1.2.0.underscore-min.js\n2e2e4a7d2772c9d1ddfab745f5f973b59b4ed741c51b994334bebc454af041ca underscore.1.2.1.underscore.js\n5363c436871957e5b2a4dea399545feda648db13d0414910cc1acee12f05cdab underscore.1.2.1.underscore-min.js\n9836e801c314da41ebffb09a46eb0d313e76d4aa5242f7c3fff8a3a20bd45038 underscore.1.2.2.underscore.js\n42d6c56d8a983ca98112fdc9e75688c34bedd9d1308e5740deb71993d6c1ae3a underscore.1.2.2.underscore-min.js\n22729344b976cc44fed6bb389059a647ceb8a0b89ae5c5120e6f42ecc2522b0b underscore.1.2.3.underscore.js\ndd5a5741cf628f152ad39dadca9aeef15c19ac3de69ecf41b4321b577641c056 underscore.1.2.3.underscore-min.js\nf53f5b8c13f99c295f48b756cb23b2803246b346dd4605d396bcfce31a60fdf9 underscore.1.2.4.underscore.js\n5e88c8fd49ad0a719f6f2adc71d650e7c201bbcfbe46fdf532fbfce23fcc23b6 underscore.1.2.4.underscore-min.js\n6422a2fa2f0f31c185c169bd31366c93fa885f554ad5e7e3a4c23d6742a1d5de underscore.1.3.0.underscore.js\nb832c2eccf70ade054d627651551196e016e9e3d6a35282afcceb7aa7ff99c41 underscore.1.3.0.underscore-min.js\nf808f0aa32fbe90fb9c9c846917faff3fdd4e236c284b76c02dd33753dc90177 underscore.1.3.1.underscore.js\n42d8fad13bc28fc726775196ec9ab953febf9bde175c5845128361c953fa17f4 underscore.1.3.1.underscore-min.js\n35b15b04a8110f2631529d32d093d6c7c1007b05f71f649c64f31b0beae61aca underscore.1.3.2.underscore.js\nf5300eb60743a9b5f5e015cfa3a29cc187051cb6c8097e821164c1cad2f86cc7 underscore.1.3.2.underscore-min.js\n49f14bad610f40f0ae76a33c55ef89a1e694219bab49b1b99cb53d754774c0fc underscore.1.3.3.underscore.js\n0f201fe52208471c863c292da4990ca7bb7ca5d58b3f1ea2a57095ff764c6848 underscore.1.3.3.underscore-min.js\n1258fb3ec5df4f2fa771d26aff20a07e9b71f1c08dfd45c86fc00ed8f0326c69 underscore.1.4.0.underscore.js\nfaab51654de7d65c0cab1e32c0403a7752e0e6a4cccb433d823d4a1de563c515 underscore.1.4.0.underscore-min.js\n3eec9a11de61554b41d142f57ea610747e44699338e2b471f1109548ac0597b7 underscore.1.4.1.underscore.js\nab0d4345dc2801d2667ff3a0ae25926d20154ba7540f6797ad4baab4681e2fa8 underscore.1.4.1.underscore-min.js\nf7852d7466f17019073cb7a1a794a30b91b13f01cc49774f4075a695270c0a3b underscore.1.4.2.underscore.js\n03ae3ad62082d4e7443de69006761d2e59b49e7f11bc209b8a5a01762d28d6b2 underscore.1.4.2.underscore-min.js\na10aa2eb9078c2e19f181ac722b1c19a29b8db1069556c508a3beb5c46289d7b underscore.1.4.3.underscore.js\nc53816234c2fd19da23c01faa3b01169a1c38bc466bcd9a282a019861a84bbb8 underscore.1.4.3.underscore-min.js\n32037dee4499126b99715750145392c8b00a7db213b2052e7032afb10fadd5da underscore.1.4.4.underscore.js\n27829b1d29e3fb532d761987d4057275d1e9ecdd3eaf4b4c40a29382590b820e underscore.1.4.4.underscore-min.js\n995a99b9cf69f2a48789cc4b8c12f75fc26418ed539b567505d0fce3cbc710c9 underscore.1.5.0.underscore.js\n817af2c86f48426d2756c83fbdf86bc2b4993e4f377d9e4b6c708aa669ab0dc5 underscore.1.5.0.underscore-min.js\n484e5a48a1d1eafdf4cfaeacafea998c3a43d25b6277ce0bd29737f5d081b598 underscore.1.5.1.underscore.js\n0b44e36460d066ba2e00a4f1a0adb193ca14a99ce5c2222099a4247ba6ee9f01 underscore.1.5.1.underscore-min.js\n023f31d6996b4ff1b3543fea50be852ecbdbdce8b9e8d0610b72918e1f9d91c3 underscore.1.5.2.underscore.js\nf205111f00aa36a51e6b312a74e58abc82394f207e48af4d596680b2a0125c2a underscore.1.5.2.underscore-min.js\nee8ba6b58a9c67d9f7148b31f90851767c45aeaa8c86fbf7e981ba255d39240b underscore.1.6.0.underscore.js\n163189ef69a3c210a04bb4cac2c336119d78b576fb84b4231977514419eb0faf underscore.1.6.0.underscore-min.js\n53596846ab864b5bc4e4605181ad18feac56662185de74eff3373e98508cf0eb underscore.1.7.0.underscore.js\n7b6fbd8af1c538408f2fe7eef5f6c52b85db12ab91b63277287e5e9ea83a4931 underscore.1.7.0.underscore-min.js\nc45c8504a0e57560128479b578e703f9533b6d56feaee5c773030138a3d3b4a1 underscore.1.8.0.underscore.js\n6e5582e8b2817eecbc135f2b1c312ec5e6a7217c7eafc658423c939b87c9134d underscore.1.8.0.underscore-min.js\n13332633f2eae3147df1ca250381a2dc391a68b353a383b2805f901d4c67923b underscore.1.8.1.underscore.js\n8b7dbdfa7de515cdc794dfdef15b63c2cc3228f7ff26670494b0f7d089b86f38 underscore.1.8.1.underscore-min.js\nb84a7a5ac0e8afc4f176b95606590bfc56044eeae9286097bdee013a6909fde5 underscore.1.8.2.underscore.js\n2de19ea3b85e03239dd9cbe30d9545a1b5a7ce2f0662feaeaf3d2d088179ea5c underscore.1.8.2.underscore-min.js\n4b328e42c558197d5b99d7727cfcc60bac9763fad660651230e8baf93f6067ed underscore.1.8.3.underscore.js\na1b6400a21ddee090e93d8882ffa629963132785bfa41b0abbea199d278121e9 underscore.1.8.3.underscore-min.js\n51aa76b532ba52182c46386e5bd2df155103d3abcd49300c7ecb6bdc7d93a25b underscore.1.9.0.underscore.js\nb6be05bd7559a7c9e45bb4ef5b83980392963acedf7369b907a2cdf803a7d552 underscore.1.9.0.underscore-min.js\n3b8d7bf449fccda6ce94f60136f1a9f1c174ba1d2f9d26695b843a525d61fbc7 underscore.1.9.1.underscore.js\n1bb03826b26326516a3f4c9a9b39f03e3000a4828f91a75e1dfc88c2269af5ed underscore.1.9.1.underscore-min.js\n716f46856dfd3d43a2848e33c91248516c3284c45e341e910e62f02fb926882e underscore.1.9.2.underscore.js\n22b404d34700979e4c9746c855a72f38d926d317ca16336e1e24614664a6ff2e underscore.1.9.2.underscore-min.js\n1c6728a3d862b85c33cefce07c6652c3301d98a5664fa1e2fb53732a9af4256b underscore.1.10.0.underscore.js\n1e4b1c5d112131699d84de1eb61be01927f23ee11d5f6c6accca92063a75fa95 underscore.1.10.0.underscore-min.js\na876a5e66659878bee48446fdfdcf9a11e9cde905e4f2c73ac966435ea5b1eee underscore.1.10.1.underscore.js\n2c00a9b27d8c5ea118596358bcd93e4ca765a97ba133e4106f9153ea58da9359 underscore.1.10.1.underscore-min.js\n1445bbc252e10d7a7aab5d679a29b398b4a446ad9cc9712d63bb6eadee7c989d underscore.1.10.2.underscore.js\n6afd53bf2c2d67866ac828ffe8776d087489767f341c0cd380405326dfcef2e7 underscore.1.10.2.underscore-min.js\n4136c101522c2915d8bd5d47e807d1b5fb02712ec51e893cf1dd4a3e39af68bf underscore.1.11.0.underscore.js\nd62f9c89984ad059d574ae6b64c9134628041695c09290643e2d53238638bdda underscore.1.11.0.underscore-min.js\n9964412824ab0ffe530e8019cf330e2aa2c3eacea489fe387f909e12c0f0d433 underscore.1.12.0.underscore.js\n1bc0ea4e2fe66ac337fb1863bbdb4c8f044ee4e84dbe0f0f1b3959bebfa539c1 underscore.1.12.0.underscore-min.js\n8c24e09024338ca43d2e2bdcc349433f94b1bf3a3787bed077f97fbda163d3b1 webextension-polyfill.0.1.1.browser-polyfill.js\n11970caafca2eaee807b79f1c6ca412100e47328d64721dad64aa619dda41cff webextension-polyfill.0.1.1.browser-polyfill.min.js\n240c7c3a9da915a6bbd2cebf2702aaa7fda54b493cb6f1db8ce44ca510734d2f webextension-polyfill.0.1.2.browser-polyfill.js\nc204650eb44c44f4ec19a7bc19995f5f2642b3de009fbbb1b999677fca65a714 webextension-polyfill.0.1.2.browser-polyfill.min.js\n824a321eba5fc21f06a9efeba19861b83e1a1c8cddee92cfca16064d771056d0 webextension-polyfill.0.2.0.browser-polyfill.js\n0912829eb35b502c83046395b1f89b6e6038ea0b0a2ac4c882077984f66002d3 webextension-polyfill.0.2.0.browser-polyfill.min.js\n091758d5356e7570ad709ad874d506b47872ace2702bba4b31a3ab520f711fd2 webextension-polyfill.0.2.1.browser-polyfill.js\ndb9ea23c5b619544c56c04fdb450cd88db7f220021344edc44c2e5cf95287826 webextension-polyfill.0.2.1.browser-polyfill.min.js\ne9b13454c0a2cf69936b90d46a8341d6216154baa232a02007b323e4770c29f7 webextension-polyfill.0.3.0.browser-polyfill.js\nc20a66af5674bdb163d628cdc88d27d07295ff0a847da514d2bbfc106e2d5c6c webextension-polyfill.0.3.0.browser-polyfill.min.js\n67c31495622acbca3cce2e6024c3679214a3bf5c16ac1c504347f2916aede4cb webextension-polyfill.0.3.1.browser-polyfill.js\nc4af642ba41957f7d768fde1c5bec5a43f873325abcffcfa0031fbfbac610e75 webextension-polyfill.0.3.1.browser-polyfill.min.js\nbb37dcae17c857b656c3557e1253e042ebf5e818db829b46771af02318a7faa7 webextension-polyfill.0.4.0.browser-polyfill.js\ncc717f237e42acca98d833f5ab217dcf69fc2651a5d637b6a6f04fcb8aea2735 webextension-polyfill.0.4.0.browser-polyfill.min.js\nf519e624c1204d231f10609831727f69f52516cbb4941af4cafd26b2dfd9361b webextension-polyfill.0.5.0.browser-polyfill.js\n62e99fc92dc73e16f11eda78cd316d1cb38c83ca967156adff6c3b045123d708 webextension-polyfill.0.5.0.browser-polyfill.min.js\nae129e111468aa63f7b6b4161e399bd8b66d0f8e711702a815b8fb52fc214402 webextension-polyfill.0.6.0.browser-polyfill.js\n36f0eae00fb83a530a1a7dc662982122cd463ddfb09bfe6db1feb218127cfa50 webextension-polyfill.0.6.0.browser-polyfill.min.js\n0d7e5b0198bab9ddac31604842a0090deb10c76001039641483ac22c1ca0ec1a webextension-polyfill.0.7.0.browser-polyfill.js\n786da7342d56de20c2a20737baae56add4f680256ea6000fe58b0534d75ce570 webextension-polyfill.0.7.0.browser-polyfill.min.js\n");

/***/ }),
/* 149 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = hasher;
var _crypto = __webpack_require__(150);
function hasher(string) {
  return (0, _crypto.createHash)('sha256').update(string, 'utf8').digest('hex');
}

/***/ }),
/* 150 */
/***/ ((module) => {

module.exports = require("crypto");

/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			id: moduleId,
/******/ 			loaded: false,
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = __webpack_module_cache__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/node module decorator */
/******/ 	(() => {
/******/ 		__webpack_require__.nmd = (module) => {
/******/ 			module.paths = [];
/******/ 			if (!module.children) module.children = [];
/******/ 			return module;
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// module cache are used so entry inlining is disabled
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	var __webpack_exports__ = __webpack_require__(__webpack_require__.s = 0);
/******/ 	module.exports = __webpack_exports__["default"];
/******/ 	
/******/ })()
;
//# sourceMappingURL=addons-linter.js.map