"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigationBuilder = useNavigationBuilder;
var _routers = require("@react-navigation/routers");
var React = _interopRequireWildcard(require("react"));
var _reactIs = require("react-is");
var _useLatestCallback = _interopRequireDefault(require("use-latest-callback"));
var _deepFreeze = require("./deepFreeze.js");
var _Group = require("./Group.js");
var _isArrayEqual = require("./isArrayEqual.js");
var _isRecordEqual = require("./isRecordEqual.js");
var _NavigationHelpersContext = require("./NavigationHelpersContext.js");
var _NavigationRouteContext = require("./NavigationRouteContext.js");
var _NavigationStateContext = require("./NavigationStateContext.js");
var _PreventRemoveProvider = require("./PreventRemoveProvider.js");
var _Screen = require("./Screen.js");
var _types = require("./types.js");
var _useChildListeners = require("./useChildListeners.js");
var _useComponent = require("./useComponent.js");
var _useCurrentRender = require("./useCurrentRender.js");
var _useDescriptors = require("./useDescriptors.js");
var _useEventEmitter = require("./useEventEmitter.js");
var _useFocusedListenersChildrenAdapter = require("./useFocusedListenersChildrenAdapter.js");
var _useFocusEvents = require("./useFocusEvents.js");
var _useIsomorphicLayoutEffect = require("./useIsomorphicLayoutEffect");
var _useKeyedChildListeners = require("./useKeyedChildListeners.js");
var _useLazyValue = require("./useLazyValue.js");
var _useNavigationHelpers = require("./useNavigationHelpers.js");
var _useOnAction = require("./useOnAction.js");
var _useOnGetState = require("./useOnGetState.js");
var _useOnRouteFocus = require("./useOnRouteFocus.js");
var _useRegisterNavigator = require("./useRegisterNavigator.js");
var _useScheduleUpdate = require("./useScheduleUpdate.js");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// This is to make TypeScript compiler happy
_types.PrivateValueStore;
const isValidKey = key => key === undefined || typeof key === 'string' && key !== '';

/**
 * Extract route config object from React children elements.
 *
 * @param children React Elements to extract the config from.
 */
const getRouteConfigsFromChildren = (children, groupKey, groupOptions, groupLayout) => {
  const configs = React.Children.toArray(children).reduce((acc, child) => {
    if (/*#__PURE__*/React.isValidElement(child)) {
      if (child.type === _Screen.Screen) {
        // We can only extract the config from `Screen` elements
        // If something else was rendered, it's probably a bug

        if (!isValidKey(child.props.navigationKey)) {
          throw new Error(`Got an invalid 'navigationKey' prop (${JSON.stringify(child.props.navigationKey)}) for the screen '${child.props.name}'. It must be a non-empty string or 'undefined'.`);
        }
        acc.push({
          keys: [groupKey, child.props.navigationKey],
          options: groupOptions,
          layout: groupLayout,
          props: child.props
        });
        return acc;
      }
      if (child.type === React.Fragment || child.type === _Group.Group) {
        if (!isValidKey(child.props.navigationKey)) {
          throw new Error(`Got an invalid 'navigationKey' prop (${JSON.stringify(child.props.navigationKey)}) for the group. It must be a non-empty string or 'undefined'.`);
        }

        // When we encounter a fragment or group, we need to dive into its children to extract the configs
        // This is handy to conditionally define a group of screens
        acc.push(...getRouteConfigsFromChildren(child.props.children, child.props.navigationKey, child.type !== _Group.Group ? groupOptions : groupOptions != null ? [...groupOptions, child.props.screenOptions] : [child.props.screenOptions], typeof child.props.screenLayout === 'function' ? child.props.screenLayout : groupLayout));
        return acc;
      }
    }
    throw new Error(`A navigator can only contain 'Screen', 'Group' or 'React.Fragment' as its direct children (found ${/*#__PURE__*/React.isValidElement(child) ? `'${typeof child.type === 'string' ? child.type : child.type?.name}'${child.props != null && typeof child.props === 'object' && 'name' in child.props && child.props?.name ? ` for the screen '${child.props.name}'` : ''}` : typeof child === 'object' ? JSON.stringify(child) : `'${String(child)}'`}). To render this component in the navigator, pass it in the 'component' prop to 'Screen'.`);
  }, []);
  if (process.env.NODE_ENV !== 'production') {
    configs.forEach(config => {
      const {
        name,
        children,
        component,
        getComponent
      } = config.props;
      if (typeof name !== 'string' || !name) {
        throw new Error(`Got an invalid name (${JSON.stringify(name)}) for the screen. It must be a non-empty string.`);
      }
      if (children != null || component !== undefined || getComponent !== undefined) {
        if (children != null && component !== undefined) {
          throw new Error(`Got both 'component' and 'children' props for the screen '${name}'. You must pass only one of them.`);
        }
        if (children != null && getComponent !== undefined) {
          throw new Error(`Got both 'getComponent' and 'children' props for the screen '${name}'. You must pass only one of them.`);
        }
        if (component !== undefined && getComponent !== undefined) {
          throw new Error(`Got both 'component' and 'getComponent' props for the screen '${name}'. You must pass only one of them.`);
        }
        if (children != null && typeof children !== 'function') {
          throw new Error(`Got an invalid value for 'children' prop for the screen '${name}'. It must be a function returning a React Element.`);
        }
        if (component !== undefined && !(0, _reactIs.isValidElementType)(component)) {
          throw new Error(`Got an invalid value for 'component' prop for the screen '${name}'. It must be a valid React Component.`);
        }
        if (getComponent !== undefined && typeof getComponent !== 'function') {
          throw new Error(`Got an invalid value for 'getComponent' prop for the screen '${name}'. It must be a function returning a React Component.`);
        }
        if (typeof component === 'function') {
          if (component.name === 'component') {
            // Inline anonymous functions passed in the `component` prop will have the name of the prop
            // It's relatively safe to assume that it's not a component since it should also have PascalCase name
            // We won't catch all scenarios here, but this should catch a good chunk of incorrect use.
            console.warn(`Looks like you're passing an inline function for 'component' prop for the screen '${name}' (e.g. component={() => <SomeComponent />}). Passing an inline function will cause the component state to be lost on re-render and cause perf issues since it's re-created every render. You can pass the function as children to 'Screen' instead to achieve the desired behaviour.`);
          } else if (/^[a-z]/.test(component.name)) {
            console.warn(`Got a component with the name '${component.name}' for the screen '${name}'. React Components must start with an uppercase letter. If you're passing a regular function and not a component, pass it as children to 'Screen' instead. Otherwise capitalize your component's name.`);
          }
        }
      } else {
        throw new Error(`Couldn't find a 'component', 'getComponent' or 'children' prop for the screen '${name}'. This can happen if you passed 'undefined'. You likely forgot to export your component from the file it's defined in, or mixed up default import and named import when importing.`);
      }
    });
  }
  return configs;
};

/**
 * Hook for building navigators.
 *
 * @param createRouter Factory method which returns router object.
 * @param options Options object containing `children` and additional options for the router.
 * @returns An object containing `state`, `navigation`, `descriptors` objects.
 */
function useNavigationBuilder(createRouter, options) {
  const navigatorKey = (0, _useRegisterNavigator.useRegisterNavigator)();
  const route = React.useContext(_NavigationRouteContext.NavigationRouteContext);
  const {
    children,
    layout,
    screenOptions,
    screenLayout,
    screenListeners,
    ...rest
  } = options;
  const routeConfigs = getRouteConfigsFromChildren(children);
  const router = (0, _useLazyValue.useLazyValue)(() => {
    if (rest.initialRouteName != null && routeConfigs.every(config => config.props.name !== rest.initialRouteName)) {
      throw new Error(`Couldn't find a screen named '${rest.initialRouteName}' to use as 'initialRouteName'.`);
    }
    return createRouter(rest);
  });
  const screens = routeConfigs.reduce((acc, config) => {
    if (config.props.name in acc) {
      throw new Error(`A navigator cannot contain multiple 'Screen' components with the same name (found duplicate screen named '${config.props.name}')`);
    }
    acc[config.props.name] = config;
    return acc;
  }, {});
  const routeNames = routeConfigs.map(config => config.props.name);
  const routeKeyList = routeNames.reduce((acc, curr) => {
    acc[curr] = screens[curr].keys.map(key => key ?? '').join(':');
    return acc;
  }, {});
  const routeParamList = routeNames.reduce((acc, curr) => {
    const {
      initialParams
    } = screens[curr].props;
    acc[curr] = initialParams;
    return acc;
  }, {});
  const routeGetIdList = routeNames.reduce((acc, curr) => Object.assign(acc, {
    [curr]: screens[curr].props.getId
  }), {});
  if (!routeNames.length) {
    throw new Error("Couldn't find any screens for the navigator. Have you defined any screens as its children?");
  }
  const isStateValid = React.useCallback(state => state.type === undefined || state.type === router.type, [router.type]);
  const isStateInitialized = React.useCallback(state => state !== undefined && state.stale === false && isStateValid(state), [isStateValid]);
  const {
    state: currentState,
    getState: getCurrentState,
    setState: setCurrentState,
    setKey,
    getKey,
    getIsInitial
  } = React.useContext(_NavigationStateContext.NavigationStateContext);
  const stateCleanedUp = React.useRef(false);
  const setState = (0, _useLatestCallback.default)(state => {
    if (stateCleanedUp.current) {
      // State might have been already cleaned up due to unmount
      // We do not want to expose API allowing to override this
      // This would lead to old data preservation on main navigator unmount
      return;
    }
    setCurrentState(state);
  });
  const [initializedState, isFirstStateInitialization] = React.useMemo(() => {
    const initialRouteParamList = routeNames.reduce((acc, curr) => {
      const {
        initialParams
      } = screens[curr].props;
      const initialParamsFromParams = route?.params?.state == null && route?.params?.initial !== false && route?.params?.screen === curr ? route.params.params : undefined;
      acc[curr] = initialParams !== undefined || initialParamsFromParams !== undefined ? {
        ...initialParams,
        ...initialParamsFromParams
      } : undefined;
      return acc;
    }, {});

    // If the current state isn't initialized on first render, we initialize it
    // We also need to re-initialize it if the state passed from parent was changed (maybe due to reset)
    // Otherwise assume that the state was provided as initial state
    // So we need to rehydrate it to make it usable
    if ((currentState === undefined || !isStateValid(currentState)) && route?.params?.state == null && !(typeof route?.params?.screen === 'string' && route?.params?.initial !== false)) {
      return [router.getInitialState({
        routeNames,
        routeParamList: initialRouteParamList,
        routeGetIdList
      }), true];
    } else {
      let stateFromParams;
      if (route?.params?.state != null) {
        stateFromParams = route.params.state;
      } else if (typeof route?.params?.screen === 'string' && route?.params?.initial !== false) {
        stateFromParams = {
          index: 0,
          routes: [{
            name: route.params.screen,
            params: route.params.params,
            path: route.params.path
          }]
        };
      }
      return [router.getRehydratedState(stateFromParams ?? currentState, {
        routeNames,
        routeParamList: initialRouteParamList,
        routeGetIdList
      }), false];
    }
    // We explicitly don't include routeNames, route.params etc. in the dep list
    // below. We want to avoid forcing a new state to be calculated in those cases
    // Instead, we handle changes to these in the nextState code below. Note
    // that some changes to routeConfigs are explicitly ignored, such as changes
    // to initialParams
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentState, router, isStateValid]);
  const previousRouteKeyListRef = React.useRef(routeKeyList);
  React.useEffect(() => {
    previousRouteKeyListRef.current = routeKeyList;
  });
  const previousRouteKeyList = previousRouteKeyListRef.current;
  let state =
  // If the state isn't initialized, or stale, use the state we initialized instead
  // The state won't update until there's a change needed in the state we have initialized locally
  // So it'll be `undefined` or stale until the first navigation event happens
  isStateInitialized(currentState) ? currentState : initializedState;
  let nextState = state;
  if (!(0, _isArrayEqual.isArrayEqual)(state.routeNames, routeNames) || !(0, _isRecordEqual.isRecordEqual)(routeKeyList, previousRouteKeyList)) {
    const navigatorStateForNextRouteNamesChange = options.UNSTABLE_getStateForRouteNamesChange?.(state);
    // When the list of route names change, the router should handle it to remove invalid routes
    nextState = navigatorStateForNextRouteNamesChange ?
    // @ts-expect-error this is ok
    router.getRehydratedState(navigatorStateForNextRouteNamesChange, {
      routeNames,
      routeParamList,
      routeGetIdList
    }) : router.getStateForRouteNamesChange(state, {
      routeNames,
      routeParamList,
      routeGetIdList,
      routeKeyChanges: Object.keys(routeKeyList).filter(name => name in previousRouteKeyList && routeKeyList[name] !== previousRouteKeyList[name])
    });
  }
  const previousNestedParamsRef = React.useRef(route?.params);
  React.useEffect(() => {
    previousNestedParamsRef.current = route?.params;
  }, [route?.params]);
  if (route?.params) {
    const previousParams = previousNestedParamsRef.current;
    let action;
    if (typeof route.params.state === 'object' && route.params.state != null && route.params !== previousParams) {
      // If the route was updated with new state, we should reset to it
      action = _routers.CommonActions.reset(route.params.state);
    } else if (typeof route.params.screen === 'string' && (route.params.initial === false && isFirstStateInitialization || route.params !== previousParams)) {
      // If the route was updated with new screen name and/or params, we should navigate there
      action = _routers.CommonActions.navigate({
        name: route.params.screen,
        params: route.params.params,
        path: route.params.path
      });
    }

    // The update should be limited to current navigator only, so we call the router manually
    const updatedState = action ? router.getStateForAction(nextState, action, {
      routeNames,
      routeParamList,
      routeGetIdList
    }) : null;
    nextState = updatedState !== null ? router.getRehydratedState(updatedState, {
      routeNames,
      routeParamList,
      routeGetIdList
    }) : nextState;
  }
  const shouldUpdate = state !== nextState;
  (0, _useScheduleUpdate.useScheduleUpdate)(() => {
    if (shouldUpdate) {
      // If the state needs to be updated, we'll schedule an update
      setState(nextState);
    }
  });

  // The up-to-date state will come in next render, but we don't need to wait for it
  // We can't use the outdated state since the screens have changed, which will cause error due to mismatched config
  // So we override the state object we return to use the latest state as soon as possible
  state = nextState;
  React.useEffect(() => {
    // In strict mode, React will double-invoke effects.
    // So we need to reset the flag if component was not unmounted
    stateCleanedUp.current = false;
    setKey(navigatorKey);
    if (!getIsInitial()) {
      // If it's not initial render, we need to update the state
      // This will make sure that our container gets notifier of state changes due to new mounts
      // This is necessary for proper screen tracking, URL updates etc.
      setState(nextState);
    }
    return () => {
      // We need to clean up state for this navigator on unmount
      if (getCurrentState() !== undefined && getKey() === navigatorKey) {
        setCurrentState(undefined);
        stateCleanedUp.current = true;
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // In some cases (e.g. route names change), internal state might have changed
  // But it hasn't been committed yet, so hasn't propagated to the sync external store
  // During this time, we need to return the internal state in `getState`
  // Otherwise it can result in inconsistent state during render in children
  // To avoid this, we use a ref for render phase, and immediately clear it on commit
  const stateRef = React.useRef(state);
  stateRef.current = state;
  (0, _useIsomorphicLayoutEffect.useIsomorphicLayoutEffect)(() => {
    stateRef.current = null;
  });
  const getState = (0, _useLatestCallback.default)(() => {
    const currentState = getCurrentState();
    return (0, _deepFreeze.deepFreeze)(isStateInitialized(currentState) ? currentState : initializedState);
  });
  const emitter = (0, _useEventEmitter.useEventEmitter)(e => {
    const routeNames = [];
    let route;
    if (e.target) {
      route = state.routes.find(route => route.key === e.target);
      if (route?.name) {
        routeNames.push(route.name);
      }
    } else {
      route = state.routes[state.index];
      routeNames.push(...Object.keys(screens).filter(name => route?.name === name));
    }
    if (route == null) {
      return;
    }
    const navigation = descriptors[route.key].navigation;
    const listeners = [].concat(
    // Get an array of listeners for all screens + common listeners on navigator
    ...[screenListeners, ...routeNames.map(name => {
      const {
        listeners
      } = screens[name].props;
      return listeners;
    })].map(listeners => {
      const map = typeof listeners === 'function' ? listeners({
        route: route,
        navigation
      }) : listeners;
      return map ? Object.keys(map).filter(type => type === e.type).map(type => map?.[type]) : undefined;
    }))
    // We don't want same listener to be called multiple times for same event
    // So we remove any duplicate functions from the array
    .filter((cb, i, self) => cb && self.lastIndexOf(cb) === i);
    listeners.forEach(listener => listener?.(e));
  });
  (0, _useFocusEvents.useFocusEvents)({
    state,
    emitter
  });
  React.useEffect(() => {
    emitter.emit({
      type: 'state',
      data: {
        state
      }
    });
  }, [emitter, state]);
  const {
    listeners: childListeners,
    addListener
  } = (0, _useChildListeners.useChildListeners)();
  const {
    keyedListeners,
    addKeyedListener
  } = (0, _useKeyedChildListeners.useKeyedChildListeners)();
  const onAction = (0, _useOnAction.useOnAction)({
    router,
    getState,
    setState,
    key: route?.key,
    actionListeners: childListeners.action,
    beforeRemoveListeners: keyedListeners.beforeRemove,
    routerConfigOptions: {
      routeNames,
      routeParamList,
      routeGetIdList
    },
    emitter
  });
  const onRouteFocus = (0, _useOnRouteFocus.useOnRouteFocus)({
    router,
    key: route?.key,
    getState,
    setState
  });
  const navigation = (0, _useNavigationHelpers.useNavigationHelpers)({
    id: options.id,
    onAction,
    getState,
    emitter,
    router,
    stateRef
  });
  (0, _useFocusedListenersChildrenAdapter.useFocusedListenersChildrenAdapter)({
    navigation,
    focusedListeners: childListeners.focus
  });
  (0, _useOnGetState.useOnGetState)({
    getState,
    getStateListeners: keyedListeners.getState
  });
  const {
    describe,
    descriptors
  } = (0, _useDescriptors.useDescriptors)({
    state,
    screens,
    navigation,
    screenOptions,
    screenLayout,
    onAction,
    getState,
    setState,
    onRouteFocus,
    addListener,
    addKeyedListener,
    router,
    // @ts-expect-error: this should have both core and custom events, but too much work right now
    emitter
  });
  (0, _useCurrentRender.useCurrentRender)({
    state,
    navigation,
    descriptors
  });
  const NavigationContent = (0, _useComponent.useComponent)(children => {
    const element = layout != null ? layout({
      state,
      descriptors,
      navigation,
      children
    }) : children;
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(_NavigationHelpersContext.NavigationHelpersContext.Provider, {
      value: navigation,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_PreventRemoveProvider.PreventRemoveProvider, {
        children: element
      })
    });
  });
  return {
    state,
    navigation,
    describe,
    descriptors,
    NavigationContent
  };
}
//# sourceMappingURL=useNavigationBuilder.js.map