"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindApiItemsMessageId = void 0;
/**
 * Unique identifiers for messages returned as part of `IFindApiItemsResult`.
 * @public
 */
var FindApiItemsMessageId;
(function (FindApiItemsMessageId) {
    /**
     * "Unable to resolve declaration reference within API item ___: ___"
     */
    FindApiItemsMessageId["DeclarationResolutionFailed"] = "declaration-resolution-failed";
    /**
     * "Unable to analyze extends clause ___ of API item ___ because no canonical reference was found."
     */
    FindApiItemsMessageId["ExtendsClauseMissingReference"] = "extends-clause-missing-reference";
    /**
     * "Unable to analyze references of API item ___ because it is not associated with an ApiModel"
     */
    FindApiItemsMessageId["NoAssociatedApiModel"] = "no-associated-api-model";
    /**
     * "Unable to analyze references of API item ___ because it is of unsupported kind ___"
     */
    FindApiItemsMessageId["UnsupportedKind"] = "unsupported-kind";
})(FindApiItemsMessageId || (exports.FindApiItemsMessageId = FindApiItemsMessageId = {}));
//# sourceMappingURL=IFindApiItemsResult.js.map