import { SettingsState } from "../settings/settingsSlice";

const mostUsedTlds = [
  "com",
  "ru",
  "net",
  "org",
  "ir",
  "blogspot.com",
  "in",
  "com.tr",
  "gr",
  "com.au",
  "co.uk",
  "co",
  "io",
  "ca",
  "vn",
  "myshopify.com",
  "info",
  "com.ua",
  "de",
  "fr",
  "xyz",
  "me",
  "jp",
  "by",
  "com.tw",
  "online",
  "tv",
  "com.vn",
  "edu",
  "co.za",
  "co.in",
  "ua",
  "id",
  "co.il",
  "eu",
  "it",
  "kz",
  "biz",
  "us",
  "co.id",
  "pro",
  "ch",
  "com.br",
  "ma",
  "club",
  "co.jp",
  "es",
  "site",
  "github.io",
  "cl",
  "ae",
  "pl",
  "cc",
  "co.kr",
  "nl",
  "pk",
  "ro",
  "su",
  "rs",
  "co.nz",
  "cn",
  "gov.in",
  "app",
  "com.mx",
  "live",
  "com.ar",
  "com.my",
  "se",
  "ai",
  "lk",
  "gov",
  "top",
  "ac.in",
  "ac.id",
  "mx",
  "cz",
  "tw",
  "shop",
  "co.th",
  "org.tr",
  "az",
  "com.pk",
  "news",
  "com.sg",
  "store",
  "be",
  "am",
  "ge",
  "gov.ua",
  "edu.vn",
  "go.id",
  "at",
  "com.np",
  "md",
  "in.ua",
  "tech",
  "com.bd",
  "org.ua",
  "dev",
  "com.cn",
  "uz",
  "my",
  "nic.in",
  "org.uk",
  "to",
  "gov.tr",
  "com.ng",
  "com.hk",
  "go.th",
  "tn",
  "sg",
  "hu",
  "asia",
  "mk",
  "ie",
  "ac.th",
  "pt",
  "dk",
  "gov.bd",
  "tk",
  "pw",
  "herokuapp.com",
  "kr",
  "sa",
  "edu.in",
  "space",
  "co.ke",
  "fun",
  "life",
  "netlify.app",
  "ng",
  "com.co",
  "fi",
  "finance",
  "cloud",
  "link",
  "kiev.ua",
  "gg",
  "media",
  "com.sa",
  "hk",
  "vip",
  "lv",
  "mn",
  "pe",
  "lt",
  "ph",
  "org.au",
  "sch.id",
  "mobi",
  "bel.tr",
  "ac.ir",
  "no",
  "one",
  "blog",
  "website",
  "web.app",
  "ws",
  "fm",
  "today",
  "edu.tr",
  "ee",
  "al",
  "azurewebsites.net",
  "bg",
  "uk",
  "ac.uk",
  "agency",
  "sk",
  "network",
  "dz",
  "firebaseapp.com",
  "hr",
  "kg",
  "edu.pk",
  "net.ua",
  "org.in",
  "gov.np",
  "org.tw",
  "spb.ru",
  "ba",
  "my.id",
  "world",
  "gov.vn",
  "global",
  "ml",
  "com.ph",
  "readthedocs.io",
  "digital",
  "is",
  "in.th",
  "web.id",
  "work",
  "guru",
  "or.id",
  "edu.ua",
  "gov.my",
  "gen.tr",
  "org.il",
  "gov.tw",
  "edu.au",
  "com.pe",
  "gov.au",
  "academy",
  "net.au",
  "ps",
  "icu",
  "edu.cn",
  "gov.pk",
  "or.jp",
  "vc",
  "com.uy",
  "appspot.com",
  "vercel.app",
  "design",
  "xxx",
  "best",
  "ga",
  "gob.mx",
  "si",
  "la",
  "or.kr",
  "cf",
  "name",
  "travel",
  "win",
  "com.eg",
  "com.ec",
  "video",
  "gov.sa",
  "edu.tw",
  "ly",
  "dp.ua",
  "com.gr",
  "qc.ca",
  "pp.ua",
  "im",
  "edu.my",
  "studio",
  "ne.jp",
  "click",
  "edu.np",
  "org.pk",
  "qa",
  "group",
  "gov.cn",
  "gov.gr",
  "aero",
  "center",
  "com.mk",
  "gov.eg",
  "go.kr",
  "plus",
  "host",
  "gov.sg",
  "nz",
  "games",
  "edu.pe",
  "market",
  "gov.ru",
  "gov.co",
  "net.tr",
  "gov.ae",
  "com.do",
  "ltd",
  "or.th",
  "tools",
  "com.ru",
  "wiki",
  "sh",
  "exchange",
  "edu.co",
  "ci",
  "services",
  "edu.ng",
  "solutions",
  "co.zw",
  "gov.az",
  "net.in",
  "team",
  "com.tn",
  "web.tr",
  "net.vn",
  "gc.ca",
  "gob.ec",
  "zp.ua",
  "buzz",
  "mu",
  "bet",
  "zone",
  "gov.uk",
  "go.jp",
  "cam",
  "art",
  "bz",
  "press",
  "ac.jp",
  "com.pl",
  "company",
  "gov.by",
  "ngrok.io",
  "com.ve",
  "cash",
  "ec",
  "gov.ph",
  "expert",
  "od.ua",
  "edu.sa",
  "cyou",
  "gob.pe",
  "gob.ar",
  "gov.hk",
  "edu.ar",
  "withgoogle.com",
  "city",
  "edu.eg",
  "rocks",
  "education",
  "school",
  "nu",
  "av.tr",
  "coop",
  "download",
  "vic.gov.au",
  "lviv.ua",
  "marketing",
  "org.br",
  "edu.bd",
  "chat",
  "li",
  "guide",
  "onrender.com",
  "org.np",
  "gov.lk",
  "lpages.co",
  "so",
  "br",
  "on.ca",
  "money",
  "trade",
  "ac.kr",
  "jo",
  "email",
  "cm",
  "ddns.net",
  "help",
  "social",
  "nyc",
  "org.vn",
  "org.nz",
  "vic.edu.au",
  "jobs",
  "gov.ng",
  "page",
  "js.org",
  "pantheonsite.io",
  "co.ir",
  "com.kw",
  "cat",
  "do",
  "gov.ma",
  "stream",
  "org.za",
  "africa",
  "com.cy",
  "govt.nz",
  "bank",
  "co.tz",
  "org.mx",
  "ninja",
  "co.rs",
  "res.in",
  "cx",
  "go.ke",
  "translate.goog",
  "tj",
  "ag",
  "int",
  "edu.ru",
  "ru.com",
  "gq",
  "if.ua",
  "sn",
  "health",
  "run",
  "tips",
  "moscow",
  "ac",
  "watch",
  "com.gh",
  "works",
  "gov.mn",
  "uno",
  "capital",
  "k12.tr",
  "org.hk",
  "istanbul",
  "co.ua",
  "pub",
  "bio",
  "st",
  "gov.kz",
  "com.bo",
  "co.ug",
  "gob.do",
  "gouv.fr",
  "org.cn",
  "gov.il",
  "com.py",
  "kharkov.ua",
  "gov.jo",
  "msk.ru",
  "qld.gov.au",
  "tl",
  "edu.ec",
  "kr.ua",
  "care",
  "org.ar",
  "workers.dev",
  "yolasite.com",
  "lol",
  "re",
  "gov.ar",
  "red",
  "edu.gr",
  "carrd.co",
  "community",
  "ac.ma",
  "nhs.uk",
  "mil",
  "porn",
  "gov.rs",
  "ink",
  "systems",
  "org.sa",
  "edu.kz",
  "cr",
  "te.ua",
  "lu",
  "com.gt",
  "gov.za",
  "gob.bo",
  "go.tz",
  "monster",
  "go.ug",
  "edu.jo",
  "org.ru",
  "kh.ua",
  "mg",
  "com.kh",
  "casa",
  "cu",
  "ms",
  "gov.kw",
  "tokyo",
  "af",
  "support",
  "edu.ph",
  "land",
  "gov.br",
  "edu.mx",
  "tube",
  "biz.ua",
  "wtf",
  "com.lb",
  "edu.hk",
  "ac.za",
  "edu.az",
  "edu.sg",
  "farm",
  "edu.pl",
  "uk.com",
  "software",
  "rv.ua",
  "eg",
  "tc",
  "moe",
  "com.pa",
  "dn.ua",
  "fund",
  "glitch.me",
  "onl",
  "report",
  "cafe",
  "org.bd",
  "vn.ua",
  "us.com",
  "codes",
  "org.sg",
  "show",
  "bc.ca",
  "ug",
  "ac.il",
  "rw",
  "pl.ua",
  "game",
  "fyi",
  "fit",
  "org.my",
  "gov.om",
  "love",
  "coffee",
  "desa.id",
  "gov.pl",
  "lg.jp",
  "clinic",
  "tel",
  "net.pk",
  "events",
  "now.sh",
  "ghost.io",
  "gov.gh",
  "edu.br",
  "om",
  "cool",
  "style",
  "ks.ua",
  "ac.ke",
  "house",
  "gov.ge",
  "review",
  "ck.ua",
  "mv",
  "altervista.org",
  "ac.lk",
  "gov.tn",
  "km.ua",
  "org.rs",
  "bid",
  "mk.ua",
  "cv.ua",
  "ovh",
  "partners",
  "iq",
  "party",
  "com.mt",
  "bh",
  "edu.lb",
  "sy",
  "gov.dz",
  "hn",
  "ac.nz",
  "k12.ga.us",
  "directory",
  "edu.iq",
  "gov.bt",
  "in.net",
  "sc",
  "googleapis.com",
  "net.tw",
  "sex",
  "surf",
  "ac.bd",
  "bo",
  "pet",
  "ac.ae",
  "wa.gov.au",
  "technology",
  "sa.gov.au",
  "ist",
  "ind.in",
  "gov.rw",
  "net.id",
  "google",
  "com.qa",
  "inc",
  "gob.ve",
  "gov.qa",
  "gob.cl",
  "com.jo",
  "deals",
  "mr",
  "ooo",
  "eu.org",
  "biz.tr",
  "edu.ge",
  "plesk.page",
  "taipei",
  "ventures",
  "domains",
  "gov.ir",
  "org.co",
  "pics",
  "edu.om",
  "law",
  "edu.mn",
  "net.ru",
  "foundation",
  "earth",
  "gov.mk",
  "idv.tw",
  "edu.bo",
  "gallery",
  "reviews",
  "gob.es",
  "kim",
  "institute",
  "gub.uy",
  "nsw.edu.au",
  "pp.ru",
  "sumy.ua",
  "co.ao",
  "org.eg",
  "pm",
  "service.gov.uk",
  "jus.br",
  "training",
  "energy",
  "org.ng",
  "edu.uy",
  "dyndns.org",
  "edu.ps",
  "church",
  "express",
  "ru.net",
  "gratis",
  "co.ma",
  "cards",
  "legal",
  "cd",
  "university",
  "gov.sy",
  "date",
  "k12.in.us",
  "pf",
  "asn.au",
  "delivery",
  "net.cn",
  "sx",
  "canon",
  "co.bw",
  "careers",
  "audio",
  "org.gr",
  "ht",
  "sale",
  "direct",
  "international",
  "info.tr",
  "co.com",
  "com.es",
  "gov.al",
  "k12.wi.us",
  "gov.bn",
  "gov.lb",
  "bj",
  "gov.ps",
  "ao",
  "sp.gov.br",
  "movie",
  "bar",
  "edu.kw",
  "dog",
  "blue",
  "co.zm",
  "wa.edu.au",
  "or.ke",
  "golf",
  "repl.co",
  "gov.kg",
  "london",
  "wine",
  "gov.iq",
  "mil.id",
  "town",
  "how",
  "edu.gh",
  "synology.me",
  "com.na",
  "gov.jm",
  "net.my",
  "casino",
  "eu.com",
  "business",
  "science",
  "name.tr",
  "cheap",
  "lc",
  "ar",
  "pr",
  "pr.gov.br",
  "menu",
  "co.mz",
  "edu.do",
  "gov.lv",
  "ac.ug",
  "gold",
  "info.vn",
  "vision",
  "gov.bh",
  "net.sa",
  "eco",
  "gov.mo",
  "med.sa",
  "ab.ca",
  "bike",
  "org.ir",
  "kherson.ua",
  "edu.mk",
  "lg.ua",
  "edu.rs",
  "pol.tr",
  "gs",
  "film",
  "et",
  "gouv.ci",
  "fan",
  "photos",
  "rest",
  "me.uk",
  "fin.ec",
  "build",
  "ngo",
  "k12.ca.us",
  "gov.et",
  "gov.kh",
  "consulting",
  "k12.fl.us",
  "k12.nj.us",
  "uy",
  "rnu.tn",
  "muni.il",
  "net.bd",
  "gov.mv",
  "cn.ua",
  "odessa.ua",
  "re.kr",
  "financial",
  "rs.gov.br",
  "realtor",
  "co.cr",
  "as",
  "fitness",
  "mt",
  "bot",
  "go.cr",
  "hosting",
  "sa.com",
  "yt",
  "ca.us",
  "bt",
  "coach",
  "tours",
  "catholic.edu.au",
  "org.mk",
  "zt.ua",
  "gov.it",
  "tm",
  "ac.at",
  "tf",
  "com.ni",
  "edu.it",
  "gd",
  "edu.et",
  "com.mo",
  "taxi",
  "camera",
  "engineering",
  "photo",
  "k12.nc.us",
  "sexy",
  "bi",
  "gov.py",
  "clothing",
  "org.pe",
  "vg",
  "investments",
  "men",
  "global.ssl.fastly.net",
  "sbi",
  "tx.us",
  "desi",
  "com.al",
  "gov.tm",
  "eus",
  "githubusercontent.com",
  "net.br",
  "com.bh",
  "scot",
  "ac.rs",
  "ed.jp",
  "paris",
  "insure",
  "sch.ir",
  "parts",
  "nat.tn",
  "toolforge.org",
  "promo",
  "gob.pa",
  "gov.cy",
  "swiss",
  "ac.cy",
  "bm",
  "com.bn",
  "tg",
  "kyiv.ua",
  "url.tw",
  "mba",
  "study",
  "a.run.app",
  "ltd.uk",
  "sa.edu.au",
  "com.kz",
  "mil.ru",
  "ac.zw",
  "gl",
  "nj.us",
  "aws",
  "mn.us",
  "mg.gov.br",
  "immo",
  "gy",
  "gop.pk",
  "vin",
  "black",
  "boutique",
  "na",
  "yoga",
  "rip",
  "je",
  "ac.cr",
  "bf",
  "org.pl",
  "myqnapcloud.com",
  "beer",
  "mw",
  "solar",
  "in.rs",
  "biz.id",
  "org.ph",
  "net.co",
  "photography",
  "k12.ma.us",
  "k12.oh.us",
  "rent",
  "gov.bs",
  "com.de",
  "freedesktop.org",
  "qld.edu.au",
  "uc.r.appspot.com",
  "fashion",
  "estate",
  "tatar",
  "googlecode.com",
  "gitlab.io",
  "smushcdn.com",
  "gos.pk",
  "lutsk.ua",
  "edu.lk",
  "gov.pt",
  "gal",
  "ma.us",
  "ac.cn",
  "fi.cr",
  "com.sv",
  "fans",
  "ac.ru",
  "gr.jp",
  "ad",
  "tax",
  "police.uk",
  "supply",
  "duckdns.org",
  "gov.mg",
  "graphics",
  "org.qa",
  "edu.ly",
  "place",
  "com.dz",
  "mb.ca",
  "radio",
  "com.hn",
  "builders",
  "basketball",
  "haus",
  "ac.tz",
  "org.ma",
  "tt",
  "va.us",
  "members.linode.com",
  "doctor",
  "homeip.net",
  "cricket",
  "cw",
  "gov.mz",
  "net.nz",
  "wi.us",
  "courses",
  "llc",
  "sr",
  "bs",
  "gm",
  "family",
  "com.ge",
  "fish",
  "poltava.ua",
  "rsc.cdn77.org",
  "college",
  "auto",
  "quebec",
  "school.nz",
  "lat",
  "volyn.ua",
  "gv.at",
  "adv.br",
  "pe.gov.br",
  "ga.us",
  "gi",
  "k12.or.us",
  "credit",
  "edu.gt",
  "or.us",
  "camp",
  "tr",
  "edu.ni",
  "shoes",
  "edu.kh",
  "markets",
  "vet",
  "edu.ve",
  "gov.zm",
  "sch.sa",
  "wf",
  "healthcare",
  "edu.sy",
  "yandex",
  "com.jm",
  "com.hr",
  "edunet.tn",
  "cv",
  "co.rw",
  "kitchen",
  "dj",
  "computer",
  "co.sz",
  "coupons",
  "cab",
  "green",
  "org.bo",
  "dental",
  "toys",
  "com.fj",
  "nf",
  "org.do",
  "security",
  "org.gh",
  "net.np",
  "crs",
  "of.by",
  "name.vn",
  "org.tn",
  "pro.vn",
  "mp",
  "sh.cn",
  "ce.gov.br",
  "garden",
  "restaurant",
  "gov.af",
  "net.pl",
  "dating",
  "de.com",
  "rj.gov.br",
  "gt",
  "ba.gov.br",
  "com.et",
  "jp.net",
  "edu.cu",
  "waw.pl",
  "ke",
  "wales",
  "holdings",
  "ipfs.dweb.link",
  "k12.va.us",
  "wpmucdn.com",
  "gov.mm",
  "pink",
  "edu.ba",
  "il.us",
  "sap",
  "edu.ee",
  "edu.bh",
  "nc",
  "forex",
  "th",
  "wa.us",
  "loans",
  "homeoffice.gov.uk",
  "or.tz",
  "k12.mn.us",
  "k12.mo.us",
  "gov.ba",
  "nc.us",
  "abbott",
  "webcam",
  "faith",
  "shopping",
  "limited",
  "jewelry",
  "kiwi",
  "co.tt",
  "com.lk",
  "org.zw",
  "ms.us",
  "auction",
  "krd",
  "football",
  "k12.ia.us",
  "gift",
  "co.ls",
  "gen.in",
  "properties",
  "edu.al",
  "tas.gov.au",
  "cloudaccess.host",
  "tsk.tr",
  "pizza",
  "sport",
  "el.r.appspot.com",
  "net.lb",
  "edu.krd",
  "lawyer",
  "net.gr",
  "uz.ua",
  "org.ve",
  "com.ly",
  "ad.jp",
  "com.mm",
  "bnpparibas",
  "fl.us",
  "gob.gt",
  "edu.qa",
  "ac.be",
  "am.gov.br",
  "sc.gov.br",
  "fo",
  "com.om",
  "es.gov.br",
  "sd",
  "goog",
  "wroc.pl",
  "bw",
  "diet",
  "cg",
  "gov.ie",
  "fail",
  "gov.do",
  "donetsk.ua",
  "gov.ly",
  "loan",
  "com.mv",
  "org.af",
  "krakow.pl",
  "gob.sv",
  "pe.kr",
  "edu.kg",
  "mil.co",
  "futbol",
  "ac.pa",
  "ddnsking.com",
  "com.by",
  "ne",
  "no-ip.net",
  "amsterdam",
  "wmflabs.org",
  "exposed",
  "mi.th",
  "k12.ct.us",
  "gob.ni",
  "ski",
  "museum",
  "rentals",
  "gov.ye",
  "org.kw",
  "cars",
  "sytes.net",
  "org.uy",
  "dreamhosters.com",
  "press.ma",
  "management",
  "org.jo",
  "melbourne",
  "k12.pa.us",
  "k12.wa.us",
  "mom",
  "dnsalias.com",
  "construction",
  "com.ba",
  "asso.fr",
  "org.lb",
  "no-ip.info",
  "org.ec",
  "mt.us",
  "discourse.group",
  "dance",
  "k12.ky.us",
  "equipment",
  "berlin",
  "or.ug",
  "org.bt",
  "moda",
  "cci.fr",
  "mil.my",
  "trading",
  "diamonds",
  "gov.fj",
  "gov.me",
  "cx.ua",
  "spdns.org",
  "mc",
  "gov.zw",
  "mi.us",
  "box",
  "veneto.it",
  "ms.gov.br",
  "piemonte.it",
  "ceo",
  "com.vc",
  "mc.it",
  "pa.gov.br",
  "edu.dz",
  "gov.sd",
  "k12.mi.us",
  "edu.es",
  "ny.us",
  "seoul.kr",
  "jpn.com",
  "saxo",
  "sharp",
  "com.se",
  "com.pg",
  "uw.gov.pl",
  "salon",
  "blog.br",
  "miami",
  "warszawa.pl",
  "recipes",
  "com.az",
  "zgora.pl",
  "edu.af",
  "edu.sv",
  "lublin.pl",
  "lgbt",
  "ltd.ua",
  "ve",
  "mo",
  "net.qa",
  "post",
  "org.kh",
  "edu.py",
  "edu.mo",
  "org.cy",
  "edu.pa",
  "vu",
  "org.mn",
  "abudhabi",
  "shiksha",
  "us.org",
  "org.ly",
  "pharmacy",
  "sk.ca",
  "freetls.fastly.net",
  "zm",
  "co.mw",
  "tur.ar",
  "contact",
  "k12.ny.us",
  "net.ng",
  "net.eg",
  "kep.tr",
  "army",
  "edu.tt",
  "gouv.sn",
  "gov.bb",
  "ac.rw",
  "za.net",
  "glass",
  "za.com",
  "gov.tt",
  "k12.al.us",
  "idf.il",
  "ac.zm",
  "horse",
  "sd.us",
  "org.sz",
  "gifts",
  "forsale",
  "kp",
  "mil.bd",
  "net.il",
  "vegas",
  "realestate",
  "cern",
  "ryd.wafaicloud.com",
  "med.ec",
  "net.ph",
  "repair",
  "ras.ru",
  "mil.ec",
  "leadpages.co",
  "apple",
  "ky",
  "freesite.host",
  "racing",
  "flowers",
  "wedding",
  "ddns.me",
  "edu.me",
  "bbs.tr",
  "com.iq",
  "property",
  "mcdir.ru",
  "cloudfunctions.net",
  "kharkiv.ua",
  "co.me",
  "pictures",
  "outsystemscloud.com",
  "gov.mr",
  "org.kz",
  "coop.np",
  "co.ve",
  "dhl",
  "gle",
  "com.tm",
  "co.us",
  "ltda",
  "va",
  "com.cu",
  "roma.it",
  "lombardia.it",
  "productions",
  "kpmg",
  "coop.br",
  "com.af",
  "sinaapp.com",
  "pa.us",
  "edu.sd",
  "pi.gov.br",
  "net.kw",
  "dynu.net",
  "nb.ca",
  "to.it",
  "lighting",
  "br.com",
  "cq.cn",
  "co.at",
  "org.az",
  "tokyo.jp",
  "rugby",
  "ind.br",
  "softbank",
  "gdn",
  "edu.pt",
  "sl",
  "hs.kr",
  "nv.us",
  "physio",
  "wroclaw.pl",
  "kyoto.jp",
  "cn.com",
  "kanagawa.jp",
  "pa",
  "adult",
  "ct.us",
  "gov.cl",
  "tv.tr",
  "zip",
  "barclays",
  "com.sy",
  "ax",
  "net.ar",
  "mz",
  "nl.ca",
  "mil.kr",
  "poker",
  "gob.hn",
  "archi",
  "org.bw",
  "cloudaccess.net",
  "sa.cr",
  "tienda",
  "com.pr",
  "bloxcms.com",
  "mil.ng",
  "net.za",
  "oh.us",
  "edu.ye",
  "leg.br",
  "ren",
  "singles",
  "gov.gn",
  "ac.fj",
  "edu.la",
  "cymru",
  "sony",
  "org.es",
  "edu.hn",
  "gov.bf",
  "ondigitalocean.app",
  "withyoutube.com",
  "luxe",
  "k12.me.us",
  "us-3.magentosite.cloud",
  "sz",
  "org.zm",
  "nh.us",
  "edu.mt",
  "organic",
  "rodeo",
  "i234.me",
  "cc.ca.us",
  "org.gt",
  "defense.tn",
  "name.ng",
  "bn",
  "co.gy",
  "tennis",
  "lima-city.de",
  "club.tw",
  "eu-central-1.linodeobjects.com",
  "us-5.magentosite.cloud",
  "ac.mu",
  "flights",
  "co.na",
  "ong",
  "bb",
  "country",
  "web.pk",
  "net.pe",
  "claims",
  "teva",
  "baby",
  "wl.r.appspot.com",
  "gov.ck",
  "cba",
  "cy",
  "geek.nz",
  "info.pl",
  "org.ae",
  "gov.la",
  "gov.cm",
  "co.om",
  "cloudapp.net",
  "hopto.org",
  "td",
  "gov.ls",
  "barcelona",
  "mine.nu",
  "me.us",
  "enterprises",
  "co.it",
  "remotewd.com",
  "k12.ms.us",
  "art.br",
  "nsn.us",
  "edu.sl",
  "limo",
  "zapto.org",
  "bible",
  "alwaysdata.net",
  "org.jm",
  "gmbh",
  "ns.ca",
  "gouv.bj",
  "brother",
  "poznan.pl",
  "abc",
  "sci.eg",
  "gov.sc",
  "ki",
  "tm.fr",
  "dyndns.biz",
  "no-ip.org",
  "v.ua",
  "furniture",
  "nov.ru",
  "co.ae",
  "ew.r.appspot.com",
  "bmoattachments.org",
  "pe.ca",
  "com.bz",
  "storage.yandexcloud.net",
  "soy",
  "mygov.bd",
  "rns.tn",
  "crd.co",
  "com.pt",
  "biz.vn",
  "edu.mv",
  "org.fj",
  "vinnica.ua",
  "sarl",
  "biz.pk",
  "spdns.de",
  "vote",
  "org.ge",
  "moi",
  "rovno.ua",
  "rivne.ua",
  "cc.ua",
  "edu.ht",
];

export function cleanSite<
  T extends Pick<
    SettingsState,
    "site" | "removeSubDomain" | "removeTopLevelDomain"
  >,
>(settings: T): T {
  const { site, removeSubDomain, removeTopLevelDomain } = settings;
  if (removeSubDomain === false && removeTopLevelDomain == false)
    return settings;
  try {
    const isIpv4 = /^\d+\.\d+\.\d+\.\d+(?::\d+)?$/.test(site);
    if (isIpv4) {
      return { ...settings, site };
    }
    for (let i = 0; i < mostUsedTlds.length; i++) {
      const tld = mostUsedTlds[i];
      const tldWithDot = `.${tld}`;
      if (site.endsWith(tldWithDot)) {
        const parts = site.replace(tldWithDot, "").split(".");
        const domain = parts.pop() || "";
        const newParts = removeSubDomain
          ? removeTopLevelDomain
            ? [domain]
            : [domain, tld]
          : removeTopLevelDomain
            ? [...parts, domain]
            : [...parts, domain, tld];
        return { ...settings, site: newParts.join(".") };
      }
    }
    return { ...settings, site };
  } catch {
    return { ...settings, site };
  }
}
