"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFocused = useIsFocused;
var React = _interopRequireWildcard(require("react"));
var _useNavigation = require("./useNavigation.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Hook to get the current focus state of the screen. Returns a `true` if screen is focused, otherwise `false`.
 * This can be used if a component needs to render something based on the focus state.
 */
function useIsFocused() {
  const navigation = (0, _useNavigation.useNavigation)();
  const subscribe = React.useCallback(callback => {
    const unsubscribeFocus = navigation.addListener('focus', callback);
    const unsubscribeBlur = navigation.addListener('blur', callback);
    return () => {
      unsubscribeFocus();
      unsubscribeBlur();
    };
  }, [navigation]);
  const value = React.useSyncExternalStore(subscribe, navigation.isFocused, navigation.isFocused);
  return value;
}
//# sourceMappingURL=useIsFocused.js.map