# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-09-24 08:13
from __future__ import unicode_literals

from django.db import migrations

import json

from api import models


def create_password_with(entry):
    settings = json.dumps(entry.password.settings)
    lowercase = "lowercase" in settings
    uppercase = "uppercase" in settings
    symbols = "symbols" in settings
    numbers = "numbers" in settings
    user = models.LessPassUser.objects.get(id=entry.user.id)
    models.Password.objects.create(
        id=entry.id,
        site=entry.site,
        login=entry.login,
        user=user,
        lowercase=lowercase,
        uppercase=uppercase,
        symbols=symbols,
        numbers=numbers,
        counter=entry.password.counter,
        length=entry.password.length,
    )


def mv_entries_to_password(apps, schema_editor):
    Entry = apps.get_model("api", "Entry")
    for entry in Entry.objects.all():
        create_password_with(entry)


class Migration(migrations.Migration):
    dependencies = [
        ("api", "0002_password"),
    ]

    operations = [
        migrations.RunPython(mv_entries_to_password),
    ]
