import type { DefaultRouterOptions, NavigationRoute, NavigationState, ParamListBase, Router } from './types';
export type StackActionType = {
    type: 'REPLACE';
    payload: {
        name: string;
        params?: object;
    };
    source?: string;
    target?: string;
} | {
    type: 'PUSH';
    payload: {
        name: string;
        params?: object;
    };
    source?: string;
    target?: string;
} | {
    type: 'POP';
    payload: {
        count: number;
    };
    source?: string;
    target?: string;
} | {
    type: 'POP_TO_TOP';
    source?: string;
    target?: string;
} | {
    type: 'POP_TO';
    payload: {
        name: string;
        params?: object;
        merge?: boolean;
    };
    source?: string;
    target?: string;
};
export type StackRouterOptions = DefaultRouterOptions;
export type StackNavigationState<ParamList extends ParamListBase> = NavigationState<ParamList> & {
    /**
     * Type of the router, in this case, it's stack.
     */
    type: 'stack';
    /**
     * List of routes, which are supposed to be preloaded before navigating to.
     */
    preloadedRoutes: NavigationRoute<ParamList, keyof ParamList>[];
};
export type StackActionHelpers<ParamList extends ParamListBase> = {
    /**
     * Replace the current route with a new one.
     *
     * @param name Name of the new route.
     * @param [params] Params object for the new route.
     */
    replace<RouteName extends keyof ParamList>(...args: {
        [Screen in keyof ParamList]: undefined extends ParamList[Screen] ? [screen: Screen] | [screen: Screen, params: ParamList[Screen]] : [screen: Screen, params: ParamList[Screen]];
    }[RouteName]): void;
    /**
     * Push a new screen onto the stack.
     *
     * @param name Name of the route to push onto the stack.
     * @param [params] Params object for the route.
     */
    push<RouteName extends keyof ParamList>(...args: {
        [Screen in keyof ParamList]: undefined extends ParamList[Screen] ? [screen: Screen] | [screen: Screen, params: ParamList[Screen]] : [screen: Screen, params: ParamList[Screen]];
    }[RouteName]): void;
    /**
     * Pop a screen from the stack.
     */
    pop(count?: number): void;
    /**
     * Pop to the first route in the stack, dismissing all other screens.
     */
    popToTop(): void;
    /**
     * Pop any screens to go back to the specified screen.
     * If the specified screen doesn't exist, it'll be added to the stack.
     *
     * @param name Name of the route to navigate to.
     * @param [params] Params object for the route.
     * @param [merge] Whether to merge the params onto the route.
     */
    popTo<RouteName extends keyof ParamList>(...args: {
        [Screen in keyof ParamList]: undefined extends ParamList[Screen] ? [screen: Screen] | [screen: Screen, params: ParamList[Screen]] | [screen: Screen, params: ParamList[Screen], merge: boolean] : [screen: Screen, params: ParamList[Screen]] | [screen: Screen, params: ParamList[Screen], merge: boolean];
    }[RouteName]): void;
};
export declare const StackActions: {
    replace(name: string, params?: object): StackActionType;
    push(name: string, params?: object): StackActionType;
    pop(count?: number): StackActionType;
    popToTop(): StackActionType;
    popTo(name: string, params?: object, merge?: boolean): StackActionType;
};
export declare function StackRouter(options: StackRouterOptions): Router<StackNavigationState<ParamListBase>, import("./CommonActions").Action | StackActionType>;
//# sourceMappingURL=StackRouter.d.ts.map