"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreventRemoveProvider = PreventRemoveProvider;
var _nonSecure = require("nanoid/non-secure");
var React = _interopRequireWildcard(require("react"));
var _useLatestCallback = _interopRequireDefault(require("use-latest-callback"));
var _NavigationHelpersContext = require("./NavigationHelpersContext.js");
var _NavigationRouteContext = require("./NavigationRouteContext.js");
var _PreventRemoveContext = require("./PreventRemoveContext.js");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Util function to transform map of prevented routes to a simpler object.
 */
const transformPreventedRoutes = preventedRoutesMap => {
  const preventedRoutesToTransform = [...preventedRoutesMap.values()];
  const preventedRoutes = preventedRoutesToTransform.reduce((acc, {
    routeKey,
    preventRemove
  }) => {
    acc[routeKey] = {
      preventRemove: acc[routeKey]?.preventRemove || preventRemove
    };
    return acc;
  }, {});
  return preventedRoutes;
};

/**
 * Component used for managing which routes have to be prevented from removal in native-stack.
 */
function PreventRemoveProvider({
  children
}) {
  const [parentId] = React.useState(() => (0, _nonSecure.nanoid)());
  const [preventedRoutesMap, setPreventedRoutesMap] = React.useState(new Map());
  const navigation = React.useContext(_NavigationHelpersContext.NavigationHelpersContext);
  const route = React.useContext(_NavigationRouteContext.NavigationRouteContext);
  const preventRemoveContextValue = React.useContext(_PreventRemoveContext.PreventRemoveContext);
  // take `setPreventRemove` from parent context - if exist it means we're in a nested context
  const setParentPrevented = preventRemoveContextValue?.setPreventRemove;
  const setPreventRemove = (0, _useLatestCallback.default)((id, routeKey, preventRemove) => {
    if (preventRemove && (navigation == null || navigation?.getState().routes.every(route => route.key !== routeKey))) {
      throw new Error(`Couldn't find a route with the key ${routeKey}. Is your component inside NavigationContent?`);
    }
    setPreventedRoutesMap(prevPrevented => {
      // values haven't changed - do nothing
      if (routeKey === prevPrevented.get(id)?.routeKey && preventRemove === prevPrevented.get(id)?.preventRemove) {
        return prevPrevented;
      }
      const nextPrevented = new Map(prevPrevented);
      if (preventRemove) {
        nextPrevented.set(id, {
          routeKey,
          preventRemove
        });
      } else {
        nextPrevented.delete(id);
      }
      return nextPrevented;
    });
  });
  const isPrevented = [...preventedRoutesMap.values()].some(({
    preventRemove
  }) => preventRemove);
  React.useEffect(() => {
    if (route?.key !== undefined && setParentPrevented !== undefined) {
      // when route is defined (and setParentPrevented) it means we're in a nested stack
      // route.key then will be the route key of parent
      setParentPrevented(parentId, route.key, isPrevented);
      return () => {
        setParentPrevented(parentId, route.key, false);
      };
    }
    return;
  }, [parentId, isPrevented, route?.key, setParentPrevented]);
  const value = React.useMemo(() => ({
    setPreventRemove,
    preventedRoutes: transformPreventedRoutes(preventedRoutesMap)
  }), [setPreventRemove, preventedRoutesMap]);
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_PreventRemoveContext.PreventRemoveContext.Provider, {
    value: value,
    children: children
  });
}
//# sourceMappingURL=PreventRemoveProvider.js.map