"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Screen = Screen;
var _native = require("@react-navigation/native");
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _Background = require("./Background.js");
var _getDefaultHeaderHeight = require("./Header/getDefaultHeaderHeight.js");
var _HeaderHeightContext = require("./Header/HeaderHeightContext.js");
var _HeaderShownContext = require("./Header/HeaderShownContext.js");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Screen(props) {
  const dimensions = (0, _reactNativeSafeAreaContext.useSafeAreaFrame)();
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const isParentHeaderShown = React.useContext(_HeaderShownContext.HeaderShownContext);
  const parentHeaderHeight = React.useContext(_HeaderHeightContext.HeaderHeightContext);
  const {
    focused,
    modal = false,
    header,
    headerShown = true,
    headerTransparent,
    // eslint-disable-next-line @eslint-react/no-unstable-default-props
    headerStatusBarHeight = isParentHeaderShown ? 0 : insets.top,
    navigation,
    route,
    children,
    style
  } = props;
  const [headerHeight, setHeaderHeight] = React.useState(() => (0, _getDefaultHeaderHeight.getDefaultHeaderHeight)(dimensions, modal, headerStatusBarHeight));
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(_Background.Background, {
    accessibilityElementsHidden: !focused,
    importantForAccessibility: focused ? 'auto' : 'no-hide-descendants',
    style: [styles.container, style]
    // On Fabric we need to disable collapsing for the background to ensure
    // that we won't render unnecessary views due to the view flattening.
    ,
    collapsable: false,
    children: [headerShown ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_native.NavigationContext.Provider, {
      value: navigation,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_native.NavigationRouteContext.Provider, {
        value: route,
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          pointerEvents: "box-none",
          onLayout: e => {
            const {
              height
            } = e.nativeEvent.layout;
            setHeaderHeight(height);
          },
          style: [styles.header, headerTransparent ? styles.absolute : null],
          children: header
        })
      })
    }) : null, /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
      style: styles.content,
      children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_HeaderShownContext.HeaderShownContext.Provider, {
        value: isParentHeaderShown || headerShown !== false,
        children: /*#__PURE__*/(0, _jsxRuntime.jsx)(_HeaderHeightContext.HeaderHeightContext.Provider, {
          value: headerShown ? headerHeight : parentHeaderHeight ?? 0,
          children: children
        })
      })
    })]
  });
}
const styles = _reactNative.StyleSheet.create({
  container: {
    flex: 1
  },
  content: {
    flex: 1
  },
  header: {
    zIndex: 1
  },
  absolute: {
    position: 'absolute',
    top: 0,
    start: 0,
    end: 0
  }
});
//# sourceMappingURL=Screen.js.map