"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldPreventRemove = void 0;
exports.useOnPreventRemove = useOnPreventRemove;
var React = _interopRequireWildcard(require("react"));
var _NavigationBuilderContext = require("./NavigationBuilderContext.js");
var _NavigationRouteContext = require("./NavigationRouteContext.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VISITED_ROUTE_KEYS = Symbol('VISITED_ROUTE_KEYS');
const shouldPreventRemove = (emitter, beforeRemoveListeners, currentRoutes, nextRoutes, action) => {
  const nextRouteKeys = nextRoutes.map(route => route.key);

  // Call these in reverse order so last screens handle the event first
  const removedRoutes = currentRoutes.filter(route => !nextRouteKeys.includes(route.key)).reverse();
  const visitedRouteKeys =
  // @ts-expect-error: add this property to mark that we've already emitted this action
  action[VISITED_ROUTE_KEYS] ?? new Set();
  const beforeRemoveAction = {
    ...action,
    [VISITED_ROUTE_KEYS]: visitedRouteKeys
  };
  for (const route of removedRoutes) {
    if (visitedRouteKeys.has(route.key)) {
      // Skip if we've already emitted this action for this screen
      continue;
    }

    // First, we need to check if any child screens want to prevent it
    const isPrevented = beforeRemoveListeners[route.key]?.(beforeRemoveAction);
    if (isPrevented) {
      return true;
    }
    visitedRouteKeys.add(route.key);
    const event = emitter.emit({
      type: 'beforeRemove',
      target: route.key,
      data: {
        action: beforeRemoveAction
      },
      canPreventDefault: true
    });
    if (event.defaultPrevented) {
      return true;
    }
  }
  return false;
};
exports.shouldPreventRemove = shouldPreventRemove;
function useOnPreventRemove({
  getState,
  emitter,
  beforeRemoveListeners
}) {
  const {
    addKeyedListener
  } = React.useContext(_NavigationBuilderContext.NavigationBuilderContext);
  const route = React.useContext(_NavigationRouteContext.NavigationRouteContext);
  const routeKey = route?.key;
  React.useEffect(() => {
    if (routeKey) {
      return addKeyedListener?.('beforeRemove', routeKey, action => {
        const state = getState();
        return shouldPreventRemove(emitter, beforeRemoveListeners, state.routes, [], action);
      });
    }
  }, [addKeyedListener, beforeRemoveListeners, emitter, getState, routeKey]);
}
//# sourceMappingURL=useOnPreventRemove.js.map