function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import * as React from 'react';
import { Animated, StyleSheet } from 'react-native';
import color from 'color';
import { withInternalTheme } from '../core/theming';
import AnimatedText from './Typography/AnimatedText';
/**
 * Helper text is used in conjuction with input elements to provide additional hints for the user.
 *
 * <div class="screenshots">
 *   <img class="small" src="screenshots/helper-text.gif" />
 * </div>
 *
 * ## Usage
 * ```js
 * import * as React from 'react';
 * import { View } from 'react-native';
 * import { HelperText, TextInput } from 'react-native-paper';
 *
 * const MyComponent = () => {
 *   const [text, setText] = React.useState('');
 *
 *    const onChangeText = text => setText(text);
 *
 *   const hasErrors = () => {
 *     return !text.includes('@');
 *   };
 *
 *  return (
 *     <View>
 *       <TextInput label="Email" value={text} onChangeText={onChangeText} />
 *       <HelperText type="error" visible={hasErrors()}>
 *         Email address is invalid!
 *       </HelperText>
 *     </View>
 *   );
 * };
 *
 * export default MyComponent;
 * ```
 */
const HelperText = _ref => {
  var _theme$colors;
  let {
    style,
    type = 'info',
    visible = true,
    theme,
    onLayout,
    padding = 'normal',
    ...rest
  } = _ref;
  const {
    current: shown
  } = React.useRef(new Animated.Value(visible ? 1 : 0));
  let {
    current: textHeight
  } = React.useRef(0);
  const {
    scale
  } = theme.animation;
  const {
    maxFontSizeMultiplier = 1.5
  } = rest;
  React.useEffect(() => {
    if (visible) {
      // show text
      Animated.timing(shown, {
        toValue: 1,
        duration: 150 * scale,
        useNativeDriver: true
      }).start();
    } else {
      // hide text
      Animated.timing(shown, {
        toValue: 0,
        duration: 180 * scale,
        useNativeDriver: true
      }).start();
    }
  }, [visible, scale, shown]);
  const handleTextLayout = e => {
    onLayout === null || onLayout === void 0 ? void 0 : onLayout(e);
    textHeight = e.nativeEvent.layout.height;
  };
  const {
    colors,
    dark
  } = theme;
  const textColor = type === 'error' ? colors === null || colors === void 0 ? void 0 : colors.error : color(theme.isV3 ? theme.colors.onSurface : theme === null || theme === void 0 ? void 0 : (_theme$colors = theme.colors) === null || _theme$colors === void 0 ? void 0 : _theme$colors.text).alpha(dark ? 0.7 : 0.54).rgb().string();
  return /*#__PURE__*/React.createElement(AnimatedText, _extends({
    onLayout: handleTextLayout,
    style: [styles.text, padding !== 'none' ? styles.padding : {}, {
      color: textColor,
      opacity: shown,
      transform: visible && type === 'error' ? [{
        translateY: shown.interpolate({
          inputRange: [0, 1],
          outputRange: [-textHeight / 2, 0]
        })
      }] : []
    }, style],
    maxFontSizeMultiplier: maxFontSizeMultiplier
  }, rest), rest.children);
};
const styles = StyleSheet.create({
  text: {
    fontSize: 12,
    paddingVertical: 4
  },
  padding: {
    paddingHorizontal: 12
  }
});
export default withInternalTheme(HelperText);
//# sourceMappingURL=HelperText.js.map