function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import * as React from 'react';
import AppbarAction from './AppbarAction';
import AppbarBackIcon from './AppbarBackIcon';
/**
 * A component used to display a back button in the appbar.
 *
 * <div class="screenshots">
 *   <img class="small" src="screenshots/appbar-backaction-android.png" />
 * </div>
 *
 * ## Usage
 * ```js
 * import * as React from 'react';
 * import { Appbar } from 'react-native-paper';
 *
 *
 * const MyComponent = () => (
 *     <Appbar.Header>
 *       <Appbar.BackAction onPress={() => {}} />
 *     </Appbar.Header>
 * );
 *
 * export default MyComponent;
 * ```
 */
const AppbarBackAction = /*#__PURE__*/React.forwardRef((_ref, ref) => {
  let {
    accessibilityLabel = 'Back',
    ...rest
  } = _ref;
  return /*#__PURE__*/React.createElement(AppbarAction, _extends({
    accessibilityLabel: accessibilityLabel
  }, rest, {
    icon: AppbarBackIcon,
    isLeading: true,
    ref: ref
  }));
});
AppbarBackAction.displayName = 'Appbar.BackAction';
export default AppbarBackAction;

// @component-docs ignore-next-line
export { AppbarBackAction };
//# sourceMappingURL=AppbarBackAction.js.map