"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ToggleButtonRow = void 0;
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _ToggleButton = _interopRequireDefault(require("./ToggleButton"));
var _ToggleButtonGroup = _interopRequireDefault(require("./ToggleButtonGroup"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Toggle button row renders a group of toggle buttons in a row.
 *
 * <div class="screenshots">
 *   <figure>
 *     <img class="medium" src="screenshots/toggle-button-row.gif" />
 *   </figure>
 * </div>
 *
 * ## Usage
 * ```js
 * import * as React from 'react';
 * import { ToggleButton } from 'react-native-paper';
 *
 * const MyComponent = () => {
 *   const [value, setValue] = React.useState('left');
 *
 *   return (
 *     <ToggleButton.Row onValueChange={value => setValue(value)} value={value}>
 *       <ToggleButton icon="format-align-left" value="left" />
 *       <ToggleButton icon="format-align-right" value="right" />
 *     </ToggleButton.Row>
 *   );
 * };
 *
 * export default MyComponent;
 *
 *```
 */
const ToggleButtonRow = _ref => {
  let {
    value,
    onValueChange,
    children,
    style
  } = _ref;
  const count = React.Children.count(children);
  return /*#__PURE__*/React.createElement(_ToggleButtonGroup.default, {
    value: value,
    onValueChange: onValueChange
  }, /*#__PURE__*/React.createElement(_reactNative.View, {
    style: [styles.row, style]
  }, React.Children.map(children, (child, i) => {
    // @ts-expect-error: TypeScript complains about child.type but it doesn't matter
    if (child && child.type === _ToggleButton.default) {
      // @ts-expect-error: We're sure that child is a React Element
      return /*#__PURE__*/React.cloneElement(child, {
        style: [styles.button, i === 0 ? styles.first : i === count - 1 ? styles.last : styles.middle,
        // @ts-expect-error: We're sure that child is a React Element
        child.props.style]
      });
    }
    return child;
  })));
};
exports.ToggleButtonRow = ToggleButtonRow;
ToggleButtonRow.displayName = 'ToggleButton.Row';
const styles = _reactNative.StyleSheet.create({
  row: {
    flexDirection: 'row'
  },
  button: {
    borderWidth: _reactNative.StyleSheet.hairlineWidth
  },
  first: {
    borderTopRightRadius: 0,
    borderBottomRightRadius: 0
  },
  middle: {
    borderRadius: 0,
    borderLeftWidth: 0
  },
  last: {
    borderLeftWidth: 0,
    borderTopLeftRadius: 0,
    borderBottomLeftRadius: 0
  }
});
var _default = ToggleButtonRow; // @component-docs ignore-next-line
exports.default = _default;
//# sourceMappingURL=ToggleButtonRow.js.map