import { Platform } from 'react-native';
import { forBottomSheetAndroid, forFadeFromBottomAndroid, forFadeFromCenter as forFadeCard, forHorizontalIOS, forModalPresentationIOS, forRevealFromBottomAndroid, forScaleFromCenterAndroid, forVerticalIOS } from './CardStyleInterpolators';
import { forFade } from './HeaderStyleInterpolators';
import { BottomSheetSlideInSpec, BottomSheetSlideOutSpec, FadeInFromBottomAndroidSpec, FadeOutToBottomAndroidSpec, RevealFromBottomAndroidSpec, ScaleFromCenterAndroidSpec, TransitionIOSSpec } from './TransitionSpecs';
const ANDROID_VERSION_PIE = 28;
const ANDROID_VERSION_10 = 29;

/**
 * Standard iOS navigation transition.
 */
export const SlideFromRightIOS = {
  gestureDirection: 'horizontal',
  transitionSpec: {
    open: TransitionIOSSpec,
    close: TransitionIOSSpec
  },
  cardStyleInterpolator: forHorizontalIOS,
  headerStyleInterpolator: forFade
};

/**
 * Standard iOS navigation transition for modals.
 */
export const ModalSlideFromBottomIOS = {
  gestureDirection: 'vertical',
  transitionSpec: {
    open: TransitionIOSSpec,
    close: TransitionIOSSpec
  },
  cardStyleInterpolator: forVerticalIOS,
  headerStyleInterpolator: forFade
};

/**
 * Standard iOS modal presentation style (introduced in iOS 13).
 */
export const ModalPresentationIOS = {
  gestureDirection: 'vertical',
  transitionSpec: {
    open: TransitionIOSSpec,
    close: TransitionIOSSpec
  },
  cardStyleInterpolator: forModalPresentationIOS,
  headerStyleInterpolator: forFade
};

/**
 * Standard Android navigation transition when opening or closing an Activity on Android < 9 (Oreo).
 */
export const FadeFromBottomAndroid = {
  gestureDirection: 'vertical',
  transitionSpec: {
    open: FadeInFromBottomAndroidSpec,
    close: FadeOutToBottomAndroidSpec
  },
  cardStyleInterpolator: forFadeFromBottomAndroid,
  headerStyleInterpolator: forFade
};

/**
 * Standard Android navigation transition when opening or closing an Activity on Android 9 (Pie).
 */
export const RevealFromBottomAndroid = {
  gestureDirection: 'vertical',
  transitionSpec: {
    open: RevealFromBottomAndroidSpec,
    close: RevealFromBottomAndroidSpec
  },
  cardStyleInterpolator: forRevealFromBottomAndroid,
  headerStyleInterpolator: forFade
};

/**
 * Standard Android navigation transition when opening or closing an Activity on Android 10 (Q).
 */
export const ScaleFromCenterAndroid = {
  gestureDirection: 'horizontal',
  transitionSpec: {
    open: ScaleFromCenterAndroidSpec,
    close: ScaleFromCenterAndroidSpec
  },
  cardStyleInterpolator: forScaleFromCenterAndroid,
  headerStyleInterpolator: forFade
};

/**
 * Standard bottom sheet slide transition for Android 10.
 */
export const BottomSheetAndroid = {
  gestureDirection: 'vertical',
  transitionSpec: {
    open: BottomSheetSlideInSpec,
    close: BottomSheetSlideOutSpec
  },
  cardStyleInterpolator: forBottomSheetAndroid,
  headerStyleInterpolator: forFade
};

/**
 * Fade transition for transparent modals.
 */
export const ModalFadeTransition = {
  gestureDirection: 'vertical',
  transitionSpec: {
    open: BottomSheetSlideInSpec,
    close: BottomSheetSlideOutSpec
  },
  cardStyleInterpolator: forFadeCard,
  headerStyleInterpolator: forFade
};

/**
 * Default navigation transition for the current platform.
 */
export const DefaultTransition = Platform.select({
  ios: SlideFromRightIOS,
  android: Platform.Version >= ANDROID_VERSION_10 ? ScaleFromCenterAndroid : Platform.Version >= ANDROID_VERSION_PIE ? RevealFromBottomAndroid : FadeFromBottomAndroid,
  default: ScaleFromCenterAndroid
});

/**
 * Default modal transition for the current platform.
 */
export const ModalTransition = Platform.select({
  ios: ModalPresentationIOS,
  default: BottomSheetAndroid
});
//# sourceMappingURL=TransitionPresets.js.map