"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _evaluateFunctions = _interopRequireDefault(require("./evaluateFunctions"));

var _evaluateObjectTypeIndexer = _interopRequireDefault(require("./evaluateObjectTypeIndexer"));

var _evaluateObjectTypeProperty = _interopRequireDefault(require("./evaluateObjectTypeProperty"));

var _evaluateTypeCastExpression = _interopRequireDefault(require("./evaluateTypeCastExpression"));

var _evaluateTypical = _interopRequireDefault(require("./evaluateTypical"));

var _evaluateVariables = _interopRequireDefault(require("./evaluateVariables"));

var _reporter = _interopRequireDefault(require("./reporter"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (direction, context, options) => {
  const report = (0, _reporter.default)(direction, context, options);
  return { ...(0, _evaluateFunctions.default)(context, report),
    ClassProperty: (0, _evaluateTypical.default)(context, report, 'class property'),
    PropertyDefinition: (0, _evaluateTypical.default)(context, report, 'class property'),
    ObjectTypeIndexer: (0, _evaluateObjectTypeIndexer.default)(context, report),
    ObjectTypeProperty: (0, _evaluateObjectTypeProperty.default)(context, report),
    TypeCastExpression: (0, _evaluateTypeCastExpression.default)(context, report),
    VariableDeclaration: (0, _evaluateVariables.default)(context, report)
  };
};

exports.default = _default;
module.exports = exports.default;